/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;

@ResourceDef(name="PaymentNotice", profile="http://hl7.org/fhir/Profile/PaymentNotice")
public class PaymentNotice
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business Identifier", formalDefinition="The notice business identifier.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<PaymentNoticeStatus> status;
    @Child(name="request", type={Reference.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Request reference", formalDefinition="Reference of resource for which payment is being made.")
    protected Reference request;
    protected Resource requestTarget;
    @Child(name="response", type={Reference.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Response reference", formalDefinition="Reference of response to resource for which payment is being made.")
    protected Reference response;
    protected Resource responseTarget;
    @Child(name="statusDate", type={DateType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Payment or clearing date", formalDefinition="The date when the above payment action occurrred.")
    protected DateType statusDate;
    @Child(name="created", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Creation date", formalDefinition="The date when this resource was created.")
    protected DateTimeType created;
    @Child(name="target", type={Organization.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Insurer or Regulatory body", formalDefinition="The Insurer who is target  of the request.")
    protected Reference target;
    protected Organization targetTarget;
    @Child(name="provider", type={Practitioner.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Reference provider;
    protected Practitioner providerTarget;
    @Child(name="organization", type={Organization.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible organization", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    protected Reference organization;
    protected Organization organizationTarget;
    @Child(name="paymentStatus", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Whether payment has been sent or cleared", formalDefinition="The payment status, typically paid: payment sent, cleared: payment received.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/payment-status")
    protected CodeableConcept paymentStatus;
    private static final long serialVersionUID = 37278603L;
    @SearchParamDefinition(name="identifier", path="PaymentNotice.identifier", description="The business identifier of the notice", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="request", path="PaymentNotice.request", description="The Claim", type="reference")
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    public static final Include INCLUDE_REQUEST = new Include("PaymentNotice:request").toLocked();
    @SearchParamDefinition(name="provider", path="PaymentNotice.provider", description="The reference to the provider", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class})
    public static final String SP_PROVIDER = "provider";
    public static final ReferenceClientParam PROVIDER = new ReferenceClientParam("provider");
    public static final Include INCLUDE_PROVIDER = new Include("PaymentNotice:provider").toLocked();
    @SearchParamDefinition(name="created", path="PaymentNotice.created", description="Creation date fro the notice", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="response", path="PaymentNotice.response", description="The ClaimResponse", type="reference")
    public static final String SP_RESPONSE = "response";
    public static final ReferenceClientParam RESPONSE = new ReferenceClientParam("response");
    public static final Include INCLUDE_RESPONSE = new Include("PaymentNotice:response").toLocked();
    @SearchParamDefinition(name="organization", path="PaymentNotice.organization", description="The organization who generated this resource", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("PaymentNotice:organization").toLocked();
    @SearchParamDefinition(name="payment-status", path="PaymentNotice.paymentStatus", description="The type of payment notice", type="token")
    public static final String SP_PAYMENT_STATUS = "payment-status";
    public static final TokenClientParam PAYMENT_STATUS = new TokenClientParam("payment-status");
    @SearchParamDefinition(name="statusdate", path="PaymentNotice.statusDate", description="The date of the payment action", type="date")
    public static final String SP_STATUSDATE = "statusdate";
    public static final DateClientParam STATUSDATE = new DateClientParam("statusdate");
    @SearchParamDefinition(name="status", path="PaymentNotice.status", description="The status of the payment notice", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public PaymentNotice setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public PaymentNotice addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<PaymentNoticeStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<PaymentNoticeStatus>(new PaymentNoticeStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public PaymentNotice setStatusElement(Enumeration<PaymentNoticeStatus> value) {
        this.status = value;
        return this;
    }

    public PaymentNoticeStatus getStatus() {
        return this.status == null ? null : (PaymentNoticeStatus)((Object)this.status.getValue());
    }

    public PaymentNotice setStatus(PaymentNoticeStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<PaymentNoticeStatus>(new PaymentNoticeStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public PaymentNotice setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public Resource getRequestTarget() {
        return this.requestTarget;
    }

    public PaymentNotice setRequestTarget(Resource value) {
        this.requestTarget = value;
        return this;
    }

    public Reference getResponse() {
        if (this.response == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.response");
            }
            if (Configuration.doAutoCreate()) {
                this.response = new Reference();
            }
        }
        return this.response;
    }

    public boolean hasResponse() {
        return this.response != null && !this.response.isEmpty();
    }

    public PaymentNotice setResponse(Reference value) {
        this.response = value;
        return this;
    }

    public Resource getResponseTarget() {
        return this.responseTarget;
    }

    public PaymentNotice setResponseTarget(Resource value) {
        this.responseTarget = value;
        return this;
    }

    public DateType getStatusDateElement() {
        if (this.statusDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.statusDate");
            }
            if (Configuration.doAutoCreate()) {
                this.statusDate = new DateType();
            }
        }
        return this.statusDate;
    }

    public boolean hasStatusDateElement() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public boolean hasStatusDate() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public PaymentNotice setStatusDateElement(DateType value) {
        this.statusDate = value;
        return this;
    }

    public Date getStatusDate() {
        return this.statusDate == null ? null : (Date)this.statusDate.getValue();
    }

    public PaymentNotice setStatusDate(Date value) {
        if (value == null) {
            this.statusDate = null;
        } else {
            if (this.statusDate == null) {
                this.statusDate = new DateType();
            }
            this.statusDate.setValue(value);
        }
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public PaymentNotice setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public PaymentNotice setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Reference getTarget() {
        if (this.target == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.target");
            }
            if (Configuration.doAutoCreate()) {
                this.target = new Reference();
            }
        }
        return this.target;
    }

    public boolean hasTarget() {
        return this.target != null && !this.target.isEmpty();
    }

    public PaymentNotice setTarget(Reference value) {
        this.target = value;
        return this;
    }

    public Organization getTargetTarget() {
        if (this.targetTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.target");
            }
            if (Configuration.doAutoCreate()) {
                this.targetTarget = new Organization();
            }
        }
        return this.targetTarget;
    }

    public PaymentNotice setTargetTarget(Organization value) {
        this.targetTarget = value;
        return this;
    }

    public Reference getProvider() {
        if (this.provider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.provider");
            }
            if (Configuration.doAutoCreate()) {
                this.provider = new Reference();
            }
        }
        return this.provider;
    }

    public boolean hasProvider() {
        return this.provider != null && !this.provider.isEmpty();
    }

    public PaymentNotice setProvider(Reference value) {
        this.provider = value;
        return this;
    }

    public Practitioner getProviderTarget() {
        if (this.providerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.provider");
            }
            if (Configuration.doAutoCreate()) {
                this.providerTarget = new Practitioner();
            }
        }
        return this.providerTarget;
    }

    public PaymentNotice setProviderTarget(Practitioner value) {
        this.providerTarget = value;
        return this;
    }

    public Reference getOrganization() {
        if (this.organization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organization = new Reference();
            }
        }
        return this.organization;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public PaymentNotice setOrganization(Reference value) {
        this.organization = value;
        return this;
    }

    public Organization getOrganizationTarget() {
        if (this.organizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organizationTarget = new Organization();
            }
        }
        return this.organizationTarget;
    }

    public PaymentNotice setOrganizationTarget(Organization value) {
        this.organizationTarget = value;
        return this;
    }

    public CodeableConcept getPaymentStatus() {
        if (this.paymentStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.paymentStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentStatus = new CodeableConcept();
            }
        }
        return this.paymentStatus;
    }

    public boolean hasPaymentStatus() {
        return this.paymentStatus != null && !this.paymentStatus.isEmpty();
    }

    public PaymentNotice setPaymentStatus(CodeableConcept value) {
        this.paymentStatus = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The notice business identifier.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property(SP_REQUEST, "Reference(Any)", "Reference of resource for which payment is being made.", 0, 1, this.request));
        children.add(new Property(SP_RESPONSE, "Reference(Any)", "Reference of response to resource for which payment is being made.", 0, 1, this.response));
        children.add(new Property("statusDate", "date", "The date when the above payment action occurrred.", 0, 1, this.statusDate));
        children.add(new Property(SP_CREATED, "dateTime", "The date when this resource was created.", 0, 1, this.created));
        children.add(new Property("target", "Reference(Organization)", "The Insurer who is target  of the request.", 0, 1, this.target));
        children.add(new Property(SP_PROVIDER, "Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.provider));
        children.add(new Property(SP_ORGANIZATION, "Reference(Organization)", "The organization which is responsible for the services rendered to the patient.", 0, 1, this.organization));
        children.add(new Property("paymentStatus", "CodeableConcept", "The payment status, typically paid: payment sent, cleared: payment received.", 0, 1, this.paymentStatus));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The notice business identifier.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case 1095692943: {
                return new Property(SP_REQUEST, "Reference(Any)", "Reference of resource for which payment is being made.", 0, 1, this.request);
            }
            case -340323263: {
                return new Property(SP_RESPONSE, "Reference(Any)", "Reference of response to resource for which payment is being made.", 0, 1, this.response);
            }
            case 247524032: {
                return new Property("statusDate", "date", "The date when the above payment action occurrred.", 0, 1, this.statusDate);
            }
            case 1028554472: {
                return new Property(SP_CREATED, "dateTime", "The date when this resource was created.", 0, 1, this.created);
            }
            case -880905839: {
                return new Property("target", "Reference(Organization)", "The Insurer who is target  of the request.", 0, 1, this.target);
            }
            case -987494927: {
                return new Property(SP_PROVIDER, "Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.provider);
            }
            case 1178922291: {
                return new Property(SP_ORGANIZATION, "Reference(Organization)", "The organization which is responsible for the services rendered to the patient.", 0, 1, this.organization);
            }
            case 1430704536: {
                return new Property("paymentStatus", "CodeableConcept", "The payment status, typically paid: payment sent, cleared: payment received.", 0, 1, this.paymentStatus);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.request;
                }
                return baseArray;
            }
            case -340323263: {
                Base[] baseArray;
                if (this.response == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.response;
                }
                return baseArray;
            }
            case 247524032: {
                Base[] baseArray;
                if (this.statusDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.statusDate;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.created;
                }
                return baseArray;
            }
            case -880905839: {
                Base[] baseArray;
                if (this.target == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.target;
                }
                return baseArray;
            }
            case -987494927: {
                Base[] baseArray;
                if (this.provider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.provider;
                }
                return baseArray;
            }
            case 1178922291: {
                Base[] baseArray;
                if (this.organization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.organization;
                }
                return baseArray;
            }
            case 1430704536: {
                Base[] baseArray;
                if (this.paymentStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.paymentStatus;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new PaymentNoticeStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 1095692943: {
                this.request = this.castToReference(value);
                return value;
            }
            case -340323263: {
                this.response = this.castToReference(value);
                return value;
            }
            case 247524032: {
                this.statusDate = this.castToDate(value);
                return value;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                return value;
            }
            case -880905839: {
                this.target = this.castToReference(value);
                return value;
            }
            case -987494927: {
                this.provider = this.castToReference(value);
                return value;
            }
            case 1178922291: {
                this.organization = this.castToReference(value);
                return value;
            }
            case 1430704536: {
                this.paymentStatus = this.castToCodeableConcept(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new PaymentNoticeStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_REQUEST)) {
            this.request = this.castToReference(value);
        } else if (name.equals(SP_RESPONSE)) {
            this.response = this.castToReference(value);
        } else if (name.equals("statusDate")) {
            this.statusDate = this.castToDate(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals("target")) {
            this.target = this.castToReference(value);
        } else if (name.equals(SP_PROVIDER)) {
            this.provider = this.castToReference(value);
        } else if (name.equals(SP_ORGANIZATION)) {
            this.organization = this.castToReference(value);
        } else if (name.equals("paymentStatus")) {
            this.paymentStatus = this.castToCodeableConcept(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1095692943: {
                return this.getRequest();
            }
            case -340323263: {
                return this.getResponse();
            }
            case 247524032: {
                return this.getStatusDateElement();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case -880905839: {
                return this.getTarget();
            }
            case -987494927: {
                return this.getProvider();
            }
            case 1178922291: {
                return this.getOrganization();
            }
            case 1430704536: {
                return this.getPaymentStatus();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 1095692943: {
                return new String[]{"Reference"};
            }
            case -340323263: {
                return new String[]{"Reference"};
            }
            case 247524032: {
                return new String[]{"date"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case -880905839: {
                return new String[]{"Reference"};
            }
            case -987494927: {
                return new String[]{"Reference"};
            }
            case 1178922291: {
                return new String[]{"Reference"};
            }
            case 1430704536: {
                return new String[]{"CodeableConcept"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentNotice.status");
        }
        if (name.equals(SP_REQUEST)) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals(SP_RESPONSE)) {
            this.response = new Reference();
            return this.response;
        }
        if (name.equals("statusDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentNotice.statusDate");
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentNotice.created");
        }
        if (name.equals("target")) {
            this.target = new Reference();
            return this.target;
        }
        if (name.equals(SP_PROVIDER)) {
            this.provider = new Reference();
            return this.provider;
        }
        if (name.equals(SP_ORGANIZATION)) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals("paymentStatus")) {
            this.paymentStatus = new CodeableConcept();
            return this.paymentStatus;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PaymentNotice";
    }

    @Override
    public PaymentNotice copy() {
        PaymentNotice dst = new PaymentNotice();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier i : this.identifier) {
                dst.identifier.add(i.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.request = this.request == null ? null : this.request.copy();
        dst.response = this.response == null ? null : this.response.copy();
        dst.statusDate = this.statusDate == null ? null : this.statusDate.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.target = this.target == null ? null : this.target.copy();
        dst.provider = this.provider == null ? null : this.provider.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        dst.paymentStatus = this.paymentStatus == null ? null : this.paymentStatus.copy();
        return dst;
    }

    protected PaymentNotice typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof PaymentNotice)) {
            return false;
        }
        PaymentNotice o = (PaymentNotice)other;
        return PaymentNotice.compareDeep(this.identifier, o.identifier, true) && PaymentNotice.compareDeep(this.status, o.status, true) && PaymentNotice.compareDeep(this.request, o.request, true) && PaymentNotice.compareDeep(this.response, o.response, true) && PaymentNotice.compareDeep(this.statusDate, o.statusDate, true) && PaymentNotice.compareDeep(this.created, o.created, true) && PaymentNotice.compareDeep(this.target, o.target, true) && PaymentNotice.compareDeep(this.provider, o.provider, true) && PaymentNotice.compareDeep(this.organization, o.organization, true) && PaymentNotice.compareDeep(this.paymentStatus, o.paymentStatus, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof PaymentNotice)) {
            return false;
        }
        PaymentNotice o = (PaymentNotice)other;
        return PaymentNotice.compareValues(this.status, o.status, true) && PaymentNotice.compareValues(this.statusDate, o.statusDate, true) && PaymentNotice.compareValues(this.created, o.created, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.request, this.response, this.statusDate, this.created, this.target, this.provider, this.organization, this.paymentStatus});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.PaymentNotice;
    }

    public static class PaymentNoticeStatusEnumFactory
    implements EnumFactory<PaymentNoticeStatus> {
        @Override
        public PaymentNoticeStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return PaymentNoticeStatus.ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return PaymentNoticeStatus.CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return PaymentNoticeStatus.DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return PaymentNoticeStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown PaymentNoticeStatus code '" + codeString + "'");
        }

        public Enumeration<PaymentNoticeStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<PaymentNoticeStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<PaymentNoticeStatus>(this, PaymentNoticeStatus.ACTIVE);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<PaymentNoticeStatus>(this, PaymentNoticeStatus.CANCELLED);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<PaymentNoticeStatus>(this, PaymentNoticeStatus.DRAFT);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<PaymentNoticeStatus>(this, PaymentNoticeStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown PaymentNoticeStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(PaymentNoticeStatus code) {
            if (code == PaymentNoticeStatus.ACTIVE) {
                return "active";
            }
            if (code == PaymentNoticeStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == PaymentNoticeStatus.DRAFT) {
                return "draft";
            }
            if (code == PaymentNoticeStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(PaymentNoticeStatus code) {
            return code.getSystem();
        }
    }

    public static enum PaymentNoticeStatus {
        ACTIVE,
        CANCELLED,
        DRAFT,
        ENTEREDINERROR,
        NULL;


        public static PaymentNoticeStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown PaymentNoticeStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DRAFT: {
                    return "draft";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/fm-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The instance is currently in-force.";
                }
                case CANCELLED: {
                    return "The instance is withdrawn, rescinded or reversed.";
                }
                case DRAFT: {
                    return "A new instance the contents of which is not complete.";
                }
                case ENTEREDINERROR: {
                    return "The instance was entered in error.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DRAFT: {
                    return "Draft";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }
}

