/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.SimpleQuantity;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Substance;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="SpecimenDefinition", profile="http://hl7.org/fhir/Profile/SpecimenDefinition")
public class SpecimenDefinition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier of a kind of specimen", formalDefinition="A business identifier associated with the kind of specimen.")
    protected Identifier identifier;
    @Child(name="typeCollected", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of material to collect", formalDefinition="The kind of material to be collected.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/v2-0487")
    protected CodeableConcept typeCollected;
    @Child(name="patientPreparation", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Patient preparation for collection", formalDefinition="Preparation of the patient for specimen collection.")
    protected StringType patientPreparation;
    @Child(name="timeAspect", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time aspect for collection", formalDefinition="Time aspect of specimen collection (duration or offset).")
    protected StringType timeAspect;
    @Child(name="collection", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specimen collection procedure", formalDefinition="The action to be performed for collecting the specimen.")
    protected List<CodeableConcept> collection;
    @Child(name="specimenToLab", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Specimen in container intended for testing by lab", formalDefinition="Specimen conditioned in a container as expected by the testing laboratory.")
    protected List<SpecimenDefinitionSpecimenToLabComponent> specimenToLab;
    private static final long serialVersionUID = -2007444482L;
    @SearchParamDefinition(name="container", path="SpecimenDefinition.specimenToLab.containerType", description="The type of specimen conditioned in container expected by the lab", type="token")
    public static final String SP_CONTAINER = "container";
    public static final TokenClientParam CONTAINER = new TokenClientParam("container");
    @SearchParamDefinition(name="identifier", path="SpecimenDefinition.identifier", description="The unique identifier associated with the specimen", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="type", path="SpecimenDefinition.typeCollected", description="The type of collected specimen", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public SpecimenDefinition setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public CodeableConcept getTypeCollected() {
        if (this.typeCollected == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.typeCollected");
            }
            if (Configuration.doAutoCreate()) {
                this.typeCollected = new CodeableConcept();
            }
        }
        return this.typeCollected;
    }

    public boolean hasTypeCollected() {
        return this.typeCollected != null && !this.typeCollected.isEmpty();
    }

    public SpecimenDefinition setTypeCollected(CodeableConcept value) {
        this.typeCollected = value;
        return this;
    }

    public StringType getPatientPreparationElement() {
        if (this.patientPreparation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.patientPreparation");
            }
            if (Configuration.doAutoCreate()) {
                this.patientPreparation = new StringType();
            }
        }
        return this.patientPreparation;
    }

    public boolean hasPatientPreparationElement() {
        return this.patientPreparation != null && !this.patientPreparation.isEmpty();
    }

    public boolean hasPatientPreparation() {
        return this.patientPreparation != null && !this.patientPreparation.isEmpty();
    }

    public SpecimenDefinition setPatientPreparationElement(StringType value) {
        this.patientPreparation = value;
        return this;
    }

    public String getPatientPreparation() {
        return this.patientPreparation == null ? null : (String)this.patientPreparation.getValue();
    }

    public SpecimenDefinition setPatientPreparation(String value) {
        if (Utilities.noString((String)value)) {
            this.patientPreparation = null;
        } else {
            if (this.patientPreparation == null) {
                this.patientPreparation = new StringType();
            }
            this.patientPreparation.setValue(value);
        }
        return this;
    }

    public StringType getTimeAspectElement() {
        if (this.timeAspect == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.timeAspect");
            }
            if (Configuration.doAutoCreate()) {
                this.timeAspect = new StringType();
            }
        }
        return this.timeAspect;
    }

    public boolean hasTimeAspectElement() {
        return this.timeAspect != null && !this.timeAspect.isEmpty();
    }

    public boolean hasTimeAspect() {
        return this.timeAspect != null && !this.timeAspect.isEmpty();
    }

    public SpecimenDefinition setTimeAspectElement(StringType value) {
        this.timeAspect = value;
        return this;
    }

    public String getTimeAspect() {
        return this.timeAspect == null ? null : (String)this.timeAspect.getValue();
    }

    public SpecimenDefinition setTimeAspect(String value) {
        if (Utilities.noString((String)value)) {
            this.timeAspect = null;
        } else {
            if (this.timeAspect == null) {
                this.timeAspect = new StringType();
            }
            this.timeAspect.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getCollection() {
        if (this.collection == null) {
            this.collection = new ArrayList<CodeableConcept>();
        }
        return this.collection;
    }

    public SpecimenDefinition setCollection(List<CodeableConcept> theCollection) {
        this.collection = theCollection;
        return this;
    }

    public boolean hasCollection() {
        if (this.collection == null) {
            return false;
        }
        for (CodeableConcept item : this.collection) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCollection() {
        CodeableConcept t = new CodeableConcept();
        if (this.collection == null) {
            this.collection = new ArrayList<CodeableConcept>();
        }
        this.collection.add(t);
        return t;
    }

    public SpecimenDefinition addCollection(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.collection == null) {
            this.collection = new ArrayList<CodeableConcept>();
        }
        this.collection.add(t);
        return this;
    }

    public CodeableConcept getCollectionFirstRep() {
        if (this.getCollection().isEmpty()) {
            this.addCollection();
        }
        return this.getCollection().get(0);
    }

    public List<SpecimenDefinitionSpecimenToLabComponent> getSpecimenToLab() {
        if (this.specimenToLab == null) {
            this.specimenToLab = new ArrayList<SpecimenDefinitionSpecimenToLabComponent>();
        }
        return this.specimenToLab;
    }

    public SpecimenDefinition setSpecimenToLab(List<SpecimenDefinitionSpecimenToLabComponent> theSpecimenToLab) {
        this.specimenToLab = theSpecimenToLab;
        return this;
    }

    public boolean hasSpecimenToLab() {
        if (this.specimenToLab == null) {
            return false;
        }
        for (SpecimenDefinitionSpecimenToLabComponent item : this.specimenToLab) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SpecimenDefinitionSpecimenToLabComponent addSpecimenToLab() {
        SpecimenDefinitionSpecimenToLabComponent t = new SpecimenDefinitionSpecimenToLabComponent();
        if (this.specimenToLab == null) {
            this.specimenToLab = new ArrayList<SpecimenDefinitionSpecimenToLabComponent>();
        }
        this.specimenToLab.add(t);
        return t;
    }

    public SpecimenDefinition addSpecimenToLab(SpecimenDefinitionSpecimenToLabComponent t) {
        if (t == null) {
            return this;
        }
        if (this.specimenToLab == null) {
            this.specimenToLab = new ArrayList<SpecimenDefinitionSpecimenToLabComponent>();
        }
        this.specimenToLab.add(t);
        return this;
    }

    public SpecimenDefinitionSpecimenToLabComponent getSpecimenToLabFirstRep() {
        if (this.getSpecimenToLab().isEmpty()) {
            this.addSpecimenToLab();
        }
        return this.getSpecimenToLab().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A business identifier associated with the kind of specimen.", 0, 1, this.identifier));
        children.add(new Property("typeCollected", "CodeableConcept", "The kind of material to be collected.", 0, 1, this.typeCollected));
        children.add(new Property("patientPreparation", "string", "Preparation of the patient for specimen collection.", 0, 1, this.patientPreparation));
        children.add(new Property("timeAspect", "string", "Time aspect of specimen collection (duration or offset).", 0, 1, this.timeAspect));
        children.add(new Property("collection", "CodeableConcept", "The action to be performed for collecting the specimen.", 0, Integer.MAX_VALUE, this.collection));
        children.add(new Property("specimenToLab", "", "Specimen conditioned in a container as expected by the testing laboratory.", 0, Integer.MAX_VALUE, this.specimenToLab));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A business identifier associated with the kind of specimen.", 0, 1, this.identifier);
            }
            case 588504367: {
                return new Property("typeCollected", "CodeableConcept", "The kind of material to be collected.", 0, 1, this.typeCollected);
            }
            case -879411630: {
                return new Property("patientPreparation", "string", "Preparation of the patient for specimen collection.", 0, 1, this.patientPreparation);
            }
            case 276972933: {
                return new Property("timeAspect", "string", "Time aspect of specimen collection (duration or offset).", 0, 1, this.timeAspect);
            }
            case -1741312354: {
                return new Property("collection", "CodeableConcept", "The action to be performed for collecting the specimen.", 0, Integer.MAX_VALUE, this.collection);
            }
            case 1669658346: {
                return new Property("specimenToLab", "", "Specimen conditioned in a container as expected by the testing laboratory.", 0, Integer.MAX_VALUE, this.specimenToLab);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 588504367: {
                Base[] baseArray;
                if (this.typeCollected == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.typeCollected;
                }
                return baseArray;
            }
            case -879411630: {
                Base[] baseArray;
                if (this.patientPreparation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.patientPreparation;
                }
                return baseArray;
            }
            case 276972933: {
                Base[] baseArray;
                if (this.timeAspect == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.timeAspect;
                }
                return baseArray;
            }
            case -1741312354: {
                return this.collection == null ? new Base[]{} : this.collection.toArray(new Base[this.collection.size()]);
            }
            case 1669658346: {
                return this.specimenToLab == null ? new Base[]{} : this.specimenToLab.toArray(new Base[this.specimenToLab.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 588504367: {
                this.typeCollected = this.castToCodeableConcept(value);
                return value;
            }
            case -879411630: {
                this.patientPreparation = this.castToString(value);
                return value;
            }
            case 276972933: {
                this.timeAspect = this.castToString(value);
                return value;
            }
            case -1741312354: {
                this.getCollection().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1669658346: {
                this.getSpecimenToLab().add((SpecimenDefinitionSpecimenToLabComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("typeCollected")) {
            this.typeCollected = this.castToCodeableConcept(value);
        } else if (name.equals("patientPreparation")) {
            this.patientPreparation = this.castToString(value);
        } else if (name.equals("timeAspect")) {
            this.timeAspect = this.castToString(value);
        } else if (name.equals("collection")) {
            this.getCollection().add(this.castToCodeableConcept(value));
        } else if (name.equals("specimenToLab")) {
            this.getSpecimenToLab().add((SpecimenDefinitionSpecimenToLabComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 588504367: {
                return this.getTypeCollected();
            }
            case -879411630: {
                return this.getPatientPreparationElement();
            }
            case 276972933: {
                return this.getTimeAspectElement();
            }
            case -1741312354: {
                return this.addCollection();
            }
            case 1669658346: {
                return this.addSpecimenToLab();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 588504367: {
                return new String[]{"CodeableConcept"};
            }
            case -879411630: {
                return new String[]{"string"};
            }
            case 276972933: {
                return new String[]{"string"};
            }
            case -1741312354: {
                return new String[]{"CodeableConcept"};
            }
            case 1669658346: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("typeCollected")) {
            this.typeCollected = new CodeableConcept();
            return this.typeCollected;
        }
        if (name.equals("patientPreparation")) {
            throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.patientPreparation");
        }
        if (name.equals("timeAspect")) {
            throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.timeAspect");
        }
        if (name.equals("collection")) {
            return this.addCollection();
        }
        if (name.equals("specimenToLab")) {
            return this.addSpecimenToLab();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SpecimenDefinition";
    }

    @Override
    public SpecimenDefinition copy() {
        SpecimenDefinition dst = new SpecimenDefinition();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.typeCollected = this.typeCollected == null ? null : this.typeCollected.copy();
        dst.patientPreparation = this.patientPreparation == null ? null : this.patientPreparation.copy();
        StringType stringType = dst.timeAspect = this.timeAspect == null ? null : this.timeAspect.copy();
        if (this.collection != null) {
            dst.collection = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.collection) {
                dst.collection.add(codeableConcept.copy());
            }
        }
        if (this.specimenToLab != null) {
            dst.specimenToLab = new ArrayList<SpecimenDefinitionSpecimenToLabComponent>();
            for (SpecimenDefinitionSpecimenToLabComponent specimenDefinitionSpecimenToLabComponent : this.specimenToLab) {
                dst.specimenToLab.add(specimenDefinitionSpecimenToLabComponent.copy());
            }
        }
        return dst;
    }

    protected SpecimenDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof SpecimenDefinition)) {
            return false;
        }
        SpecimenDefinition o = (SpecimenDefinition)other;
        return SpecimenDefinition.compareDeep(this.identifier, o.identifier, true) && SpecimenDefinition.compareDeep(this.typeCollected, o.typeCollected, true) && SpecimenDefinition.compareDeep(this.patientPreparation, o.patientPreparation, true) && SpecimenDefinition.compareDeep(this.timeAspect, o.timeAspect, true) && SpecimenDefinition.compareDeep(this.collection, o.collection, true) && SpecimenDefinition.compareDeep(this.specimenToLab, o.specimenToLab, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof SpecimenDefinition)) {
            return false;
        }
        SpecimenDefinition o = (SpecimenDefinition)other;
        return SpecimenDefinition.compareValues(this.patientPreparation, o.patientPreparation, true) && SpecimenDefinition.compareValues(this.timeAspect, o.timeAspect, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.typeCollected, this.patientPreparation, this.timeAspect, this.collection, this.specimenToLab});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SpecimenDefinition;
    }

    @Block
    public static class SpecimenDefinitionSpecimenToLabHandlingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="conditionSet", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Conservation condition set", formalDefinition="Code representing the set of handling instructions.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/handling-condition")
        protected CodeableConcept conditionSet;
        @Child(name="tempRange", type={Range.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Temperature range", formalDefinition="The temperature interval for this set of handling instructions.")
        protected Range tempRange;
        @Child(name="maxDuration", type={Duration.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Maximum conservation time", formalDefinition="The maximum time interval of conservation of the specimen with these conditions.")
        protected Duration maxDuration;
        @Child(name="lightExposure", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Light exposure", formalDefinition="Textual instructions regarding the light exposure of the specimen prior testing.")
        protected StringType lightExposure;
        @Child(name="instruction", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Conservation instruction", formalDefinition="Additional textual instructions for the conservation or transport of the specimen.")
        protected StringType instruction;
        private static final long serialVersionUID = 1577777957L;

        public CodeableConcept getConditionSet() {
            if (this.conditionSet == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionSpecimenToLabHandlingComponent.conditionSet");
                }
                if (Configuration.doAutoCreate()) {
                    this.conditionSet = new CodeableConcept();
                }
            }
            return this.conditionSet;
        }

        public boolean hasConditionSet() {
            return this.conditionSet != null && !this.conditionSet.isEmpty();
        }

        public SpecimenDefinitionSpecimenToLabHandlingComponent setConditionSet(CodeableConcept value) {
            this.conditionSet = value;
            return this;
        }

        public Range getTempRange() {
            if (this.tempRange == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionSpecimenToLabHandlingComponent.tempRange");
                }
                if (Configuration.doAutoCreate()) {
                    this.tempRange = new Range();
                }
            }
            return this.tempRange;
        }

        public boolean hasTempRange() {
            return this.tempRange != null && !this.tempRange.isEmpty();
        }

        public SpecimenDefinitionSpecimenToLabHandlingComponent setTempRange(Range value) {
            this.tempRange = value;
            return this;
        }

        public Duration getMaxDuration() {
            if (this.maxDuration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionSpecimenToLabHandlingComponent.maxDuration");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxDuration = new Duration();
                }
            }
            return this.maxDuration;
        }

        public boolean hasMaxDuration() {
            return this.maxDuration != null && !this.maxDuration.isEmpty();
        }

        public SpecimenDefinitionSpecimenToLabHandlingComponent setMaxDuration(Duration value) {
            this.maxDuration = value;
            return this;
        }

        public StringType getLightExposureElement() {
            if (this.lightExposure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionSpecimenToLabHandlingComponent.lightExposure");
                }
                if (Configuration.doAutoCreate()) {
                    this.lightExposure = new StringType();
                }
            }
            return this.lightExposure;
        }

        public boolean hasLightExposureElement() {
            return this.lightExposure != null && !this.lightExposure.isEmpty();
        }

        public boolean hasLightExposure() {
            return this.lightExposure != null && !this.lightExposure.isEmpty();
        }

        public SpecimenDefinitionSpecimenToLabHandlingComponent setLightExposureElement(StringType value) {
            this.lightExposure = value;
            return this;
        }

        public String getLightExposure() {
            return this.lightExposure == null ? null : (String)this.lightExposure.getValue();
        }

        public SpecimenDefinitionSpecimenToLabHandlingComponent setLightExposure(String value) {
            if (Utilities.noString((String)value)) {
                this.lightExposure = null;
            } else {
                if (this.lightExposure == null) {
                    this.lightExposure = new StringType();
                }
                this.lightExposure.setValue(value);
            }
            return this;
        }

        public StringType getInstructionElement() {
            if (this.instruction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionSpecimenToLabHandlingComponent.instruction");
                }
                if (Configuration.doAutoCreate()) {
                    this.instruction = new StringType();
                }
            }
            return this.instruction;
        }

        public boolean hasInstructionElement() {
            return this.instruction != null && !this.instruction.isEmpty();
        }

        public boolean hasInstruction() {
            return this.instruction != null && !this.instruction.isEmpty();
        }

        public SpecimenDefinitionSpecimenToLabHandlingComponent setInstructionElement(StringType value) {
            this.instruction = value;
            return this;
        }

        public String getInstruction() {
            return this.instruction == null ? null : (String)this.instruction.getValue();
        }

        public SpecimenDefinitionSpecimenToLabHandlingComponent setInstruction(String value) {
            if (Utilities.noString((String)value)) {
                this.instruction = null;
            } else {
                if (this.instruction == null) {
                    this.instruction = new StringType();
                }
                this.instruction.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("conditionSet", "CodeableConcept", "Code representing the set of handling instructions.", 0, 1, this.conditionSet));
            children.add(new Property("tempRange", "Range", "The temperature interval for this set of handling instructions.", 0, 1, this.tempRange));
            children.add(new Property("maxDuration", "Duration", "The maximum time interval of conservation of the specimen with these conditions.", 0, 1, this.maxDuration));
            children.add(new Property("lightExposure", "string", "Textual instructions regarding the light exposure of the specimen prior testing.", 0, 1, this.lightExposure));
            children.add(new Property("instruction", "string", "Additional textual instructions for the conservation or transport of the specimen.", 0, 1, this.instruction));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1202651833: {
                    return new Property("conditionSet", "CodeableConcept", "Code representing the set of handling instructions.", 0, 1, this.conditionSet);
                }
                case 1957710281: {
                    return new Property("tempRange", "Range", "The temperature interval for this set of handling instructions.", 0, 1, this.tempRange);
                }
                case 40284952: {
                    return new Property("maxDuration", "Duration", "The maximum time interval of conservation of the specimen with these conditions.", 0, 1, this.maxDuration);
                }
                case -1391615939: {
                    return new Property("lightExposure", "string", "Textual instructions regarding the light exposure of the specimen prior testing.", 0, 1, this.lightExposure);
                }
                case 301526158: {
                    return new Property("instruction", "string", "Additional textual instructions for the conservation or transport of the specimen.", 0, 1, this.instruction);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1202651833: {
                    Base[] baseArray;
                    if (this.conditionSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.conditionSet;
                    }
                    return baseArray;
                }
                case 1957710281: {
                    Base[] baseArray;
                    if (this.tempRange == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.tempRange;
                    }
                    return baseArray;
                }
                case 40284952: {
                    Base[] baseArray;
                    if (this.maxDuration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.maxDuration;
                    }
                    return baseArray;
                }
                case -1391615939: {
                    Base[] baseArray;
                    if (this.lightExposure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.lightExposure;
                    }
                    return baseArray;
                }
                case 301526158: {
                    Base[] baseArray;
                    if (this.instruction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.instruction;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1202651833: {
                    this.conditionSet = this.castToCodeableConcept(value);
                    return value;
                }
                case 1957710281: {
                    this.tempRange = this.castToRange(value);
                    return value;
                }
                case 40284952: {
                    this.maxDuration = this.castToDuration(value);
                    return value;
                }
                case -1391615939: {
                    this.lightExposure = this.castToString(value);
                    return value;
                }
                case 301526158: {
                    this.instruction = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("conditionSet")) {
                this.conditionSet = this.castToCodeableConcept(value);
            } else if (name.equals("tempRange")) {
                this.tempRange = this.castToRange(value);
            } else if (name.equals("maxDuration")) {
                this.maxDuration = this.castToDuration(value);
            } else if (name.equals("lightExposure")) {
                this.lightExposure = this.castToString(value);
            } else if (name.equals("instruction")) {
                this.instruction = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1202651833: {
                    return this.getConditionSet();
                }
                case 1957710281: {
                    return this.getTempRange();
                }
                case 40284952: {
                    return this.getMaxDuration();
                }
                case -1391615939: {
                    return this.getLightExposureElement();
                }
                case 301526158: {
                    return this.getInstructionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1202651833: {
                    return new String[]{"CodeableConcept"};
                }
                case 1957710281: {
                    return new String[]{"Range"};
                }
                case 40284952: {
                    return new String[]{"Duration"};
                }
                case -1391615939: {
                    return new String[]{"string"};
                }
                case 301526158: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("conditionSet")) {
                this.conditionSet = new CodeableConcept();
                return this.conditionSet;
            }
            if (name.equals("tempRange")) {
                this.tempRange = new Range();
                return this.tempRange;
            }
            if (name.equals("maxDuration")) {
                this.maxDuration = new Duration();
                return this.maxDuration;
            }
            if (name.equals("lightExposure")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.lightExposure");
            }
            if (name.equals("instruction")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.instruction");
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenDefinitionSpecimenToLabHandlingComponent copy() {
            SpecimenDefinitionSpecimenToLabHandlingComponent dst = new SpecimenDefinitionSpecimenToLabHandlingComponent();
            this.copyValues(dst);
            dst.conditionSet = this.conditionSet == null ? null : this.conditionSet.copy();
            dst.tempRange = this.tempRange == null ? null : this.tempRange.copy();
            dst.maxDuration = this.maxDuration == null ? null : this.maxDuration.copy();
            dst.lightExposure = this.lightExposure == null ? null : this.lightExposure.copy();
            dst.instruction = this.instruction == null ? null : this.instruction.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SpecimenDefinitionSpecimenToLabHandlingComponent)) {
                return false;
            }
            SpecimenDefinitionSpecimenToLabHandlingComponent o = (SpecimenDefinitionSpecimenToLabHandlingComponent)other;
            return SpecimenDefinitionSpecimenToLabHandlingComponent.compareDeep(this.conditionSet, o.conditionSet, true) && SpecimenDefinitionSpecimenToLabHandlingComponent.compareDeep(this.tempRange, o.tempRange, true) && SpecimenDefinitionSpecimenToLabHandlingComponent.compareDeep(this.maxDuration, o.maxDuration, true) && SpecimenDefinitionSpecimenToLabHandlingComponent.compareDeep(this.lightExposure, o.lightExposure, true) && SpecimenDefinitionSpecimenToLabHandlingComponent.compareDeep(this.instruction, o.instruction, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SpecimenDefinitionSpecimenToLabHandlingComponent)) {
                return false;
            }
            SpecimenDefinitionSpecimenToLabHandlingComponent o = (SpecimenDefinitionSpecimenToLabHandlingComponent)other;
            return SpecimenDefinitionSpecimenToLabHandlingComponent.compareValues(this.lightExposure, o.lightExposure, true) && SpecimenDefinitionSpecimenToLabHandlingComponent.compareValues(this.instruction, o.instruction, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.conditionSet, this.tempRange, this.maxDuration, this.lightExposure, this.instruction});
        }

        @Override
        public String fhirType() {
            return "SpecimenDefinition.specimenToLab.handling";
        }
    }

    @Block
    public static class SpecimenDefinitionSpecimenToLabContainerAdditiveComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="additive", type={CodeableConcept.class, Substance.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additive associated with container", formalDefinition="Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/v2-0371")
        protected Type additive;
        private static final long serialVersionUID = 1819209272L;

        public SpecimenDefinitionSpecimenToLabContainerAdditiveComponent() {
        }

        public SpecimenDefinitionSpecimenToLabContainerAdditiveComponent(Type additive) {
            this.additive = additive;
        }

        public Type getAdditive() {
            return this.additive;
        }

        public CodeableConcept getAdditiveCodeableConcept() throws FHIRException {
            if (!(this.additive instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.additive.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.additive;
        }

        public boolean hasAdditiveCodeableConcept() {
            return this.additive instanceof CodeableConcept;
        }

        public Reference getAdditiveReference() throws FHIRException {
            if (!(this.additive instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.additive.getClass().getName() + " was encountered");
            }
            return (Reference)this.additive;
        }

        public boolean hasAdditiveReference() {
            return this.additive instanceof Reference;
        }

        public boolean hasAdditive() {
            return this.additive != null && !this.additive.isEmpty();
        }

        public SpecimenDefinitionSpecimenToLabContainerAdditiveComponent setAdditive(Type value) {
            this.additive = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("additive[x]", "CodeableConcept|Reference(Substance)", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 261915956: {
                    return new Property("additive[x]", "CodeableConcept|Reference(Substance)", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive);
                }
                case -1226589236: {
                    return new Property("additive[x]", "CodeableConcept|Reference(Substance)", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive);
                }
                case 1330272821: {
                    return new Property("additive[x]", "CodeableConcept|Reference(Substance)", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive);
                }
                case -386783009: {
                    return new Property("additive[x]", "CodeableConcept|Reference(Substance)", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1226589236: {
                    Base[] baseArray;
                    if (this.additive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.additive;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1226589236: {
                    this.additive = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("additive[x]")) {
                return super.setProperty(name, value);
            }
            this.additive = this.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 261915956: {
                    return this.getAdditive();
                }
                case -1226589236: {
                    return this.getAdditive();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1226589236: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("additiveCodeableConcept")) {
                this.additive = new CodeableConcept();
                return this.additive;
            }
            if (name.equals("additiveReference")) {
                this.additive = new Reference();
                return this.additive;
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenDefinitionSpecimenToLabContainerAdditiveComponent copy() {
            SpecimenDefinitionSpecimenToLabContainerAdditiveComponent dst = new SpecimenDefinitionSpecimenToLabContainerAdditiveComponent();
            this.copyValues(dst);
            dst.additive = this.additive == null ? null : this.additive.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SpecimenDefinitionSpecimenToLabContainerAdditiveComponent)) {
                return false;
            }
            SpecimenDefinitionSpecimenToLabContainerAdditiveComponent o = (SpecimenDefinitionSpecimenToLabContainerAdditiveComponent)other;
            return SpecimenDefinitionSpecimenToLabContainerAdditiveComponent.compareDeep(this.additive, o.additive, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SpecimenDefinitionSpecimenToLabContainerAdditiveComponent)) {
                return false;
            }
            SpecimenDefinitionSpecimenToLabContainerAdditiveComponent o = (SpecimenDefinitionSpecimenToLabContainerAdditiveComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.additive});
        }

        @Override
        public String fhirType() {
            return "SpecimenDefinition.specimenToLab.containerAdditive";
        }
    }

    @Block
    public static class SpecimenDefinitionSpecimenToLabComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="isDerived", type={BooleanType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Primary or secondary specimen", formalDefinition="Primary of secondary specimen.")
        protected BooleanType isDerived;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of intended specimen", formalDefinition="The kind of specimen conditioned for testing expected by lab.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/v2-0487")
        protected CodeableConcept type;
        @Child(name="preference", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="preferred | alternate", formalDefinition="The preference for this type of conditioned specimen.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/specimen-contained-preference")
        protected Enumeration<SpecimenContainedPreference> preference;
        @Child(name="containerMaterial", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Container material", formalDefinition="The type of material of the container.")
        protected CodeableConcept containerMaterial;
        @Child(name="containerType", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Kind of container associated with the kind of specimen", formalDefinition="The type of container used to contain this kind of specimen.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/specimen-container-type")
        protected CodeableConcept containerType;
        @Child(name="containerCap", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Color of container cap", formalDefinition="Color of container cap.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/container-cap")
        protected CodeableConcept containerCap;
        @Child(name="containerDescription", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Container description", formalDefinition="The textual description of the kind of container.")
        protected StringType containerDescription;
        @Child(name="containerCapacity", type={SimpleQuantity.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Container capacity", formalDefinition="The capacity (volume or other measure) of this kind of container.")
        protected SimpleQuantity containerCapacity;
        @Child(name="containerMinimumVolume", type={SimpleQuantity.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Minimum volume", formalDefinition="The minimum volume to be conditioned in the container.")
        protected SimpleQuantity containerMinimumVolume;
        @Child(name="containerAdditive", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additive associated with container", formalDefinition="Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.")
        protected List<SpecimenDefinitionSpecimenToLabContainerAdditiveComponent> containerAdditive;
        @Child(name="containerPreparation", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specimen container preparation", formalDefinition="Special processing that should be applied to the container for this kind of specimen.")
        protected StringType containerPreparation;
        @Child(name="requirement", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specimen requirements", formalDefinition="Requirements for delivery and special handling of this kind of conditioned specimen.")
        protected StringType requirement;
        @Child(name="retentionTime", type={Duration.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specimen retention time", formalDefinition="The usual time that a specimen of this kind is retained after the ordered tests are completed, for the purpose of additional testing.")
        protected Duration retentionTime;
        @Child(name="rejectionCriterion", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Rejection criterion", formalDefinition="Criterion for rejection of the specimen in its container by the laboratory.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/rejection-criteria")
        protected List<CodeableConcept> rejectionCriterion;
        @Child(name="handling", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specimen handling before testing", formalDefinition="Set of instructions for conservation/transport of the specimen at a defined temperature interval, prior the testing process.")
        protected List<SpecimenDefinitionSpecimenToLabHandlingComponent> handling;
        private static final long serialVersionUID = -239351274L;

        public SpecimenDefinitionSpecimenToLabComponent() {
        }

        public SpecimenDefinitionSpecimenToLabComponent(BooleanType isDerived, Enumeration<SpecimenContainedPreference> preference) {
            this.isDerived = isDerived;
            this.preference = preference;
        }

        public BooleanType getIsDerivedElement() {
            if (this.isDerived == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionSpecimenToLabComponent.isDerived");
                }
                if (Configuration.doAutoCreate()) {
                    this.isDerived = new BooleanType();
                }
            }
            return this.isDerived;
        }

        public boolean hasIsDerivedElement() {
            return this.isDerived != null && !this.isDerived.isEmpty();
        }

        public boolean hasIsDerived() {
            return this.isDerived != null && !this.isDerived.isEmpty();
        }

        public SpecimenDefinitionSpecimenToLabComponent setIsDerivedElement(BooleanType value) {
            this.isDerived = value;
            return this;
        }

        public boolean getIsDerived() {
            return this.isDerived == null || this.isDerived.isEmpty() ? false : (Boolean)this.isDerived.getValue();
        }

        public SpecimenDefinitionSpecimenToLabComponent setIsDerived(boolean value) {
            if (this.isDerived == null) {
                this.isDerived = new BooleanType();
            }
            this.isDerived.setValue((Object)value);
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionSpecimenToLabComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SpecimenDefinitionSpecimenToLabComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Enumeration<SpecimenContainedPreference> getPreferenceElement() {
            if (this.preference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionSpecimenToLabComponent.preference");
                }
                if (Configuration.doAutoCreate()) {
                    this.preference = new Enumeration<SpecimenContainedPreference>(new SpecimenContainedPreferenceEnumFactory());
                }
            }
            return this.preference;
        }

        public boolean hasPreferenceElement() {
            return this.preference != null && !this.preference.isEmpty();
        }

        public boolean hasPreference() {
            return this.preference != null && !this.preference.isEmpty();
        }

        public SpecimenDefinitionSpecimenToLabComponent setPreferenceElement(Enumeration<SpecimenContainedPreference> value) {
            this.preference = value;
            return this;
        }

        public SpecimenContainedPreference getPreference() {
            return this.preference == null ? null : (SpecimenContainedPreference)((Object)this.preference.getValue());
        }

        public SpecimenDefinitionSpecimenToLabComponent setPreference(SpecimenContainedPreference value) {
            if (this.preference == null) {
                this.preference = new Enumeration<SpecimenContainedPreference>(new SpecimenContainedPreferenceEnumFactory());
            }
            this.preference.setValue((Object)value);
            return this;
        }

        public CodeableConcept getContainerMaterial() {
            if (this.containerMaterial == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionSpecimenToLabComponent.containerMaterial");
                }
                if (Configuration.doAutoCreate()) {
                    this.containerMaterial = new CodeableConcept();
                }
            }
            return this.containerMaterial;
        }

        public boolean hasContainerMaterial() {
            return this.containerMaterial != null && !this.containerMaterial.isEmpty();
        }

        public SpecimenDefinitionSpecimenToLabComponent setContainerMaterial(CodeableConcept value) {
            this.containerMaterial = value;
            return this;
        }

        public CodeableConcept getContainerType() {
            if (this.containerType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionSpecimenToLabComponent.containerType");
                }
                if (Configuration.doAutoCreate()) {
                    this.containerType = new CodeableConcept();
                }
            }
            return this.containerType;
        }

        public boolean hasContainerType() {
            return this.containerType != null && !this.containerType.isEmpty();
        }

        public SpecimenDefinitionSpecimenToLabComponent setContainerType(CodeableConcept value) {
            this.containerType = value;
            return this;
        }

        public CodeableConcept getContainerCap() {
            if (this.containerCap == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionSpecimenToLabComponent.containerCap");
                }
                if (Configuration.doAutoCreate()) {
                    this.containerCap = new CodeableConcept();
                }
            }
            return this.containerCap;
        }

        public boolean hasContainerCap() {
            return this.containerCap != null && !this.containerCap.isEmpty();
        }

        public SpecimenDefinitionSpecimenToLabComponent setContainerCap(CodeableConcept value) {
            this.containerCap = value;
            return this;
        }

        public StringType getContainerDescriptionElement() {
            if (this.containerDescription == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionSpecimenToLabComponent.containerDescription");
                }
                if (Configuration.doAutoCreate()) {
                    this.containerDescription = new StringType();
                }
            }
            return this.containerDescription;
        }

        public boolean hasContainerDescriptionElement() {
            return this.containerDescription != null && !this.containerDescription.isEmpty();
        }

        public boolean hasContainerDescription() {
            return this.containerDescription != null && !this.containerDescription.isEmpty();
        }

        public SpecimenDefinitionSpecimenToLabComponent setContainerDescriptionElement(StringType value) {
            this.containerDescription = value;
            return this;
        }

        public String getContainerDescription() {
            return this.containerDescription == null ? null : (String)this.containerDescription.getValue();
        }

        public SpecimenDefinitionSpecimenToLabComponent setContainerDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.containerDescription = null;
            } else {
                if (this.containerDescription == null) {
                    this.containerDescription = new StringType();
                }
                this.containerDescription.setValue(value);
            }
            return this;
        }

        public SimpleQuantity getContainerCapacity() {
            if (this.containerCapacity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionSpecimenToLabComponent.containerCapacity");
                }
                if (Configuration.doAutoCreate()) {
                    this.containerCapacity = new SimpleQuantity();
                }
            }
            return this.containerCapacity;
        }

        public boolean hasContainerCapacity() {
            return this.containerCapacity != null && !this.containerCapacity.isEmpty();
        }

        public SpecimenDefinitionSpecimenToLabComponent setContainerCapacity(SimpleQuantity value) {
            this.containerCapacity = value;
            return this;
        }

        public SimpleQuantity getContainerMinimumVolume() {
            if (this.containerMinimumVolume == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionSpecimenToLabComponent.containerMinimumVolume");
                }
                if (Configuration.doAutoCreate()) {
                    this.containerMinimumVolume = new SimpleQuantity();
                }
            }
            return this.containerMinimumVolume;
        }

        public boolean hasContainerMinimumVolume() {
            return this.containerMinimumVolume != null && !this.containerMinimumVolume.isEmpty();
        }

        public SpecimenDefinitionSpecimenToLabComponent setContainerMinimumVolume(SimpleQuantity value) {
            this.containerMinimumVolume = value;
            return this;
        }

        public List<SpecimenDefinitionSpecimenToLabContainerAdditiveComponent> getContainerAdditive() {
            if (this.containerAdditive == null) {
                this.containerAdditive = new ArrayList<SpecimenDefinitionSpecimenToLabContainerAdditiveComponent>();
            }
            return this.containerAdditive;
        }

        public SpecimenDefinitionSpecimenToLabComponent setContainerAdditive(List<SpecimenDefinitionSpecimenToLabContainerAdditiveComponent> theContainerAdditive) {
            this.containerAdditive = theContainerAdditive;
            return this;
        }

        public boolean hasContainerAdditive() {
            if (this.containerAdditive == null) {
                return false;
            }
            for (SpecimenDefinitionSpecimenToLabContainerAdditiveComponent item : this.containerAdditive) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SpecimenDefinitionSpecimenToLabContainerAdditiveComponent addContainerAdditive() {
            SpecimenDefinitionSpecimenToLabContainerAdditiveComponent t = new SpecimenDefinitionSpecimenToLabContainerAdditiveComponent();
            if (this.containerAdditive == null) {
                this.containerAdditive = new ArrayList<SpecimenDefinitionSpecimenToLabContainerAdditiveComponent>();
            }
            this.containerAdditive.add(t);
            return t;
        }

        public SpecimenDefinitionSpecimenToLabComponent addContainerAdditive(SpecimenDefinitionSpecimenToLabContainerAdditiveComponent t) {
            if (t == null) {
                return this;
            }
            if (this.containerAdditive == null) {
                this.containerAdditive = new ArrayList<SpecimenDefinitionSpecimenToLabContainerAdditiveComponent>();
            }
            this.containerAdditive.add(t);
            return this;
        }

        public SpecimenDefinitionSpecimenToLabContainerAdditiveComponent getContainerAdditiveFirstRep() {
            if (this.getContainerAdditive().isEmpty()) {
                this.addContainerAdditive();
            }
            return this.getContainerAdditive().get(0);
        }

        public StringType getContainerPreparationElement() {
            if (this.containerPreparation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionSpecimenToLabComponent.containerPreparation");
                }
                if (Configuration.doAutoCreate()) {
                    this.containerPreparation = new StringType();
                }
            }
            return this.containerPreparation;
        }

        public boolean hasContainerPreparationElement() {
            return this.containerPreparation != null && !this.containerPreparation.isEmpty();
        }

        public boolean hasContainerPreparation() {
            return this.containerPreparation != null && !this.containerPreparation.isEmpty();
        }

        public SpecimenDefinitionSpecimenToLabComponent setContainerPreparationElement(StringType value) {
            this.containerPreparation = value;
            return this;
        }

        public String getContainerPreparation() {
            return this.containerPreparation == null ? null : (String)this.containerPreparation.getValue();
        }

        public SpecimenDefinitionSpecimenToLabComponent setContainerPreparation(String value) {
            if (Utilities.noString((String)value)) {
                this.containerPreparation = null;
            } else {
                if (this.containerPreparation == null) {
                    this.containerPreparation = new StringType();
                }
                this.containerPreparation.setValue(value);
            }
            return this;
        }

        public StringType getRequirementElement() {
            if (this.requirement == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionSpecimenToLabComponent.requirement");
                }
                if (Configuration.doAutoCreate()) {
                    this.requirement = new StringType();
                }
            }
            return this.requirement;
        }

        public boolean hasRequirementElement() {
            return this.requirement != null && !this.requirement.isEmpty();
        }

        public boolean hasRequirement() {
            return this.requirement != null && !this.requirement.isEmpty();
        }

        public SpecimenDefinitionSpecimenToLabComponent setRequirementElement(StringType value) {
            this.requirement = value;
            return this;
        }

        public String getRequirement() {
            return this.requirement == null ? null : (String)this.requirement.getValue();
        }

        public SpecimenDefinitionSpecimenToLabComponent setRequirement(String value) {
            if (Utilities.noString((String)value)) {
                this.requirement = null;
            } else {
                if (this.requirement == null) {
                    this.requirement = new StringType();
                }
                this.requirement.setValue(value);
            }
            return this;
        }

        public Duration getRetentionTime() {
            if (this.retentionTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionSpecimenToLabComponent.retentionTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.retentionTime = new Duration();
                }
            }
            return this.retentionTime;
        }

        public boolean hasRetentionTime() {
            return this.retentionTime != null && !this.retentionTime.isEmpty();
        }

        public SpecimenDefinitionSpecimenToLabComponent setRetentionTime(Duration value) {
            this.retentionTime = value;
            return this;
        }

        public List<CodeableConcept> getRejectionCriterion() {
            if (this.rejectionCriterion == null) {
                this.rejectionCriterion = new ArrayList<CodeableConcept>();
            }
            return this.rejectionCriterion;
        }

        public SpecimenDefinitionSpecimenToLabComponent setRejectionCriterion(List<CodeableConcept> theRejectionCriterion) {
            this.rejectionCriterion = theRejectionCriterion;
            return this;
        }

        public boolean hasRejectionCriterion() {
            if (this.rejectionCriterion == null) {
                return false;
            }
            for (CodeableConcept item : this.rejectionCriterion) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRejectionCriterion() {
            CodeableConcept t = new CodeableConcept();
            if (this.rejectionCriterion == null) {
                this.rejectionCriterion = new ArrayList<CodeableConcept>();
            }
            this.rejectionCriterion.add(t);
            return t;
        }

        public SpecimenDefinitionSpecimenToLabComponent addRejectionCriterion(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.rejectionCriterion == null) {
                this.rejectionCriterion = new ArrayList<CodeableConcept>();
            }
            this.rejectionCriterion.add(t);
            return this;
        }

        public CodeableConcept getRejectionCriterionFirstRep() {
            if (this.getRejectionCriterion().isEmpty()) {
                this.addRejectionCriterion();
            }
            return this.getRejectionCriterion().get(0);
        }

        public List<SpecimenDefinitionSpecimenToLabHandlingComponent> getHandling() {
            if (this.handling == null) {
                this.handling = new ArrayList<SpecimenDefinitionSpecimenToLabHandlingComponent>();
            }
            return this.handling;
        }

        public SpecimenDefinitionSpecimenToLabComponent setHandling(List<SpecimenDefinitionSpecimenToLabHandlingComponent> theHandling) {
            this.handling = theHandling;
            return this;
        }

        public boolean hasHandling() {
            if (this.handling == null) {
                return false;
            }
            for (SpecimenDefinitionSpecimenToLabHandlingComponent item : this.handling) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SpecimenDefinitionSpecimenToLabHandlingComponent addHandling() {
            SpecimenDefinitionSpecimenToLabHandlingComponent t = new SpecimenDefinitionSpecimenToLabHandlingComponent();
            if (this.handling == null) {
                this.handling = new ArrayList<SpecimenDefinitionSpecimenToLabHandlingComponent>();
            }
            this.handling.add(t);
            return t;
        }

        public SpecimenDefinitionSpecimenToLabComponent addHandling(SpecimenDefinitionSpecimenToLabHandlingComponent t) {
            if (t == null) {
                return this;
            }
            if (this.handling == null) {
                this.handling = new ArrayList<SpecimenDefinitionSpecimenToLabHandlingComponent>();
            }
            this.handling.add(t);
            return this;
        }

        public SpecimenDefinitionSpecimenToLabHandlingComponent getHandlingFirstRep() {
            if (this.getHandling().isEmpty()) {
                this.addHandling();
            }
            return this.getHandling().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("isDerived", "boolean", "Primary of secondary specimen.", 0, 1, this.isDerived));
            children.add(new Property(SpecimenDefinition.SP_TYPE, "CodeableConcept", "The kind of specimen conditioned for testing expected by lab.", 0, 1, this.type));
            children.add(new Property("preference", "code", "The preference for this type of conditioned specimen.", 0, 1, this.preference));
            children.add(new Property("containerMaterial", "CodeableConcept", "The type of material of the container.", 0, 1, this.containerMaterial));
            children.add(new Property("containerType", "CodeableConcept", "The type of container used to contain this kind of specimen.", 0, 1, this.containerType));
            children.add(new Property("containerCap", "CodeableConcept", "Color of container cap.", 0, 1, this.containerCap));
            children.add(new Property("containerDescription", "string", "The textual description of the kind of container.", 0, 1, this.containerDescription));
            children.add(new Property("containerCapacity", "SimpleQuantity", "The capacity (volume or other measure) of this kind of container.", 0, 1, this.containerCapacity));
            children.add(new Property("containerMinimumVolume", "SimpleQuantity", "The minimum volume to be conditioned in the container.", 0, 1, this.containerMinimumVolume));
            children.add(new Property("containerAdditive", "", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, Integer.MAX_VALUE, this.containerAdditive));
            children.add(new Property("containerPreparation", "string", "Special processing that should be applied to the container for this kind of specimen.", 0, 1, this.containerPreparation));
            children.add(new Property("requirement", "string", "Requirements for delivery and special handling of this kind of conditioned specimen.", 0, 1, this.requirement));
            children.add(new Property("retentionTime", "Duration", "The usual time that a specimen of this kind is retained after the ordered tests are completed, for the purpose of additional testing.", 0, 1, this.retentionTime));
            children.add(new Property("rejectionCriterion", "CodeableConcept", "Criterion for rejection of the specimen in its container by the laboratory.", 0, Integer.MAX_VALUE, this.rejectionCriterion));
            children.add(new Property("handling", "", "Set of instructions for conservation/transport of the specimen at a defined temperature interval, prior the testing process.", 0, Integer.MAX_VALUE, this.handling));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 976346515: {
                    return new Property("isDerived", "boolean", "Primary of secondary specimen.", 0, 1, this.isDerived);
                }
                case 3575610: {
                    return new Property(SpecimenDefinition.SP_TYPE, "CodeableConcept", "The kind of specimen conditioned for testing expected by lab.", 0, 1, this.type);
                }
                case -1459831589: {
                    return new Property("preference", "code", "The preference for this type of conditioned specimen.", 0, 1, this.preference);
                }
                case -207682360: {
                    return new Property("containerMaterial", "CodeableConcept", "The type of material of the container.", 0, 1, this.containerMaterial);
                }
                case 1966942043: {
                    return new Property("containerType", "CodeableConcept", "The type of container used to contain this kind of specimen.", 0, 1, this.containerType);
                }
                case 2141642641: {
                    return new Property("containerCap", "CodeableConcept", "Color of container cap.", 0, 1, this.containerCap);
                }
                case -1474644805: {
                    return new Property("containerDescription", "string", "The textual description of the kind of container.", 0, 1, this.containerDescription);
                }
                case -574573477: {
                    return new Property("containerCapacity", "SimpleQuantity", "The capacity (volume or other measure) of this kind of container.", 0, 1, this.containerCapacity);
                }
                case -2037735993: {
                    return new Property("containerMinimumVolume", "SimpleQuantity", "The minimum volume to be conditioned in the container.", 0, 1, this.containerMinimumVolume);
                }
                case -1733338259: {
                    return new Property("containerAdditive", "", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, Integer.MAX_VALUE, this.containerAdditive);
                }
                case -1065527466: {
                    return new Property("containerPreparation", "string", "Special processing that should be applied to the container for this kind of specimen.", 0, 1, this.containerPreparation);
                }
                case 363387971: {
                    return new Property("requirement", "string", "Requirements for delivery and special handling of this kind of conditioned specimen.", 0, 1, this.requirement);
                }
                case 1434969867: {
                    return new Property("retentionTime", "Duration", "The usual time that a specimen of this kind is retained after the ordered tests are completed, for the purpose of additional testing.", 0, 1, this.retentionTime);
                }
                case -553706344: {
                    return new Property("rejectionCriterion", "CodeableConcept", "Criterion for rejection of the specimen in its container by the laboratory.", 0, Integer.MAX_VALUE, this.rejectionCriterion);
                }
                case 2072805: {
                    return new Property("handling", "", "Set of instructions for conservation/transport of the specimen at a defined temperature interval, prior the testing process.", 0, Integer.MAX_VALUE, this.handling);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 976346515: {
                    Base[] baseArray;
                    if (this.isDerived == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.isDerived;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -1459831589: {
                    Base[] baseArray;
                    if (this.preference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.preference;
                    }
                    return baseArray;
                }
                case -207682360: {
                    Base[] baseArray;
                    if (this.containerMaterial == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.containerMaterial;
                    }
                    return baseArray;
                }
                case 1966942043: {
                    Base[] baseArray;
                    if (this.containerType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.containerType;
                    }
                    return baseArray;
                }
                case 2141642641: {
                    Base[] baseArray;
                    if (this.containerCap == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.containerCap;
                    }
                    return baseArray;
                }
                case -1474644805: {
                    Base[] baseArray;
                    if (this.containerDescription == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.containerDescription;
                    }
                    return baseArray;
                }
                case -574573477: {
                    Base[] baseArray;
                    if (this.containerCapacity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.containerCapacity;
                    }
                    return baseArray;
                }
                case -2037735993: {
                    Base[] baseArray;
                    if (this.containerMinimumVolume == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.containerMinimumVolume;
                    }
                    return baseArray;
                }
                case -1733338259: {
                    return this.containerAdditive == null ? new Base[]{} : this.containerAdditive.toArray(new Base[this.containerAdditive.size()]);
                }
                case -1065527466: {
                    Base[] baseArray;
                    if (this.containerPreparation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.containerPreparation;
                    }
                    return baseArray;
                }
                case 363387971: {
                    Base[] baseArray;
                    if (this.requirement == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.requirement;
                    }
                    return baseArray;
                }
                case 1434969867: {
                    Base[] baseArray;
                    if (this.retentionTime == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.retentionTime;
                    }
                    return baseArray;
                }
                case -553706344: {
                    return this.rejectionCriterion == null ? new Base[]{} : this.rejectionCriterion.toArray(new Base[this.rejectionCriterion.size()]);
                }
                case 2072805: {
                    return this.handling == null ? new Base[]{} : this.handling.toArray(new Base[this.handling.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 976346515: {
                    this.isDerived = this.castToBoolean(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1459831589: {
                    value = new SpecimenContainedPreferenceEnumFactory().fromType(this.castToCode(value));
                    this.preference = value;
                    return value;
                }
                case -207682360: {
                    this.containerMaterial = this.castToCodeableConcept(value);
                    return value;
                }
                case 1966942043: {
                    this.containerType = this.castToCodeableConcept(value);
                    return value;
                }
                case 2141642641: {
                    this.containerCap = this.castToCodeableConcept(value);
                    return value;
                }
                case -1474644805: {
                    this.containerDescription = this.castToString(value);
                    return value;
                }
                case -574573477: {
                    this.containerCapacity = this.castToSimpleQuantity(value);
                    return value;
                }
                case -2037735993: {
                    this.containerMinimumVolume = this.castToSimpleQuantity(value);
                    return value;
                }
                case -1733338259: {
                    this.getContainerAdditive().add((SpecimenDefinitionSpecimenToLabContainerAdditiveComponent)((Object)value));
                    return value;
                }
                case -1065527466: {
                    this.containerPreparation = this.castToString(value);
                    return value;
                }
                case 363387971: {
                    this.requirement = this.castToString(value);
                    return value;
                }
                case 1434969867: {
                    this.retentionTime = this.castToDuration(value);
                    return value;
                }
                case -553706344: {
                    this.getRejectionCriterion().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 2072805: {
                    this.getHandling().add((SpecimenDefinitionSpecimenToLabHandlingComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("isDerived")) {
                this.isDerived = this.castToBoolean(value);
            } else if (name.equals(SpecimenDefinition.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("preference")) {
                value = new SpecimenContainedPreferenceEnumFactory().fromType(this.castToCode(value));
                this.preference = value;
            } else if (name.equals("containerMaterial")) {
                this.containerMaterial = this.castToCodeableConcept(value);
            } else if (name.equals("containerType")) {
                this.containerType = this.castToCodeableConcept(value);
            } else if (name.equals("containerCap")) {
                this.containerCap = this.castToCodeableConcept(value);
            } else if (name.equals("containerDescription")) {
                this.containerDescription = this.castToString(value);
            } else if (name.equals("containerCapacity")) {
                this.containerCapacity = this.castToSimpleQuantity(value);
            } else if (name.equals("containerMinimumVolume")) {
                this.containerMinimumVolume = this.castToSimpleQuantity(value);
            } else if (name.equals("containerAdditive")) {
                this.getContainerAdditive().add((SpecimenDefinitionSpecimenToLabContainerAdditiveComponent)((Object)value));
            } else if (name.equals("containerPreparation")) {
                this.containerPreparation = this.castToString(value);
            } else if (name.equals("requirement")) {
                this.requirement = this.castToString(value);
            } else if (name.equals("retentionTime")) {
                this.retentionTime = this.castToDuration(value);
            } else if (name.equals("rejectionCriterion")) {
                this.getRejectionCriterion().add(this.castToCodeableConcept(value));
            } else if (name.equals("handling")) {
                this.getHandling().add((SpecimenDefinitionSpecimenToLabHandlingComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 976346515: {
                    return this.getIsDerivedElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1459831589: {
                    return this.getPreferenceElement();
                }
                case -207682360: {
                    return this.getContainerMaterial();
                }
                case 1966942043: {
                    return this.getContainerType();
                }
                case 2141642641: {
                    return this.getContainerCap();
                }
                case -1474644805: {
                    return this.getContainerDescriptionElement();
                }
                case -574573477: {
                    return this.getContainerCapacity();
                }
                case -2037735993: {
                    return this.getContainerMinimumVolume();
                }
                case -1733338259: {
                    return this.addContainerAdditive();
                }
                case -1065527466: {
                    return this.getContainerPreparationElement();
                }
                case 363387971: {
                    return this.getRequirementElement();
                }
                case 1434969867: {
                    return this.getRetentionTime();
                }
                case -553706344: {
                    return this.addRejectionCriterion();
                }
                case 2072805: {
                    return this.addHandling();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 976346515: {
                    return new String[]{"boolean"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1459831589: {
                    return new String[]{"code"};
                }
                case -207682360: {
                    return new String[]{"CodeableConcept"};
                }
                case 1966942043: {
                    return new String[]{"CodeableConcept"};
                }
                case 2141642641: {
                    return new String[]{"CodeableConcept"};
                }
                case -1474644805: {
                    return new String[]{"string"};
                }
                case -574573477: {
                    return new String[]{"SimpleQuantity"};
                }
                case -2037735993: {
                    return new String[]{"SimpleQuantity"};
                }
                case -1733338259: {
                    return new String[0];
                }
                case -1065527466: {
                    return new String[]{"string"};
                }
                case 363387971: {
                    return new String[]{"string"};
                }
                case 1434969867: {
                    return new String[]{"Duration"};
                }
                case -553706344: {
                    return new String[]{"CodeableConcept"};
                }
                case 2072805: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("isDerived")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.isDerived");
            }
            if (name.equals(SpecimenDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("preference")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.preference");
            }
            if (name.equals("containerMaterial")) {
                this.containerMaterial = new CodeableConcept();
                return this.containerMaterial;
            }
            if (name.equals("containerType")) {
                this.containerType = new CodeableConcept();
                return this.containerType;
            }
            if (name.equals("containerCap")) {
                this.containerCap = new CodeableConcept();
                return this.containerCap;
            }
            if (name.equals("containerDescription")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.containerDescription");
            }
            if (name.equals("containerCapacity")) {
                this.containerCapacity = new SimpleQuantity();
                return this.containerCapacity;
            }
            if (name.equals("containerMinimumVolume")) {
                this.containerMinimumVolume = new SimpleQuantity();
                return this.containerMinimumVolume;
            }
            if (name.equals("containerAdditive")) {
                return this.addContainerAdditive();
            }
            if (name.equals("containerPreparation")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.containerPreparation");
            }
            if (name.equals("requirement")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.requirement");
            }
            if (name.equals("retentionTime")) {
                this.retentionTime = new Duration();
                return this.retentionTime;
            }
            if (name.equals("rejectionCriterion")) {
                return this.addRejectionCriterion();
            }
            if (name.equals("handling")) {
                return this.addHandling();
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenDefinitionSpecimenToLabComponent copy() {
            SpecimenDefinitionSpecimenToLabComponent dst = new SpecimenDefinitionSpecimenToLabComponent();
            this.copyValues(dst);
            dst.isDerived = this.isDerived == null ? null : this.isDerived.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.preference = this.preference == null ? null : this.preference.copy();
            dst.containerMaterial = this.containerMaterial == null ? null : this.containerMaterial.copy();
            dst.containerType = this.containerType == null ? null : this.containerType.copy();
            dst.containerCap = this.containerCap == null ? null : this.containerCap.copy();
            dst.containerDescription = this.containerDescription == null ? null : this.containerDescription.copy();
            dst.containerCapacity = this.containerCapacity == null ? null : this.containerCapacity.copy();
            SimpleQuantity simpleQuantity = dst.containerMinimumVolume = this.containerMinimumVolume == null ? null : this.containerMinimumVolume.copy();
            if (this.containerAdditive != null) {
                dst.containerAdditive = new ArrayList<SpecimenDefinitionSpecimenToLabContainerAdditiveComponent>();
                for (SpecimenDefinitionSpecimenToLabContainerAdditiveComponent specimenDefinitionSpecimenToLabContainerAdditiveComponent : this.containerAdditive) {
                    dst.containerAdditive.add(specimenDefinitionSpecimenToLabContainerAdditiveComponent.copy());
                }
            }
            dst.containerPreparation = this.containerPreparation == null ? null : this.containerPreparation.copy();
            dst.requirement = this.requirement == null ? null : this.requirement.copy();
            Duration duration = dst.retentionTime = this.retentionTime == null ? null : this.retentionTime.copy();
            if (this.rejectionCriterion != null) {
                dst.rejectionCriterion = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.rejectionCriterion) {
                    dst.rejectionCriterion.add(codeableConcept.copy());
                }
            }
            if (this.handling != null) {
                dst.handling = new ArrayList<SpecimenDefinitionSpecimenToLabHandlingComponent>();
                for (SpecimenDefinitionSpecimenToLabHandlingComponent specimenDefinitionSpecimenToLabHandlingComponent : this.handling) {
                    dst.handling.add(specimenDefinitionSpecimenToLabHandlingComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SpecimenDefinitionSpecimenToLabComponent)) {
                return false;
            }
            SpecimenDefinitionSpecimenToLabComponent o = (SpecimenDefinitionSpecimenToLabComponent)other;
            return SpecimenDefinitionSpecimenToLabComponent.compareDeep(this.isDerived, o.isDerived, true) && SpecimenDefinitionSpecimenToLabComponent.compareDeep(this.type, o.type, true) && SpecimenDefinitionSpecimenToLabComponent.compareDeep(this.preference, o.preference, true) && SpecimenDefinitionSpecimenToLabComponent.compareDeep(this.containerMaterial, o.containerMaterial, true) && SpecimenDefinitionSpecimenToLabComponent.compareDeep(this.containerType, o.containerType, true) && SpecimenDefinitionSpecimenToLabComponent.compareDeep(this.containerCap, o.containerCap, true) && SpecimenDefinitionSpecimenToLabComponent.compareDeep(this.containerDescription, o.containerDescription, true) && SpecimenDefinitionSpecimenToLabComponent.compareDeep(this.containerCapacity, o.containerCapacity, true) && SpecimenDefinitionSpecimenToLabComponent.compareDeep(this.containerMinimumVolume, o.containerMinimumVolume, true) && SpecimenDefinitionSpecimenToLabComponent.compareDeep(this.containerAdditive, o.containerAdditive, true) && SpecimenDefinitionSpecimenToLabComponent.compareDeep(this.containerPreparation, o.containerPreparation, true) && SpecimenDefinitionSpecimenToLabComponent.compareDeep(this.requirement, o.requirement, true) && SpecimenDefinitionSpecimenToLabComponent.compareDeep(this.retentionTime, o.retentionTime, true) && SpecimenDefinitionSpecimenToLabComponent.compareDeep(this.rejectionCriterion, o.rejectionCriterion, true) && SpecimenDefinitionSpecimenToLabComponent.compareDeep(this.handling, o.handling, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SpecimenDefinitionSpecimenToLabComponent)) {
                return false;
            }
            SpecimenDefinitionSpecimenToLabComponent o = (SpecimenDefinitionSpecimenToLabComponent)other;
            return SpecimenDefinitionSpecimenToLabComponent.compareValues(this.isDerived, o.isDerived, true) && SpecimenDefinitionSpecimenToLabComponent.compareValues(this.preference, o.preference, true) && SpecimenDefinitionSpecimenToLabComponent.compareValues(this.containerDescription, o.containerDescription, true) && SpecimenDefinitionSpecimenToLabComponent.compareValues(this.containerPreparation, o.containerPreparation, true) && SpecimenDefinitionSpecimenToLabComponent.compareValues(this.requirement, o.requirement, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.isDerived, this.type, this.preference, this.containerMaterial, this.containerType, this.containerCap, this.containerDescription, this.containerCapacity, this.containerMinimumVolume, this.containerAdditive, this.containerPreparation, this.requirement, this.retentionTime, this.rejectionCriterion, this.handling});
        }

        @Override
        public String fhirType() {
            return "SpecimenDefinition.specimenToLab";
        }
    }

    public static class SpecimenContainedPreferenceEnumFactory
    implements EnumFactory<SpecimenContainedPreference> {
        @Override
        public SpecimenContainedPreference fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("preferred".equals(codeString)) {
                return SpecimenContainedPreference.PREFERRED;
            }
            if ("alternate".equals(codeString)) {
                return SpecimenContainedPreference.ALTERNATE;
            }
            throw new IllegalArgumentException("Unknown SpecimenContainedPreference code '" + codeString + "'");
        }

        public Enumeration<SpecimenContainedPreference> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SpecimenContainedPreference>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preferred".equals(codeString)) {
                return new Enumeration<SpecimenContainedPreference>(this, SpecimenContainedPreference.PREFERRED);
            }
            if ("alternate".equals(codeString)) {
                return new Enumeration<SpecimenContainedPreference>(this, SpecimenContainedPreference.ALTERNATE);
            }
            throw new FHIRException("Unknown SpecimenContainedPreference code '" + codeString + "'");
        }

        @Override
        public String toCode(SpecimenContainedPreference code) {
            if (code == SpecimenContainedPreference.PREFERRED) {
                return "preferred";
            }
            if (code == SpecimenContainedPreference.ALTERNATE) {
                return "alternate";
            }
            return "?";
        }

        @Override
        public String toSystem(SpecimenContainedPreference code) {
            return code.getSystem();
        }
    }

    public static enum SpecimenContainedPreference {
        PREFERRED,
        ALTERNATE,
        NULL;


        public static SpecimenContainedPreference fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preferred".equals(codeString)) {
                return PREFERRED;
            }
            if ("alternate".equals(codeString)) {
                return ALTERNATE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SpecimenContainedPreference code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PREFERRED: {
                    return "preferred";
                }
                case ALTERNATE: {
                    return "alternate";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PREFERRED: {
                    return "http://hl7.org/fhir/specimen-contained-preference";
                }
                case ALTERNATE: {
                    return "http://hl7.org/fhir/specimen-contained-preference";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PREFERRED: {
                    return "This type of contained specimen is preferred to collect this kind of specimen";
                }
                case ALTERNATE: {
                    return "This type of conditioned specimen is an alternate";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PREFERRED: {
                    return "Preferred";
                }
                case ALTERNATE: {
                    return "Alternate";
                }
            }
            return "?";
        }
    }
}

