/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ActionRequiredBehavior {
    MUST,
    COULD,
    MUSTUNLESSDOCUMENTED,
    NULL;


    public static ActionRequiredBehavior fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("must".equals(codeString)) {
            return MUST;
        }
        if ("could".equals(codeString)) {
            return COULD;
        }
        if ("must-unless-documented".equals(codeString)) {
            return MUSTUNLESSDOCUMENTED;
        }
        throw new FHIRException("Unknown ActionRequiredBehavior code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case MUST: {
                return "must";
            }
            case COULD: {
                return "could";
            }
            case MUSTUNLESSDOCUMENTED: {
                return "must-unless-documented";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/action-required-behavior";
    }

    public String getDefinition() {
        switch (this) {
            case MUST: {
                return "An action with this behavior must be included in the actions processed by the end user; the end user may not choose not to include this action";
            }
            case COULD: {
                return "An action with this behavior may be included in the set of actions processed by the end user";
            }
            case MUSTUNLESSDOCUMENTED: {
                return "An action with this behavior must be included in the set of actions processed by the end user, unless the end user provides documentation as to why the action was not included";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case MUST: {
                return "Must";
            }
            case COULD: {
                return "Could";
            }
            case MUSTUNLESSDOCUMENTED: {
                return "Must Unless Documented";
            }
        }
        return "?";
    }
}

