/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AdverseEventCausalityAssess {
    CERTAIN,
    PROBABLYLIKELY,
    POSSIBLE,
    UNLIKELY,
    CONDITIONALCLASSIFIED,
    UNASSESSABLEUNCLASSIFIABLE,
    NULL;


    public static AdverseEventCausalityAssess fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("Certain".equals(codeString)) {
            return CERTAIN;
        }
        if ("Probably-Likely".equals(codeString)) {
            return PROBABLYLIKELY;
        }
        if ("Possible".equals(codeString)) {
            return POSSIBLE;
        }
        if ("Unlikely".equals(codeString)) {
            return UNLIKELY;
        }
        if ("Conditional-Classified".equals(codeString)) {
            return CONDITIONALCLASSIFIED;
        }
        if ("Unassessable-Unclassifiable".equals(codeString)) {
            return UNASSESSABLEUNCLASSIFIABLE;
        }
        throw new FHIRException("Unknown AdverseEventCausalityAssess code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CERTAIN: {
                return "Certain";
            }
            case PROBABLYLIKELY: {
                return "Probably-Likely";
            }
            case POSSIBLE: {
                return "Possible";
            }
            case UNLIKELY: {
                return "Unlikely";
            }
            case CONDITIONALCLASSIFIED: {
                return "Conditional-Classified";
            }
            case UNASSESSABLEUNCLASSIFIABLE: {
                return "Unassessable-Unclassifiable";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/adverse-event-causality-assess";
    }

    public String getDefinition() {
        switch (this) {
            case CERTAIN: {
                return "i) Event or laboratory test abnormality, with plausible time relationship to drug intake\nii) Cannot be explained by disease or other drugs\niii) Response to withdrawal plausible (pharmacologically, pathologically)\niv) Event definitive pharmacologically or phenomenologically (i.e. an objective and specific medical disorder or a recognized pharmacological phenomenon)\nv) Re-challenge satisfactory, if necessary";
            }
            case PROBABLYLIKELY: {
                return "i) Event or laboratory test abnormality, with reasonable time relationship to drug intake\nii) Unlikely to be attributed to disease or other drugs\niii) Response to withdrawal clinically reasonable\niv) Re-challenge not required";
            }
            case POSSIBLE: {
                return "i) Event or laboratory test abnormality, with reasonable time relationship to drug intake\nii) Could also be explained by disease or other drugs\niii) Information on drug withdrawal may be lacking or unclear";
            }
            case UNLIKELY: {
                return "i) Event or laboratory test abnormality, with a time to drug intake that makes a relationship improbable (but not impossible)\nii) Disease or other drugs provide plausible explanations";
            }
            case CONDITIONALCLASSIFIED: {
                return "i) Event or laboratory test abnormality\nii) More data for proper assessment needed, or\niii) Additional data under examination";
            }
            case UNASSESSABLEUNCLASSIFIABLE: {
                return "i) Report suggesting an adverse reaction\nii) Cannot be judged because information is insufficient or contradictory\niii) Data cannot be supplemented or verified";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CERTAIN: {
                return "Certain";
            }
            case PROBABLYLIKELY: {
                return "Probably/Likely";
            }
            case POSSIBLE: {
                return "Possible";
            }
            case UNLIKELY: {
                return "Unlikely";
            }
            case CONDITIONALCLASSIFIED: {
                return "Conditional/Classified";
            }
            case UNASSESSABLEUNCLASSIFIABLE: {
                return "Unassessable/Unclassifiable";
            }
        }
        return "?";
    }
}

