/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ClaimInformationcategory {
    INFO,
    DISCHARGE,
    ONSET,
    RELATED,
    EXCEPTION,
    MATERIAL,
    ATTACHMENT,
    MISSINGTOOTH,
    PROSTHESIS,
    OTHER,
    NULL;


    public static ClaimInformationcategory fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("info".equals(codeString)) {
            return INFO;
        }
        if ("discharge".equals(codeString)) {
            return DISCHARGE;
        }
        if ("onset".equals(codeString)) {
            return ONSET;
        }
        if ("related".equals(codeString)) {
            return RELATED;
        }
        if ("exception".equals(codeString)) {
            return EXCEPTION;
        }
        if ("material".equals(codeString)) {
            return MATERIAL;
        }
        if ("attachment".equals(codeString)) {
            return ATTACHMENT;
        }
        if ("missingtooth".equals(codeString)) {
            return MISSINGTOOTH;
        }
        if ("prosthesis".equals(codeString)) {
            return PROSTHESIS;
        }
        if ("other".equals(codeString)) {
            return OTHER;
        }
        throw new FHIRException("Unknown ClaimInformationcategory code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INFO: {
                return "info";
            }
            case DISCHARGE: {
                return "discharge";
            }
            case ONSET: {
                return "onset";
            }
            case RELATED: {
                return "related";
            }
            case EXCEPTION: {
                return "exception";
            }
            case MATERIAL: {
                return "material";
            }
            case ATTACHMENT: {
                return "attachment";
            }
            case MISSINGTOOTH: {
                return "missingtooth";
            }
            case PROSTHESIS: {
                return "prosthesis";
            }
            case OTHER: {
                return "other";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/claiminformationcategory";
    }

    public String getDefinition() {
        switch (this) {
            case INFO: {
                return "Codes conveying additional situation and condition information.";
            }
            case DISCHARGE: {
                return "Discharge status and discharge to locations.";
            }
            case ONSET: {
                return "Period, start or end dates of aspects of the Condition.";
            }
            case RELATED: {
                return "Nature and date of the related event eg. Last exam, service, Xray etc.";
            }
            case EXCEPTION: {
                return "Insurance policy exceptions.";
            }
            case MATERIAL: {
                return "Materials being forwarded, eg. Models, molds, images, documents.";
            }
            case ATTACHMENT: {
                return "Materials attached such as images, documents and resources.";
            }
            case MISSINGTOOTH: {
                return "Teeth which are missing for any reason, for example: prior extraction, never developed.";
            }
            case PROSTHESIS: {
                return "The type of prosthesis and date of supply if a previously supplied prosthesis.";
            }
            case OTHER: {
                return "Other information identified by the type.system.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INFO: {
                return "Information";
            }
            case DISCHARGE: {
                return "Discharge";
            }
            case ONSET: {
                return "Onset";
            }
            case RELATED: {
                return "Related Services";
            }
            case EXCEPTION: {
                return "Exception";
            }
            case MATERIAL: {
                return "Materials Forwarded";
            }
            case ATTACHMENT: {
                return "Attachment";
            }
            case MISSINGTOOTH: {
                return "Missing Tooth";
            }
            case PROSTHESIS: {
                return "Prosthesis";
            }
            case OTHER: {
                return "Other";
            }
        }
        return "?";
    }
}

