/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ClaimType {
    INSTITUTIONAL,
    ORAL,
    PHARMACY,
    PROFESSIONAL,
    VISION,
    NULL;


    public static ClaimType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("institutional".equals(codeString)) {
            return INSTITUTIONAL;
        }
        if ("oral".equals(codeString)) {
            return ORAL;
        }
        if ("pharmacy".equals(codeString)) {
            return PHARMACY;
        }
        if ("professional".equals(codeString)) {
            return PROFESSIONAL;
        }
        if ("vision".equals(codeString)) {
            return VISION;
        }
        throw new FHIRException("Unknown ClaimType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INSTITUTIONAL: {
                return "institutional";
            }
            case ORAL: {
                return "oral";
            }
            case PHARMACY: {
                return "pharmacy";
            }
            case PROFESSIONAL: {
                return "professional";
            }
            case VISION: {
                return "vision";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-claimtype";
    }

    public String getDefinition() {
        switch (this) {
            case INSTITUTIONAL: {
                return "Hospital, clinic and typically inpatient claims.";
            }
            case ORAL: {
                return "Dental, Denture and Hygiene claims.";
            }
            case PHARMACY: {
                return "Pharmacy claims for goods and services.";
            }
            case PROFESSIONAL: {
                return "Typically outpatient claims from Physician, Psychological, Chiropractor, Physiotherapy, Speech Pathology, rehabilitative, consulting.";
            }
            case VISION: {
                return "Vision claims for professional services and products such as glasses and contact lenses.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INSTITUTIONAL: {
                return "Institutional";
            }
            case ORAL: {
                return "Oral";
            }
            case PHARMACY: {
                return "Pharmacy";
            }
            case PROFESSIONAL: {
                return "Professional";
            }
            case VISION: {
                return "Vision";
            }
        }
        return "?";
    }
}

