/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CodesystemContentMode {
    NOTPRESENT,
    EXAMPLE,
    FRAGMENT,
    COMPLETE,
    NULL;


    public static CodesystemContentMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("not-present".equals(codeString)) {
            return NOTPRESENT;
        }
        if ("example".equals(codeString)) {
            return EXAMPLE;
        }
        if ("fragment".equals(codeString)) {
            return FRAGMENT;
        }
        if ("complete".equals(codeString)) {
            return COMPLETE;
        }
        throw new FHIRException("Unknown CodesystemContentMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NOTPRESENT: {
                return "not-present";
            }
            case EXAMPLE: {
                return "example";
            }
            case FRAGMENT: {
                return "fragment";
            }
            case COMPLETE: {
                return "complete";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/codesystem-content-mode";
    }

    public String getDefinition() {
        switch (this) {
            case NOTPRESENT: {
                return "None of the concepts defined by the code system are included in the code system resource";
            }
            case EXAMPLE: {
                return "A few representative concepts are included in the code system resource";
            }
            case FRAGMENT: {
                return "A subset of the code system concepts are included in the code system resource";
            }
            case COMPLETE: {
                return "All the concepts defined by the code system are included in the code system resource";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NOTPRESENT: {
                return "Not Present";
            }
            case EXAMPLE: {
                return "Example";
            }
            case FRAGMENT: {
                return "Fragment";
            }
            case COMPLETE: {
                return "Complete";
            }
        }
        return "?";
    }
}

