/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConceptMapEquivalence {
    RELATEDTO,
    EQUIVALENT,
    EQUAL,
    WIDER,
    SUBSUMES,
    NARROWER,
    SPECIALIZES,
    INEXACT,
    UNMATCHED,
    DISJOINT,
    NULL;


    public static ConceptMapEquivalence fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("relatedto".equals(codeString)) {
            return RELATEDTO;
        }
        if ("equivalent".equals(codeString)) {
            return EQUIVALENT;
        }
        if ("equal".equals(codeString)) {
            return EQUAL;
        }
        if ("wider".equals(codeString)) {
            return WIDER;
        }
        if ("subsumes".equals(codeString)) {
            return SUBSUMES;
        }
        if ("narrower".equals(codeString)) {
            return NARROWER;
        }
        if ("specializes".equals(codeString)) {
            return SPECIALIZES;
        }
        if ("inexact".equals(codeString)) {
            return INEXACT;
        }
        if ("unmatched".equals(codeString)) {
            return UNMATCHED;
        }
        if ("disjoint".equals(codeString)) {
            return DISJOINT;
        }
        throw new FHIRException("Unknown ConceptMapEquivalence code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case RELATEDTO: {
                return "relatedto";
            }
            case EQUIVALENT: {
                return "equivalent";
            }
            case EQUAL: {
                return "equal";
            }
            case WIDER: {
                return "wider";
            }
            case SUBSUMES: {
                return "subsumes";
            }
            case NARROWER: {
                return "narrower";
            }
            case SPECIALIZES: {
                return "specializes";
            }
            case INEXACT: {
                return "inexact";
            }
            case UNMATCHED: {
                return "unmatched";
            }
            case DISJOINT: {
                return "disjoint";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/concept-map-equivalence";
    }

    public String getDefinition() {
        switch (this) {
            case RELATEDTO: {
                return "The concepts are related to each other, and have at least some overlap in meaning, but the exact relationship is not known";
            }
            case EQUIVALENT: {
                return "The definitions of the concepts mean the same thing (including when structural implications of meaning are considered) (i.e. extensionally identical).";
            }
            case EQUAL: {
                return "The definitions of the concepts are exactly the same (i.e. only grammatical differences) and structural implications of meaning are identical or irrelevant (i.e. intentionally identical).";
            }
            case WIDER: {
                return "The target mapping is wider in meaning than the source concept.";
            }
            case SUBSUMES: {
                return "The target mapping subsumes the meaning of the source concept (e.g. the source is-a target).";
            }
            case NARROWER: {
                return "The target mapping is narrower in meaning than the source concept. The sense in which the mapping is narrower SHALL be described in the comments in this case, and applications should be careful when attempting to use these mappings operationally.";
            }
            case SPECIALIZES: {
                return "The target mapping specializes the meaning of the source concept (e.g. the target is-a source).";
            }
            case INEXACT: {
                return "The target mapping overlaps with the source concept, but both source and target cover additional meaning, or the definitions are imprecise and it is uncertain whether they have the same boundaries to their meaning. The sense in which the mapping is narrower SHALL be described in the comments in this case, and applications should be careful when attempting to use these mappings operationally.";
            }
            case UNMATCHED: {
                return "There is no match for this concept in the destination concept system.";
            }
            case DISJOINT: {
                return "This is an explicit assertion that there is no mapping between the source and target concept.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case RELATEDTO: {
                return "Related To";
            }
            case EQUIVALENT: {
                return "Equivalent";
            }
            case EQUAL: {
                return "Equal";
            }
            case WIDER: {
                return "Wider";
            }
            case SUBSUMES: {
                return "Subsumes";
            }
            case NARROWER: {
                return "Narrower";
            }
            case SPECIALIZES: {
                return "Specializes";
            }
            case INEXACT: {
                return "Inexact";
            }
            case UNMATCHED: {
                return "Unmatched";
            }
            case DISJOINT: {
                return "Disjoint";
            }
        }
        return "?";
    }
}

