/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConditionClinical {
    ACTIVE,
    RECURRENCE,
    RELAPSE,
    WELLCONTROLLED,
    POORLYCONTROLLED,
    INACTIVE,
    REMISSION,
    RESOLVED,
    NULL;


    public static ConditionClinical fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("recurrence".equals(codeString)) {
            return RECURRENCE;
        }
        if ("relapse".equals(codeString)) {
            return RELAPSE;
        }
        if ("well-controlled".equals(codeString)) {
            return WELLCONTROLLED;
        }
        if ("poorly-controlled".equals(codeString)) {
            return POORLYCONTROLLED;
        }
        if ("inactive".equals(codeString)) {
            return INACTIVE;
        }
        if ("remission".equals(codeString)) {
            return REMISSION;
        }
        if ("resolved".equals(codeString)) {
            return RESOLVED;
        }
        throw new FHIRException("Unknown ConditionClinical code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVE: {
                return "active";
            }
            case RECURRENCE: {
                return "recurrence";
            }
            case RELAPSE: {
                return "relapse";
            }
            case WELLCONTROLLED: {
                return "well-controlled";
            }
            case POORLYCONTROLLED: {
                return "poorly-controlled";
            }
            case INACTIVE: {
                return "inactive";
            }
            case REMISSION: {
                return "remission";
            }
            case RESOLVED: {
                return "resolved";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/condition-clinical";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVE: {
                return "The subject is currently experiencing the symptoms of the condition or there is evidence of the condition.";
            }
            case RECURRENCE: {
                return "The subject is experiencing a re-occurence or repeating of a previously resolved condition, e.g. urinary tract infection, pancreatitis, cholangitis, conjunctivitis.";
            }
            case RELAPSE: {
                return "The subject is experiencing a return of a condition, or signs and symptoms after a period of improvement or remission, e.g. relapse of cancer, multiple sclerosis, rheumatoid arthritis, systemic lupus erythematosus, bipolar disorder, [psychotic relapse of] schizophrenia, etc.";
            }
            case WELLCONTROLLED: {
                return "The subject's condition is adequately or well managed such that the recommended evidence-based clinical outcome targets are met.";
            }
            case POORLYCONTROLLED: {
                return "The subject's condition is inadequately/poorly managed such that the recommended evidence-based clinical outcome targets are not met.";
            }
            case INACTIVE: {
                return "The subject is no longer experiencing the symptoms of the condition or there is no longer evidence of the condition.";
            }
            case REMISSION: {
                return "The subject is no longer experiencing the symptoms of the condition, but there is a risk of the symptoms returning.";
            }
            case RESOLVED: {
                return "The subject is no longer experiencing the symptoms of the condition and there is a negligible perceived risk of the symptoms returning.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVE: {
                return "Active";
            }
            case RECURRENCE: {
                return "Recurrence";
            }
            case RELAPSE: {
                return "Relapse";
            }
            case WELLCONTROLLED: {
                return "Well-Controlled";
            }
            case POORLYCONTROLLED: {
                return "Poorly-Controlled";
            }
            case INACTIVE: {
                return "Inactive";
            }
            case REMISSION: {
                return "Remission";
            }
            case RESOLVED: {
                return "Resolved";
            }
        }
        return "?";
    }
}

