/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContractActorrole {
    PRACTITIONER,
    PATIENT,
    NULL;


    public static ContractActorrole fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("practitioner".equals(codeString)) {
            return PRACTITIONER;
        }
        if ("patient".equals(codeString)) {
            return PATIENT;
        }
        throw new FHIRException("Unknown ContractActorrole code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PRACTITIONER: {
                return "practitioner";
            }
            case PATIENT: {
                return "patient";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://www.hl7.org/fhir/contractactorrole";
    }

    public String getDefinition() {
        switch (this) {
            case PRACTITIONER: {
                return "Someone who provides health care related services to people or animals including both clinical and support services.";
            }
            case PATIENT: {
                return "A receiver, human or animal, of health care related goods and services.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PRACTITIONER: {
                return "Practitioner";
            }
            case PATIENT: {
                return "Patient";
            }
        }
        return "?";
    }
}

