/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CoverageLevel {
    GROUP,
    SUBGROUP,
    PLAN,
    SUBPLAN,
    CLASS,
    SUBCLASS,
    NULL;


    public static CoverageLevel fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("group".equals(codeString)) {
            return GROUP;
        }
        if ("subgroup".equals(codeString)) {
            return SUBGROUP;
        }
        if ("plan".equals(codeString)) {
            return PLAN;
        }
        if ("subplan".equals(codeString)) {
            return SUBPLAN;
        }
        if ("class".equals(codeString)) {
            return CLASS;
        }
        if ("subclass".equals(codeString)) {
            return SUBCLASS;
        }
        throw new FHIRException("Unknown CoverageLevel code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case GROUP: {
                return "group";
            }
            case SUBGROUP: {
                return "subgroup";
            }
            case PLAN: {
                return "plan";
            }
            case SUBPLAN: {
                return "subplan";
            }
            case CLASS: {
                return "class";
            }
            case SUBCLASS: {
                return "subclass";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/coverage-level";
    }

    public String getDefinition() {
        switch (this) {
            case GROUP: {
                return "An employee group";
            }
            case SUBGROUP: {
                return "A sub-group of an employee group";
            }
            case PLAN: {
                return "A specific suite of benefits.";
            }
            case SUBPLAN: {
                return "A subset of a specific suite of benefits.";
            }
            case CLASS: {
                return "A class of benefits.";
            }
            case SUBCLASS: {
                return "A subset of a class of benefits.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case GROUP: {
                return "Group";
            }
            case SUBGROUP: {
                return "SubGroup";
            }
            case PLAN: {
                return "Plan";
            }
            case SUBPLAN: {
                return "SubPlan";
            }
            case CLASS: {
                return "Class";
            }
            case SUBCLASS: {
                return "SubClass";
            }
        }
        return "?";
    }
}

