/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EventStatus {
    PREPARATION,
    INPROGRESS,
    SUSPENDED,
    ABORTED,
    COMPLETED,
    ENTEREDINERROR,
    UNKNOWN,
    NULL;


    public static EventStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("preparation".equals(codeString)) {
            return PREPARATION;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("suspended".equals(codeString)) {
            return SUSPENDED;
        }
        if ("aborted".equals(codeString)) {
            return ABORTED;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown EventStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PREPARATION: {
                return "preparation";
            }
            case INPROGRESS: {
                return "in-progress";
            }
            case SUSPENDED: {
                return "suspended";
            }
            case ABORTED: {
                return "aborted";
            }
            case COMPLETED: {
                return "completed";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/event-status";
    }

    public String getDefinition() {
        switch (this) {
            case PREPARATION: {
                return "The core event has not started yet, but some staging activities have begun (e.g. surgical suite preparation).  Preparation stages may be tracked for billing purposes.";
            }
            case INPROGRESS: {
                return "The event is currently occurring";
            }
            case SUSPENDED: {
                return "The event has been temporarily stopped but is expected to resume in the future";
            }
            case ABORTED: {
                return "The event was  prior to the full completion of the intended actions";
            }
            case COMPLETED: {
                return "The event has now concluded";
            }
            case ENTEREDINERROR: {
                return "This electronic record should never have existed, though it is possible that real-world decisions were based on it.  (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".)";
            }
            case UNKNOWN: {
                return "The authoring system does not know which of the status values currently applies for this request.  Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, it's just not known which one.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PREPARATION: {
                return "Preparation";
            }
            case INPROGRESS: {
                return "In Progress";
            }
            case SUSPENDED: {
                return "Suspended";
            }
            case ABORTED: {
                return "Aborted";
            }
            case COMPLETED: {
                return "Completed";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "?";
    }
}

