/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.EventTiming;

public class EventTimingEnumFactory
implements EnumFactory<EventTiming> {
    @Override
    public EventTiming fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("MORN".equals(codeString)) {
            return EventTiming.MORN;
        }
        if ("AFT".equals(codeString)) {
            return EventTiming.AFT;
        }
        if ("EVE".equals(codeString)) {
            return EventTiming.EVE;
        }
        if ("NIGHT".equals(codeString)) {
            return EventTiming.NIGHT;
        }
        if ("PHS".equals(codeString)) {
            return EventTiming.PHS;
        }
        throw new IllegalArgumentException("Unknown EventTiming code '" + codeString + "'");
    }

    @Override
    public String toCode(EventTiming code) {
        if (code == EventTiming.MORN) {
            return "MORN";
        }
        if (code == EventTiming.AFT) {
            return "AFT";
        }
        if (code == EventTiming.EVE) {
            return "EVE";
        }
        if (code == EventTiming.NIGHT) {
            return "NIGHT";
        }
        if (code == EventTiming.PHS) {
            return "PHS";
        }
        return "?";
    }

    @Override
    public String toSystem(EventTiming code) {
        return code.getSystem();
    }
}

