/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ExProgramCode {
    AS,
    HD,
    AUSCR,
    NONE,
    NULL;


    public static ExProgramCode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("as".equals(codeString)) {
            return AS;
        }
        if ("hd".equals(codeString)) {
            return HD;
        }
        if ("auscr".equals(codeString)) {
            return AUSCR;
        }
        if ("none".equals(codeString)) {
            return NONE;
        }
        throw new FHIRException("Unknown ExProgramCode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AS: {
                return "as";
            }
            case HD: {
                return "hd";
            }
            case AUSCR: {
                return "auscr";
            }
            case NONE: {
                return "none";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-programcode";
    }

    public String getDefinition() {
        switch (this) {
            case AS: {
                return "Child Asthma Program";
            }
            case HD: {
                return "Hemodialysis Program.";
            }
            case AUSCR: {
                return "Autism Screening Program.";
            }
            case NONE: {
                return "No program code applies.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AS: {
                return "Child Asthma";
            }
            case HD: {
                return "Hemodialysis";
            }
            case AUSCR: {
                return "Autism Screening";
            }
            case NONE: {
                return "None";
            }
        }
        return "?";
    }
}

