/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum FhirVersions {
    _0_01,
    _0_05,
    _0_06,
    _0_11,
    _0_0_80,
    _0_0_81,
    _0_0_82,
    _0_4_0,
    _0_5_0,
    _1_0_0,
    _1_0_1,
    _1_1_0,
    _1_4_0,
    _1_6_0,
    _1_8_0,
    _3_0_0,
    _3_0_1,
    _3_1_0,
    NULL;


    public static FhirVersions fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("0.01".equals(codeString)) {
            return _0_01;
        }
        if ("0.05".equals(codeString)) {
            return _0_05;
        }
        if ("0.06".equals(codeString)) {
            return _0_06;
        }
        if ("0.11".equals(codeString)) {
            return _0_11;
        }
        if ("0.0.80".equals(codeString)) {
            return _0_0_80;
        }
        if ("0.0.81".equals(codeString)) {
            return _0_0_81;
        }
        if ("0.0.82".equals(codeString)) {
            return _0_0_82;
        }
        if ("0.4.0".equals(codeString)) {
            return _0_4_0;
        }
        if ("0.5.0".equals(codeString)) {
            return _0_5_0;
        }
        if ("1.0.0".equals(codeString)) {
            return _1_0_0;
        }
        if ("1.0.1".equals(codeString)) {
            return _1_0_1;
        }
        if ("1.1.0".equals(codeString)) {
            return _1_1_0;
        }
        if ("1.4.0".equals(codeString)) {
            return _1_4_0;
        }
        if ("1.6.0".equals(codeString)) {
            return _1_6_0;
        }
        if ("1.8.0".equals(codeString)) {
            return _1_8_0;
        }
        if ("3.0.0".equals(codeString)) {
            return _3_0_0;
        }
        if ("3.0.1".equals(codeString)) {
            return _3_0_1;
        }
        if ("3.1.0".equals(codeString)) {
            return _3_1_0;
        }
        throw new FHIRException("Unknown FhirVersions code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _0_01: {
                return "0.01";
            }
            case _0_05: {
                return "0.05";
            }
            case _0_06: {
                return "0.06";
            }
            case _0_11: {
                return "0.11";
            }
            case _0_0_80: {
                return "0.0.80";
            }
            case _0_0_81: {
                return "0.0.81";
            }
            case _0_0_82: {
                return "0.0.82";
            }
            case _0_4_0: {
                return "0.4.0";
            }
            case _0_5_0: {
                return "0.5.0";
            }
            case _1_0_0: {
                return "1.0.0";
            }
            case _1_0_1: {
                return "1.0.1";
            }
            case _1_1_0: {
                return "1.1.0";
            }
            case _1_4_0: {
                return "1.4.0";
            }
            case _1_6_0: {
                return "1.6.0";
            }
            case _1_8_0: {
                return "1.8.0";
            }
            case _3_0_0: {
                return "3.0.0";
            }
            case _3_0_1: {
                return "3.0.1";
            }
            case _3_1_0: {
                return "3.1.0";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/fhir-versions";
    }

    public String getDefinition() {
        switch (this) {
            case _0_01: {
                return "Oldest archived version of FHIR";
            }
            case _0_05: {
                return "1st Draft for Comment (Sept 2012 Ballot)";
            }
            case _0_06: {
                return "2nd Draft for Comment (January 2013 Ballot)";
            }
            case _0_11: {
                return "DSTU 1 Ballot version";
            }
            case _0_0_80: {
                return "DSTU 1 Official version";
            }
            case _0_0_81: {
                return "DSTU 1 Official version Technical Errata #1";
            }
            case _0_0_82: {
                return "DSTU 1 Official version Technical Errata #2";
            }
            case _0_4_0: {
                return "Draft For Comment (January 2015 Ballot)";
            }
            case _0_5_0: {
                return "DSTU 2 Ballot version (May 2015 Ballot)";
            }
            case _1_0_0: {
                return "DSTU 2 QA Preview + CQIF Ballot (Sep 2015)";
            }
            case _1_0_1: {
                return "DSTU 2 (Official version)";
            }
            case _1_1_0: {
                return "GAO Ballot + draft changes to main FHIR standard";
            }
            case _1_4_0: {
                return "CQF on FHIR Ballot + Connectathon 12 (Montreal)";
            }
            case _1_6_0: {
                return "FHIR STU3 Ballot + Connectathon 13 (Baltimore)";
            }
            case _1_8_0: {
                return "FHIR STU3 Candidate + Connectathon 14 (San Antonio)";
            }
            case _3_0_0: {
                return "FHIR Release 3 (STU)";
            }
            case _3_0_1: {
                return "FHIR Release 3 (STU) with 1 technical errata";
            }
            case _3_1_0: {
                return "Current Development build";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _0_01: {
                return "0.01";
            }
            case _0_05: {
                return "0.05";
            }
            case _0_06: {
                return "0.06";
            }
            case _0_11: {
                return "0.11";
            }
            case _0_0_80: {
                return "0.0.80";
            }
            case _0_0_81: {
                return "0.0.81";
            }
            case _0_0_82: {
                return "0.0.82";
            }
            case _0_4_0: {
                return "0.4.0";
            }
            case _0_5_0: {
                return "0.5.0";
            }
            case _1_0_0: {
                return "1.0.0";
            }
            case _1_0_1: {
                return "1.0.1";
            }
            case _1_1_0: {
                return "1.1.0";
            }
            case _1_4_0: {
                return "1.4.0";
            }
            case _1_6_0: {
                return "1.6.0";
            }
            case _1_8_0: {
                return "1.8.0";
            }
            case _3_0_0: {
                return "3.0.0";
            }
            case _3_0_1: {
                return "3.0.1";
            }
            case _3_1_0: {
                return "3.1.0";
            }
        }
        return "?";
    }
}

