/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HttpVerb {
    GET,
    POST,
    PUT,
    DELETE,
    NULL;


    public static HttpVerb fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("GET".equals(codeString)) {
            return GET;
        }
        if ("POST".equals(codeString)) {
            return POST;
        }
        if ("PUT".equals(codeString)) {
            return PUT;
        }
        if ("DELETE".equals(codeString)) {
            return DELETE;
        }
        throw new FHIRException("Unknown HttpVerb code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case GET: {
                return "GET";
            }
            case POST: {
                return "POST";
            }
            case PUT: {
                return "PUT";
            }
            case DELETE: {
                return "DELETE";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/http-verb";
    }

    public String getDefinition() {
        switch (this) {
            case GET: {
                return "HTTP GET";
            }
            case POST: {
                return "HTTP POST";
            }
            case PUT: {
                return "HTTP PUT";
            }
            case DELETE: {
                return "HTTP DELETE";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case GET: {
                return "GET";
            }
            case POST: {
                return "POST";
            }
            case PUT: {
                return "PUT";
            }
            case DELETE: {
                return "DELETE";
            }
        }
        return "?";
    }
}

