/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ListMode {
    WORKING,
    SNAPSHOT,
    CHANGES,
    NULL;


    public static ListMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("working".equals(codeString)) {
            return WORKING;
        }
        if ("snapshot".equals(codeString)) {
            return SNAPSHOT;
        }
        if ("changes".equals(codeString)) {
            return CHANGES;
        }
        throw new FHIRException("Unknown ListMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case WORKING: {
                return "working";
            }
            case SNAPSHOT: {
                return "snapshot";
            }
            case CHANGES: {
                return "changes";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/list-mode";
    }

    public String getDefinition() {
        switch (this) {
            case WORKING: {
                return "This list is the master list, maintained in an ongoing fashion with regular updates as the real world list it is tracking changes";
            }
            case SNAPSHOT: {
                return "This list was prepared as a snapshot. It should not be assumed to be current";
            }
            case CHANGES: {
                return "A list that indicates where changes have been made or recommended";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case WORKING: {
                return "Working List";
            }
            case SNAPSHOT: {
                return "Snapshot List";
            }
            case CHANGES: {
                return "Change List";
            }
        }
        return "?";
    }
}

