/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ReferencerangeMeaning {
    TYPE,
    NORMAL,
    RECOMMENDED,
    TREATMENT,
    THERAPEUTIC,
    PRE,
    POST,
    ENDOCRINE,
    PREPUBERTY,
    FOLLICULAR,
    MIDCYCLE,
    LUTEAL,
    POSTMEOPAUSAL,
    NULL;


    public static ReferencerangeMeaning fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("type".equals(codeString)) {
            return TYPE;
        }
        if ("normal".equals(codeString)) {
            return NORMAL;
        }
        if ("recommended".equals(codeString)) {
            return RECOMMENDED;
        }
        if ("treatment".equals(codeString)) {
            return TREATMENT;
        }
        if ("therapeutic".equals(codeString)) {
            return THERAPEUTIC;
        }
        if ("pre".equals(codeString)) {
            return PRE;
        }
        if ("post".equals(codeString)) {
            return POST;
        }
        if ("endocrine".equals(codeString)) {
            return ENDOCRINE;
        }
        if ("pre-puberty".equals(codeString)) {
            return PREPUBERTY;
        }
        if ("follicular".equals(codeString)) {
            return FOLLICULAR;
        }
        if ("midcycle".equals(codeString)) {
            return MIDCYCLE;
        }
        if ("luteal".equals(codeString)) {
            return LUTEAL;
        }
        if ("postmeopausal".equals(codeString)) {
            return POSTMEOPAUSAL;
        }
        throw new FHIRException("Unknown ReferencerangeMeaning code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case TYPE: {
                return "type";
            }
            case NORMAL: {
                return "normal";
            }
            case RECOMMENDED: {
                return "recommended";
            }
            case TREATMENT: {
                return "treatment";
            }
            case THERAPEUTIC: {
                return "therapeutic";
            }
            case PRE: {
                return "pre";
            }
            case POST: {
                return "post";
            }
            case ENDOCRINE: {
                return "endocrine";
            }
            case PREPUBERTY: {
                return "pre-puberty";
            }
            case FOLLICULAR: {
                return "follicular";
            }
            case MIDCYCLE: {
                return "midcycle";
            }
            case LUTEAL: {
                return "luteal";
            }
            case POSTMEOPAUSAL: {
                return "postmeopausal";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/referencerange-meaning";
    }

    public String getDefinition() {
        switch (this) {
            case TYPE: {
                return "General types of reference range.";
            }
            case NORMAL: {
                return "Based on 95th percentile for the relevant control population.";
            }
            case RECOMMENDED: {
                return "The range that is recommended by a relevant professional body.";
            }
            case TREATMENT: {
                return "The range at which treatment would/should be considered.";
            }
            case THERAPEUTIC: {
                return "The optimal range for best therapeutic outcomes.";
            }
            case PRE: {
                return "The optimal range for best therapeutic outcomes for a specimen taken immediately before administration.";
            }
            case POST: {
                return "The optimal range for best therapeutic outcomes for a specimen taken immediately after administration.";
            }
            case ENDOCRINE: {
                return "Endocrine related states that change the expected value.";
            }
            case PREPUBERTY: {
                return "An expected range in an individual prior to puberty.";
            }
            case FOLLICULAR: {
                return "An expected range in an individual during the follicular stage of the cycle.";
            }
            case MIDCYCLE: {
                return "An expected range in an individual during the follicular stage of the cycle.";
            }
            case LUTEAL: {
                return "An expected range in an individual during the luteal stage of the cycle.";
            }
            case POSTMEOPAUSAL: {
                return "An expected range in an individual post-menopause.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case TYPE: {
                return "Type";
            }
            case NORMAL: {
                return "Normal Range";
            }
            case RECOMMENDED: {
                return "Recommended Range";
            }
            case TREATMENT: {
                return "Treatment Range";
            }
            case THERAPEUTIC: {
                return "Therapeutic Desired Level";
            }
            case PRE: {
                return "Pre Therapeutic Desired Level";
            }
            case POST: {
                return "Post Therapeutic Desired Level";
            }
            case ENDOCRINE: {
                return "Endocrine";
            }
            case PREPUBERTY: {
                return "Pre-Puberty";
            }
            case FOLLICULAR: {
                return "Follicular Stage";
            }
            case MIDCYCLE: {
                return "MidCycle";
            }
            case LUTEAL: {
                return "Luteal";
            }
            case POSTMEOPAUSAL: {
                return "Post-Menopause";
            }
        }
        return "?";
    }
}

