/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ResearchSubjectStatus {
    CANDIDATE,
    ENROLLED,
    ACTIVE,
    SUSPENDED,
    WITHDRAWN,
    COMPLETED,
    NULL;


    public static ResearchSubjectStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("candidate".equals(codeString)) {
            return CANDIDATE;
        }
        if ("enrolled".equals(codeString)) {
            return ENROLLED;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("suspended".equals(codeString)) {
            return SUSPENDED;
        }
        if ("withdrawn".equals(codeString)) {
            return WITHDRAWN;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        throw new FHIRException("Unknown ResearchSubjectStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CANDIDATE: {
                return "candidate";
            }
            case ENROLLED: {
                return "enrolled";
            }
            case ACTIVE: {
                return "active";
            }
            case SUSPENDED: {
                return "suspended";
            }
            case WITHDRAWN: {
                return "withdrawn";
            }
            case COMPLETED: {
                return "completed";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/research-subject-status";
    }

    public String getDefinition() {
        switch (this) {
            case CANDIDATE: {
                return "The subject has been identified as a potential participant in the study but has not yet agreed to participate";
            }
            case ENROLLED: {
                return "The subject has agreed to participate in the study but has not yet begun performing any action within the study";
            }
            case ACTIVE: {
                return "The subject is currently being monitored and/or subject to treatment as part of the study";
            }
            case SUSPENDED: {
                return "The subject has temporarily discontinued monitoring/treatment as part of the study";
            }
            case WITHDRAWN: {
                return "The subject has permanently ended participation in the study prior to completion of the intended monitoring/treatment";
            }
            case COMPLETED: {
                return "All intended monitoring/treatment of the subject has been completed and their engagement with the study is now ended";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CANDIDATE: {
                return "Candidate";
            }
            case ENROLLED: {
                return "Enrolled";
            }
            case ACTIVE: {
                return "Active";
            }
            case SUSPENDED: {
                return "Suspended";
            }
            case WITHDRAWN: {
                return "Withdrawn";
            }
            case COMPLETED: {
                return "Completed";
            }
        }
        return "?";
    }
}

