/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.SpecificationType;

public class SpecificationTypeEnumFactory
implements EnumFactory<SpecificationType> {
    @Override
    public SpecificationType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("unspecified".equals(codeString)) {
            return SpecificationType.UNSPECIFIED;
        }
        if ("serial-number".equals(codeString)) {
            return SpecificationType.SERIALNUMBER;
        }
        if ("part-number".equals(codeString)) {
            return SpecificationType.PARTNUMBER;
        }
        if ("hardware-revision".equals(codeString)) {
            return SpecificationType.HARDWAREREVISION;
        }
        if ("software-revision".equals(codeString)) {
            return SpecificationType.SOFTWAREREVISION;
        }
        if ("firmware-revision".equals(codeString)) {
            return SpecificationType.FIRMWAREREVISION;
        }
        if ("protocol-revision".equals(codeString)) {
            return SpecificationType.PROTOCOLREVISION;
        }
        if ("gmdn".equals(codeString)) {
            return SpecificationType.GMDN;
        }
        throw new IllegalArgumentException("Unknown SpecificationType code '" + codeString + "'");
    }

    @Override
    public String toCode(SpecificationType code) {
        if (code == SpecificationType.UNSPECIFIED) {
            return "unspecified";
        }
        if (code == SpecificationType.SERIALNUMBER) {
            return "serial-number";
        }
        if (code == SpecificationType.PARTNUMBER) {
            return "part-number";
        }
        if (code == SpecificationType.HARDWAREREVISION) {
            return "hardware-revision";
        }
        if (code == SpecificationType.SOFTWAREREVISION) {
            return "software-revision";
        }
        if (code == SpecificationType.FIRMWAREREVISION) {
            return "firmware-revision";
        }
        if (code == SpecificationType.PROTOCOLREVISION) {
            return "protocol-revision";
        }
        if (code == SpecificationType.GMDN) {
            return "gmdn";
        }
        return "?";
    }

    @Override
    public String toSystem(SpecificationType code) {
        return code.getSystem();
    }
}

