/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum TestscriptProfileOriginTypes {
    FHIRCLIENT,
    FHIRSDCFORMFILLER,
    NULL;


    public static TestscriptProfileOriginTypes fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("FHIR-Client".equals(codeString)) {
            return FHIRCLIENT;
        }
        if ("FHIR-SDC-FormFiller".equals(codeString)) {
            return FHIRSDCFORMFILLER;
        }
        throw new FHIRException("Unknown TestscriptProfileOriginTypes code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case FHIRCLIENT: {
                return "FHIR-Client";
            }
            case FHIRSDCFORMFILLER: {
                return "FHIR-SDC-FormFiller";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/testscript-profile-origin-types";
    }

    public String getDefinition() {
        switch (this) {
            case FHIRCLIENT: {
                return "General FHIR client used to initiate operations against a FHIR server.";
            }
            case FHIRSDCFORMFILLER: {
                return "A FHIR client acting as a Structured Data Capture Form Filler.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case FHIRCLIENT: {
                return "FHIR Client";
            }
            case FHIRSDCFORMFILLER: {
                return "FHIR SDC FormFiller";
            }
        }
        return "?";
    }
}

