/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.ExpressionNode;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.utils.FHIRPathEngine;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.graphql.Argument;
import org.hl7.fhir.utilities.graphql.Directive;
import org.hl7.fhir.utilities.graphql.EGraphEngine;
import org.hl7.fhir.utilities.graphql.EGraphQLException;
import org.hl7.fhir.utilities.graphql.Field;
import org.hl7.fhir.utilities.graphql.Fragment;
import org.hl7.fhir.utilities.graphql.IGraphQLStorageServices;
import org.hl7.fhir.utilities.graphql.NameValue;
import org.hl7.fhir.utilities.graphql.NumberValue;
import org.hl7.fhir.utilities.graphql.ObjectValue;
import org.hl7.fhir.utilities.graphql.Operation;
import org.hl7.fhir.utilities.graphql.Package;
import org.hl7.fhir.utilities.graphql.ReferenceResolution;
import org.hl7.fhir.utilities.graphql.Selection;
import org.hl7.fhir.utilities.graphql.StringValue;
import org.hl7.fhir.utilities.graphql.Value;
import org.hl7.fhir.utilities.graphql.Variable;
import org.hl7.fhir.utilities.graphql.VariableValue;

public class GraphQLEngine {
    private IWorkerContext context;
    private Object appInfo;
    private Resource focus;
    private Package graphQL;
    private ObjectValue output;
    private IGraphQLStorageServices<Resource, Reference, Bundle> services;
    private Map<String, Argument> workingVariables = new HashMap<String, Argument>();

    public GraphQLEngine(IWorkerContext context) {
        this.context = context;
    }

    public void execute() throws EGraphEngine, EGraphQLException, FHIRException {
        if (this.graphQL == null) {
            throw new EGraphEngine("Unable to process graphql - graphql document missing");
        }
        this.output = new ObjectValue();
        Operation op = null;
        if (!Utilities.noString((String)this.graphQL.getOperationName())) {
            op = this.graphQL.getDocument().operation(this.graphQL.getOperationName());
            if (op == null) {
                throw new EGraphEngine("Unable to find operation \"" + this.graphQL.getOperationName() + "\"");
            }
        } else if (this.graphQL.getDocument().getOperations().size() == 1) {
            op = (Operation)this.graphQL.getDocument().getOperations().get(0);
        } else {
            throw new EGraphQLException("No operation name provided, so expected to find a single operation");
        }
        if (op.getOperationType() == Operation.OperationType.qglotMutation) {
            throw new EGraphQLException("Mutation operations are not supported (yet)");
        }
        this.checkNoDirectives(op.getDirectives());
        this.processVariables(op);
        if (this.focus == null) {
            this.processSearch(this.output, op.getSelectionSet());
        } else {
            this.processObject(this.focus, this.focus, this.output, op.getSelectionSet());
        }
    }

    private boolean checkBooleanDirective(Directive dir) throws EGraphQLException {
        if (dir.getArguments().size() != 1) {
            throw new EGraphQLException("Unable to process @" + dir.getName() + ": expected a single argument \"if\"");
        }
        if (!((Argument)dir.getArguments().get(0)).getName().equals("if")) {
            throw new EGraphQLException("Unable to process @" + dir.getName() + ": expected a single argument \"if\"");
        }
        List<Value> vl = this.resolveValues((Argument)dir.getArguments().get(0), 1);
        return vl.get(0).toString().equals("true");
    }

    private boolean checkDirectives(List<Directive> directives) throws EGraphQLException {
        Directive skip = null;
        Directive include = null;
        for (Directive dir : directives) {
            if (dir.getName().equals("skip")) {
                if (skip == null) {
                    skip = dir;
                    continue;
                }
                throw new EGraphQLException("Duplicate @skip directives");
            }
            if (dir.getName().equals("include")) {
                if (include == null) {
                    include = dir;
                    continue;
                }
                throw new EGraphQLException("Duplicate @include directives");
            }
            throw new EGraphQLException("Directive \"" + dir.getName() + "\" instanceof not recognised");
        }
        if (skip != null && include != null) {
            throw new EGraphQLException("Cannot mix @skip and @include directives");
        }
        if (skip != null) {
            return !this.checkBooleanDirective(skip);
        }
        if (include != null) {
            return this.checkBooleanDirective(include);
        }
        return true;
    }

    private void checkNoDirectives(List<Directive> directives) {
    }

    private boolean targetTypeOk(List<Argument> arguments, Resource dest) throws EGraphQLException {
        ArrayList<String> list = new ArrayList<String>();
        for (Argument arg : arguments) {
            if (!arg.getName().equals("type")) continue;
            List<Value> vl = this.resolveValues(arg);
            for (Value v : vl) {
                list.add(v.toString());
            }
        }
        if (list.size() == 0) {
            return true;
        }
        return list.indexOf(dest.fhirType()) > -1;
    }

    private boolean hasExtensions(Base obj) {
        if (obj instanceof BackboneElement) {
            return ((BackboneElement)obj).getExtension().size() > 0 || ((BackboneElement)obj).getModifierExtension().size() > 0;
        }
        if (obj instanceof DomainResource) {
            return ((DomainResource)obj).getExtension().size() > 0 || ((DomainResource)obj).getModifierExtension().size() > 0;
        }
        if (obj instanceof Element) {
            return ((Element)obj).getExtension().size() > 0;
        }
        return false;
    }

    private boolean passesExtensionMode(Base obj, boolean extensionMode) {
        if (!obj.isPrimitive()) {
            return !extensionMode;
        }
        if (extensionMode) {
            return !Utilities.noString((String)obj.getIdBase()) || this.hasExtensions(obj);
        }
        return obj.primitiveValue() != "";
    }

    private List<Base> filter(Resource context, Property prop, List<Argument> arguments, List<Base> values, boolean extensionMode) throws FHIRException, EGraphQLException {
        ArrayList<Base> result;
        block9: {
            result = new ArrayList<Base>();
            if (values.size() <= 0) break block9;
            StringBuilder fp = new StringBuilder();
            for (Argument arg : arguments) {
                List<Value> vl = this.resolveValues(arg);
                if (vl.size() != 1) {
                    throw new EGraphQLException("Incorrect number of arguments");
                }
                if (values.get(0).isPrimitive()) {
                    throw new EGraphQLException("Attempt to use a filter (" + arg.getName() + ") on a primtive type (" + prop.getTypeCode() + ")");
                }
                if (arg.getName().equals("fhirpath")) {
                    fp.append(" and " + vl.get(0).toString());
                    continue;
                }
                Property p = values.get(0).getNamedProperty(arg.getName());
                if (p == null) {
                    throw new EGraphQLException("Attempt to use an unknown filter (" + arg.getName() + ") on a type (" + prop.getTypeCode() + ")");
                }
                fp.append(" and " + arg.getName() + " = '" + vl.get(0).toString() + "'");
            }
            if (fp.length() == 0) {
                for (Base v : values) {
                    if (!this.passesExtensionMode(v, extensionMode)) continue;
                    result.add(v);
                }
            } else {
                FHIRPathEngine fpe = new FHIRPathEngine(this.context);
                ExpressionNode node = fpe.parse(fp.toString().substring(5));
                for (Base v : values) {
                    if (!this.passesExtensionMode(v, extensionMode) || !fpe.evaluateToBoolean(null, context, v, node)) continue;
                    result.add(v);
                }
            }
        }
        return result;
    }

    private List<Resource> filterResources(Argument fhirpath, Bundle bnd) throws EGraphQLException, FHIRException {
        ArrayList<Resource> result;
        block4: {
            result = new ArrayList<Resource>();
            if (bnd.getEntry().size() <= 0) break block4;
            if (fhirpath == null) {
                for (Bundle.BundleEntryComponent be : bnd.getEntry()) {
                    result.add(be.getResource());
                }
            } else {
                FHIRPathEngine fpe = new FHIRPathEngine(this.context);
                ExpressionNode node = fpe.parse(this.getSingleValue(fhirpath));
                for (Bundle.BundleEntryComponent be : bnd.getEntry()) {
                    if (!fpe.evaluateToBoolean(null, be.getResource(), be.getResource(), node)) continue;
                    result.add(be.getResource());
                }
            }
        }
        return result;
    }

    private List<Resource> filterResources(Argument fhirpath, List<Resource> list) throws EGraphQLException, FHIRException {
        ArrayList<Resource> result;
        block4: {
            result = new ArrayList<Resource>();
            if (list.size() <= 0) break block4;
            if (fhirpath == null) {
                for (Resource v : list) {
                    result.add(v);
                }
            } else {
                FHIRPathEngine fpe = new FHIRPathEngine(this.context);
                ExpressionNode node = fpe.parse(this.getSingleValue(fhirpath));
                for (Resource v : list) {
                    if (!fpe.evaluateToBoolean(null, v, v, node)) continue;
                    result.add(v);
                }
            }
        }
        return result;
    }

    private boolean hasArgument(List<Argument> arguments, String name, String value) {
        for (Argument arg : arguments) {
            if (!arg.getName().equals(name) || !arg.hasValue(value)) continue;
            return true;
        }
        return false;
    }

    private void processValues(Resource context, Selection sel, Property prop, ObjectValue target, List<Base> values, boolean extensionMode) throws EGraphQLException, FHIRException {
        Argument arg = target.addField(sel.getField().getAlias(), prop.isList());
        for (Base value : values) {
            if (value.isPrimitive() && !extensionMode) {
                if (!sel.getField().getSelectionSet().isEmpty()) {
                    throw new EGraphQLException("Encountered a selection set on a scalar field type");
                }
                this.processPrimitive(arg, value);
                continue;
            }
            if (sel.getField().getSelectionSet().isEmpty()) {
                throw new EGraphQLException("No Fields selected on a complex object");
            }
            ObjectValue n = new ObjectValue();
            arg.addValue((Value)n);
            this.processObject(context, value, n, sel.getField().getSelectionSet());
        }
    }

    private void processVariables(Operation op) throws EGraphQLException {
        for (Variable varRef : op.getVariables()) {
            Argument varDef = null;
            for (Argument v : this.graphQL.getVariables()) {
                if (!v.getName().equals(varRef.getName())) continue;
                varDef = v;
            }
            if (varDef != null) {
                this.workingVariables.put(varRef.getName(), varDef);
                continue;
            }
            if (varRef.getDefaultValue() != null) {
                this.workingVariables.put(varRef.getName(), new Argument(varRef.getName(), varRef.getDefaultValue()));
                continue;
            }
            throw new EGraphQLException("No value found for variable ");
        }
    }

    private boolean isPrimitive(String typename) {
        return Utilities.existsInList((String)typename, (String[])new String[]{"boolean", "integer", "string", "decimal", "uri", "base64Binary", "instant", "date", "dateTime", "time", "code", "oid", "id", "markdown", "unsignedInt", "positiveInt"});
    }

    private boolean isResourceName(String name, String suffix) {
        if (!name.endsWith(suffix)) {
            return false;
        }
        name = name.substring(0, name.length() - suffix.length());
        return this.context.getResourceNamesAsSet().contains(name);
    }

    private void processObject(Resource context, Base source, ObjectValue target, List<Selection> selection) throws EGraphQLException, FHIRException {
        for (Selection sel : selection) {
            if (sel.getField() != null) {
                if (!this.checkDirectives(sel.getField().getDirectives())) continue;
                Property prop = source.getNamedProperty(sel.getField().getName());
                if (prop == null && sel.getField().getName().startsWith("_")) {
                    prop = source.getNamedProperty(sel.getField().getName().substring(1));
                }
                if (prop == null) {
                    if (sel.getField().getName().equals("resourceType") && source instanceof Resource) {
                        target.addField("resourceType", false).addValue((Value)new StringValue(source.fhirType()));
                        continue;
                    }
                    if (sel.getField().getName().equals("resource") && source.fhirType().equals("Reference")) {
                        this.processReference(context, source, sel.getField(), target);
                        continue;
                    }
                    if (this.isResourceName(sel.getField().getName(), "List") && source instanceof Resource) {
                        this.processReverseReferenceList((Resource)source, sel.getField(), target);
                        continue;
                    }
                    if (this.isResourceName(sel.getField().getName(), "Connection") && source instanceof Resource) {
                        this.processReverseReferenceSearch((Resource)source, sel.getField(), target);
                        continue;
                    }
                    throw new EGraphQLException("Unknown property " + sel.getField().getName() + " on " + source.fhirType());
                }
                if (!this.isPrimitive(prop.getTypeCode()) && sel.getField().getName().startsWith("_")) {
                    throw new EGraphQLException("Unknown property " + sel.getField().getName() + " on " + source.fhirType());
                }
                List<Base> vl = this.filter(context, prop, sel.getField().getArguments(), prop.getValues(), sel.getField().getName().startsWith("_"));
                if (vl.isEmpty()) continue;
                this.processValues(context, sel, prop, target, vl, sel.getField().getName().startsWith("_"));
                continue;
            }
            if (sel.getInlineFragment() != null) {
                if (!this.checkDirectives(sel.getInlineFragment().getDirectives())) continue;
                if (Utilities.noString((String)sel.getInlineFragment().getTypeCondition())) {
                    throw new EGraphQLException("Not done yet - inline fragment with no type condition");
                }
                if (!source.fhirType().equals(sel.getInlineFragment().getTypeCondition())) continue;
                this.processObject(context, source, target, sel.getInlineFragment().getSelectionSet());
                continue;
            }
            if (!this.checkDirectives(sel.getFragmentSpread().getDirectives())) continue;
            Fragment fragment = this.graphQL.getDocument().fragment(sel.getFragmentSpread().getName());
            if (fragment == null) {
                throw new EGraphQLException("Unable to resolve fragment " + sel.getFragmentSpread().getName());
            }
            if (Utilities.noString((String)fragment.getTypeCondition())) {
                throw new EGraphQLException("Not done yet - inline fragment with no type condition");
            }
            if (!source.fhirType().equals(fragment.getTypeCondition())) continue;
            this.processObject(context, source, target, fragment.getSelectionSet());
        }
    }

    private void processPrimitive(Argument arg, Base value) {
        String s = value.fhirType();
        if (s.equals("integer") || s.equals("decimal") || s.equals("unsignedInt") || s.equals("positiveInt")) {
            arg.addValue((Value)new NumberValue(value.primitiveValue()));
        } else if (s.equals("boolean")) {
            arg.addValue((Value)new NameValue(value.primitiveValue()));
        } else {
            arg.addValue((Value)new StringValue(value.primitiveValue()));
        }
    }

    private void processReference(Resource context, Base source, Field field, ObjectValue target) throws EGraphQLException, FHIRException {
        if (!(source instanceof Reference)) {
            throw new EGraphQLException("Not done yet");
        }
        if (this.services == null) {
            throw new EGraphQLException("Resource Referencing services not provided");
        }
        Reference ref = (Reference)source;
        ReferenceResolution res = this.services.lookup(this.appInfo, (IAnyResource)context, (IBaseReference)ref);
        if (res != null) {
            if (this.targetTypeOk(field.getArguments(), (Resource)res.getTarget())) {
                Argument arg = target.addField(field.getAlias(), false);
                ObjectValue obj = new ObjectValue();
                arg.addValue((Value)obj);
                this.processObject((Resource)res.getTargetContext(), (Base)res.getTarget(), obj, field.getSelectionSet());
            }
        } else if (!this.hasArgument(field.getArguments(), "optional", "true")) {
            throw new EGraphQLException("Unable to resolve reference to " + ref.getReference());
        }
    }

    private void processReverseReferenceList(Resource source, Field field, ObjectValue target) throws EGraphQLException, FHIRException {
        if (this.services == null) {
            throw new EGraphQLException("Resource Referencing services not provided");
        }
        ArrayList<Resource> list = new ArrayList<Resource>();
        ArrayList<Argument> params = new ArrayList<Argument>();
        Argument parg = null;
        for (Argument a : field.getArguments()) {
            if (!a.getName().equals("_reference")) {
                params.add(a);
                continue;
            }
            if (parg == null) {
                parg = a;
                continue;
            }
            throw new EGraphQLException("Duplicate parameter _reference");
        }
        if (parg == null) {
            throw new EGraphQLException("Missing parameter _reference");
        }
        Argument arg = new Argument();
        params.add(arg);
        arg.setName(this.getSingleValue(parg));
        arg.addValue((Value)new StringValue(source.fhirType() + "/" + source.getId()));
        this.services.listResources(this.appInfo, field.getName().substring(0, field.getName().length() - 4), params, list);
        arg = null;
        ObjectValue obj = null;
        List<Resource> vl = this.filterResources(field.argument("fhirpath"), list);
        if (!vl.isEmpty()) {
            arg = target.addField(field.getAlias(), true);
            for (Resource v : vl) {
                obj = new ObjectValue();
                arg.addValue((Value)obj);
                this.processObject(v, v, obj, field.getSelectionSet());
            }
        }
    }

    private void processReverseReferenceSearch(Resource source, Field field, ObjectValue target) throws EGraphQLException, FHIRException {
        if (this.services == null) {
            throw new EGraphQLException("Resource Referencing services not provided");
        }
        ArrayList<Argument> params = new ArrayList<Argument>();
        Argument parg = null;
        for (Argument a : field.getArguments()) {
            if (!a.getName().equals("_reference")) {
                params.add(a);
                continue;
            }
            if (parg == null) {
                parg = a;
                continue;
            }
            throw new EGraphQLException("Duplicate parameter _reference");
        }
        if (parg == null) {
            throw new EGraphQLException("Missing parameter _reference");
        }
        Argument arg = new Argument();
        params.add(arg);
        arg.setName(this.getSingleValue(parg));
        arg.addValue((Value)new StringValue(source.fhirType() + "/" + source.getId()));
        Bundle bnd = (Bundle)this.services.search(this.appInfo, field.getName().substring(0, field.getName().length() - 10), params);
        SearchWrapper bndWrapper = new SearchWrapper(field.getName(), bnd);
        arg = target.addField(field.getAlias(), false);
        ObjectValue obj = new ObjectValue();
        arg.addValue((Value)obj);
        this.processObject(null, bndWrapper, obj, field.getSelectionSet());
    }

    private void processSearch(ObjectValue target, List<Selection> selection) throws EGraphQLException, FHIRException {
        for (Selection sel : selection) {
            if (sel.getField() == null) {
                throw new EGraphQLException("Only field selections are allowed in this context");
            }
            this.checkNoDirectives(sel.getField().getDirectives());
            if (this.isResourceName(sel.getField().getName(), "")) {
                this.processSearchSingle(target, sel.getField());
                continue;
            }
            if (this.isResourceName(sel.getField().getName(), "List")) {
                this.processSearchSimple(target, sel.getField());
                continue;
            }
            if (!this.isResourceName(sel.getField().getName(), "Connection")) continue;
            this.processSearchFull(target, sel.getField());
        }
    }

    private void processSearchSingle(ObjectValue target, Field field) throws EGraphQLException, FHIRException {
        Argument arg2;
        if (this.services == null) {
            throw new EGraphQLException("Resource Referencing services not provided");
        }
        String id = "";
        for (Argument arg2 : field.getArguments()) {
            if (arg2.getName().equals("id")) {
                id = this.getSingleValue(arg2);
                continue;
            }
            throw new EGraphQLException("Unknown/invalid parameter " + arg2.getName());
        }
        if (Utilities.noString((String)id)) {
            throw new EGraphQLException("No id found");
        }
        Resource res = (Resource)this.services.lookup(this.appInfo, field.getName(), id);
        if (res == null) {
            throw new EGraphQLException("Resource " + field.getName() + "/" + id + " not found");
        }
        arg2 = target.addField(field.getAlias(), false);
        ObjectValue obj = new ObjectValue();
        arg2.addValue((Value)obj);
        this.processObject(res, res, obj, field.getSelectionSet());
    }

    private void processSearchSimple(ObjectValue target, Field field) throws EGraphQLException, FHIRException {
        if (this.services == null) {
            throw new EGraphQLException("Resource Referencing services not provided");
        }
        ArrayList<Resource> list = new ArrayList<Resource>();
        this.services.listResources(this.appInfo, field.getName().substring(0, field.getName().length() - 4), field.getArguments(), list);
        Argument arg = null;
        ObjectValue obj = null;
        List<Resource> vl = this.filterResources(field.argument("fhirpath"), list);
        if (!vl.isEmpty()) {
            arg = target.addField(field.getAlias(), true);
            for (Resource v : vl) {
                obj = new ObjectValue();
                arg.addValue((Value)obj);
                this.processObject(v, v, obj, field.getSelectionSet());
            }
        }
    }

    private void processSearchFull(ObjectValue target, Field field) throws EGraphQLException, FHIRException {
        if (this.services == null) {
            throw new EGraphQLException("Resource Referencing services not provided");
        }
        ArrayList<Argument> params = new ArrayList<Argument>();
        Argument carg = null;
        for (Argument arg : field.getArguments()) {
            if (arg.getName().equals("cursor")) {
                carg = arg;
                continue;
            }
            params.add(arg);
        }
        if (carg != null) {
            params.clear();
            String[] parts = this.getSingleValue(carg).split(":");
            params.add(new Argument("search-id", (Value)new StringValue(parts[0])));
            params.add(new Argument("search-offset", (Value)new StringValue(parts[1])));
        }
        Bundle bnd = (Bundle)this.services.search(this.appInfo, field.getName().substring(0, field.getName().length() - 10), params);
        SearchWrapper bndWrapper = new SearchWrapper(field.getName(), bnd);
        Argument arg = target.addField(field.getAlias(), false);
        ObjectValue obj = new ObjectValue();
        arg.addValue((Value)obj);
        this.processObject(null, bndWrapper, obj, field.getSelectionSet());
    }

    private String getSingleValue(Argument arg) throws EGraphQLException {
        List<Value> vl = this.resolveValues(arg, 1);
        if (vl.size() == 0) {
            return "";
        }
        return vl.get(0).toString();
    }

    private List<Value> resolveValues(Argument arg) throws EGraphQLException {
        return this.resolveValues(arg, -1, "");
    }

    private List<Value> resolveValues(Argument arg, int max) throws EGraphQLException {
        return this.resolveValues(arg, max, "");
    }

    private List<Value> resolveValues(Argument arg, int max, String vars) throws EGraphQLException {
        ArrayList<Value> result = new ArrayList<Value>();
        for (Value v : arg.getValues()) {
            if (!(v instanceof VariableValue)) {
                result.add(v);
                continue;
            }
            if (vars.contains(":" + v.toString() + ":")) {
                throw new EGraphQLException("Recursive reference to variable " + v.toString());
            }
            Argument a = this.workingVariables.get(v.toString());
            if (a == null) {
                throw new EGraphQLException("No value found for variable \"" + v.toString() + "\" in \"" + arg.getName() + "\"");
            }
            List<Value> vl = this.resolveValues(a, -1, vars + ":" + v.toString() + ":");
            result.addAll(vl);
        }
        if (max != -1 && result.size() > max) {
            throw new EGraphQLException("Only " + Integer.toString(max) + " values are allowed for \"" + arg.getName() + "\", but " + Integer.toString(result.size()) + " enoucntered");
        }
        return result;
    }

    public Object getAppInfo() {
        return this.appInfo;
    }

    public void setAppInfo(Object appInfo) {
        this.appInfo = appInfo;
    }

    public Resource getFocus() {
        return this.focus;
    }

    public void setFocus(Resource focus) {
        this.focus = focus;
    }

    public Package getGraphQL() {
        return this.graphQL;
    }

    public void setGraphQL(Package graphQL) {
        this.graphQL = graphQL;
    }

    public ObjectValue getOutput() {
        return this.output;
    }

    public IGraphQLStorageServices getServices() {
        return this.services;
    }

    public void setServices(IGraphQLStorageServices services) {
        this.services = services;
    }

    public class SearchWrapper
    extends Base {
        private Bundle bnd;
        private String type;
        private Map<String, String> map;

        public SearchWrapper(String type, Bundle bnd) throws FHIRException {
            this.type = type;
            this.bnd = bnd;
            for (Bundle.BundleLinkComponent bl : bnd.getLink()) {
                if (!bl.getRelation().equals("self")) continue;
                this.map = this.parseURL(bl.getUrl());
            }
        }

        @Override
        public String fhirType() {
            return this.type;
        }

        @Override
        protected void listChildren(List<Property> result) {
            throw new Error("Not Implemented");
        }

        @Override
        public String getIdBase() {
            throw new Error("Not Implemented");
        }

        @Override
        public void setIdBase(String value) {
            throw new Error("Not Implemented");
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 97440432: {
                    return new Property(_name, "string", "n/a", 0, 1, this.extractLink(_name));
                }
                case -1273775369: {
                    return new Property(_name, "string", "n/a", 0, 1, this.extractLink(_name));
                }
                case 3377907: {
                    return new Property(_name, "string", "n/a", 0, 1, this.extractLink(_name));
                }
                case 3314326: {
                    return new Property(_name, "string", "n/a", 0, 1, this.extractLink(_name));
                }
                case 94851343: {
                    return new Property(_name, "integer", "n/a", 0, 1, this.bnd.getTotalElement());
                }
                case -1019779949: {
                    return new Property(_name, "integer", "n/a", 0, 1, this.extractParam("search-offset"));
                }
                case 860381968: {
                    return new Property(_name, "integer", "n/a", 0, 1, this.extractParam("_count"));
                }
                case 96356950: {
                    return new Property(_name, "edge", "n/a", 0, Integer.MAX_VALUE, this.getEdges());
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        private List<Base> getEdges() {
            ArrayList<Base> list = new ArrayList<Base>();
            for (Bundle.BundleEntryComponent be : this.bnd.getEntry()) {
                list.add(new SearchEdge(this.type.substring(0, this.type.length() - 10) + "Edge", be));
            }
            return list;
        }

        private Base extractParam(String name) throws FHIRException {
            return this.map != null ? new IntegerType(this.map.get(name)) : null;
        }

        private Map<String, String> parseURL(String url) throws FHIRException {
            try {
                String[] pairs;
                HashMap<String, String> map = new HashMap<String, String>();
                for (String pair : pairs = url.split("&")) {
                    int idx = pair.indexOf("=");
                    String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
                    String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
                    map.put(key, value);
                }
                return map;
            }
            catch (UnsupportedEncodingException e) {
                throw new FHIRException((Throwable)e);
            }
        }

        private Base extractLink(String _name) throws FHIRException {
            for (Bundle.BundleLinkComponent bl : this.bnd.getLink()) {
                if (!bl.getRelation().equals(_name)) continue;
                Map<String, String> map = this.parseURL(bl.getUrl());
                return new StringType(map.get("search-id") + ':' + map.get("search-offset"));
            }
            return null;
        }
    }

    public class SearchEdge
    extends Base {
        private Bundle.BundleEntryComponent be;
        private String type;

        public SearchEdge(String type, Bundle.BundleEntryComponent be) {
            this.type = type;
            this.be = be;
        }

        @Override
        public String fhirType() {
            return this.type;
        }

        @Override
        protected void listChildren(List<Property> result) {
            throw new Error("Not Implemented");
        }

        @Override
        public String getIdBase() {
            throw new Error("Not Implemented");
        }

        @Override
        public void setIdBase(String value) {
            throw new Error("Not Implemented");
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 0x3339A3: {
                    return new Property(_name, "string", "n/a", 0, 1, this.be.getSearch().hasMode() ? this.be.getSearch().getModeElement() : null);
                }
                case 109264530: {
                    return new Property(_name, "string", "n/a", 0, 1, this.be.getSearch().hasScore() ? this.be.getSearch().getScoreElement() : null);
                }
                case -341064690: {
                    return new Property(_name, "resource", "n/a", 0, 1, this.be.hasResource() ? this.be.getResource() : null);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }
    }
}

