package org.hl7.fhir.r4.formats;

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Sat, Sep 23, 2017 17:56-0400 for FHIR v3.1.0

import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.OidType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UuidType;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.*;
import org.xmlpull.v1.*;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.FHIRException;
import java.io.IOException;

public class XmlParser extends XmlParserBase {

  public XmlParser() {
    super();
  }

  public XmlParser(boolean allowUnknownContent) {
    super();
    setAllowUnknownContent(allowUnknownContent);
  }


  protected boolean parseElementContent(int eventType, XmlPullParser xpp, Element res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("extension")) 
      res.getExtension().add(parseExtension(xpp));
    else
      return false;
      
    return true;
  }

  protected boolean parseBackboneContent(int eventType, XmlPullParser xpp, BackboneElement res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifierExtension")) 
      res.getModifierExtension().add(parseExtension(xpp));
    else
      return parseElementContent(eventType, xpp, res);
      
    return true;
  }

  @SuppressWarnings("unchecked")
  protected <E extends Enum<E>> Enumeration<E> parseEnumeration(XmlPullParser xpp, E item, EnumFactory e) throws XmlPullParserException, IOException, FHIRFormatError {
    Enumeration<E> res = new Enumeration<E>(e);
    parseElementAttributes(xpp, res);
    res.setValue((E) e.fromCode(xpp.getAttributeValue(null, "value")));
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected DateType parseDate(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DateType res = new DateType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected DateTimeType parseDateTime(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DateTimeType res = new DateTimeType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected CodeType parseCode(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeType res = new CodeType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected StringType parseString(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    StringType res = new StringType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected IntegerType parseInteger(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    IntegerType res = new IntegerType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected OidType parseOid(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    OidType res = new OidType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected UriType parseUri(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    UriType res = new UriType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected UuidType parseUuid(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    UuidType res = new UuidType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected InstantType parseInstant(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    InstantType res = new InstantType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected BooleanType parseBoolean(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    BooleanType res = new BooleanType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected Base64BinaryType parseBase64Binary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Base64BinaryType res = new Base64BinaryType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected UnsignedIntType parseUnsignedInt(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    UnsignedIntType res = new UnsignedIntType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected MarkdownType parseMarkdown(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MarkdownType res = new MarkdownType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected TimeType parseTime(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    TimeType res = new TimeType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected IdType parseId(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    IdType res = new IdType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected PositiveIntType parsePositiveInt(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    PositiveIntType res = new PositiveIntType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected DecimalType parseDecimal(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DecimalType res = new DecimalType(xpp.getAttributeValue(null, "value"));
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
      if (!parseElementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected Extension parseExtension(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Extension res = new Extension();
    parseElementAttributes(xpp, res);
    if (xpp.getAttributeValue(null, "url") != null)
        res.setUrl(xpp.getAttributeValue(null, "url"));
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExtensionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExtensionContent(int eventType, XmlPullParser xpp, Extension res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Narrative parseNarrative(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Narrative res = new Narrative();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNarrativeContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNarrativeContent(int eventType, XmlPullParser xpp, Narrative res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Narrative.NarrativeStatus.NULL, new Narrative.NarrativeStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("div")) {
        res.setDiv(parseXhtml(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Reference parseReference(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Reference res = new Reference();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseReferenceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseReferenceContent(int eventType, XmlPullParser xpp, Reference res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReferenceElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
        res.setDisplayElement(parseString(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Quantity parseQuantity(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Quantity res = new Quantity();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseQuantityContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseQuantityContent(int eventType, XmlPullParser xpp, Quantity res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comparator")) {
        res.setComparatorElement(parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unit")) {
        res.setUnitElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
        res.setSystemElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Period parsePeriod(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Period res = new Period();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePeriodContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePeriodContent(int eventType, XmlPullParser xpp, Period res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
        res.setStartElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
        res.setEndElement(parseDateTime(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Attachment parseAttachment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Attachment res = new Attachment();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAttachmentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAttachmentContent(int eventType, XmlPullParser xpp, Attachment res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contentType")) {
        res.setContentTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguageElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("data")) {
        res.setDataElement(parseBase64Binary(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("size")) {
        res.setSizeElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hash")) {
        res.setHashElement(parseBase64Binary(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("creation")) {
        res.setCreationElement(parseDateTime(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Duration parseDuration(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Duration res = new Duration();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDurationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDurationContent(int eventType, XmlPullParser xpp, Duration res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (!parseQuantityContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Count parseCount(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Count res = new Count();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCountContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCountContent(int eventType, XmlPullParser xpp, Count res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (!parseQuantityContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Range parseRange(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Range res = new Range();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseRangeContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseRangeContent(int eventType, XmlPullParser xpp, Range res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("low")) {
        res.setLow(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("high")) {
        res.setHigh(parseSimpleQuantity(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Annotation parseAnnotation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Annotation res = new Annotation();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAnnotationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAnnotationContent(int eventType, XmlPullParser xpp, Annotation res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "author")) {
        res.setAuthor(parseType("author", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("time")) {
        res.setTimeElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Money parseMoney(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Money res = new Money();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMoneyContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMoneyContent(int eventType, XmlPullParser xpp, Money res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (!parseQuantityContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Identifier parseIdentifier(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Identifier res = new Identifier();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseIdentifierContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseIdentifierContent(int eventType, XmlPullParser xpp, Identifier res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUseElement(parseEnumeration(xpp, Identifier.IdentifierUse.NULL, new Identifier.IdentifierUseEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
        res.setSystemElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assigner")) {
        res.setAssigner(parseReference(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Coding parseCoding(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Coding res = new Coding();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCodingContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodingContent(int eventType, XmlPullParser xpp, Coding res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
        res.setSystemElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
        res.setDisplayElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("userSelected")) {
        res.setUserSelectedElement(parseBoolean(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Signature parseSignature(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Signature res = new Signature();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSignatureContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSignatureContent(int eventType, XmlPullParser xpp, Signature res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("when")) {
        res.setWhenElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "who")) {
        res.setWho(parseType("who", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "onBehalfOf")) {
        res.setOnBehalfOf(parseType("onBehalfOf", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contentType")) {
        res.setContentTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("blob")) {
        res.setBlobElement(parseBase64Binary(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected SampledData parseSampledData(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    SampledData res = new SampledData();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSampledDataContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSampledDataContent(int eventType, XmlPullParser xpp, SampledData res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("origin")) {
        res.setOrigin(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriodElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lowerLimit")) {
        res.setLowerLimitElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("upperLimit")) {
        res.setUpperLimitElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dimensions")) {
        res.setDimensionsElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("data")) {
        res.setDataElement(parseString(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Ratio parseRatio(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Ratio res = new Ratio();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseRatioContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseRatioContent(int eventType, XmlPullParser xpp, Ratio res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numerator")) {
        res.setNumerator(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("denominator")) {
        res.setDenominator(parseQuantity(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Distance parseDistance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Distance res = new Distance();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDistanceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDistanceContent(int eventType, XmlPullParser xpp, Distance res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (!parseQuantityContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Age parseAge(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Age res = new Age();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAgeContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAgeContent(int eventType, XmlPullParser xpp, Age res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (!parseQuantityContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CodeableConcept parseCodeableConcept(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeableConcept res = new CodeableConcept();
    parseTypeAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCodeableConceptContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeableConceptContent(int eventType, XmlPullParser xpp, CodeableConcept res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coding")) {
        res.getCoding().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected SimpleQuantity parseSimpleQuantity(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    SimpleQuantity res = new SimpleQuantity();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSimpleQuantityContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSimpleQuantityContent(int eventType, XmlPullParser xpp, SimpleQuantity res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comparator")) {
        res.setComparatorElement(parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unit")) {
        res.setUnitElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
        res.setSystemElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Meta parseMeta(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Meta res = new Meta();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMetaContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMetaContent(int eventType, XmlPullParser xpp, Meta res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("versionId")) {
        res.setVersionIdElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastUpdated")) {
        res.setLastUpdatedElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.getProfile().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("security")) {
        res.getSecurity().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("tag")) {
        res.getTag().add(parseCoding(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Address parseAddress(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Address res = new Address();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAddressContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAddressContent(int eventType, XmlPullParser xpp, Address res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUseElement(parseEnumeration(xpp, Address.AddressUse.NULL, new Address.AddressUseEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Address.AddressType.NULL, new Address.AddressTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("line")) {
        res.getLine().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("city")) {
        res.setCityElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("district")) {
        res.setDistrictElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("state")) {
        res.setStateElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("postalCode")) {
        res.setPostalCodeElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("country")) {
        res.setCountryElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TriggerDefinition parseTriggerDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    TriggerDefinition res = new TriggerDefinition();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTriggerDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTriggerDefinitionContent(int eventType, XmlPullParser xpp, TriggerDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, TriggerDefinition.TriggerType.NULL, new TriggerDefinition.TriggerTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "timing")) {
        res.setTiming(parseType("timing", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("data")) {
        res.setData(parseDataRequirement(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
        res.setCondition(parseTriggerDefinitionTriggerDefinitionConditionComponent(xpp, res));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TriggerDefinition.TriggerDefinitionConditionComponent parseTriggerDefinitionTriggerDefinitionConditionComponent(XmlPullParser xpp, TriggerDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TriggerDefinition.TriggerDefinitionConditionComponent res = new TriggerDefinition.TriggerDefinitionConditionComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTriggerDefinitionTriggerDefinitionConditionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTriggerDefinitionTriggerDefinitionConditionComponentContent(int eventType, XmlPullParser xpp, TriggerDefinition owner, TriggerDefinition.TriggerDefinitionConditionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguageElement(parseEnumeration(xpp, TriggerDefinition.ExpressionLanguage.NULL, new TriggerDefinition.ExpressionLanguageEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
        res.setExpressionElement(parseString(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contributor parseContributor(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contributor res = new Contributor();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContributorContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContributorContent(int eventType, XmlPullParser xpp, Contributor res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Contributor.ContributorType.NULL, new Contributor.ContributorTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DataRequirement parseDataRequirement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DataRequirement res = new DataRequirement();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDataRequirementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDataRequirementContent(int eventType, XmlPullParser xpp, DataRequirement res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.getProfile().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mustSupport")) {
        res.getMustSupport().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("codeFilter")) {
        res.getCodeFilter().add(parseDataRequirementDataRequirementCodeFilterComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateFilter")) {
        res.getDateFilter().add(parseDataRequirementDataRequirementDateFilterComponent(xpp, res));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DataRequirement.DataRequirementCodeFilterComponent parseDataRequirementDataRequirementCodeFilterComponent(XmlPullParser xpp, DataRequirement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DataRequirement.DataRequirementCodeFilterComponent res = new DataRequirement.DataRequirementCodeFilterComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDataRequirementDataRequirementCodeFilterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDataRequirementDataRequirementCodeFilterComponentContent(int eventType, XmlPullParser xpp, DataRequirement owner, DataRequirement.DataRequirementCodeFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "valueSet")) {
        res.setValueSet(parseType("valueSet", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.getCode().add(parseCoding(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DataRequirement.DataRequirementDateFilterComponent parseDataRequirementDataRequirementDateFilterComponent(XmlPullParser xpp, DataRequirement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DataRequirement.DataRequirementDateFilterComponent res = new DataRequirement.DataRequirementDateFilterComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDataRequirementDataRequirementDateFilterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDataRequirementDataRequirementDateFilterComponentContent(int eventType, XmlPullParser xpp, DataRequirement owner, DataRequirement.DataRequirementDateFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Dosage parseDosage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Dosage res = new Dosage();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDosageContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDosageContent(int eventType, XmlPullParser xpp, Dosage res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additionalInstruction")) {
        res.getAdditionalInstruction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patientInstruction")) {
        res.setPatientInstructionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("timing")) {
        res.setTiming(parseTiming(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "asNeeded")) {
        res.setAsNeeded(parseType("asNeeded", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("site")) {
        res.setSite(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("route")) {
        res.setRoute(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
        res.setMethod(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "dose")) {
        res.setDose(parseType("dose", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxDosePerPeriod")) {
        res.setMaxDosePerPeriod(parseRatio(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxDosePerAdministration")) {
        res.setMaxDosePerAdministration(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxDosePerLifetime")) {
        res.setMaxDosePerLifetime(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "rate")) {
        res.setRate(parseType("rate", xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected RelatedArtifact parseRelatedArtifact(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    RelatedArtifact res = new RelatedArtifact();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseRelatedArtifactContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseRelatedArtifactContent(int eventType, XmlPullParser xpp, RelatedArtifact res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, RelatedArtifact.RelatedArtifactType.NULL, new RelatedArtifact.RelatedArtifactTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
        res.setDisplayElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("citation")) {
        res.setCitationElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("document")) {
        res.setDocument(parseAttachment(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.setResource(parseReference(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ContactDetail parseContactDetail(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ContactDetail res = new ContactDetail();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContactDetailContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContactDetailContent(int eventType, XmlPullParser xpp, ContactDetail res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
        res.getTelecom().add(parseContactPoint(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected HumanName parseHumanName(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    HumanName res = new HumanName();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseHumanNameContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseHumanNameContent(int eventType, XmlPullParser xpp, HumanName res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUseElement(parseEnumeration(xpp, HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("family")) {
        res.setFamilyElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("given")) {
        res.getGiven().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prefix")) {
        res.getPrefix().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("suffix")) {
        res.getSuffix().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ContactPoint parseContactPoint(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ContactPoint res = new ContactPoint();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContactPointContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContactPointContent(int eventType, XmlPullParser xpp, ContactPoint res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
        res.setSystemElement(parseEnumeration(xpp, ContactPoint.ContactPointSystem.NULL, new ContactPoint.ContactPointSystemEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUseElement(parseEnumeration(xpp, ContactPoint.ContactPointUse.NULL, new ContactPoint.ContactPointUseEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rank")) {
        res.setRankElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected UsageContext parseUsageContext(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    UsageContext res = new UsageContext();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseUsageContextContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseUsageContextContent(int eventType, XmlPullParser xpp, UsageContext res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Timing parseTiming(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Timing res = new Timing();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTimingContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTimingContent(int eventType, XmlPullParser xpp, Timing res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("event")) {
        res.getEvent().add(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("repeat")) {
        res.setRepeat(parseTimingTimingRepeatComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Timing.TimingRepeatComponent parseTimingTimingRepeatComponent(XmlPullParser xpp, Timing owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTimingTimingRepeatComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTimingTimingRepeatComponentContent(int eventType, XmlPullParser xpp, Timing owner, Timing.TimingRepeatComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "bounds")) {
        res.setBounds(parseType("bounds", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("count")) {
        res.setCountElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("countMax")) {
        res.setCountMaxElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("duration")) {
        res.setDurationElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("durationMax")) {
        res.setDurationMaxElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("durationUnit")) {
        res.setDurationUnitElement(parseEnumeration(xpp, Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("frequency")) {
        res.setFrequencyElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("frequencyMax")) {
        res.setFrequencyMaxElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriodElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("periodMax")) {
        res.setPeriodMaxElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("periodUnit")) {
        res.setPeriodUnitElement(parseEnumeration(xpp, Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dayOfWeek")) {
        res.getDayOfWeek().add(parseEnumeration(xpp, Timing.DayOfWeek.NULL, new Timing.DayOfWeekEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("timeOfDay")) {
        res.getTimeOfDay().add(parseTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("when")) {
        res.getWhen().add(parseEnumeration(xpp, Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("offset")) {
        res.setOffsetElement(parseUnsignedInt(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ElementDefinition parseElementDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition res = new ElementDefinition();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseElementDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionContent(int eventType, XmlPullParser xpp, ElementDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("representation")) {
        res.getRepresentation().add(parseEnumeration(xpp, ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sliceName")) {
        res.setSliceNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("label")) {
        res.setLabelElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.getCode().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("slicing")) {
        res.setSlicing(parseElementDefinitionElementDefinitionSlicingComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("short")) {
        res.setShortElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinitionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requirements")) {
        res.setRequirementsElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("alias")) {
        res.getAlias().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("min")) {
        res.setMinElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("max")) {
        res.setMaxElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("base")) {
        res.setBase(parseElementDefinitionElementDefinitionBaseComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contentReference")) {
        res.setContentReferenceElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseElementDefinitionTypeRefComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "defaultValue")) {
        res.setDefaultValue(parseType("defaultValue", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("meaningWhenMissing")) {
        res.setMeaningWhenMissingElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("orderMeaning")) {
        res.setOrderMeaningElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "fixed")) {
        res.setFixed(parseType("fixed", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "pattern")) {
        res.setPattern(parseType("pattern", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("example")) {
        res.getExample().add(parseElementDefinitionElementDefinitionExampleComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "minValue")) {
        res.setMinValue(parseType("minValue", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "maxValue")) {
        res.setMaxValue(parseType("maxValue", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxLength")) {
        res.setMaxLengthElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
        res.getCondition().add(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("constraint")) {
        res.getConstraint().add(parseElementDefinitionElementDefinitionConstraintComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mustSupport")) {
        res.setMustSupportElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("isModifier")) {
        res.setIsModifierElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("isSummary")) {
        res.setIsSummaryElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("binding")) {
        res.setBinding(parseElementDefinitionElementDefinitionBindingComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mapping")) {
        res.getMapping().add(parseElementDefinitionElementDefinitionMappingComponent(xpp, res));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionElementDefinitionSlicingComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseElementDefinitionElementDefinitionSlicingComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionElementDefinitionSlicingComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionSlicingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("discriminator")) {
        res.getDiscriminator().add(parseElementDefinitionElementDefinitionSlicingDiscriminatorComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ordered")) {
        res.setOrderedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rules")) {
        res.setRulesElement(parseEnumeration(xpp, ElementDefinition.SlicingRules.NULL, new ElementDefinition.SlicingRulesEnumFactory()));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent parseElementDefinitionElementDefinitionSlicingDiscriminatorComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseElementDefinitionElementDefinitionSlicingDiscriminatorComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionElementDefinitionSlicingDiscriminatorComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, ElementDefinition.DiscriminatorType.NULL, new ElementDefinition.DiscriminatorTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionElementDefinitionBaseComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseElementDefinitionElementDefinitionBaseComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionElementDefinitionBaseComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionBaseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("min")) {
        res.setMinElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("max")) {
        res.setMaxElement(parseString(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseElementDefinitionTypeRefComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionTypeRefComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.TypeRefComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfileElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetProfile")) {
        res.setTargetProfileElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("aggregation")) {
        res.getAggregation().add(parseEnumeration(xpp, ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("versioning")) {
        res.setVersioningElement(parseEnumeration(xpp, ElementDefinition.ReferenceVersionRules.NULL, new ElementDefinition.ReferenceVersionRulesEnumFactory()));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ElementDefinition.ElementDefinitionExampleComponent parseElementDefinitionElementDefinitionExampleComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionExampleComponent res = new ElementDefinition.ElementDefinitionExampleComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseElementDefinitionElementDefinitionExampleComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionElementDefinitionExampleComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionExampleComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("label")) {
        res.setLabelElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionElementDefinitionConstraintComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseElementDefinitionElementDefinitionConstraintComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionElementDefinitionConstraintComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionConstraintComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("key")) {
        res.setKeyElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requirements")) {
        res.setRequirementsElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("severity")) {
        res.setSeverityElement(parseEnumeration(xpp, ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("human")) {
        res.setHumanElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
        res.setExpressionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("xpath")) {
        res.setXpathElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSourceElement(parseUri(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionElementDefinitionBindingComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseElementDefinitionElementDefinitionBindingComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionElementDefinitionBindingComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionBindingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("strength")) {
        res.setStrengthElement(parseEnumeration(xpp, Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "valueSet")) {
        res.setValueSet(parseType("valueSet", xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionElementDefinitionMappingComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseElementDefinitionElementDefinitionMappingComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseElementDefinitionElementDefinitionMappingComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionMappingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identity")) {
        res.setIdentityElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguageElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("map")) {
        res.setMapElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ParameterDefinition parseParameterDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ParameterDefinition res = new ParameterDefinition();
    parseElementAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseParameterDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseParameterDefinitionContent(int eventType, XmlPullParser xpp, ParameterDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUseElement(parseEnumeration(xpp, ParameterDefinition.ParameterUse.NULL, new ParameterDefinition.ParameterUseEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("min")) {
        res.setMinElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("max")) {
        res.setMaxElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfile(parseReference(xpp));
      } else if (!parseElementContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected void parseDomainResourceAttributes(XmlPullParser xpp, DomainResource res) throws XmlPullParserException, IOException, FHIRFormatError {
    parseResourceAttributes(xpp, res);
  }

  protected boolean parseDomainResourceContent(int eventType, XmlPullParser xpp, DomainResource res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setText(parseNarrative(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contained")) {
        res.getContained().add(parseResourceContained(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("extension")) {
        res.getExtension().add(parseExtension(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifierExtension")) {
        res.getModifierExtension().add(parseExtension(xpp));
    } else
    return parseResourceContent(eventType, xpp, res);
    return true;
  }

  protected Parameters parseParameters(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Parameters res = new Parameters();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseParametersContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseParametersContent(int eventType, XmlPullParser xpp, Parameters res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parameter")) {
        res.getParameter().add(parseParametersParametersParameterComponent(xpp, res));
      } else if (!parseResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Parameters.ParametersParameterComponent parseParametersParametersParameterComponent(XmlPullParser xpp, Parameters owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Parameters.ParametersParameterComponent res = new Parameters.ParametersParameterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseParametersParametersParameterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseParametersParametersParameterComponentContent(int eventType, XmlPullParser xpp, Parameters owner, Parameters.ParametersParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.setResource(parseResourceContained(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("part")) {
        res.getPart().add(parseParametersParametersParameterComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected void parseResourceAttributes(XmlPullParser xpp, Resource res) throws XmlPullParserException, IOException, FHIRFormatError {
    if (!comments.isEmpty()) {
      res.getFormatCommentsPre().addAll(comments);
      comments.clear();
     }
  }

  protected boolean parseResourceContent(int eventType, XmlPullParser xpp, Resource res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("id")) {
        res.setIdElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("meta")) {
        res.setMeta(parseMeta(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("implicitRules")) {
        res.setImplicitRulesElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguageElement(parseCode(xpp));
    } else
        return false;
    return true;
  }

  protected Account parseAccount(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Account res = new Account();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAccountContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAccountContent(int eventType, XmlPullParser xpp, Account res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Account.AccountStatus.NULL, new Account.AccountStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
        res.setActive(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("balance")) {
        res.setBalance(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
        res.getCoverage().add(parseAccountCoverageComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("owner")) {
        res.setOwner(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("guarantor")) {
        res.getGuarantor().add(parseAccountGuarantorComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Account.CoverageComponent parseAccountCoverageComponent(XmlPullParser xpp, Account owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Account.CoverageComponent res = new Account.CoverageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAccountCoverageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAccountCoverageComponentContent(int eventType, XmlPullParser xpp, Account owner, Account.CoverageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
        res.setCoverage(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriorityElement(parsePositiveInt(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Account.GuarantorComponent parseAccountGuarantorComponent(XmlPullParser xpp, Account owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Account.GuarantorComponent res = new Account.GuarantorComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAccountGuarantorComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAccountGuarantorComponentContent(int eventType, XmlPullParser xpp, Account owner, Account.GuarantorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("party")) {
        res.setParty(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onHold")) {
        res.setOnHoldElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ActivityDefinition parseActivityDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ActivityDefinition res = new ActivityDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseActivityDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseActivityDefinitionContent(int eventType, XmlPullParser xpp, ActivityDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
        res.setUsageElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
        res.setApprovalDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
        res.setLastReviewDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
        res.setEffectivePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
        res.getTopic().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contributor")) {
        res.getContributor().add(parseContributor(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
        res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("library")) {
        res.getLibrary().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
        res.setKindElement(parseEnumeration(xpp, ActivityDefinition.ActivityDefinitionKind.NULL, new ActivityDefinition.ActivityDefinitionKindEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "timing")) {
        res.setTiming(parseType("timing", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
        res.getParticipant().add(parseActivityDefinitionActivityDefinitionParticipantComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "product")) {
        res.setProduct(parseType("product", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosage")) {
        res.getDosage().add(parseDosage(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.getBodySite().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("transform")) {
        res.setTransform(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dynamicValue")) {
        res.getDynamicValue().add(parseActivityDefinitionActivityDefinitionDynamicValueComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ActivityDefinition.ActivityDefinitionParticipantComponent parseActivityDefinitionActivityDefinitionParticipantComponent(XmlPullParser xpp, ActivityDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ActivityDefinition.ActivityDefinitionParticipantComponent res = new ActivityDefinition.ActivityDefinitionParticipantComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseActivityDefinitionActivityDefinitionParticipantComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseActivityDefinitionActivityDefinitionParticipantComponentContent(int eventType, XmlPullParser xpp, ActivityDefinition owner, ActivityDefinition.ActivityDefinitionParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, ActivityDefinition.ActivityParticipantType.NULL, new ActivityDefinition.ActivityParticipantTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ActivityDefinition.ActivityDefinitionDynamicValueComponent parseActivityDefinitionActivityDefinitionDynamicValueComponent(XmlPullParser xpp, ActivityDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ActivityDefinition.ActivityDefinitionDynamicValueComponent res = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseActivityDefinitionActivityDefinitionDynamicValueComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseActivityDefinitionActivityDefinitionDynamicValueComponentContent(int eventType, XmlPullParser xpp, ActivityDefinition owner, ActivityDefinition.ActivityDefinitionDynamicValueComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguageElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
        res.setExpressionElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AdverseEvent parseAdverseEvent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AdverseEvent res = new AdverseEvent();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAdverseEventContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdverseEventContent(int eventType, XmlPullParser xpp, AdverseEvent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actuality")) {
        res.setActualityElement(parseEnumeration(xpp, AdverseEvent.AdverseEventActuality.NULL, new AdverseEvent.AdverseEventActualityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategoryElement(parseEnumeration(xpp, AdverseEvent.AdverseEventCategory.NULL, new AdverseEvent.AdverseEventCategoryEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("event")) {
        res.setEvent(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resultingCondition")) {
        res.getResultingCondition().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("seriousness")) {
        res.setSeriousness(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("severity")) {
        res.setSeverity(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcome(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recorder")) {
        res.setRecorder(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("eventParticipant")) {
        res.setEventParticipant(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("suspectEntity")) {
        res.getSuspectEntity().add(parseAdverseEventAdverseEventSuspectEntityComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subjectMedicalHistory")) {
        res.getSubjectMedicalHistory().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceDocument")) {
        res.getReferenceDocument().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("study")) {
        res.getStudy().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AdverseEvent.AdverseEventSuspectEntityComponent parseAdverseEventAdverseEventSuspectEntityComponent(XmlPullParser xpp, AdverseEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AdverseEvent.AdverseEventSuspectEntityComponent res = new AdverseEvent.AdverseEventSuspectEntityComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAdverseEventAdverseEventSuspectEntityComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdverseEventAdverseEventSuspectEntityComponentContent(int eventType, XmlPullParser xpp, AdverseEvent owner, AdverseEvent.AdverseEventSuspectEntityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instance")) {
        res.setInstance(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("causality")) {
        res.getCausality().add(parseAdverseEventAdverseEventSuspectEntityCausalityComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AdverseEvent.AdverseEventSuspectEntityCausalityComponent parseAdverseEventAdverseEventSuspectEntityCausalityComponent(XmlPullParser xpp, AdverseEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AdverseEvent.AdverseEventSuspectEntityCausalityComponent res = new AdverseEvent.AdverseEventSuspectEntityCausalityComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAdverseEventAdverseEventSuspectEntityCausalityComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAdverseEventAdverseEventSuspectEntityCausalityComponentContent(int eventType, XmlPullParser xpp, AdverseEvent owner, AdverseEvent.AdverseEventSuspectEntityCausalityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assessment")) {
        res.setAssessment(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productRelatedness")) {
        res.setProductRelatednessElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
        res.setMethod(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AllergyIntolerance parseAllergyIntolerance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AllergyIntolerance res = new AllergyIntolerance();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAllergyIntoleranceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAllergyIntoleranceContent(int eventType, XmlPullParser xpp, AllergyIntolerance res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("clinicalStatus")) {
        res.setClinicalStatusElement(parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceClinicalStatus.NULL, new AllergyIntolerance.AllergyIntoleranceClinicalStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("verificationStatus")) {
        res.setVerificationStatusElement(parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceVerificationStatus.NULL, new AllergyIntolerance.AllergyIntoleranceVerificationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceType.NULL, new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("criticality")) {
        res.setCriticalityElement(parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceCriticality.NULL, new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "onset")) {
        res.setOnset(parseType("onset", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assertedDate")) {
        res.setAssertedDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recorder")) {
        res.setRecorder(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("asserter")) {
        res.setAsserter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastOccurrence")) {
        res.setLastOccurrenceElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reaction")) {
        res.getReaction().add(parseAllergyIntoleranceAllergyIntoleranceReactionComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceAllergyIntoleranceReactionComponent(XmlPullParser xpp, AllergyIntolerance owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAllergyIntoleranceAllergyIntoleranceReactionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAllergyIntoleranceAllergyIntoleranceReactionComponentContent(int eventType, XmlPullParser xpp, AllergyIntolerance owner, AllergyIntolerance.AllergyIntoleranceReactionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("substance")) {
        res.setSubstance(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manifestation")) {
        res.getManifestation().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onset")) {
        res.setOnsetElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("severity")) {
        res.setSeverityElement(parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceSeverity.NULL, new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("exposureRoute")) {
        res.setExposureRoute(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Appointment parseAppointment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Appointment res = new Appointment();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAppointmentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAppointmentContent(int eventType, XmlPullParser xpp, Appointment res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Appointment.AppointmentStatus.NULL, new Appointment.AppointmentStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serviceCategory")) {
        res.setServiceCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serviceType")) {
        res.getServiceType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialty")) {
        res.getSpecialty().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("appointmentType")) {
        res.setAppointmentType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.getReason().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("indication")) {
        res.getIndication().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriorityElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInformation")) {
        res.getSupportingInformation().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
        res.setStartElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
        res.setEndElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("minutesDuration")) {
        res.setMinutesDurationElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("slot")) {
        res.getSlot().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("incomingReferral")) {
        res.getIncomingReferral().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
        res.getParticipant().add(parseAppointmentAppointmentParticipantComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestedPeriod")) {
        res.getRequestedPeriod().add(parsePeriod(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Appointment.AppointmentParticipantComponent parseAppointmentAppointmentParticipantComponent(XmlPullParser xpp, Appointment owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAppointmentAppointmentParticipantComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAppointmentAppointmentParticipantComponentContent(int eventType, XmlPullParser xpp, Appointment owner, Appointment.AppointmentParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.setActor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("required")) {
        res.setRequiredElement(parseEnumeration(xpp, Appointment.ParticipantRequired.NULL, new Appointment.ParticipantRequiredEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Appointment.ParticipationStatus.NULL, new Appointment.ParticipationStatusEnumFactory()));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AppointmentResponse parseAppointmentResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AppointmentResponse res = new AppointmentResponse();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAppointmentResponseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAppointmentResponseContent(int eventType, XmlPullParser xpp, AppointmentResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("appointment")) {
        res.setAppointment(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
        res.setStartElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
        res.setEndElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participantType")) {
        res.getParticipantType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.setActor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participantStatus")) {
        res.setParticipantStatusElement(parseEnumeration(xpp, AppointmentResponse.ParticipantStatus.NULL, new AppointmentResponse.ParticipantStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AuditEvent parseAuditEvent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    AuditEvent res = new AuditEvent();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAuditEventContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAuditEventContent(int eventType, XmlPullParser xpp, AuditEvent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtype")) {
        res.getSubtype().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
        res.setActionElement(parseEnumeration(xpp, AuditEvent.AuditEventAction.NULL, new AuditEvent.AuditEventActionEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recorded")) {
        res.setRecordedElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcomeElement(parseEnumeration(xpp, AuditEvent.AuditEventOutcome.NULL, new AuditEvent.AuditEventOutcomeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcomeDesc")) {
        res.setOutcomeDescElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purposeOfEvent")) {
        res.getPurposeOfEvent().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("agent")) {
        res.getAgent().add(parseAuditEventAuditEventAgentComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSource(parseAuditEventAuditEventSourceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entity")) {
        res.getEntity().add(parseAuditEventAuditEventEntityComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AuditEvent.AuditEventAgentComponent parseAuditEventAuditEventAgentComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AuditEvent.AuditEventAgentComponent res = new AuditEvent.AuditEventAgentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAuditEventAuditEventAgentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAuditEventAuditEventAgentComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventAgentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.getRole().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReference(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("userId")) {
        res.setUserId(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("altId")) {
        res.setAltIdElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestor")) {
        res.setRequestorElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("policy")) {
        res.getPolicy().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("media")) {
        res.setMedia(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("network")) {
        res.setNetwork(parseAuditEventAuditEventAgentNetworkComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purposeOfUse")) {
        res.getPurposeOfUse().add(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AuditEvent.AuditEventAgentNetworkComponent parseAuditEventAuditEventAgentNetworkComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AuditEvent.AuditEventAgentNetworkComponent res = new AuditEvent.AuditEventAgentNetworkComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAuditEventAuditEventAgentNetworkComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAuditEventAuditEventAgentNetworkComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventAgentNetworkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
        res.setAddressElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, AuditEvent.AuditEventAgentNetworkType.NULL, new AuditEvent.AuditEventAgentNetworkTypeEnumFactory()));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AuditEvent.AuditEventSourceComponent parseAuditEventAuditEventSourceComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAuditEventAuditEventSourceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAuditEventAuditEventSourceComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventSourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("site")) {
        res.setSiteElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCoding(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AuditEvent.AuditEventEntityComponent parseAuditEventAuditEventEntityComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AuditEvent.AuditEventEntityComponent res = new AuditEvent.AuditEventEntityComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAuditEventAuditEventEntityComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAuditEventAuditEventEntityComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventEntityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReference(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lifecycle")) {
        res.setLifecycle(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabel")) {
        res.getSecurityLabel().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("query")) {
        res.setQueryElement(parseBase64Binary(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.getDetail().add(parseAuditEventAuditEventEntityDetailComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected AuditEvent.AuditEventEntityDetailComponent parseAuditEventAuditEventEntityDetailComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    AuditEvent.AuditEventEntityDetailComponent res = new AuditEvent.AuditEventEntityDetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseAuditEventAuditEventEntityDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseAuditEventAuditEventEntityDetailComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventEntityDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Basic parseBasic(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Basic res = new Basic();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBasicContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBasicContent(int eventType, XmlPullParser xpp, Basic res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Binary parseBinary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Binary res = new Binary();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBinaryContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBinaryContent(int eventType, XmlPullParser xpp, Binary res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contentType")) {
        res.setContentTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityContext")) {
        res.setSecurityContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("content")) {
        res.setContentElement(parseBase64Binary(xpp));
      } else if (!parseResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected BodyStructure parseBodyStructure(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    BodyStructure res = new BodyStructure();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBodyStructureContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBodyStructureContent(int eventType, XmlPullParser xpp, BodyStructure res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
        res.setActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("morphology")) {
        res.setMorphology(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("locationQualifier")) {
        res.getLocationQualifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("image")) {
        res.getImage().add(parseAttachment(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Bundle parseBundle(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Bundle res = new Bundle();
    parseResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBundleContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBundleContent(int eventType, XmlPullParser xpp, Bundle res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("total")) {
        res.setTotalElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
        res.getLink().add(parseBundleBundleLinkComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entry")) {
        res.getEntry().add(parseBundleBundleEntryComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("signature")) {
        res.setSignature(parseSignature(xpp));
      } else if (!parseResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Bundle.BundleLinkComponent parseBundleBundleLinkComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBundleBundleLinkComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBundleBundleLinkComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relation")) {
        res.setRelationElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Bundle.BundleEntryComponent parseBundleBundleEntryComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBundleBundleEntryComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBundleBundleEntryComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleEntryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
        res.getLink().add(parseBundleBundleLinkComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fullUrl")) {
        res.setFullUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.setResource(parseResourceContained(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("search")) {
        res.setSearch(parseBundleBundleEntrySearchComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.setRequest(parseBundleBundleEntryRequestComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("response")) {
        res.setResponse(parseBundleBundleEntryResponseComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Bundle.BundleEntrySearchComponent parseBundleBundleEntrySearchComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBundleBundleEntrySearchComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBundleBundleEntrySearchComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleEntrySearchComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, Bundle.SearchEntryMode.NULL, new Bundle.SearchEntryModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("score")) {
        res.setScoreElement(parseDecimal(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Bundle.BundleEntryRequestComponent parseBundleBundleEntryRequestComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBundleBundleEntryRequestComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBundleBundleEntryRequestComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleEntryRequestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
        res.setMethodElement(parseEnumeration(xpp, Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ifNoneMatch")) {
        res.setIfNoneMatchElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ifModifiedSince")) {
        res.setIfModifiedSinceElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ifMatch")) {
        res.setIfMatchElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ifNoneExist")) {
        res.setIfNoneExistElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Bundle.BundleEntryResponseComponent parseBundleBundleEntryResponseComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseBundleBundleEntryResponseComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseBundleBundleEntryResponseComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleEntryResponseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocationElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("etag")) {
        res.setEtagElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastModified")) {
        res.setLastModifiedElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcome(parseResourceContained(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement parseCapabilityStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement res = new CapabilityStatement();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementContent(int eventType, XmlPullParser xpp, CapabilityStatement res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
        res.setKindElement(parseEnumeration(xpp, CapabilityStatement.CapabilityStatementKind.NULL, new CapabilityStatement.CapabilityStatementKindEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instantiates")) {
        res.getInstantiates().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("software")) {
        res.setSoftware(parseCapabilityStatementCapabilityStatementSoftwareComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("implementation")) {
        res.setImplementation(parseCapabilityStatementCapabilityStatementImplementationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fhirVersion")) {
        res.setFhirVersionElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("acceptUnknown")) {
        res.setAcceptUnknownElement(parseEnumeration(xpp, CapabilityStatement.UnknownContentCode.NULL, new CapabilityStatement.UnknownContentCodeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("format")) {
        res.getFormat().add(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patchFormat")) {
        res.getPatchFormat().add(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("implementationGuide")) {
        res.getImplementationGuide().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.getProfile().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rest")) {
        res.getRest().add(parseCapabilityStatementCapabilityStatementRestComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("messaging")) {
        res.getMessaging().add(parseCapabilityStatementCapabilityStatementMessagingComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("document")) {
        res.getDocument().add(parseCapabilityStatementCapabilityStatementDocumentComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementSoftwareComponent parseCapabilityStatementCapabilityStatementSoftwareComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementSoftwareComponent res = new CapabilityStatement.CapabilityStatementSoftwareComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementSoftwareComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementSoftwareComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementSoftwareComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("releaseDate")) {
        res.setReleaseDateElement(parseDateTime(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementImplementationComponent parseCapabilityStatementCapabilityStatementImplementationComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementImplementationComponent res = new CapabilityStatement.CapabilityStatementImplementationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementImplementationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementImplementationComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementImplementationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementRestComponent parseCapabilityStatementCapabilityStatementRestComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestComponent res = new CapabilityStatement.CapabilityStatementRestComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementRestComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementRestComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, CapabilityStatement.RestfulCapabilityMode.NULL, new CapabilityStatement.RestfulCapabilityModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("security")) {
        res.setSecurity(parseCapabilityStatementCapabilityStatementRestSecurityComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.getResource().add(parseCapabilityStatementCapabilityStatementRestResourceComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interaction")) {
        res.getInteraction().add(parseCapabilityStatementSystemInteractionComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchParam")) {
        res.getSearchParam().add(parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operation")) {
        res.getOperation().add(parseCapabilityStatementCapabilityStatementRestOperationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("compartment")) {
        res.getCompartment().add(parseUri(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementRestSecurityComponent parseCapabilityStatementCapabilityStatementRestSecurityComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestSecurityComponent res = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementRestSecurityComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementRestSecurityComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestSecurityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cors")) {
        res.setCorsElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("service")) {
        res.getService().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("certificate")) {
        res.getCertificate().add(parseCapabilityStatementCapabilityStatementRestSecurityCertificateComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent parseCapabilityStatementCapabilityStatementRestSecurityCertificateComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent res = new CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementRestSecurityCertificateComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementRestSecurityCertificateComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("blob")) {
        res.setBlobElement(parseBase64Binary(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementRestResourceComponent parseCapabilityStatementCapabilityStatementRestResourceComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceComponent res = new CapabilityStatement.CapabilityStatementRestResourceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementRestResourceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementRestResourceComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfile(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interaction")) {
        res.getInteraction().add(parseCapabilityStatementResourceInteractionComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("versioning")) {
        res.setVersioningElement(parseEnumeration(xpp, CapabilityStatement.ResourceVersionPolicy.NULL, new CapabilityStatement.ResourceVersionPolicyEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("readHistory")) {
        res.setReadHistoryElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("updateCreate")) {
        res.setUpdateCreateElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conditionalCreate")) {
        res.setConditionalCreateElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conditionalRead")) {
        res.setConditionalReadElement(parseEnumeration(xpp, CapabilityStatement.ConditionalReadStatus.NULL, new CapabilityStatement.ConditionalReadStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conditionalUpdate")) {
        res.setConditionalUpdateElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conditionalDelete")) {
        res.setConditionalDeleteElement(parseEnumeration(xpp, CapabilityStatement.ConditionalDeleteStatus.NULL, new CapabilityStatement.ConditionalDeleteStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referencePolicy")) {
        res.getReferencePolicy().add(parseEnumeration(xpp, CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchInclude")) {
        res.getSearchInclude().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchRevInclude")) {
        res.getSearchRevInclude().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchParam")) {
        res.getSearchParam().add(parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.ResourceInteractionComponent parseCapabilityStatementResourceInteractionComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.ResourceInteractionComponent res = new CapabilityStatement.ResourceInteractionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementResourceInteractionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementResourceInteractionComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.ResourceInteractionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseEnumeration(xpp, CapabilityStatement.TypeRestfulInteraction.NULL, new CapabilityStatement.TypeRestfulInteractionEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinitionElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.SystemInteractionComponent parseCapabilityStatementSystemInteractionComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.SystemInteractionComponent res = new CapabilityStatement.SystemInteractionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementSystemInteractionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementSystemInteractionComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.SystemInteractionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseEnumeration(xpp, CapabilityStatement.SystemRestfulInteraction.NULL, new CapabilityStatement.SystemRestfulInteractionEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementRestOperationComponent parseCapabilityStatementCapabilityStatementRestOperationComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestOperationComponent res = new CapabilityStatement.CapabilityStatementRestOperationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementRestOperationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementRestOperationComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinition(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementMessagingComponent parseCapabilityStatementCapabilityStatementMessagingComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingComponent res = new CapabilityStatement.CapabilityStatementMessagingComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementMessagingComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementMessagingComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.getEndpoint().add(parseCapabilityStatementCapabilityStatementMessagingEndpointComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reliableCache")) {
        res.setReliableCacheElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportedMessage")) {
        res.getSupportedMessage().add(parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("event")) {
        res.getEvent().add(parseCapabilityStatementCapabilityStatementMessagingEventComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementMessagingEndpointComponent parseCapabilityStatementCapabilityStatementMessagingEndpointComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingEndpointComponent res = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementMessagingEndpointComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementMessagingEndpointComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingEndpointComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("protocol")) {
        res.setProtocol(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
        res.setAddressElement(parseUri(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, CapabilityStatement.EventCapabilityMode.NULL, new CapabilityStatement.EventCapabilityModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinition(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementMessagingEventComponent parseCapabilityStatementCapabilityStatementMessagingEventComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingEventComponent res = new CapabilityStatement.CapabilityStatementMessagingEventComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementMessagingEventComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementMessagingEventComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingEventComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategoryElement(parseEnumeration(xpp, CapabilityStatement.MessageSignificanceCategory.NULL, new CapabilityStatement.MessageSignificanceCategoryEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, CapabilityStatement.EventCapabilityMode.NULL, new CapabilityStatement.EventCapabilityModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focus")) {
        res.setFocusElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.setRequest(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("response")) {
        res.setResponse(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CapabilityStatement.CapabilityStatementDocumentComponent parseCapabilityStatementCapabilityStatementDocumentComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementDocumentComponent res = new CapabilityStatement.CapabilityStatementDocumentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCapabilityStatementCapabilityStatementDocumentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCapabilityStatementCapabilityStatementDocumentComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementDocumentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, CapabilityStatement.DocumentMode.NULL, new CapabilityStatement.DocumentModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfile(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CarePlan parseCarePlan(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CarePlan res = new CarePlan();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCarePlanContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCarePlanContent(int eventType, XmlPullParser xpp, CarePlan res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.getDefinition().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("replaces")) {
        res.getReplaces().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, CarePlan.CarePlanStatus.NULL, new CarePlan.CarePlanStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intent")) {
        res.setIntentElement(parseEnumeration(xpp, CarePlan.CarePlanIntent.NULL, new CarePlan.CarePlanIntentEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.getAuthor().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("careTeam")) {
        res.getCareTeam().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("addresses")) {
        res.getAddresses().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfo")) {
        res.getSupportingInfo().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("goal")) {
        res.getGoal().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("activity")) {
        res.getActivity().add(parseCarePlanCarePlanActivityComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CarePlan.CarePlanActivityComponent parseCarePlanCarePlanActivityComponent(XmlPullParser xpp, CarePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCarePlanCarePlanActivityComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCarePlanCarePlanActivityComponentContent(int eventType, XmlPullParser xpp, CarePlan owner, CarePlan.CarePlanActivityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcomeCodeableConcept")) {
        res.getOutcomeCodeableConcept().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcomeReference")) {
        res.getOutcomeReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("progress")) {
        res.getProgress().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReference(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.setDetail(parseCarePlanCarePlanActivityDetailComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CarePlan.CarePlanActivityDetailComponent parseCarePlanCarePlanActivityDetailComponent(XmlPullParser xpp, CarePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CarePlan.CarePlanActivityDetailComponent res = new CarePlan.CarePlanActivityDetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCarePlanCarePlanActivityDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCarePlanCarePlanActivityDetailComponentContent(int eventType, XmlPullParser xpp, CarePlan owner, CarePlan.CarePlanActivityDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
        res.setKindElement(parseEnumeration(xpp, CarePlan.CarePlanActivityKind.NULL, new CarePlan.CarePlanActivityKindEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinition(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("goal")) {
        res.getGoal().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, CarePlan.CarePlanActivityStatus.NULL, new CarePlan.CarePlanActivityStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
        res.setStatusReasonElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prohibited")) {
        res.setProhibitedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "scheduled")) {
        res.setScheduled(parseType("scheduled", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.getPerformer().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "product")) {
        res.setProduct(parseType("product", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dailyAmount")) {
        res.setDailyAmount(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CareTeam parseCareTeam(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CareTeam res = new CareTeam();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCareTeamContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCareTeamContent(int eventType, XmlPullParser xpp, CareTeam res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, CareTeam.CareTeamStatus.NULL, new CareTeam.CareTeamStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
        res.getParticipant().add(parseCareTeamCareTeamParticipantComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("managingOrganization")) {
        res.getManagingOrganization().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
        res.getTelecom().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CareTeam.CareTeamParticipantComponent parseCareTeamCareTeamParticipantComponent(XmlPullParser xpp, CareTeam owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CareTeam.CareTeamParticipantComponent res = new CareTeam.CareTeamParticipantComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCareTeamCareTeamParticipantComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCareTeamCareTeamParticipantComponentContent(int eventType, XmlPullParser xpp, CareTeam owner, CareTeam.CareTeamParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("member")) {
        res.setMember(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onBehalfOf")) {
        res.setOnBehalfOf(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CatalogEntry parseCatalogEntry(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CatalogEntry res = new CatalogEntry();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCatalogEntryContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCatalogEntryContent(int eventType, XmlPullParser xpp, CatalogEntry res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurpose(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referencedItem")) {
        res.setReferencedItem(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additionalIdentifier")) {
        res.getAdditionalIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("classification")) {
        res.getClassification().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("validityPeriod")) {
        res.setValidityPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastUpdated")) {
        res.setLastUpdatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additionalCharacteristic")) {
        res.getAdditionalCharacteristic().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additionalClassification")) {
        res.getAdditionalClassification().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedItem")) {
        res.getRelatedItem().add(parseCatalogEntryCatalogEntryRelatedItemComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CatalogEntry.CatalogEntryRelatedItemComponent parseCatalogEntryCatalogEntryRelatedItemComponent(XmlPullParser xpp, CatalogEntry owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CatalogEntry.CatalogEntryRelatedItemComponent res = new CatalogEntry.CatalogEntryRelatedItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCatalogEntryCatalogEntryRelatedItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCatalogEntryCatalogEntryRelatedItemComponentContent(int eventType, XmlPullParser xpp, CatalogEntry owner, CatalogEntry.CatalogEntryRelatedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationtype")) {
        res.setRelationtype(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.setItem(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ChargeItem parseChargeItem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ChargeItem res = new ChargeItem();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseChargeItemContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseChargeItemContent(int eventType, XmlPullParser xpp, ChargeItem res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.getDefinition().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, ChargeItem.ChargeItemStatus.NULL, new ChargeItem.ChargeItemStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
        res.setOccurrence(parseType("occurrence", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
        res.getParticipant().add(parseChargeItemChargeItemParticipantComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performingOrganization")) {
        res.setPerformingOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestingOrganization")) {
        res.setRequestingOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodysite")) {
        res.getBodysite().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factorOverride")) {
        res.setFactorOverrideElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priceOverride")) {
        res.setPriceOverride(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("overrideReason")) {
        res.setOverrideReasonElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enterer")) {
        res.setEnterer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enteredDate")) {
        res.setEnteredDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.getReason().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("service")) {
        res.getService().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("account")) {
        res.getAccount().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInformation")) {
        res.getSupportingInformation().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ChargeItem.ChargeItemParticipantComponent parseChargeItemChargeItemParticipantComponent(XmlPullParser xpp, ChargeItem owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ChargeItem.ChargeItemParticipantComponent res = new ChargeItem.ChargeItemParticipantComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseChargeItemChargeItemParticipantComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseChargeItemChargeItemParticipantComponentContent(int eventType, XmlPullParser xpp, ChargeItem owner, ChargeItem.ChargeItemParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.setActor(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim parseClaim(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim res = new Claim();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimContent(int eventType, XmlPullParser xpp, Claim res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Claim.ClaimStatus.NULL, new Claim.ClaimStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subType")) {
        res.getSubType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUseElement(parseEnumeration(xpp, Claim.Use.NULL, new Claim.UseEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("billablePeriod")) {
        res.setBillablePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enterer")) {
        res.setEnterer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurer")) {
        res.setInsurer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
        res.setProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("organization")) {
        res.setOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriority(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fundsReserve")) {
        res.setFundsReserve(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("related")) {
        res.getRelated().add(parseClaimRelatedClaimComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prescription")) {
        res.setPrescription(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("originalPrescription")) {
        res.setOriginalPrescription(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payee")) {
        res.setPayee(parseClaimPayeeComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referral")) {
        res.setReferral(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("facility")) {
        res.setFacility(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("careTeam")) {
        res.getCareTeam().add(parseClaimCareTeamComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("information")) {
        res.getInformation().add(parseClaimSpecialConditionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosis")) {
        res.getDiagnosis().add(parseClaimDiagnosisComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedure")) {
        res.getProcedure().add(parseClaimProcedureComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurance")) {
        res.getInsurance().add(parseClaimInsuranceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("accident")) {
        res.setAccident(parseClaimAccidentComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("employmentImpacted")) {
        res.setEmploymentImpacted(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hospitalization")) {
        res.setHospitalization(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.getItem().add(parseClaimItemComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("total")) {
        res.setTotal(parseMoney(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.RelatedClaimComponent parseClaimRelatedClaimComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.RelatedClaimComponent res = new Claim.RelatedClaimComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimRelatedClaimComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimRelatedClaimComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.RelatedClaimComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("claim")) {
        res.setClaim(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
        res.setRelationship(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReference(parseIdentifier(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.PayeeComponent parseClaimPayeeComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.PayeeComponent res = new Claim.PayeeComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimPayeeComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimPayeeComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.PayeeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.setResource(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("party")) {
        res.setParty(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.CareTeamComponent parseClaimCareTeamComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.CareTeamComponent res = new Claim.CareTeamComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimCareTeamComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimCareTeamComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.CareTeamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
        res.setProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responsible")) {
        res.setResponsibleElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("qualification")) {
        res.setQualification(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.SpecialConditionComponent parseClaimSpecialConditionComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.SpecialConditionComponent res = new Claim.SpecialConditionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimSpecialConditionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimSpecialConditionComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.SpecialConditionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "timing")) {
        res.setTiming(parseType("timing", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.setReason(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimDiagnosisComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimDiagnosisComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "diagnosis")) {
        res.setDiagnosis(parseType("diagnosis", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("packageCode")) {
        res.setPackageCode(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.ProcedureComponent parseClaimProcedureComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.ProcedureComponent res = new Claim.ProcedureComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimProcedureComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimProcedureComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.ProcedureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "procedure")) {
        res.setProcedure(parseType("procedure", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.InsuranceComponent parseClaimInsuranceComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.InsuranceComponent res = new Claim.InsuranceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimInsuranceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimInsuranceComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focal")) {
        res.setFocalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
        res.setCoverage(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("businessArrangement")) {
        res.setBusinessArrangementElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAuthRef")) {
        res.getPreAuthRef().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("claimResponse")) {
        res.setClaimResponse(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.AccidentComponent parseClaimAccidentComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.AccidentComponent res = new Claim.AccidentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimAccidentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimAccidentComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.AccidentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "location")) {
        res.setLocation(parseType("location", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.ItemComponent parseClaimItemComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.ItemComponent res = new Claim.ItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimItemComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.ItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("careTeamLinkId")) {
        res.getCareTeamLinkId().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosisLinkId")) {
        res.getDiagnosisLinkId().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedureLinkId")) {
        res.getProcedureLinkId().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("informationLinkId")) {
        res.getInformationLinkId().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("revenue")) {
        res.setRevenue(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("service")) {
        res.setService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
        res.getProgramCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "serviced")) {
        res.setServiced(parseType("serviced", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "location")) {
        res.setLocation(parseType("location", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
        res.getUdi().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.setBodySite(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subSite")) {
        res.getSubSite().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.getEncounter().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.getDetail().add(parseClaimDetailComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.DetailComponent parseClaimDetailComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.DetailComponent res = new Claim.DetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimDetailComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.DetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("revenue")) {
        res.setRevenue(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("service")) {
        res.setService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
        res.getProgramCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
        res.getUdi().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetail")) {
        res.getSubDetail().add(parseClaimSubDetailComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Claim.SubDetailComponent parseClaimSubDetailComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Claim.SubDetailComponent res = new Claim.SubDetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimSubDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimSubDetailComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.SubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("revenue")) {
        res.setRevenue(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("service")) {
        res.setService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
        res.getProgramCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
        res.getUdi().add(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse parseClaimResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse res = new ClaimResponse();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseContent(int eventType, XmlPullParser xpp, ClaimResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, ClaimResponse.ClaimResponseStatus.NULL, new ClaimResponse.ClaimResponseStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurer")) {
        res.setInsurer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestProvider")) {
        res.setRequestProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestOrganization")) {
        res.setRequestOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.setRequest(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcomeElement(parseEnumeration(xpp, ClaimResponse.RemittanceOutcome.NULL, new ClaimResponse.RemittanceOutcomeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("disposition")) {
        res.setDispositionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payeeType")) {
        res.setPayeeType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.getItem().add(parseClaimResponseItemComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("addItem")) {
        res.getAddItem().add(parseClaimResponseAddedItemComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("error")) {
        res.getError().add(parseClaimResponseErrorComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("totalCost")) {
        res.setTotalCost(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unallocDeductable")) {
        res.setUnallocDeductable(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("totalBenefit")) {
        res.setTotalBenefit(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payment")) {
        res.setPayment(parseClaimResponsePaymentComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reserved")) {
        res.setReserved(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("form")) {
        res.setForm(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("processNote")) {
        res.getProcessNote().add(parseClaimResponseNoteComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("communicationRequest")) {
        res.getCommunicationRequest().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurance")) {
        res.getInsurance().add(parseClaimResponseInsuranceComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.ItemComponent parseClaimResponseItemComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.ItemComponent res = new ClaimResponse.ItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseItemComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.ItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequenceLinkId")) {
        res.setSequenceLinkIdElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.getDetail().add(parseClaimResponseItemDetailComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.AdjudicationComponent parseClaimResponseAdjudicationComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.AdjudicationComponent res = new ClaimResponse.AdjudicationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseAdjudicationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseAdjudicationComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.AdjudicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.setReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseDecimal(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseItemDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseItemDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.ItemDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequenceLinkId")) {
        res.setSequenceLinkIdElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetail")) {
        res.getSubDetail().add(parseClaimResponseSubDetailComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseSubDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseSubDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.SubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequenceLinkId")) {
        res.setSequenceLinkIdElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseAddedItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseAddedItemComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.AddedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequenceLinkId")) {
        res.getSequenceLinkId().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detailSequenceLinkId")) {
        res.getDetailSequenceLinkId().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subdetailSequenceLinkId")) {
        res.getSubdetailSequenceLinkId().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("service")) {
        res.setService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fee")) {
        res.setFee(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.ErrorComponent parseClaimResponseErrorComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.ErrorComponent res = new ClaimResponse.ErrorComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseErrorComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseErrorComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.ErrorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequenceLinkId")) {
        res.setSequenceLinkIdElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detailSequenceLinkId")) {
        res.setDetailSequenceLinkIdElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subdetailSequenceLinkId")) {
        res.setSubdetailSequenceLinkIdElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.PaymentComponent parseClaimResponsePaymentComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.PaymentComponent res = new ClaimResponse.PaymentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponsePaymentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponsePaymentComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.PaymentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjustment")) {
        res.setAdjustment(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjustmentReason")) {
        res.setAdjustmentReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.NoteComponent parseClaimResponseNoteComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.NoteComponent res = new ClaimResponse.NoteComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseNoteComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseNoteComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.NoteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("number")) {
        res.setNumberElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguage(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClaimResponse.InsuranceComponent parseClaimResponseInsuranceComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClaimResponse.InsuranceComponent res = new ClaimResponse.InsuranceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClaimResponseInsuranceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClaimResponseInsuranceComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focal")) {
        res.setFocalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
        res.setCoverage(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("businessArrangement")) {
        res.setBusinessArrangementElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAuthRef")) {
        res.getPreAuthRef().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("claimResponse")) {
        res.setClaimResponse(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClinicalImpression parseClinicalImpression(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalImpression res = new ClinicalImpression();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClinicalImpressionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalImpressionContent(int eventType, XmlPullParser xpp, ClinicalImpression res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, ClinicalImpression.ClinicalImpressionStatus.NULL, new ClinicalImpression.ClinicalImpressionStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "effective")) {
        res.setEffective(parseType("effective", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assessor")) {
        res.setAssessor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("previous")) {
        res.setPrevious(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("problem")) {
        res.getProblem().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("investigation")) {
        res.getInvestigation().add(parseClinicalImpressionClinicalImpressionInvestigationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("protocol")) {
        res.getProtocol().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("summary")) {
        res.setSummaryElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("finding")) {
        res.getFinding().add(parseClinicalImpressionClinicalImpressionFindingComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prognosisCodeableConcept")) {
        res.getPrognosisCodeableConcept().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prognosisReference")) {
        res.getPrognosisReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
        res.getAction().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClinicalImpression.ClinicalImpressionInvestigationComponent parseClinicalImpressionClinicalImpressionInvestigationComponent(XmlPullParser xpp, ClinicalImpression owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalImpression.ClinicalImpressionInvestigationComponent res = new ClinicalImpression.ClinicalImpressionInvestigationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClinicalImpressionClinicalImpressionInvestigationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalImpressionClinicalImpressionInvestigationComponentContent(int eventType, XmlPullParser xpp, ClinicalImpression owner, ClinicalImpression.ClinicalImpressionInvestigationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.getItem().add(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionClinicalImpressionFindingComponent(XmlPullParser xpp, ClinicalImpression owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseClinicalImpressionClinicalImpressionFindingComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseClinicalImpressionClinicalImpressionFindingComponentContent(int eventType, XmlPullParser xpp, ClinicalImpression owner, ClinicalImpression.ClinicalImpressionFindingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "item")) {
        res.setItem(parseType("item", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basis")) {
        res.setBasisElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CodeSystem parseCodeSystem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeSystem res = new CodeSystem();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCodeSystemContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeSystemContent(int eventType, XmlPullParser xpp, CodeSystem res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("caseSensitive")) {
        res.setCaseSensitiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueSet")) {
        res.setValueSetElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hierarchyMeaning")) {
        res.setHierarchyMeaningElement(parseEnumeration(xpp, CodeSystem.CodeSystemHierarchyMeaning.NULL, new CodeSystem.CodeSystemHierarchyMeaningEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("compositional")) {
        res.setCompositionalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("versionNeeded")) {
        res.setVersionNeededElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("content")) {
        res.setContentElement(parseEnumeration(xpp, CodeSystem.CodeSystemContentMode.NULL, new CodeSystem.CodeSystemContentModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("count")) {
        res.setCountElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("filter")) {
        res.getFilter().add(parseCodeSystemCodeSystemFilterComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("property")) {
        res.getProperty().add(parseCodeSystemPropertyComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("concept")) {
        res.getConcept().add(parseCodeSystemConceptDefinitionComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CodeSystem.CodeSystemFilterComponent parseCodeSystemCodeSystemFilterComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeSystem.CodeSystemFilterComponent res = new CodeSystem.CodeSystemFilterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCodeSystemCodeSystemFilterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeSystemCodeSystemFilterComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.CodeSystemFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operator")) {
        res.getOperator().add(parseEnumeration(xpp, CodeSystem.FilterOperator.NULL, new CodeSystem.FilterOperatorEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CodeSystem.PropertyComponent parseCodeSystemPropertyComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeSystem.PropertyComponent res = new CodeSystem.PropertyComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCodeSystemPropertyComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeSystemPropertyComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.PropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uri")) {
        res.setUriElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, CodeSystem.PropertyType.NULL, new CodeSystem.PropertyTypeEnumFactory()));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CodeSystem.ConceptDefinitionComponent parseCodeSystemConceptDefinitionComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCodeSystemConceptDefinitionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeSystemConceptDefinitionComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.ConceptDefinitionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
        res.setDisplayElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinitionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("designation")) {
        res.getDesignation().add(parseCodeSystemConceptDefinitionDesignationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("property")) {
        res.getProperty().add(parseCodeSystemConceptPropertyComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("concept")) {
        res.getConcept().add(parseCodeSystemConceptDefinitionComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CodeSystem.ConceptDefinitionDesignationComponent parseCodeSystemConceptDefinitionDesignationComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionDesignationComponent res = new CodeSystem.ConceptDefinitionDesignationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCodeSystemConceptDefinitionDesignationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeSystemConceptDefinitionDesignationComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.ConceptDefinitionDesignationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguageElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUse(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CodeSystem.ConceptPropertyComponent parseCodeSystemConceptPropertyComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CodeSystem.ConceptPropertyComponent res = new CodeSystem.ConceptPropertyComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCodeSystemConceptPropertyComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCodeSystemConceptPropertyComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.ConceptPropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Communication parseCommunication(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Communication res = new Communication();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCommunicationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCommunicationContent(int eventType, XmlPullParser xpp, Communication res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.getDefinition().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("inResponseTo")) {
        res.getInResponseTo().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Communication.CommunicationStatus.NULL, new Communication.CommunicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("notDone")) {
        res.setNotDoneElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("notDoneReason")) {
        res.setNotDoneReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriorityElement(parseEnumeration(xpp, Communication.CommunicationPriority.NULL, new Communication.CommunicationPriorityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("medium")) {
        res.getMedium().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recipient")) {
        res.getRecipient().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
        res.getTopic().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sent")) {
        res.setSentElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("received")) {
        res.setReceivedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sender")) {
        res.setSender(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payload")) {
        res.getPayload().add(parseCommunicationCommunicationPayloadComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Communication.CommunicationPayloadComponent parseCommunicationCommunicationPayloadComponent(XmlPullParser xpp, Communication owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCommunicationCommunicationPayloadComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCommunicationCommunicationPayloadComponentContent(int eventType, XmlPullParser xpp, Communication owner, Communication.CommunicationPayloadComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "content")) {
        res.setContent(parseType("content", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CommunicationRequest parseCommunicationRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CommunicationRequest res = new CommunicationRequest();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCommunicationRequestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCommunicationRequestContent(int eventType, XmlPullParser xpp, CommunicationRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("replaces")) {
        res.getReplaces().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupIdentifier")) {
        res.setGroupIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, CommunicationRequest.CommunicationRequestStatus.NULL, new CommunicationRequest.CommunicationRequestStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriorityElement(parseEnumeration(xpp, CommunicationRequest.CommunicationPriority.NULL, new CommunicationRequest.CommunicationPriorityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("medium")) {
        res.getMedium().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recipient")) {
        res.getRecipient().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
        res.getTopic().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payload")) {
        res.getPayload().add(parseCommunicationRequestCommunicationRequestPayloadComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
        res.setOccurrence(parseType("occurrence", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authoredOn")) {
        res.setAuthoredOnElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sender")) {
        res.setSender(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requester")) {
        res.setRequester(parseCommunicationRequestCommunicationRequestRequesterComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestCommunicationRequestPayloadComponent(XmlPullParser xpp, CommunicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCommunicationRequestCommunicationRequestPayloadComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCommunicationRequestCommunicationRequestPayloadComponentContent(int eventType, XmlPullParser xpp, CommunicationRequest owner, CommunicationRequest.CommunicationRequestPayloadComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "content")) {
        res.setContent(parseType("content", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CommunicationRequest.CommunicationRequestRequesterComponent parseCommunicationRequestCommunicationRequestRequesterComponent(XmlPullParser xpp, CommunicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CommunicationRequest.CommunicationRequestRequesterComponent res = new CommunicationRequest.CommunicationRequestRequesterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCommunicationRequestCommunicationRequestRequesterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCommunicationRequestCommunicationRequestRequesterComponentContent(int eventType, XmlPullParser xpp, CommunicationRequest owner, CommunicationRequest.CommunicationRequestRequesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("agent")) {
        res.setAgent(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onBehalfOf")) {
        res.setOnBehalfOf(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CompartmentDefinition parseCompartmentDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    CompartmentDefinition res = new CompartmentDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCompartmentDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompartmentDefinitionContent(int eventType, XmlPullParser xpp, CompartmentDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseEnumeration(xpp, CompartmentDefinition.CompartmentType.NULL, new CompartmentDefinition.CompartmentTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("search")) {
        res.setSearchElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.getResource().add(parseCompartmentDefinitionCompartmentDefinitionResourceComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected CompartmentDefinition.CompartmentDefinitionResourceComponent parseCompartmentDefinitionCompartmentDefinitionResourceComponent(XmlPullParser xpp, CompartmentDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    CompartmentDefinition.CompartmentDefinitionResourceComponent res = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCompartmentDefinitionCompartmentDefinitionResourceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompartmentDefinitionCompartmentDefinitionResourceComponentContent(int eventType, XmlPullParser xpp, CompartmentDefinition owner, CompartmentDefinition.CompartmentDefinitionResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("param")) {
        res.getParam().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Composition parseComposition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Composition res = new Composition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCompositionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompositionContent(int eventType, XmlPullParser xpp, Composition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Composition.CompositionStatus.NULL, new Composition.CompositionStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("class")) {
        res.setClass_(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.getAuthor().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("confidentiality")) {
        res.setConfidentialityElement(parseEnumeration(xpp, Composition.DocumentConfidentiality.NULL, new Composition.DocumentConfidentialityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("attester")) {
        res.getAttester().add(parseCompositionCompositionAttesterComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("custodian")) {
        res.setCustodian(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatesTo")) {
        res.getRelatesTo().add(parseCompositionCompositionRelatesToComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("event")) {
        res.getEvent().add(parseCompositionCompositionEventComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("section")) {
        res.getSection().add(parseCompositionSectionComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Composition.CompositionAttesterComponent parseCompositionCompositionAttesterComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCompositionCompositionAttesterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompositionCompositionAttesterComponentContent(int eventType, XmlPullParser xpp, Composition owner, Composition.CompositionAttesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.getMode().add(parseEnumeration(xpp, Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("time")) {
        res.setTimeElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("party")) {
        res.setParty(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Composition.CompositionRelatesToComponent parseCompositionCompositionRelatesToComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Composition.CompositionRelatesToComponent res = new Composition.CompositionRelatesToComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCompositionCompositionRelatesToComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompositionCompositionRelatesToComponentContent(int eventType, XmlPullParser xpp, Composition owner, Composition.CompositionRelatesToComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseEnumeration(xpp, Composition.DocumentRelationshipType.NULL, new Composition.DocumentRelationshipTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "target")) {
        res.setTarget(parseType("target", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Composition.CompositionEventComponent parseCompositionCompositionEventComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCompositionCompositionEventComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompositionCompositionEventComponentContent(int eventType, XmlPullParser xpp, Composition owner, Composition.CompositionEventComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.getCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.getDetail().add(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Composition.SectionComponent parseCompositionSectionComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Composition.SectionComponent res = new Composition.SectionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCompositionSectionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCompositionSectionComponentContent(int eventType, XmlPullParser xpp, Composition owner, Composition.SectionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setText(parseNarrative(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, Composition.SectionMode.NULL, new Composition.SectionModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("orderedBy")) {
        res.setOrderedBy(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entry")) {
        res.getEntry().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("emptyReason")) {
        res.setEmptyReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("section")) {
        res.getSection().add(parseCompositionSectionComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ConceptMap parseConceptMap(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ConceptMap res = new ConceptMap();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConceptMapContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConceptMapContent(int eventType, XmlPullParser xpp, ConceptMap res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "source")) {
        res.setSource(parseType("source", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "target")) {
        res.setTarget(parseType("target", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("group")) {
        res.getGroup().add(parseConceptMapConceptMapGroupComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ConceptMap.ConceptMapGroupComponent parseConceptMapConceptMapGroupComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ConceptMap.ConceptMapGroupComponent res = new ConceptMap.ConceptMapGroupComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConceptMapConceptMapGroupComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConceptMapConceptMapGroupComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.ConceptMapGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSourceElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sourceVersion")) {
        res.setSourceVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.setTargetElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetVersion")) {
        res.setTargetVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("element")) {
        res.getElement().add(parseConceptMapSourceElementComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unmapped")) {
        res.setUnmapped(parseConceptMapConceptMapGroupUnmappedComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConceptMapSourceElementComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConceptMapSourceElementComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.SourceElementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
        res.setDisplayElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.getTarget().add(parseConceptMapTargetElementComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConceptMapTargetElementComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConceptMapTargetElementComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.TargetElementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
        res.setDisplayElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("equivalence")) {
        res.setEquivalenceElement(parseEnumeration(xpp, Enumerations.ConceptMapEquivalence.NULL, new Enumerations.ConceptMapEquivalenceEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dependsOn")) {
        res.getDependsOn().add(parseConceptMapOtherElementComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("product")) {
        res.getProduct().add(parseConceptMapOtherElementComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConceptMapOtherElementComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConceptMapOtherElementComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.OtherElementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("property")) {
        res.setPropertyElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
        res.setSystemElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
        res.setDisplayElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ConceptMap.ConceptMapGroupUnmappedComponent parseConceptMapConceptMapGroupUnmappedComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ConceptMap.ConceptMapGroupUnmappedComponent res = new ConceptMap.ConceptMapGroupUnmappedComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConceptMapConceptMapGroupUnmappedComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConceptMapConceptMapGroupUnmappedComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.ConceptMapGroupUnmappedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, ConceptMap.ConceptMapGroupUnmappedMode.NULL, new ConceptMap.ConceptMapGroupUnmappedModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
        res.setDisplayElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Condition parseCondition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Condition res = new Condition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConditionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConditionContent(int eventType, XmlPullParser xpp, Condition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("clinicalStatus")) {
        res.setClinicalStatusElement(parseEnumeration(xpp, Condition.ConditionClinicalStatus.NULL, new Condition.ConditionClinicalStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("verificationStatus")) {
        res.setVerificationStatusElement(parseEnumeration(xpp, Condition.ConditionVerificationStatus.NULL, new Condition.ConditionVerificationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("severity")) {
        res.setSeverity(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.getBodySite().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "onset")) {
        res.setOnset(parseType("onset", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "abatement")) {
        res.setAbatement(parseType("abatement", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assertedDate")) {
        res.setAssertedDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("asserter")) {
        res.setAsserter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("stage")) {
        res.getStage().add(parseConditionConditionStageComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("evidence")) {
        res.getEvidence().add(parseConditionConditionEvidenceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Condition.ConditionStageComponent parseConditionConditionStageComponent(XmlPullParser xpp, Condition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConditionConditionStageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConditionConditionStageComponentContent(int eventType, XmlPullParser xpp, Condition owner, Condition.ConditionStageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("summary")) {
        res.setSummary(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assessment")) {
        res.getAssessment().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Condition.ConditionEvidenceComponent parseConditionConditionEvidenceComponent(XmlPullParser xpp, Condition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Condition.ConditionEvidenceComponent res = new Condition.ConditionEvidenceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConditionConditionEvidenceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConditionConditionEvidenceComponentContent(int eventType, XmlPullParser xpp, Condition owner, Condition.ConditionEvidenceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.getCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.getDetail().add(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Consent parseConsent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Consent res = new Consent();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConsentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConsentContent(int eventType, XmlPullParser xpp, Consent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Consent.ConsentState.NULL, new Consent.ConsentStateEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateTime")) {
        res.setDateTimeElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("consentingParty")) {
        res.getConsentingParty().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("organization")) {
        res.getOrganization().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "source")) {
        res.setSource(parseType("source", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("policy")) {
        res.getPolicy().add(parseConsentConsentPolicyComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("policyRule")) {
        res.setPolicyRule(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("verification")) {
        res.getVerification().add(parseConsentConsentVerificationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provision")) {
        res.getProvision().add(parseConsentprovisionComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Consent.ConsentPolicyComponent parseConsentConsentPolicyComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Consent.ConsentPolicyComponent res = new Consent.ConsentPolicyComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConsentConsentPolicyComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConsentConsentPolicyComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.ConsentPolicyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authority")) {
        res.setAuthorityElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uri")) {
        res.setUriElement(parseUri(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Consent.ConsentVerificationComponent parseConsentConsentVerificationComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Consent.ConsentVerificationComponent res = new Consent.ConsentVerificationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConsentConsentVerificationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConsentConsentVerificationComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.ConsentVerificationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("verified")) {
        res.setVerifiedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("verifiedWith")) {
        res.setVerifiedWith(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("verificationDate")) {
        res.setVerificationDateElement(parseDateTime(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Consent.provisionComponent parseConsentprovisionComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Consent.provisionComponent res = new Consent.provisionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConsentprovisionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConsentprovisionComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.provisionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Consent.ConsentProvisionType.NULL, new Consent.ConsentProvisionTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.getActor().add(parseConsentprovisionActorComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
        res.getAction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabel")) {
        res.getSecurityLabel().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.getPurpose().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("class")) {
        res.getClass_().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.getCode().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataPeriod")) {
        res.setDataPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("data")) {
        res.getData().add(parseConsentprovisionDataComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provision")) {
        res.getProvision().add(parseConsentprovisionComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Consent.provisionActorComponent parseConsentprovisionActorComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Consent.provisionActorComponent res = new Consent.provisionActorComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConsentprovisionActorComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConsentprovisionActorComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.provisionActorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReference(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Consent.provisionDataComponent parseConsentprovisionDataComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Consent.provisionDataComponent res = new Consent.provisionDataComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseConsentprovisionDataComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseConsentprovisionDataComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.provisionDataComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("meaning")) {
        res.setMeaningElement(parseEnumeration(xpp, Consent.ConsentDataMeaning.NULL, new Consent.ConsentDataMeaningEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReference(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract parseContract(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract res = new Contract();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractContent(int eventType, XmlPullParser xpp, Contract res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Contract.ContractStatus.NULL, new Contract.ContractStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contentDerivative")) {
        res.setContentDerivative(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issued")) {
        res.setIssuedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("applies")) {
        res.setApplies(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.getSubject().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authority")) {
        res.getAuthority().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("domain")) {
        res.getDomain().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subType")) {
        res.getSubType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("term")) {
        res.getTerm().add(parseContractTermComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("signer")) {
        res.getSigner().add(parseContractSignatoryComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("friendly")) {
        res.getFriendly().add(parseContractFriendlyLanguageComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("legal")) {
        res.getLegal().add(parseContractLegalLanguageComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rule")) {
        res.setRule(parseContractComputableLanguageComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "legallyBinding")) {
        res.setLegallyBinding(parseType("legallyBinding", xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.TermComponent parseContractTermComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.TermComponent res = new Contract.TermComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractTermComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractTermComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.TermComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issued")) {
        res.setIssuedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("applies")) {
        res.setApplies(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subType")) {
        res.setSubType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("offer")) {
        res.setOffer(parseContractContractOfferComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("asset")) {
        res.getAsset().add(parseContractContractAssetComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("agent")) {
        res.getAgent().add(parseContractAgentComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
        res.getAction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actionReason")) {
        res.getActionReason().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("group")) {
        res.getGroup().add(parseContractTermComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.ContractOfferComponent parseContractContractOfferComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ContractOfferComponent res = new Contract.ContractOfferComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractContractOfferComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractContractOfferComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ContractOfferComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
        res.setTopic(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("decision")) {
        res.setDecision(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("linkId")) {
        res.setLinkIdElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.ContractAssetComponent parseContractContractAssetComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ContractAssetComponent res = new Contract.ContractAssetComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractContractAssetComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractContractAssetComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ContractAssetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("class")) {
        res.setClass_(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataPeriod")) {
        res.setDataPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("data")) {
        res.getData().add(parseContractAssetDataComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valuedItem")) {
        res.getValuedItem().add(parseContractValuedItemComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabel")) {
        res.getSecurityLabel().add(parseCoding(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.AssetDataComponent parseContractAssetDataComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.AssetDataComponent res = new Contract.AssetDataComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractAssetDataComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractAssetDataComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.AssetDataComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("meaning")) {
        res.setMeaningElement(parseEnumeration(xpp, Contract.ContractDataMeaning.NULL, new Contract.ContractDataMeaningEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReference(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.ValuedItemComponent parseContractValuedItemComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractValuedItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractValuedItemComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ValuedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "entity")) {
        res.setEntity(parseType("entity", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectiveTime")) {
        res.setEffectiveTimeElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("points")) {
        res.setPointsElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.AgentComponent parseContractAgentComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.AgentComponent res = new Contract.AgentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractAgentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractAgentComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.AgentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.setActor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.getRole().add(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.SignatoryComponent parseContractSignatoryComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.SignatoryComponent res = new Contract.SignatoryComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractSignatoryComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractSignatoryComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.SignatoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("party")) {
        res.setParty(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("signature")) {
        res.getSignature().add(parseSignature(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractFriendlyLanguageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractFriendlyLanguageComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.FriendlyLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "content")) {
        res.setContent(parseType("content", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractLegalLanguageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractLegalLanguageComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.LegalLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "content")) {
        res.setContent(parseType("content", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseContractComputableLanguageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseContractComputableLanguageComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ComputableLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "content")) {
        res.setContent(parseType("content", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Coverage parseCoverage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Coverage res = new Coverage();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCoverageContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageContent(int eventType, XmlPullParser xpp, Coverage res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Coverage.CoverageStatus.NULL, new Coverage.CoverageStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("policyHolder")) {
        res.setPolicyHolder(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subscriber")) {
        res.setSubscriber(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subscriberId")) {
        res.setSubscriberIdElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("beneficiary")) {
        res.setBeneficiary(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
        res.setRelationship(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payor")) {
        res.getPayor().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("grouping")) {
        res.setGrouping(parseCoverageGroupComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dependent")) {
        res.setDependentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("order")) {
        res.setOrderElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("network")) {
        res.setNetworkElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contract")) {
        res.getContract().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Coverage.GroupComponent parseCoverageGroupComponent(XmlPullParser xpp, Coverage owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Coverage.GroupComponent res = new Coverage.GroupComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseCoverageGroupComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseCoverageGroupComponentContent(int eventType, XmlPullParser xpp, Coverage owner, Coverage.GroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("group")) {
        res.setGroupElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupDisplay")) {
        res.setGroupDisplayElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subGroup")) {
        res.setSubGroupElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subGroupDisplay")) {
        res.setSubGroupDisplayElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("plan")) {
        res.setPlanElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("planDisplay")) {
        res.setPlanDisplayElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subPlan")) {
        res.setSubPlanElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subPlanDisplay")) {
        res.setSubPlanDisplayElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("class")) {
        res.setClass_Element(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("classDisplay")) {
        res.setClassDisplayElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subClass")) {
        res.setSubClassElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subClassDisplay")) {
        res.setSubClassDisplayElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DetectedIssue parseDetectedIssue(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DetectedIssue res = new DetectedIssue();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDetectedIssueContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDetectedIssueContent(int eventType, XmlPullParser xpp, DetectedIssue res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, DetectedIssue.DetectedIssueStatus.NULL, new DetectedIssue.DetectedIssueStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("severity")) {
        res.setSeverityElement(parseEnumeration(xpp, DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("implicated")) {
        res.getImplicated().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.setDetailElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReferenceElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mitigation")) {
        res.getMitigation().add(parseDetectedIssueDetectedIssueMitigationComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueDetectedIssueMitigationComponent(XmlPullParser xpp, DetectedIssue owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDetectedIssueDetectedIssueMitigationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDetectedIssueDetectedIssueMitigationComponentContent(int eventType, XmlPullParser xpp, DetectedIssue owner, DetectedIssue.DetectedIssueMitigationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
        res.setAction(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Device parseDevice(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Device res = new Device();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceContent(int eventType, XmlPullParser xpp, Device res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
        res.setUdi(parseDeviceDeviceUdiComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Device.FHIRDeviceStatus.NULL, new Device.FHIRDeviceStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lotNumber")) {
        res.setLotNumberElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturer")) {
        res.setManufacturerElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufactureDate")) {
        res.setManufactureDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expirationDate")) {
        res.setExpirationDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("model")) {
        res.setModelElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("owner")) {
        res.setOwner(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("safety")) {
        res.getSafety().add(parseCodeableConcept(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Device.DeviceUdiComponent parseDeviceDeviceUdiComponent(XmlPullParser xpp, Device owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Device.DeviceUdiComponent res = new Device.DeviceUdiComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceDeviceUdiComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceDeviceUdiComponentContent(int eventType, XmlPullParser xpp, Device owner, Device.DeviceUdiComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("deviceIdentifier")) {
        res.setDeviceIdentifierElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.setJurisdictionElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("carrierHRF")) {
        res.setCarrierHRFElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("carrierAIDC")) {
        res.setCarrierAIDCElement(parseBase64Binary(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issuer")) {
        res.setIssuerElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entryType")) {
        res.setEntryTypeElement(parseEnumeration(xpp, Device.UDIEntryType.NULL, new Device.UDIEntryTypeEnumFactory()));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceComponent parseDeviceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceComponent res = new DeviceComponent();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceComponentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceComponentContent(int eventType, XmlPullParser xpp, DeviceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastSystemChange")) {
        res.setLastSystemChangeElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSource(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parent")) {
        res.setParent(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operationalStatus")) {
        res.getOperationalStatus().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parameterGroup")) {
        res.setParameterGroup(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measurementPrinciple")) {
        res.setMeasurementPrincipleElement(parseEnumeration(xpp, DeviceComponent.MeasmntPrinciple.NULL, new DeviceComponent.MeasmntPrincipleEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productionSpecification")) {
        res.getProductionSpecification().add(parseDeviceComponentDeviceComponentProductionSpecificationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("languageCode")) {
        res.setLanguageCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("property")) {
        res.getProperty().add(parseDeviceComponentDeviceComponentPropertyComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceComponent.DeviceComponentProductionSpecificationComponent parseDeviceComponentDeviceComponentProductionSpecificationComponent(XmlPullParser xpp, DeviceComponent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceComponent.DeviceComponentProductionSpecificationComponent res = new DeviceComponent.DeviceComponentProductionSpecificationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceComponentDeviceComponentProductionSpecificationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceComponentDeviceComponentProductionSpecificationComponentContent(int eventType, XmlPullParser xpp, DeviceComponent owner, DeviceComponent.DeviceComponentProductionSpecificationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specType")) {
        res.setSpecType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("componentId")) {
        res.setComponentId(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productionSpec")) {
        res.setProductionSpecElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceComponent.DeviceComponentPropertyComponent parseDeviceComponentDeviceComponentPropertyComponent(XmlPullParser xpp, DeviceComponent owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceComponent.DeviceComponentPropertyComponent res = new DeviceComponent.DeviceComponentPropertyComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceComponentDeviceComponentPropertyComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceComponentDeviceComponentPropertyComponentContent(int eventType, XmlPullParser xpp, DeviceComponent owner, DeviceComponent.DeviceComponentPropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueQuantity")) {
        res.getValueQuantity().add(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("valueCode")) {
        res.getValueCode().add(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceMetric parseDeviceMetric(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceMetric res = new DeviceMetric();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceMetricContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceMetricContent(int eventType, XmlPullParser xpp, DeviceMetric res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unit")) {
        res.setUnit(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSource(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parent")) {
        res.setParent(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operationalStatus")) {
        res.setOperationalStatusElement(parseEnumeration(xpp, DeviceMetric.DeviceMetricOperationalStatus.NULL, new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("color")) {
        res.setColorElement(parseEnumeration(xpp, DeviceMetric.DeviceMetricColor.NULL, new DeviceMetric.DeviceMetricColorEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategoryElement(parseEnumeration(xpp, DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measurementPeriod")) {
        res.setMeasurementPeriod(parseTiming(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("calibration")) {
        res.getCalibration().add(parseDeviceMetricDeviceMetricCalibrationComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricDeviceMetricCalibrationComponent(XmlPullParser xpp, DeviceMetric owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceMetricDeviceMetricCalibrationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceMetricDeviceMetricCalibrationComponentContent(int eventType, XmlPullParser xpp, DeviceMetric owner, DeviceMetric.DeviceMetricCalibrationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, DeviceMetric.DeviceMetricCalibrationType.NULL, new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("state")) {
        res.setStateElement(parseEnumeration(xpp, DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("time")) {
        res.setTimeElement(parseInstant(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceRequest parseDeviceRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceRequest res = new DeviceRequest();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceRequestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceRequestContent(int eventType, XmlPullParser xpp, DeviceRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.getDefinition().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priorRequest")) {
        res.getPriorRequest().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupIdentifier")) {
        res.setGroupIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, DeviceRequest.DeviceRequestStatus.NULL, new DeviceRequest.DeviceRequestStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intent")) {
        res.setIntent(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriorityElement(parseEnumeration(xpp, DeviceRequest.RequestPriority.NULL, new DeviceRequest.RequestPriorityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "code")) {
        res.setCode(parseType("code", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
        res.setOccurrence(parseType("occurrence", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authoredOn")) {
        res.setAuthoredOnElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requester")) {
        res.setRequester(parseDeviceRequestDeviceRequestRequesterComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performerType")) {
        res.setPerformerType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.setPerformer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfo")) {
        res.getSupportingInfo().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relevantHistory")) {
        res.getRelevantHistory().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceRequest.DeviceRequestRequesterComponent parseDeviceRequestDeviceRequestRequesterComponent(XmlPullParser xpp, DeviceRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceRequest.DeviceRequestRequesterComponent res = new DeviceRequest.DeviceRequestRequesterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceRequestDeviceRequestRequesterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceRequestDeviceRequestRequesterComponentContent(int eventType, XmlPullParser xpp, DeviceRequest owner, DeviceRequest.DeviceRequestRequesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("agent")) {
        res.setAgent(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onBehalfOf")) {
        res.setOnBehalfOf(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DeviceUseStatement parseDeviceUseStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DeviceUseStatement res = new DeviceUseStatement();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDeviceUseStatementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDeviceUseStatementContent(int eventType, XmlPullParser xpp, DeviceUseStatement res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, DeviceUseStatement.DeviceUseStatementStatus.NULL, new DeviceUseStatement.DeviceUseStatementStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("whenUsed")) {
        res.setWhenUsed(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "timing")) {
        res.setTiming(parseType("timing", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recordedOn")) {
        res.setRecordedOnElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSource(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
        res.setDevice(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("indication")) {
        res.getIndication().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.setBodySite(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DiagnosticReport parseDiagnosticReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DiagnosticReport res = new DiagnosticReport();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDiagnosticReportContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDiagnosticReportContent(int eventType, XmlPullParser xpp, DiagnosticReport res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "effective")) {
        res.setEffective(parseType("effective", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issued")) {
        res.setIssuedElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.getPerformer().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resultsInterpreter")) {
        res.getResultsInterpreter().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specimen")) {
        res.getSpecimen().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("result")) {
        res.getResult().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("imagingStudy")) {
        res.getImagingStudy().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("image")) {
        res.getImage().add(parseDiagnosticReportDiagnosticReportImageComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conclusion")) {
        res.setConclusionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("codedDiagnosis")) {
        res.getCodedDiagnosis().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("presentedForm")) {
        res.getPresentedForm().add(parseAttachment(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DiagnosticReport.DiagnosticReportImageComponent parseDiagnosticReportDiagnosticReportImageComponent(XmlPullParser xpp, DiagnosticReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DiagnosticReport.DiagnosticReportImageComponent res = new DiagnosticReport.DiagnosticReportImageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDiagnosticReportDiagnosticReportImageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDiagnosticReportDiagnosticReportImageComponentContent(int eventType, XmlPullParser xpp, DiagnosticReport owner, DiagnosticReport.DiagnosticReportImageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
        res.setLink(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DocumentManifest parseDocumentManifest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentManifest res = new DocumentManifest();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDocumentManifestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentManifestContent(int eventType, XmlPullParser xpp, DocumentManifest res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("masterIdentifier")) {
        res.setMasterIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("agent")) {
        res.getAgent().add(parseDocumentManifestDocumentManifestAgentComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recipient")) {
        res.getRecipient().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSourceElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("content")) {
        res.getContent().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("related")) {
        res.getRelated().add(parseDocumentManifestDocumentManifestRelatedComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DocumentManifest.DocumentManifestAgentComponent parseDocumentManifestDocumentManifestAgentComponent(XmlPullParser xpp, DocumentManifest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentManifest.DocumentManifestAgentComponent res = new DocumentManifest.DocumentManifestAgentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDocumentManifestDocumentManifestAgentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentManifestDocumentManifestAgentComponentContent(int eventType, XmlPullParser xpp, DocumentManifest owner, DocumentManifest.DocumentManifestAgentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("who")) {
        res.setWho(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DocumentManifest.DocumentManifestRelatedComponent parseDocumentManifestDocumentManifestRelatedComponent(XmlPullParser xpp, DocumentManifest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentManifest.DocumentManifestRelatedComponent res = new DocumentManifest.DocumentManifestRelatedComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDocumentManifestDocumentManifestRelatedComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentManifestDocumentManifestRelatedComponentContent(int eventType, XmlPullParser xpp, DocumentManifest owner, DocumentManifest.DocumentManifestRelatedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ref")) {
        res.setRef(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DocumentReference parseDocumentReference(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentReference res = new DocumentReference();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDocumentReferenceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentReferenceContent(int eventType, XmlPullParser xpp, DocumentReference res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("masterIdentifier")) {
        res.setMasterIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("docStatus")) {
        res.setDocStatusElement(parseEnumeration(xpp, DocumentReference.ReferredDocumentStatus.NULL, new DocumentReference.ReferredDocumentStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("class")) {
        res.setClass_(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("agent")) {
        res.getAgent().add(parseDocumentReferenceDocumentReferenceAgentComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authenticator")) {
        res.setAuthenticator(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("custodian")) {
        res.setCustodian(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatesTo")) {
        res.getRelatesTo().add(parseDocumentReferenceDocumentReferenceRelatesToComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("securityLabel")) {
        res.getSecurityLabel().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("content")) {
        res.getContent().add(parseDocumentReferenceDocumentReferenceContentComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseDocumentReferenceDocumentReferenceContextComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DocumentReference.DocumentReferenceAgentComponent parseDocumentReferenceDocumentReferenceAgentComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceAgentComponent res = new DocumentReference.DocumentReferenceAgentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDocumentReferenceDocumentReferenceAgentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentReferenceDocumentReferenceAgentComponentContent(int eventType, XmlPullParser xpp, DocumentReference owner, DocumentReference.DocumentReferenceAgentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("who")) {
        res.setWho(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceDocumentReferenceRelatesToComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDocumentReferenceDocumentReferenceRelatesToComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentReferenceDocumentReferenceRelatesToComponentContent(int eventType, XmlPullParser xpp, DocumentReference owner, DocumentReference.DocumentReferenceRelatesToComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseEnumeration(xpp, DocumentReference.DocumentRelationshipType.NULL, new DocumentReference.DocumentRelationshipTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.setTarget(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceDocumentReferenceContentComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDocumentReferenceDocumentReferenceContentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentReferenceDocumentReferenceContentComponentContent(int eventType, XmlPullParser xpp, DocumentReference owner, DocumentReference.DocumentReferenceContentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("attachment")) {
        res.setAttachment(parseAttachment(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("format")) {
        res.setFormat(parseCoding(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DocumentReference.DocumentReferenceContextComponent parseDocumentReferenceDocumentReferenceContextComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContextComponent res = new DocumentReference.DocumentReferenceContextComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDocumentReferenceDocumentReferenceContextComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentReferenceDocumentReferenceContextComponentContent(int eventType, XmlPullParser xpp, DocumentReference owner, DocumentReference.DocumentReferenceContextComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("event")) {
        res.getEvent().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("facilityType")) {
        res.setFacilityType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("practiceSetting")) {
        res.setPracticeSetting(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sourcePatientInfo")) {
        res.setSourcePatientInfo(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("related")) {
        res.getRelated().add(parseDocumentReferenceDocumentReferenceContextRelatedComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected DocumentReference.DocumentReferenceContextRelatedComponent parseDocumentReferenceDocumentReferenceContextRelatedComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContextRelatedComponent res = new DocumentReference.DocumentReferenceContextRelatedComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseDocumentReferenceDocumentReferenceContextRelatedComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseDocumentReferenceDocumentReferenceContextRelatedComponentContent(int eventType, XmlPullParser xpp, DocumentReference owner, DocumentReference.DocumentReferenceContextRelatedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ref")) {
        res.setRef(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EligibilityRequest parseEligibilityRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EligibilityRequest res = new EligibilityRequest();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEligibilityRequestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEligibilityRequestContent(int eventType, XmlPullParser xpp, EligibilityRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, EligibilityRequest.EligibilityRequestStatus.NULL, new EligibilityRequest.EligibilityRequestStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriority(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "serviced")) {
        res.setServiced(parseType("serviced", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enterer")) {
        res.setEnterer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
        res.setProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("organization")) {
        res.setOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurer")) {
        res.setInsurer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("facility")) {
        res.setFacility(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
        res.setCoverage(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("businessArrangement")) {
        res.setBusinessArrangementElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("benefitCategory")) {
        res.setBenefitCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("benefitSubCategory")) {
        res.setBenefitSubCategory(parseCodeableConcept(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EligibilityResponse parseEligibilityResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EligibilityResponse res = new EligibilityResponse();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEligibilityResponseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEligibilityResponseContent(int eventType, XmlPullParser xpp, EligibilityResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, EligibilityResponse.EligibilityResponseStatus.NULL, new EligibilityResponse.EligibilityResponseStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestProvider")) {
        res.setRequestProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestOrganization")) {
        res.setRequestOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.setRequest(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcomeElement(parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("disposition")) {
        res.setDispositionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurer")) {
        res.setInsurer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("inforce")) {
        res.setInforceElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurance")) {
        res.getInsurance().add(parseEligibilityResponseInsuranceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("form")) {
        res.setForm(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("error")) {
        res.getError().add(parseEligibilityResponseErrorsComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EligibilityResponse.InsuranceComponent parseEligibilityResponseInsuranceComponent(XmlPullParser xpp, EligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    EligibilityResponse.InsuranceComponent res = new EligibilityResponse.InsuranceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEligibilityResponseInsuranceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEligibilityResponseInsuranceComponentContent(int eventType, XmlPullParser xpp, EligibilityResponse owner, EligibilityResponse.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
        res.setCoverage(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contract")) {
        res.setContract(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("benefitBalance")) {
        res.getBenefitBalance().add(parseEligibilityResponseBenefitsComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EligibilityResponse.BenefitsComponent parseEligibilityResponseBenefitsComponent(XmlPullParser xpp, EligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    EligibilityResponse.BenefitsComponent res = new EligibilityResponse.BenefitsComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEligibilityResponseBenefitsComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEligibilityResponseBenefitsComponentContent(int eventType, XmlPullParser xpp, EligibilityResponse owner, EligibilityResponse.BenefitsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subCategory")) {
        res.setSubCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("excluded")) {
        res.setExcludedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("network")) {
        res.setNetwork(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unit")) {
        res.setUnit(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("term")) {
        res.setTerm(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("financial")) {
        res.getFinancial().add(parseEligibilityResponseBenefitComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EligibilityResponse.BenefitComponent parseEligibilityResponseBenefitComponent(XmlPullParser xpp, EligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    EligibilityResponse.BenefitComponent res = new EligibilityResponse.BenefitComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEligibilityResponseBenefitComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEligibilityResponseBenefitComponentContent(int eventType, XmlPullParser xpp, EligibilityResponse owner, EligibilityResponse.BenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "allowed")) {
        res.setAllowed(parseType("allowed", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "used")) {
        res.setUsed(parseType("used", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EligibilityResponse.ErrorsComponent parseEligibilityResponseErrorsComponent(XmlPullParser xpp, EligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    EligibilityResponse.ErrorsComponent res = new EligibilityResponse.ErrorsComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEligibilityResponseErrorsComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEligibilityResponseErrorsComponentContent(int eventType, XmlPullParser xpp, EligibilityResponse owner, EligibilityResponse.ErrorsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Encounter parseEncounter(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter res = new Encounter();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEncounterContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterContent(int eventType, XmlPullParser xpp, Encounter res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusHistory")) {
        res.getStatusHistory().add(parseEncounterStatusHistoryComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("class")) {
        res.setClass_(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("classHistory")) {
        res.getClassHistory().add(parseEncounterClassHistoryComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriority(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("episodeOfCare")) {
        res.getEpisodeOfCare().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("incomingReferral")) {
        res.getIncomingReferral().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
        res.getParticipant().add(parseEncounterEncounterParticipantComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("appointment")) {
        res.setAppointment(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("length")) {
        res.setLength(parseDuration(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.getReason().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosis")) {
        res.getDiagnosis().add(parseEncounterDiagnosisComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("account")) {
        res.getAccount().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hospitalization")) {
        res.setHospitalization(parseEncounterEncounterHospitalizationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.getLocation().add(parseEncounterEncounterLocationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serviceProvider")) {
        res.setServiceProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.setPartOf(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Encounter.StatusHistoryComponent parseEncounterStatusHistoryComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter.StatusHistoryComponent res = new Encounter.StatusHistoryComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEncounterStatusHistoryComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterStatusHistoryComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.StatusHistoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Encounter.ClassHistoryComponent parseEncounterClassHistoryComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter.ClassHistoryComponent res = new Encounter.ClassHistoryComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEncounterClassHistoryComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterClassHistoryComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.ClassHistoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("class")) {
        res.setClass_(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Encounter.EncounterParticipantComponent parseEncounterEncounterParticipantComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEncounterEncounterParticipantComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterEncounterParticipantComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.EncounterParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("individual")) {
        res.setIndividual(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Encounter.DiagnosisComponent parseEncounterDiagnosisComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter.DiagnosisComponent res = new Encounter.DiagnosisComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEncounterDiagnosisComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterDiagnosisComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
        res.setCondition(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rank")) {
        res.setRankElement(parsePositiveInt(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Encounter.EncounterHospitalizationComponent parseEncounterEncounterHospitalizationComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter.EncounterHospitalizationComponent res = new Encounter.EncounterHospitalizationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEncounterEncounterHospitalizationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterEncounterHospitalizationComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.EncounterHospitalizationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAdmissionIdentifier")) {
        res.setPreAdmissionIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("origin")) {
        res.setOrigin(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("admitSource")) {
        res.setAdmitSource(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reAdmission")) {
        res.setReAdmission(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dietPreference")) {
        res.getDietPreference().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialCourtesy")) {
        res.getSpecialCourtesy().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialArrangement")) {
        res.getSpecialArrangement().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("destination")) {
        res.setDestination(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dischargeDisposition")) {
        res.setDischargeDisposition(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Encounter.EncounterLocationComponent parseEncounterEncounterLocationComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEncounterEncounterLocationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEncounterEncounterLocationComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.EncounterLocationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Encounter.EncounterLocationStatus.NULL, new Encounter.EncounterLocationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Endpoint parseEndpoint(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Endpoint res = new Endpoint();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEndpointContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEndpointContent(int eventType, XmlPullParser xpp, Endpoint res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Endpoint.EndpointStatus.NULL, new Endpoint.EndpointStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("connectionType")) {
        res.setConnectionType(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("managingOrganization")) {
        res.setManagingOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payloadType")) {
        res.getPayloadType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payloadMimeType")) {
        res.getPayloadMimeType().add(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
        res.setAddressElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("header")) {
        res.getHeader().add(parseString(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EnrollmentRequest parseEnrollmentRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EnrollmentRequest res = new EnrollmentRequest();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEnrollmentRequestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEnrollmentRequestContent(int eventType, XmlPullParser xpp, EnrollmentRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, EnrollmentRequest.EnrollmentRequestStatus.NULL, new EnrollmentRequest.EnrollmentRequestStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurer")) {
        res.setInsurer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
        res.setProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("organization")) {
        res.setOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("candidate")) {
        res.setCandidate(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
        res.setCoverage(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EnrollmentResponse parseEnrollmentResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EnrollmentResponse res = new EnrollmentResponse();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEnrollmentResponseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEnrollmentResponseContent(int eventType, XmlPullParser xpp, EnrollmentResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, EnrollmentResponse.EnrollmentResponseStatus.NULL, new EnrollmentResponse.EnrollmentResponseStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.setRequest(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcomeElement(parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("disposition")) {
        res.setDispositionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("organization")) {
        res.setOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestProvider")) {
        res.setRequestProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestOrganization")) {
        res.setRequestOrganization(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EpisodeOfCare parseEpisodeOfCare(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EpisodeOfCare res = new EpisodeOfCare();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEpisodeOfCareContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEpisodeOfCareContent(int eventType, XmlPullParser xpp, EpisodeOfCare res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusHistory")) {
        res.getStatusHistory().add(parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosis")) {
        res.getDiagnosis().add(parseEpisodeOfCareDiagnosisComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("managingOrganization")) {
        res.setManagingOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referralRequest")) {
        res.getReferralRequest().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("careManager")) {
        res.setCareManager(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("team")) {
        res.getTeam().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("account")) {
        res.getAccount().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(XmlPullParser xpp, EpisodeOfCare owner) throws XmlPullParserException, IOException, FHIRFormatError {
    EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEpisodeOfCareEpisodeOfCareStatusHistoryComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEpisodeOfCareEpisodeOfCareStatusHistoryComponentContent(int eventType, XmlPullParser xpp, EpisodeOfCare owner, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EpisodeOfCare.DiagnosisComponent parseEpisodeOfCareDiagnosisComponent(XmlPullParser xpp, EpisodeOfCare owner) throws XmlPullParserException, IOException, FHIRFormatError {
    EpisodeOfCare.DiagnosisComponent res = new EpisodeOfCare.DiagnosisComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEpisodeOfCareDiagnosisComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEpisodeOfCareDiagnosisComponentContent(int eventType, XmlPullParser xpp, EpisodeOfCare owner, EpisodeOfCare.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
        res.setCondition(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rank")) {
        res.setRankElement(parsePositiveInt(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected EventDefinition parseEventDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    EventDefinition res = new EventDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseEventDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseEventDefinitionContent(int eventType, XmlPullParser xpp, EventDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
        res.setUsageElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
        res.setApprovalDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
        res.setLastReviewDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
        res.setEffectivePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
        res.getTopic().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contributor")) {
        res.getContributor().add(parseContributor(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
        res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("trigger")) {
        res.setTrigger(parseTriggerDefinition(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario parseExampleScenario(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario res = new ExampleScenario();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioContent(int eventType, XmlPullParser xpp, ExampleScenario res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.getActor().add(parseExampleScenarioExampleScenarioActorComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instance")) {
        res.getInstance().add(parseExampleScenarioExampleScenarioInstanceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("process")) {
        res.setProcess(parseExampleScenarioExampleScenarioProcessComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("workflow")) {
        res.getWorkflow().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario.ExampleScenarioActorComponent parseExampleScenarioExampleScenarioActorComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioActorComponent res = new ExampleScenario.ExampleScenarioActorComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioExampleScenarioActorComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioExampleScenarioActorComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioActorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actorId")) {
        res.setActorIdElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, ExampleScenario.ExampleScenarioActorType.NULL, new ExampleScenario.ExampleScenarioActorTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario.ExampleScenarioInstanceComponent parseExampleScenarioExampleScenarioInstanceComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioExampleScenarioInstanceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioExampleScenarioInstanceComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resourceId")) {
        res.setResourceIdElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resourceType")) {
        res.setResourceTypeElement(parseEnumeration(xpp, ExampleScenario.FHIRResourceType.NULL, new ExampleScenario.FHIRResourceTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.getVersion().add(parseExampleScenarioExampleScenarioInstanceVersionComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("containedInstance")) {
        res.getContainedInstance().add(parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario.ExampleScenarioInstanceVersionComponent parseExampleScenarioExampleScenarioInstanceVersionComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceVersionComponent res = new ExampleScenario.ExampleScenarioInstanceVersionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioExampleScenarioInstanceVersionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioExampleScenarioInstanceVersionComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioInstanceVersionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("versionId")) {
        res.setVersionIdElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioExampleScenarioInstanceContainedInstanceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioExampleScenarioInstanceContainedInstanceComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resourceId")) {
        res.setResourceIdElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("versionId")) {
        res.setVersionIdElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario.ExampleScenarioProcessComponent parseExampleScenarioExampleScenarioProcessComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessComponent res = new ExampleScenario.ExampleScenarioProcessComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioExampleScenarioProcessComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioExampleScenarioProcessComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preConditions")) {
        res.setPreConditionsElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("postConditions")) {
        res.setPostConditionsElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("step")) {
        res.getStep().add(parseExampleScenarioExampleScenarioProcessStepComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario.ExampleScenarioProcessStepComponent parseExampleScenarioExampleScenarioProcessStepComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepComponent res = new ExampleScenario.ExampleScenarioProcessStepComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioExampleScenarioProcessStepComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioExampleScenarioProcessStepComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessStepComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("process")) {
        res.getProcess().add(parseExampleScenarioExampleScenarioProcessComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("pause")) {
        res.setPauseElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operation")) {
        res.setOperation(parseExampleScenarioExampleScenarioProcessStepOperationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("alternative")) {
        res.setAlternative(parseExampleScenarioExampleScenarioProcessStepAlternativeComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario.ExampleScenarioProcessStepOperationComponent parseExampleScenarioExampleScenarioProcessStepOperationComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepOperationComponent res = new ExampleScenario.ExampleScenarioProcessStepOperationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioExampleScenarioProcessStepOperationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioExampleScenarioProcessStepOperationComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessStepOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("number")) {
        res.setNumberElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("initiator")) {
        res.setInitiatorElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("receiver")) {
        res.setReceiverElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("initiatorActive")) {
        res.setInitiatorActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("receiverActive")) {
        res.setReceiverActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.setRequest(parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("response")) {
        res.setResponse(parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario.ExampleScenarioProcessStepAlternativeComponent parseExampleScenarioExampleScenarioProcessStepAlternativeComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res = new ExampleScenario.ExampleScenarioProcessStepAlternativeComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioExampleScenarioProcessStepAlternativeComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioExampleScenarioProcessStepAlternativeComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("option")) {
        res.getOption().add(parseExampleScenarioExampleScenarioProcessStepAlternativeOptionComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExampleScenario.ExampleScenarioProcessStepAlternativeOptionComponent parseExampleScenarioExampleScenarioProcessStepAlternativeOptionComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepAlternativeOptionComponent res = new ExampleScenario.ExampleScenarioProcessStepAlternativeOptionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExampleScenarioExampleScenarioProcessStepAlternativeOptionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExampleScenarioExampleScenarioProcessStepAlternativeOptionComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessStepAlternativeOptionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("step")) {
        res.getStep().add(parseExampleScenarioExampleScenarioProcessStepComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("pause")) {
        res.getPause().add(parseBoolean(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExpansionProfile parseExpansionProfile(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExpansionProfile res = new ExpansionProfile();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExpansionProfileContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExpansionProfileContent(int eventType, XmlPullParser xpp, ExpansionProfile res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fixedVersion")) {
        res.getFixedVersion().add(parseExpansionProfileExpansionProfileFixedVersionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("excludedSystem")) {
        res.setExcludedSystem(parseExpansionProfileExpansionProfileExcludedSystemComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("includeDesignations")) {
        res.setIncludeDesignationsElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("designation")) {
        res.setDesignation(parseExpansionProfileExpansionProfileDesignationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("includeDefinition")) {
        res.setIncludeDefinitionElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("activeOnly")) {
        res.setActiveOnlyElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("excludeNested")) {
        res.setExcludeNestedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("excludeNotForUI")) {
        res.setExcludeNotForUIElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("excludePostCoordinated")) {
        res.setExcludePostCoordinatedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("displayLanguage")) {
        res.setDisplayLanguageElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("limitedExpansion")) {
        res.setLimitedExpansionElement(parseBoolean(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExpansionProfile.ExpansionProfileFixedVersionComponent parseExpansionProfileExpansionProfileFixedVersionComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExpansionProfile.ExpansionProfileFixedVersionComponent res = new ExpansionProfile.ExpansionProfileFixedVersionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExpansionProfileExpansionProfileFixedVersionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExpansionProfileExpansionProfileFixedVersionComponentContent(int eventType, XmlPullParser xpp, ExpansionProfile owner, ExpansionProfile.ExpansionProfileFixedVersionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
        res.setSystemElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, ExpansionProfile.SystemVersionProcessingMode.NULL, new ExpansionProfile.SystemVersionProcessingModeEnumFactory()));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExpansionProfile.ExpansionProfileExcludedSystemComponent parseExpansionProfileExpansionProfileExcludedSystemComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExpansionProfile.ExpansionProfileExcludedSystemComponent res = new ExpansionProfile.ExpansionProfileExcludedSystemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExpansionProfileExpansionProfileExcludedSystemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExpansionProfileExpansionProfileExcludedSystemComponentContent(int eventType, XmlPullParser xpp, ExpansionProfile owner, ExpansionProfile.ExpansionProfileExcludedSystemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
        res.setSystemElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExpansionProfile.ExpansionProfileDesignationComponent parseExpansionProfileExpansionProfileDesignationComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExpansionProfile.ExpansionProfileDesignationComponent res = new ExpansionProfile.ExpansionProfileDesignationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExpansionProfileExpansionProfileDesignationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExpansionProfileExpansionProfileDesignationComponentContent(int eventType, XmlPullParser xpp, ExpansionProfile owner, ExpansionProfile.ExpansionProfileDesignationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("include")) {
        res.setInclude(parseExpansionProfileDesignationIncludeComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("exclude")) {
        res.setExclude(parseExpansionProfileDesignationExcludeComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExpansionProfile.DesignationIncludeComponent parseExpansionProfileDesignationIncludeComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExpansionProfile.DesignationIncludeComponent res = new ExpansionProfile.DesignationIncludeComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExpansionProfileDesignationIncludeComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExpansionProfileDesignationIncludeComponentContent(int eventType, XmlPullParser xpp, ExpansionProfile owner, ExpansionProfile.DesignationIncludeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("designation")) {
        res.getDesignation().add(parseExpansionProfileDesignationIncludeDesignationComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExpansionProfile.DesignationIncludeDesignationComponent parseExpansionProfileDesignationIncludeDesignationComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExpansionProfile.DesignationIncludeDesignationComponent res = new ExpansionProfile.DesignationIncludeDesignationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExpansionProfileDesignationIncludeDesignationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExpansionProfileDesignationIncludeDesignationComponentContent(int eventType, XmlPullParser xpp, ExpansionProfile owner, ExpansionProfile.DesignationIncludeDesignationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguageElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUse(parseCoding(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExpansionProfile.DesignationExcludeComponent parseExpansionProfileDesignationExcludeComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExpansionProfile.DesignationExcludeComponent res = new ExpansionProfile.DesignationExcludeComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExpansionProfileDesignationExcludeComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExpansionProfileDesignationExcludeComponentContent(int eventType, XmlPullParser xpp, ExpansionProfile owner, ExpansionProfile.DesignationExcludeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("designation")) {
        res.getDesignation().add(parseExpansionProfileDesignationExcludeDesignationComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExpansionProfile.DesignationExcludeDesignationComponent parseExpansionProfileDesignationExcludeDesignationComponent(XmlPullParser xpp, ExpansionProfile owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExpansionProfile.DesignationExcludeDesignationComponent res = new ExpansionProfile.DesignationExcludeDesignationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExpansionProfileDesignationExcludeDesignationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExpansionProfileDesignationExcludeDesignationComponentContent(int eventType, XmlPullParser xpp, ExpansionProfile owner, ExpansionProfile.DesignationExcludeDesignationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguageElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUse(parseCoding(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit parseExplanationOfBenefit(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit res = new ExplanationOfBenefit();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, ExplanationOfBenefit.ExplanationOfBenefitStatus.NULL, new ExplanationOfBenefit.ExplanationOfBenefitStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subType")) {
        res.getSubType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("billablePeriod")) {
        res.setBillablePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enterer")) {
        res.setEnterer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurer")) {
        res.setInsurer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
        res.setProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("organization")) {
        res.setOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referral")) {
        res.setReferral(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("facility")) {
        res.setFacility(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("claim")) {
        res.setClaim(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("claimResponse")) {
        res.setClaimResponse(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcomeElement(parseEnumeration(xpp, ExplanationOfBenefit.RemittanceOutcome.NULL, new ExplanationOfBenefit.RemittanceOutcomeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("disposition")) {
        res.setDispositionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("related")) {
        res.getRelated().add(parseExplanationOfBenefitRelatedClaimComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prescription")) {
        res.setPrescription(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("originalPrescription")) {
        res.setOriginalPrescription(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payee")) {
        res.setPayee(parseExplanationOfBenefitPayeeComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("information")) {
        res.getInformation().add(parseExplanationOfBenefitSupportingInformationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("careTeam")) {
        res.getCareTeam().add(parseExplanationOfBenefitCareTeamComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosis")) {
        res.getDiagnosis().add(parseExplanationOfBenefitDiagnosisComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedure")) {
        res.getProcedure().add(parseExplanationOfBenefitProcedureComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("precedence")) {
        res.setPrecedenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("insurance")) {
        res.setInsurance(parseExplanationOfBenefitInsuranceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("accident")) {
        res.setAccident(parseExplanationOfBenefitAccidentComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("employmentImpacted")) {
        res.setEmploymentImpacted(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hospitalization")) {
        res.setHospitalization(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.getItem().add(parseExplanationOfBenefitItemComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("addItem")) {
        res.getAddItem().add(parseExplanationOfBenefitAddedItemComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("totalCost")) {
        res.setTotalCost(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unallocDeductable")) {
        res.setUnallocDeductable(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("totalBenefit")) {
        res.setTotalBenefit(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payment")) {
        res.setPayment(parseExplanationOfBenefitPaymentComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("form")) {
        res.setForm(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("processNote")) {
        res.getProcessNote().add(parseExplanationOfBenefitNoteComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("benefitBalance")) {
        res.getBenefitBalance().add(parseExplanationOfBenefitBenefitBalanceComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.RelatedClaimComponent parseExplanationOfBenefitRelatedClaimComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.RelatedClaimComponent res = new ExplanationOfBenefit.RelatedClaimComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitRelatedClaimComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitRelatedClaimComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.RelatedClaimComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("claim")) {
        res.setClaim(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
        res.setRelationship(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReference(parseIdentifier(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.PayeeComponent parseExplanationOfBenefitPayeeComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.PayeeComponent res = new ExplanationOfBenefit.PayeeComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitPayeeComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitPayeeComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.PayeeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.setResource(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("party")) {
        res.setParty(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.SupportingInformationComponent parseExplanationOfBenefitSupportingInformationComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.SupportingInformationComponent res = new ExplanationOfBenefit.SupportingInformationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitSupportingInformationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitSupportingInformationComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.SupportingInformationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "timing")) {
        res.setTiming(parseType("timing", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.setReason(parseCoding(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.CareTeamComponent parseExplanationOfBenefitCareTeamComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.CareTeamComponent res = new ExplanationOfBenefit.CareTeamComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitCareTeamComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitCareTeamComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.CareTeamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
        res.setProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responsible")) {
        res.setResponsibleElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("qualification")) {
        res.setQualification(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.DiagnosisComponent parseExplanationOfBenefitDiagnosisComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.DiagnosisComponent res = new ExplanationOfBenefit.DiagnosisComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitDiagnosisComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitDiagnosisComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "diagnosis")) {
        res.setDiagnosis(parseType("diagnosis", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("packageCode")) {
        res.setPackageCode(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.ProcedureComponent parseExplanationOfBenefitProcedureComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.ProcedureComponent res = new ExplanationOfBenefit.ProcedureComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitProcedureComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitProcedureComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.ProcedureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "procedure")) {
        res.setProcedure(parseType("procedure", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.InsuranceComponent parseExplanationOfBenefitInsuranceComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.InsuranceComponent res = new ExplanationOfBenefit.InsuranceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitInsuranceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitInsuranceComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverage")) {
        res.setCoverage(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preAuthRef")) {
        res.getPreAuthRef().add(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.AccidentComponent parseExplanationOfBenefitAccidentComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.AccidentComponent res = new ExplanationOfBenefit.AccidentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitAccidentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitAccidentComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.AccidentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "location")) {
        res.setLocation(parseType("location", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.ItemComponent parseExplanationOfBenefitItemComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.ItemComponent res = new ExplanationOfBenefit.ItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitItemComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.ItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("careTeamLinkId")) {
        res.getCareTeamLinkId().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnosisLinkId")) {
        res.getDiagnosisLinkId().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedureLinkId")) {
        res.getProcedureLinkId().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("informationLinkId")) {
        res.getInformationLinkId().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("revenue")) {
        res.setRevenue(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("service")) {
        res.setService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
        res.getProgramCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "serviced")) {
        res.setServiced(parseType("serviced", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "location")) {
        res.setLocation(parseType("location", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
        res.getUdi().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.setBodySite(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subSite")) {
        res.getSubSite().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.getEncounter().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.getDetail().add(parseExplanationOfBenefitDetailComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.AdjudicationComponent parseExplanationOfBenefitAdjudicationComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.AdjudicationComponent res = new ExplanationOfBenefit.AdjudicationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitAdjudicationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitAdjudicationComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.AdjudicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.setReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseDecimal(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.DetailComponent parseExplanationOfBenefitDetailComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.DetailComponent res = new ExplanationOfBenefit.DetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.DetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("revenue")) {
        res.setRevenue(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("service")) {
        res.setService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
        res.getProgramCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
        res.getUdi().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subDetail")) {
        res.getSubDetail().add(parseExplanationOfBenefitSubDetailComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.SubDetailComponent parseExplanationOfBenefitSubDetailComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.SubDetailComponent res = new ExplanationOfBenefit.SubDetailComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitSubDetailComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitSubDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.SubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequence")) {
        res.setSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("revenue")) {
        res.setRevenue(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("service")) {
        res.setService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programCode")) {
        res.getProgramCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unitPrice")) {
        res.setUnitPrice(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("factor")) {
        res.setFactorElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("net")) {
        res.setNet(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("udi")) {
        res.getUdi().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.AddedItemComponent parseExplanationOfBenefitAddedItemComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemComponent res = new ExplanationOfBenefit.AddedItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitAddedItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitAddedItemComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequenceLinkId")) {
        res.getSequenceLinkId().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detailSequenceLinkId")) {
        res.getDetailSequenceLinkId().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subdetailSequenceLinkId")) {
        res.getSubdetailSequenceLinkId().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("service")) {
        res.setService(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fee")) {
        res.setFee(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("noteNumber")) {
        res.getNoteNumber().add(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjudication")) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.PaymentComponent parseExplanationOfBenefitPaymentComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.PaymentComponent res = new ExplanationOfBenefit.PaymentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitPaymentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitPaymentComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.PaymentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjustment")) {
        res.setAdjustment(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("adjustmentReason")) {
        res.setAdjustmentReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.NoteComponent parseExplanationOfBenefitNoteComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.NoteComponent res = new ExplanationOfBenefit.NoteComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitNoteComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitNoteComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.NoteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("number")) {
        res.setNumberElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguage(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.BenefitBalanceComponent parseExplanationOfBenefitBenefitBalanceComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.BenefitBalanceComponent res = new ExplanationOfBenefit.BenefitBalanceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitBenefitBalanceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitBenefitBalanceComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.BenefitBalanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subCategory")) {
        res.setSubCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("excluded")) {
        res.setExcludedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("network")) {
        res.setNetwork(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("unit")) {
        res.setUnit(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("term")) {
        res.setTerm(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("financial")) {
        res.getFinancial().add(parseExplanationOfBenefitBenefitComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ExplanationOfBenefit.BenefitComponent parseExplanationOfBenefitBenefitComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ExplanationOfBenefit.BenefitComponent res = new ExplanationOfBenefit.BenefitComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseExplanationOfBenefitBenefitComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseExplanationOfBenefitBenefitComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.BenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "allowed")) {
        res.setAllowed(parseType("allowed", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "used")) {
        res.setUsed(parseType("used", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected FamilyMemberHistory parseFamilyMemberHistory(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    FamilyMemberHistory res = new FamilyMemberHistory();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseFamilyMemberHistoryContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseFamilyMemberHistoryContent(int eventType, XmlPullParser xpp, FamilyMemberHistory res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.getDefinition().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataAbsentReason")) {
        res.setDataAbsentReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
        res.setRelationship(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("gender")) {
        res.setGenderElement(parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "born")) {
        res.setBorn(parseType("born", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "age")) {
        res.setAge(parseType("age", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("estimatedAge")) {
        res.setEstimatedAgeElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "deceased")) {
        res.setDeceased(parseType("deceased", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
        res.getCondition().add(parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected FamilyMemberHistory.FamilyMemberHistoryConditionComponent parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(XmlPullParser xpp, FamilyMemberHistory owner) throws XmlPullParserException, IOException, FHIRFormatError {
    FamilyMemberHistory.FamilyMemberHistoryConditionComponent res = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseFamilyMemberHistoryFamilyMemberHistoryConditionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseFamilyMemberHistoryFamilyMemberHistoryConditionComponentContent(int eventType, XmlPullParser xpp, FamilyMemberHistory owner, FamilyMemberHistory.FamilyMemberHistoryConditionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcome(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "onset")) {
        res.setOnset(parseType("onset", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Flag parseFlag(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Flag res = new Flag();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseFlagContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseFlagContent(int eventType, XmlPullParser xpp, Flag res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Flag.FlagStatus.NULL, new Flag.FlagStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Goal parseGoal(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Goal res = new Goal();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGoalContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGoalContent(int eventType, XmlPullParser xpp, Goal res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Goal.GoalStatus.NULL, new Goal.GoalStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriority(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescription(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "start")) {
        res.setStart(parseType("start", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.setTarget(parseGoalGoalTargetComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusDate")) {
        res.setStatusDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
        res.setStatusReasonElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expressedBy")) {
        res.setExpressedBy(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("addresses")) {
        res.getAddresses().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcomeCode")) {
        res.getOutcomeCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcomeReference")) {
        res.getOutcomeReference().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Goal.GoalTargetComponent parseGoalGoalTargetComponent(XmlPullParser xpp, Goal owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Goal.GoalTargetComponent res = new Goal.GoalTargetComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGoalGoalTargetComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGoalGoalTargetComponentContent(int eventType, XmlPullParser xpp, Goal owner, Goal.GoalTargetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measure")) {
        res.setMeasure(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "detail")) {
        res.setDetail(parseType("detail", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "due")) {
        res.setDue(parseType("due", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected GraphDefinition parseGraphDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    GraphDefinition res = new GraphDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGraphDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGraphDefinitionContent(int eventType, XmlPullParser xpp, GraphDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
        res.setStartElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfileElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
        res.getLink().add(parseGraphDefinitionGraphDefinitionLinkComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected GraphDefinition.GraphDefinitionLinkComponent parseGraphDefinitionGraphDefinitionLinkComponent(XmlPullParser xpp, GraphDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkComponent res = new GraphDefinition.GraphDefinitionLinkComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGraphDefinitionGraphDefinitionLinkComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGraphDefinitionGraphDefinitionLinkComponentContent(int eventType, XmlPullParser xpp, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sliceName")) {
        res.setSliceNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("min")) {
        res.setMinElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("max")) {
        res.setMaxElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.getTarget().add(parseGraphDefinitionGraphDefinitionLinkTargetComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected GraphDefinition.GraphDefinitionLinkTargetComponent parseGraphDefinitionGraphDefinitionLinkTargetComponent(XmlPullParser xpp, GraphDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkTargetComponent res = new GraphDefinition.GraphDefinitionLinkTargetComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGraphDefinitionGraphDefinitionLinkTargetComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGraphDefinitionGraphDefinitionLinkTargetComponentContent(int eventType, XmlPullParser xpp, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkTargetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("params")) {
        res.setParamsElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfileElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("compartment")) {
        res.getCompartment().add(parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
        res.getLink().add(parseGraphDefinitionGraphDefinitionLinkComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(XmlPullParser xpp, GraphDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res = new GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponentContent(int eventType, XmlPullParser xpp, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUseElement(parseEnumeration(xpp, GraphDefinition.GraphCompartmentUse.NULL, new GraphDefinition.GraphCompartmentUseEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseEnumeration(xpp, GraphDefinition.CompartmentCode.NULL, new GraphDefinition.CompartmentCodeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rule")) {
        res.setRuleElement(parseEnumeration(xpp, GraphDefinition.GraphCompartmentRule.NULL, new GraphDefinition.GraphCompartmentRuleEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
        res.setExpressionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Group parseGroup(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Group res = new Group();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGroupContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGroupContent(int eventType, XmlPullParser xpp, Group res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
        res.setActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Group.GroupType.NULL, new Group.GroupTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actual")) {
        res.setActualElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantityElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("characteristic")) {
        res.getCharacteristic().add(parseGroupGroupCharacteristicComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("member")) {
        res.getMember().add(parseGroupGroupMemberComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Group.GroupCharacteristicComponent parseGroupGroupCharacteristicComponent(XmlPullParser xpp, Group owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Group.GroupCharacteristicComponent res = new Group.GroupCharacteristicComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGroupGroupCharacteristicComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGroupGroupCharacteristicComponentContent(int eventType, XmlPullParser xpp, Group owner, Group.GroupCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("exclude")) {
        res.setExcludeElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Group.GroupMemberComponent parseGroupGroupMemberComponent(XmlPullParser xpp, Group owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Group.GroupMemberComponent res = new Group.GroupMemberComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGroupGroupMemberComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGroupGroupMemberComponentContent(int eventType, XmlPullParser xpp, Group owner, Group.GroupMemberComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entity")) {
        res.setEntity(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("inactive")) {
        res.setInactiveElement(parseBoolean(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected GuidanceResponse parseGuidanceResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    GuidanceResponse res = new GuidanceResponse();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseGuidanceResponseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseGuidanceResponseContent(int eventType, XmlPullParser xpp, GuidanceResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestId")) {
        res.setRequestIdElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("module")) {
        res.setModule(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, GuidanceResponse.GuidanceResponseStatus.NULL, new GuidanceResponse.GuidanceResponseStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("occurrenceDateTime")) {
        res.setOccurrenceDateTimeElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.setPerformer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "reason")) {
        res.setReason(parseType("reason", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("evaluationMessage")) {
        res.getEvaluationMessage().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outputParameters")) {
        res.setOutputParameters(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("result")) {
        res.setResult(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataRequirement")) {
        res.getDataRequirement().add(parseDataRequirement(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected HealthcareService parseHealthcareService(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    HealthcareService res = new HealthcareService();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseHealthcareServiceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseHealthcareServiceContent(int eventType, XmlPullParser xpp, HealthcareService res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
        res.setActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("providedBy")) {
        res.setProvidedBy(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialty")) {
        res.getSpecialty().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.getLocation().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("extraDetails")) {
        res.setExtraDetailsElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("photo")) {
        res.setPhoto(parseAttachment(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
        res.getTelecom().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coverageArea")) {
        res.getCoverageArea().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serviceProvisionCode")) {
        res.getServiceProvisionCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("eligibility")) {
        res.setEligibility(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("eligibilityNote")) {
        res.setEligibilityNoteElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("programName")) {
        res.getProgramName().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("characteristic")) {
        res.getCharacteristic().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referralMethod")) {
        res.getReferralMethod().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("appointmentRequired")) {
        res.setAppointmentRequiredElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availableTime")) {
        res.getAvailableTime().add(parseHealthcareServiceHealthcareServiceAvailableTimeComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("notAvailable")) {
        res.getNotAvailable().add(parseHealthcareServiceHealthcareServiceNotAvailableComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availabilityExceptions")) {
        res.setAvailabilityExceptionsElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.getEndpoint().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected HealthcareService.HealthcareServiceAvailableTimeComponent parseHealthcareServiceHealthcareServiceAvailableTimeComponent(XmlPullParser xpp, HealthcareService owner) throws XmlPullParserException, IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceAvailableTimeComponent res = new HealthcareService.HealthcareServiceAvailableTimeComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseHealthcareServiceHealthcareServiceAvailableTimeComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseHealthcareServiceHealthcareServiceAvailableTimeComponentContent(int eventType, XmlPullParser xpp, HealthcareService owner, HealthcareService.HealthcareServiceAvailableTimeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("daysOfWeek")) {
        res.getDaysOfWeek().add(parseEnumeration(xpp, HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allDay")) {
        res.setAllDayElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availableStartTime")) {
        res.setAvailableStartTimeElement(parseTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availableEndTime")) {
        res.setAvailableEndTimeElement(parseTime(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected HealthcareService.HealthcareServiceNotAvailableComponent parseHealthcareServiceHealthcareServiceNotAvailableComponent(XmlPullParser xpp, HealthcareService owner) throws XmlPullParserException, IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceNotAvailableComponent res = new HealthcareService.HealthcareServiceNotAvailableComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseHealthcareServiceHealthcareServiceNotAvailableComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseHealthcareServiceHealthcareServiceNotAvailableComponentContent(int eventType, XmlPullParser xpp, HealthcareService owner, HealthcareService.HealthcareServiceNotAvailableComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("during")) {
        res.setDuring(parsePeriod(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImagingManifest parseImagingManifest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImagingManifest res = new ImagingManifest();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImagingManifestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImagingManifestContent(int eventType, XmlPullParser xpp, ImagingManifest res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authoringTime")) {
        res.setAuthoringTimeElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("study")) {
        res.getStudy().add(parseImagingManifestStudyComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImagingManifest.StudyComponent parseImagingManifestStudyComponent(XmlPullParser xpp, ImagingManifest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImagingManifest.StudyComponent res = new ImagingManifest.StudyComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImagingManifestStudyComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImagingManifestStudyComponentContent(int eventType, XmlPullParser xpp, ImagingManifest owner, ImagingManifest.StudyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uid")) {
        res.setUidElement(parseOid(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("imagingStudy")) {
        res.setImagingStudy(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.getEndpoint().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("series")) {
        res.getSeries().add(parseImagingManifestSeriesComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImagingManifest.SeriesComponent parseImagingManifestSeriesComponent(XmlPullParser xpp, ImagingManifest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImagingManifest.SeriesComponent res = new ImagingManifest.SeriesComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImagingManifestSeriesComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImagingManifestSeriesComponentContent(int eventType, XmlPullParser xpp, ImagingManifest owner, ImagingManifest.SeriesComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uid")) {
        res.setUidElement(parseOid(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.getEndpoint().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instance")) {
        res.getInstance().add(parseImagingManifestInstanceComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImagingManifest.InstanceComponent parseImagingManifestInstanceComponent(XmlPullParser xpp, ImagingManifest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImagingManifest.InstanceComponent res = new ImagingManifest.InstanceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImagingManifestInstanceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImagingManifestInstanceComponentContent(int eventType, XmlPullParser xpp, ImagingManifest owner, ImagingManifest.InstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sopClass")) {
        res.setSopClassElement(parseOid(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uid")) {
        res.setUidElement(parseOid(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("frameNumber")) {
        res.getFrameNumber().add(parseUnsignedInt(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImagingStudy parseImagingStudy(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImagingStudy res = new ImagingStudy();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImagingStudyContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImagingStudyContent(int eventType, XmlPullParser xpp, ImagingStudy res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uid")) {
        res.setUidElement(parseOid(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("accession")) {
        res.setAccession(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availability")) {
        res.setAvailabilityElement(parseEnumeration(xpp, ImagingStudy.InstanceAvailability.NULL, new ImagingStudy.InstanceAvailabilityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modalityList")) {
        res.getModalityList().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("started")) {
        res.setStartedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referrer")) {
        res.setReferrer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interpreter")) {
        res.getInterpreter().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.getEndpoint().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberOfSeries")) {
        res.setNumberOfSeriesElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberOfInstances")) {
        res.setNumberOfInstancesElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedureReference")) {
        res.getProcedureReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedureCode")) {
        res.getProcedureCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.setReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("series")) {
        res.getSeries().add(parseImagingStudyImagingStudySeriesComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImagingStudy.ImagingStudySeriesComponent parseImagingStudyImagingStudySeriesComponent(XmlPullParser xpp, ImagingStudy owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesComponent res = new ImagingStudy.ImagingStudySeriesComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImagingStudyImagingStudySeriesComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImagingStudyImagingStudySeriesComponentContent(int eventType, XmlPullParser xpp, ImagingStudy owner, ImagingStudy.ImagingStudySeriesComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uid")) {
        res.setUidElement(parseOid(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("number")) {
        res.setNumberElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modality")) {
        res.setModality(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberOfInstances")) {
        res.setNumberOfInstancesElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availability")) {
        res.setAvailabilityElement(parseEnumeration(xpp, ImagingStudy.InstanceAvailability.NULL, new ImagingStudy.InstanceAvailabilityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.getEndpoint().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.setBodySite(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("laterality")) {
        res.setLaterality(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("started")) {
        res.setStartedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.getPerformer().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instance")) {
        res.getInstance().add(parseImagingStudyImagingStudySeriesInstanceComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudyImagingStudySeriesInstanceComponent(XmlPullParser xpp, ImagingStudy owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesInstanceComponent res = new ImagingStudy.ImagingStudySeriesInstanceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImagingStudyImagingStudySeriesInstanceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImagingStudyImagingStudySeriesInstanceComponentContent(int eventType, XmlPullParser xpp, ImagingStudy owner, ImagingStudy.ImagingStudySeriesInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uid")) {
        res.setUidElement(parseOid(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("number")) {
        res.setNumberElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sopClass")) {
        res.setSopClassElement(parseOid(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Immunization parseImmunization(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Immunization res = new Immunization();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImmunizationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationContent(int eventType, XmlPullParser xpp, Immunization res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Immunization.ImmunizationStatus.NULL, new Immunization.ImmunizationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("notGiven")) {
        res.setNotGivenElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("vaccineCode")) {
        res.setVaccineCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("primarySource")) {
        res.setPrimarySourceElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reportOrigin")) {
        res.setReportOrigin(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturer")) {
        res.setManufacturer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lotNumber")) {
        res.setLotNumberElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expirationDate")) {
        res.setExpirationDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("site")) {
        res.setSite(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("route")) {
        res.setRoute(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doseQuantity")) {
        res.setDoseQuantity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("practitioner")) {
        res.getPractitioner().add(parseImmunizationImmunizationPractitionerComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("explanation")) {
        res.setExplanation(parseImmunizationImmunizationExplanationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reaction")) {
        res.getReaction().add(parseImmunizationImmunizationReactionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("vaccinationProtocol")) {
        res.getVaccinationProtocol().add(parseImmunizationImmunizationVaccinationProtocolComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Immunization.ImmunizationPractitionerComponent parseImmunizationImmunizationPractitionerComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Immunization.ImmunizationPractitionerComponent res = new Immunization.ImmunizationPractitionerComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImmunizationImmunizationPractitionerComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationImmunizationPractitionerComponentContent(int eventType, XmlPullParser xpp, Immunization owner, Immunization.ImmunizationPractitionerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.setActor(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Immunization.ImmunizationExplanationComponent parseImmunizationImmunizationExplanationComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Immunization.ImmunizationExplanationComponent res = new Immunization.ImmunizationExplanationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImmunizationImmunizationExplanationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationImmunizationExplanationComponentContent(int eventType, XmlPullParser xpp, Immunization owner, Immunization.ImmunizationExplanationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.getReason().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonNotGiven")) {
        res.getReasonNotGiven().add(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Immunization.ImmunizationReactionComponent parseImmunizationImmunizationReactionComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Immunization.ImmunizationReactionComponent res = new Immunization.ImmunizationReactionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImmunizationImmunizationReactionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationImmunizationReactionComponentContent(int eventType, XmlPullParser xpp, Immunization owner, Immunization.ImmunizationReactionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.setDetail(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reported")) {
        res.setReportedElement(parseBoolean(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Immunization.ImmunizationVaccinationProtocolComponent parseImmunizationImmunizationVaccinationProtocolComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Immunization.ImmunizationVaccinationProtocolComponent res = new Immunization.ImmunizationVaccinationProtocolComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImmunizationImmunizationVaccinationProtocolComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationImmunizationVaccinationProtocolComponentContent(int eventType, XmlPullParser xpp, Immunization owner, Immunization.ImmunizationVaccinationProtocolComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doseSequence")) {
        res.setDoseSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authority")) {
        res.setAuthority(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("series")) {
        res.setSeriesElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("seriesDoses")) {
        res.setSeriesDosesElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetDisease")) {
        res.getTargetDisease().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doseStatus")) {
        res.setDoseStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doseStatusReason")) {
        res.setDoseStatusReason(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImmunizationRecommendation parseImmunizationRecommendation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImmunizationRecommendation res = new ImmunizationRecommendation();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImmunizationRecommendationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationRecommendationContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recommendation")) {
        res.getRecommendation().add(parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(XmlPullParser xpp, ImmunizationRecommendation owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImmunizationRecommendationImmunizationRecommendationRecommendationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationRecommendationImmunizationRecommendationRecommendationComponentContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("vaccineCode")) {
        res.setVaccineCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("targetDisease")) {
        res.setTargetDisease(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doseNumber")) {
        res.setDoseNumberElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("forecastStatus")) {
        res.setForecastStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateCriterion")) {
        res.getDateCriterion().add(parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("protocol")) {
        res.setProtocol(parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingImmunization")) {
        res.getSupportingImmunization().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingPatientInformation")) {
        res.getSupportingPatientInformation().add(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(XmlPullParser xpp, ImmunizationRecommendation owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponentContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseDateTime(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(XmlPullParser xpp, ImmunizationRecommendation owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponentContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doseSequence")) {
        res.setDoseSequenceElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authority")) {
        res.setAuthority(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("series")) {
        res.setSeriesElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImplementationGuide parseImplementationGuide(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide res = new ImplementationGuide();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImplementationGuideContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideContent(int eventType, XmlPullParser xpp, ImplementationGuide res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fhirVersion")) {
        res.setFhirVersionElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dependency")) {
        res.getDependency().add(parseImplementationGuideImplementationGuideDependencyComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("package")) {
        res.getPackage().add(parseImplementationGuideImplementationGuidePackageComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("global")) {
        res.getGlobal().add(parseImplementationGuideImplementationGuideGlobalComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("binary")) {
        res.getBinary().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("page")) {
        res.setPage(parseImplementationGuideImplementationGuidePageComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImplementationGuide.ImplementationGuideDependencyComponent parseImplementationGuideImplementationGuideDependencyComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDependencyComponent res = new ImplementationGuide.ImplementationGuideDependencyComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImplementationGuideImplementationGuideDependencyComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideImplementationGuideDependencyComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDependencyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, ImplementationGuide.GuideDependencyType.NULL, new ImplementationGuide.GuideDependencyTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uri")) {
        res.setUriElement(parseUri(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImplementationGuide.ImplementationGuidePackageComponent parseImplementationGuideImplementationGuidePackageComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuidePackageComponent res = new ImplementationGuide.ImplementationGuidePackageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImplementationGuideImplementationGuidePackageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideImplementationGuidePackageComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuidePackageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.getResource().add(parseImplementationGuideImplementationGuidePackageResourceComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImplementationGuide.ImplementationGuidePackageResourceComponent parseImplementationGuideImplementationGuidePackageResourceComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuidePackageResourceComponent res = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImplementationGuideImplementationGuidePackageResourceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideImplementationGuidePackageResourceComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuidePackageResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("example")) {
        res.setExampleElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("acronym")) {
        res.setAcronymElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "source")) {
        res.setSource(parseType("source", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("exampleFor")) {
        res.setExampleFor(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImplementationGuide.ImplementationGuideGlobalComponent parseImplementationGuideImplementationGuideGlobalComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideGlobalComponent res = new ImplementationGuide.ImplementationGuideGlobalComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImplementationGuideImplementationGuideGlobalComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideImplementationGuideGlobalComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideGlobalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfile(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ImplementationGuide.ImplementationGuidePageComponent parseImplementationGuideImplementationGuidePageComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuidePageComponent res = new ImplementationGuide.ImplementationGuidePageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseImplementationGuideImplementationGuidePageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseImplementationGuideImplementationGuidePageComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuidePageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSourceElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
        res.setKindElement(parseEnumeration(xpp, ImplementationGuide.GuidePageKind.NULL, new ImplementationGuide.GuidePageKindEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("package")) {
        res.getPackage().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("format")) {
        res.setFormatElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("page")) {
        res.getPage().add(parseImplementationGuideImplementationGuidePageComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Library parseLibrary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Library res = new Library();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseLibraryContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseLibraryContent(int eventType, XmlPullParser xpp, Library res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
        res.setUsageElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
        res.setApprovalDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
        res.setLastReviewDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
        res.setEffectivePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
        res.getTopic().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contributor")) {
        res.getContributor().add(parseContributor(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
        res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parameter")) {
        res.getParameter().add(parseParameterDefinition(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataRequirement")) {
        res.getDataRequirement().add(parseDataRequirement(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("content")) {
        res.getContent().add(parseAttachment(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Linkage parseLinkage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Linkage res = new Linkage();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseLinkageContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseLinkageContent(int eventType, XmlPullParser xpp, Linkage res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
        res.setActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.getItem().add(parseLinkageLinkageItemComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Linkage.LinkageItemComponent parseLinkageLinkageItemComponent(XmlPullParser xpp, Linkage owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Linkage.LinkageItemComponent res = new Linkage.LinkageItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseLinkageLinkageItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseLinkageLinkageItemComponentContent(int eventType, XmlPullParser xpp, Linkage owner, Linkage.LinkageItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Linkage.LinkageType.NULL, new Linkage.LinkageTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.setResource(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ListResource parseListResource(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ListResource res = new ListResource();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseListResourceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseListResourceContent(int eventType, XmlPullParser xpp, ListResource res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, ListResource.ListStatus.NULL, new ListResource.ListStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, ListResource.ListMode.NULL, new ListResource.ListModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSource(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("orderedBy")) {
        res.setOrderedBy(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entry")) {
        res.getEntry().add(parseListResourceListEntryComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("emptyReason")) {
        res.setEmptyReason(parseCodeableConcept(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ListResource.ListEntryComponent parseListResourceListEntryComponent(XmlPullParser xpp, ListResource owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ListResource.ListEntryComponent res = new ListResource.ListEntryComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseListResourceListEntryComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseListResourceListEntryComponentContent(int eventType, XmlPullParser xpp, ListResource owner, ListResource.ListEntryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("flag")) {
        res.setFlag(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("deleted")) {
        res.setDeletedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.setItem(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Location parseLocation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Location res = new Location();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseLocationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseLocationContent(int eventType, XmlPullParser xpp, Location res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Location.LocationStatus.NULL, new Location.LocationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operationalStatus")) {
        res.setOperationalStatus(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("alias")) {
        res.getAlias().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, Location.LocationMode.NULL, new Location.LocationModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
        res.getTelecom().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
        res.setAddress(parseAddress(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("physicalType")) {
        res.setPhysicalType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("position")) {
        res.setPosition(parseLocationLocationPositionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("managingOrganization")) {
        res.setManagingOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.setPartOf(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.getEndpoint().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Location.LocationPositionComponent parseLocationLocationPositionComponent(XmlPullParser xpp, Location owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Location.LocationPositionComponent res = new Location.LocationPositionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseLocationLocationPositionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseLocationLocationPositionComponentContent(int eventType, XmlPullParser xpp, Location owner, Location.LocationPositionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("longitude")) {
        res.setLongitudeElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("latitude")) {
        res.setLatitudeElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("altitude")) {
        res.setAltitudeElement(parseDecimal(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Measure parseMeasure(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Measure res = new Measure();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureContent(int eventType, XmlPullParser xpp, Measure res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
        res.setUsageElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
        res.setApprovalDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
        res.setLastReviewDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
        res.setEffectivePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
        res.getTopic().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contributor")) {
        res.getContributor().add(parseContributor(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
        res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("library")) {
        res.getLibrary().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("disclaimer")) {
        res.setDisclaimerElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("scoring")) {
        res.setScoring(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("compositeScoring")) {
        res.setCompositeScoring(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("riskAdjustment")) {
        res.setRiskAdjustmentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rateAggregation")) {
        res.setRateAggregationElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rationale")) {
        res.setRationaleElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("clinicalRecommendationStatement")) {
        res.setClinicalRecommendationStatementElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("improvementNotation")) {
        res.setImprovementNotationElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.getDefinition().add(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("guidance")) {
        res.setGuidanceElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("set")) {
        res.setSetElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("group")) {
        res.getGroup().add(parseMeasureMeasureGroupComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supplementalData")) {
        res.getSupplementalData().add(parseMeasureMeasureSupplementalDataComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Measure.MeasureGroupComponent parseMeasureMeasureGroupComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Measure.MeasureGroupComponent res = new Measure.MeasureGroupComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureMeasureGroupComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureMeasureGroupComponentContent(int eventType, XmlPullParser xpp, Measure owner, Measure.MeasureGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("population")) {
        res.getPopulation().add(parseMeasureMeasureGroupPopulationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("stratifier")) {
        res.getStratifier().add(parseMeasureMeasureGroupStratifierComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Measure.MeasureGroupPopulationComponent parseMeasureMeasureGroupPopulationComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Measure.MeasureGroupPopulationComponent res = new Measure.MeasureGroupPopulationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureMeasureGroupPopulationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureMeasureGroupPopulationComponentContent(int eventType, XmlPullParser xpp, Measure owner, Measure.MeasureGroupPopulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("criteria")) {
        res.setCriteriaElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Measure.MeasureGroupStratifierComponent parseMeasureMeasureGroupStratifierComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Measure.MeasureGroupStratifierComponent res = new Measure.MeasureGroupStratifierComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureMeasureGroupStratifierComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureMeasureGroupStratifierComponentContent(int eventType, XmlPullParser xpp, Measure owner, Measure.MeasureGroupStratifierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("criteria")) {
        res.setCriteriaElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Measure.MeasureSupplementalDataComponent parseMeasureMeasureSupplementalDataComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Measure.MeasureSupplementalDataComponent res = new Measure.MeasureSupplementalDataComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureMeasureSupplementalDataComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureMeasureSupplementalDataComponentContent(int eventType, XmlPullParser xpp, Measure owner, Measure.MeasureSupplementalDataComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
        res.getUsage().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("criteria")) {
        res.setCriteriaElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MeasureReport parseMeasureReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport res = new MeasureReport();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureReportContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportContent(int eventType, XmlPullParser xpp, MeasureReport res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, MeasureReport.MeasureReportStatus.NULL, new MeasureReport.MeasureReportStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, MeasureReport.MeasureReportType.NULL, new MeasureReport.MeasureReportTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measure")) {
        res.setMeasure(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reportingOrganization")) {
        res.setReportingOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("group")) {
        res.getGroup().add(parseMeasureReportMeasureReportGroupComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("evaluatedResources")) {
        res.setEvaluatedResources(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MeasureReport.MeasureReportGroupComponent parseMeasureReportMeasureReportGroupComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupComponent res = new MeasureReport.MeasureReportGroupComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureReportMeasureReportGroupComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportMeasureReportGroupComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.MeasureReportGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("population")) {
        res.getPopulation().add(parseMeasureReportMeasureReportGroupPopulationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measureScore")) {
        res.setMeasureScoreElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("stratifier")) {
        res.getStratifier().add(parseMeasureReportMeasureReportGroupStratifierComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MeasureReport.MeasureReportGroupPopulationComponent parseMeasureReportMeasureReportGroupPopulationComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupPopulationComponent res = new MeasureReport.MeasureReportGroupPopulationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureReportMeasureReportGroupPopulationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportMeasureReportGroupPopulationComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.MeasureReportGroupPopulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("count")) {
        res.setCountElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patients")) {
        res.setPatients(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MeasureReport.MeasureReportGroupStratifierComponent parseMeasureReportMeasureReportGroupStratifierComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupStratifierComponent res = new MeasureReport.MeasureReportGroupStratifierComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureReportMeasureReportGroupStratifierComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportMeasureReportGroupStratifierComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.MeasureReportGroupStratifierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("stratum")) {
        res.getStratum().add(parseMeasureReportStratifierGroupComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MeasureReport.StratifierGroupComponent parseMeasureReportStratifierGroupComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport.StratifierGroupComponent res = new MeasureReport.StratifierGroupComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureReportStratifierGroupComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportStratifierGroupComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.StratifierGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("population")) {
        res.getPopulation().add(parseMeasureReportStratifierGroupPopulationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measureScore")) {
        res.setMeasureScoreElement(parseDecimal(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MeasureReport.StratifierGroupPopulationComponent parseMeasureReportStratifierGroupPopulationComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MeasureReport.StratifierGroupPopulationComponent res = new MeasureReport.StratifierGroupPopulationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMeasureReportStratifierGroupPopulationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMeasureReportStratifierGroupPopulationComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.StratifierGroupPopulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("count")) {
        res.setCountElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patients")) {
        res.setPatients(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Media parseMedia(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Media res = new Media();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMediaContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMediaContent(int eventType, XmlPullParser xpp, Media res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Media.DigitalMediaType.NULL, new Media.DigitalMediaTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subtype")) {
        res.setSubtype(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("view")) {
        res.setView(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
        res.setOccurrence(parseType("occurrence", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operator")) {
        res.setOperator(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.setBodySite(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
        res.setDevice(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("height")) {
        res.setHeightElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("width")) {
        res.setWidthElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("frames")) {
        res.setFramesElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("duration")) {
        res.setDurationElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("content")) {
        res.setContent(parseAttachment(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Medication parseMedication(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Medication res = new Medication();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationContent(int eventType, XmlPullParser xpp, Medication res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Medication.MedicationStatus.NULL, new Medication.MedicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("isBrand")) {
        res.setIsBrandElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("isOverTheCounter")) {
        res.setIsOverTheCounterElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manufacturer")) {
        res.setManufacturer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("form")) {
        res.setForm(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ingredient")) {
        res.getIngredient().add(parseMedicationMedicationIngredientComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("package")) {
        res.setPackage(parseMedicationMedicationPackageComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("image")) {
        res.getImage().add(parseAttachment(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Medication.MedicationIngredientComponent parseMedicationMedicationIngredientComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Medication.MedicationIngredientComponent res = new Medication.MedicationIngredientComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationMedicationIngredientComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationMedicationIngredientComponentContent(int eventType, XmlPullParser xpp, Medication owner, Medication.MedicationIngredientComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "item")) {
        res.setItem(parseType("item", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("isActive")) {
        res.setIsActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseRatio(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Medication.MedicationPackageComponent parseMedicationMedicationPackageComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Medication.MedicationPackageComponent res = new Medication.MedicationPackageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationMedicationPackageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationMedicationPackageComponentContent(int eventType, XmlPullParser xpp, Medication owner, Medication.MedicationPackageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("container")) {
        res.setContainer(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("content")) {
        res.getContent().add(parseMedicationMedicationPackageContentComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("batch")) {
        res.getBatch().add(parseMedicationMedicationPackageBatchComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Medication.MedicationPackageContentComponent parseMedicationMedicationPackageContentComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Medication.MedicationPackageContentComponent res = new Medication.MedicationPackageContentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationMedicationPackageContentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationMedicationPackageContentComponentContent(int eventType, XmlPullParser xpp, Medication owner, Medication.MedicationPackageContentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "item")) {
        res.setItem(parseType("item", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseSimpleQuantity(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Medication.MedicationPackageBatchComponent parseMedicationMedicationPackageBatchComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Medication.MedicationPackageBatchComponent res = new Medication.MedicationPackageBatchComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationMedicationPackageBatchComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationMedicationPackageBatchComponentContent(int eventType, XmlPullParser xpp, Medication owner, Medication.MedicationPackageBatchComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lotNumber")) {
        res.setLotNumberElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expirationDate")) {
        res.setExpirationDateElement(parseDateTime(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationAdministration parseMedicationAdministration(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationAdministration res = new MedicationAdministration();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationAdministrationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationAdministrationContent(int eventType, XmlPullParser xpp, MedicationAdministration res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.getDefinition().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, MedicationAdministration.MedicationAdministrationStatus.NULL, new MedicationAdministration.MedicationAdministrationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "medication")) {
        res.setMedication(parseType("medication", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInformation")) {
        res.getSupportingInformation().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "effective")) {
        res.setEffective(parseType("effective", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.getPerformer().add(parseMedicationAdministrationMedicationAdministrationPerformerComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("notGiven")) {
        res.setNotGivenElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonNotGiven")) {
        res.getReasonNotGiven().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.setRequest(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
        res.getDevice().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosage")) {
        res.setDosage(parseMedicationAdministrationMedicationAdministrationDosageComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("eventHistory")) {
        res.getEventHistory().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationAdministration.MedicationAdministrationPerformerComponent parseMedicationAdministrationMedicationAdministrationPerformerComponent(XmlPullParser xpp, MedicationAdministration owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationAdministration.MedicationAdministrationPerformerComponent res = new MedicationAdministration.MedicationAdministrationPerformerComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationAdministrationMedicationAdministrationPerformerComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationAdministrationMedicationAdministrationPerformerComponentContent(int eventType, XmlPullParser xpp, MedicationAdministration owner, MedicationAdministration.MedicationAdministrationPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.setActor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onBehalfOf")) {
        res.setOnBehalfOf(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationAdministration.MedicationAdministrationDosageComponent parseMedicationAdministrationMedicationAdministrationDosageComponent(XmlPullParser xpp, MedicationAdministration owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationAdministration.MedicationAdministrationDosageComponent res = new MedicationAdministration.MedicationAdministrationDosageComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationAdministrationMedicationAdministrationDosageComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationAdministrationMedicationAdministrationDosageComponentContent(int eventType, XmlPullParser xpp, MedicationAdministration owner, MedicationAdministration.MedicationAdministrationDosageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("site")) {
        res.setSite(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("route")) {
        res.setRoute(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
        res.setMethod(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dose")) {
        res.setDose(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "rate")) {
        res.setRate(parseType("rate", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationDispense parseMedicationDispense(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationDispense res = new MedicationDispense();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationDispenseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationDispenseContent(int eventType, XmlPullParser xpp, MedicationDispense res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, MedicationDispense.MedicationDispenseStatus.NULL, new MedicationDispense.MedicationDispenseStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "medication")) {
        res.setMedication(parseType("medication", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInformation")) {
        res.getSupportingInformation().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.getPerformer().add(parseMedicationDispenseMedicationDispensePerformerComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authorizingPrescription")) {
        res.getAuthorizingPrescription().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("daysSupply")) {
        res.setDaysSupply(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("whenPrepared")) {
        res.setWhenPreparedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("whenHandedOver")) {
        res.setWhenHandedOverElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("destination")) {
        res.setDestination(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("receiver")) {
        res.getReceiver().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosageInstruction")) {
        res.getDosageInstruction().add(parseDosage(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("substitution")) {
        res.setSubstitution(parseMedicationDispenseMedicationDispenseSubstitutionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detectedIssue")) {
        res.getDetectedIssue().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("notDone")) {
        res.setNotDoneElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "notDoneReason")) {
        res.setNotDoneReason(parseType("notDoneReason", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("eventHistory")) {
        res.getEventHistory().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationDispense.MedicationDispensePerformerComponent parseMedicationDispenseMedicationDispensePerformerComponent(XmlPullParser xpp, MedicationDispense owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationDispense.MedicationDispensePerformerComponent res = new MedicationDispense.MedicationDispensePerformerComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationDispenseMedicationDispensePerformerComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationDispenseMedicationDispensePerformerComponentContent(int eventType, XmlPullParser xpp, MedicationDispense owner, MedicationDispense.MedicationDispensePerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.setActor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onBehalfOf")) {
        res.setOnBehalfOf(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationDispense.MedicationDispenseSubstitutionComponent parseMedicationDispenseMedicationDispenseSubstitutionComponent(XmlPullParser xpp, MedicationDispense owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationDispense.MedicationDispenseSubstitutionComponent res = new MedicationDispense.MedicationDispenseSubstitutionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationDispenseMedicationDispenseSubstitutionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationDispenseMedicationDispenseSubstitutionComponentContent(int eventType, XmlPullParser xpp, MedicationDispense owner, MedicationDispense.MedicationDispenseSubstitutionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("wasSubstituted")) {
        res.setWasSubstitutedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.getReason().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responsibleParty")) {
        res.getResponsibleParty().add(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationRequest parseMedicationRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationRequest res = new MedicationRequest();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationRequestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationRequestContent(int eventType, XmlPullParser xpp, MedicationRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.getDefinition().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupIdentifier")) {
        res.setGroupIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, MedicationRequest.MedicationRequestStatus.NULL, new MedicationRequest.MedicationRequestStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intent")) {
        res.setIntentElement(parseEnumeration(xpp, MedicationRequest.MedicationRequestIntent.NULL, new MedicationRequest.MedicationRequestIntentEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriorityElement(parseEnumeration(xpp, MedicationRequest.MedicationRequestPriority.NULL, new MedicationRequest.MedicationRequestPriorityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "medication")) {
        res.setMedication(parseType("medication", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInformation")) {
        res.getSupportingInformation().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authoredOn")) {
        res.setAuthoredOnElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requester")) {
        res.setRequester(parseMedicationRequestMedicationRequestRequesterComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recorder")) {
        res.setRecorder(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.setPerformer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosageInstruction")) {
        res.getDosageInstruction().add(parseDosage(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dispenseRequest")) {
        res.setDispenseRequest(parseMedicationRequestMedicationRequestDispenseRequestComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("substitution")) {
        res.setSubstitution(parseMedicationRequestMedicationRequestSubstitutionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priorPrescription")) {
        res.setPriorPrescription(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detectedIssue")) {
        res.getDetectedIssue().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("eventHistory")) {
        res.getEventHistory().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationRequest.MedicationRequestRequesterComponent parseMedicationRequestMedicationRequestRequesterComponent(XmlPullParser xpp, MedicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestRequesterComponent res = new MedicationRequest.MedicationRequestRequesterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationRequestMedicationRequestRequesterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationRequestMedicationRequestRequesterComponentContent(int eventType, XmlPullParser xpp, MedicationRequest owner, MedicationRequest.MedicationRequestRequesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("agent")) {
        res.setAgent(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onBehalfOf")) {
        res.setOnBehalfOf(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationRequest.MedicationRequestDispenseRequestComponent parseMedicationRequestMedicationRequestDispenseRequestComponent(XmlPullParser xpp, MedicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestDispenseRequestComponent res = new MedicationRequest.MedicationRequestDispenseRequestComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationRequestMedicationRequestDispenseRequestComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationRequestMedicationRequestDispenseRequestComponentContent(int eventType, XmlPullParser xpp, MedicationRequest owner, MedicationRequest.MedicationRequestDispenseRequestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("validityPeriod")) {
        res.setValidityPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numberOfRepeatsAllowed")) {
        res.setNumberOfRepeatsAllowedElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expectedSupplyDuration")) {
        res.setExpectedSupplyDuration(parseDuration(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.setPerformer(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationRequest.MedicationRequestSubstitutionComponent parseMedicationRequestMedicationRequestSubstitutionComponent(XmlPullParser xpp, MedicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestSubstitutionComponent res = new MedicationRequest.MedicationRequestSubstitutionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationRequestMedicationRequestSubstitutionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationRequestMedicationRequestSubstitutionComponentContent(int eventType, XmlPullParser xpp, MedicationRequest owner, MedicationRequest.MedicationRequestSubstitutionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allowed")) {
        res.setAllowedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.setReason(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MedicationStatement parseMedicationStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MedicationStatement res = new MedicationStatement();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMedicationStatementContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMedicationStatementContent(int eventType, XmlPullParser xpp, MedicationStatement res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, MedicationStatement.MedicationStatementStatus.NULL, new MedicationStatement.MedicationStatementStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "medication")) {
        res.setMedication(parseType("medication", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "effective")) {
        res.setEffective(parseType("effective", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateAsserted")) {
        res.setDateAssertedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("informationSource")) {
        res.setInformationSource(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("derivedFrom")) {
        res.getDerivedFrom().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("taken")) {
        res.setTakenElement(parseEnumeration(xpp, MedicationStatement.MedicationStatementTaken.NULL, new MedicationStatement.MedicationStatementTakenEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonNotTaken")) {
        res.getReasonNotTaken().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dosage")) {
        res.getDosage().add(parseDosage(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MessageDefinition parseMessageDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageDefinition res = new MessageDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMessageDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageDefinitionContent(int eventType, XmlPullParser xpp, MessageDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("base")) {
        res.setBase(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parent")) {
        res.getParent().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("replaces")) {
        res.getReplaces().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("event")) {
        res.setEventElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategoryElement(parseEnumeration(xpp, MessageDefinition.MessageSignificanceCategory.NULL, new MessageDefinition.MessageSignificanceCategoryEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focus")) {
        res.getFocus().add(parseMessageDefinitionMessageDefinitionFocusComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responseRequired")) {
        res.setResponseRequiredElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allowedResponse")) {
        res.getAllowedResponse().add(parseMessageDefinitionMessageDefinitionAllowedResponseComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MessageDefinition.MessageDefinitionFocusComponent parseMessageDefinitionMessageDefinitionFocusComponent(XmlPullParser xpp, MessageDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageDefinition.MessageDefinitionFocusComponent res = new MessageDefinition.MessageDefinitionFocusComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMessageDefinitionMessageDefinitionFocusComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageDefinitionMessageDefinitionFocusComponentContent(int eventType, XmlPullParser xpp, MessageDefinition owner, MessageDefinition.MessageDefinitionFocusComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfile(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("min")) {
        res.setMinElement(parseUnsignedInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("max")) {
        res.setMaxElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MessageDefinition.MessageDefinitionAllowedResponseComponent parseMessageDefinitionMessageDefinitionAllowedResponseComponent(XmlPullParser xpp, MessageDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageDefinition.MessageDefinitionAllowedResponseComponent res = new MessageDefinition.MessageDefinitionAllowedResponseComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMessageDefinitionMessageDefinitionAllowedResponseComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageDefinitionMessageDefinitionAllowedResponseComponentContent(int eventType, XmlPullParser xpp, MessageDefinition owner, MessageDefinition.MessageDefinitionAllowedResponseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("message")) {
        res.setMessage(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("situation")) {
        res.setSituationElement(parseMarkdown(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MessageHeader parseMessageHeader(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageHeader res = new MessageHeader();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMessageHeaderContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageHeaderContent(int eventType, XmlPullParser xpp, MessageHeader res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("event")) {
        res.setEvent(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("destination")) {
        res.getDestination().add(parseMessageHeaderMessageDestinationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sender")) {
        res.setSender(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("timestamp")) {
        res.setTimestampElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enterer")) {
        res.setEnterer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSource(parseMessageHeaderMessageSourceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responsible")) {
        res.setResponsible(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.setReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("response")) {
        res.setResponse(parseMessageHeaderMessageHeaderResponseComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focus")) {
        res.getFocus().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinitionElement(parseUri(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MessageHeader.MessageDestinationComponent parseMessageHeaderMessageDestinationComponent(XmlPullParser xpp, MessageHeader owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageHeader.MessageDestinationComponent res = new MessageHeader.MessageDestinationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMessageHeaderMessageDestinationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageHeaderMessageDestinationComponentContent(int eventType, XmlPullParser xpp, MessageHeader owner, MessageHeader.MessageDestinationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.setTarget(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.setEndpointElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("receiver")) {
        res.setReceiver(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MessageHeader.MessageSourceComponent parseMessageHeaderMessageSourceComponent(XmlPullParser xpp, MessageHeader owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageHeader.MessageSourceComponent res = new MessageHeader.MessageSourceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMessageHeaderMessageSourceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageHeaderMessageSourceComponentContent(int eventType, XmlPullParser xpp, MessageHeader owner, MessageHeader.MessageSourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("software")) {
        res.setSoftwareElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.setContact(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.setEndpointElement(parseUri(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected MessageHeader.MessageHeaderResponseComponent parseMessageHeaderMessageHeaderResponseComponent(XmlPullParser xpp, MessageHeader owner) throws XmlPullParserException, IOException, FHIRFormatError {
    MessageHeader.MessageHeaderResponseComponent res = new MessageHeader.MessageHeaderResponseComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseMessageHeaderMessageHeaderResponseComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseMessageHeaderMessageHeaderResponseComponentContent(int eventType, XmlPullParser xpp, MessageHeader owner, MessageHeader.MessageHeaderResponseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifierElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseEnumeration(xpp, MessageHeader.ResponseType.NULL, new MessageHeader.ResponseTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("details")) {
        res.setDetails(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NamingSystem parseNamingSystem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NamingSystem res = new NamingSystem();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNamingSystemContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNamingSystemContent(int eventType, XmlPullParser xpp, NamingSystem res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
        res.setKindElement(parseEnumeration(xpp, NamingSystem.NamingSystemType.NULL, new NamingSystem.NamingSystemTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("responsible")) {
        res.setResponsibleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
        res.setUsageElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uniqueId")) {
        res.getUniqueId().add(parseNamingSystemNamingSystemUniqueIdComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("replacedBy")) {
        res.setReplacedBy(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NamingSystem.NamingSystemUniqueIdComponent parseNamingSystemNamingSystemUniqueIdComponent(XmlPullParser xpp, NamingSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
    NamingSystem.NamingSystemUniqueIdComponent res = new NamingSystem.NamingSystemUniqueIdComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNamingSystemNamingSystemUniqueIdComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNamingSystemNamingSystemUniqueIdComponentContent(int eventType, XmlPullParser xpp, NamingSystem owner, NamingSystem.NamingSystemUniqueIdComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, NamingSystem.NamingSystemIdentifierType.NULL, new NamingSystem.NamingSystemIdentifierTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preferred")) {
        res.setPreferredElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NutritionOrder parseNutritionOrder(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder res = new NutritionOrder();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNutritionOrderContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderContent(int eventType, XmlPullParser xpp, NutritionOrder res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, NutritionOrder.NutritionOrderStatus.NULL, new NutritionOrder.NutritionOrderStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("encounter")) {
        res.setEncounter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dateTime")) {
        res.setDateTimeElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("orderer")) {
        res.setOrderer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allergyIntolerance")) {
        res.getAllergyIntolerance().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("foodPreferenceModifier")) {
        res.getFoodPreferenceModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("excludeFoodModifier")) {
        res.getExcludeFoodModifier().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("oralDiet")) {
        res.setOralDiet(parseNutritionOrderNutritionOrderOralDietComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supplement")) {
        res.getSupplement().add(parseNutritionOrderNutritionOrderSupplementComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enteralFormula")) {
        res.setEnteralFormula(parseNutritionOrderNutritionOrderEnteralFormulaComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NutritionOrder.NutritionOrderOralDietComponent parseNutritionOrderNutritionOrderOralDietComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietComponent res = new NutritionOrder.NutritionOrderOralDietComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNutritionOrderNutritionOrderOralDietComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderNutritionOrderOralDietComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("schedule")) {
        res.getSchedule().add(parseTiming(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("nutrient")) {
        res.getNutrient().add(parseNutritionOrderNutritionOrderOralDietNutrientComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("texture")) {
        res.getTexture().add(parseNutritionOrderNutritionOrderOralDietTextureComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fluidConsistencyType")) {
        res.getFluidConsistencyType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instruction")) {
        res.setInstructionElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NutritionOrder.NutritionOrderOralDietNutrientComponent parseNutritionOrderNutritionOrderOralDietNutrientComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietNutrientComponent res = new NutritionOrder.NutritionOrderOralDietNutrientComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNutritionOrderNutritionOrderOralDietNutrientComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderNutritionOrderOralDietNutrientComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietNutrientComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.setModifier(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseSimpleQuantity(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NutritionOrder.NutritionOrderOralDietTextureComponent parseNutritionOrderNutritionOrderOralDietTextureComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietTextureComponent res = new NutritionOrder.NutritionOrderOralDietTextureComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNutritionOrderNutritionOrderOralDietTextureComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderNutritionOrderOralDietTextureComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietTextureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.setModifier(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("foodType")) {
        res.setFoodType(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NutritionOrder.NutritionOrderSupplementComponent parseNutritionOrderNutritionOrderSupplementComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderSupplementComponent res = new NutritionOrder.NutritionOrderSupplementComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNutritionOrderNutritionOrderSupplementComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderNutritionOrderSupplementComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderSupplementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("productName")) {
        res.setProductNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("schedule")) {
        res.getSchedule().add(parseTiming(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instruction")) {
        res.setInstructionElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NutritionOrder.NutritionOrderEnteralFormulaComponent parseNutritionOrderNutritionOrderEnteralFormulaComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderEnteralFormulaComponent res = new NutritionOrder.NutritionOrderEnteralFormulaComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNutritionOrderNutritionOrderEnteralFormulaComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderNutritionOrderEnteralFormulaComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderEnteralFormulaComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("baseFormulaType")) {
        res.setBaseFormulaType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("baseFormulaProductName")) {
        res.setBaseFormulaProductNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additiveType")) {
        res.setAdditiveType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additiveProductName")) {
        res.setAdditiveProductNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("caloricDensity")) {
        res.setCaloricDensity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("routeofAdministration")) {
        res.setRouteofAdministration(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("administration")) {
        res.getAdministration().add(parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxVolumeToDeliver")) {
        res.setMaxVolumeToDeliver(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("administrationInstruction")) {
        res.setAdministrationInstructionElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res = new NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("schedule")) {
        res.setSchedule(parseTiming(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "rate")) {
        res.setRate(parseType("rate", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Observation parseObservation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Observation res = new Observation();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseObservationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseObservationContent(int eventType, XmlPullParser xpp, Observation res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Observation.ObservationStatus.NULL, new Observation.ObservationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "effective")) {
        res.setEffective(parseType("effective", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issued")) {
        res.setIssuedElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.getPerformer().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataAbsentReason")) {
        res.setDataAbsentReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interpretation")) {
        res.setInterpretation(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.setBodySite(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
        res.setMethod(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specimen")) {
        res.setSpecimen(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
        res.setDevice(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceRange")) {
        res.getReferenceRange().add(parseObservationObservationReferenceRangeComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("related")) {
        res.getRelated().add(parseObservationObservationRelatedComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("component")) {
        res.getComponent().add(parseObservationObservationComponentComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Observation.ObservationReferenceRangeComponent parseObservationObservationReferenceRangeComponent(XmlPullParser xpp, Observation owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Observation.ObservationReferenceRangeComponent res = new Observation.ObservationReferenceRangeComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseObservationObservationReferenceRangeComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseObservationObservationReferenceRangeComponentContent(int eventType, XmlPullParser xpp, Observation owner, Observation.ObservationReferenceRangeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("low")) {
        res.setLow(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("high")) {
        res.setHigh(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("appliesTo")) {
        res.getAppliesTo().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("age")) {
        res.setAge(parseRange(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Observation.ObservationRelatedComponent parseObservationObservationRelatedComponent(XmlPullParser xpp, Observation owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Observation.ObservationRelatedComponent res = new Observation.ObservationRelatedComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseObservationObservationRelatedComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseObservationObservationRelatedComponentContent(int eventType, XmlPullParser xpp, Observation owner, Observation.ObservationRelatedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Observation.ObservationRelationshipType.NULL, new Observation.ObservationRelationshipTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.setTarget(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Observation.ObservationComponentComponent parseObservationObservationComponentComponent(XmlPullParser xpp, Observation owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Observation.ObservationComponentComponent res = new Observation.ObservationComponentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseObservationObservationComponentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseObservationObservationComponentComponentContent(int eventType, XmlPullParser xpp, Observation owner, Observation.ObservationComponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataAbsentReason")) {
        res.setDataAbsentReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("interpretation")) {
        res.setInterpretation(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceRange")) {
        res.getReferenceRange().add(parseObservationObservationReferenceRangeComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected OperationDefinition parseOperationDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    OperationDefinition res = new OperationDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseOperationDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseOperationDefinitionContent(int eventType, XmlPullParser xpp, OperationDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
        res.setKindElement(parseEnumeration(xpp, OperationDefinition.OperationKind.NULL, new OperationDefinition.OperationKindEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("idempotent")) {
        res.setIdempotentElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("base")) {
        res.setBase(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.getResource().add(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("system")) {
        res.setSystemElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instance")) {
        res.setInstanceElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parameter")) {
        res.getParameter().add(parseOperationDefinitionOperationDefinitionParameterComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("overload")) {
        res.getOverload().add(parseOperationDefinitionOperationDefinitionOverloadComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected OperationDefinition.OperationDefinitionParameterComponent parseOperationDefinitionOperationDefinitionParameterComponent(XmlPullParser xpp, OperationDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    OperationDefinition.OperationDefinitionParameterComponent res = new OperationDefinition.OperationDefinitionParameterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseOperationDefinitionOperationDefinitionParameterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseOperationDefinitionOperationDefinitionParameterComponentContent(int eventType, XmlPullParser xpp, OperationDefinition owner, OperationDefinition.OperationDefinitionParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("use")) {
        res.setUseElement(parseEnumeration(xpp, OperationDefinition.OperationParameterUse.NULL, new OperationDefinition.OperationParameterUseEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("min")) {
        res.setMinElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("max")) {
        res.setMaxElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("searchType")) {
        res.setSearchTypeElement(parseEnumeration(xpp, Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfile(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("binding")) {
        res.setBinding(parseOperationDefinitionOperationDefinitionParameterBindingComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("part")) {
        res.getPart().add(parseOperationDefinitionOperationDefinitionParameterComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected OperationDefinition.OperationDefinitionParameterBindingComponent parseOperationDefinitionOperationDefinitionParameterBindingComponent(XmlPullParser xpp, OperationDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    OperationDefinition.OperationDefinitionParameterBindingComponent res = new OperationDefinition.OperationDefinitionParameterBindingComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseOperationDefinitionOperationDefinitionParameterBindingComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseOperationDefinitionOperationDefinitionParameterBindingComponentContent(int eventType, XmlPullParser xpp, OperationDefinition owner, OperationDefinition.OperationDefinitionParameterBindingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("strength")) {
        res.setStrengthElement(parseEnumeration(xpp, Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "valueSet")) {
        res.setValueSet(parseType("valueSet", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected OperationDefinition.OperationDefinitionOverloadComponent parseOperationDefinitionOperationDefinitionOverloadComponent(XmlPullParser xpp, OperationDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    OperationDefinition.OperationDefinitionOverloadComponent res = new OperationDefinition.OperationDefinitionOverloadComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseOperationDefinitionOperationDefinitionOverloadComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseOperationDefinitionOperationDefinitionOverloadComponentContent(int eventType, XmlPullParser xpp, OperationDefinition owner, OperationDefinition.OperationDefinitionOverloadComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parameterName")) {
        res.getParameterName().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected OperationOutcome parseOperationOutcome(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    OperationOutcome res = new OperationOutcome();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseOperationOutcomeContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseOperationOutcomeContent(int eventType, XmlPullParser xpp, OperationOutcome res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issue")) {
        res.getIssue().add(parseOperationOutcomeOperationOutcomeIssueComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected OperationOutcome.OperationOutcomeIssueComponent parseOperationOutcomeOperationOutcomeIssueComponent(XmlPullParser xpp, OperationOutcome owner) throws XmlPullParserException, IOException, FHIRFormatError {
    OperationOutcome.OperationOutcomeIssueComponent res = new OperationOutcome.OperationOutcomeIssueComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseOperationOutcomeOperationOutcomeIssueComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseOperationOutcomeOperationOutcomeIssueComponentContent(int eventType, XmlPullParser xpp, OperationOutcome owner, OperationOutcome.OperationOutcomeIssueComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("severity")) {
        res.setSeverityElement(parseEnumeration(xpp, OperationOutcome.IssueSeverity.NULL, new OperationOutcome.IssueSeverityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseEnumeration(xpp, OperationOutcome.IssueType.NULL, new OperationOutcome.IssueTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("details")) {
        res.setDetails(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("diagnostics")) {
        res.setDiagnosticsElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.getLocation().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
        res.getExpression().add(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Organization parseOrganization(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Organization res = new Organization();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseOrganizationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseOrganizationContent(int eventType, XmlPullParser xpp, Organization res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
        res.setActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.getType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("alias")) {
        res.getAlias().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
        res.getTelecom().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
        res.getAddress().add(parseAddress(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.setPartOf(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseOrganizationOrganizationContactComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.getEndpoint().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Organization.OrganizationContactComponent parseOrganizationOrganizationContactComponent(XmlPullParser xpp, Organization owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Organization.OrganizationContactComponent res = new Organization.OrganizationContactComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseOrganizationOrganizationContactComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseOrganizationOrganizationContactComponentContent(int eventType, XmlPullParser xpp, Organization owner, Organization.OrganizationContactComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurpose(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setName(parseHumanName(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
        res.getTelecom().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
        res.setAddress(parseAddress(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Patient parsePatient(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Patient res = new Patient();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePatientContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePatientContent(int eventType, XmlPullParser xpp, Patient res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
        res.setActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.getName().add(parseHumanName(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
        res.getTelecom().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("gender")) {
        res.setGenderElement(parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("birthDate")) {
        res.setBirthDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "deceased")) {
        res.setDeceased(parseType("deceased", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
        res.getAddress().add(parseAddress(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maritalStatus")) {
        res.setMaritalStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "multipleBirth")) {
        res.setMultipleBirth(parseType("multipleBirth", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("photo")) {
        res.getPhoto().add(parseAttachment(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parsePatientContactComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("animal")) {
        res.setAnimal(parsePatientAnimalComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("communication")) {
        res.getCommunication().add(parsePatientPatientCommunicationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("generalPractitioner")) {
        res.getGeneralPractitioner().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("managingOrganization")) {
        res.setManagingOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
        res.getLink().add(parsePatientPatientLinkComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Patient.ContactComponent parsePatientContactComponent(XmlPullParser xpp, Patient owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Patient.ContactComponent res = new Patient.ContactComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePatientContactComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePatientContactComponentContent(int eventType, XmlPullParser xpp, Patient owner, Patient.ContactComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
        res.getRelationship().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setName(parseHumanName(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
        res.getTelecom().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
        res.setAddress(parseAddress(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("gender")) {
        res.setGenderElement(parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("organization")) {
        res.setOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Patient.AnimalComponent parsePatientAnimalComponent(XmlPullParser xpp, Patient owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Patient.AnimalComponent res = new Patient.AnimalComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePatientAnimalComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePatientAnimalComponentContent(int eventType, XmlPullParser xpp, Patient owner, Patient.AnimalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("species")) {
        res.setSpecies(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("breed")) {
        res.setBreed(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("genderStatus")) {
        res.setGenderStatus(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Patient.PatientCommunicationComponent parsePatientPatientCommunicationComponent(XmlPullParser xpp, Patient owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Patient.PatientCommunicationComponent res = new Patient.PatientCommunicationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePatientPatientCommunicationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePatientPatientCommunicationComponentContent(int eventType, XmlPullParser xpp, Patient owner, Patient.PatientCommunicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguage(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preferred")) {
        res.setPreferredElement(parseBoolean(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Patient.PatientLinkComponent parsePatientPatientLinkComponent(XmlPullParser xpp, Patient owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Patient.PatientLinkComponent res = new Patient.PatientLinkComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePatientPatientLinkComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePatientPatientLinkComponentContent(int eventType, XmlPullParser xpp, Patient owner, Patient.PatientLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("other")) {
        res.setOther(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Patient.LinkType.NULL, new Patient.LinkTypeEnumFactory()));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected PaymentNotice parsePaymentNotice(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    PaymentNotice res = new PaymentNotice();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePaymentNoticeContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePaymentNoticeContent(int eventType, XmlPullParser xpp, PaymentNotice res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, PaymentNotice.PaymentNoticeStatus.NULL, new PaymentNotice.PaymentNoticeStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.setRequest(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("response")) {
        res.setResponse(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusDate")) {
        res.setStatusDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.setTarget(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
        res.setProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("organization")) {
        res.setOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("paymentStatus")) {
        res.setPaymentStatus(parseCodeableConcept(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected PaymentReconciliation parsePaymentReconciliation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    PaymentReconciliation res = new PaymentReconciliation();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePaymentReconciliationContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePaymentReconciliationContent(int eventType, XmlPullParser xpp, PaymentReconciliation res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, PaymentReconciliation.PaymentReconciliationStatus.NULL, new PaymentReconciliation.PaymentReconciliationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("organization")) {
        res.setOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.setRequest(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcomeElement(parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("disposition")) {
        res.setDispositionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestProvider")) {
        res.setRequestProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestOrganization")) {
        res.setRequestOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.getDetail().add(parsePaymentReconciliationDetailsComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("form")) {
        res.setForm(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("total")) {
        res.setTotal(parseMoney(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("processNote")) {
        res.getProcessNote().add(parsePaymentReconciliationNotesComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected PaymentReconciliation.DetailsComponent parsePaymentReconciliationDetailsComponent(XmlPullParser xpp, PaymentReconciliation owner) throws XmlPullParserException, IOException, FHIRFormatError {
    PaymentReconciliation.DetailsComponent res = new PaymentReconciliation.DetailsComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePaymentReconciliationDetailsComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePaymentReconciliationDetailsComponentContent(int eventType, XmlPullParser xpp, PaymentReconciliation owner, PaymentReconciliation.DetailsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.setRequest(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("response")) {
        res.setResponse(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("submitter")) {
        res.setSubmitter(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payee")) {
        res.setPayee(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("amount")) {
        res.setAmount(parseMoney(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected PaymentReconciliation.NotesComponent parsePaymentReconciliationNotesComponent(XmlPullParser xpp, PaymentReconciliation owner) throws XmlPullParserException, IOException, FHIRFormatError {
    PaymentReconciliation.NotesComponent res = new PaymentReconciliation.NotesComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePaymentReconciliationNotesComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePaymentReconciliationNotesComponentContent(int eventType, XmlPullParser xpp, PaymentReconciliation owner, PaymentReconciliation.NotesComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Person parsePerson(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Person res = new Person();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePersonContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePersonContent(int eventType, XmlPullParser xpp, Person res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.getName().add(parseHumanName(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
        res.getTelecom().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("gender")) {
        res.setGenderElement(parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("birthDate")) {
        res.setBirthDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
        res.getAddress().add(parseAddress(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("photo")) {
        res.setPhoto(parseAttachment(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("managingOrganization")) {
        res.setManagingOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
        res.setActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
        res.getLink().add(parsePersonPersonLinkComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Person.PersonLinkComponent parsePersonPersonLinkComponent(XmlPullParser xpp, Person owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Person.PersonLinkComponent res = new Person.PersonLinkComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePersonPersonLinkComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePersonPersonLinkComponentContent(int eventType, XmlPullParser xpp, Person owner, Person.PersonLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.setTarget(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assurance")) {
        res.setAssuranceElement(parseEnumeration(xpp, Person.IdentityAssuranceLevel.NULL, new Person.IdentityAssuranceLevelEnumFactory()));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected PlanDefinition parsePlanDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    PlanDefinition res = new PlanDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePlanDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePlanDefinitionContent(int eventType, XmlPullParser xpp, PlanDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
        res.setUsageElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
        res.setApprovalDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
        res.setLastReviewDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
        res.setEffectivePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
        res.getTopic().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contributor")) {
        res.getContributor().add(parseContributor(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
        res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("library")) {
        res.getLibrary().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("goal")) {
        res.getGoal().add(parsePlanDefinitionPlanDefinitionGoalComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
        res.getAction().add(parsePlanDefinitionPlanDefinitionActionComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected PlanDefinition.PlanDefinitionGoalComponent parsePlanDefinitionPlanDefinitionGoalComponent(XmlPullParser xpp, PlanDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    PlanDefinition.PlanDefinitionGoalComponent res = new PlanDefinition.PlanDefinitionGoalComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePlanDefinitionPlanDefinitionGoalComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePlanDefinitionPlanDefinitionGoalComponentContent(int eventType, XmlPullParser xpp, PlanDefinition owner, PlanDefinition.PlanDefinitionGoalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescription(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriority(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
        res.setStart(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("addresses")) {
        res.getAddresses().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.getDocumentation().add(parseRelatedArtifact(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.getTarget().add(parsePlanDefinitionPlanDefinitionGoalTargetComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected PlanDefinition.PlanDefinitionGoalTargetComponent parsePlanDefinitionPlanDefinitionGoalTargetComponent(XmlPullParser xpp, PlanDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    PlanDefinition.PlanDefinitionGoalTargetComponent res = new PlanDefinition.PlanDefinitionGoalTargetComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePlanDefinitionPlanDefinitionGoalTargetComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePlanDefinitionPlanDefinitionGoalTargetComponentContent(int eventType, XmlPullParser xpp, PlanDefinition owner, PlanDefinition.PlanDefinitionGoalTargetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("measure")) {
        res.setMeasure(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "detail")) {
        res.setDetail(parseType("detail", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("due")) {
        res.setDue(parseDuration(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected PlanDefinition.PlanDefinitionActionComponent parsePlanDefinitionPlanDefinitionActionComponent(XmlPullParser xpp, PlanDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    PlanDefinition.PlanDefinitionActionComponent res = new PlanDefinition.PlanDefinitionActionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePlanDefinitionPlanDefinitionActionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePlanDefinitionPlanDefinitionActionComponentContent(int eventType, XmlPullParser xpp, PlanDefinition owner, PlanDefinition.PlanDefinitionActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prefix")) {
        res.setPrefixElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("textEquivalent")) {
        res.setTextEquivalentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.getCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.getReason().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.getDocumentation().add(parseRelatedArtifact(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("goalId")) {
        res.getGoalId().add(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("triggerDefinition")) {
        res.getTriggerDefinition().add(parseTriggerDefinition(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
        res.getCondition().add(parsePlanDefinitionPlanDefinitionActionConditionComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("input")) {
        res.getInput().add(parseDataRequirement(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("output")) {
        res.getOutput().add(parseDataRequirement(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedAction")) {
        res.getRelatedAction().add(parsePlanDefinitionPlanDefinitionActionRelatedActionComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "timing")) {
        res.setTiming(parseType("timing", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
        res.getParticipant().add(parsePlanDefinitionPlanDefinitionActionParticipantComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupingBehavior")) {
        res.setGroupingBehaviorElement(parseEnumeration(xpp, PlanDefinition.ActionGroupingBehavior.NULL, new PlanDefinition.ActionGroupingBehaviorEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("selectionBehavior")) {
        res.setSelectionBehaviorElement(parseEnumeration(xpp, PlanDefinition.ActionSelectionBehavior.NULL, new PlanDefinition.ActionSelectionBehaviorEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requiredBehavior")) {
        res.setRequiredBehaviorElement(parseEnumeration(xpp, PlanDefinition.ActionRequiredBehavior.NULL, new PlanDefinition.ActionRequiredBehaviorEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("precheckBehavior")) {
        res.setPrecheckBehaviorElement(parseEnumeration(xpp, PlanDefinition.ActionPrecheckBehavior.NULL, new PlanDefinition.ActionPrecheckBehaviorEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cardinalityBehavior")) {
        res.setCardinalityBehaviorElement(parseEnumeration(xpp, PlanDefinition.ActionCardinalityBehavior.NULL, new PlanDefinition.ActionCardinalityBehaviorEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinition(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("transform")) {
        res.setTransform(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dynamicValue")) {
        res.getDynamicValue().add(parsePlanDefinitionPlanDefinitionActionDynamicValueComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
        res.getAction().add(parsePlanDefinitionPlanDefinitionActionComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected PlanDefinition.PlanDefinitionActionConditionComponent parsePlanDefinitionPlanDefinitionActionConditionComponent(XmlPullParser xpp, PlanDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    PlanDefinition.PlanDefinitionActionConditionComponent res = new PlanDefinition.PlanDefinitionActionConditionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePlanDefinitionPlanDefinitionActionConditionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePlanDefinitionPlanDefinitionActionConditionComponentContent(int eventType, XmlPullParser xpp, PlanDefinition owner, PlanDefinition.PlanDefinitionActionConditionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
        res.setKindElement(parseEnumeration(xpp, PlanDefinition.ActionConditionKind.NULL, new PlanDefinition.ActionConditionKindEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguageElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
        res.setExpressionElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected PlanDefinition.PlanDefinitionActionRelatedActionComponent parsePlanDefinitionPlanDefinitionActionRelatedActionComponent(XmlPullParser xpp, PlanDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    PlanDefinition.PlanDefinitionActionRelatedActionComponent res = new PlanDefinition.PlanDefinitionActionRelatedActionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePlanDefinitionPlanDefinitionActionRelatedActionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePlanDefinitionPlanDefinitionActionRelatedActionComponentContent(int eventType, XmlPullParser xpp, PlanDefinition owner, PlanDefinition.PlanDefinitionActionRelatedActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actionId")) {
        res.setActionIdElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
        res.setRelationshipElement(parseEnumeration(xpp, PlanDefinition.ActionRelationshipType.NULL, new PlanDefinition.ActionRelationshipTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "offset")) {
        res.setOffset(parseType("offset", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected PlanDefinition.PlanDefinitionActionParticipantComponent parsePlanDefinitionPlanDefinitionActionParticipantComponent(XmlPullParser xpp, PlanDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    PlanDefinition.PlanDefinitionActionParticipantComponent res = new PlanDefinition.PlanDefinitionActionParticipantComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePlanDefinitionPlanDefinitionActionParticipantComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePlanDefinitionPlanDefinitionActionParticipantComponentContent(int eventType, XmlPullParser xpp, PlanDefinition owner, PlanDefinition.PlanDefinitionActionParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, PlanDefinition.ActionParticipantType.NULL, new PlanDefinition.ActionParticipantTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected PlanDefinition.PlanDefinitionActionDynamicValueComponent parsePlanDefinitionPlanDefinitionActionDynamicValueComponent(XmlPullParser xpp, PlanDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    PlanDefinition.PlanDefinitionActionDynamicValueComponent res = new PlanDefinition.PlanDefinitionActionDynamicValueComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePlanDefinitionPlanDefinitionActionDynamicValueComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePlanDefinitionPlanDefinitionActionDynamicValueComponentContent(int eventType, XmlPullParser xpp, PlanDefinition owner, PlanDefinition.PlanDefinitionActionDynamicValueComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguageElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
        res.setExpressionElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Practitioner parsePractitioner(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Practitioner res = new Practitioner();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePractitionerContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePractitionerContent(int eventType, XmlPullParser xpp, Practitioner res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
        res.setActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.getName().add(parseHumanName(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
        res.getTelecom().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
        res.getAddress().add(parseAddress(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("gender")) {
        res.setGenderElement(parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("birthDate")) {
        res.setBirthDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("photo")) {
        res.getPhoto().add(parseAttachment(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("qualification")) {
        res.getQualification().add(parsePractitionerPractitionerQualificationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("communication")) {
        res.getCommunication().add(parseCodeableConcept(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Practitioner.PractitionerQualificationComponent parsePractitionerPractitionerQualificationComponent(XmlPullParser xpp, Practitioner owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Practitioner.PractitionerQualificationComponent res = new Practitioner.PractitionerQualificationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePractitionerPractitionerQualificationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePractitionerPractitionerQualificationComponentContent(int eventType, XmlPullParser xpp, Practitioner owner, Practitioner.PractitionerQualificationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issuer")) {
        res.setIssuer(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected PractitionerRole parsePractitionerRole(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    PractitionerRole res = new PractitionerRole();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePractitionerRoleContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePractitionerRoleContent(int eventType, XmlPullParser xpp, PractitionerRole res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
        res.setActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("practitioner")) {
        res.setPractitioner(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("organization")) {
        res.setOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.getCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialty")) {
        res.getSpecialty().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.getLocation().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("healthcareService")) {
        res.getHealthcareService().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
        res.getTelecom().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availableTime")) {
        res.getAvailableTime().add(parsePractitionerRolePractitionerRoleAvailableTimeComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("notAvailable")) {
        res.getNotAvailable().add(parsePractitionerRolePractitionerRoleNotAvailableComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availabilityExceptions")) {
        res.setAvailabilityExceptionsElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.getEndpoint().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected PractitionerRole.PractitionerRoleAvailableTimeComponent parsePractitionerRolePractitionerRoleAvailableTimeComponent(XmlPullParser xpp, PractitionerRole owner) throws XmlPullParserException, IOException, FHIRFormatError {
    PractitionerRole.PractitionerRoleAvailableTimeComponent res = new PractitionerRole.PractitionerRoleAvailableTimeComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePractitionerRolePractitionerRoleAvailableTimeComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePractitionerRolePractitionerRoleAvailableTimeComponentContent(int eventType, XmlPullParser xpp, PractitionerRole owner, PractitionerRole.PractitionerRoleAvailableTimeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("daysOfWeek")) {
        res.getDaysOfWeek().add(parseEnumeration(xpp, PractitionerRole.DaysOfWeek.NULL, new PractitionerRole.DaysOfWeekEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("allDay")) {
        res.setAllDayElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availableStartTime")) {
        res.setAvailableStartTimeElement(parseTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("availableEndTime")) {
        res.setAvailableEndTimeElement(parseTime(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected PractitionerRole.PractitionerRoleNotAvailableComponent parsePractitionerRolePractitionerRoleNotAvailableComponent(XmlPullParser xpp, PractitionerRole owner) throws XmlPullParserException, IOException, FHIRFormatError {
    PractitionerRole.PractitionerRoleNotAvailableComponent res = new PractitionerRole.PractitionerRoleNotAvailableComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parsePractitionerRolePractitionerRoleNotAvailableComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parsePractitionerRolePractitionerRoleNotAvailableComponentContent(int eventType, XmlPullParser xpp, PractitionerRole owner, PractitionerRole.PractitionerRoleNotAvailableComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("during")) {
        res.setDuring(parsePeriod(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Procedure parseProcedure(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Procedure res = new Procedure();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseProcedureContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseProcedureContent(int eventType, XmlPullParser xpp, Procedure res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.getDefinition().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Procedure.ProcedureStatus.NULL, new Procedure.ProcedureStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("notDone")) {
        res.setNotDoneElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("notDoneReason")) {
        res.setNotDoneReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "performed")) {
        res.setPerformed(parseType("performed", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.getPerformer().add(parseProcedureProcedurePerformerComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.getBodySite().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcome(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("report")) {
        res.getReport().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("complication")) {
        res.getComplication().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("complicationDetail")) {
        res.getComplicationDetail().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("followUp")) {
        res.getFollowUp().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focalDevice")) {
        res.getFocalDevice().add(parseProcedureProcedureFocalDeviceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usedReference")) {
        res.getUsedReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usedCode")) {
        res.getUsedCode().add(parseCodeableConcept(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Procedure.ProcedurePerformerComponent parseProcedureProcedurePerformerComponent(XmlPullParser xpp, Procedure owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Procedure.ProcedurePerformerComponent res = new Procedure.ProcedurePerformerComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseProcedureProcedurePerformerComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseProcedureProcedurePerformerComponentContent(int eventType, XmlPullParser xpp, Procedure owner, Procedure.ProcedurePerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRole(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.setActor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onBehalfOf")) {
        res.setOnBehalfOf(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Procedure.ProcedureFocalDeviceComponent parseProcedureProcedureFocalDeviceComponent(XmlPullParser xpp, Procedure owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Procedure.ProcedureFocalDeviceComponent res = new Procedure.ProcedureFocalDeviceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseProcedureProcedureFocalDeviceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseProcedureProcedureFocalDeviceComponentContent(int eventType, XmlPullParser xpp, Procedure owner, Procedure.ProcedureFocalDeviceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
        res.setAction(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("manipulated")) {
        res.setManipulated(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ProcedureRequest parseProcedureRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ProcedureRequest res = new ProcedureRequest();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseProcedureRequestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseProcedureRequestContent(int eventType, XmlPullParser xpp, ProcedureRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.getDefinition().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("replaces")) {
        res.getReplaces().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requisition")) {
        res.setRequisition(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, ProcedureRequest.ProcedureRequestStatus.NULL, new ProcedureRequest.ProcedureRequestStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intent")) {
        res.setIntentElement(parseEnumeration(xpp, ProcedureRequest.ProcedureRequestIntent.NULL, new ProcedureRequest.ProcedureRequestIntentEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriorityElement(parseEnumeration(xpp, ProcedureRequest.ProcedureRequestPriority.NULL, new ProcedureRequest.ProcedureRequestPriorityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("doNotPerform")) {
        res.setDoNotPerformElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
        res.setOccurrence(parseType("occurrence", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "asNeeded")) {
        res.setAsNeeded(parseType("asNeeded", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authoredOn")) {
        res.setAuthoredOnElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requester")) {
        res.setRequester(parseProcedureRequestProcedureRequestRequesterComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performerType")) {
        res.setPerformerType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.setPerformer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supportingInfo")) {
        res.getSupportingInfo().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specimen")) {
        res.getSpecimen().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.getBodySite().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relevantHistory")) {
        res.getRelevantHistory().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ProcedureRequest.ProcedureRequestRequesterComponent parseProcedureRequestProcedureRequestRequesterComponent(XmlPullParser xpp, ProcedureRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ProcedureRequest.ProcedureRequestRequesterComponent res = new ProcedureRequest.ProcedureRequestRequesterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseProcedureRequestProcedureRequestRequesterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseProcedureRequestProcedureRequestRequesterComponentContent(int eventType, XmlPullParser xpp, ProcedureRequest owner, ProcedureRequest.ProcedureRequestRequesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("agent")) {
        res.setAgent(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onBehalfOf")) {
        res.setOnBehalfOf(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ProcessRequest parseProcessRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ProcessRequest res = new ProcessRequest();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseProcessRequestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseProcessRequestContent(int eventType, XmlPullParser xpp, ProcessRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, ProcessRequest.ProcessRequestStatus.NULL, new ProcessRequest.ProcessRequestStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
        res.setActionElement(parseEnumeration(xpp, ProcessRequest.ActionList.NULL, new ProcessRequest.ActionListEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.setTarget(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("provider")) {
        res.setProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("organization")) {
        res.setOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.setRequest(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("response")) {
        res.setResponse(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("nullify")) {
        res.setNullifyElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reference")) {
        res.setReferenceElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.getItem().add(parseProcessRequestItemsComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("include")) {
        res.getInclude().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("exclude")) {
        res.getExclude().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ProcessRequest.ItemsComponent parseProcessRequestItemsComponent(XmlPullParser xpp, ProcessRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ProcessRequest.ItemsComponent res = new ProcessRequest.ItemsComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseProcessRequestItemsComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseProcessRequestItemsComponentContent(int eventType, XmlPullParser xpp, ProcessRequest owner, ProcessRequest.ItemsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sequenceLinkId")) {
        res.setSequenceLinkIdElement(parseInteger(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ProcessResponse parseProcessResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ProcessResponse res = new ProcessResponse();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseProcessResponseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseProcessResponseContent(int eventType, XmlPullParser xpp, ProcessResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, ProcessResponse.ProcessResponseStatus.NULL, new ProcessResponse.ProcessResponseStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("created")) {
        res.setCreatedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("organization")) {
        res.setOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.setRequest(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcomeElement(parseEnumeration(xpp, ProcessResponse.ProcessingOutcome.NULL, new ProcessResponse.ProcessingOutcomeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("disposition")) {
        res.setDispositionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestProvider")) {
        res.setRequestProvider(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requestOrganization")) {
        res.setRequestOrganization(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("form")) {
        res.setForm(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("processNote")) {
        res.getProcessNote().add(parseProcessResponseProcessResponseProcessNoteComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("error")) {
        res.getError().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("communicationRequest")) {
        res.getCommunicationRequest().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ProcessResponse.ProcessResponseProcessNoteComponent parseProcessResponseProcessResponseProcessNoteComponent(XmlPullParser xpp, ProcessResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ProcessResponse.ProcessResponseProcessNoteComponent res = new ProcessResponse.ProcessResponseProcessNoteComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseProcessResponseProcessResponseProcessNoteComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseProcessResponseProcessResponseProcessNoteComponentContent(int eventType, XmlPullParser xpp, ProcessResponse owner, ProcessResponse.ProcessResponseProcessNoteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Provenance parseProvenance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Provenance res = new Provenance();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseProvenanceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseProvenanceContent(int eventType, XmlPullParser xpp, Provenance res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.getTarget().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occured")) {
        res.setOccured(parseType("occured", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recorded")) {
        res.setRecordedElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("policy")) {
        res.getPolicy().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("location")) {
        res.setLocation(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.getReason().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("activity")) {
        res.setActivity(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("agent")) {
        res.getAgent().add(parseProvenanceProvenanceAgentComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("entity")) {
        res.getEntity().add(parseProvenanceProvenanceEntityComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("signature")) {
        res.getSignature().add(parseSignature(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Provenance.ProvenanceAgentComponent parseProvenanceProvenanceAgentComponent(XmlPullParser xpp, Provenance owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Provenance.ProvenanceAgentComponent res = new Provenance.ProvenanceAgentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseProvenanceProvenanceAgentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseProvenanceProvenanceAgentComponentContent(int eventType, XmlPullParser xpp, Provenance owner, Provenance.ProvenanceAgentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.getRole().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "who")) {
        res.setWho(parseType("who", xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "onBehalfOf")) {
        res.setOnBehalfOf(parseType("onBehalfOf", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Provenance.ProvenanceEntityComponent parseProvenanceProvenanceEntityComponent(XmlPullParser xpp, Provenance owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Provenance.ProvenanceEntityComponent res = new Provenance.ProvenanceEntityComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseProvenanceProvenanceEntityComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseProvenanceProvenanceEntityComponentContent(int eventType, XmlPullParser xpp, Provenance owner, Provenance.ProvenanceEntityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("role")) {
        res.setRoleElement(parseEnumeration(xpp, Provenance.ProvenanceEntityRole.NULL, new Provenance.ProvenanceEntityRoleEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "what")) {
        res.setWhat(parseType("what", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("agent")) {
        res.getAgent().add(parseProvenanceProvenanceAgentComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Questionnaire parseQuestionnaire(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Questionnaire res = new Questionnaire();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseQuestionnaireContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseQuestionnaireContent(int eventType, XmlPullParser xpp, Questionnaire res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
        res.setApprovalDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
        res.setLastReviewDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
        res.setEffectivePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.getCode().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subjectType")) {
        res.getSubjectType().add(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.getItem().add(parseQuestionnaireQuestionnaireItemComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Questionnaire.QuestionnaireItemComponent parseQuestionnaireQuestionnaireItemComponent(XmlPullParser xpp, Questionnaire owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Questionnaire.QuestionnaireItemComponent res = new Questionnaire.QuestionnaireItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseQuestionnaireQuestionnaireItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseQuestionnaireQuestionnaireItemComponentContent(int eventType, XmlPullParser xpp, Questionnaire owner, Questionnaire.QuestionnaireItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("linkId")) {
        res.setLinkIdElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinitionElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.getCode().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prefix")) {
        res.setPrefixElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Questionnaire.QuestionnaireItemType.NULL, new Questionnaire.QuestionnaireItemTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enableWhen")) {
        res.getEnableWhen().add(parseQuestionnaireQuestionnaireItemEnableWhenComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("required")) {
        res.setRequiredElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("repeats")) {
        res.setRepeatsElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("readOnly")) {
        res.setReadOnlyElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxLength")) {
        res.setMaxLengthElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("options")) {
        res.setOptions(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("option")) {
        res.getOption().add(parseQuestionnaireQuestionnaireItemOptionComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "initial")) {
        res.setInitial(parseType("initial", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.getItem().add(parseQuestionnaireQuestionnaireItemComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Questionnaire.QuestionnaireItemEnableWhenComponent parseQuestionnaireQuestionnaireItemEnableWhenComponent(XmlPullParser xpp, Questionnaire owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Questionnaire.QuestionnaireItemEnableWhenComponent res = new Questionnaire.QuestionnaireItemEnableWhenComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseQuestionnaireQuestionnaireItemEnableWhenComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseQuestionnaireQuestionnaireItemEnableWhenComponentContent(int eventType, XmlPullParser xpp, Questionnaire owner, Questionnaire.QuestionnaireItemEnableWhenComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("question")) {
        res.setQuestionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hasAnswer")) {
        res.setHasAnswerElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "answer")) {
        res.setAnswer(parseType("answer", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Questionnaire.QuestionnaireItemOptionComponent parseQuestionnaireQuestionnaireItemOptionComponent(XmlPullParser xpp, Questionnaire owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Questionnaire.QuestionnaireItemOptionComponent res = new Questionnaire.QuestionnaireItemOptionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseQuestionnaireQuestionnaireItemOptionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseQuestionnaireQuestionnaireItemOptionComponentContent(int eventType, XmlPullParser xpp, Questionnaire owner, Questionnaire.QuestionnaireItemOptionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected QuestionnaireResponse parseQuestionnaireResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    QuestionnaireResponse res = new QuestionnaireResponse();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseQuestionnaireResponseContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseQuestionnaireResponseContent(int eventType, XmlPullParser xpp, QuestionnaireResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parent")) {
        res.getParent().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("questionnaire")) {
        res.setQuestionnaire(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, QuestionnaireResponse.QuestionnaireResponseStatus.NULL, new QuestionnaireResponse.QuestionnaireResponseStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authored")) {
        res.setAuthoredElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.setSource(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.getItem().add(parseQuestionnaireResponseQuestionnaireResponseItemComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected QuestionnaireResponse.QuestionnaireResponseItemComponent parseQuestionnaireResponseQuestionnaireResponseItemComponent(XmlPullParser xpp, QuestionnaireResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    QuestionnaireResponse.QuestionnaireResponseItemComponent res = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseQuestionnaireResponseQuestionnaireResponseItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseQuestionnaireResponseQuestionnaireResponseItemComponentContent(int eventType, XmlPullParser xpp, QuestionnaireResponse owner, QuestionnaireResponse.QuestionnaireResponseItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("linkId")) {
        res.setLinkIdElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinitionElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("text")) {
        res.setTextElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("answer")) {
        res.getAnswer().add(parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.getItem().add(parseQuestionnaireResponseQuestionnaireResponseItemComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(XmlPullParser xpp, QuestionnaireResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
    QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent res = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponentContent(int eventType, XmlPullParser xpp, QuestionnaireResponse owner, QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("item")) {
        res.getItem().add(parseQuestionnaireResponseQuestionnaireResponseItemComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected RelatedPerson parseRelatedPerson(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    RelatedPerson res = new RelatedPerson();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseRelatedPersonContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseRelatedPersonContent(int eventType, XmlPullParser xpp, RelatedPerson res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
        res.setActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
        res.setRelationship(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.getName().add(parseHumanName(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("telecom")) {
        res.getTelecom().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("gender")) {
        res.setGenderElement(parseEnumeration(xpp, Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("birthDate")) {
        res.setBirthDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("address")) {
        res.getAddress().add(parseAddress(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("photo")) {
        res.getPhoto().add(parseAttachment(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected RequestGroup parseRequestGroup(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    RequestGroup res = new RequestGroup();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseRequestGroupContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseRequestGroupContent(int eventType, XmlPullParser xpp, RequestGroup res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.getDefinition().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("replaces")) {
        res.getReplaces().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupIdentifier")) {
        res.setGroupIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, RequestGroup.RequestStatus.NULL, new RequestGroup.RequestStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intent")) {
        res.setIntentElement(parseEnumeration(xpp, RequestGroup.RequestIntent.NULL, new RequestGroup.RequestIntentEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriorityElement(parseEnumeration(xpp, RequestGroup.RequestPriority.NULL, new RequestGroup.RequestPriorityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authoredOn")) {
        res.setAuthoredOnElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("author")) {
        res.setAuthor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.getReasonCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.getReasonReference().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
        res.getAction().add(parseRequestGroupRequestGroupActionComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected RequestGroup.RequestGroupActionComponent parseRequestGroupRequestGroupActionComponent(XmlPullParser xpp, RequestGroup owner) throws XmlPullParserException, IOException, FHIRFormatError {
    RequestGroup.RequestGroupActionComponent res = new RequestGroup.RequestGroupActionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseRequestGroupRequestGroupActionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseRequestGroupRequestGroupActionComponentContent(int eventType, XmlPullParser xpp, RequestGroup owner, RequestGroup.RequestGroupActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prefix")) {
        res.setPrefixElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("textEquivalent")) {
        res.setTextEquivalentElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.getCode().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.getDocumentation().add(parseRelatedArtifact(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
        res.getCondition().add(parseRequestGroupRequestGroupActionConditionComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedAction")) {
        res.getRelatedAction().add(parseRequestGroupRequestGroupActionRelatedActionComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "timing")) {
        res.setTiming(parseType("timing", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
        res.getParticipant().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupingBehavior")) {
        res.setGroupingBehaviorElement(parseEnumeration(xpp, RequestGroup.ActionGroupingBehavior.NULL, new RequestGroup.ActionGroupingBehaviorEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("selectionBehavior")) {
        res.setSelectionBehaviorElement(parseEnumeration(xpp, RequestGroup.ActionSelectionBehavior.NULL, new RequestGroup.ActionSelectionBehaviorEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requiredBehavior")) {
        res.setRequiredBehaviorElement(parseEnumeration(xpp, RequestGroup.ActionRequiredBehavior.NULL, new RequestGroup.ActionRequiredBehaviorEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("precheckBehavior")) {
        res.setPrecheckBehaviorElement(parseEnumeration(xpp, RequestGroup.ActionPrecheckBehavior.NULL, new RequestGroup.ActionPrecheckBehaviorEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cardinalityBehavior")) {
        res.setCardinalityBehaviorElement(parseEnumeration(xpp, RequestGroup.ActionCardinalityBehavior.NULL, new RequestGroup.ActionCardinalityBehaviorEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.setResource(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
        res.getAction().add(parseRequestGroupRequestGroupActionComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected RequestGroup.RequestGroupActionConditionComponent parseRequestGroupRequestGroupActionConditionComponent(XmlPullParser xpp, RequestGroup owner) throws XmlPullParserException, IOException, FHIRFormatError {
    RequestGroup.RequestGroupActionConditionComponent res = new RequestGroup.RequestGroupActionConditionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseRequestGroupRequestGroupActionConditionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseRequestGroupRequestGroupActionConditionComponentContent(int eventType, XmlPullParser xpp, RequestGroup owner, RequestGroup.RequestGroupActionConditionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
        res.setKindElement(parseEnumeration(xpp, RequestGroup.ActionConditionKind.NULL, new RequestGroup.ActionConditionKindEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("language")) {
        res.setLanguageElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
        res.setExpressionElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected RequestGroup.RequestGroupActionRelatedActionComponent parseRequestGroupRequestGroupActionRelatedActionComponent(XmlPullParser xpp, RequestGroup owner) throws XmlPullParserException, IOException, FHIRFormatError {
    RequestGroup.RequestGroupActionRelatedActionComponent res = new RequestGroup.RequestGroupActionRelatedActionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseRequestGroupRequestGroupActionRelatedActionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseRequestGroupRequestGroupActionRelatedActionComponentContent(int eventType, XmlPullParser xpp, RequestGroup owner, RequestGroup.RequestGroupActionRelatedActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actionId")) {
        res.setActionIdElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relationship")) {
        res.setRelationshipElement(parseEnumeration(xpp, RequestGroup.ActionRelationshipType.NULL, new RequestGroup.ActionRelationshipTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "offset")) {
        res.setOffset(parseType("offset", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ResearchStudy parseResearchStudy(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ResearchStudy res = new ResearchStudy();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseResearchStudyContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseResearchStudyContent(int eventType, XmlPullParser xpp, ResearchStudy res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("protocol")) {
        res.getProtocol().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, ResearchStudy.ResearchStudyStatus.NULL, new ResearchStudy.ResearchStudyStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focus")) {
        res.getFocus().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
        res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("keyword")) {
        res.getKeyword().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("enrollment")) {
        res.getEnrollment().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sponsor")) {
        res.setSponsor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("principalInvestigator")) {
        res.setPrincipalInvestigator(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("site")) {
        res.getSite().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonStopped")) {
        res.setReasonStopped(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("arm")) {
        res.getArm().add(parseResearchStudyResearchStudyArmComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ResearchStudy.ResearchStudyArmComponent parseResearchStudyResearchStudyArmComponent(XmlPullParser xpp, ResearchStudy owner) throws XmlPullParserException, IOException, FHIRFormatError {
    ResearchStudy.ResearchStudyArmComponent res = new ResearchStudy.ResearchStudyArmComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseResearchStudyResearchStudyArmComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseResearchStudyResearchStudyArmComponentContent(int eventType, XmlPullParser xpp, ResearchStudy owner, ResearchStudy.ResearchStudyArmComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ResearchSubject parseResearchSubject(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ResearchSubject res = new ResearchSubject();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseResearchSubjectContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseResearchSubjectContent(int eventType, XmlPullParser xpp, ResearchSubject res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, ResearchSubject.ResearchSubjectStatus.NULL, new ResearchSubject.ResearchSubjectStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("study")) {
        res.setStudy(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("individual")) {
        res.setIndividual(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assignedArm")) {
        res.setAssignedArmElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actualArm")) {
        res.setActualArmElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("consent")) {
        res.setConsent(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected RiskAssessment parseRiskAssessment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    RiskAssessment res = new RiskAssessment();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseRiskAssessmentContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseRiskAssessmentContent(int eventType, XmlPullParser xpp, RiskAssessment res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.setBasedOn(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parent")) {
        res.setParent(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, RiskAssessment.RiskAssessmentStatus.NULL, new RiskAssessment.RiskAssessmentStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
        res.setMethod(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
        res.setOccurrence(parseType("occurrence", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
        res.setCondition(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.setPerformer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "reason")) {
        res.setReason(parseType("reason", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basis")) {
        res.getBasis().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("prediction")) {
        res.getPrediction().add(parseRiskAssessmentRiskAssessmentPredictionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mitigation")) {
        res.setMitigationElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected RiskAssessment.RiskAssessmentPredictionComponent parseRiskAssessmentRiskAssessmentPredictionComponent(XmlPullParser xpp, RiskAssessment owner) throws XmlPullParserException, IOException, FHIRFormatError {
    RiskAssessment.RiskAssessmentPredictionComponent res = new RiskAssessment.RiskAssessmentPredictionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseRiskAssessmentRiskAssessmentPredictionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseRiskAssessmentRiskAssessmentPredictionComponentContent(int eventType, XmlPullParser xpp, RiskAssessment owner, RiskAssessment.RiskAssessmentPredictionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outcome")) {
        res.setOutcome(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "probability")) {
        res.setProbability(parseType("probability", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("qualitativeRisk")) {
        res.setQualitativeRisk(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relativeRisk")) {
        res.setRelativeRiskElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "when")) {
        res.setWhen(parseType("when", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rationale")) {
        res.setRationaleElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Schedule parseSchedule(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Schedule res = new Schedule();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseScheduleContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseScheduleContent(int eventType, XmlPullParser xpp, Schedule res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("active")) {
        res.setActiveElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serviceCategory")) {
        res.setServiceCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serviceType")) {
        res.getServiceType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialty")) {
        res.getSpecialty().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("actor")) {
        res.getActor().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("planningHorizon")) {
        res.setPlanningHorizon(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected SearchParameter parseSearchParameter(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    SearchParameter res = new SearchParameter();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSearchParameterContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSearchParameterContent(int eventType, XmlPullParser xpp, SearchParameter res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCodeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("base")) {
        res.getBase().add(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("derivedFrom")) {
        res.setDerivedFromElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
        res.setExpressionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("xpath")) {
        res.setXpathElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("xpathUsage")) {
        res.setXpathUsageElement(parseEnumeration(xpp, SearchParameter.XPathUsageType.NULL, new SearchParameter.XPathUsageTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.getTarget().add(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comparator")) {
        res.getComparator().add(parseEnumeration(xpp, SearchParameter.SearchComparator.NULL, new SearchParameter.SearchComparatorEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("modifier")) {
        res.getModifier().add(parseEnumeration(xpp, SearchParameter.SearchModifierCode.NULL, new SearchParameter.SearchModifierCodeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("chain")) {
        res.getChain().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("component")) {
        res.getComponent().add(parseSearchParameterSearchParameterComponentComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected SearchParameter.SearchParameterComponentComponent parseSearchParameterSearchParameterComponentComponent(XmlPullParser xpp, SearchParameter owner) throws XmlPullParserException, IOException, FHIRFormatError {
    SearchParameter.SearchParameterComponentComponent res = new SearchParameter.SearchParameterComponentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSearchParameterSearchParameterComponentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSearchParameterSearchParameterComponentComponentContent(int eventType, XmlPullParser xpp, SearchParameter owner, SearchParameter.SearchParameterComponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("definition")) {
        res.setDefinition(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
        res.setExpressionElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Sequence parseSequence(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Sequence res = new Sequence();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSequenceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSequenceContent(int eventType, XmlPullParser xpp, Sequence res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Sequence.SequenceType.NULL, new Sequence.SequenceTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("coordinateSystem")) {
        res.setCoordinateSystemElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specimen")) {
        res.setSpecimen(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("device")) {
        res.setDevice(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performer")) {
        res.setPerformer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceSeq")) {
        res.setReferenceSeq(parseSequenceSequenceReferenceSeqComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variant")) {
        res.getVariant().add(parseSequenceSequenceVariantComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("observedSeq")) {
        res.setObservedSeqElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quality")) {
        res.getQuality().add(parseSequenceSequenceQualityComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("readCoverage")) {
        res.setReadCoverageElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("repository")) {
        res.getRepository().add(parseSequenceSequenceRepositoryComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("pointer")) {
        res.getPointer().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("structureVariant")) {
        res.getStructureVariant().add(parseSequenceSequenceStructureVariantComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Sequence.SequenceReferenceSeqComponent parseSequenceSequenceReferenceSeqComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Sequence.SequenceReferenceSeqComponent res = new Sequence.SequenceReferenceSeqComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSequenceSequenceReferenceSeqComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSequenceSequenceReferenceSeqComponentContent(int eventType, XmlPullParser xpp, Sequence owner, Sequence.SequenceReferenceSeqComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("chromosome")) {
        res.setChromosome(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("genomeBuild")) {
        res.setGenomeBuildElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceSeqId")) {
        res.setReferenceSeqId(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceSeqPointer")) {
        res.setReferenceSeqPointer(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceSeqString")) {
        res.setReferenceSeqStringElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("strand")) {
        res.setStrandElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("windowStart")) {
        res.setWindowStartElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("windowEnd")) {
        res.setWindowEndElement(parseInteger(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Sequence.SequenceVariantComponent parseSequenceSequenceVariantComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Sequence.SequenceVariantComponent res = new Sequence.SequenceVariantComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSequenceSequenceVariantComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSequenceSequenceVariantComponentContent(int eventType, XmlPullParser xpp, Sequence owner, Sequence.SequenceVariantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
        res.setStartElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
        res.setEndElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("observedAllele")) {
        res.setObservedAlleleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("referenceAllele")) {
        res.setReferenceAlleleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("cigar")) {
        res.setCigarElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variantPointer")) {
        res.setVariantPointer(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Sequence.SequenceQualityComponent parseSequenceSequenceQualityComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Sequence.SequenceQualityComponent res = new Sequence.SequenceQualityComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSequenceSequenceQualityComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSequenceSequenceQualityComponentContent(int eventType, XmlPullParser xpp, Sequence owner, Sequence.SequenceQualityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Sequence.QualityType.NULL, new Sequence.QualityTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("standardSequence")) {
        res.setStandardSequence(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
        res.setStartElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
        res.setEndElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("score")) {
        res.setScore(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
        res.setMethod(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("truthTP")) {
        res.setTruthTPElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("queryTP")) {
        res.setQueryTPElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("truthFN")) {
        res.setTruthFNElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("queryFP")) {
        res.setQueryFPElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("gtFP")) {
        res.setGtFPElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("precision")) {
        res.setPrecisionElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recall")) {
        res.setRecallElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fScore")) {
        res.setFScoreElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("roc")) {
        res.setRoc(parseSequenceSequenceQualityRocComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Sequence.SequenceQualityRocComponent parseSequenceSequenceQualityRocComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Sequence.SequenceQualityRocComponent res = new Sequence.SequenceQualityRocComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSequenceSequenceQualityRocComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSequenceSequenceQualityRocComponentContent(int eventType, XmlPullParser xpp, Sequence owner, Sequence.SequenceQualityRocComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("score")) {
        res.getScore().add(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numTP")) {
        res.getNumTP().add(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numFP")) {
        res.getNumFP().add(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("numFN")) {
        res.getNumFN().add(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("precision")) {
        res.getPrecision().add(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sensitivity")) {
        res.getSensitivity().add(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fMeasure")) {
        res.getFMeasure().add(parseDecimal(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Sequence.SequenceRepositoryComponent parseSequenceSequenceRepositoryComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Sequence.SequenceRepositoryComponent res = new Sequence.SequenceRepositoryComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSequenceSequenceRepositoryComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSequenceSequenceRepositoryComponentContent(int eventType, XmlPullParser xpp, Sequence owner, Sequence.SequenceRepositoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Sequence.RepositoryType.NULL, new Sequence.RepositoryTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("datasetId")) {
        res.setDatasetIdElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variantsetId")) {
        res.setVariantsetIdElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("readsetId")) {
        res.setReadsetIdElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Sequence.SequenceStructureVariantComponent parseSequenceSequenceStructureVariantComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Sequence.SequenceStructureVariantComponent res = new Sequence.SequenceStructureVariantComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSequenceSequenceStructureVariantComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSequenceSequenceStructureVariantComponentContent(int eventType, XmlPullParser xpp, Sequence owner, Sequence.SequenceStructureVariantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("precision")) {
        res.setPrecisionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reportedaCGHRatio")) {
        res.setReportedaCGHRatioElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("length")) {
        res.setLengthElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("outer")) {
        res.setOuter(parseSequenceSequenceStructureVariantOuterComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("inner")) {
        res.setInner(parseSequenceSequenceStructureVariantInnerComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Sequence.SequenceStructureVariantOuterComponent parseSequenceSequenceStructureVariantOuterComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Sequence.SequenceStructureVariantOuterComponent res = new Sequence.SequenceStructureVariantOuterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSequenceSequenceStructureVariantOuterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSequenceSequenceStructureVariantOuterComponentContent(int eventType, XmlPullParser xpp, Sequence owner, Sequence.SequenceStructureVariantOuterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
        res.setStartElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
        res.setEndElement(parseInteger(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Sequence.SequenceStructureVariantInnerComponent parseSequenceSequenceStructureVariantInnerComponent(XmlPullParser xpp, Sequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Sequence.SequenceStructureVariantInnerComponent res = new Sequence.SequenceStructureVariantInnerComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSequenceSequenceStructureVariantInnerComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSequenceSequenceStructureVariantInnerComponentContent(int eventType, XmlPullParser xpp, Sequence owner, Sequence.SequenceStructureVariantInnerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
        res.setStartElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
        res.setEndElement(parseInteger(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected ServiceDefinition parseServiceDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    ServiceDefinition res = new ServiceDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseServiceDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseServiceDefinitionContent(int eventType, XmlPullParser xpp, ServiceDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("usage")) {
        res.setUsageElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("approvalDate")) {
        res.setApprovalDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastReviewDate")) {
        res.setLastReviewDateElement(parseDate(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("effectivePeriod")) {
        res.setEffectivePeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("topic")) {
        res.getTopic().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contributor")) {
        res.getContributor().add(parseContributor(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relatedArtifact")) {
        res.getRelatedArtifact().add(parseRelatedArtifact(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("trigger")) {
        res.getTrigger().add(parseTriggerDefinition(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dataRequirement")) {
        res.getDataRequirement().add(parseDataRequirement(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operationDefinition")) {
        res.setOperationDefinition(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Slot parseSlot(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Slot res = new Slot();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSlotContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSlotContent(int eventType, XmlPullParser xpp, Slot res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serviceCategory")) {
        res.setServiceCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("serviceType")) {
        res.getServiceType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specialty")) {
        res.getSpecialty().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("appointmentType")) {
        res.setAppointmentType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("schedule")) {
        res.setSchedule(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Slot.SlotStatus.NULL, new Slot.SlotStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("start")) {
        res.setStartElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
        res.setEndElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("overbooked")) {
        res.setOverbookedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Specimen parseSpecimen(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Specimen res = new Specimen();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSpecimenContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSpecimenContent(int eventType, XmlPullParser xpp, Specimen res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("accessionIdentifier")) {
        res.setAccessionIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Specimen.SpecimenStatus.NULL, new Specimen.SpecimenStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("subject")) {
        res.setSubject(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("receivedTime")) {
        res.setReceivedTimeElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parent")) {
        res.getParent().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("request")) {
        res.getRequest().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("collection")) {
        res.setCollection(parseSpecimenSpecimenCollectionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("processing")) {
        res.getProcessing().add(parseSpecimenSpecimenProcessingComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("container")) {
        res.getContainer().add(parseSpecimenSpecimenContainerComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Specimen.SpecimenCollectionComponent parseSpecimenSpecimenCollectionComponent(XmlPullParser xpp, Specimen owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Specimen.SpecimenCollectionComponent res = new Specimen.SpecimenCollectionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSpecimenSpecimenCollectionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSpecimenSpecimenCollectionComponentContent(int eventType, XmlPullParser xpp, Specimen owner, Specimen.SpecimenCollectionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("collector")) {
        res.setCollector(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "collected")) {
        res.setCollected(parseType("collected", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("method")) {
        res.setMethod(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("bodySite")) {
        res.setBodySite(parseCodeableConcept(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Specimen.SpecimenProcessingComponent parseSpecimenSpecimenProcessingComponent(XmlPullParser xpp, Specimen owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Specimen.SpecimenProcessingComponent res = new Specimen.SpecimenProcessingComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSpecimenSpecimenProcessingComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSpecimenSpecimenProcessingComponentContent(int eventType, XmlPullParser xpp, Specimen owner, Specimen.SpecimenProcessingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("procedure")) {
        res.setProcedure(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("additive")) {
        res.getAdditive().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "time")) {
        res.setTime(parseType("time", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Specimen.SpecimenContainerComponent parseSpecimenSpecimenContainerComponent(XmlPullParser xpp, Specimen owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Specimen.SpecimenContainerComponent res = new Specimen.SpecimenContainerComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSpecimenSpecimenContainerComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSpecimenSpecimenContainerComponentContent(int eventType, XmlPullParser xpp, Specimen owner, Specimen.SpecimenContainerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("capacity")) {
        res.setCapacity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specimenQuantity")) {
        res.setSpecimenQuantity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "additive")) {
        res.setAdditive(parseType("additive", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected SpecimenDefinition parseSpecimenDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    SpecimenDefinition res = new SpecimenDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSpecimenDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSpecimenDefinitionContent(int eventType, XmlPullParser xpp, SpecimenDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("typeCollected")) {
        res.setTypeCollected(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patientPreparation")) {
        res.setPatientPreparationElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("timeAspect")) {
        res.setTimeAspectElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("collection")) {
        res.getCollection().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("specimenToLab")) {
        res.getSpecimenToLab().add(parseSpecimenDefinitionSpecimenDefinitionSpecimenToLabComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected SpecimenDefinition.SpecimenDefinitionSpecimenToLabComponent parseSpecimenDefinitionSpecimenDefinitionSpecimenToLabComponent(XmlPullParser xpp, SpecimenDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    SpecimenDefinition.SpecimenDefinitionSpecimenToLabComponent res = new SpecimenDefinition.SpecimenDefinitionSpecimenToLabComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSpecimenDefinitionSpecimenDefinitionSpecimenToLabComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSpecimenDefinitionSpecimenDefinitionSpecimenToLabComponentContent(int eventType, XmlPullParser xpp, SpecimenDefinition owner, SpecimenDefinition.SpecimenDefinitionSpecimenToLabComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("isDerived")) {
        res.setIsDerivedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("preference")) {
        res.setPreferenceElement(parseEnumeration(xpp, SpecimenDefinition.SpecimenContainedPreference.NULL, new SpecimenDefinition.SpecimenContainedPreferenceEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("containerMaterial")) {
        res.setContainerMaterial(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("containerType")) {
        res.setContainerType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("containerCap")) {
        res.setContainerCap(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("containerDescription")) {
        res.setContainerDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("containerCapacity")) {
        res.setContainerCapacity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("containerMinimumVolume")) {
        res.setContainerMinimumVolume(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("containerAdditive")) {
        res.getContainerAdditive().add(parseSpecimenDefinitionSpecimenDefinitionSpecimenToLabContainerAdditiveComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("containerPreparation")) {
        res.setContainerPreparationElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requirement")) {
        res.setRequirementElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("retentionTime")) {
        res.setRetentionTime(parseDuration(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rejectionCriterion")) {
        res.getRejectionCriterion().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("handling")) {
        res.getHandling().add(parseSpecimenDefinitionSpecimenDefinitionSpecimenToLabHandlingComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected SpecimenDefinition.SpecimenDefinitionSpecimenToLabContainerAdditiveComponent parseSpecimenDefinitionSpecimenDefinitionSpecimenToLabContainerAdditiveComponent(XmlPullParser xpp, SpecimenDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    SpecimenDefinition.SpecimenDefinitionSpecimenToLabContainerAdditiveComponent res = new SpecimenDefinition.SpecimenDefinitionSpecimenToLabContainerAdditiveComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSpecimenDefinitionSpecimenDefinitionSpecimenToLabContainerAdditiveComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSpecimenDefinitionSpecimenDefinitionSpecimenToLabContainerAdditiveComponentContent(int eventType, XmlPullParser xpp, SpecimenDefinition owner, SpecimenDefinition.SpecimenDefinitionSpecimenToLabContainerAdditiveComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "additive")) {
        res.setAdditive(parseType("additive", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected SpecimenDefinition.SpecimenDefinitionSpecimenToLabHandlingComponent parseSpecimenDefinitionSpecimenDefinitionSpecimenToLabHandlingComponent(XmlPullParser xpp, SpecimenDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    SpecimenDefinition.SpecimenDefinitionSpecimenToLabHandlingComponent res = new SpecimenDefinition.SpecimenDefinitionSpecimenToLabHandlingComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSpecimenDefinitionSpecimenDefinitionSpecimenToLabHandlingComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSpecimenDefinitionSpecimenDefinitionSpecimenToLabHandlingComponentContent(int eventType, XmlPullParser xpp, SpecimenDefinition owner, SpecimenDefinition.SpecimenDefinitionSpecimenToLabHandlingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("conditionSet")) {
        res.setConditionSet(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("tempRange")) {
        res.setTempRange(parseRange(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("maxDuration")) {
        res.setMaxDuration(parseDuration(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lightExposure")) {
        res.setLightExposureElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instruction")) {
        res.setInstructionElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected StructureDefinition parseStructureDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    StructureDefinition res = new StructureDefinition();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseStructureDefinitionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseStructureDefinitionContent(int eventType, XmlPullParser xpp, StructureDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("keyword")) {
        res.getKeyword().add(parseCoding(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fhirVersion")) {
        res.setFhirVersionElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mapping")) {
        res.getMapping().add(parseStructureDefinitionStructureDefinitionMappingComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("kind")) {
        res.setKindElement(parseEnumeration(xpp, StructureDefinition.StructureDefinitionKind.NULL, new StructureDefinition.StructureDefinitionKindEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("abstract")) {
        res.setAbstractElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contextType")) {
        res.setContextTypeElement(parseEnumeration(xpp, StructureDefinition.ExtensionContext.NULL, new StructureDefinition.ExtensionContextEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.getContext().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contextInvariant")) {
        res.getContextInvariant().add(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseCode(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("baseDefinition")) {
        res.setBaseDefinitionElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("derivation")) {
        res.setDerivationElement(parseEnumeration(xpp, StructureDefinition.TypeDerivationRule.NULL, new StructureDefinition.TypeDerivationRuleEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("snapshot")) {
        res.setSnapshot(parseStructureDefinitionStructureDefinitionSnapshotComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("differential")) {
        res.setDifferential(parseStructureDefinitionStructureDefinitionDifferentialComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected StructureDefinition.StructureDefinitionMappingComponent parseStructureDefinitionStructureDefinitionMappingComponent(XmlPullParser xpp, StructureDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    StructureDefinition.StructureDefinitionMappingComponent res = new StructureDefinition.StructureDefinitionMappingComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseStructureDefinitionStructureDefinitionMappingComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseStructureDefinitionStructureDefinitionMappingComponentContent(int eventType, XmlPullParser xpp, StructureDefinition owner, StructureDefinition.StructureDefinitionMappingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identity")) {
        res.setIdentityElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uri")) {
        res.setUriElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("comment")) {
        res.setCommentElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected StructureDefinition.StructureDefinitionSnapshotComponent parseStructureDefinitionStructureDefinitionSnapshotComponent(XmlPullParser xpp, StructureDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    StructureDefinition.StructureDefinitionSnapshotComponent res = new StructureDefinition.StructureDefinitionSnapshotComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseStructureDefinitionStructureDefinitionSnapshotComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseStructureDefinitionStructureDefinitionSnapshotComponentContent(int eventType, XmlPullParser xpp, StructureDefinition owner, StructureDefinition.StructureDefinitionSnapshotComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("element")) {
        res.getElement().add(parseElementDefinition(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected StructureDefinition.StructureDefinitionDifferentialComponent parseStructureDefinitionStructureDefinitionDifferentialComponent(XmlPullParser xpp, StructureDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
    StructureDefinition.StructureDefinitionDifferentialComponent res = new StructureDefinition.StructureDefinitionDifferentialComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseStructureDefinitionStructureDefinitionDifferentialComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseStructureDefinitionStructureDefinitionDifferentialComponentContent(int eventType, XmlPullParser xpp, StructureDefinition owner, StructureDefinition.StructureDefinitionDifferentialComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("element")) {
        res.getElement().add(parseElementDefinition(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected StructureMap parseStructureMap(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    StructureMap res = new StructureMap();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseStructureMapContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseStructureMapContent(int eventType, XmlPullParser xpp, StructureMap res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("structure")) {
        res.getStructure().add(parseStructureMapStructureMapStructureComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("import")) {
        res.getImport().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("group")) {
        res.getGroup().add(parseStructureMapStructureMapGroupComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected StructureMap.StructureMapStructureComponent parseStructureMapStructureMapStructureComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
    StructureMap.StructureMapStructureComponent res = new StructureMap.StructureMapStructureComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseStructureMapStructureMapStructureComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseStructureMapStructureMapStructureComponentContent(int eventType, XmlPullParser xpp, StructureMap owner, StructureMap.StructureMapStructureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, StructureMap.StructureMapModelMode.NULL, new StructureMap.StructureMapModelModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("alias")) {
        res.setAliasElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected StructureMap.StructureMapGroupComponent parseStructureMapStructureMapGroupComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
    StructureMap.StructureMapGroupComponent res = new StructureMap.StructureMapGroupComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseStructureMapStructureMapGroupComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseStructureMapStructureMapGroupComponentContent(int eventType, XmlPullParser xpp, StructureMap owner, StructureMap.StructureMapGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("extends")) {
        res.setExtendsElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("typeMode")) {
        res.setTypeModeElement(parseEnumeration(xpp, StructureMap.StructureMapGroupTypeMode.NULL, new StructureMap.StructureMapGroupTypeModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("input")) {
        res.getInput().add(parseStructureMapStructureMapGroupInputComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rule")) {
        res.getRule().add(parseStructureMapStructureMapGroupRuleComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected StructureMap.StructureMapGroupInputComponent parseStructureMapStructureMapGroupInputComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
    StructureMap.StructureMapGroupInputComponent res = new StructureMap.StructureMapGroupInputComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseStructureMapStructureMapGroupInputComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseStructureMapStructureMapGroupInputComponentContent(int eventType, XmlPullParser xpp, StructureMap owner, StructureMap.StructureMapGroupInputComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("mode")) {
        res.setModeElement(parseEnumeration(xpp, StructureMap.StructureMapInputMode.NULL, new StructureMap.StructureMapInputModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected StructureMap.StructureMapGroupRuleComponent parseStructureMapStructureMapGroupRuleComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
    StructureMap.StructureMapGroupRuleComponent res = new StructureMap.StructureMapGroupRuleComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseStructureMapStructureMapGroupRuleComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseStructureMapStructureMapGroupRuleComponentContent(int eventType, XmlPullParser xpp, StructureMap owner, StructureMap.StructureMapGroupRuleComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("source")) {
        res.getSource().add(parseStructureMapStructureMapGroupRuleSourceComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("target")) {
        res.getTarget().add(parseStructureMapStructureMapGroupRuleTargetComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rule")) {
        res.getRule().add(parseStructureMapStructureMapGroupRuleComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("dependent")) {
        res.getDependent().add(parseStructureMapStructureMapGroupRuleDependentComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("documentation")) {
        res.setDocumentationElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected StructureMap.StructureMapGroupRuleSourceComponent parseStructureMapStructureMapGroupRuleSourceComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
    StructureMap.StructureMapGroupRuleSourceComponent res = new StructureMap.StructureMapGroupRuleSourceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseStructureMapStructureMapGroupRuleSourceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseStructureMapStructureMapGroupRuleSourceComponentContent(int eventType, XmlPullParser xpp, StructureMap owner, StructureMap.StructureMapGroupRuleSourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContextElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("min")) {
        res.setMinElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("max")) {
        res.setMaxElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "defaultValue")) {
        res.setDefaultValue(parseType("defaultValue", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("element")) {
        res.setElementElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("listMode")) {
        res.setListModeElement(parseEnumeration(xpp, StructureMap.StructureMapSourceListMode.NULL, new StructureMap.StructureMapSourceListModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variable")) {
        res.setVariableElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("condition")) {
        res.setConditionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("check")) {
        res.setCheckElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected StructureMap.StructureMapGroupRuleTargetComponent parseStructureMapStructureMapGroupRuleTargetComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
    StructureMap.StructureMapGroupRuleTargetComponent res = new StructureMap.StructureMapGroupRuleTargetComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseStructureMapStructureMapGroupRuleTargetComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseStructureMapStructureMapGroupRuleTargetComponentContent(int eventType, XmlPullParser xpp, StructureMap owner, StructureMap.StructureMapGroupRuleTargetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContextElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contextType")) {
        res.setContextTypeElement(parseEnumeration(xpp, StructureMap.StructureMapContextType.NULL, new StructureMap.StructureMapContextTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("element")) {
        res.setElementElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variable")) {
        res.setVariableElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("listMode")) {
        res.getListMode().add(parseEnumeration(xpp, StructureMap.StructureMapTargetListMode.NULL, new StructureMap.StructureMapTargetListModeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("listRuleId")) {
        res.setListRuleIdElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("transform")) {
        res.setTransformElement(parseEnumeration(xpp, StructureMap.StructureMapTransform.NULL, new StructureMap.StructureMapTransformEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("parameter")) {
        res.getParameter().add(parseStructureMapStructureMapGroupRuleTargetParameterComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected StructureMap.StructureMapGroupRuleTargetParameterComponent parseStructureMapStructureMapGroupRuleTargetParameterComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
    StructureMap.StructureMapGroupRuleTargetParameterComponent res = new StructureMap.StructureMapGroupRuleTargetParameterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseStructureMapStructureMapGroupRuleTargetParameterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseStructureMapStructureMapGroupRuleTargetParameterComponentContent(int eventType, XmlPullParser xpp, StructureMap owner, StructureMap.StructureMapGroupRuleTargetParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected StructureMap.StructureMapGroupRuleDependentComponent parseStructureMapStructureMapGroupRuleDependentComponent(XmlPullParser xpp, StructureMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
    StructureMap.StructureMapGroupRuleDependentComponent res = new StructureMap.StructureMapGroupRuleDependentComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseStructureMapStructureMapGroupRuleDependentComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseStructureMapStructureMapGroupRuleDependentComponentContent(int eventType, XmlPullParser xpp, StructureMap owner, StructureMap.StructureMapGroupRuleDependentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variable")) {
        res.getVariable().add(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Subscription parseSubscription(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Subscription res = new Subscription();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSubscriptionContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSubscriptionContent(int eventType, XmlPullParser xpp, Subscription res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Subscription.SubscriptionStatus.NULL, new Subscription.SubscriptionStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactPoint(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("end")) {
        res.setEndElement(parseInstant(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reason")) {
        res.setReasonElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("criteria")) {
        res.setCriteriaElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("error")) {
        res.setErrorElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("channel")) {
        res.setChannel(parseSubscriptionSubscriptionChannelComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("tag")) {
        res.getTag().add(parseCoding(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Subscription.SubscriptionChannelComponent parseSubscriptionSubscriptionChannelComponent(XmlPullParser xpp, Subscription owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Subscription.SubscriptionChannelComponent res = new Subscription.SubscriptionChannelComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSubscriptionSubscriptionChannelComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSubscriptionSubscriptionChannelComponentContent(int eventType, XmlPullParser xpp, Subscription owner, Subscription.SubscriptionChannelComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, Subscription.SubscriptionChannelType.NULL, new Subscription.SubscriptionChannelTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("endpoint")) {
        res.setEndpointElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("payload")) {
        res.setPayloadElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("header")) {
        res.getHeader().add(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Substance parseSubstance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Substance res = new Substance();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSubstanceContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSubstanceContent(int eventType, XmlPullParser xpp, Substance res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Substance.FHIRSubstanceStatus.NULL, new Substance.FHIRSubstanceStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.getCategory().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("instance")) {
        res.getInstance().add(parseSubstanceSubstanceInstanceComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ingredient")) {
        res.getIngredient().add(parseSubstanceSubstanceIngredientComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Substance.SubstanceInstanceComponent parseSubstanceSubstanceInstanceComponent(XmlPullParser xpp, Substance owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Substance.SubstanceInstanceComponent res = new Substance.SubstanceInstanceComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSubstanceSubstanceInstanceComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSubstanceSubstanceInstanceComponentContent(int eventType, XmlPullParser xpp, Substance owner, Substance.SubstanceInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expiry")) {
        res.setExpiryElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseSimpleQuantity(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Substance.SubstanceIngredientComponent parseSubstanceSubstanceIngredientComponent(XmlPullParser xpp, Substance owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Substance.SubstanceIngredientComponent res = new Substance.SubstanceIngredientComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSubstanceSubstanceIngredientComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSubstanceSubstanceIngredientComponentContent(int eventType, XmlPullParser xpp, Substance owner, Substance.SubstanceIngredientComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseRatio(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "substance")) {
        res.setSubstance(parseType("substance", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected SupplyDelivery parseSupplyDelivery(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    SupplyDelivery res = new SupplyDelivery();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSupplyDeliveryContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSupplyDeliveryContent(int eventType, XmlPullParser xpp, SupplyDelivery res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, SupplyDelivery.SupplyDeliveryStatus.NULL, new SupplyDelivery.SupplyDeliveryStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("patient")) {
        res.setPatient(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("suppliedItem")) {
        res.setSuppliedItem(parseSupplyDeliverySupplyDeliverySuppliedItemComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
        res.setOccurrence(parseType("occurrence", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supplier")) {
        res.setSupplier(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("destination")) {
        res.setDestination(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("receiver")) {
        res.getReceiver().add(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected SupplyDelivery.SupplyDeliverySuppliedItemComponent parseSupplyDeliverySupplyDeliverySuppliedItemComponent(XmlPullParser xpp, SupplyDelivery owner) throws XmlPullParserException, IOException, FHIRFormatError {
    SupplyDelivery.SupplyDeliverySuppliedItemComponent res = new SupplyDelivery.SupplyDeliverySuppliedItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSupplyDeliverySupplyDeliverySuppliedItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSupplyDeliverySupplyDeliverySuppliedItemComponentContent(int eventType, XmlPullParser xpp, SupplyDelivery owner, SupplyDelivery.SupplyDeliverySuppliedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseSimpleQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "item")) {
        res.setItem(parseType("item", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected SupplyRequest parseSupplyRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    SupplyRequest res = new SupplyRequest();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSupplyRequestContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSupplyRequestContent(int eventType, XmlPullParser xpp, SupplyRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, SupplyRequest.SupplyRequestStatus.NULL, new SupplyRequest.SupplyRequestStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("category")) {
        res.setCategory(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriorityElement(parseEnumeration(xpp, SupplyRequest.RequestPriority.NULL, new SupplyRequest.RequestPriorityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("orderedItem")) {
        res.setOrderedItem(parseSupplyRequestSupplyRequestOrderedItemComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "occurrence")) {
        res.setOccurrence(parseType("occurrence", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authoredOn")) {
        res.setAuthoredOnElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requester")) {
        res.setRequester(parseSupplyRequestSupplyRequestRequesterComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("supplier")) {
        res.getSupplier().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "reason")) {
        res.setReason(parseType("reason", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("deliverFrom")) {
        res.setDeliverFrom(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("deliverTo")) {
        res.setDeliverTo(parseReference(xpp));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected SupplyRequest.SupplyRequestOrderedItemComponent parseSupplyRequestSupplyRequestOrderedItemComponent(XmlPullParser xpp, SupplyRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    SupplyRequest.SupplyRequestOrderedItemComponent res = new SupplyRequest.SupplyRequestOrderedItemComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSupplyRequestSupplyRequestOrderedItemComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSupplyRequestSupplyRequestOrderedItemComponentContent(int eventType, XmlPullParser xpp, SupplyRequest owner, SupplyRequest.SupplyRequestOrderedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("quantity")) {
        res.setQuantity(parseQuantity(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "item")) {
        res.setItem(parseType("item", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected SupplyRequest.SupplyRequestRequesterComponent parseSupplyRequestSupplyRequestRequesterComponent(XmlPullParser xpp, SupplyRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
    SupplyRequest.SupplyRequestRequesterComponent res = new SupplyRequest.SupplyRequestRequesterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseSupplyRequestSupplyRequestRequesterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseSupplyRequestSupplyRequestRequesterComponentContent(int eventType, XmlPullParser xpp, SupplyRequest owner, SupplyRequest.SupplyRequestRequesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("agent")) {
        res.setAgent(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onBehalfOf")) {
        res.setOnBehalfOf(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Task parseTask(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    Task res = new Task();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTaskContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTaskContent(int eventType, XmlPullParser xpp, Task res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.getIdentifier().add(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "definition")) {
        res.setDefinition(parseType("definition", xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("basedOn")) {
        res.getBasedOn().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("groupIdentifier")) {
        res.setGroupIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("partOf")) {
        res.getPartOf().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Task.TaskStatus.NULL, new Task.TaskStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("statusReason")) {
        res.setStatusReason(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("businessStatus")) {
        res.setBusinessStatus(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("intent")) {
        res.setIntentElement(parseEnumeration(xpp, Task.TaskIntent.NULL, new Task.TaskIntentEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("priority")) {
        res.setPriorityElement(parseEnumeration(xpp, Task.TaskPriority.NULL, new Task.TaskPriorityEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("code")) {
        res.setCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("focus")) {
        res.setFocus(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("for")) {
        res.setFor(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("context")) {
        res.setContext(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("executionPeriod")) {
        res.setExecutionPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("authoredOn")) {
        res.setAuthoredOnElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("lastModified")) {
        res.setLastModifiedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("requester")) {
        res.setRequester(parseTaskTaskRequesterComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("performerType")) {
        res.getPerformerType().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("owner")) {
        res.setOwner(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonCode")) {
        res.setReasonCode(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("reasonReference")) {
        res.setReasonReference(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("note")) {
        res.getNote().add(parseAnnotation(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("relevantHistory")) {
        res.getRelevantHistory().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("restriction")) {
        res.setRestriction(parseTaskTaskRestrictionComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("input")) {
        res.getInput().add(parseTaskParameterComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("output")) {
        res.getOutput().add(parseTaskTaskOutputComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Task.TaskRequesterComponent parseTaskTaskRequesterComponent(XmlPullParser xpp, Task owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Task.TaskRequesterComponent res = new Task.TaskRequesterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTaskTaskRequesterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTaskTaskRequesterComponentContent(int eventType, XmlPullParser xpp, Task owner, Task.TaskRequesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("agent")) {
        res.setAgent(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("onBehalfOf")) {
        res.setOnBehalfOf(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Task.TaskRestrictionComponent parseTaskTaskRestrictionComponent(XmlPullParser xpp, Task owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Task.TaskRestrictionComponent res = new Task.TaskRestrictionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTaskTaskRestrictionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTaskTaskRestrictionComponentContent(int eventType, XmlPullParser xpp, Task owner, Task.TaskRestrictionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("repetitions")) {
        res.setRepetitionsElement(parsePositiveInt(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("period")) {
        res.setPeriod(parsePeriod(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("recipient")) {
        res.getRecipient().add(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Task.ParameterComponent parseTaskParameterComponent(XmlPullParser xpp, Task owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Task.ParameterComponent res = new Task.ParameterComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTaskParameterComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTaskParameterComponentContent(int eventType, XmlPullParser xpp, Task owner, Task.ParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected Task.TaskOutputComponent parseTaskTaskOutputComponent(XmlPullParser xpp, Task owner) throws XmlPullParserException, IOException, FHIRFormatError {
    Task.TaskOutputComponent res = new Task.TaskOutputComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTaskTaskOutputComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTaskTaskOutputComponentContent(int eventType, XmlPullParser xpp, Task owner, Task.TaskOutputComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setType(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, "value")) {
        res.setValue(parseType("value", xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestReport parseTestReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    TestReport res = new TestReport();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestReportContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestReportContent(int eventType, XmlPullParser xpp, TestReport res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, TestReport.TestReportStatus.NULL, new TestReport.TestReportStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("testScript")) {
        res.setTestScript(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("result")) {
        res.setResultElement(parseEnumeration(xpp, TestReport.TestReportResult.NULL, new TestReport.TestReportResultEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("score")) {
        res.setScoreElement(parseDecimal(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("tester")) {
        res.setTesterElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("issued")) {
        res.setIssuedElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("participant")) {
        res.getParticipant().add(parseTestReportTestReportParticipantComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("setup")) {
        res.setSetup(parseTestReportTestReportSetupComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("test")) {
        res.getTest().add(parseTestReportTestReportTestComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("teardown")) {
        res.setTeardown(parseTestReportTestReportTeardownComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestReport.TestReportParticipantComponent parseTestReportTestReportParticipantComponent(XmlPullParser xpp, TestReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestReport.TestReportParticipantComponent res = new TestReport.TestReportParticipantComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestReportTestReportParticipantComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestReportTestReportParticipantComponentContent(int eventType, XmlPullParser xpp, TestReport owner, TestReport.TestReportParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("type")) {
        res.setTypeElement(parseEnumeration(xpp, TestReport.TestReportParticipantType.NULL, new TestReport.TestReportParticipantTypeEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("uri")) {
        res.setUriElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("display")) {
        res.setDisplayElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestReport.TestReportSetupComponent parseTestReportTestReportSetupComponent(XmlPullParser xpp, TestReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestReport.TestReportSetupComponent res = new TestReport.TestReportSetupComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestReportTestReportSetupComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestReportTestReportSetupComponentContent(int eventType, XmlPullParser xpp, TestReport owner, TestReport.TestReportSetupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
        res.getAction().add(parseTestReportSetupActionComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestReport.SetupActionComponent parseTestReportSetupActionComponent(XmlPullParser xpp, TestReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestReport.SetupActionComponent res = new TestReport.SetupActionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestReportSetupActionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestReportSetupActionComponentContent(int eventType, XmlPullParser xpp, TestReport owner, TestReport.SetupActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operation")) {
        res.setOperation(parseTestReportSetupActionOperationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assert")) {
        res.setAssert(parseTestReportSetupActionAssertComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestReport.SetupActionOperationComponent parseTestReportSetupActionOperationComponent(XmlPullParser xpp, TestReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestReport.SetupActionOperationComponent res = new TestReport.SetupActionOperationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestReportSetupActionOperationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestReportSetupActionOperationComponentContent(int eventType, XmlPullParser xpp, TestReport owner, TestReport.SetupActionOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("result")) {
        res.setResultElement(parseEnumeration(xpp, TestReport.TestReportActionResult.NULL, new TestReport.TestReportActionResultEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("message")) {
        res.setMessageElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.setDetailElement(parseUri(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestReport.SetupActionAssertComponent parseTestReportSetupActionAssertComponent(XmlPullParser xpp, TestReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestReport.SetupActionAssertComponent res = new TestReport.SetupActionAssertComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestReportSetupActionAssertComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestReportSetupActionAssertComponentContent(int eventType, XmlPullParser xpp, TestReport owner, TestReport.SetupActionAssertComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("result")) {
        res.setResultElement(parseEnumeration(xpp, TestReport.TestReportActionResult.NULL, new TestReport.TestReportActionResultEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("message")) {
        res.setMessageElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("detail")) {
        res.setDetailElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestReport.TestReportTestComponent parseTestReportTestReportTestComponent(XmlPullParser xpp, TestReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestReport.TestReportTestComponent res = new TestReport.TestReportTestComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestReportTestReportTestComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestReportTestReportTestComponentContent(int eventType, XmlPullParser xpp, TestReport owner, TestReport.TestReportTestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
        res.getAction().add(parseTestReportTestActionComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestReport.TestActionComponent parseTestReportTestActionComponent(XmlPullParser xpp, TestReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestReport.TestActionComponent res = new TestReport.TestActionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestReportTestActionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestReportTestActionComponentContent(int eventType, XmlPullParser xpp, TestReport owner, TestReport.TestActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operation")) {
        res.setOperation(parseTestReportSetupActionOperationComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("assert")) {
        res.setAssert(parseTestReportSetupActionAssertComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestReport.TestReportTeardownComponent parseTestReportTestReportTeardownComponent(XmlPullParser xpp, TestReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestReport.TestReportTeardownComponent res = new TestReport.TestReportTeardownComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestReportTestReportTeardownComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestReportTestReportTeardownComponentContent(int eventType, XmlPullParser xpp, TestReport owner, TestReport.TestReportTeardownComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("action")) {
        res.getAction().add(parseTestReportTeardownActionComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestReport.TeardownActionComponent parseTestReportTeardownActionComponent(XmlPullParser xpp, TestReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestReport.TeardownActionComponent res = new TestReport.TeardownActionComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestReportTeardownActionComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestReportTeardownActionComponentContent(int eventType, XmlPullParser xpp, TestReport owner, TestReport.TeardownActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("operation")) {
        res.setOperation(parseTestReportSetupActionOperationComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestScript parseTestScript(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
    TestScript res = new TestScript();
    parseDomainResourceAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestScriptContent(eventType, xpp, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestScriptContent(int eventType, XmlPullParser xpp, TestScript res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("identifier")) {
        res.setIdentifier(parseIdentifier(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("version")) {
        res.setVersionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("title")) {
        res.setTitleElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("status")) {
        res.setStatusElement(parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("experimental")) {
        res.setExperimentalElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("date")) {
        res.setDateElement(parseDateTime(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("publisher")) {
        res.setPublisherElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("contact")) {
        res.getContact().add(parseContactDetail(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("useContext")) {
        res.getUseContext().add(parseUsageContext(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("jurisdiction")) {
        res.getJurisdiction().add(parseCodeableConcept(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("purpose")) {
        res.setPurposeElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("copyright")) {
        res.setCopyrightElement(parseMarkdown(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("origin")) {
        res.getOrigin().add(parseTestScriptTestScriptOriginComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("destination")) {
        res.getDestination().add(parseTestScriptTestScriptDestinationComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("metadata")) {
        res.setMetadata(parseTestScriptTestScriptMetadataComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("fixture")) {
        res.getFixture().add(parseTestScriptTestScriptFixtureComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.getProfile().add(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("variable")) {
        res.getVariable().add(parseTestScriptTestScriptVariableComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rule")) {
        res.getRule().add(parseTestScriptTestScriptRuleComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ruleset")) {
        res.getRuleset().add(parseTestScriptTestScriptRulesetComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("setup")) {
        res.setSetup(parseTestScriptTestScriptSetupComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("test")) {
        res.getTest().add(parseTestScriptTestScriptTestComponent(xpp, res));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("teardown")) {
        res.setTeardown(parseTestScriptTestScriptTeardownComponent(xpp, res));
      } else if (!parseDomainResourceContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestScript.TestScriptOriginComponent parseTestScriptTestScriptOriginComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestScript.TestScriptOriginComponent res = new TestScript.TestScriptOriginComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestScriptTestScriptOriginComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestScriptTestScriptOriginComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptOriginComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("index")) {
        res.setIndexElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfile(parseCoding(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestScript.TestScriptDestinationComponent parseTestScriptTestScriptDestinationComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestScript.TestScriptDestinationComponent res = new TestScript.TestScriptDestinationComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestScriptTestScriptDestinationComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestScriptTestScriptDestinationComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptDestinationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("index")) {
        res.setIndexElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("profile")) {
        res.setProfile(parseCoding(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestScript.TestScriptMetadataComponent parseTestScriptTestScriptMetadataComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestScript.TestScriptMetadataComponent res = new TestScript.TestScriptMetadataComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestScriptTestScriptMetadataComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestScriptTestScriptMetadataComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptMetadataComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
        res.getLink().add(parseTestScriptTestScriptMetadataLinkComponent(xpp, owner));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("capability")) {
        res.getCapability().add(parseTestScriptTestScriptMetadataCapabilityComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestScript.TestScriptMetadataLinkComponent parseTestScriptTestScriptMetadataLinkComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestScript.TestScriptMetadataLinkComponent res = new TestScript.TestScriptMetadataLinkComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestScriptTestScriptMetadataLinkComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestScriptTestScriptMetadataLinkComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptMetadataLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("url")) {
        res.setUrlElement(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestScript.TestScriptMetadataCapabilityComponent parseTestScriptTestScriptMetadataCapabilityComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestScript.TestScriptMetadataCapabilityComponent res = new TestScript.TestScriptMetadataCapabilityComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestScriptTestScriptMetadataCapabilityComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestScriptTestScriptMetadataCapabilityComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptMetadataCapabilityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("required")) {
        res.setRequiredElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("validated")) {
        res.setValidatedElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("origin")) {
        res.getOrigin().add(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("destination")) {
        res.setDestinationElement(parseInteger(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("link")) {
        res.getLink().add(parseUri(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("capabilities")) {
        res.setCapabilities(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestScript.TestScriptFixtureComponent parseTestScriptTestScriptFixtureComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestScript.TestScriptFixtureComponent res = new TestScript.TestScriptFixtureComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestScriptTestScriptFixtureComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestScriptTestScriptFixtureComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptFixtureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("autocreate")) {
        res.setAutocreateElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("autodelete")) {
        res.setAutodeleteElement(parseBoolean(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.setResource(parseReference(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestScript.TestScriptVariableComponent parseTestScriptTestScriptVariableComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestScript.TestScriptVariableComponent res = new TestScript.TestScriptVariableComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestScriptTestScriptVariableComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestScriptTestScriptVariableComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptVariableComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("defaultValue")) {
        res.setDefaultValueElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("description")) {
        res.setDescriptionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("expression")) {
        res.setExpressionElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("headerField")) {
        res.setHeaderFieldElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("hint")) {
        res.setHintElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("path")) {
        res.setPathElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("sourceId")) {
        res.setSourceIdElement(parseId(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestScript.TestScriptRuleComponent parseTestScriptTestScriptRuleComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestScript.TestScriptRuleComponent res = new TestScript.TestScriptRuleComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestScriptTestScriptRuleComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestScriptTestScriptRuleComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptRuleComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.setResource(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("param")) {
        res.getParam().add(parseTestScriptRuleParamComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestScript.RuleParamComponent parseTestScriptRuleParamComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestScript.RuleParamComponent res = new TestScript.RuleParamComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestScriptRuleParamComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestScriptRuleParamComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.RuleParamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("name")) {
        res.setNameElement(parseString(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("value")) {
        res.setValueElement(parseString(xpp));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestScript.TestScriptRulesetComponent parseTestScriptTestScriptRulesetComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestScript.TestScriptRulesetComponent res = new TestScript.TestScriptRulesetComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestScriptTestScriptRulesetComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestScriptTestScriptRulesetComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.TestScriptRulesetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("resource")) {
        res.setResource(parseReference(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("rule")) {
        res.getRule().add(parseTestScriptRulesetRuleComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestScript.RulesetRuleComponent parseTestScriptRulesetRuleComponent(XmlPullParser xpp, TestScript owner) throws XmlPullParserException, IOException, FHIRFormatError {
    TestScript.RulesetRuleComponent res = new TestScript.RulesetRuleComponent();
    parseBackboneAttributes(xpp, res);
    next(xpp);
    int eventType = nextNoWhitespace(xpp);
    while (eventType != XmlPullParser.END_TAG) {
  if (!parseTestScriptRulesetRuleComponentContent(eventType, xpp, owner, res))
        unknownContent(xpp);
      eventType = nextNoWhitespace(xpp);
    }
    next(xpp);
    parseElementClose(res);
    return res;
  }

  protected boolean parseTestScriptRulesetRuleComponentContent(int eventType, XmlPullParser xpp, TestScript owner, TestScript.RulesetRuleComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
      if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("ruleId")) {
        res.setRuleIdElement(parseId(xpp));
      } else if (eventType == XmlPullParser.START_TAG && xpp.getName().equals("param")) {
        res.getParam().add(parseTestScriptRulesetRuleParamComponent(xpp, owner));
      } else if (!parseBackboneContent(eventType, xpp, res))
        return false;
    return true;
  }

  protected TestScript.RulesetRuleParamComponent parseTestScriptRulesetRuleParamComponent(XmlPu