package org.hl7.fhir.r4.model.codesystems;

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Sat, Mar 3, 2018 18:00-0500 for FHIR v3.2.0


import org.hl7.fhir.exceptions.FHIRException;

public enum V3TribalEntityUS {

        /**
         * NATIVE ENTITIES WITHIN THE STATE OF ALASKA RECOGNIZED AND ELIGIBLE TO RECEIVE SERVICES FROM THE UNITED STATES BUREAU OF INDIAN AFFAIRS
         */
        _NATIVEENTITYALASKA, 
        /**
         * Village of Afognak
         */
        _338, 
        /**
         * Agdaagux Tribe of King Cove
         */
        _339, 
        /**
         * Native Village of Akhiok
         */
        _340, 
        /**
         * Akiachak Native Community
         */
        _341, 
        /**
         * Akiak Native Community
         */
        _342, 
        /**
         * Native Village of Akutan
         */
        _343, 
        /**
         * Village of Alakanuk
         */
        _344, 
        /**
         * Alatna Village
         */
        _345, 
        /**
         * Native Village of Aleknagik
         */
        _346, 
        /**
         * Algaaciq Native Village (St. Mary's)
         */
        _347, 
        /**
         * Allakaket Village
         */
        _348, 
        /**
         * Native Village of Ambler
         */
        _349, 
        /**
         * Village of Anaktuvuk Pass
         */
        _350, 
        /**
         * Yupiit of Andreafski
         */
        _351, 
        /**
         * Angoon Community Association
         */
        _352, 
        /**
         * Village of Aniak
         */
        _353, 
        /**
         * Anvik Village
         */
        _354, 
        /**
         * Arctic Village (See Native Village of Venetie Trib
         */
        _355, 
        /**
         * Asa carsarmiut Tribe (formerly Native Village of M
         */
        _356, 
        /**
         * Native Village of Atka
         */
        _357, 
        /**
         * Village of Atmautluak
         */
        _358, 
        /**
         * Atqasuk Village (Atkasook)
         */
        _359, 
        /**
         * Native Village of Barrow Inupiat Traditional Gover
         */
        _360, 
        /**
         * Beaver Village
         */
        _361, 
        /**
         * Native Village of Belkofski
         */
        _362, 
        /**
         * Village of Bill Moore's Slough
         */
        _363, 
        /**
         * Birch Creek Tribe
         */
        _364, 
        /**
         * Native Village of Brevig Mission
         */
        _365, 
        /**
         * Native Village of Buckland
         */
        _366, 
        /**
         * Native Village of Cantwell
         */
        _367, 
        /**
         * Native Village of Chanega (aka Chenega)
         */
        _368, 
        /**
         * Chalkyitsik Village
         */
        _369, 
        /**
         * Village of Chefornak
         */
        _370, 
        /**
         * Chevak Native Village
         */
        _371, 
        /**
         * Chickaloon Native Village
         */
        _372, 
        /**
         * Native Village of Chignik
         */
        _373, 
        /**
         * Native Village of Chignik Lagoon
         */
        _374, 
        /**
         * Chignik Lake Village
         */
        _375, 
        /**
         * Chilkat Indian Village (Klukwan)
         */
        _376, 
        /**
         * Chilkoot Indian Association (Haines)
         */
        _377, 
        /**
         * Chinik Eskimo Community (Golovin)
         */
        _378, 
        /**
         * Native Village of Chistochina
         */
        _379, 
        /**
         * Native Village of Chitina
         */
        _380, 
        /**
         * Native Village of Chuathbaluk (Russian Mission, Ku
         */
        _381, 
        /**
         * Chuloonawick Native Village
         */
        _382, 
        /**
         * Circle Native Community
         */
        _383, 
        /**
         * Village of Clark's Point
         */
        _384, 
        /**
         * Native Village of Council
         */
        _385, 
        /**
         * Craig Community Association
         */
        _386, 
        /**
         * Village of Crooked Creek
         */
        _387, 
        /**
         * Curyung Tribal Council (formerly Native Village of
         */
        _388, 
        /**
         * Native Village of Deering
         */
        _389, 
        /**
         * Native Village of Diomede (aka Inalik)
         */
        _390, 
        /**
         * Village of Dot Lake
         */
        _391, 
        /**
         * Douglas Indian Association
         */
        _392, 
        /**
         * Native Village of Eagle
         */
        _393, 
        /**
         * Native Village of Eek
         */
        _394, 
        /**
         * Egegik Village
         */
        _395, 
        /**
         * Eklutna Native Village
         */
        _396, 
        /**
         * Native Village of Ekuk
         */
        _397, 
        /**
         * Ekwok Village
         */
        _398, 
        /**
         * Native Village of Elim
         */
        _399, 
        /**
         * Emmonak Village
         */
        _400, 
        /**
         * Evansville Village (aka Bettles Field)
         */
        _401, 
        /**
         * Native Village of Eyak (Cordova)
         */
        _402, 
        /**
         * Native Village of False Pass
         */
        _403, 
        /**
         * Native Village of Fort Yukon
         */
        _404, 
        /**
         * Native Village of Gakona
         */
        _405, 
        /**
         * Galena Village (aka Louden Village)
         */
        _406, 
        /**
         * Native Village of Gambell
         */
        _407, 
        /**
         * Native Village of Georgetown
         */
        _408, 
        /**
         * Native Village of Goodnews Bay
         */
        _409, 
        /**
         * Organized Village of Grayling (aka Holikachuk)
         */
        _410, 
        /**
         * Gulkana Village
         */
        _411, 
        /**
         * Native Village of Hamilton
         */
        _412, 
        /**
         * Healy Lake Village
         */
        _413, 
        /**
         * Holy Cross Village
         */
        _414, 
        /**
         * Hoonah Indian Association
         */
        _415, 
        /**
         * Native Village of Hooper Bay
         */
        _416, 
        /**
         * Hughes Village
         */
        _417, 
        /**
         * Huslia Village
         */
        _418, 
        /**
         * Hydaburg Cooperative Association
         */
        _419, 
        /**
         * Igiugig Village
         */
        _420, 
        /**
         * Village of Iliamna
         */
        _421, 
        /**
         * Inupiat Community of the Arctic Slope
         */
        _422, 
        /**
         * Iqurmuit Traditional Council (formerly Native Vill
         */
        _423, 
        /**
         * Ivanoff Bay Village
         */
        _424, 
        /**
         * Kaguyak Village
         */
        _425, 
        /**
         * Organized Village of Kake
         */
        _426, 
        /**
         * Kaktovik Village (aka Barter Island)
         */
        _427, 
        /**
         * Village of Kalskag
         */
        _428, 
        /**
         * Village of Kaltag
         */
        _429, 
        /**
         * Native Village of Kanatak
         */
        _430, 
        /**
         * Native Village of Karluk
         */
        _431, 
        /**
         * Organized Village of Kasaan
         */
        _432, 
        /**
         * Native Village of Kasigluk
         */
        _433, 
        /**
         * Kenaitze Indian Tribe
         */
        _434, 
        /**
         * Ketchikan Indian Corporation
         */
        _435, 
        /**
         * Native Village of Kiana
         */
        _436, 
        /**
         * King Island Native Community
         */
        _437, 
        /**
         * King Salmon Tribe
         */
        _438, 
        /**
         * Native Village of Kipnuk
         */
        _439, 
        /**
         * Native Village of Kivalina
         */
        _440, 
        /**
         * Klawock Cooperative Association
         */
        _441, 
        /**
         * Native Village of Kluti Kaah (aka Copper Center)
         */
        _442, 
        /**
         * Knik Tribe
         */
        _443, 
        /**
         * Native Village of Kobuk
         */
        _444, 
        /**
         * Kokhanok Village
         */
        _445, 
        /**
         * Native Village of Kongiganak
         */
        _446, 
        /**
         * Village of Kotlik
         */
        _447, 
        /**
         * Native Village of Kotzebue
         */
        _448, 
        /**
         * Native Village of Koyuk
         */
        _449, 
        /**
         * Koyukuk Native Village
         */
        _450, 
        /**
         * Organized Village of Kwethluk
         */
        _451, 
        /**
         * Native Village of Kwigillingok
         */
        _452, 
        /**
         * Native Village of Kwinhagak (aka Quinhagak)
         */
        _453, 
        /**
         * Native Village of Larsen Bay
         */
        _454, 
        /**
         * Levelock Village
         */
        _455, 
        /**
         * Lesnoi Village (aka Woody Island)
         */
        _456, 
        /**
         * Lime Village
         */
        _457, 
        /**
         * Village of Lower Kalskag
         */
        _458, 
        /**
         * Manley Hot Springs Village
         */
        _459, 
        /**
         * Manokotak Village
         */
        _460, 
        /**
         * Native Village of Marshall (aka Fortuna Ledge)
         */
        _461, 
        /**
         * Native Village of Mary's Igloo
         */
        _462, 
        /**
         * McGrath Native Village
         */
        _463, 
        /**
         * Native Village of Mekoryuk
         */
        _464, 
        /**
         * Mentasta Traditional Council
         */
        _465, 
        /**
         * Metlakatla Indian Community, Annette Island Reserv
         */
        _466, 
        /**
         * Native Village of Minto
         */
        _467, 
        /**
         * Naknek Native Village
         */
        _468, 
        /**
         * Native Village of Nanwalek (aka English Bay)
         */
        _469, 
        /**
         * Native Village of Napaimute
         */
        _470, 
        /**
         * Native Village of Napakiak
         */
        _471, 
        /**
         * Native Village of Napaskiak
         */
        _472, 
        /**
         * Native Village of Nelson Lagoon
         */
        _473, 
        /**
         * Nenana Native Association
         */
        _474, 
        /**
         * New Koliganek Village Council (formerly Koliganek
         */
        _475, 
        /**
         * New Stuyahok Village
         */
        _476, 
        /**
         * Newhalen Village
         */
        _477, 
        /**
         * Newtok Village
         */
        _478, 
        /**
         * Native Village of Nightmute
         */
        _479, 
        /**
         * Nikolai Village
         */
        _480, 
        /**
         * Native Village of Nikolski
         */
        _481, 
        /**
         * Ninilchik Village
         */
        _482, 
        /**
         * Native Village of Noatak
         */
        _483, 
        /**
         * Nome Eskimo Community
         */
        _484, 
        /**
         * Nondalton Village
         */
        _485, 
        /**
         * Noorvik Native Community
         */
        _486, 
        /**
         * Northway Village
         */
        _487, 
        /**
         * Native Village of Nuiqsut (aka Nooiksut)
         */
        _488, 
        /**
         * Nulato Village
         */
        _489, 
        /**
         * Nunakauyarmiut Tribe (formerly Native Village of T
         */
        _490, 
        /**
         * Native Village of Nunapitchuk
         */
        _491, 
        /**
         * Village of Ohogamiut
         */
        _492, 
        /**
         * Village of Old Harbor
         */
        _493, 
        /**
         * Orutsararmuit Native Village (aka Bethel)
         */
        _494, 
        /**
         * Oscarville Traditional Village
         */
        _495, 
        /**
         * Native Village of Ouzinkie
         */
        _496, 
        /**
         * Native Village of Paimiut
         */
        _497, 
        /**
         * Pauloff Harbor Village
         */
        _498, 
        /**
         * Pedro Bay Village
         */
        _499, 
        /**
         * Native Village of Perryville
         */
        _500, 
        /**
         * Petersburg Indian Association
         */
        _501, 
        /**
         * Native Village of Pilot Point
         */
        _502, 
        /**
         * Pilot Station Traditional Village
         */
        _503, 
        /**
         * Native Village of Pitka's Point
         */
        _504, 
        /**
         * Platinum Traditional Village
         */
        _505, 
        /**
         * Native Village of Point Hope
         */
        _506, 
        /**
         * Native Village of Point Lay
         */
        _507, 
        /**
         * Native Village of Port Graham
         */
        _508, 
        /**
         * Native Village of Port Heiden
         */
        _509, 
        /**
         * Native Village of Port Lions
         */
        _510, 
        /**
         * Portage Creek Village (aka Ohgsenakale)
         */
        _511, 
        /**
         * Pribilof Islands Aleut Communities of St. Paul & S
         */
        _512, 
        /**
         * Qagan Tayagungin Tribe of Sand Point Village
         */
        _513, 
        /**
         * Qawalangin Tribe of Unalaska
         */
        _514, 
        /**
         * Rampart Village
         */
        _515, 
        /**
         * Village of Red Devil
         */
        _516, 
        /**
         * Native Village of Ruby
         */
        _517, 
        /**
         * Saint George Island(See Pribilof Islands Aleut Com
         */
        _518, 
        /**
         * Native Village of Saint Michael
         */
        _519, 
        /**
         * Saint Paul Island (See Pribilof Islands Aleut Comm
         */
        _520, 
        /**
         * Village of Salamatoff
         */
        _521, 
        /**
         * Native Village of Savoonga
         */
        _522, 
        /**
         * Organized Village of Saxman
         */
        _523, 
        /**
         * Native Village of Scammon Bay
         */
        _524, 
        /**
         * Native Village of Selawik
         */
        _525, 
        /**
         * Seldovia Village Tribe
         */
        _526, 
        /**
         * Shageluk Native Village
         */
        _527, 
        /**
         * Native Village of Shaktoolik
         */
        _528, 
        /**
         * Native Village of Sheldon's Point
         */
        _529, 
        /**
         * Native Village of Shishmaref
         */
        _530, 
        /**
         * Shoonaq Tribe of Kodiak
         */
        _531, 
        /**
         * Native Village of Shungnak
         */
        _532, 
        /**
         * Sitka Tribe of Alaska
         */
        _533, 
        /**
         * Skagway Village
         */
        _534, 
        /**
         * Village of Sleetmute
         */
        _535, 
        /**
         * Village of Solomon
         */
        _536, 
        /**
         * South Naknek Village
         */
        _537, 
        /**
         * Stebbins Community Association
         */
        _538, 
        /**
         * Native Village of Stevens
         */
        _539, 
        /**
         * Village of Stony River
         */
        _540, 
        /**
         * Takotna Village
         */
        _541, 
        /**
         * Native Village of Tanacross
         */
        _542, 
        /**
         * Native Village of Tanana
         */
        _543, 
        /**
         * Native Village of Tatitlek
         */
        _544, 
        /**
         * Native Village of Tazlina
         */
        _545, 
        /**
         * Telida Village
         */
        _546, 
        /**
         * Native Village of Teller
         */
        _547, 
        /**
         * Native Village of Tetlin
         */
        _548, 
        /**
         * Central Council of the Tlingit and Haida Indian Tb
         */
        _549, 
        /**
         * Traditional Village of Togiak
         */
        _550, 
        /**
         * Tuluksak Native Community
         */
        _551, 
        /**
         * Native Village of Tuntutuliak
         */
        _552, 
        /**
         * Native Village of Tununak
         */
        _553, 
        /**
         * Twin Hills Village
         */
        _554, 
        /**
         * Native Village of Tyonek
         */
        _555, 
        /**
         * Ugashik Village
         */
        _556, 
        /**
         * Umkumiute Native Village
         */
        _557, 
        /**
         * Native Village of Unalakleet
         */
        _558, 
        /**
         * Native Village of Unga
         */
        _559, 
        /**
         * Village of Venetie (See Native Village of Venetie
         */
        _560, 
        /**
         * Native Village of Venetie Tribal Government (Arcti
         */
        _561, 
        /**
         * Village of Wainwright
         */
        _562, 
        /**
         * Native Village of Wales
         */
        _563, 
        /**
         * Native Village of White Mountain
         */
        _564, 
        /**
         * Wrangell Cooperative Association
         */
        _565, 
        /**
         * Yakutat Tlingit Tribe
         */
        _566, 
        /**
         * NATIVE ENTITIES WITHIN THE CONTIGUOUS 48 STATES
         */
        _NATIVEENTITYCONTIGUOUS, 
        /**
         * Absentee-Shawnee Tribe of Indians of Oklahoma
         */
        _1, 
        /**
         * Assiniboine and Sioux Tribes of the Fort Peck Indi
         */
        _10, 
        /**
         * Havasupai Tribe of the Havasupai Reservation, Ariz
         */
        _100, 
        /**
         * Ho-Chunk Nation of Wisconsin (formerly known as th
         */
        _101, 
        /**
         * Hoh Indian Tribe of the Hoh Indian Reservation, Wa
         */
        _102, 
        /**
         * Hoopa Valley Tribe, California
         */
        _103, 
        /**
         * Hopi Tribe of Arizona
         */
        _104, 
        /**
         * Hopland Band of Pomo Indians of the Hopland Ranche
         */
        _105, 
        /**
         * Houlton Band of Maliseet Indians of Maine
         */
        _106, 
        /**
         * Hualapai Indian Tribe of the Hualapai Indian Reser
         */
        _107, 
        /**
         * Huron Potawatomi, Inc., Michigan
         */
        _108, 
        /**
         * Inaja Band of Diegueno Mission Indians of the Inaj
         */
        _109, 
        /**
         * Augustine Band of Cahuilla Mission Indians of the
         */
        _11, 
        /**
         * Ione Band of Miwok Indians of California
         */
        _110, 
        /**
         * Iowa Tribe of Kansas and Nebraska
         */
        _111, 
        /**
         * Iowa Tribe of Oklahoma
         */
        _112, 
        /**
         * Jackson Rancheria of Me-Wuk Indians of California
         */
        _113, 
        /**
         * Jamestown S'Klallam Tribe of Washington
         */
        _114, 
        /**
         * Jamul Indian Village of California
         */
        _115, 
        /**
         * Jena Band of Choctaw Indians, Louisiana
         */
        _116, 
        /**
         * Jicarilla Apache Tribe of the Jicarilla Apache Ind
         */
        _117, 
        /**
         * Kaibab Band of Paiute Indians of the Kaibab Indian
         */
        _118, 
        /**
         * Kalispel Indian Community of the Kalispel Reservat
         */
        _119, 
        /**
         * Bad River Band of the Lake Superior Tribe of Chipp
         */
        _12, 
        /**
         * Karuk Tribe of California
         */
        _120, 
        /**
         * Kashia Band of Pomo Indians of the Stewarts Point
         */
        _121, 
        /**
         * Kaw Nation, Oklahoma
         */
        _122, 
        /**
         * Keweenaw Bay Indian Community of L'Anse and Ontona
         */
        _123, 
        /**
         * Kialegee Tribal Town, Oklahoma
         */
        _124, 
        /**
         * Kickapoo Tribe of Indians of the Kickapoo Reservat
         */
        _125, 
        /**
         * Kickapoo Tribe of Oklahoma
         */
        _126, 
        /**
         * Kickapoo Traditional Tribe of Texas
         */
        _127, 
        /**
         * Kiowa Indian Tribe of Oklahoma
         */
        _128, 
        /**
         * Klamath Indian Tribe of Oregon
         */
        _129, 
        /**
         * Bay Mills Indian Community of the Sault Ste. Marie
         */
        _13, 
        /**
         * Kootenai Tribe of Idaho
         */
        _130, 
        /**
         * La Jolla Band of Luiseno Mission Indians of the La
         */
        _131, 
        /**
         * La Posta Band of Diegueno Mission Indians of the L
         */
        _132, 
        /**
         * Lac Courte Oreilles Band of Lake Superior Chippewa
         */
        _133, 
        /**
         * Lac du Flambeau Band of Lake Superior Chippewa Ind
         */
        _134, 
        /**
         * Lac Vieux Desert Band of Lake Superior Chippewa In
         */
        _135, 
        /**
         * Las Vegas Tribe of Paiute Indians of the Las Vegas
         */
        _136, 
        /**
         * Little River Band of Ottawa Indians of Michigan
         */
        _137, 
        /**
         * Little Traverse Bay Bands of Odawa Indians of Mich
         */
        _138, 
        /**
         * Lower Lake Rancheria, California
         */
        _139, 
        /**
         * Bear River Band of the Rohnerville Rancheria, Cali
         */
        _14, 
        /**
         * Los Coyotes Band of Cahuilla Mission Indians of th
         */
        _140, 
        /**
         * Lovelock Paiute Tribe of the Lovelock Indian Colon
         */
        _141, 
        /**
         * Lower Brule Sioux Tribe of the Lower Brule Reserva
         */
        _142, 
        /**
         * Lower Elwha Tribal Community of the Lower Elwha Re
         */
        _143, 
        /**
         * Lower Sioux Indian Community of Minnesota Mdewakan
         */
        _144, 
        /**
         * Lummi Tribe of the Lummi Reservation, Washington
         */
        _145, 
        /**
         * Lytton Rancheria of California
         */
        _146, 
        /**
         * Makah Indian Tribe of the Makah Indian Reservation
         */
        _147, 
        /**
         * Manchester Band of Pomo Indians of the Manchester-
         */
        _148, 
        /**
         * Manzanita Band of Diegueno Mission Indians of the
         */
        _149, 
        /**
         * Berry Creek Rancheria of Maidu Indians of Californ
         */
        _15, 
        /**
         * Mashantucket Pequot Tribe of Connecticut
         */
        _150, 
        /**
         * Match-e-be-nash-she-wish Band of Pottawatomi India
         */
        _151, 
        /**
         * Mechoopda Indian Tribe of Chico Rancheria, Califor
         */
        _152, 
        /**
         * Menominee Indian Tribe of Wisconsin
         */
        _153, 
        /**
         * Mesa Grande Band of Diegueno Mission Indians of th
         */
        _154, 
        /**
         * Mescalero Apache Tribe of the Mescalero Reservatio
         */
        _155, 
        /**
         * Miami Tribe of Oklahoma
         */
        _156, 
        /**
         * Miccosukee Tribe of Indians of Florida
         */
        _157, 
        /**
         * Middletown Rancheria of Pomo Indians of California
         */
        _158, 
        /**
         * Minnesota Chippewa Tribe, Minnesota (Six component
         */
        _159, 
        /**
         * Big Lagoon Rancheria, California
         */
        _16, 
        /**
         * Bois Forte Band (Nett Lake); Fond du Lac Band; Gra
         */
        _160, 
        /**
         * Mississippi Band of Choctaw Indians, Mississippi
         */
        _161, 
        /**
         * Moapa Band of Paiute Indians of the Moapa River In
         */
        _162, 
        /**
         * Modoc Tribe of Oklahoma
         */
        _163, 
        /**
         * Mohegan Indian Tribe of Connecticut
         */
        _164, 
        /**
         * Mooretown Rancheria of Maidu Indians of California
         */
        _165, 
        /**
         * Morongo Band of Cahuilla Mission Indians of the Mo
         */
        _166, 
        /**
         * Muckleshoot Indian Tribe of the Muckleshoot Reserv
         */
        _167, 
        /**
         * Muscogee (Creek) Nation, Oklahoma
         */
        _168, 
        /**
         * Narragansett Indian Tribe of Rhode Island
         */
        _169, 
        /**
         * Big Pine Band of Owens Valley Paiute Shoshone Indi
         */
        _17, 
        /**
         * Navajo Nation, Arizona, New Mexico & Utah
         */
        _170, 
        /**
         * Nez Perce Tribe of Idaho
         */
        _171, 
        /**
         * Nisqually Indian Tribe of the Nisqually Reservatio
         */
        _172, 
        /**
         * Nooksack Indian Tribe of Washington
         */
        _173, 
        /**
         * Northern Cheyenne Tribe of the Northern Cheyenne I
         */
        _174, 
        /**
         * Northfork Rancheria of Mono Indians of California
         */
        _175, 
        /**
         * Northwestern Band of Shoshoni Nation of Utah (Wash
         */
        _176, 
        /**
         * Oglala Sioux Tribe of the Pine Ridge Reservation,
         */
        _177, 
        /**
         * Omaha Tribe of Nebraska
         */
        _178, 
        /**
         * Oneida Nation of New York
         */
        _179, 
        /**
         * Big Sandy Rancheria of Mono Indians of California
         */
        _18, 
        /**
         * Oneida Tribe of Wisconsin
         */
        _180, 
        /**
         * Onondaga Nation of New York
         */
        _181, 
        /**
         * Osage Tribe, Oklahoma
         */
        _182, 
        /**
         * Ottawa Tribe of Oklahoma
         */
        _183, 
        /**
         * Otoe-Missouria Tribe of Indians, Oklahoma
         */
        _184, 
        /**
         * Paiute Indian Tribe of Utah
         */
        _185, 
        /**
         * Paiute-Shoshone Indians of the Bishop Community of
         */
        _186, 
        /**
         * Paiute-Shoshone Tribe of the Fallon Reservation an
         */
        _187, 
        /**
         * Paiute-Shoshone Indians of the Lone Pine Community
         */
        _188, 
        /**
         * Pala Band of Luiseno Mission Indians of the Pala R
         */
        _189, 
        /**
         * Big Valley Band of Pomo Indians of the Big Valley
         */
        _19, 
        /**
         * Pascua Yaqui Tribe of Arizona
         */
        _190, 
        /**
         * Paskenta Band of Nomlaki Indians of California
         */
        _191, 
        /**
         * Passamaquoddy Tribe of Maine
         */
        _192, 
        /**
         * Pauma Band of Luiseno Mission Indians of the Pauma
         */
        _193, 
        /**
         * Pawnee Nation of Oklahoma
         */
        _194, 
        /**
         * Pechanga Band of Luiseno Mission Indians of the Pe
         */
        _195, 
        /**
         * Penobscot Tribe of Maine
         */
        _196, 
        /**
         * Peoria Tribe of Indians of Oklahoma
         */
        _197, 
        /**
         * Picayune Rancheria of Chukchansi Indians of Califo
         */
        _198, 
        /**
         * Pinoleville Rancheria of Pomo Indians of Californi
         */
        _199, 
        /**
         * Agua Caliente Band of Cahuilla Indians of the Agua
         */
        _2, 
        /**
         * Blackfeet Tribe of the Blackfeet Indian Reservatio
         */
        _20, 
        /**
         * Pit River Tribe, California (includes Big Bend, Lo
         */
        _200, 
        /**
         * Poarch Band of Creek Indians of Alabama
         */
        _201, 
        /**
         * Pokagon Band of Potawatomi Indians of Michigan
         */
        _202, 
        /**
         * Ponca Tribe of Indians of Oklahoma
         */
        _203, 
        /**
         * Ponca Tribe of Nebraska
         */
        _204, 
        /**
         * Port Gamble Indian Community of the Port Gamble Re
         */
        _205, 
        /**
         * Potter Valley Rancheria of Pomo Indians of Califor
         */
        _206, 
        /**
         * Prairie Band of Potawatomi Indians, Kansas
         */
        _207, 
        /**
         * Prairie Island Indian Community of Minnesota Mdewa
         */
        _208, 
        /**
         * Pueblo of Acoma, New Mexico
         */
        _209, 
        /**
         * Blue Lake Rancheria, California
         */
        _21, 
        /**
         * Pueblo of Cochiti, New Mexico
         */
        _210, 
        /**
         * Pueblo of Jemez, New Mexico
         */
        _211, 
        /**
         * Pueblo of Isleta, New Mexico
         */
        _212, 
        /**
         * Pueblo of Laguna, New Mexico
         */
        _213, 
        /**
         * Pueblo of Nambe, New Mexico
         */
        _214, 
        /**
         * Pueblo of Picuris, New Mexico
         */
        _215, 
        /**
         * Pueblo of Pojoaque, New Mexico
         */
        _216, 
        /**
         * Pueblo of San Felipe, New Mexico
         */
        _217, 
        /**
         * Pueblo of San Juan, New Mexico
         */
        _218, 
        /**
         * Pueblo of San Ildefonso, New Mexico
         */
        _219, 
        /**
         * Bridgeport Paiute Indian Colony of California
         */
        _22, 
        /**
         * Pueblo of Sandia, New Mexico
         */
        _220, 
        /**
         * Pueblo of Santa Ana, New Mexico
         */
        _221, 
        /**
         * Pueblo of Santa Clara, New Mexico
         */
        _222, 
        /**
         * Pueblo of Santo Domingo, New Mexico
         */
        _223, 
        /**
         * Pueblo of Taos, New Mexico
         */
        _224, 
        /**
         * Pueblo of Tesuque, New Mexico
         */
        _225, 
        /**
         * Pueblo of Zia, New Mexico
         */
        _226, 
        /**
         * Puyallup Tribe of the Puyallup Reservation, Washin
         */
        _227, 
        /**
         * Pyramid Lake Paiute Tribe of the Pyramid Lake Rese
         */
        _228, 
        /**
         * Quapaw Tribe of Indians, Oklahoma
         */
        _229, 
        /**
         * Buena Vista Rancheria of Me-Wuk Indians of Califor
         */
        _23, 
        /**
         * Quartz Valley Indian Community of the Quartz Valle
         */
        _230, 
        /**
         * Quechan Tribe of the Fort Yuma Indian Reservation,
         */
        _231, 
        /**
         * Quileute Tribe of the Quileute Reservation, Washin
         */
        _232, 
        /**
         * Quinault Tribe of the Quinault Reservation, Washin
         */
        _233, 
        /**
         * Ramona Band or Village of Cahuilla Mission Indians
         */
        _234, 
        /**
         * Red Cliff Band of Lake Superior Chippewa Indians o
         */
        _235, 
        /**
         * Red Lake Band of Chippewa Indians of the Red Lake
         */
        _236, 
        /**
         * Redding Rancheria, California
         */
        _237, 
        /**
         * Redwood Valley Rancheria of Pomo Indians of Califo
         */
        _238, 
        /**
         * Reno-Sparks Indian Colony, Nevada
         */
        _239, 
        /**
         * Burns Paiute Tribe of the Burns Paiute Indian Colo
         */
        _24, 
        /**
         * Resighini Rancheria, California (formerly known as
         */
        _240, 
        /**
         * Rincon Band of Luiseno Mission Indians of the Rinc
         */
        _241, 
        /**
         * Robinson Rancheria of Pomo Indians of California
         */
        _242, 
        /**
         * Rosebud Sioux Tribe of the Rosebud Indian Reservat
         */
        _243, 
        /**
         * Round Valley Indian Tribes of the Round Valley Res
         */
        _244, 
        /**
         * Rumsey Indian Rancheria of Wintun Indians of Calif
         */
        _245, 
        /**
         * Sac and Fox Tribe of the Mississippi in Iowa
         */
        _246, 
        /**
         * Sac and Fox Nation of Missouri in Kansas and Nebra
         */
        _247, 
        /**
         * Sac and Fox Nation, Oklahoma
         */
        _248, 
        /**
         * Saginaw Chippewa Indian Tribe of Michigan, Isabell
         */
        _249, 
        /**
         * Cabazon Band of Cahuilla Mission Indians of the Ca
         */
        _25, 
        /**
         * Salt River Pima-Maricopa Indian Community of the S
         */
        _250, 
        /**
         * Samish Indian Tribe, Washington
         */
        _251, 
        /**
         * San Carlos Apache Tribe of the San Carlos Reservat
         */
        _252, 
        /**
         * San Juan Southern Paiute Tribe of Arizona
         */
        _253, 
        /**
         * San Manual Band of Serrano Mission Indians of the
         */
        _254, 
        /**
         * San Pasqual Band of Diegueno Mission Indians of Ca
         */
        _255, 
        /**
         * Santa Rosa Indian Community of the Santa Rosa Ranc
         */
        _256, 
        /**
         * Santa Rosa Band of Cahuilla Mission Indians of the
         */
        _257, 
        /**
         * Santa Ynez Band of Chumash Mission Indians of the
         */
        _258, 
        /**
         * Santa Ysabel Band of Diegueno Mission Indians of t
         */
        _259, 
        /**
         * Cachil DeHe Band of Wintun Indians of the Colusa I
         */
        _26, 
        /**
         * Santee Sioux Tribe of the Santee Reservation of Ne
         */
        _260, 
        /**
         * Sauk-Suiattle Indian Tribe of Washington
         */
        _261, 
        /**
         * Sault Ste. Marie Tribe of Chippewa Indians of Mich
         */
        _262, 
        /**
         * Scotts Valley Band of Pomo Indians of California
         */
        _263, 
        /**
         * Seminole Nation of Oklahoma
         */
        _264, 
        /**
         * Seminole Tribe of Florida, Dania, Big Cypress, Bri
         */
        _265, 
        /**
         * Seneca Nation of New York
         */
        _266, 
        /**
         * Seneca-Cayuga Tribe of Oklahoma
         */
        _267, 
        /**
         * Shakopee Mdewakanton Sioux Community of Minnesota
         */
        _268, 
        /**
         * Shawnee Tribe, Oklahoma
         */
        _269, 
        /**
         * Caddo Indian Tribe of Oklahoma
         */
        _27, 
        /**
         * Sherwood Valley Rancheria of Pomo Indians of Calif
         */
        _270, 
        /**
         * Shingle Springs Band of Miwok Indians, Shingle Spr
         */
        _271, 
        /**
         * Shoalwater Bay Tribe of the Shoalwater Bay Indian
         */
        _272, 
        /**
         * Shoshone Tribe of the Wind River Reservation, Wyom
         */
        _273, 
        /**
         * Shoshone-Bannock Tribes of the Fort Hall Reservati
         */
        _274, 
        /**
         * Shoshone-Paiute Tribes of the Duck Valley Reservat
         */
        _275, 
        /**
         * Sisseton-Wahpeton Sioux Tribe of the Lake Traverse
         */
        _276, 
        /**
         * Skokomish Indian Tribe of the Skokomish Reservatio
         */
        _277, 
        /**
         * Skull Valley Band of Goshute Indians of Utah
         */
        _278, 
        /**
         * Smith River Rancheria, California
         */
        _279, 
        /**
         * Cahuilla Band of Mission Indians of the Cahuilla R
         */
        _28, 
        /**
         * Snoqualmie Tribe, Washington
         */
        _280, 
        /**
         * Soboba Band of Luiseno Indians, California (former
         */
        _281, 
        /**
         * Sokaogon Chippewa Community of the Mole Lake Band
         */
        _282, 
        /**
         * Southern Ute Indian Tribe of the Southern Ute Rese
         */
        _283, 
        /**
         * Spirit Lake Tribe, North Dakota (formerly known as
         */
        _284, 
        /**
         * Spokane Tribe of the Spokane Reservation, Washingt
         */
        _285, 
        /**
         * Squaxin Island Tribe of the Squaxin Island Reserva
         */
        _286, 
        /**
         * St. Croix Chippewa Indians of Wisconsin, St. Croix
         */
        _287, 
        /**
         * St. Regis Band of Mohawk Indians of New York
         */
        _288, 
        /**
         * Standing Rock Sioux Tribe of North & South Dakota
         */
        _289, 
        /**
         * Cahto Indian Tribe of the Laytonville Rancheria, C
         */
        _29, 
        /**
         * Stockbridge-Munsee Community of Mohican Indians of
         */
        _290, 
        /**
         * Stillaguamish Tribe of Washington
         */
        _291, 
        /**
         * Summit Lake Paiute Tribe of Nevada
         */
        _292, 
        /**
         * Suquamish Indian Tribe of the Port Madison Reserva
         */
        _293, 
        /**
         * Susanville Indian Rancheria, California
         */
        _294, 
        /**
         * Swinomish Indians of the Swinomish Reservation, Wa
         */
        _295, 
        /**
         * Sycuan Band of Diegueno Mission Indians of Califor
         */
        _296, 
        /**
         * Table Bluff Reservation - Wiyot Tribe, California
         */
        _297, 
        /**
         * Table Mountain Rancheria of California
         */
        _298, 
        /**
         * Te-Moak Tribe of Western Shoshone Indians of Nevad
         */
        _299, 
        /**
         * Ak Chin Indian Community of the Maricopa (Ak Chin)
         */
        _3, 
        /**
         * California Valley Miwok Tribe, California (formerl
         */
        _30, 
        /**
         * Thlopthlocco Tribal Town, Oklahoma
         */
        _300, 
        /**
         * Three Affiliated Tribes of the Fort Berthold Reser
         */
        _301, 
        /**
         * Tohono O'odham Nation of Arizona
         */
        _302, 
        /**
         * Tonawanda Band of Seneca Indians of New York
         */
        _303, 
        /**
         * Tonkawa Tribe of Indians of Oklahoma
         */
        _304, 
        /**
         * Tonto Apache Tribe of Arizona
         */
        _305, 
        /**
         * Torres-Martinez Band of Cahuilla Mission Indians o
         */
        _306, 
        /**
         * Tule River Indian Tribe of the Tule River Reservat
         */
        _307, 
        /**
         * Tulalip Tribes of the Tulalip Reservation, Washing
         */
        _308, 
        /**
         * Tunica-Biloxi Indian Tribe of Louisiana
         */
        _309, 
        /**
         * Campo Band of Diegueno Mission Indians of the Camp
         */
        _31, 
        /**
         * Tuolumne Band of Me-Wuk Indians of the Tuolumne Ra
         */
        _310, 
        /**
         * Turtle Mountain Band of Chippewa Indians of North
         */
        _311, 
        /**
         * Tuscarora Nation of New York
         */
        _312, 
        /**
         * Twenty-Nine Palms Band of Mission Indians of Calif
         */
        _313, 
        /**
         * United Auburn Indian Community of the Auburn Ranch
         */
        _314, 
        /**
         * United Keetoowah Band of Cherokee Indians of Oklah
         */
        _315, 
        /**
         * Upper Lake Band of Pomo Indians of Upper Lake Ranc
         */
        _316, 
        /**
         * Upper Sioux Indian Community of the Upper Sioux Re
         */
        _317, 
        /**
         * Upper Skagit Indian Tribe of Washington
         */
        _318, 
        /**
         * Ute Indian Tribe of the Uintah & Ouray Reservation
         */
        _319, 
        /**
         * Capitan Grande Band of Diegueno Mission Indians of
         */
        _32, 
        /**
         * Ute Mountain Tribe of the Ute Mountain Reservation
         */
        _320, 
        /**
         * Utu Utu Gwaitu Paiute Tribe of the Benton Paiute R
         */
        _321, 
        /**
         * Walker River Paiute Tribe of the Walker River Rese
         */
        _322, 
        /**
         * Wampanoag Tribe of Gay Head (Aquinnah) of Massachu
         */
        _323, 
        /**
         * Washoe Tribe of Nevada & California (Carson Colony
         */
        _324, 
        /**
         * White Mountain Apache Tribe of the Fort Apache Res
         */
        _325, 
        /**
         * Wichita and Affiliated Tribes (Wichita, Keechi, Wa
         */
        _326, 
        /**
         * Winnebago Tribe of Nebraska
         */
        _327, 
        /**
         * Winnemucca Indian Colony of Nevada
         */
        _328, 
        /**
         * Wyandotte Tribe of Oklahoma
         */
        _329, 
        /**
         * Barona Group of Capitan Grande Band of Mission Ind
         */
        _33, 
        /**
         * Yankton Sioux Tribe of South Dakota
         */
        _330, 
        /**
         * Yavapai-Apache Nation of the Camp Verde Indian Res
         */
        _331, 
        /**
         * Yavapai-Prescott Tribe of the Yavapai Reservation,
         */
        _332, 
        /**
         * Yerington Paiute Tribe of the Yerington Colony & C
         */
        _333, 
        /**
         * Yomba Shoshone Tribe of the Yomba Reservation, Nev
         */
        _334, 
        /**
         * Ysleta Del Sur Pueblo of Texas
         */
        _335, 
        /**
         * Yurok Tribe of the Yurok Reservation, California
         */
        _336, 
        /**
         * Zuni Tribe of the Zuni Reservation, New Mexico
         */
        _337, 
        /**
         * Viejas (Baron Long) Group of Capitan Grande Band o
         */
        _34, 
        /**
         * Catawba Indian Nation (aka Catawba Tribe of South
         */
        _35, 
        /**
         * Cayuga Nation of New York
         */
        _36, 
        /**
         * Cedarville Rancheria, California
         */
        _37, 
        /**
         * Chemehuevi Indian Tribe of the Chemehuevi Reservat
         */
        _38, 
        /**
         * Cher-Ae Heights Indian Community of the Trinidad R
         */
        _39, 
        /**
         * Alabama-Coushatta Tribes of Texas
         */
        _4, 
        /**
         * Cherokee Nation, Oklahoma
         */
        _40, 
        /**
         * Cheyenne-Arapaho Tribes of Oklahoma
         */
        _41, 
        /**
         * Cheyenne River Sioux Tribe of the Cheyenne River R
         */
        _42, 
        /**
         * Chickasaw Nation, Oklahoma
         */
        _43, 
        /**
         * Chicken Ranch Rancheria of Me-Wuk Indians of Calif
         */
        _44, 
        /**
         * Chippewa-Cree Indians of the Rocky Boy's Reservati
         */
        _45, 
        /**
         * Chitimacha Tribe of Louisiana
         */
        _46, 
        /**
         * Choctaw Nation of Oklahoma
         */
        _47, 
        /**
         * Citizen Potawatomi Nation, Oklahoma
         */
        _48, 
        /**
         * Cloverdale Rancheria of Pomo Indians of California
         */
        _49, 
        /**
         * Alabama-Quassarte Tribal Town, Oklahoma
         */
        _5, 
        /**
         * Cocopah Tribe of Arizona
         */
        _50, 
        /**
         * Coeur D'Alene Tribe of the Coeur D'Alene Reservati
         */
        _51, 
        /**
         * Cold Springs Rancheria of Mono Indians of Californ
         */
        _52, 
        /**
         * Colorado River Indian Tribes of the Colorado River
         */
        _53, 
        /**
         * Comanche Indian Tribe, Oklahoma
         */
        _54, 
        /**
         * Confederated Salish & Kootenai Tribes of the Flath
         */
        _55, 
        /**
         * Confederated Tribes of the Chehalis Reservation, W
         */
        _56, 
        /**
         * Confederated Tribes of the Colville Reservation, W
         */
        _57, 
        /**
         * Confederated Tribes of the Coos, Lower Umpqua and
         */
        _58, 
        /**
         * Confederated Tribes of the Goshute Reservation, Ne
         */
        _59, 
        /**
         * Alturas Indian Rancheria, California
         */
        _6, 
        /**
         * Confederated Tribes of the Grand Ronde Community o
         */
        _60, 
        /**
         * Confederated Tribes of the Siletz Reservation, Ore
         */
        _61, 
        /**
         * Confederated Tribes of the Umatilla Reservation, O
         */
        _62, 
        /**
         * Confederated Tribes of the Warm Springs Reservatio
         */
        _63, 
        /**
         * Confederated Tribes and Bands of the Yakama Indian
         */
        _64, 
        /**
         * Coquille Tribe of Oregon
         */
        _65, 
        /**
         * Cortina Indian Rancheria of Wintun Indians of Cali
         */
        _66, 
        /**
         * Coushatta Tribe of Louisiana
         */
        _67, 
        /**
         * Cow Creek Band of Umpqua Indians of Oregon
         */
        _68, 
        /**
         * Coyote Valley Band of Pomo Indians of California
         */
        _69, 
        /**
         * Apache Tribe of Oklahoma
         */
        _7, 
        /**
         * Crow Tribe of Montana
         */
        _70, 
        /**
         * Crow Creek Sioux Tribe of the Crow Creek Reservati
         */
        _71, 
        /**
         * Cuyapaipe Community of Diegueno Mission Indians of
         */
        _72, 
        /**
         * Death Valley Timbi-Sha Shoshone Band of California
         */
        _73, 
        /**
         * Delaware Nation, Oklahoma (formerly Delaware Tribe
         */
        _74, 
        /**
         * Delaware Tribe of Indians, Oklahoma
         */
        _75, 
        /**
         * Dry Creek Rancheria of Pomo Indians of California
         */
        _76, 
        /**
         * Duckwater Shoshone Tribe of the Duckwater Reservat
         */
        _77, 
        /**
         * Eastern Band of Cherokee Indians of North Carolina
         */
        _78, 
        /**
         * Eastern Shawnee Tribe of Oklahoma
         */
        _79, 
        /**
         * Arapahoe Tribe of the Wind River Reservation, Wyom
         */
        _8, 
        /**
         * Elem Indian Colony of Pomo Indians of the Sulphur
         */
        _80, 
        /**
         * Elk Valley Rancheria, California
         */
        _81, 
        /**
         * Ely Shoshone Tribe of Nevada
         */
        _82, 
        /**
         * Enterprise Rancheria of Maidu Indians of Californi
         */
        _83, 
        /**
         * Flandreau Santee Sioux Tribe of South Dakota
         */
        _84, 
        /**
         * Forest County Potawatomi Community of Wisconsin Po
         */
        _85, 
        /**
         * Fort Belknap Indian Community of the Fort Belknap
         */
        _86, 
        /**
         * Fort Bidwell Indian Community of the Fort Bidwell
         */
        _87, 
        /**
         * Fort Independence Indian Community of Paiute India
         */
        _88, 
        /**
         * Fort McDermitt Paiute and Shoshone Tribes of the F
         */
        _89, 
        /**
         * Aroostook Band of Micmac Indians of Maine
         */
        _9, 
        /**
         * Fort McDowell Yavapai Nation, Arizona (formerly th
         */
        _90, 
        /**
         * Fort Mojave Indian Tribe of Arizona, California
         */
        _91, 
        /**
         * Fort Sill Apache Tribe of Oklahoma
         */
        _92, 
        /**
         * Gila River Indian Community of the Gila River Indi
         */
        _93, 
        /**
         * Grand Traverse Band of Ottawa & Chippewa Indians o
         */
        _94, 
        /**
         * Graton Rancheria, California
         */
        _95, 
        /**
         * Greenville Rancheria of Maidu Indians of Californi
         */
        _96, 
        /**
         * Grindstone Indian Rancheria of Wintun-Wailaki Indi
         */
        _97, 
        /**
         * Guidiville Rancheria of California
         */
        _98, 
        /**
         * Hannahville Indian Community of Wisconsin Potawato
         */
        _99, 
        /**
         * added to help the parsers
         */
        NULL;
        public static V3TribalEntityUS fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString))
                return null;
        if ("_NativeEntityAlaska".equals(codeString))
          return _NATIVEENTITYALASKA;
        if ("338".equals(codeString))
          return _338;
        if ("339".equals(codeString))
          return _339;
        if ("340".equals(codeString))
          return _340;
        if ("341".equals(codeString))
          return _341;
        if ("342".equals(codeString))
          return _342;
        if ("343".equals(codeString))
          return _343;
        if ("344".equals(codeString))
          return _344;
        if ("345".equals(codeString))
          return _345;
        if ("346".equals(codeString))
          return _346;
        if ("347".equals(codeString))
          return _347;
        if ("348".equals(codeString))
          return _348;
        if ("349".equals(codeString))
          return _349;
        if ("350".equals(codeString))
          return _350;
        if ("351".equals(codeString))
          return _351;
        if ("352".equals(codeString))
          return _352;
        if ("353".equals(codeString))
          return _353;
        if ("354".equals(codeString))
          return _354;
        if ("355".equals(codeString))
          return _355;
        if ("356".equals(codeString))
          return _356;
        if ("357".equals(codeString))
          return _357;
        if ("358".equals(codeString))
          return _358;
        if ("359".equals(codeString))
          return _359;
        if ("360".equals(codeString))
          return _360;
        if ("361".equals(codeString))
          return _361;
        if ("362".equals(codeString))
          return _362;
        if ("363".equals(codeString))
          return _363;
        if ("364".equals(codeString))
          return _364;
        if ("365".equals(codeString))
          return _365;
        if ("366".equals(codeString))
          return _366;
        if ("367".equals(codeString))
          return _367;
        if ("368".equals(codeString))
          return _368;
        if ("369".equals(codeString))
          return _369;
        if ("370".equals(codeString))
          return _370;
        if ("371".equals(codeString))
          return _371;
        if ("372".equals(codeString))
          return _372;
        if ("373".equals(codeString))
          return _373;
        if ("374".equals(codeString))
          return _374;
        if ("375".equals(codeString))
          return _375;
        if ("376".equals(codeString))
          return _376;
        if ("377".equals(codeString))
          return _377;
        if ("378".equals(codeString))
          return _378;
        if ("379".equals(codeString))
          return _379;
        if ("380".equals(codeString))
          return _380;
        if ("381".equals(codeString))
          return _381;
        if ("382".equals(codeString))
          return _382;
        if ("383".equals(codeString))
          return _383;
        if ("384".equals(codeString))
          return _384;
        if ("385".equals(codeString))
          return _385;
        if ("386".equals(codeString))
          return _386;
        if ("387".equals(codeString))
          return _387;
        if ("388".equals(codeString))
          return _388;
        if ("389".equals(codeString))
          return _389;
        if ("390".equals(codeString))
          return _390;
        if ("391".equals(codeString))
          return _391;
        if ("392".equals(codeString))
          return _392;
        if ("393".equals(codeString))
          return _393;
        if ("394".equals(codeString))
          return _394;
        if ("395".equals(codeString))
          return _395;
        if ("396".equals(codeString))
          return _396;
        if ("397".equals(codeString))
          return _397;
        if ("398".equals(codeString))
          return _398;
        if ("399".equals(codeString))
          return _399;
        if ("400".equals(codeString))
          return _400;
        if ("401".equals(codeString))
          return _401;
        if ("402".equals(codeString))
          return _402;
        if ("403".equals(codeString))
          return _403;
        if ("404".equals(codeString))
          return _404;
        if ("405".equals(codeString))
          return _405;
        if ("406".equals(codeString))
          return _406;
        if ("407".equals(codeString))
          return _407;
        if ("408".equals(codeString))
          return _408;
        if ("409".equals(codeString))
          return _409;
        if ("410".equals(codeString))
          return _410;
        if ("411".equals(codeString))
          return _411;
        if ("412".equals(codeString))
          return _412;
        if ("413".equals(codeString))
          return _413;
        if ("414".equals(codeString))
          return _414;
        if ("415".equals(codeString))
          return _415;
        if ("416".equals(codeString))
          return _416;
        if ("417".equals(codeString))
          return _417;
        if ("418".equals(codeString))
          return _418;
        if ("419".equals(codeString))
          return _419;
        if ("420".equals(codeString))
          return _420;
        if ("421".equals(codeString))
          return _421;
        if ("422".equals(codeString))
          return _422;
        if ("423".equals(codeString))
          return _423;
        if ("424".equals(codeString))
          return _424;
        if ("425".equals(codeString))
          return _425;
        if ("426".equals(codeString))
          return _426;
        if ("427".equals(codeString))
          return _427;
        if ("428".equals(codeString))
          return _428;
        if ("429".equals(codeString))
          return _429;
        if ("430".equals(codeString))
          return _430;
        if ("431".equals(codeString))
          return _431;
        if ("432".equals(codeString))
          return _432;
        if ("433".equals(codeString))
          return _433;
        if ("434".equals(codeString))
          return _434;
        if ("435".equals(codeString))
          return _435;
        if ("436".equals(codeString))
          return _436;
        if ("437".equals(codeString))
          return _437;
        if ("438".equals(codeString))
          return _438;
        if ("439".equals(codeString))
          return _439;
        if ("440".equals(codeString))
          return _440;
        if ("441".equals(codeString))
          return _441;
        if ("442".equals(codeString))
          return _442;
        if ("443".equals(codeString))
          return _443;
        if ("444".equals(codeString))
          return _444;
        if ("445".equals(codeString))
          return _445;
        if ("446".equals(codeString))
          return _446;
        if ("447".equals(codeString))
          return _447;
        if ("448".equals(codeString))
          return _448;
        if ("449".equals(codeString))
          return _449;
        if ("450".equals(codeString))
          return _450;
        if ("451".equals(codeString))
          return _451;
        if ("452".equals(codeString))
          return _452;
        if ("453".equals(codeString))
          return _453;
        if ("454".equals(codeString))
          return _454;
        if ("455".equals(codeString))
          return _455;
        if ("456".equals(codeString))
          return _456;
        if ("457".equals(codeString))
          return _457;
        if ("458".equals(codeString))
          return _458;
        if ("459".equals(codeString))
          return _459;
        if ("460".equals(codeString))
          return _460;
        if ("461".equals(codeString))
          return _461;
        if ("462".equals(codeString))
          return _462;
        if ("463".equals(codeString))
          return _463;
        if ("464".equals(codeString))
          return _464;
        if ("465".equals(codeString))
          return _465;
        if ("466".equals(codeString))
          return _466;
        if ("467".equals(codeString))
          return _467;
        if ("468".equals(codeString))
          return _468;
        if ("469".equals(codeString))
          return _469;
        if ("470".equals(codeString))
          return _470;
        if ("471".equals(codeString))
          return _471;
        if ("472".equals(codeString))
          return _472;
        if ("473".equals(codeString))
          return _473;
        if ("474".equals(codeString))
          return _474;
        if ("475".equals(codeString))
          return _475;
        if ("476".equals(codeString))
          return _476;
        if ("477".equals(codeString))
          return _477;
        if ("478".equals(codeString))
          return _478;
        if ("479".equals(codeString))
          return _479;
        if ("480".equals(codeString))
          return _480;
        if ("481".equals(codeString))
          return _481;
        if ("482".equals(codeString))
          return _482;
        if ("483".equals(codeString))
          return _483;
        if ("484".equals(codeString))
          return _484;
        if ("485".equals(codeString))
          return _485;
        if ("486".equals(codeString))
          return _486;
        if ("487".equals(codeString))
          return _487;
        if ("488".equals(codeString))
          return _488;
        if ("489".equals(codeString))
          return _489;
        if ("490".equals(codeString))
          return _490;
        if ("491".equals(codeString))
          return _491;
        if ("492".equals(codeString))
          return _492;
        if ("493".equals(codeString))
          return _493;
        if ("494".equals(codeString))
          return _494;
        if ("495".equals(codeString))
          return _495;
        if ("496".equals(codeString))
          return _496;
        if ("497".equals(codeString))
          return _497;
        if ("498".equals(codeString))
          return _498;
        if ("499".equals(codeString))
          return _499;
        if ("500".equals(codeString))
          return _500;
        if ("501".equals(codeString))
          return _501;
        if ("502".equals(codeString))
          return _502;
        if ("503".equals(codeString))
          return _503;
        if ("504".equals(codeString))
          return _504;
        if ("505".equals(codeString))
          return _505;
        if ("506".equals(codeString))
          return _506;
        if ("507".equals(codeString))
          return _507;
        if ("508".equals(codeString))
          return _508;
        if ("509".equals(codeString))
          return _509;
        if ("510".equals(codeString))
          return _510;
        if ("511".equals(codeString))
          return _511;
        if ("512".equals(codeString))
          return _512;
        if ("513".equals(codeString))
          return _513;
        if ("514".equals(codeString))
          return _514;
        if ("515".equals(codeString))
          return _515;
        if ("516".equals(codeString))
          return _516;
        if ("517".equals(codeString))
          return _517;
        if ("518".equals(codeString))
          return _518;
        if ("519".equals(codeString))
          return _519;
        if ("520".equals(codeString))
          return _520;
        if ("521".equals(codeString))
          return _521;
        if ("522".equals(codeString))
          return _522;
        if ("523".equals(codeString))
          return _523;
        if ("524".equals(codeString))
          return _524;
        if ("525".equals(codeString))
          return _525;
        if ("526".equals(codeString))
          return _526;
        if ("527".equals(codeString))
          return _527;
        if ("528".equals(codeString))
          return _528;
        if ("529".equals(codeString))
          return _529;
        if ("530".equals(codeString))
          return _530;
        if ("531".equals(codeString))
          return _531;
        if ("532".equals(codeString))
          return _532;
        if ("533".equals(codeString))
          return _533;
        if ("534".equals(codeString))
          return _534;
        if ("535".equals(codeString))
          return _535;
        if ("536".equals(codeString))
          return _536;
        if ("537".equals(codeString))
          return _537;
        if ("538".equals(codeString))
          return _538;
        if ("539".equals(codeString))
          return _539;
        if ("540".equals(codeString))
          return _540;
        if ("541".equals(codeString))
          return _541;
        if ("542".equals(codeString))
          return _542;
        if ("543".equals(codeString))
          return _543;
        if ("544".equals(codeString))
          return _544;
        if ("545".equals(codeString))
          return _545;
        if ("546".equals(codeString))
          return _546;
        if ("547".equals(codeString))
          return _547;
        if ("548".equals(codeString))
          return _548;
        if ("549".equals(codeString))
          return _549;
        if ("550".equals(codeString))
          return _550;
        if ("551".equals(codeString))
          return _551;
        if ("552".equals(codeString))
          return _552;
        if ("553".equals(codeString))
          return _553;
        if ("554".equals(codeString))
          return _554;
        if ("555".equals(codeString))
          return _555;
        if ("556".equals(codeString))
          return _556;
        if ("557".equals(codeString))
          return _557;
        if ("558".equals(codeString))
          return _558;
        if ("559".equals(codeString))
          return _559;
        if ("560".equals(codeString))
          return _560;
        if ("561".equals(codeString))
          return _561;
        if ("562".equals(codeString))
          return _562;
        if ("563".equals(codeString))
          return _563;
        if ("564".equals(codeString))
          return _564;
        if ("565".equals(codeString))
          return _565;
        if ("566".equals(codeString))
          return _566;
        if ("_NativeEntityContiguous".equals(codeString))
          return _NATIVEENTITYCONTIGUOUS;
        if ("1".equals(codeString))
          return _1;
        if ("10".equals(codeString))
          return _10;
        if ("100".equals(codeString))
          return _100;
        if ("101".equals(codeString))
          return _101;
        if ("102".equals(codeString))
          return _102;
        if ("103".equals(codeString))
          return _103;
        if ("104".equals(codeString))
          return _104;
        if ("105".equals(codeString))
          return _105;
        if ("106".equals(codeString))
          return _106;
        if ("107".equals(codeString))
          return _107;
        if ("108".equals(codeString))
          return _108;
        if ("109".equals(codeString))
          return _109;
        if ("11".equals(codeString))
          return _11;
        if ("110".equals(codeString))
          return _110;
        if ("111".equals(codeString))
          return _111;
        if ("112".equals(codeString))
          return _112;
        if ("113".equals(codeString))
          return _113;
        if ("114".equals(codeString))
          return _114;
        if ("115".equals(codeString))
          return _115;
        if ("116".equals(codeString))
          return _116;
        if ("117".equals(codeString))
          return _117;
        if ("118".equals(codeString))
          return _118;
        if ("119".equals(codeString))
          return _119;
        if ("12".equals(codeString))
          return _12;
        if ("120".equals(codeString))
          return _120;
        if ("121".equals(codeString))
          return _121;
        if ("122".equals(codeString))
          return _122;
        if ("123".equals(codeString))
          return _123;
        if ("124".equals(codeString))
          return _124;
        if ("125".equals(codeString))
          return _125;
        if ("126".equals(codeString))
          return _126;
        if ("127".equals(codeString))
          return _127;
        if ("128".equals(codeString))
          return _128;
        if ("129".equals(codeString))
          return _129;
        if ("13".equals(codeString))
          return _13;
        if ("130".equals(codeString))
          return _130;
        if ("131".equals(codeString))
          return _131;
        if ("132".equals(codeString))
          return _132;
        if ("133".equals(codeString))
          return _133;
        if ("134".equals(codeString))
          return _134;
        if ("135".equals(codeString))
          return _135;
        if ("136".equals(codeString))
          return _136;
        if ("137".equals(codeString))
          return _137;
        if ("138".equals(codeString))
          return _138;
        if ("139".equals(codeString))
          return _139;
        if ("14".equals(codeString))
          return _14;
        if ("140".equals(codeString))
          return _140;
        if ("141".equals(codeString))
          return _141;
        if ("142".equals(codeString))
          return _142;
        if ("143".equals(codeString))
          return _143;
        if ("144".equals(codeString))
          return _144;
        if ("145".equals(codeString))
          return _145;
        if ("146".equals(codeString))
          return _146;
        if ("147".equals(codeString))
          return _147;
        if ("148".equals(codeString))
          return _148;
        if ("149".equals(codeString))
          return _149;
        if ("15".equals(codeString))
          return _15;
        if ("150".equals(codeString))
          return _150;
        if ("151".equals(codeString))
          return _151;
        if ("152".equals(codeString))
          return _152;
        if ("153".equals(codeString))
          return _153;
        if ("154".equals(codeString))
          return _154;
        if ("155".equals(codeString))
          return _155;
        if ("156".equals(codeString))
          return _156;
        if ("157".equals(codeString))
          return _157;
        if ("158".equals(codeString))
          return _158;
        if ("159".equals(codeString))
          return _159;
        if ("16".equals(codeString))
          return _16;
        if ("160".equals(codeString))
          return _160;
        if ("161".equals(codeString))
          return _161;
        if ("162".equals(codeString))
          return _162;
        if ("163".equals(codeString))
          return _163;
        if ("164".equals(codeString))
          return _164;
        if ("165".equals(codeString))
          return _165;
        if ("166".equals(codeString))
          return _166;
        if ("167".equals(codeString))
          return _167;
        if ("168".equals(codeString))
          return _168;
        if ("169".equals(codeString))
          return _169;
        if ("17".equals(codeString))
          return _17;
        if ("170".equals(codeString))
          return _170;
        if ("171".equals(codeString))
          return _171;
        if ("172".equals(codeString))
          return _172;
        if ("173".equals(codeString))
          return _173;
        if ("174".equals(codeString))
          return _174;
        if ("175".equals(codeString))
          return _175;
        if ("176".equals(codeString))
          return _176;
        if ("177".equals(codeString))
          return _177;
        if ("178".equals(codeString))
          return _178;
        if ("179".equals(codeString))
          return _179;
        if ("18".equals(codeString))
          return _18;
        if ("180".equals(codeString))
          return _180;
        if ("181".equals(codeString))
          return _181;
        if ("182".equals(codeString))
          return _182;
        if ("183".equals(codeString))
          return _183;
        if ("184".equals(codeString))
          return _184;
        if ("185".equals(codeString))
          return _185;
        if ("186".equals(codeString))
          return _186;
        if ("187".equals(codeString))
          return _187;
        if ("188".equals(codeString))
          return _188;
        if ("189".equals(codeString))
          return _189;
        if ("19".equals(codeString))
          return _19;
        if ("190".equals(codeString))
          return _190;
        if ("191".equals(codeString))
          return _191;
        if ("192".equals(codeString))
          return _192;
        if ("193".equals(codeString))
          return _193;
        if ("194".equals(codeString))
          return _194;
        if ("195".equals(codeString))
          return _195;
        if ("196".equals(codeString))
          return _196;
        if ("197".equals(codeString))
          return _197;
        if ("198".equals(codeString))
          return _198;
        if ("199".equals(codeString))
          return _199;
        if ("2".equals(codeString))
          return _2;
        if ("20".equals(codeString))
          return _20;
        if ("200".equals(codeString))
          return _200;
        if ("201".equals(codeString))
          return _201;
        if ("202".equals(codeString))
          return _202;
        if ("203".equals(codeString))
          return _203;
        if ("204".equals(codeString))
          return _204;
        if ("205".equals(codeString))
          return _205;
        if ("206".equals(codeString))
          return _206;
        if ("207".equals(codeString))
          return _207;
        if ("208".equals(codeString))
          return _208;
        if ("209".equals(codeString))
          return _209;
        if ("21".equals(codeString))
          return _21;
        if ("210".equals(codeString))
          return _210;
        if ("211".equals(codeString))
          return _211;
        if ("212".equals(codeString))
          return _212;
        if ("213".equals(codeString))
          return _213;
        if ("214".equals(codeString))
          return _214;
        if ("215".equals(codeString))
          return _215;
        if ("216".equals(codeString))
          return _216;
        if ("217".equals(codeString))
          return _217;
        if ("218".equals(codeString))
          return _218;
        if ("219".equals(codeString))
          return _219;
        if ("22".equals(codeString))
          return _22;
        if ("220".equals(codeString))
          return _220;
        if ("221".equals(codeString))
          return _221;
        if ("222".equals(codeString))
          return _222;
        if ("223".equals(codeString))
          return _223;
        if ("224".equals(codeString))
          return _224;
        if ("225".equals(codeString))
          return _225;
        if ("226".equals(codeString))
          return _226;
        if ("227".equals(codeString))
          return _227;
        if ("228".equals(codeString))
          return _228;
        if ("229".equals(codeString))
          return _229;
        if ("23".equals(codeString))
          return _23;
        if ("230".equals(codeString))
          return _230;
        if ("231".equals(codeString))
          return _231;
        if ("232".equals(codeString))
          return _232;
        if ("233".equals(codeString))
          return _233;
        if ("234".equals(codeString))
          return _234;
        if ("235".equals(codeString))
          return _235;
        if ("236".equals(codeString))
          return _236;
        if ("237".equals(codeString))
          return _237;
        if ("238".equals(codeString))
          return _238;
        if ("239".equals(codeString))
          return _239;
        if ("24".equals(codeString))
          return _24;
        if ("240".equals(codeString))
          return _240;
        if ("241".equals(codeString))
          return _241;
        if ("242".equals(codeString))
          return _242;
        if ("243".equals(codeString))
          return _243;
        if ("244".equals(codeString))
          return _244;
        if ("245".equals(codeString))
          return _245;
        if ("246".equals(codeString))
          return _246;
        if ("247".equals(codeString))
          return _247;
        if ("248".equals(codeString))
          return _248;
        if ("249".equals(codeString))
          return _249;
        if ("25".equals(codeString))
          return _25;
        if ("250".equals(codeString))
          return _250;
        if ("251".equals(codeString))
          return _251;
        if ("252".equals(codeString))
          return _252;
        if ("253".equals(codeString))
          return _253;
        if ("254".equals(codeString))
          return _254;
        if ("255".equals(codeString))
          return _255;
        if ("256".equals(codeString))
          return _256;
        if ("257".equals(codeString))
          return _257;
        if ("258".equals(codeString))
          return _258;
        if ("259".equals(codeString))
          return _259;
        if ("26".equals(codeString))
          return _26;
        if ("260".equals(codeString))
          return _260;
        if ("261".equals(codeString))
          return _261;
        if ("262".equals(codeString))
          return _262;
        if ("263".equals(codeString))
          return _263;
        if ("264".equals(codeString))
          return _264;
        if ("265".equals(codeString))
          return _265;
        if ("266".equals(codeString))
          return _266;
        if ("267".equals(codeString))
          return _267;
        if ("268".equals(codeString))
          return _268;
        if ("269".equals(codeString))
          return _269;
        if ("27".equals(codeString))
          return _27;
        if ("270".equals(codeString))
          return _270;
        if ("271".equals(codeString))
          return _271;
        if ("272".equals(codeString))
          return _272;
        if ("273".equals(codeString))
          return _273;
        if ("274".equals(codeString))
          return _274;
        if ("275".equals(codeString))
          return _275;
        if ("276".equals(codeString))
          return _276;
        if ("277".equals(codeString))
          return _277;
        if ("278".equals(codeString))
          return _278;
        if ("279".equals(codeString))
          return _279;
        if ("28".equals(codeString))
          return _28;
        if ("280".equals(codeString))
          return _280;
        if ("281".equals(codeString))
          return _281;
        if ("282".equals(codeString))
          return _282;
        if ("283".equals(codeString))
          return _283;
        if ("284".equals(codeString))
          return _284;
        if ("285".equals(codeString))
          return _285;
        if ("286".equals(codeString))
          return _286;
        if ("287".equals(codeString))
          return _287;
        if ("288".equals(codeString))
          return _288;
        if ("289".equals(codeString))
          return _289;
        if ("29".equals(codeString))
          return _29;
        if ("290".equals(codeString))
          return _290;
        if ("291".equals(codeString))
          return _291;
        if ("292".equals(codeString))
          return _292;
        if ("293".equals(codeString))
          return _293;
        if ("294".equals(codeString))
          return _294;
        if ("295".equals(codeString))
          return _295;
        if ("296".equals(codeString))
          return _296;
        if ("297".equals(codeString))
          return _297;
        if ("298".equals(codeString))
          return _298;
        if ("299".equals(codeString))
          return _299;
        if ("3".equals(codeString))
          return _3;
        if ("30".equals(codeString))
          return _30;
        if ("300".equals(codeString))
          return _300;
        if ("301".equals(codeString))
          return _301;
        if ("302".equals(codeString))
          return _302;
        if ("303".equals(codeString))
          return _303;
        if ("304".equals(codeString))
          return _304;
        if ("305".equals(codeString))
          return _305;
        if ("306".equals(codeString))
          return _306;
        if ("307".equals(codeString))
          return _307;
        if ("308".equals(codeString))
          return _308;
        if ("309".equals(codeString))
          return _309;
        if ("31".equals(codeString))
          return _31;
        if ("310".equals(codeString))
          return _310;
        if ("311".equals(codeString))
          return _311;
        if ("312".equals(codeString))
          return _312;
        if ("313".equals(codeString))
          return _313;
        if ("314".equals(codeString))
          return _314;
        if ("315".equals(codeString))
          return _315;
        if ("316".equals(codeString))
          return _316;
        if ("317".equals(codeString))
          return _317;
        if ("318".equals(codeString))
          return _318;
        if ("319".equals(codeString))
          return _319;
        if ("32".equals(codeString))
          return _32;
        if ("320".equals(codeString))
          return _320;
        if ("321".equals(codeString))
          return _321;
        if ("322".equals(codeString))
          return _322;
        if ("323".equals(codeString))
          return _323;
        if ("324".equals(codeString))
          return _324;
        if ("325".equals(codeString))
          return _325;
        if ("326".equals(codeString))
          return _326;
        if ("327".equals(codeString))
          return _327;
        if ("328".equals(codeString))
          return _328;
        if ("329".equals(codeString))
          return _329;
        if ("33".equals(codeString))
          return _33;
        if ("330".equals(codeString))
          return _330;
        if ("331".equals(codeString))
          return _331;
        if ("332".equals(codeString))
          return _332;
        if ("333".equals(codeString))
          return _333;
        if ("334".equals(codeString))
          return _334;
        if ("335".equals(codeString))
          return _335;
        if ("336".equals(codeString))
          return _336;
        if ("337".equals(codeString))
          return _337;
        if ("34".equals(codeString))
          return _34;
        if ("35".equals(codeString))
          return _35;
        if ("36".equals(codeString))
          return _36;
        if ("37".equals(codeString))
          return _37;
        if ("38".equals(codeString))
          return _38;
        if ("39".equals(codeString))
          return _39;
        if ("4".equals(codeString))
          return _4;
        if ("40".equals(codeString))
          return _40;
        if ("41".equals(codeString))
          return _41;
        if ("42".equals(codeString))
          return _42;
        if ("43".equals(codeString))
          return _43;
        if ("44".equals(codeString))
          return _44;
        if ("45".equals(codeString))
          return _45;
        if ("46".equals(codeString))
          return _46;
        if ("47".equals(codeString))
          return _47;
        if ("48".equals(codeString))
          return _48;
        if ("49".equals(codeString))
          return _49;
        if ("5".equals(codeString))
          return _5;
        if ("50".equals(codeString))
          return _50;
        if ("51".equals(codeString))
          return _51;
        if ("52".equals(codeString))
          return _52;
        if ("53".equals(codeString))
          return _53;
        if ("54".equals(codeString))
          return _54;
        if ("55".equals(codeString))
          return _55;
        if ("56".equals(codeString))
          return _56;
        if ("57".equals(codeString))
          return _57;
        if ("58".equals(codeString))
          return _58;
        if ("59".equals(codeString))
          return _59;
        if ("6".equals(codeString))
          return _6;
        if ("60".equals(codeString))
          return _60;
        if ("61".equals(codeString))
          return _61;
        if ("62".equals(codeString))
          return _62;
        if ("63".equals(codeString))
          return _63;
        if ("64".equals(codeString))
          return _64;
        if ("65".equals(codeString))
          return _65;
        if ("66".equals(codeString))
          return _66;
        if ("67".equals(codeString))
          return _67;
        if ("68".equals(codeString))
          return _68;
        if ("69".equals(codeString))
          return _69;
        if ("7".equals(codeString))
          return _7;
        if ("70".equals(codeString))
          return _70;
        if ("71".equals(codeString))
          return _71;
        if ("72".equals(codeString))
          return _72;
        if ("73".equals(codeString))
          return _73;
        if ("74".equals(codeString))
          return _74;
        if ("75".equals(codeString))
          return _75;
        if ("76".equals(codeString))
          return _76;
        if ("77".equals(codeString))
          return _77;
        if ("78".equals(codeString))
          return _78;
        if ("79".equals(codeString))
          return _79;
        if ("8".equals(codeString))
          return _8;
        if ("80".equals(codeString))
          return _80;
        if ("81".equals(codeString))
          return _81;
        if ("82".equals(codeString))
          return _82;
        if ("83".equals(codeString))
          return _83;
        if ("84".equals(codeString))
          return _84;
        if ("85".equals(codeString))
          return _85;
        if ("86".equals(codeString))
          return _86;
        if ("87".equals(codeString))
          return _87;
        if ("88".equals(codeString))
          return _88;
        if ("89".equals(codeString))
          return _89;
        if ("9".equals(codeString))
          return _9;
        if ("90".equals(codeString))
          return _90;
        if ("91".equals(codeString))
          return _91;
        if ("92".equals(codeString))
          return _92;
        if ("93".equals(codeString))
          return _93;
        if ("94".equals(codeString))
          return _94;
        if ("95".equals(codeString))
          return _95;
        if ("96".equals(codeString))
          return _96;
        if ("97".equals(codeString))
          return _97;
        if ("98".equals(codeString))
          return _98;
        if ("99".equals(codeString))
          return _99;
        throw new FHIRException("Unknown V3TribalEntityUS code '"+codeString+"'");
        }
        public String toCode() {
          switch (this) {
            case _NATIVEENTITYALASKA: return "_NativeEntityAlaska";
            case _338: return "338";
            case _339: return "339";
            case _340: return "340";
            case _341: return "341";
            case _342: return "342";
            case _343: return "343";
            case _344: return "344";
            case _345: return "345";
            case _346: return "346";
            case _347: return "347";
            case _348: return "348";
            case _349: return "349";
            case _350: return "350";
            case _351: return "351";
            case _352: return "352";
            case _353: return "353";
            case _354: return "354";
            case _355: return "355";
            case _356: return "356";
            case _357: return "357";
            case _358: return "358";
            case _359: return "359";
            case _360: return "360";
            case _361: return "361";
            case _362: return "362";
            case _363: return "363";
            case _364: return "364";
            case _365: return "365";
            case _366: return "366";
            case _367: return "367";
            case _368: return "368";
            case _369: return "369";
            case _370: return "370";
            case _371: return "371";
            case _372: return "372";
            case _373: return "373";
            case _374: return "374";
            case _375: return "375";
            case _376: return "376";
            case _377: return "377";
            case _378: return "378";
            case _379: return "379";
            case _380: return "380";
            case _381: return "381";
            case _382: return "382";
            case _383: return "383";
            case _384: return "384";
            case _385: return "385";
            case _386: return "386";
            case _387: return "387";
            case _388: return "388";
            case _389: return "389";
            case _390: return "390";
            case _391: return "391";
            case _392: return "392";
            case _393: return "393";
            case _394: return "394";
            case _395: return "395";
            case _396: return "396";
            case _397: return "397";
            case _398: return "398";
            case _399: return "399";
            case _400: return "400";
            case _401: return "401";
            case _402: return "402";
            case _403: return "403";
            case _404: return "404";
            case _405: return "405";
            case _406: return "406";
            case _407: return "407";
            case _408: return "408";
            case _409: return "409";
            case _410: return "410";
            case _411: return "411";
            case _412: return "412";
            case _413: return "413";
            case _414: return "414";
            case _415: return "415";
            case _416: return "416";
            case _417: return "417";
            case _418: return "418";
            case _419: return "419";
            case _420: return "420";
            case _421: return "421";
            case _422: return "422";
            case _423: return "423";
            case _424: return "424";
            case _425: return "425";
            case _426: return "426";
            case _427: return "427";
            case _428: return "428";
            case _429: return "429";
            case _430: return "430";
            case _431: return "431";
            case _432: return "432";
            case _433: return "433";
            case _434: return "434";
            case _435: return "435";
            case _436: return "436";
            case _437: return "437";
            case _438: return "438";
            case _439: return "439";
            case _440: return "440";
            case _441: return "441";
            case _442: return "442";
            case _443: return "443";
            case _444: return "444";
            case _445: return "445";
            case _446: return "446";
            case _447: return "447";
            case _448: return "448";
            case _449: return "449";
            case _450: return "450";
            case _451: return "451";
            case _452: return "452";
            case _453: return "453";
            case _454: return "454";
            case _455: return "455";
            case _456: return "456";
            case _457: return "457";
            case _458: return "458";
            case _459: return "459";
            case _460: return "460";
            case _461: return "461";
            case _462: return "462";
            case _463: return "463";
            case _464: return "464";
            case _465: return "465";
            case _466: return "466";
            case _467: return "467";
            case _468: return "468";
            case _469: return "469";
            case _470: return "470";
            case _471: return "471";
            case _472: return "472";
            case _473: return "473";
            case _474: return "474";
            case _475: return "475";
            case _476: return "476";
            case _477: return "477";
            case _478: return "478";
            case _479: return "479";
            case _480: return "480";
            case _481: return "481";
            case _482: return "482";
            case _483: return "483";
            case _484: return "484";
            case _485: return "485";
            case _486: return "486";
            case _487: return "487";
            case _488: return "488";
            case _489: return "489";
            case _490: return "490";
            case _491: return "491";
            case _492: return "492";
            case _493: return "493";
            case _494: return "494";
            case _495: return "495";
            case _496: return "496";
            case _497: return "497";
            case _498: return "498";
            case _499: return "499";
            case _500: return "500";
            case _501: return "501";
            case _502: return "502";
            case _503: return "503";
            case _504: return "504";
            case _505: return "505";
            case _506: return "506";
            case _507: return "507";
            case _508: return "508";
            case _509: return "509";
            case _510: return "510";
            case _511: return "511";
            case _512: return "512";
            case _513: return "513";
            case _514: return "514";
            case _515: return "515";
            case _516: return "516";
            case _517: return "517";
            case _518: return "518";
            case _519: return "519";
            case _520: return "520";
            case _521: return "521";
            case _522: return "522";
            case _523: return "523";
            case _524: return "524";
            case _525: return "525";
            case _526: return "526";
            case _527: return "527";
            case _528: return "528";
            case _529: return "529";
            case _530: return "530";
            case _531: return "531";
            case _532: return "532";
            case _533: return "533";
            case _534: return "534";
            case _535: return "535";
            case _536: return "536";
            case _537: return "537";
            case _538: return "538";
            case _539: return "539";
            case _540: return "540";
            case _541: return "541";
            case _542: return "542";
            case _543: return "543";
            case _544: return "544";
            case _545: return "545";
            case _546: return "546";
            case _547: return "547";
            case _548: return "548";
            case _549: return "549";
            case _550: return "550";
            case _551: return "551";
            case _552: return "552";
            case _553: return "553";
            case _554: return "554";
            case _555: return "555";
            case _556: return "556";
            case _557: return "557";
            case _558: return "558";
            case _559: return "559";
            case _560: return "560";
            case _561: return "561";
            case _562: return "562";
            case _563: return "563";
            case _564: return "564";
            case _565: return "565";
            case _566: return "566";
            case _NATIVEENTITYCONTIGUOUS: return "_NativeEntityContiguous";
            case _1: return "1";
            case _10: return "10";
            case _100: return "100";
            case _101: return "101";
            case _102: return "102";
            case _103: return "103";
            case _104: return "104";
            case _105: return "105";
            case _106: return "106";
            case _107: return "107";
            case _108: return "108";
            case _109: return "109";
            case _11: return "11";
            case _110: return "110";
            case _111: return "111";
            case _112: return "112";
            case _113: return "113";
            case _114: return "114";
            case _115: return "115";
            case _116: return "116";
            case _117: return "117";
            case _118: return "118";
            case _119: return "119";
            case _12: return "12";
            case _120: return "120";
            case _121: return "121";
            case _122: return "122";
            case _123: return "123";
            case _124: return "124";
            case _125: return "125";
            case _126: return "126";
            case _127: return "127";
            case _128: return "128";
            case _129: return "129";
            case _13: return "13";
            case _130: return "130";
            case _131: return "131";
            case _132: return "132";
            case _133: return "133";
            case _134: return "134";
            case _135: return "135";
            case _136: return "136";
            case _137: return "137";
            case _138: return "138";
            case _139: return "139";
            case _14: return "14";
            case _140: return "140";
            case _141: return "141";
            case _142: return "142";
            case _143: return "143";
            case _144: return "144";
            case _145: return "145";
            case _146: return "146";
            case _147: return "147";
            case _148: return "148";
            case _149: return "149";
            case _15: return "15";
            case _150: return "150";
            case _151: return "151";
            case _152: return "152";
            case _153: return "153";
            case _154: return "154";
            case _155: return "155";
            case _156: return "156";
            case _157: return "157";
            case _158: return "158";
            case _159: return "159";
            case _16: return "16";
            case _160: return "160";
            case _161: return "161";
            case _162: return "162";
            case _163: return "163";
            case _164: return "164";
            case _165: return "165";
            case _166: return "166";
            case _167: return "167";
            case _168: return "168";
            case _169: return "169";
            case _17: return "17";
            case _170: return "170";
            case _171: return "171";
            case _172: return "172";
            case _173: return "173";
            case _174: return "174";
            case _175: return "175";
            case _176: return "176";
            case _177: return "177";
            case _178: return "178";
            case _179: return "179";
            case _18: return "18";
            case _180: return "180";
            case _181: return "181";
            case _182: return "182";
            case _183: return "183";
            case _184: return "184";
            case _185: return "185";
            case _186: return "186";
            case _187: return "187";
            case _188: return "188";
            case _189: return "189";
            case _19: return "19";
            case _190: return "190";
            case _191: return "191";
            case _192: return "192";
            case _193: return "193";
            case _194: return "194";
            case _195: return "195";
            case _196: return "196";
            case _197: return "197";
            case _198: return "198";
            case _199: return "199";
            case _2: return "2";
            case _20: return "20";
            case _200: return "200";
            case _201: return "201";
            case _202: return "202";
            case _203: return "203";
            case _204: return "204";
            case _205: return "205";
            case _206: return "206";
            case _207: return "207";
            case _208: return "208";
            case _209: return "209";
            case _21: return "21";
            case _210: return "210";
            case _211: return "211";
            case _212: return "212";
            case _213: return "213";
            case _214: return "214";
            case _215: return "215";
            case _216: return "216";
            case _217: return "217";
            case _218: return "218";
            case _219: return "219";
            case _22: return "22";
            case _220: return "220";
            case _221: return "221";
            case _222: return "222";
            case _223: return "223";
            case _224: return "224";
            case _225: return "225";
            case _226: return "226";
            case _227: return "227";
            case _228: return "228";
            case _229: return "229";
            case _23: return "23";
            case _230: return "230";
            case _231: return "231";
            case _232: return "232";
            case _233: return "233";
            case _234: return "234";
            case _235: return "235";
            case _236: return "236";
            case _237: return "237";
            case _238: return "238";
            case _239: return "239";
            case _24: return "24";
            case _240: return "240";
            case _241: return "241";
            case _242: return "242";
            case _243: return "243";
            case _244: return "244";
            case _245: return "245";
            case _246: return "246";
            case _247: return "247";
            case _248: return "248";
            case _249: return "249";
            case _25: return "25";
            case _250: return "250";
            case _251: return "251";
            case _252: return "252";
            case _253: return "253";
            case _254: return "254";
            case _255: return "255";
            case _256: return "256";
            case _257: return "257";
            case _258: return "258";
            case _259: return "259";
            case _26: return "26";
            case _260: return "260";
            case _261: return "261";
            case _262: return "262";
            case _263: return "263";
            case _264: return "264";
            case _265: return "265";
            case _266: return "266";
            case _267: return "267";
            case _268: return "268";
            case _269: return "269";
            case _27: return "27";
            case _270: return "270";
            case _271: return "271";
            case _272: return "272";
            case _273: return "273";
            case _274: return "274";
            case _275: return "275";
            case _276: return "276";
            case _277: return "277";
            case _278: return "278";
            case _279: return "279";
            case _28: return "28";
            case _280: return "280";
            case _281: return "281";
            case _282: return "282";
            case _283: return "283";
            case _284: return "284";
            case _285: return "285";
            case _286: return "286";
            case _287: return "287";
            case _288: return "288";
            case _289: return "289";
            case _29: return "29";
            case _290: return "290";
            case _291: return "291";
            case _292: return "292";
            case _293: return "293";
            case _294: return "294";
            case _295: return "295";
            case _296: return "296";
            case _297: return "297";
            case _298: return "298";
            case _299: return "299";
            case _3: return "3";
            case _30: return "30";
            case _300: return "300";
            case _301: return "301";
            case _302: return "302";
            case _303: return "303";
            case _304: return "304";
            case _305: return "305";
            case _306: return "306";
            case _307: return "307";
            case _308: return "308";
            case _309: return "309";
            case _31: return "31";
            case _310: return "310";
            case _311: return "311";
            case _312: return "312";
            case _313: return "313";
            case _314: return "314";
            case _315: return "315";
            case _316: return "316";
            case _317: return "317";
            case _318: return "318";
            case _319: return "319";
            case _32: return "32";
            case _320: return "320";
            case _321: return "321";
            case _322: return "322";
            case _323: return "323";
            case _324: return "324";
            case _325: return "325";
            case _326: return "326";
            case _327: return "327";
            case _328: return "328";
            case _329: return "329";
            case _33: return "33";
            case _330: return "330";
            case _331: return "331";
            case _332: return "332";
            case _333: return "333";
            case _334: return "334";
            case _335: return "335";
            case _336: return "336";
            case _337: return "337";
            case _34: return "34";
            case _35: return "35";
            case _36: return "36";
            case _37: return "37";
            case _38: return "38";
            case _39: return "39";
            case _4: return "4";
            case _40: return "40";
            case _41: return "41";
            case _42: return "42";
            case _43: return "43";
            case _44: return "44";
            case _45: return "45";
            case _46: return "46";
            case _47: return "47";
            case _48: return "48";
            case _49: return "49";
            case _5: return "5";
            case _50: return "50";
            case _51: return "51";
            case _52: return "52";
            case _53: return "53";
            case _54: return "54";
            case _55: return "55";
            case _56: return "56";
            case _57: return "57";
            case _58: return "58";
            case _59: return "59";
            case _6: return "6";
            case _60: return "60";
            case _61: return "61";
            case _62: return "62";
            case _63: return "63";
            case _64: return "64";
            case _65: return "65";
            case _66: return "66";
            case _67: return "67";
            case _68: return "68";
            case _69: return "69";
            case _7: return "7";
            case _70: return "70";
            case _71: return "71";
            case _72: return "72";
            case _73: return "73";
            case _74: return "74";
            case _75: return "75";
            case _76: return "76";
            case _77: return "77";
            case _78: return "78";
            case _79: return "79";
            case _8: return "8";
            case _80: return "80";
            case _81: return "81";
            case _82: return "82";
            case _83: return "83";
            case _84: return "84";
            case _85: return "85";
            case _86: return "86";
            case _87: return "87";
            case _88: return "88";
            case _89: return "89";
            case _9: return "9";
            case _90: return "90";
            case _91: return "91";
            case _92: return "92";
            case _93: return "93";
            case _94: return "94";
            case _95: return "95";
            case _96: return "96";
            case _97: return "97";
            case _98: return "98";
            case _99: return "99";
            default: return "?";
          }
        }
        public String getSystem() {
          return "http://hl7.org/fhir/v3/TribalEntityUS";
        }
        public String getDefinition() {
          switch (this) {
            case _NATIVEENTITYALASKA: return "NATIVE ENTITIES WITHIN THE STATE OF ALASKA RECOGNIZED AND ELIGIBLE TO RECEIVE SERVICES FROM THE UNITED STATES BUREAU OF INDIAN AFFAIRS";
            case _338: return "Village of Afognak";
            case _339: return "Agdaagux Tribe of King Cove";
            case _340: return "Native Village of Akhiok";
            case _341: return "Akiachak Native Community";
            case _342: return "Akiak Native Community";
            case _343: return "Native Village of Akutan";
            case _344: return "Village of Alakanuk";
            case _345: return "Alatna Village";
            case _346: return "Native Village of Aleknagik";
            case _347: return "Algaaciq Native Village (St. Mary's)";
            case _348: return "Allakaket Village";
            case _349: return "Native Village of Ambler";
            case _350: return "Village of Anaktuvuk Pass";
            case _351: return "Yupiit of Andreafski";
            case _352: return "Angoon Community Association";
            case _353: return "Village of Aniak";
            case _354: return "Anvik Village";
            case _355: return "Arctic Village (See Native Village of Venetie Trib";
            case _356: return "Asa carsarmiut Tribe (formerly Native Village of M";
            case _357: return "Native Village of Atka";
            case _358: return "Village of Atmautluak";
            case _359: return "Atqasuk Village (Atkasook)";
            case _360: return "Native Village of Barrow Inupiat Traditional Gover";
            case _361: return "Beaver Village";
            case _362: return "Native Village of Belkofski";
            case _363: return "Village of Bill Moore's Slough";
            case _364: return "Birch Creek Tribe";
            case _365: return "Native Village of Brevig Mission";
            case _366: return "Native Village of Buckland";
            case _367: return "Native Village of Cantwell";
            case _368: return "Native Village of Chanega (aka Chenega)";
            case _369: return "Chalkyitsik Village";
            case _370: return "Village of Chefornak";
            case _371: return "Chevak Native Village";
            case _372: return "Chickaloon Native Village";
            case _373: return "Native Village of Chignik";
            case _374: return "Native Village of Chignik Lagoon";
            case _375: return "Chignik Lake Village";
            case _376: return "Chilkat Indian Village (Klukwan)";
            case _377: return "Chilkoot Indian Association (Haines)";
            case _378: return "Chinik Eskimo Community (Golovin)";
            case _379: return "Native Village of Chistochina";
            case _380: return "Native Village of Chitina";
            case _381: return "Native Village of Chuathbaluk (Russian Mission, Ku";
            case _382: return "Chuloonawick Native Village";
            case _383: return "Circle Native Community";
            case _384: return "Village of Clark's Point";
            case _385: return "Native Village of Council";
            case _386: return "Craig Community Association";
            case _387: return "Village of Crooked Creek";
            case _388: return "Curyung Tribal Council (formerly Native Village of";
            case _389: return "Native Village of Deering";
            case _390: return "Native Village of Diomede (aka Inalik)";
            case _391: return "Village of Dot Lake";
            case _392: return "Douglas Indian Association";
            case _393: return "Native Village of Eagle";
            case _394: return "Native Village of Eek";
            case _395: return "Egegik Village";
            case _396: return "Eklutna Native Village";
            case _397: return "Native Village of Ekuk";
            case _398: return "Ekwok Village";
            case _399: return "Native Village of Elim";
            case _400: return "Emmonak Village";
            case _401: return "Evansville Village (aka Bettles Field)";
            case _402: return "Native Village of Eyak (Cordova)";
            case _403: return "Native Village of False Pass";
            case _404: return "Native Village of Fort Yukon";
            case _405: return "Native Village of Gakona";
            case _406: return "Galena Village (aka Louden Village)";
            case _407: return "Native Village of Gambell";
            case _408: return "Native Village of Georgetown";
            case _409: return "Native Village of Goodnews Bay";
            case _410: return "Organized Village of Grayling (aka Holikachuk)";
            case _411: return "Gulkana Village";
            case _412: return "Native Village of Hamilton";
            case _413: return "Healy Lake Village";
            case _414: return "Holy Cross Village";
            case _415: return "Hoonah Indian Association";
            case _416: return "Native Village of Hooper Bay";
            case _417: return "Hughes Village";
            case _418: return "Huslia Village";
            case _419: return "Hydaburg Cooperative Association";
            case _420: return "Igiugig Village";
            case _421: return "Village of Iliamna";
            case _422: return "Inupiat Community of the Arctic Slope";
            case _423: return "Iqurmuit Traditional Council (formerly Native Vill";
            case _424: return "Ivanoff Bay Village";
            case _425: return "Kaguyak Village";
            case _426: return "Organized Village of Kake";
            case _427: return "Kaktovik Village (aka Barter Island)";
            case _428: return "Village of Kalskag";
            case _429: return "Village of Kaltag";
            case _430: return "Native Village of Kanatak";
            case _431: return "Native Village of Karluk";
            case _432: return "Organized Village of Kasaan";
            case _433: return "Native Village of Kasigluk";
            case _434: return "Kenaitze Indian Tribe";
            case _435: return "Ketchikan Indian Corporation";
            case _436: return "Native Village of Kiana";
            case _437: return "King Island Native Community";
            case _438: return "King Salmon Tribe";
            case _439: return "Native Village of Kipnuk";
            case _440: return "Native Village of Kivalina";
            case _441: return "Klawock Cooperative Association";
            case _442: return "Native Village of Kluti Kaah (aka Copper Center)";
            case _443: return "Knik Tribe";
            case _444: return "Native Village of Kobuk";
            case _445: return "Kokhanok Village";
            case _446: return "Native Village of Kongiganak";
            case _447: return "Village of Kotlik";
            case _448: return "Native Village of Kotzebue";
            case _449: return "Native Village of Koyuk";
            case _450: return "Koyukuk Native Village";
            case _451: return "Organized Village of Kwethluk";
            case _452: return "Native Village of Kwigillingok";
            case _453: return "Native Village of Kwinhagak (aka Quinhagak)";
            case _454: return "Native Village of Larsen Bay";
            case _455: return "Levelock Village";
            case _456: return "Lesnoi Village (aka Woody Island)";
            case _457: return "Lime Village";
            case _458: return "Village of Lower Kalskag";
            case _459: return "Manley Hot Springs Village";
            case _460: return "Manokotak Village";
            case _461: return "Native Village of Marshall (aka Fortuna Ledge)";
            case _462: return "Native Village of Mary's Igloo";
            case _463: return "McGrath Native Village";
            case _464: return "Native Village of Mekoryuk";
            case _465: return "Mentasta Traditional Council";
            case _466: return "Metlakatla Indian Community, Annette Island Reserv";
            case _467: return "Native Village of Minto";
            case _468: return "Naknek Native Village";
            case _469: return "Native Village of Nanwalek (aka English Bay)";
            case _470: return "Native Village of Napaimute";
            case _471: return "Native Village of Napakiak";
            case _472: return "Native Village of Napaskiak";
            case _473: return "Native Village of Nelson Lagoon";
            case _474: return "Nenana Native Association";
            case _475: return "New Koliganek Village Council (formerly Koliganek";
            case _476: return "New Stuyahok Village";
            case _477: return "Newhalen Village";
            case _478: return "Newtok Village";
            case _479: return "Native Village of Nightmute";
            case _480: return "Nikolai Village";
            case _481: return "Native Village of Nikolski";
            case _482: return "Ninilchik Village";
            case _483: return "Native Village of Noatak";
            case _484: return "Nome Eskimo Community";
            case _485: return "Nondalton Village";
            case _486: return "Noorvik Native Community";
            case _487: return "Northway Village";
            case _488: return "Native Village of Nuiqsut (aka Nooiksut)";
            case _489: return "Nulato Village";
            case _490: return "Nunakauyarmiut Tribe (formerly Native Village of T";
            case _491: return "Native Village of Nunapitchuk";
            case _492: return "Village of Ohogamiut";
            case _493: return "Village of Old Harbor";
            case _494: return "Orutsararmuit Native Village (aka Bethel)";
            case _495: return "Oscarville Traditional Village";
            case _496: return "Native Village of Ouzinkie";
            case _497: return "Native Village of Paimiut";
            case _498: return "Pauloff Harbor Village";
            case _499: return "Pedro Bay Village";
            case _500: return "Native Village of Perryville";
            case _501: return "Petersburg Indian Association";
            case _502: return "Native Village of Pilot Point";
            case _503: return "Pilot Station Traditional Village";
            case _504: return "Native Village of Pitka's Point";
            case _505: return "Platinum Traditional Village";
            case _506: return "Native Village of Point Hope";
            case _507: return "Native Village of Point Lay";
            case _508: return "Native Village of Port Graham";
            case _509: return "Native Village of Port Heiden";
            case _510: return "Native Village of Port Lions";
            case _511: return "Portage Creek Village (aka Ohgsenakale)";
            case _512: return "Pribilof Islands Aleut Communities of St. Paul & S";
            case _513: return "Qagan Tayagungin Tribe of Sand Point Village";
            case _514: return "Qawalangin Tribe of Unalaska";
            case _515: return "Rampart Village";
            case _516: return "Village of Red Devil";
            case _517: return "Native Village of Ruby";
            case _518: return "Saint George Island(See Pribilof Islands Aleut Com";
            case _519: return "Native Village of Saint Michael";
            case _520: return "Saint Paul Island (See Pribilof Islands Aleut Comm";
            case _521: return "Village of Salamatoff";
            case _522: return "Native Village of Savoonga";
            case _523: return "Organized Village of Saxman";
            case _524: return "Native Village of Scammon Bay";
            case _525: return "Native Village of Selawik";
            case _526: return "Seldovia Village Tribe";
            case _527: return "Shageluk Native Village";
            case _528: return "Native Village of Shaktoolik";
            case _529: return "Native Village of Sheldon's Point";
            case _530: return "Native Village of Shishmaref";
            case _531: return "Shoonaq Tribe of Kodiak";
            case _532: return "Native Village of Shungnak";
            case _533: return "Sitka Tribe of Alaska";
            case _534: return "Skagway Village";
            case _535: return "Village of Sleetmute";
            case _536: return "Village of Solomon";
            case _537: return "South Naknek Village";
            case _538: return "Stebbins Community Association";
            case _539: return "Native Village of Stevens";
            case _540: return "Village of Stony River";
            case _541: return "Takotna Village";
            case _542: return "Native Village of Tanacross";
            case _543: return "Native Village of Tanana";
            case _544: return "Native Village of Tatitlek";
            case _545: return "Native Village of Tazlina";
            case _546: return "Telida Village";
            case _547: return "Native Village of Teller";
            case _548: return "Native Village of Tetlin";
            case _549: return "Central Council of the Tlingit and Haida Indian Tb";
            case _550: return "Traditional Village of Togiak";
            case _551: return "Tuluksak Native Community";
            case _552: return "Native Village of Tuntutuliak";
            case _553: return "Native Village of Tununak";
            case _554: return "Twin Hills Village";
            case _555: return "Native Village of Tyonek";
            case _556: return "Ugashik Village";
            case _557: return "Umkumiute Native Village";
            case _558: return "Native Village of Unalakleet";
            case _559: return "Native Village of Unga";
            case _560: return "Village of Venetie (See Native Village of Venetie";
            case _561: return "Native Village of Venetie Tribal Government (Arcti";
            case _562: return "Village of Wainwright";
            case _563: return "Native Village of Wales";
            case _564: return "Native Village of White Mountain";
            case _565: return "Wrangell Cooperative Association";
            case _566: return "Yakutat Tlingit Tribe";
            case _NATIVEENTITYCONTIGUOUS: return "NATIVE ENTITIES WITHIN THE CONTIGUOUS 48 STATES";
            case _1: return "Absentee-Shawnee Tribe of Indians of Oklahoma";
            case _10: return "Assiniboine and Sioux Tribes of the Fort Peck Indi";
            case _100: return "Havasupai Tribe of the Havasupai Reservation, Ariz";
            case _101: return "Ho-Chunk Nation of Wisconsin (formerly known as th";
            case _102: return "Hoh Indian Tribe of the Hoh Indian Reservation, Wa";
            case _103: return "Hoopa Valley Tribe, California";
            case _104: return "Hopi Tribe of Arizona";
            case _105: return "Hopland Band of Pomo Indians of the Hopland Ranche";
            case _106: return "Houlton Band of Maliseet Indians of Maine";
            case _107: return "Hualapai Indian Tribe of the Hualapai Indian Reser";
            case _108: return "Huron Potawatomi, Inc., Michigan";
            case _109: return "Inaja Band of Diegueno Mission Indians of the Inaj";
            case _11: return "Augustine Band of Cahuilla Mission Indians of the";
            case _110: return "Ione Band of Miwok Indians of California";
            case _111: return "Iowa Tribe of Kansas and Nebraska";
            case _112: return "Iowa Tribe of Oklahoma";
            case _113: return "Jackson Rancheria of Me-Wuk Indians of California";
            case _114: return "Jamestown S'Klallam Tribe of Washington";
            case _115: return "Jamul Indian Village of California";
            case _116: return "Jena Band of Choctaw Indians, Louisiana";
            case _117: return "Jicarilla Apache Tribe of the Jicarilla Apache Ind";
            case _118: return "Kaibab Band of Paiute Indians of the Kaibab Indian";
            case _119: return "Kalispel Indian Community of the Kalispel Reservat";
            case _12: return "Bad River Band of the Lake Superior Tribe of Chipp";
            case _120: return "Karuk Tribe of California";
            case _121: return "Kashia Band of Pomo Indians of the Stewarts Point";
            case _122: return "Kaw Nation, Oklahoma";
            case _123: return "Keweenaw Bay Indian Community of L'Anse and Ontona";
            case _124: return "Kialegee Tribal Town, Oklahoma";
            case _125: return "Kickapoo Tribe of Indians of the Kickapoo Reservat";
            case _126: return "Kickapoo Tribe of Oklahoma";
            case _127: return "Kickapoo Traditional Tribe of Texas";
            case _128: return "Kiowa Indian Tribe of Oklahoma";
            case _129: return "Klamath Indian Tribe of Oregon";
            case _13: return "Bay Mills Indian Community of the Sault Ste. Marie";
            case _130: return "Kootenai Tribe of Idaho";
            case _131: return "La Jolla Band of Luiseno Mission Indians of the La";
            case _132: return "La Posta Band of Diegueno Mission Indians of the L";
            case _133: return "Lac Courte Oreilles Band of Lake Superior Chippewa";
            case _134: return "Lac du Flambeau Band of Lake Superior Chippewa Ind";
            case _135: return "Lac Vieux Desert Band of Lake Superior Chippewa In";
            case _136: return "Las Vegas Tribe of Paiute Indians of the Las Vegas";
            case _137: return "Little River Band of Ottawa Indians of Michigan";
            case _138: return "Little Traverse Bay Bands of Odawa Indians of Mich";
            case _139: return "Lower Lake Rancheria, California";
            case _14: return "Bear River Band of the Rohnerville Rancheria, Cali";
            case _140: return "Los Coyotes Band of Cahuilla Mission Indians of th";
            case _141: return "Lovelock Paiute Tribe of the Lovelock Indian Colon";
            case _142: return "Lower Brule Sioux Tribe of the Lower Brule Reserva";
            case _143: return "Lower Elwha Tribal Community of the Lower Elwha Re";
            case _144: return "Lower Sioux Indian Community of Minnesota Mdewakan";
            case _145: return "Lummi Tribe of the Lummi Reservation, Washington";
            case _146: return "Lytton Rancheria of California";
            case _147: return "Makah Indian Tribe of the Makah Indian Reservation";
            case _148: return "Manchester Band of Pomo Indians of the Manchester-";
            case _149: return "Manzanita Band of Diegueno Mission Indians of the";
            case _15: return "Berry Creek Rancheria of Maidu Indians of Californ";
            case _150: return "Mashantucket Pequot Tribe of Connecticut";
            case _151: return "Match-e-be-nash-she-wish Band of Pottawatomi India";
            case _152: return "Mechoopda Indian Tribe of Chico Rancheria, Califor";
            case _153: return "Menominee Indian Tribe of Wisconsin";
            case _154: return "Mesa Grande Band of Diegueno Mission Indians of th";
            case _155: return "Mescalero Apache Tribe of the Mescalero Reservatio";
            case _156: return "Miami Tribe of Oklahoma";
            case _157: return "Miccosukee Tribe of Indians of Florida";
            case _158: return "Middletown Rancheria of Pomo Indians of California";
            case _159: return "Minnesota Chippewa Tribe, Minnesota (Six component";
            case _16: return "Big Lagoon Rancheria, California";
            case _160: return "Bois Forte Band (Nett Lake); Fond du Lac Band; Gra";
            case _161: return "Mississippi Band of Choctaw Indians, Mississippi";
            case _162: return "Moapa Band of Paiute Indians of the Moapa River In";
            case _163: return "Modoc Tribe of Oklahoma";
            case _164: return "Mohegan Indian Tribe of Connecticut";
            case _165: return "Mooretown Rancheria of Maidu Indians of California";
            case _166: return "Morongo Band of Cahuilla Mission Indians of the Mo";
            case _167: return "Muckleshoot Indian Tribe of the Muckleshoot Reserv";
            case _168: return "Muscogee (Creek) Nation, Oklahoma";
            case _169: return "Narragansett Indian Tribe of Rhode Island";
            case _17: return "Big Pine Band of Owens Valley Paiute Shoshone Indi";
            case _170: return "Navajo Nation, Arizona, New Mexico & Utah";
            case _171: return "Nez Perce Tribe of Idaho";
            case _172: return "Nisqually Indian Tribe of the Nisqually Reservatio";
            case _173: return "Nooksack Indian Tribe of Washington";
            case _174: return "Northern Cheyenne Tribe of the Northern Cheyenne I";
            case _175: return "Northfork Rancheria of Mono Indians of California";
            case _176: return "Northwestern Band of Shoshoni Nation of Utah (Wash";
            case _177: return "Oglala Sioux Tribe of the Pine Ridge Reservation,";
            case _178: return "Omaha Tribe of Nebraska";
            case _179: return "Oneida Nation of New York";
            case _18: return "Big Sandy Rancheria of Mono Indians of California";
            case _180: return "Oneida Tribe of Wisconsin";
            case _181: return "Onondaga Nation of New York";
            case _182: return "Osage Tribe, Oklahoma";
            case _183: return "Ottawa Tribe of Oklahoma";
            case _184: return "Otoe-Missouria Tribe of Indians, Oklahoma";
            case _185: return "Paiute Indian Tribe of Utah";
            case _186: return "Paiute-Shoshone Indians of the Bishop Community of";
            case _187: return "Paiute-Shoshone Tribe of the Fallon Reservation an";
            case _188: return "Paiute-Shoshone Indians of the Lone Pine Community";
            case _189: return "Pala Band of Luiseno Mission Indians of the Pala R";
            case _19: return "Big Valley Band of Pomo Indians of the Big Valley";
            case _190: return "Pascua Yaqui Tribe of Arizona";
            case _191: return "Paskenta Band of Nomlaki Indians of California";
            case _192: return "Passamaquoddy Tribe of Maine";
            case _193: return "Pauma Band of Luiseno Mission Indians of the Pauma";
            case _194: return "Pawnee Nation of Oklahoma";
            case _195: return "Pechanga Band of Luiseno Mission Indians of the Pe";
            case _196: return "Penobscot Tribe of Maine";
            case _197: return "Peoria Tribe of Indians of Oklahoma";
            case _198: return "Picayune Rancheria of Chukchansi Indians of Califo";
            case _199: return "Pinoleville Rancheria of Pomo Indians of Californi";
            case _2: return "Agua Caliente Band of Cahuilla Indians of the Agua";
            case _20: return "Blackfeet Tribe of the Blackfeet Indian Reservatio";
            case _200: return "Pit River Tribe, California (includes Big Bend, Lo";
            case _201: return "Poarch Band of Creek Indians of Alabama";
            case _202: return "Pokagon Band of Potawatomi Indians of Michigan";
            case _203: return "Ponca Tribe of Indians of Oklahoma";
            case _204: return "Ponca Tribe of Nebraska";
            case _205: return "Port Gamble Indian Community of the Port Gamble Re";
            case _206: return "Potter Valley Rancheria of Pomo Indians of Califor";
            case _207: return "Prairie Band of Potawatomi Indians, Kansas";
            case _208: return "Prairie Island Indian Community of Minnesota Mdewa";
            case _209: return "Pueblo of Acoma, New Mexico";
            case _21: return "Blue Lake Rancheria, California";
            case _210: return "Pueblo of Cochiti, New Mexico";
            case _211: return "Pueblo of Jemez, New Mexico";
            case _212: return "Pueblo of Isleta, New Mexico";
            case _213: return "Pueblo of Laguna, New Mexico";
            case _214: return "Pueblo of Nambe, New Mexico";
            case _215: return "Pueblo of Picuris, New Mexico";
            case _216: return "Pueblo of Pojoaque, New Mexico";
            case _217: return "Pueblo of San Felipe, New Mexico";
            case _218: return "Pueblo of San Juan, New Mexico";
            case _219: return "Pueblo of San Ildefonso, New Mexico";
            case _22: return "Bridgeport Paiute Indian Colony of California";
            case _220: return "Pueblo of Sandia, New Mexico";
            case _221: return "Pueblo of Santa Ana, New Mexico";
            case _222: return "Pueblo of Santa Clara, New Mexico";
            case _223: return "Pueblo of Santo Domingo, New Mexico";
            case _224: return "Pueblo of Taos, New Mexico";
            case _225: return "Pueblo of Tesuque, New Mexico";
            case _226: return "Pueblo of Zia, New Mexico";
            case _227: return "Puyallup Tribe of the Puyallup Reservation, Washin";
            case _228: return "Pyramid Lake Paiute Tribe of the Pyramid Lake Rese";
            case _229: return "Quapaw Tribe of Indians, Oklahoma";
            case _23: return "Buena Vista Rancheria of Me-Wuk Indians of Califor";
            case _230: return "Quartz Valley Indian Community of the Quartz Valle";
            case _231: return "Quechan Tribe of the Fort Yuma Indian Reservation,";
            case _232: return "Quileute Tribe of the Quileute Reservation, Washin";
            case _233: return "Quinault Tribe of the Quinault Reservation, Washin";
            case _234: return "Ramona Band or Village of Cahuilla Mission Indians";
            case _235: return "Red Cliff Band of Lake Superior Chippewa Indians o";
            case _236: return "Red Lake Band of Chippewa Indians of the Red Lake";
            case _237: return "Redding Rancheria, California";
            case _238: return "Redwood Valley Rancheria of Pomo Indians of Califo";
            case _239: return "Reno-Sparks Indian Colony, Nevada";
            case _24: return "Burns Paiute Tribe of the Burns Paiute Indian Colo";
            case _240: return "Resighini Rancheria, California (formerly known as";
            case _241: return "Rincon Band of Luiseno Mission Indians of the Rinc";
            case _242: return "Robinson Rancheria of Pomo Indians of California";
            case _243: return "Rosebud Sioux Tribe of the Rosebud Indian Reservat";
            case _244: return "Round Valley Indian Tribes of the Round Valley Res";
            case _245: return "Rumsey Indian Rancheria of Wintun Indians of Calif";
            case _246: return "Sac and Fox Tribe of the Mississippi in Iowa";
            case _247: return "Sac and Fox Nation of Missouri in Kansas and Nebra";
            case _248: return "Sac and Fox Nation, Oklahoma";
            case _249: return "Saginaw Chippewa Indian Tribe of Michigan, Isabell";
            case _25: return "Cabazon Band of Cahuilla Mission Indians of the Ca";
            case _250: return "Salt River Pima-Maricopa Indian Community of the S";
            case _251: return "Samish Indian Tribe, Washington";
            case _252: return "San Carlos Apache Tribe of the San Carlos Reservat";
            case _253: return "San Juan Southern Paiute Tribe of Arizona";
            case _254: return "San Manual Band of Serrano Mission Indians of the";
            case _255: return "San Pasqual Band of Diegueno Mission Indians of Ca";
            case _256: return "Santa Rosa Indian Community of the Santa Rosa Ranc";
            case _257: return "Santa Rosa Band of Cahuilla Mission Indians of the";
            case _258: return "Santa Ynez Band of Chumash Mission Indians of the";
            case _259: return "Santa Ysabel Band of Diegueno Mission Indians of t";
            case _26: return "Cachil DeHe Band of Wintun Indians of the Colusa I";
            case _260: return "Santee Sioux Tribe of the Santee Reservation of Ne";
            case _261: return "Sauk-Suiattle Indian Tribe of Washington";
            case _262: return "Sault Ste. Marie Tribe of Chippewa Indians of Mich";
            case _263: return "Scotts Valley Band of Pomo Indians of California";
            case _264: return "Seminole Nation of Oklahoma";
            case _265: return "Seminole Tribe of Florida, Dania, Big Cypress, Bri";
            case _266: return "Seneca Nation of New York";
            case _267: return "Seneca-Cayuga Tribe of Oklahoma";
            case _268: return "Shakopee Mdewakanton Sioux Community of Minnesota";
            case _269: return "Shawnee Tribe, Oklahoma";
            case _27: return "Caddo Indian Tribe of Oklahoma";
            case _270: return "Sherwood Valley Rancheria of Pomo Indians of Calif";
            case _271: return "Shingle Springs Band of Miwok Indians, Shingle Spr";
            case _272: return "Shoalwater Bay Tribe of the Shoalwater Bay Indian";
            case _273: return "Shoshone Tribe of the Wind River Reservation, Wyom";
            case _274: return "Shoshone-Bannock Tribes of the Fort Hall Reservati";
            case _275: return "Shoshone-Paiute Tribes of the Duck Valley Reservat";
            case _276: return "Sisseton-Wahpeton Sioux Tribe of the Lake Traverse";
            case _277: return "Skokomish Indian Tribe of the Skokomish Reservatio";
            case _278: return "Skull Valley Band of Goshute Indians of Utah";
            case _279: return "Smith River Rancheria, California";
            case _28: return "Cahuilla Band of Mission Indians of the Cahuilla R";
            case _280: return "Snoqualmie Tribe, Washington";
            case _281: return "Soboba Band of Luiseno Indians, California (former";
            case _282: return "Sokaogon Chippewa Community of the Mole Lake Band";
            case _283: return "Southern Ute Indian Tribe of the Southern Ute Rese";
            case _284: return "Spirit Lake Tribe, North Dakota (formerly known as";
            case _285: return "Spokane Tribe of the Spokane Reservation, Washingt";
            case _286: return "Squaxin Island Tribe of the Squaxin Island Reserva";
            case _287: return "St. Croix Chippewa Indians of Wisconsin, St. Croix";
            case _288: return "St. Regis Band of Mohawk Indians of New York";
            case _289: return "Standing Rock Sioux Tribe of North & South Dakota";
            case _29: return "Cahto Indian Tribe of the Laytonville Rancheria, C";
            case _290: return "Stockbridge-Munsee Community of Mohican Indians of";
            case _291: return "Stillaguamish Tribe of Washington";
            case _292: return "Summit Lake Paiute Tribe of Nevada";
            case _293: return "Suquamish Indian Tribe of the Port Madison Reserva";
            case _294: return "Susanville Indian Rancheria, California";
            case _295: return "Swinomish Indians of the Swinomish Reservation, Wa";
            case _296: return "Sycuan Band of Diegueno Mission Indians of Califor";
            case _297: return "Table Bluff Reservation - Wiyot Tribe, California";
            case _298: return "Table Mountain Rancheria of California";
            case _299: return "Te-Moak Tribe of Western Shoshone Indians of Nevad";
            case _3: return "Ak Chin Indian Community of the Maricopa (Ak Chin)";
            case _30: return "California Valley Miwok Tribe, California (formerl";
            case _300: return "Thlopthlocco Tribal Town, Oklahoma";
            case _301: return "Three Affiliated Tribes of the Fort Berthold Reser";
            case _302: return "Tohono O'odham Nation of Arizona";
            case _303: return "Tonawanda Band of Seneca Indians of New York";
            case _304: return "Tonkawa Tribe of Indians of Oklahoma";
            case _305: return "Tonto Apache Tribe of Arizona";
            case _306: return "Torres-Martinez Band of Cahuilla Mission Indians o";
            case _307: return "Tule River Indian Tribe of the Tule River Reservat";
            case _308: return "Tulalip Tribes of the Tulalip Reservation, Washing";
            case _309: return "Tunica-Biloxi Indian Tribe of Louisiana";
            case _31: return "Campo Band of Diegueno Mission Indians of the Camp";
            case _310: return "Tuolumne Band of Me-Wuk Indians of the Tuolumne Ra";
            case _311: return "Turtle Mountain Band of Chippewa Indians of North";
            case _312: return "Tuscarora Nation of New York";
            case _313: return "Twenty-Nine Palms Band of Mission Indians of Calif";
            case _314: return "United Auburn Indian Community of the Auburn Ranch";
            case _315: return "United Keetoowah Band of Cherokee Indians of Oklah";
            case _316: return "Upper Lake Band of Pomo Indians of Upper Lake Ranc";
            case _317: return "Upper Sioux Indian Community of the Upper Sioux Re";
            case _318: return "Upper Skagit Indian Tribe of Washington";
            case _319: return "Ute Indian Tribe of the Uintah & Ouray Reservation";
            case _32: return "Capitan Grande Band of Diegueno Mission Indians of";
            case _320: return "Ute Mountain Tribe of the Ute Mountain Reservation";
            case _321: return "Utu Utu Gwaitu Paiute Tribe of the Benton Paiute R";
            case _322: return "Walker River Paiute Tribe of the Walker River Rese";
            case _323: return "Wampanoag Tribe of Gay Head (Aquinnah) of Massachu";
            case _324: return "Washoe Tribe of Nevada & California (Carson Colony";
            case _325: return "White Mountain Apache Tribe of the Fort Apache Res";
            case _326: return "Wichita and Affiliated Tribes (Wichita, Keechi, Wa";
            case _327: return "Winnebago Tribe of Nebraska";
            case _328: return "Winnemucca Indian Colony of Nevada";
            case _329: return "Wyandotte Tribe of Oklahoma";
            case _33: return "Barona Group of Capitan Grande Band of Mission Ind";
            case _330: return "Yankton Sioux Tribe of South Dakota";
            case _331: return "Yavapai-Apache Nation of the Camp Verde Indian Res";
            case _332: return "Yavapai-Prescott Tribe of the Yavapai Reservation,";
            case _333: return "Yerington Paiute Tribe of the Yerington Colony & C";
            case _334: return "Yomba Shoshone Tribe of the Yomba Reservation, Nev";
            case _335: return "Ysleta Del Sur Pueblo of Texas";
            case _336: return "Yurok Tribe of the Yurok Reservation, California";
            case _337: return "Zuni Tribe of the Zuni Reservation, New Mexico";
            case _34: return "Viejas (Baron Long) Group of Capitan Grande Band o";
            case _35: return "Catawba Indian Nation (aka Catawba Tribe of South";
            case _36: return "Cayuga Nation of New York";
            case _37: return "Cedarville Rancheria, California";
            case _38: return "Chemehuevi Indian Tribe of the Chemehuevi Reservat";
            case _39: return "Cher-Ae Heights Indian Community of the Trinidad R";
            case _4: return "Alabama-Coushatta Tribes of Texas";
            case _40: return "Cherokee Nation, Oklahoma";
            case _41: return "Cheyenne-Arapaho Tribes of Oklahoma";
            case _42: return "Cheyenne River Sioux Tribe of the Cheyenne River R";
            case _43: return "Chickasaw Nation, Oklahoma";
            case _44: return "Chicken Ranch Rancheria of Me-Wuk Indians of Calif";
            case _45: return "Chippewa-Cree Indians of the Rocky Boy's Reservati";
            case _46: return "Chitimacha Tribe of Louisiana";
            case _47: return "Choctaw Nation of Oklahoma";
            case _48: return "Citizen Potawatomi Nation, Oklahoma";
            case _49: return "Cloverdale Rancheria of Pomo Indians of California";
            case _5: return "Alabama-Quassarte Tribal Town, Oklahoma";
            case _50: return "Cocopah Tribe of Arizona";
            case _51: return "Coeur D'Alene Tribe of the Coeur D'Alene Reservati";
            case _52: return "Cold Springs Rancheria of Mono Indians of Californ";
            case _53: return "Colorado River Indian Tribes of the Colorado River";
            case _54: return "Comanche Indian Tribe, Oklahoma";
            case _55: return "Confederated Salish & Kootenai Tribes of the Flath";
            case _56: return "Confederated Tribes of the Chehalis Reservation, W";
            case _57: return "Confederated Tribes of the Colville Reservation, W";
            case _58: return "Confederated Tribes of the Coos, Lower Umpqua and";
            case _59: return "Confederated Tribes of the Goshute Reservation, Ne";
            case _6: return "Alturas Indian Rancheria, California";
            case _60: return "Confederated Tribes of the Grand Ronde Community o";
            case _61: return "Confederated Tribes of the Siletz Reservation, Ore";
            case _62: return "Confederated Tribes of the Umatilla Reservation, O";
            case _63: return "Confederated Tribes of the Warm Springs Reservatio";
            case _64: return "Confederated Tribes and Bands of the Yakama Indian";
            case _65: return "Coquille Tribe of Oregon";
            case _66: return "Cortina Indian Rancheria of Wintun Indians of Cali";
            case _67: return "Coushatta Tribe of Louisiana";
            case _68: return "Cow Creek Band of Umpqua Indians of Oregon";
            case _69: return "Coyote Valley Band of Pomo Indians of California";
            case _7: return "Apache Tribe of Oklahoma";
            case _70: return "Crow Tribe of Montana";
            case _71: return "Crow Creek Sioux Tribe of the Crow Creek Reservati";
            case _72: return "Cuyapaipe Community of Diegueno Mission Indians of";
            case _73: return "Death Valley Timbi-Sha Shoshone Band of California";
            case _74: return "Delaware Nation, Oklahoma (formerly Delaware Tribe";
            case _75: return "Delaware Tribe of Indians, Oklahoma";
            case _76: return "Dry Creek Rancheria of Pomo Indians of California";
            case _77: return "Duckwater Shoshone Tribe of the Duckwater Reservat";
            case _78: return "Eastern Band of Cherokee Indians of North Carolina";
            case _79: return "Eastern Shawnee Tribe of Oklahoma";
            case _8: return "Arapahoe Tribe of the Wind River Reservation, Wyom";
            case _80: return "Elem Indian Colony of Pomo Indians of the Sulphur";
            case _81: return "Elk Valley Rancheria, California";
            case _82: return "Ely Shoshone Tribe of Nevada";
            case _83: return "Enterprise Rancheria of Maidu Indians of Californi";
            case _84: return "Flandreau Santee Sioux Tribe of South Dakota";
            case _85: return "Forest County Potawatomi Community of Wisconsin Po";
            case _86: return "Fort Belknap Indian Community of the Fort Belknap";
            case _87: return "Fort Bidwell Indian Community of the Fort Bidwell";
            case _88: return "Fort Independence Indian Community of Paiute India";
            case _89: return "Fort McDermitt Paiute and Shoshone Tribes of the F";
            case _9: return "Aroostook Band of Micmac Indians of Maine";
            case _90: return "Fort McDowell Yavapai Nation, Arizona (formerly th";
            case _91: return "Fort Mojave Indian Tribe of Arizona, California";
            case _92: return "Fort Sill Apache Tribe of Oklahoma";
            case _93: return "Gila River Indian Community of the Gila River Indi";
            case _94: return "Grand Traverse Band of Ottawa & Chippewa Indians o";
            case _95: return "Graton Rancheria, California";
            case _96: return "Greenville Rancheria of Maidu Indians of Californi";
            case _97: return "Grindstone Indian Rancheria of Wintun-Wailaki Indi";
            case _98: return "Guidiville Rancheria of California";
            case _99: return "Hannahville Indian Community of Wisconsin Potawato";
            default: return "?";
          }
        }
        public String getDisplay() {
          switch (this) {
            case _NATIVEENTITYALASKA: return "NativeEntityAlaska";
            case _338: return "Village of Afognak";
            case _339: return "Agdaagux Tribe of King Cove";
            case _340: return "Native Village of Akhiok";
            case _341: return "Akiachak Native Community";
            case _342: return "Akiak Native Community";
            case _343: return "Native Village of Akutan";
            case _344: return "Village of Alakanuk";
            case _345: return "Alatna Village";
            case _346: return "Native Village of Aleknagik";
            case _347: return "Algaaciq Native Village (St. Mary's)";
            case _348: return "Allakaket Village";
            case _349: return "Native Village of Ambler";
            case _350: return "Village of Anaktuvuk Pass";
            case _351: return "Yupiit of Andreafski";
            case _352: return "Angoon Community Association";
            case _353: return "Village of Aniak";
            case _354: return "Anvik Village";
            case _355: return "Arctic Village (See Native Village of Venetie Trib";
            case _356: return "Asa carsarmiut Tribe (formerly Native Village of M";
            case _357: return "Native Village of Atka";
            case _358: return "Village of Atmautluak";
            case _359: return "Atqasuk Village (Atkasook)";
            case _360: return "Native Village of Barrow Inupiat Traditional Gover";
            case _361: return "Beaver Village";
            case _362: return "Native Village of Belkofski";
            case _363: return "Village of Bill Moore's Slough";
            case _364: return "Birch Creek Tribe";
            case _365: return "Native Village of Brevig Mission";
            case _366: return "Native Village of Buckland";
            case _367: return "Native Village of Cantwell";
            case _368: return "Native Village of Chanega (aka Chenega)";
            case _369: return "Chalkyitsik Village";
            case _370: return "Village of Chefornak";
            case _371: return "Chevak Native Village";
            case _372: return "Chickaloon Native Village";
            case _373: return "Native Village of Chignik";
            case _374: return "Native Village of Chignik Lagoon";
            case _375: return "Chignik Lake Village";
            case _376: return "Chilkat Indian Village (Klukwan)";
            case _377: return "Chilkoot Indian Association (Haines)";
            case _378: return "Chinik Eskimo Community (Golovin)";
            case _379: return "Native Village of Chistochina";
            case _380: return "Native Village of Chitina";
            case _381: return "Native Village of Chuathbaluk (Russian Mission, Ku";
            case _382: return "Chuloonawick Native Village";
            case _383: return "Circle Native Community";
            case _384: return "Village of Clark's Point";
            case _385: return "Native Village of Council";
            case _386: return "Craig Community Association";
            case _387: return "Village of Crooked Creek";
            case _388: return "Curyung Tribal Council (formerly Native Village of";
            case _389: return "Native Village of Deering";
            case _390: return "Native Village of Diomede (aka Inalik)";
            case _391: return "Village of Dot Lake";
            case _392: return "Douglas Indian Association";
            case _393: return "Native Village of Eagle";
            case _394: return "Native Village of Eek";
            case _395: return "Egegik Village";
            case _396: return "Eklutna Native Village";
            case _397: return "Native Village of Ekuk";
            case _398: return "Ekwok Village";
            case _399: return "Native Village of Elim";
            case _400: return "Emmonak Village";
            case _401: return "Evansville Village (aka Bettles Field)";
            case _402: return "Native Village of Eyak (Cordova)";
            case _403: return "Native Village of False Pass";
            case _404: return "Native Village of Fort Yukon";
            case _405: return "Native Village of Gakona";
            case _406: return "Galena Village (aka Louden Village)";
            case _407: return "Native Village of Gambell";
            case _408: return "Native Village of Georgetown";
            case _409: return "Native Village of Goodnews Bay";
            case _410: return "Organized Village of Grayling (aka Holikachuk)";
            case _411: return "Gulkana Village";
            case _412: return "Native Village of Hamilton";
            case _413: return "Healy Lake Village";
            case _414: return "Holy Cross Village";
            case _415: return "Hoonah Indian Association";
            case _416: return "Native Village of Hooper Bay";
            case _417: return "Hughes Village";
            case _418: return "Huslia Village";
            case _419: return "Hydaburg Cooperative Association";
            case _420: return "Igiugig Village";
            case _421: return "Village of Iliamna";
            case _422: return "Inupiat Community of the Arctic Slope";
            case _423: return "Iqurmuit Traditional Council (formerly Native Vill";
            case _424: return "Ivanoff Bay Village";
            case _425: return "Kaguyak Village";
            case _426: return "Organized Village of Kake";
            case _427: return "Kaktovik Village (aka Barter Island)";
            case _428: return "Village of Kalskag";
            case _429: return "Village of Kaltag";
            case _430: return "Native Village of Kanatak";
            case _431: return "Native Village of Karluk";
            case _432: return "Organized Village of Kasaan";
            case _433: return "Native Village of Kasigluk";
            case _434: return "Kenaitze Indian Tribe";
            case _435: return "Ketchikan Indian Corporation";
            case _436: return "Native Village of Kiana";
            case _437: return "King Island Native Community";
            case _438: return "King Salmon Tribe";
            case _439: return "Native Village of Kipnuk";
            case _440: return "Native Village of Kivalina";
            case _441: return "Klawock Cooperative Association";
            case _442: return "Native Village of Kluti Kaah (aka Copper Center)";
            case _443: return "Knik Tribe";
            case _444: return "Native Village of Kobuk";
            case _445: return "Kokhanok Village";
            case _446: return "Native Village of Kongiganak";
            case _447: return "Village of Kotlik";
            case _448: return "Native Village of Kotzebue";
            case _449: return "Native Village of Koyuk";
            case _450: return "Koyukuk Native Village";
            case _451: return "Organized Village of Kwethluk";
            case _452: return "Native Village of Kwigillingok";
            case _453: return "Native Village of Kwinhagak (aka Quinhagak)";
            case _454: return "Native Village of Larsen Bay";
            case _455: return "Levelock Village";
            case _456: return "Lesnoi Village (aka Woody Island)";
            case _457: return "Lime Village";
            case _458: return "Village of Lower Kalskag";
            case _459: return "Manley Hot Springs Village";
            case _460: return "Manokotak Village";
            case _461: return "Native Village of Marshall (aka Fortuna Ledge)";
            case _462: return "Native Village of Mary's Igloo";
            case _463: return "McGrath Native Village";
            case _464: return "Native Village of Mekoryuk";
            case _465: return "Mentasta Traditional Council";
            case _466: return "Metlakatla Indian Community, Annette Island Reserv";
            case _467: return "Native Village of Minto";
            case _468: return "Naknek Native Village";
            case _469: return "Native Village of Nanwalek (aka English Bay)";
            case _470: return "Native Village of Napaimute";
            case _471: return "Native Village of Napakiak";
            case _472: return "Native Village of Napaskiak";
            case _473: return "Native Village of Nelson Lagoon";
            case _474: return "Nenana Native Association";
            case _475: return "New Koliganek Village Council (formerly Koliganek";
            case _476: return "New Stuyahok Village";
            case _477: return "Newhalen Village";
            case _478: return "Newtok Village";
            case _479: return "Native Village of Nightmute";
            case _480: return "Nikolai Village";
            case _481: return "Native Village of Nikolski";
            case _482: return "Ninilchik Village";
            case _483: return "Native Village of Noatak";
            case _484: return "Nome Eskimo Community";
            case _485: return "Nondalton Village";
            case _486: return "Noorvik Native Community";
            case _487: return "Northway Village";
            case _488: return "Native Village of Nuiqsut (aka Nooiksut)";
            case _489: return "Nulato Village";
            case _490: return "Nunakauyarmiut Tribe (formerly Native Village of T";
            case _491: return "Native Village of Nunapitchuk";
            case _492: return "Village of Ohogamiut";
            case _493: return "Village of Old Harbor";
            case _494: return "Orutsararmuit Native Village (aka Bethel)";
            case _495: return "Oscarville Traditional Village";
            case _496: return "Native Village of Ouzinkie";
            case _497: return "Native Village of Paimiut";
            case _498: return "Pauloff Harbor Village";
            case _499: return "Pedro Bay Village";
            case _500: return "Native Village of Perryville";
            case _501: return "Petersburg Indian Association";
            case _502: return "Native Village of Pilot Point";
            case _503: return "Pilot Station Traditional Village";
            case _504: return "Native Village of Pitka's Point";
            case _505: return "Platinum Traditional Village";
            case _506: return "Native Village of Point Hope";
            case _507: return "Native Village of Point Lay";
            case _508: return "Native Village of Port Graham";
            case _509: return "Native Village of Port Heiden";
            case _510: return "Native Village of Port Lions";
            case _511: return "Portage Creek Village (aka Ohgsenakale)";
            case _512: return "Pribilof Islands Aleut Communities of St. Paul & S";
            case _513: return "Qagan Tayagungin Tribe of Sand Point Village";
            case _514: return "Qawalangin Tribe of Unalaska";
            case _515: return "Rampart Village";
            case _516: return "Village of Red Devil";
            case _517: return "Native Village of Ruby";
            case _518: return "Saint George Island(See Pribilof Islands Aleut Com";
            case _519: return "Native Village of Saint Michael";
            case _520: return "Saint Paul Island (See Pribilof Islands Aleut Comm";
            case _521: return "Village of Salamatoff";
            case _522: return "Native Village of Savoonga";
            case _523: return "Organized Village of Saxman";
            case _524: return "Native Village of Scammon Bay";
            case _525: return "Native Village of Selawik";
            case _526: return "Seldovia Village Tribe";
            case _527: return "Shageluk Native Village";
            case _528: return "Native Village of Shaktoolik";
            case _529: return "Native Village of Sheldon's Point";
            case _530: return "Native Village of Shishmaref";
            case _531: return "Shoonaq Tribe of Kodiak";
            case _532: return "Native Village of Shungnak";
            case _533: return "Sitka Tribe of Alaska";
            case _534: return "Skagway Village";
            case _535: return "Village of Sleetmute";
            case _536: return "Village of Solomon";
            case _537: return "South Naknek Village";
            case _538: return "Stebbins Community Association";
            case _539: return "Native Village of Stevens";
            case _540: return "Village of Stony River";
            case _541: return "Takotna Village";
            case _542: return "Native Village of Tanacross";
            case _543: return "Native Village of Tanana";
            case _544: return "Native Village of Tatitlek";
            case _545: return "Native Village of Tazlina";
            case _546: return "Telida Village";
            case _547: return "Native Village of Teller";
            case _548: return "Native Village of Tetlin";
            case _549: return "Central Council of the Tlingit and Haida Indian Tb";
            case _550: return "Traditional Village of Togiak";
            case _551: return "Tuluksak Native Community";
            case _552: return "Native Village of Tuntutuliak";
            case _553: return "Native Village of Tununak";
            case _554: return "Twin Hills Village";
            case _555: return "Native Village of Tyonek";
            case _556: return "Ugashik Village";
            case _557: return "Umkumiute Native Village";
            case _558: return "Native Village of Unalakleet";
            case _559: return "Native Village of Unga";
            case _560: return "Village of Venetie (See Native Village of Venetie";
            case _561: return "Native Village of Venetie Tribal Government (Arcti";
            case _562: return "Village of Wainwright";
            case _563: return "Native Village of Wales";
            case _564: return "Native Village of White Mountain";
            case _565: return "Wrangell Cooperative Association";
            case _566: return "Yakutat Tlingit Tribe";
            case _NATIVEENTITYCONTIGUOUS: return "NativeEntityContiguous";
            case _1: return "Absentee-Shawnee Tribe of Indians of Oklahoma";
            case _10: return "Assiniboine and Sioux Tribes of the Fort Peck Indi";
            case _100: return "Havasupai Tribe of the Havasupai Reservation, Ariz";
            case _101: return "Ho-Chunk Nation of Wisconsin (formerly known as th";
            case _102: return "Hoh Indian Tribe of the Hoh Indian Reservation, Wa";
            case _103: return "Hoopa Valley Tribe, California";
            case _104: return "Hopi Tribe of Arizona";
            case _105: return "Hopland Band of Pomo Indians of the Hopland Ranche";
            case _106: return "Houlton Band of Maliseet Indians of Maine";
            case _107: return "Hualapai Indian Tribe of the Hualapai Indian Reser";
            case _108: return "Huron Potawatomi, Inc., Michigan";
            case _109: return "Inaja Band of Diegueno Mission Indians of the Inaj";
            case _11: return "Augustine Band of Cahuilla Mission Indians of the";
            case _110: return "Ione Band of Miwok Indians of California";
            case _111: return "Iowa Tribe of Kansas and Nebraska";
            case _112: return "Iowa Tribe of Oklahoma";
            case _113: return "Jackson Rancheria of Me-Wuk Indians of California";
            case _114: return "Jamestown S'Klallam Tribe of Washington";
            case _115: return "Jamul Indian Village of California";
            case _116: return "Jena Band of Choctaw Indians, Louisiana";
            case _117: return "Jicarilla Apache Tribe of the Jicarilla Apache Ind";
            case _118: return "Kaibab Band of Paiute Indians of the Kaibab Indian";
            case _119: return "Kalispel Indian Community of the Kalispel Reservat";
            case _12: return "Bad River Band of the Lake Superior Tribe of Chipp";
            case _120: return "Karuk Tribe of California";
            case _121: return "Kashia Band of Pomo Indians of the Stewarts Point";
            case _122: return "Kaw Nation, Oklahoma";
            case _123: return "Keweenaw Bay Indian Community of L'Anse and Ontona";
            case _124: return "Kialegee Tribal Town, Oklahoma";
            case _125: return "Kickapoo Tribe of Indians of the Kickapoo Reservat";
            case _126: return "Kickapoo Tribe of Oklahoma";
            case _127: return "Kickapoo Traditional Tribe of Texas";
            case _128: return "Kiowa Indian Tribe of Oklahoma";
            case _129: return "Klamath Indian Tribe of Oregon";
            case _13: return "Bay Mills Indian Community of the Sault Ste. Marie";
            case _130: return "Kootenai Tribe of Idaho";
            case _131: return "La Jolla Band of Luiseno Mission Indians of the La";
            case _132: return "La Posta Band of Diegueno Mission Indians of the L";
            case _133: return "Lac Courte Oreilles Band of Lake Superior Chippewa";
            case _134: return "Lac du Flambeau Band of Lake Superior Chippewa Ind";
            case _135: return "Lac Vieux Desert Band of Lake Superior Chippewa In";
            case _136: return "Las Vegas Tribe of Paiute Indians of the Las Vegas";
            case _137: return "Little River Band of Ottawa Indians of Michigan";
            case _138: return "Little Traverse Bay Bands of Odawa Indians of Mich";
            case _139: return "Lower Lake Rancheria, California";
            case _14: return "Bear River Band of the Rohnerville Rancheria, Cali";
            case _140: return "Los Coyotes Band of Cahuilla Mission Indians of th";
            case _141: return "Lovelock Paiute Tribe of the Lovelock Indian Colon";
            case _142: return "Lower Brule Sioux Tribe of the Lower Brule Reserva";
            case _143: return "Lower Elwha Tribal Community of the Lower Elwha Re";
            case _144: return "Lower Sioux Indian Community of Minnesota Mdewakan";
            case _145: return "Lummi Tribe of the Lummi Reservation, Washington";
            case _146: return "Lytton Rancheria of California";
            case _147: return "Makah Indian Tribe of the Makah Indian Reservation";
            case _148: return "Manchester Band of Pomo Indians of the Manchester-";
            case _149: return "Manzanita Band of Diegueno Mission Indians of the";
            case _15: return "Berry Creek Rancheria of Maidu Indians of Californ";
            case _150: return "Mashantucket Pequot Tribe of Connecticut";
            case _151: return "Match-e-be-nash-she-wish Band of Pottawatomi India";
            case _152: return "Mechoopda Indian Tribe of Chico Rancheria, Califor";
            case _153: return "Menominee Indian Tribe of Wisconsin";
            case _154: return "Mesa Grande Band of Diegueno Mission Indians of th";
            case _155: return "Mescalero Apache Tribe of the Mescalero Reservatio";
            case _156: return "Miami Tribe of Oklahoma";
            case _157: return "Miccosukee Tribe of Indians of Florida";
            case _158: return "Middletown Rancheria of Pomo Indians of California";
            case _159: return "Minnesota Chippewa Tribe, Minnesota (Six component";
            case _16: return "Big Lagoon Rancheria, California";
            case _160: return "Bois Forte Band (Nett Lake); Fond du Lac Band; Gra";
            case _161: return "Mississippi Band of Choctaw Indians, Mississippi";
            case _162: return "Moapa Band of Paiute Indians of the Moapa River In";
            case _163: return "Modoc Tribe of Oklahoma";
            case _164: return "Mohegan Indian Tribe of Connecticut";
            case _165: return "Mooretown Rancheria of Maidu Indians of California";
            case _166: return "Morongo Band of Cahuilla Mission Indians of the Mo";
            case _167: return "Muckleshoot Indian Tribe of the Muckleshoot Reserv";
            case _168: return "Muscogee (Creek) Nation, Oklahoma";
            case _169: return "Narragansett Indian Tribe of Rhode Island";
            case _17: return "Big Pine Band of Owens Valley Paiute Shoshone Indi";
            case _170: return "Navajo Nation, Arizona, New Mexico & Utah";
            case _171: return "Nez Perce Tribe of Idaho";
            case _172: return "Nisqually Indian Tribe of the Nisqually Reservatio";
            case _173: return "Nooksack Indian Tribe of Washington";
            case _174: return "Northern Cheyenne Tribe of the Northern Cheyenne I";
            case _175: return "Northfork Rancheria of Mono Indians of California";
            case _176: return "Northwestern Band of Shoshoni Nation of Utah (Wash";
            case _177: return "Oglala Sioux Tribe of the Pine Ridge Reservation,";
            case _178: return "Omaha Tribe of Nebraska";
            case _179: return "Oneida Nation of New York";
            case _18: return "Big Sandy Rancheria of Mono Indians of California";
            case _180: return "Oneida Tribe of Wisconsin";
            case _181: return "Onondaga Nation of New York";
            case _182: return "Osage Tribe, Oklahoma";
            case _183: return "Ottawa Tribe of Oklahoma";
            case _184: return "Otoe-Missouria Tribe of Indians, Oklahoma";
            case _185: return "Paiute Indian Tribe of Utah";
            case _186: return "Paiute-Shoshone Indians of the Bishop Community of";
            case _187: return "Paiute-Shoshone Tribe of the Fallon Reservation an";
            case _188: return "Paiute-Shoshone Indians of the Lone Pine Community";
            case _189: return "Pala Band of Luiseno Mission Indians of the Pala R";
            case _19: return "Big Valley Band of Pomo Indians of the Big Valley";
            case _190: return "Pascua Yaqui Tribe of Arizona";
            case _191: return "Paskenta Band of Nomlaki Indians of California";
            case _192: return "Passamaquoddy Tribe of Maine";
            case _193: return "Pauma Band of Luiseno Mission Indians of the Pauma";
            case _194: return "Pawnee Nation of Oklahoma";
            case _195: return "Pechanga Band of Luiseno Mission Indians of the Pe";
            case _196: return "Penobscot Tribe of Maine";
            case _197: return "Peoria Tribe of Indians of Oklahoma";
            case _198: return "Picayune Rancheria of Chukchansi Indians of Califo";
            case _199: return "Pinoleville Rancheria of Pomo Indians of Californi";
            case _2: return "Agua Caliente Band of Cahuilla Indians of the Agua";
            case _20: return "Blackfeet Tribe of the Blackfeet Indian Reservatio";
            case _200: return "Pit River Tribe, California (includes Big Bend, Lo";
            case _201: return "Poarch Band of Creek Indians of Alabama";
            case _202: return "Pokagon Band of Potawatomi Indians of Michigan";
            case _203: return "Ponca Tribe of Indians of Oklahoma";
            case _204: return "Ponca Tribe of Nebraska";
            case _205: return "Port Gamble Indian Community of the Port Gamble Re";
            case _206: return "Potter Valley Rancheria of Pomo Indians of Califor";
            case _207: return "Prairie Band of Potawatomi Indians, Kansas";
            case _208: return "Prairie Island Indian Community of Minnesota Mdewa";
            case _209: return "Pueblo of Acoma, New Mexico";
            case _21: return "Blue Lake Rancheria, California";
            case _210: return "Pueblo of Cochiti, New Mexico";
            case _211: return "Pueblo of Jemez, New Mexico";
            case _212: return "Pueblo of Isleta, New Mexico";
            case _213: return "Pueblo of Laguna, New Mexico";
            case _214: return "Pueblo of Nambe, New Mexico";
            case _215: return "Pueblo of Picuris, New Mexico";
            case _216: return "Pueblo of Pojoaque, New Mexico";
            case _217: return "Pueblo of San Felipe, New Mexico";
            case _218: return "Pueblo of San Juan, New Mexico";
            case _219: return "Pueblo of San Ildefonso, New Mexico";
            case _22: return "Bridgeport Paiute Indian Colony of California";
            case _220: return "Pueblo of Sandia, New Mexico";
            case _221: return "Pueblo of Santa Ana, New Mexico";
            case _222: return "Pueblo of Santa Clara, New Mexico";
            case _223: return "Pueblo of Santo Domingo, New Mexico";
            case _224: return "Pueblo of Taos, New Mexico";
            case _225: return "Pueblo of Tesuque, New Mexico";
            case _226: return "Pueblo of Zia, New Mexico";
            case _227: return "Puyallup Tribe of the Puyallup Reservation, Washin";
            case _228: return "Pyramid Lake Paiute Tribe of the Pyramid Lake Rese";
            case _229: return "Quapaw Tribe of Indians, Oklahoma";
            case _23: return "Buena Vista Rancheria of Me-Wuk Indians of Califor";
            case _230: return "Quartz Valley Indian Community of the Quartz Valle";
            case _231: return "Quechan Tribe of the Fort Yuma Indian Reservation,";
            case _232: return "Quileute Tribe of the Quileute Reservation, Washin";
            case _233: return "Quinault Tribe of the Quinault Reservation, Washin";
            case _234: return "Ramona Band or Village of Cahuilla Mission Indians";
            case _235: return "Red Cliff Band of Lake Superior Chippewa Indians o";
            case _236: return "Red Lake Band of Chippewa Indians of the Red Lake";
            case _237: return "Redding Rancheria, California";
            case _238: return "Redwood Valley Rancheria of Pomo Indians of Califo";
            case _239: return "Reno-Sparks Indian Colony, Nevada";
            case _24: return "Burns Paiute Tribe of the Burns Paiute Indian Colo";
            case _240: return "Resighini Rancheria, California (formerly known as";
            case _241: return "Rincon Band of Luiseno Mission Indians of the Rinc";
            case _242: return "Robinson Rancheria of Pomo Indians of California";
            case _243: return "Rosebud Sioux Tribe of the Rosebud Indian Reservat";
            case _244: return "Round Valley Indian Tribes of the Round Valley Res";
            case _245: return "Rumsey Indian Rancheria of Wintun Indians of Calif";
            case _246: return "Sac and Fox Tribe of the Mississippi in Iowa";
            case _247: return "Sac and Fox Nation of Missouri in Kansas and Nebra";
            case _248: return "Sac and Fox Nation, Oklahoma";
            case _249: return "Saginaw Chippewa Indian Tribe of Michigan, Isabell";
            case _25: return "Cabazon Band of Cahuilla Mission Indians of the Ca";
            case _250: return "Salt River Pima-Maricopa Indian Community of the S";
            case _251: return "Samish Indian Tribe, Washington";
            case _252: return "San Carlos Apache Tribe of the San Carlos Reservat";
            case _253: return "San Juan Southern Paiute Tribe of Arizona";
            case _254: return "San Manual Band of Serrano Mission Indians of the";
            case _255: return "San Pasqual Band of Diegueno Mission Indians of Ca";
            case _256: return "Santa Rosa Indian Community of the Santa Rosa Ranc";
            case _257: return "Santa Rosa Band of Cahuilla Mission Indians of the";
            case _258: return "Santa Ynez Band of Chumash Mission Indians of the";
            case _259: return "Santa Ysabel Band of Diegueno Mission Indians of t";
            case _26: return "Cachil DeHe Band of Wintun Indians of the Colusa I";
            case _260: return "Santee Sioux Tribe of the Santee Reservation of Ne";
            case _261: return "Sauk-Suiattle Indian Tribe of Washington";
            case _262: return "Sault Ste. Marie Tribe of Chippewa Indians of Mich";
            case _263: return "Scotts Valley Band of Pomo Indians of California";
            case _264: return "Seminole Nation of Oklahoma";
            case _265: return "Seminole Tribe of Florida, Dania, Big Cypress, Bri";
            case _266: return "Seneca Nation of New York";
            case _267: return "Seneca-Cayuga Tribe of Oklahoma";
            case _268: return "Shakopee Mdewakanton Sioux Community of Minnesota";
            case _269: return "Shawnee Tribe, Oklahoma";
            case _27: return "Caddo Indian Tribe of Oklahoma";
            case _270: return "Sherwood Valley Rancheria of Pomo Indians of Calif";
            case _271: return "Shingle Springs Band of Miwok Indians, Shingle Spr";
            case _272: return "Shoalwater Bay Tribe of the Shoalwater Bay Indian";
            case _273: return "Shoshone Tribe of the Wind River Reservation, Wyom";
            case _274: return "Shoshone-Bannock Tribes of the Fort Hall Reservati";
            case _275: return "Shoshone-Paiute Tribes of the Duck Valley Reservat";
            case _276: return "Sisseton-Wahpeton Sioux Tribe of the Lake Traverse";
            case _277: return "Skokomish Indian Tribe of the Skokomish Reservatio";
            case _278: return "Skull Valley Band of Goshute Indians of Utah";
            case _279: return "Smith River Rancheria, California";
            case _28: return "Cahuilla Band of Mission Indians of the Cahuilla R";
            case _280: return "Snoqualmie Tribe, Washington";
            case _281: return "Soboba Band of Luiseno Indians, California (former";
            case _282: return "Sokaogon Chippewa Community of the Mole Lake Band";
            case _283: return "Southern Ute Indian Tribe of the Southern Ute Rese";
            case _284: return "Spirit Lake Tribe, North Dakota (formerly known as";
            case _285: return "Spokane Tribe of the Spokane Reservation, Washingt";
            case _286: return "Squaxin Island Tribe of the Squaxin Island Reserva";
            case _287: return "St. Croix Chippewa Indians of Wisconsin, St. Croix";
            case _288: return "St. Regis Band of Mohawk Indians of New York";
            case _289: return "Standing Rock Sioux Tribe of North & South Dakota";
            case _29: return "Cahto Indian Tribe of the Laytonville Rancheria, C";
            case _290: return "Stockbridge-Munsee Community of Mohican Indians of";
            case _291: return "Stillaguamish Tribe of Washington";
            case _292: return "Summit Lake Paiute Tribe of Nevada";
            case _293: return "Suquamish Indian Tribe of the Port Madison Reserva";
            case _294: return "Susanville Indian Rancheria, California";
            case _295: return "Swinomish Indians of the Swinomish Reservation, Wa";
            case _296: return "Sycuan Band of Diegueno Mission Indians of Califor";
            case _297: return "Table Bluff Reservation - Wiyot Tribe, California";
            case _298: return "Table Mountain Rancheria of California";
            case _299: return "Te-Moak Tribe of Western Shoshone Indians of Nevad";
            case _3: return "Ak Chin Indian Community of the Maricopa (Ak Chin)";
            case _30: return "California Valley Miwok Tribe, California (formerl";
            case _300: return "Thlopthlocco Tribal Town, Oklahoma";
            case _301: return "Three Affiliated Tribes of the Fort Berthold Reser";
            case _302: return "Tohono O'odham Nation of Arizona";
            case _303: return "Tonawanda Band of Seneca Indians of New York";
            case _304: return "Tonkawa Tribe of Indians of Oklahoma";
            case _305: return "Tonto Apache Tribe of Arizona";
            case _306: return "Torres-Martinez Band of Cahuilla Mission Indians o";
            case _307: return "Tule River Indian Tribe of the Tule River Reservat";
            case _308: return "Tulalip Tribes of the Tulalip Reservation, Washing";
            case _309: return "Tunica-Biloxi Indian Tribe of Louisiana";
            case _31: return "Campo Band of Diegueno Mission Indians of the Camp";
            case _310: return "Tuolumne Band of Me-Wuk Indians of the Tuolumne Ra";
            case _311: return "Turtle Mountain Band of Chippewa Indians of North";
            case _312: return "Tuscarora Nation of New York";
            case _313: return "Twenty-Nine Palms Band of Mission Indians of Calif";
            case _314: return "United Auburn Indian Community of the Auburn Ranch";
            case _315: return "United Keetoowah Band of Cherokee Indians of Oklah";
            case _316: return "Upper Lake Band of Pomo Indians of Upper Lake Ranc";
            case _317: return "Upper Sioux Indian Community of the Upper Sioux Re";
            case _318: return "Upper Skagit Indian Tribe of Washington";
            case _319: return "Ute Indian Tribe of the Uintah & Ouray Reservation";
            case _32: return "Capitan Grande Band of Diegueno Mission Indians of";
            case _320: return "Ute Mountain Tribe of the Ute Mountain Reservation";
            case _321: return "Utu Utu Gwaitu Paiute Tribe of the Benton Paiute R";
            case _322: return "Walker River Paiute Tribe of the Walker River Rese";
            case _323: return "Wampanoag Tribe of Gay Head (Aquinnah) of Massachu";
            case _324: return "Washoe Tribe of Nevada & California (Carson Colony";
            case _325: return "White Mountain Apache Tribe of the Fort Apache Res";
            case _326: return "Wichita and Affiliated Tribes (Wichita, Keechi, Wa";
            case _327: return "Winnebago Tribe of Nebraska";
            case _328: return "Winnemucca Indian Colony of Nevada";
            case _329: return "Wyandotte Tribe of Oklahoma";
            case _33: return "Barona Group of Capitan Grande Band of Mission Ind";
            case _330: return "Yankton Sioux Tribe of South Dakota";
            case _331: return "Yavapai-Apache Nation of the Camp Verde Indian Res";
            case _332: return "Yavapai-Prescott Tribe of the Yavapai Reservation,";
            case _333: return "Yerington Paiute Tribe of the Yerington Colony & C";
            case _334: return "Yomba Shoshone Tribe of the Yomba Reservation, Nev";
            case _335: return "Ysleta Del Sur Pueblo of Texas";
            case _336: return "Yurok Tribe of the Yurok Reservation, California";
            case _337: return "Zuni Tribe of the Zuni Reservation, New Mexico";
            case _34: return "Viejas (Baron Long) Group of Capitan Grande Band o";
            case _35: return "Catawba Indian Nation (aka Catawba Tribe of South";
            case _36: return "Cayuga Nation of New York";
            case _37: return "Cedarville Rancheria, California";
            case _38: return "Chemehuevi Indian Tribe of the Chemehuevi Reservat";
            case _39: return "Cher-Ae Heights Indian Community of the Trinidad R";
            case _4: return "Alabama-Coushatta Tribes of Texas";
            case _40: return "Cherokee Nation, Oklahoma";
            case _41: return "Cheyenne-Arapaho Tribes of Oklahoma";
            case _42: return "Cheyenne River Sioux Tribe of the Cheyenne River R";
            case _43: return "Chickasaw Nation, Oklahoma";
            case _44: return "Chicken Ranch Rancheria of Me-Wuk Indians of Calif";
            case _45: return "Chippewa-Cree Indians of the Rocky Boy's Reservati";
            case _46: return "Chitimacha Tribe of Louisiana";
            case _47: return "Choctaw Nation of Oklahoma";
            case _48: return "Citizen Potawatomi Nation, Oklahoma";
            case _49: return "Cloverdale Rancheria of Pomo Indians of California";
            case _5: return "Alabama-Quassarte Tribal Town, Oklahoma";
            case _50: return "Cocopah Tribe of Arizona";
            case _51: return "Coeur D'Alene Tribe of the Coeur D'Alene Reservati";
            case _52: return "Cold Springs Rancheria of Mono Indians of Californ";
            case _53: return "Colorado River Indian Tribes of the Colorado River";
            case _54: return "Comanche Indian Tribe, Oklahoma";
            case _55: return "Confederated Salish & Kootenai Tribes of the Flath";
            case _56: return "Confederated Tribes of the Chehalis Reservation, W";
            case _57: return "Confederated Tribes of the Colville Reservation, W";
            case _58: return "Confederated Tribes of the Coos, Lower Umpqua and";
            case _59: return "Confederated Tribes of the Goshute Reservation, Ne";
            case _6: return "Alturas Indian Rancheria, California";
            case _60: return "Confederated Tribes of the Grand Ronde Community o";
            case _61: return "Confederated Tribes of the Siletz Reservation, Ore";
            case _62: return "Confederated Tribes of the Umatilla Reservation, O";
            case _63: return "Confederated Tribes of the Warm Springs Reservatio";
            case _64: return "Confederated Tribes and Bands of the Yakama Indian";
            case _65: return "Coquille Tribe of Oregon";
            case _66: return "Cortina Indian Rancheria of Wintun Indians of Cali";
            case _67: return "Coushatta Tribe of Louisiana";
            case _68: return "Cow Creek Band of Umpqua Indians of Oregon";
            case _69: return "Coyote Valley Band of Pomo Indians of California";
            case _7: return "Apache Tribe of Oklahoma";
            case _70: return "Crow Tribe of Montana";
            case _71: return "Crow Creek Sioux Tribe of the Crow Creek Reservati";
            case _72: return "Cuyapaipe Community of Diegueno Mission Indians of";
            case _73: return "Death Valley Timbi-Sha Shoshone Band of California";
            case _74: return "Delaware Nation, Oklahoma (formerly Delaware Tribe";
            case _75: return "Delaware Tribe of Indians, Oklahoma";
            case _76: return "Dry Creek Rancheria of Pomo Indians of California";
            case _77: return "Duckwater Shoshone Tribe of the Duckwater Reservat";
            case _78: return "Eastern Band of Cherokee Indians of North Carolina";
            case _79: return "Eastern Shawnee Tribe of Oklahoma";
            case _8: return "Arapahoe Tribe of the Wind River Reservation, Wyom";
            case _80: return "Elem Indian Colony of Pomo Indians of the Sulphur";
            case _81: return "Elk Valley Rancheria, California";
            case _82: return "Ely Shoshone Tribe of Nevada";
            case _83: return "Enterprise Rancheria of Maidu Indians of Californi";
            case _84: return "Flandreau Santee Sioux Tribe of South Dakota";
            case _85: return "Forest County Potawatomi Community of Wisconsin Po";
            case _86: return "Fort Belknap Indian Community of the Fort Belknap";
            case _87: return "Fort Bidwell Indian Community of the Fort Bidwell";
            case _88: return "Fort Independence Indian Community of Paiute India";
            case _89: return "Fort McDermitt Paiute and Shoshone Tribes of the F";
            case _9: return "Aroostook Band of Micmac Indians of Maine";
            case _90: return "Fort McDowell Yavapai Nation, Arizona (formerly th";
            case _91: return "Fort Mojave Indian Tribe of Arizona, California";
            case _92: return "Fort Sill Apache Tribe of Oklahoma";
            case _93: return "Gila River Indian Community of the Gila River Indi";
            case _94: return "Grand Traverse Band of Ottawa & Chippewa Indians o";
            case _95: return "Graton Rancheria, California";
            case _96: return "Greenville Rancheria of Maidu Indians of Californi";
            case _97: return "Grindstone Indian Rancheria of Wintun-Wailaki Indi";
            case _98: return "Guidiville Rancheria of California";
            case _99: return "Hannahville Indian Community of Wisconsin Potawato";
            default: return "?";
          }
    }


}

