/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.ObservationDefinition;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.SpecimenDefinition;

@ResourceDef(name="EntryDefinition", profile="http://hl7.org/fhir/Profile/EntryDefinition")
public class EntryDefinition
extends DomainResource {
    @Child(name="type", type={CodeableConcept.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The type of item - medication, device, service, protocol or other", formalDefinition="The type of item - medication, device, service, protocol or other.")
    protected CodeableConcept type;
    @Child(name="purpose", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether the entry represents an orderable item, or other", formalDefinition="Whether the entry represents an orderable item, or other.")
    protected CodeableConcept purpose;
    @Child(name="referencedItem", type={Medication.class, Device.class, Organization.class, Practitioner.class, HealthcareService.class, ActivityDefinition.class, PlanDefinition.class, SpecimenDefinition.class, ObservationDefinition.class, Binary.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The item itself", formalDefinition="Content of the catalog.")
    protected Reference referencedItem;
    protected Resource referencedItemTarget;
    @Child(name="identifier", type={Identifier.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier of the catalog item", formalDefinition="Used in supporting different identifiers for the same product, e.g. manufacturer code and retailer code.")
    protected Identifier identifier;
    @Child(name="additionalIdentifier", type={Identifier.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Any additional identifier(s) for the catalog item, in the same granularity or concept", formalDefinition="Used in supporting related concepts, e.g. NDC to RxNorm.")
    protected List<Identifier> additionalIdentifier;
    @Child(name="classification", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Classification (category or class) of the item entry", formalDefinition="Classes of devices, or ATC for medication.")
    protected List<CodeableConcept> classification;
    @Child(name="status", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The status of the item, e.g. active, approved, deleted\u2026", formalDefinition="Used to support catalog exchange even for unsupported products, e.g. getting list of medications even if not prescribable.")
    protected CodeableConcept status;
    @Child(name="validityPeriod", type={Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The time period in which this catalog entry is expected to be active", formalDefinition="The time period in which this catalog entry is expected to be active.")
    protected Period validityPeriod;
    @Child(name="lastUpdated", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When was this catalog last updated", formalDefinition="Typically date of issue is different from the beginning of the validity. This can be used to see when an item was last updated.")
    protected DateTimeType lastUpdated;
    @Child(name="additionalCharacteristic", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional characteristics of the catalog entry", formalDefinition="Used for examplefor Out of Formulary, or any specifics.")
    protected List<CodeableConcept> additionalCharacteristic;
    @Child(name="additionalClassification", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional classification of the catalog entry", formalDefinition="User for example for ATC classification, or.")
    protected List<CodeableConcept> additionalClassification;
    @Child(name="relatedEntry", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="An item that this catalog entry is related to", formalDefinition="Used for example, to point to a substance, or to a device used to administer a medication.")
    protected List<EntryDefinitionRelatedEntryComponent> relatedEntry;
    private static final long serialVersionUID = 1643677246L;

    public EntryDefinition() {
    }

    public EntryDefinition(CodeableConcept purpose, Reference referencedItem) {
        this.purpose = purpose;
        this.referencedItem = referencedItem;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EntryDefinition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public EntryDefinition setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public CodeableConcept getPurpose() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EntryDefinition.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new CodeableConcept();
            }
        }
        return this.purpose;
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public EntryDefinition setPurpose(CodeableConcept value) {
        this.purpose = value;
        return this;
    }

    public Reference getReferencedItem() {
        if (this.referencedItem == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EntryDefinition.referencedItem");
            }
            if (Configuration.doAutoCreate()) {
                this.referencedItem = new Reference();
            }
        }
        return this.referencedItem;
    }

    public boolean hasReferencedItem() {
        return this.referencedItem != null && !this.referencedItem.isEmpty();
    }

    public EntryDefinition setReferencedItem(Reference value) {
        this.referencedItem = value;
        return this;
    }

    public Resource getReferencedItemTarget() {
        return this.referencedItemTarget;
    }

    public EntryDefinition setReferencedItemTarget(Resource value) {
        this.referencedItemTarget = value;
        return this;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EntryDefinition.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public EntryDefinition setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public List<Identifier> getAdditionalIdentifier() {
        if (this.additionalIdentifier == null) {
            this.additionalIdentifier = new ArrayList<Identifier>();
        }
        return this.additionalIdentifier;
    }

    public EntryDefinition setAdditionalIdentifier(List<Identifier> theAdditionalIdentifier) {
        this.additionalIdentifier = theAdditionalIdentifier;
        return this;
    }

    public boolean hasAdditionalIdentifier() {
        if (this.additionalIdentifier == null) {
            return false;
        }
        for (Identifier item : this.additionalIdentifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addAdditionalIdentifier() {
        Identifier t = new Identifier();
        if (this.additionalIdentifier == null) {
            this.additionalIdentifier = new ArrayList<Identifier>();
        }
        this.additionalIdentifier.add(t);
        return t;
    }

    public EntryDefinition addAdditionalIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.additionalIdentifier == null) {
            this.additionalIdentifier = new ArrayList<Identifier>();
        }
        this.additionalIdentifier.add(t);
        return this;
    }

    public Identifier getAdditionalIdentifierFirstRep() {
        if (this.getAdditionalIdentifier().isEmpty()) {
            this.addAdditionalIdentifier();
        }
        return this.getAdditionalIdentifier().get(0);
    }

    public List<CodeableConcept> getClassification() {
        if (this.classification == null) {
            this.classification = new ArrayList<CodeableConcept>();
        }
        return this.classification;
    }

    public EntryDefinition setClassification(List<CodeableConcept> theClassification) {
        this.classification = theClassification;
        return this;
    }

    public boolean hasClassification() {
        if (this.classification == null) {
            return false;
        }
        for (CodeableConcept item : this.classification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addClassification() {
        CodeableConcept t = new CodeableConcept();
        if (this.classification == null) {
            this.classification = new ArrayList<CodeableConcept>();
        }
        this.classification.add(t);
        return t;
    }

    public EntryDefinition addClassification(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.classification == null) {
            this.classification = new ArrayList<CodeableConcept>();
        }
        this.classification.add(t);
        return this;
    }

    public CodeableConcept getClassificationFirstRep() {
        if (this.getClassification().isEmpty()) {
            this.addClassification();
        }
        return this.getClassification().get(0);
    }

    public CodeableConcept getStatus() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EntryDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new CodeableConcept();
            }
        }
        return this.status;
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public EntryDefinition setStatus(CodeableConcept value) {
        this.status = value;
        return this;
    }

    public Period getValidityPeriod() {
        if (this.validityPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EntryDefinition.validityPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.validityPeriod = new Period();
            }
        }
        return this.validityPeriod;
    }

    public boolean hasValidityPeriod() {
        return this.validityPeriod != null && !this.validityPeriod.isEmpty();
    }

    public EntryDefinition setValidityPeriod(Period value) {
        this.validityPeriod = value;
        return this;
    }

    public DateTimeType getLastUpdatedElement() {
        if (this.lastUpdated == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EntryDefinition.lastUpdated");
            }
            if (Configuration.doAutoCreate()) {
                this.lastUpdated = new DateTimeType();
            }
        }
        return this.lastUpdated;
    }

    public boolean hasLastUpdatedElement() {
        return this.lastUpdated != null && !this.lastUpdated.isEmpty();
    }

    public boolean hasLastUpdated() {
        return this.lastUpdated != null && !this.lastUpdated.isEmpty();
    }

    public EntryDefinition setLastUpdatedElement(DateTimeType value) {
        this.lastUpdated = value;
        return this;
    }

    public Date getLastUpdated() {
        return this.lastUpdated == null ? null : (Date)this.lastUpdated.getValue();
    }

    public EntryDefinition setLastUpdated(Date value) {
        if (value == null) {
            this.lastUpdated = null;
        } else {
            if (this.lastUpdated == null) {
                this.lastUpdated = new DateTimeType();
            }
            this.lastUpdated.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getAdditionalCharacteristic() {
        if (this.additionalCharacteristic == null) {
            this.additionalCharacteristic = new ArrayList<CodeableConcept>();
        }
        return this.additionalCharacteristic;
    }

    public EntryDefinition setAdditionalCharacteristic(List<CodeableConcept> theAdditionalCharacteristic) {
        this.additionalCharacteristic = theAdditionalCharacteristic;
        return this;
    }

    public boolean hasAdditionalCharacteristic() {
        if (this.additionalCharacteristic == null) {
            return false;
        }
        for (CodeableConcept item : this.additionalCharacteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addAdditionalCharacteristic() {
        CodeableConcept t = new CodeableConcept();
        if (this.additionalCharacteristic == null) {
            this.additionalCharacteristic = new ArrayList<CodeableConcept>();
        }
        this.additionalCharacteristic.add(t);
        return t;
    }

    public EntryDefinition addAdditionalCharacteristic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.additionalCharacteristic == null) {
            this.additionalCharacteristic = new ArrayList<CodeableConcept>();
        }
        this.additionalCharacteristic.add(t);
        return this;
    }

    public CodeableConcept getAdditionalCharacteristicFirstRep() {
        if (this.getAdditionalCharacteristic().isEmpty()) {
            this.addAdditionalCharacteristic();
        }
        return this.getAdditionalCharacteristic().get(0);
    }

    public List<CodeableConcept> getAdditionalClassification() {
        if (this.additionalClassification == null) {
            this.additionalClassification = new ArrayList<CodeableConcept>();
        }
        return this.additionalClassification;
    }

    public EntryDefinition setAdditionalClassification(List<CodeableConcept> theAdditionalClassification) {
        this.additionalClassification = theAdditionalClassification;
        return this;
    }

    public boolean hasAdditionalClassification() {
        if (this.additionalClassification == null) {
            return false;
        }
        for (CodeableConcept item : this.additionalClassification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addAdditionalClassification() {
        CodeableConcept t = new CodeableConcept();
        if (this.additionalClassification == null) {
            this.additionalClassification = new ArrayList<CodeableConcept>();
        }
        this.additionalClassification.add(t);
        return t;
    }

    public EntryDefinition addAdditionalClassification(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.additionalClassification == null) {
            this.additionalClassification = new ArrayList<CodeableConcept>();
        }
        this.additionalClassification.add(t);
        return this;
    }

    public CodeableConcept getAdditionalClassificationFirstRep() {
        if (this.getAdditionalClassification().isEmpty()) {
            this.addAdditionalClassification();
        }
        return this.getAdditionalClassification().get(0);
    }

    public List<EntryDefinitionRelatedEntryComponent> getRelatedEntry() {
        if (this.relatedEntry == null) {
            this.relatedEntry = new ArrayList<EntryDefinitionRelatedEntryComponent>();
        }
        return this.relatedEntry;
    }

    public EntryDefinition setRelatedEntry(List<EntryDefinitionRelatedEntryComponent> theRelatedEntry) {
        this.relatedEntry = theRelatedEntry;
        return this;
    }

    public boolean hasRelatedEntry() {
        if (this.relatedEntry == null) {
            return false;
        }
        for (EntryDefinitionRelatedEntryComponent item : this.relatedEntry) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EntryDefinitionRelatedEntryComponent addRelatedEntry() {
        EntryDefinitionRelatedEntryComponent t = new EntryDefinitionRelatedEntryComponent();
        if (this.relatedEntry == null) {
            this.relatedEntry = new ArrayList<EntryDefinitionRelatedEntryComponent>();
        }
        this.relatedEntry.add(t);
        return t;
    }

    public EntryDefinition addRelatedEntry(EntryDefinitionRelatedEntryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.relatedEntry == null) {
            this.relatedEntry = new ArrayList<EntryDefinitionRelatedEntryComponent>();
        }
        this.relatedEntry.add(t);
        return this;
    }

    public EntryDefinitionRelatedEntryComponent getRelatedEntryFirstRep() {
        if (this.getRelatedEntry().isEmpty()) {
            this.addRelatedEntry();
        }
        return this.getRelatedEntry().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("type", "CodeableConcept", "The type of item - medication, device, service, protocol or other.", 0, 1, this.type));
        children.add(new Property("purpose", "CodeableConcept", "Whether the entry represents an orderable item, or other.", 0, 1, this.purpose));
        children.add(new Property("referencedItem", "Reference(Medication|Device|Organization|Practitioner|HealthcareService|ActivityDefinition|PlanDefinition|SpecimenDefinition|ObservationDefinition|Binary)", "Content of the catalog.", 0, 1, this.referencedItem));
        children.add(new Property("identifier", "Identifier", "Used in supporting different identifiers for the same product, e.g. manufacturer code and retailer code.", 0, 1, this.identifier));
        children.add(new Property("additionalIdentifier", "Identifier", "Used in supporting related concepts, e.g. NDC to RxNorm.", 0, Integer.MAX_VALUE, this.additionalIdentifier));
        children.add(new Property("classification", "CodeableConcept", "Classes of devices, or ATC for medication.", 0, Integer.MAX_VALUE, this.classification));
        children.add(new Property("status", "CodeableConcept", "Used to support catalog exchange even for unsupported products, e.g. getting list of medications even if not prescribable.", 0, 1, this.status));
        children.add(new Property("validityPeriod", "Period", "The time period in which this catalog entry is expected to be active.", 0, 1, this.validityPeriod));
        children.add(new Property("lastUpdated", "dateTime", "Typically date of issue is different from the beginning of the validity. This can be used to see when an item was last updated.", 0, 1, this.lastUpdated));
        children.add(new Property("additionalCharacteristic", "CodeableConcept", "Used for examplefor Out of Formulary, or any specifics.", 0, Integer.MAX_VALUE, this.additionalCharacteristic));
        children.add(new Property("additionalClassification", "CodeableConcept", "User for example for ATC classification, or.", 0, Integer.MAX_VALUE, this.additionalClassification));
        children.add(new Property("relatedEntry", "", "Used for example, to point to a substance, or to a device used to administer a medication.", 0, Integer.MAX_VALUE, this.relatedEntry));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3575610: {
                return new Property("type", "CodeableConcept", "The type of item - medication, device, service, protocol or other.", 0, 1, this.type);
            }
            case -220463842: {
                return new Property("purpose", "CodeableConcept", "Whether the entry represents an orderable item, or other.", 0, 1, this.purpose);
            }
            case -1896630996: {
                return new Property("referencedItem", "Reference(Medication|Device|Organization|Practitioner|HealthcareService|ActivityDefinition|PlanDefinition|SpecimenDefinition|ObservationDefinition|Binary)", "Content of the catalog.", 0, 1, this.referencedItem);
            }
            case -1618432855: {
                return new Property("identifier", "Identifier", "Used in supporting different identifiers for the same product, e.g. manufacturer code and retailer code.", 0, 1, this.identifier);
            }
            case 1195162672: {
                return new Property("additionalIdentifier", "Identifier", "Used in supporting related concepts, e.g. NDC to RxNorm.", 0, Integer.MAX_VALUE, this.additionalIdentifier);
            }
            case 382350310: {
                return new Property("classification", "CodeableConcept", "Classes of devices, or ATC for medication.", 0, Integer.MAX_VALUE, this.classification);
            }
            case -892481550: {
                return new Property("status", "CodeableConcept", "Used to support catalog exchange even for unsupported products, e.g. getting list of medications even if not prescribable.", 0, 1, this.status);
            }
            case -1434195053: {
                return new Property("validityPeriod", "Period", "The time period in which this catalog entry is expected to be active.", 0, 1, this.validityPeriod);
            }
            case 1649733957: {
                return new Property("lastUpdated", "dateTime", "Typically date of issue is different from the beginning of the validity. This can be used to see when an item was last updated.", 0, 1, this.lastUpdated);
            }
            case -1638369886: {
                return new Property("additionalCharacteristic", "CodeableConcept", "Used for examplefor Out of Formulary, or any specifics.", 0, Integer.MAX_VALUE, this.additionalCharacteristic);
            }
            case -1622333459: {
                return new Property("additionalClassification", "CodeableConcept", "User for example for ATC classification, or.", 0, Integer.MAX_VALUE, this.additionalClassification);
            }
            case 130178823: {
                return new Property("relatedEntry", "", "Used for example, to point to a substance, or to a device used to administer a medication.", 0, Integer.MAX_VALUE, this.relatedEntry);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.purpose;
                }
                return baseArray;
            }
            case -1896630996: {
                Base[] baseArray;
                if (this.referencedItem == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.referencedItem;
                }
                return baseArray;
            }
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.identifier;
                }
                return baseArray;
            }
            case 1195162672: {
                return this.additionalIdentifier == null ? new Base[]{} : this.additionalIdentifier.toArray(new Base[this.additionalIdentifier.size()]);
            }
            case 382350310: {
                return this.classification == null ? new Base[]{} : this.classification.toArray(new Base[this.classification.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -1434195053: {
                Base[] baseArray;
                if (this.validityPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.validityPeriod;
                }
                return baseArray;
            }
            case 1649733957: {
                Base[] baseArray;
                if (this.lastUpdated == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.lastUpdated;
                }
                return baseArray;
            }
            case -1638369886: {
                return this.additionalCharacteristic == null ? new Base[]{} : this.additionalCharacteristic.toArray(new Base[this.additionalCharacteristic.size()]);
            }
            case -1622333459: {
                return this.additionalClassification == null ? new Base[]{} : this.additionalClassification.toArray(new Base[this.additionalClassification.size()]);
            }
            case 130178823: {
                return this.relatedEntry == null ? new Base[]{} : this.relatedEntry.toArray(new Base[this.relatedEntry.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -220463842: {
                this.purpose = this.castToCodeableConcept(value);
                return value;
            }
            case -1896630996: {
                this.referencedItem = this.castToReference(value);
                return value;
            }
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 1195162672: {
                this.getAdditionalIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 382350310: {
                this.getClassification().add(this.castToCodeableConcept(value));
                return value;
            }
            case -892481550: {
                this.status = this.castToCodeableConcept(value);
                return value;
            }
            case -1434195053: {
                this.validityPeriod = this.castToPeriod(value);
                return value;
            }
            case 1649733957: {
                this.lastUpdated = this.castToDateTime(value);
                return value;
            }
            case -1638369886: {
                this.getAdditionalCharacteristic().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1622333459: {
                this.getAdditionalClassification().add(this.castToCodeableConcept(value));
                return value;
            }
            case 130178823: {
                this.getRelatedEntry().add((EntryDefinitionRelatedEntryComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("purpose")) {
            this.purpose = this.castToCodeableConcept(value);
        } else if (name.equals("referencedItem")) {
            this.referencedItem = this.castToReference(value);
        } else if (name.equals("identifier")) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("additionalIdentifier")) {
            this.getAdditionalIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("classification")) {
            this.getClassification().add(this.castToCodeableConcept(value));
        } else if (name.equals("status")) {
            this.status = this.castToCodeableConcept(value);
        } else if (name.equals("validityPeriod")) {
            this.validityPeriod = this.castToPeriod(value);
        } else if (name.equals("lastUpdated")) {
            this.lastUpdated = this.castToDateTime(value);
        } else if (name.equals("additionalCharacteristic")) {
            this.getAdditionalCharacteristic().add(this.castToCodeableConcept(value));
        } else if (name.equals("additionalClassification")) {
            this.getAdditionalClassification().add(this.castToCodeableConcept(value));
        } else if (name.equals("relatedEntry")) {
            this.getRelatedEntry().add((EntryDefinitionRelatedEntryComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return this.getType();
            }
            case -220463842: {
                return this.getPurpose();
            }
            case -1896630996: {
                return this.getReferencedItem();
            }
            case -1618432855: {
                return this.getIdentifier();
            }
            case 1195162672: {
                return this.addAdditionalIdentifier();
            }
            case 382350310: {
                return this.addClassification();
            }
            case -892481550: {
                return this.getStatus();
            }
            case -1434195053: {
                return this.getValidityPeriod();
            }
            case 1649733957: {
                return this.getLastUpdatedElement();
            }
            case -1638369886: {
                return this.addAdditionalCharacteristic();
            }
            case -1622333459: {
                return this.addAdditionalClassification();
            }
            case 130178823: {
                return this.addRelatedEntry();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"CodeableConcept"};
            }
            case -1896630996: {
                return new String[]{"Reference"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 1195162672: {
                return new String[]{"Identifier"};
            }
            case 382350310: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{"CodeableConcept"};
            }
            case -1434195053: {
                return new String[]{"Period"};
            }
            case 1649733957: {
                return new String[]{"dateTime"};
            }
            case -1638369886: {
                return new String[]{"CodeableConcept"};
            }
            case -1622333459: {
                return new String[]{"CodeableConcept"};
            }
            case 130178823: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("purpose")) {
            this.purpose = new CodeableConcept();
            return this.purpose;
        }
        if (name.equals("referencedItem")) {
            this.referencedItem = new Reference();
            return this.referencedItem;
        }
        if (name.equals("identifier")) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("additionalIdentifier")) {
            return this.addAdditionalIdentifier();
        }
        if (name.equals("classification")) {
            return this.addClassification();
        }
        if (name.equals("status")) {
            this.status = new CodeableConcept();
            return this.status;
        }
        if (name.equals("validityPeriod")) {
            this.validityPeriod = new Period();
            return this.validityPeriod;
        }
        if (name.equals("lastUpdated")) {
            throw new FHIRException("Cannot call addChild on a primitive type EntryDefinition.lastUpdated");
        }
        if (name.equals("additionalCharacteristic")) {
            return this.addAdditionalCharacteristic();
        }
        if (name.equals("additionalClassification")) {
            return this.addAdditionalClassification();
        }
        if (name.equals("relatedEntry")) {
            return this.addRelatedEntry();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EntryDefinition";
    }

    @Override
    public EntryDefinition copy() {
        EntryDefinition dst = new EntryDefinition();
        this.copyValues(dst);
        dst.type = this.type == null ? null : this.type.copy();
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.referencedItem = this.referencedItem == null ? null : this.referencedItem.copy();
        Identifier identifier = dst.identifier = this.identifier == null ? null : this.identifier.copy();
        if (this.additionalIdentifier != null) {
            dst.additionalIdentifier = new ArrayList<Identifier>();
            for (Identifier identifier2 : this.additionalIdentifier) {
                dst.additionalIdentifier.add(identifier2.copy());
            }
        }
        if (this.classification != null) {
            dst.classification = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.classification) {
                dst.classification.add(codeableConcept.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.validityPeriod = this.validityPeriod == null ? null : this.validityPeriod.copy();
        DateTimeType dateTimeType = dst.lastUpdated = this.lastUpdated == null ? null : this.lastUpdated.copy();
        if (this.additionalCharacteristic != null) {
            dst.additionalCharacteristic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.additionalCharacteristic) {
                dst.additionalCharacteristic.add(codeableConcept.copy());
            }
        }
        if (this.additionalClassification != null) {
            dst.additionalClassification = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.additionalClassification) {
                dst.additionalClassification.add(codeableConcept.copy());
            }
        }
        if (this.relatedEntry != null) {
            dst.relatedEntry = new ArrayList<EntryDefinitionRelatedEntryComponent>();
            for (EntryDefinitionRelatedEntryComponent entryDefinitionRelatedEntryComponent : this.relatedEntry) {
                dst.relatedEntry.add(entryDefinitionRelatedEntryComponent.copy());
            }
        }
        return dst;
    }

    protected EntryDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof EntryDefinition)) {
            return false;
        }
        EntryDefinition o = (EntryDefinition)other_;
        return EntryDefinition.compareDeep(this.type, o.type, true) && EntryDefinition.compareDeep(this.purpose, o.purpose, true) && EntryDefinition.compareDeep(this.referencedItem, o.referencedItem, true) && EntryDefinition.compareDeep(this.identifier, o.identifier, true) && EntryDefinition.compareDeep(this.additionalIdentifier, o.additionalIdentifier, true) && EntryDefinition.compareDeep(this.classification, o.classification, true) && EntryDefinition.compareDeep(this.status, o.status, true) && EntryDefinition.compareDeep(this.validityPeriod, o.validityPeriod, true) && EntryDefinition.compareDeep(this.lastUpdated, o.lastUpdated, true) && EntryDefinition.compareDeep(this.additionalCharacteristic, o.additionalCharacteristic, true) && EntryDefinition.compareDeep(this.additionalClassification, o.additionalClassification, true) && EntryDefinition.compareDeep(this.relatedEntry, o.relatedEntry, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof EntryDefinition)) {
            return false;
        }
        EntryDefinition o = (EntryDefinition)other_;
        return EntryDefinition.compareValues(this.lastUpdated, o.lastUpdated, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.purpose, this.referencedItem, this.identifier, this.additionalIdentifier, this.classification, this.status, this.validityPeriod, this.lastUpdated, this.additionalCharacteristic, this.additionalClassification, this.relatedEntry});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.EntryDefinition;
    }

    @Block
    public static class EntryDefinitionRelatedEntryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="relationtype", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of relation to the related item", formalDefinition="The type of relation to the related item: child, parent, packageContent, containerPackage, usedIn, uses, requires, etc.")
        protected CodeableConcept relationtype;
        @Child(name="item", type={EntryDefinition.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The reference to the related item", formalDefinition="The reference to the related item.")
        protected Reference item;
        protected EntryDefinition itemTarget;
        private static final long serialVersionUID = -1871051942L;

        public EntryDefinitionRelatedEntryComponent() {
        }

        public EntryDefinitionRelatedEntryComponent(CodeableConcept relationtype, Reference item) {
            this.relationtype = relationtype;
            this.item = item;
        }

        public CodeableConcept getRelationtype() {
            if (this.relationtype == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EntryDefinitionRelatedEntryComponent.relationtype");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationtype = new CodeableConcept();
                }
            }
            return this.relationtype;
        }

        public boolean hasRelationtype() {
            return this.relationtype != null && !this.relationtype.isEmpty();
        }

        public EntryDefinitionRelatedEntryComponent setRelationtype(CodeableConcept value) {
            this.relationtype = value;
            return this;
        }

        public Reference getItem() {
            if (this.item == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EntryDefinitionRelatedEntryComponent.item");
                }
                if (Configuration.doAutoCreate()) {
                    this.item = new Reference();
                }
            }
            return this.item;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public EntryDefinitionRelatedEntryComponent setItem(Reference value) {
            this.item = value;
            return this;
        }

        public EntryDefinition getItemTarget() {
            if (this.itemTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EntryDefinitionRelatedEntryComponent.item");
                }
                if (Configuration.doAutoCreate()) {
                    this.itemTarget = new EntryDefinition();
                }
            }
            return this.itemTarget;
        }

        public EntryDefinitionRelatedEntryComponent setItemTarget(EntryDefinition value) {
            this.itemTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("relationtype", "CodeableConcept", "The type of relation to the related item: child, parent, packageContent, containerPackage, usedIn, uses, requires, etc.", 0, 1, this.relationtype));
            children.add(new Property("item", "Reference(EntryDefinition)", "The reference to the related item.", 0, 1, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -261805258: {
                    return new Property("relationtype", "CodeableConcept", "The type of relation to the related item: child, parent, packageContent, containerPackage, usedIn, uses, requires, etc.", 0, 1, this.relationtype);
                }
                case 3242771: {
                    return new Property("item", "Reference(EntryDefinition)", "The reference to the related item.", 0, 1, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -261805258: {
                    Base[] baseArray;
                    if (this.relationtype == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.relationtype;
                    }
                    return baseArray;
                }
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.item;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -261805258: {
                    this.relationtype = this.castToCodeableConcept(value);
                    return value;
                }
                case 3242771: {
                    this.item = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("relationtype")) {
                this.relationtype = this.castToCodeableConcept(value);
            } else if (name.equals("item")) {
                this.item = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -261805258: {
                    return this.getRelationtype();
                }
                case 3242771: {
                    return this.getItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -261805258: {
                    return new String[]{"CodeableConcept"};
                }
                case 3242771: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("relationtype")) {
                this.relationtype = new CodeableConcept();
                return this.relationtype;
            }
            if (name.equals("item")) {
                this.item = new Reference();
                return this.item;
            }
            return super.addChild(name);
        }

        @Override
        public EntryDefinitionRelatedEntryComponent copy() {
            EntryDefinitionRelatedEntryComponent dst = new EntryDefinitionRelatedEntryComponent();
            this.copyValues(dst);
            dst.relationtype = this.relationtype == null ? null : this.relationtype.copy();
            dst.item = this.item == null ? null : this.item.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EntryDefinitionRelatedEntryComponent)) {
                return false;
            }
            EntryDefinitionRelatedEntryComponent o = (EntryDefinitionRelatedEntryComponent)other_;
            return EntryDefinitionRelatedEntryComponent.compareDeep(this.relationtype, o.relationtype, true) && EntryDefinitionRelatedEntryComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EntryDefinitionRelatedEntryComponent)) {
                return false;
            }
            EntryDefinitionRelatedEntryComponent o = (EntryDefinitionRelatedEntryComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.relationtype, this.item});
        }

        @Override
        public String fhirType() {
            return "EntryDefinition.relatedEntry";
        }
    }
}

