/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Account;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.ChargeItem;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Invoice", profile="http://hl7.org/fhir/Profile/Invoice")
public class Invoice
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for item", formalDefinition="Identifier of this Invoice, often used for reference in corresponcence about this invoice or for tracking of payments.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | issued | balanced | cancelled | entered-in-error", formalDefinition="The current state of the Invoice.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/invoice-status")
    protected Enumeration<InvoiceStatus> status;
    @Child(name="cancelledReason", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for cancellation of this Invoice", formalDefinition="In case of Invoice cancellation a reason must be given (entered in error, superseded by corrected invoice etc.).")
    protected StringType cancelledReason;
    @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of Invoice", formalDefinition="Type of Invoice depending on domain, realm an usage (eg. internal/external, dental, preliminary).")
    protected CodeableConcept type;
    @Child(name="subject", type={Patient.class, Group.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Recipient(s) of goods and services", formalDefinition="The individual or set of individuals receiving the goods and services billed in this invoice.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="recipient", type={Organization.class, Patient.class, RelatedPerson.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Recipient of this invoice", formalDefinition="The individual or Organization responsible for balancing of this invoice.")
    protected Reference recipient;
    protected Resource recipientTarget;
    @Child(name="date", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Invoice date / posting date", formalDefinition="Date/time(s) of when this Invoice was posted.")
    protected DateTimeType date;
    @Child(name="participant", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Participant in creation of this Invoice", formalDefinition="Indicates who or what performed or participated in the charged service.")
    protected List<InvoiceParticipantComponent> participant;
    @Child(name="issuer", type={Organization.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Issuing Organization of Invoice", formalDefinition="The organizationissuing the Invoice.")
    protected Reference issuer;
    protected Organization issuerTarget;
    @Child(name="account", type={Account.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Account that is being balanced", formalDefinition="Account which is supposed to be balanced with this Invoice.")
    protected Reference account;
    protected Account accountTarget;
    @Child(name="lineItem", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Line items of this Invoice", formalDefinition="Each line item represents one charge for goods ond services rendered. Details such as date, code and amount are found in the referenced ChargeItem resource.")
    protected List<InvoiceLineItemComponent> lineItem;
    @Child(name="totalPriceComponent", type={InvoiceLineItemPriceComponentComponent.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Components of Invoice total", formalDefinition="The total amount for the Invoice may be calculated as the sum of the line items with surcharges/deductions that apply in certain conditions.  The priceComponent element can be used to offer transparency to the recipient of the Invoice of how the total price was calculated.")
    protected List<InvoiceLineItemPriceComponentComponent> totalPriceComponent;
    @Child(name="totalNet", type={Money.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Net total of this Invoice", formalDefinition="Invoice total , taxes excluded.")
    protected Money totalNet;
    @Child(name="totalGross", type={Money.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Gross toal of this Invoice", formalDefinition="Invoice total, tax included.")
    protected Money totalGross;
    @Child(name="paymentTerms", type={MarkdownType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Payment details", formalDefinition="Payment details such as banking details, period of payment, deductables, methods of payment.")
    protected MarkdownType paymentTerms;
    @Child(name="note", type={Annotation.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about the invoice", formalDefinition="Comments made about the invoice by the issuer, subject or other participants.")
    protected List<Annotation> note;
    private static final long serialVersionUID = -62357265L;
    @SearchParamDefinition(name="date", path="Invoice.date", description="Invoice date / posting date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Invoice.identifier", description="Business Identifier for item", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="totalgross", path="Invoice.totalGross", description="Gross toal of this Invoice", type="quantity")
    public static final String SP_TOTALGROSS = "totalgross";
    public static final QuantityClientParam TOTALGROSS = new QuantityClientParam("totalgross");
    @SearchParamDefinition(name="subject", path="Invoice.subject", description="Recipient(s) of goods and services", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Invoice:subject").toLocked();
    @SearchParamDefinition(name="participant-role", path="Invoice.participant.role", description="Type of involevent in creation of this Invoice", type="token")
    public static final String SP_PARTICIPANT_ROLE = "participant-role";
    public static final TokenClientParam PARTICIPANT_ROLE = new TokenClientParam("participant-role");
    @SearchParamDefinition(name="type", path="Invoice.type", description="Type of Invoice", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="issuer", path="Invoice.issuer", description="Issuing Organization of Invoice", type="reference", target={Organization.class})
    public static final String SP_ISSUER = "issuer";
    public static final ReferenceClientParam ISSUER = new ReferenceClientParam("issuer");
    public static final Include INCLUDE_ISSUER = new Include("Invoice:issuer").toLocked();
    @SearchParamDefinition(name="participant", path="Invoice.participant.actor", description="Individual who was involved", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Practitioner")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_PARTICIPANT = "participant";
    public static final ReferenceClientParam PARTICIPANT = new ReferenceClientParam("participant");
    public static final Include INCLUDE_PARTICIPANT = new Include("Invoice:participant").toLocked();
    @SearchParamDefinition(name="totalnet", path="Invoice.totalNet", description="Net total of this Invoice", type="quantity")
    public static final String SP_TOTALNET = "totalnet";
    public static final QuantityClientParam TOTALNET = new QuantityClientParam("totalnet");
    @SearchParamDefinition(name="patient", path="Invoice.subject", description="Recipient(s) of goods and services", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Invoice:patient").toLocked();
    @SearchParamDefinition(name="recipient", path="Invoice.recipient", description="Recipient of this invoice", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="RelatedPerson")}, target={Organization.class, Patient.class, RelatedPerson.class})
    public static final String SP_RECIPIENT = "recipient";
    public static final ReferenceClientParam RECIPIENT = new ReferenceClientParam("recipient");
    public static final Include INCLUDE_RECIPIENT = new Include("Invoice:recipient").toLocked();
    @SearchParamDefinition(name="account", path="Invoice.account", description="Account that is being balanced", type="reference", target={Account.class})
    public static final String SP_ACCOUNT = "account";
    public static final ReferenceClientParam ACCOUNT = new ReferenceClientParam("account");
    public static final Include INCLUDE_ACCOUNT = new Include("Invoice:account").toLocked();
    @SearchParamDefinition(name="status", path="Invoice.status", description="draft | issued | balanced | cancelled | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Invoice() {
    }

    public Invoice(Enumeration<InvoiceStatus> status) {
        this.status = status;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Invoice setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Invoice addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<InvoiceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<InvoiceStatus>(new InvoiceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Invoice setStatusElement(Enumeration<InvoiceStatus> value) {
        this.status = value;
        return this;
    }

    public InvoiceStatus getStatus() {
        return this.status == null ? null : (InvoiceStatus)((Object)this.status.getValue());
    }

    public Invoice setStatus(InvoiceStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<InvoiceStatus>(new InvoiceStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public StringType getCancelledReasonElement() {
        if (this.cancelledReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.cancelledReason");
            }
            if (Configuration.doAutoCreate()) {
                this.cancelledReason = new StringType();
            }
        }
        return this.cancelledReason;
    }

    public boolean hasCancelledReasonElement() {
        return this.cancelledReason != null && !this.cancelledReason.isEmpty();
    }

    public boolean hasCancelledReason() {
        return this.cancelledReason != null && !this.cancelledReason.isEmpty();
    }

    public Invoice setCancelledReasonElement(StringType value) {
        this.cancelledReason = value;
        return this;
    }

    public String getCancelledReason() {
        return this.cancelledReason == null ? null : (String)this.cancelledReason.getValue();
    }

    public Invoice setCancelledReason(String value) {
        if (Utilities.noString((String)value)) {
            this.cancelledReason = null;
        } else {
            if (this.cancelledReason == null) {
                this.cancelledReason = new StringType();
            }
            this.cancelledReason.setValue(value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Invoice setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Invoice setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Invoice setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getRecipient() {
        if (this.recipient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.recipient");
            }
            if (Configuration.doAutoCreate()) {
                this.recipient = new Reference();
            }
        }
        return this.recipient;
    }

    public boolean hasRecipient() {
        return this.recipient != null && !this.recipient.isEmpty();
    }

    public Invoice setRecipient(Reference value) {
        this.recipient = value;
        return this;
    }

    public Resource getRecipientTarget() {
        return this.recipientTarget;
    }

    public Invoice setRecipientTarget(Resource value) {
        this.recipientTarget = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public Invoice setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public Invoice setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public List<InvoiceParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<InvoiceParticipantComponent>();
        }
        return this.participant;
    }

    public Invoice setParticipant(List<InvoiceParticipantComponent> theParticipant) {
        this.participant = theParticipant;
        return this;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (InvoiceParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InvoiceParticipantComponent addParticipant() {
        InvoiceParticipantComponent t = new InvoiceParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<InvoiceParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public Invoice addParticipant(InvoiceParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<InvoiceParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public InvoiceParticipantComponent getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public Reference getIssuer() {
        if (this.issuer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.issuer");
            }
            if (Configuration.doAutoCreate()) {
                this.issuer = new Reference();
            }
        }
        return this.issuer;
    }

    public boolean hasIssuer() {
        return this.issuer != null && !this.issuer.isEmpty();
    }

    public Invoice setIssuer(Reference value) {
        this.issuer = value;
        return this;
    }

    public Organization getIssuerTarget() {
        if (this.issuerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.issuer");
            }
            if (Configuration.doAutoCreate()) {
                this.issuerTarget = new Organization();
            }
        }
        return this.issuerTarget;
    }

    public Invoice setIssuerTarget(Organization value) {
        this.issuerTarget = value;
        return this;
    }

    public Reference getAccount() {
        if (this.account == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.account");
            }
            if (Configuration.doAutoCreate()) {
                this.account = new Reference();
            }
        }
        return this.account;
    }

    public boolean hasAccount() {
        return this.account != null && !this.account.isEmpty();
    }

    public Invoice setAccount(Reference value) {
        this.account = value;
        return this;
    }

    public Account getAccountTarget() {
        if (this.accountTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.account");
            }
            if (Configuration.doAutoCreate()) {
                this.accountTarget = new Account();
            }
        }
        return this.accountTarget;
    }

    public Invoice setAccountTarget(Account value) {
        this.accountTarget = value;
        return this;
    }

    public List<InvoiceLineItemComponent> getLineItem() {
        if (this.lineItem == null) {
            this.lineItem = new ArrayList<InvoiceLineItemComponent>();
        }
        return this.lineItem;
    }

    public Invoice setLineItem(List<InvoiceLineItemComponent> theLineItem) {
        this.lineItem = theLineItem;
        return this;
    }

    public boolean hasLineItem() {
        if (this.lineItem == null) {
            return false;
        }
        for (InvoiceLineItemComponent item : this.lineItem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InvoiceLineItemComponent addLineItem() {
        InvoiceLineItemComponent t = new InvoiceLineItemComponent();
        if (this.lineItem == null) {
            this.lineItem = new ArrayList<InvoiceLineItemComponent>();
        }
        this.lineItem.add(t);
        return t;
    }

    public Invoice addLineItem(InvoiceLineItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.lineItem == null) {
            this.lineItem = new ArrayList<InvoiceLineItemComponent>();
        }
        this.lineItem.add(t);
        return this;
    }

    public InvoiceLineItemComponent getLineItemFirstRep() {
        if (this.getLineItem().isEmpty()) {
            this.addLineItem();
        }
        return this.getLineItem().get(0);
    }

    public List<InvoiceLineItemPriceComponentComponent> getTotalPriceComponent() {
        if (this.totalPriceComponent == null) {
            this.totalPriceComponent = new ArrayList<InvoiceLineItemPriceComponentComponent>();
        }
        return this.totalPriceComponent;
    }

    public Invoice setTotalPriceComponent(List<InvoiceLineItemPriceComponentComponent> theTotalPriceComponent) {
        this.totalPriceComponent = theTotalPriceComponent;
        return this;
    }

    public boolean hasTotalPriceComponent() {
        if (this.totalPriceComponent == null) {
            return false;
        }
        for (InvoiceLineItemPriceComponentComponent item : this.totalPriceComponent) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InvoiceLineItemPriceComponentComponent addTotalPriceComponent() {
        InvoiceLineItemPriceComponentComponent t = new InvoiceLineItemPriceComponentComponent();
        if (this.totalPriceComponent == null) {
            this.totalPriceComponent = new ArrayList<InvoiceLineItemPriceComponentComponent>();
        }
        this.totalPriceComponent.add(t);
        return t;
    }

    public Invoice addTotalPriceComponent(InvoiceLineItemPriceComponentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.totalPriceComponent == null) {
            this.totalPriceComponent = new ArrayList<InvoiceLineItemPriceComponentComponent>();
        }
        this.totalPriceComponent.add(t);
        return this;
    }

    public InvoiceLineItemPriceComponentComponent getTotalPriceComponentFirstRep() {
        if (this.getTotalPriceComponent().isEmpty()) {
            this.addTotalPriceComponent();
        }
        return this.getTotalPriceComponent().get(0);
    }

    public Money getTotalNet() {
        if (this.totalNet == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.totalNet");
            }
            if (Configuration.doAutoCreate()) {
                this.totalNet = new Money();
            }
        }
        return this.totalNet;
    }

    public boolean hasTotalNet() {
        return this.totalNet != null && !this.totalNet.isEmpty();
    }

    public Invoice setTotalNet(Money value) {
        this.totalNet = value;
        return this;
    }

    public Money getTotalGross() {
        if (this.totalGross == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.totalGross");
            }
            if (Configuration.doAutoCreate()) {
                this.totalGross = new Money();
            }
        }
        return this.totalGross;
    }

    public boolean hasTotalGross() {
        return this.totalGross != null && !this.totalGross.isEmpty();
    }

    public Invoice setTotalGross(Money value) {
        this.totalGross = value;
        return this;
    }

    public MarkdownType getPaymentTermsElement() {
        if (this.paymentTerms == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.paymentTerms");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentTerms = new MarkdownType();
            }
        }
        return this.paymentTerms;
    }

    public boolean hasPaymentTermsElement() {
        return this.paymentTerms != null && !this.paymentTerms.isEmpty();
    }

    public boolean hasPaymentTerms() {
        return this.paymentTerms != null && !this.paymentTerms.isEmpty();
    }

    public Invoice setPaymentTermsElement(MarkdownType value) {
        this.paymentTerms = value;
        return this;
    }

    public String getPaymentTerms() {
        return this.paymentTerms == null ? null : (String)this.paymentTerms.getValue();
    }

    public Invoice setPaymentTerms(String value) {
        if (value == null) {
            this.paymentTerms = null;
        } else {
            if (this.paymentTerms == null) {
                this.paymentTerms = new MarkdownType();
            }
            this.paymentTerms.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Invoice setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Invoice addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier of this Invoice, often used for reference in corresponcence about this invoice or for tracking of payments.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The current state of the Invoice.", 0, 1, this.status));
        children.add(new Property("cancelledReason", "string", "In case of Invoice cancellation a reason must be given (entered in error, superseded by corrected invoice etc.).", 0, 1, this.cancelledReason));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Type of Invoice depending on domain, realm an usage (eg. internal/external, dental, preliminary).", 0, 1, this.type));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The individual or set of individuals receiving the goods and services billed in this invoice.", 0, 1, this.subject));
        children.add(new Property(SP_RECIPIENT, "Reference(Organization|Patient|RelatedPerson)", "The individual or Organization responsible for balancing of this invoice.", 0, 1, this.recipient));
        children.add(new Property(SP_DATE, "dateTime", "Date/time(s) of when this Invoice was posted.", 0, 1, this.date));
        children.add(new Property(SP_PARTICIPANT, "", "Indicates who or what performed or participated in the charged service.", 0, Integer.MAX_VALUE, this.participant));
        children.add(new Property(SP_ISSUER, "Reference(Organization)", "The organizationissuing the Invoice.", 0, 1, this.issuer));
        children.add(new Property(SP_ACCOUNT, "Reference(Account)", "Account which is supposed to be balanced with this Invoice.", 0, 1, this.account));
        children.add(new Property("lineItem", "", "Each line item represents one charge for goods ond services rendered. Details such as date, code and amount are found in the referenced ChargeItem resource.", 0, Integer.MAX_VALUE, this.lineItem));
        children.add(new Property("totalPriceComponent", "@Invoice.lineItem.priceComponent", "The total amount for the Invoice may be calculated as the sum of the line items with surcharges/deductions that apply in certain conditions.  The priceComponent element can be used to offer transparency to the recipient of the Invoice of how the total price was calculated.", 0, Integer.MAX_VALUE, this.totalPriceComponent));
        children.add(new Property("totalNet", "Money", "Invoice total , taxes excluded.", 0, 1, this.totalNet));
        children.add(new Property("totalGross", "Money", "Invoice total, tax included.", 0, 1, this.totalGross));
        children.add(new Property("paymentTerms", "markdown", "Payment details such as banking details, period of payment, deductables, methods of payment.", 0, 1, this.paymentTerms));
        children.add(new Property("note", "Annotation", "Comments made about the invoice by the issuer, subject or other participants.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier of this Invoice, often used for reference in corresponcence about this invoice or for tracking of payments.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the Invoice.", 0, 1, this.status);
            }
            case 1550362357: {
                return new Property("cancelledReason", "string", "In case of Invoice cancellation a reason must be given (entered in error, superseded by corrected invoice etc.).", 0, 1, this.cancelledReason);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Type of Invoice depending on domain, realm an usage (eg. internal/external, dental, preliminary).", 0, 1, this.type);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The individual or set of individuals receiving the goods and services billed in this invoice.", 0, 1, this.subject);
            }
            case 820081177: {
                return new Property(SP_RECIPIENT, "Reference(Organization|Patient|RelatedPerson)", "The individual or Organization responsible for balancing of this invoice.", 0, 1, this.recipient);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "Date/time(s) of when this Invoice was posted.", 0, 1, this.date);
            }
            case 767422259: {
                return new Property(SP_PARTICIPANT, "", "Indicates who or what performed or participated in the charged service.", 0, Integer.MAX_VALUE, this.participant);
            }
            case -1179159879: {
                return new Property(SP_ISSUER, "Reference(Organization)", "The organizationissuing the Invoice.", 0, 1, this.issuer);
            }
            case -1177318867: {
                return new Property(SP_ACCOUNT, "Reference(Account)", "Account which is supposed to be balanced with this Invoice.", 0, 1, this.account);
            }
            case 1188332839: {
                return new Property("lineItem", "", "Each line item represents one charge for goods ond services rendered. Details such as date, code and amount are found in the referenced ChargeItem resource.", 0, Integer.MAX_VALUE, this.lineItem);
            }
            case 1731497496: {
                return new Property("totalPriceComponent", "@Invoice.lineItem.priceComponent", "The total amount for the Invoice may be calculated as the sum of the line items with surcharges/deductions that apply in certain conditions.  The priceComponent element can be used to offer transparency to the recipient of the Invoice of how the total price was calculated.", 0, Integer.MAX_VALUE, this.totalPriceComponent);
            }
            case -849911879: {
                return new Property("totalNet", "Money", "Invoice total , taxes excluded.", 0, 1, this.totalNet);
            }
            case -727607968: {
                return new Property("totalGross", "Money", "Invoice total, tax included.", 0, 1, this.totalGross);
            }
            case -507544799: {
                return new Property("paymentTerms", "markdown", "Payment details such as banking details, period of payment, deductables, methods of payment.", 0, 1, this.paymentTerms);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments made about the invoice by the issuer, subject or other participants.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 1550362357: {
                Base[] baseArray;
                if (this.cancelledReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.cancelledReason;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.type;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 820081177: {
                Base[] baseArray;
                if (this.recipient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.recipient;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case 767422259: {
                return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
            }
            case -1179159879: {
                Base[] baseArray;
                if (this.issuer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.issuer;
                }
                return baseArray;
            }
            case -1177318867: {
                Base[] baseArray;
                if (this.account == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.account;
                }
                return baseArray;
            }
            case 1188332839: {
                return this.lineItem == null ? new Base[]{} : this.lineItem.toArray(new Base[this.lineItem.size()]);
            }
            case 1731497496: {
                return this.totalPriceComponent == null ? new Base[]{} : this.totalPriceComponent.toArray(new Base[this.totalPriceComponent.size()]);
            }
            case -849911879: {
                Base[] baseArray;
                if (this.totalNet == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.totalNet;
                }
                return baseArray;
            }
            case -727607968: {
                Base[] baseArray;
                if (this.totalGross == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.totalGross;
                }
                return baseArray;
            }
            case -507544799: {
                Base[] baseArray;
                if (this.paymentTerms == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.paymentTerms;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new InvoiceStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 1550362357: {
                this.cancelledReason = this.castToString(value);
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 820081177: {
                this.recipient = this.castToReference(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 767422259: {
                this.getParticipant().add((InvoiceParticipantComponent)((Object)value));
                return value;
            }
            case -1179159879: {
                this.issuer = this.castToReference(value);
                return value;
            }
            case -1177318867: {
                this.account = this.castToReference(value);
                return value;
            }
            case 1188332839: {
                this.getLineItem().add((InvoiceLineItemComponent)((Object)value));
                return value;
            }
            case 1731497496: {
                this.getTotalPriceComponent().add((InvoiceLineItemPriceComponentComponent)((Object)value));
                return value;
            }
            case -849911879: {
                this.totalNet = this.castToMoney(value);
                return value;
            }
            case -727607968: {
                this.totalGross = this.castToMoney(value);
                return value;
            }
            case -507544799: {
                this.paymentTerms = this.castToMarkdown(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new InvoiceStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("cancelledReason")) {
            this.cancelledReason = this.castToString(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_RECIPIENT)) {
            this.recipient = this.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PARTICIPANT)) {
            this.getParticipant().add((InvoiceParticipantComponent)((Object)value));
        } else if (name.equals(SP_ISSUER)) {
            this.issuer = this.castToReference(value);
        } else if (name.equals(SP_ACCOUNT)) {
            this.account = this.castToReference(value);
        } else if (name.equals("lineItem")) {
            this.getLineItem().add((InvoiceLineItemComponent)((Object)value));
        } else if (name.equals("totalPriceComponent")) {
            this.getTotalPriceComponent().add((InvoiceLineItemPriceComponentComponent)((Object)value));
        } else if (name.equals("totalNet")) {
            this.totalNet = this.castToMoney(value);
        } else if (name.equals("totalGross")) {
            this.totalGross = this.castToMoney(value);
        } else if (name.equals("paymentTerms")) {
            this.paymentTerms = this.castToMarkdown(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1550362357: {
                return this.getCancelledReasonElement();
            }
            case 3575610: {
                return this.getType();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 820081177: {
                return this.getRecipient();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 767422259: {
                return this.addParticipant();
            }
            case -1179159879: {
                return this.getIssuer();
            }
            case -1177318867: {
                return this.getAccount();
            }
            case 1188332839: {
                return this.addLineItem();
            }
            case 1731497496: {
                return this.addTotalPriceComponent();
            }
            case -849911879: {
                return this.getTotalNet();
            }
            case -727607968: {
                return this.getTotalGross();
            }
            case -507544799: {
                return this.getPaymentTermsElement();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 1550362357: {
                return new String[]{"string"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 820081177: {
                return new String[]{"Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 767422259: {
                return new String[0];
            }
            case -1179159879: {
                return new String[]{"Reference"};
            }
            case -1177318867: {
                return new String[]{"Reference"};
            }
            case 1188332839: {
                return new String[0];
            }
            case 1731497496: {
                return new String[]{"@Invoice.lineItem.priceComponent"};
            }
            case -849911879: {
                return new String[]{"Money"};
            }
            case -727607968: {
                return new String[]{"Money"};
            }
            case -507544799: {
                return new String[]{"markdown"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Invoice.status");
        }
        if (name.equals("cancelledReason")) {
            throw new FHIRException("Cannot call addChild on a primitive type Invoice.cancelledReason");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_RECIPIENT)) {
            this.recipient = new Reference();
            return this.recipient;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Invoice.date");
        }
        if (name.equals(SP_PARTICIPANT)) {
            return this.addParticipant();
        }
        if (name.equals(SP_ISSUER)) {
            this.issuer = new Reference();
            return this.issuer;
        }
        if (name.equals(SP_ACCOUNT)) {
            this.account = new Reference();
            return this.account;
        }
        if (name.equals("lineItem")) {
            return this.addLineItem();
        }
        if (name.equals("totalPriceComponent")) {
            return this.addTotalPriceComponent();
        }
        if (name.equals("totalNet")) {
            this.totalNet = new Money();
            return this.totalNet;
        }
        if (name.equals("totalGross")) {
            this.totalGross = new Money();
            return this.totalGross;
        }
        if (name.equals("paymentTerms")) {
            throw new FHIRException("Cannot call addChild on a primitive type Invoice.paymentTerms");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Invoice";
    }

    @Override
    public Invoice copy() {
        Invoice dst = new Invoice();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.cancelledReason = this.cancelledReason == null ? null : this.cancelledReason.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.recipient = this.recipient == null ? null : this.recipient.copy();
        DateTimeType dateTimeType = dst.date = this.date == null ? null : this.date.copy();
        if (this.participant != null) {
            dst.participant = new ArrayList<InvoiceParticipantComponent>();
            for (InvoiceParticipantComponent invoiceParticipantComponent : this.participant) {
                dst.participant.add(invoiceParticipantComponent.copy());
            }
        }
        dst.issuer = this.issuer == null ? null : this.issuer.copy();
        Reference reference = dst.account = this.account == null ? null : this.account.copy();
        if (this.lineItem != null) {
            dst.lineItem = new ArrayList<InvoiceLineItemComponent>();
            for (InvoiceLineItemComponent invoiceLineItemComponent : this.lineItem) {
                dst.lineItem.add(invoiceLineItemComponent.copy());
            }
        }
        if (this.totalPriceComponent != null) {
            dst.totalPriceComponent = new ArrayList<InvoiceLineItemPriceComponentComponent>();
            for (InvoiceLineItemPriceComponentComponent invoiceLineItemPriceComponentComponent : this.totalPriceComponent) {
                dst.totalPriceComponent.add(invoiceLineItemPriceComponentComponent.copy());
            }
        }
        dst.totalNet = this.totalNet == null ? null : this.totalNet.copy();
        dst.totalGross = this.totalGross == null ? null : this.totalGross.copy();
        MarkdownType markdownType = dst.paymentTerms = this.paymentTerms == null ? null : this.paymentTerms.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        return dst;
    }

    protected Invoice typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Invoice)) {
            return false;
        }
        Invoice o = (Invoice)other_;
        return Invoice.compareDeep(this.identifier, o.identifier, true) && Invoice.compareDeep(this.status, o.status, true) && Invoice.compareDeep(this.cancelledReason, o.cancelledReason, true) && Invoice.compareDeep(this.type, o.type, true) && Invoice.compareDeep(this.subject, o.subject, true) && Invoice.compareDeep(this.recipient, o.recipient, true) && Invoice.compareDeep(this.date, o.date, true) && Invoice.compareDeep(this.participant, o.participant, true) && Invoice.compareDeep(this.issuer, o.issuer, true) && Invoice.compareDeep(this.account, o.account, true) && Invoice.compareDeep(this.lineItem, o.lineItem, true) && Invoice.compareDeep(this.totalPriceComponent, o.totalPriceComponent, true) && Invoice.compareDeep(this.totalNet, o.totalNet, true) && Invoice.compareDeep(this.totalGross, o.totalGross, true) && Invoice.compareDeep(this.paymentTerms, o.paymentTerms, true) && Invoice.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Invoice)) {
            return false;
        }
        Invoice o = (Invoice)other_;
        return Invoice.compareValues(this.status, o.status, true) && Invoice.compareValues(this.cancelledReason, o.cancelledReason, true) && Invoice.compareValues(this.date, o.date, true) && Invoice.compareValues(this.paymentTerms, o.paymentTerms, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.cancelledReason, this.type, this.subject, this.recipient, this.date, this.participant, this.issuer, this.account, this.lineItem, this.totalPriceComponent, this.totalNet, this.totalGross, this.paymentTerms, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Invoice;
    }

    @Block
    public static class InvoiceLineItemPriceComponentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="base | surcharge | deduction | discount | tax | informational", formalDefinition="This code identifies the type of the component.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/invoice-priceComponentType")
        protected Enumeration<InvoicePriceComponentType> type;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code identifying the specific component", formalDefinition="A code that identifies the component. Codes may be used to differentiate between kinds of taxes, surcharges, discounts etc.")
        protected CodeableConcept code;
        @Child(name="factor", type={Money.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Monetary amount associated with this component", formalDefinition="The amount calculated for this component.")
        protected Money factor;
        @Child(name="amount", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Factor used for calculating this component", formalDefinition="The factor that has been applied on the base price for calculating this component.")
        protected DecimalType amount;
        private static final long serialVersionUID = -39471852L;

        public InvoiceLineItemPriceComponentComponent() {
        }

        public InvoiceLineItemPriceComponentComponent(Enumeration<InvoicePriceComponentType> type) {
            this.type = type;
        }

        public Enumeration<InvoicePriceComponentType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InvoiceLineItemPriceComponentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<InvoicePriceComponentType>(new InvoicePriceComponentTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public InvoiceLineItemPriceComponentComponent setTypeElement(Enumeration<InvoicePriceComponentType> value) {
            this.type = value;
            return this;
        }

        public InvoicePriceComponentType getType() {
            return this.type == null ? null : (InvoicePriceComponentType)((Object)this.type.getValue());
        }

        public InvoiceLineItemPriceComponentComponent setType(InvoicePriceComponentType value) {
            if (this.type == null) {
                this.type = new Enumeration<InvoicePriceComponentType>(new InvoicePriceComponentTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InvoiceLineItemPriceComponentComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public InvoiceLineItemPriceComponentComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Money getFactor() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InvoiceLineItemPriceComponentComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new Money();
                }
            }
            return this.factor;
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public InvoiceLineItemPriceComponentComponent setFactor(Money value) {
            this.factor = value;
            return this;
        }

        public DecimalType getAmountElement() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InvoiceLineItemPriceComponentComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new DecimalType();
                }
            }
            return this.amount;
        }

        public boolean hasAmountElement() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public InvoiceLineItemPriceComponentComponent setAmountElement(DecimalType value) {
            this.amount = value;
            return this;
        }

        public BigDecimal getAmount() {
            return this.amount == null ? null : (BigDecimal)this.amount.getValue();
        }

        public InvoiceLineItemPriceComponentComponent setAmount(BigDecimal value) {
            if (value == null) {
                this.amount = null;
            } else {
                if (this.amount == null) {
                    this.amount = new DecimalType();
                }
                this.amount.setValue(value);
            }
            return this;
        }

        public InvoiceLineItemPriceComponentComponent setAmount(long value) {
            this.amount = new DecimalType();
            this.amount.setValue(value);
            return this;
        }

        public InvoiceLineItemPriceComponentComponent setAmount(double value) {
            this.amount = new DecimalType();
            this.amount.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Invoice.SP_TYPE, "code", "This code identifies the type of the component.", 0, 1, this.type));
            children.add(new Property("code", "CodeableConcept", "A code that identifies the component. Codes may be used to differentiate between kinds of taxes, surcharges, discounts etc.", 0, 1, this.code));
            children.add(new Property("factor", "Money", "The amount calculated for this component.", 0, 1, this.factor));
            children.add(new Property("amount", "decimal", "The factor that has been applied on the base price for calculating this component.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(Invoice.SP_TYPE, "code", "This code identifies the type of the component.", 0, 1, this.type);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "A code that identifies the component. Codes may be used to differentiate between kinds of taxes, surcharges, discounts etc.", 0, 1, this.code);
                }
                case -1282148017: {
                    return new Property("factor", "Money", "The amount calculated for this component.", 0, 1, this.factor);
                }
                case -1413853096: {
                    return new Property("amount", "decimal", "The factor that has been applied on the base price for calculating this component.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.factor;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new InvoicePriceComponentTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToMoney(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToDecimal(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Invoice.SP_TYPE)) {
                value = new InvoicePriceComponentTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToMoney(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToDecimal(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 3059181: {
                    return this.getCode();
                }
                case -1282148017: {
                    return this.getFactor();
                }
                case -1413853096: {
                    return this.getAmountElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -1282148017: {
                    return new String[]{"Money"};
                }
                case -1413853096: {
                    return new String[]{"decimal"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Invoice.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a primitive type Invoice.type");
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("factor")) {
                this.factor = new Money();
                return this.factor;
            }
            if (name.equals("amount")) {
                throw new FHIRException("Cannot call addChild on a primitive type Invoice.amount");
            }
            return super.addChild(name);
        }

        @Override
        public InvoiceLineItemPriceComponentComponent copy() {
            InvoiceLineItemPriceComponentComponent dst = new InvoiceLineItemPriceComponentComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InvoiceLineItemPriceComponentComponent)) {
                return false;
            }
            InvoiceLineItemPriceComponentComponent o = (InvoiceLineItemPriceComponentComponent)other_;
            return InvoiceLineItemPriceComponentComponent.compareDeep(this.type, o.type, true) && InvoiceLineItemPriceComponentComponent.compareDeep(this.code, o.code, true) && InvoiceLineItemPriceComponentComponent.compareDeep(this.factor, o.factor, true) && InvoiceLineItemPriceComponentComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InvoiceLineItemPriceComponentComponent)) {
                return false;
            }
            InvoiceLineItemPriceComponentComponent o = (InvoiceLineItemPriceComponentComponent)other_;
            return InvoiceLineItemPriceComponentComponent.compareValues(this.type, o.type, true) && InvoiceLineItemPriceComponentComponent.compareValues(this.amount, o.amount, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.code, this.factor, this.amount});
        }

        @Override
        public String fhirType() {
            return "Invoice.lineItem.priceComponent";
        }
    }

    @Block
    public static class InvoiceLineItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Sequence number of line item", formalDefinition="Sequence in which the items appear on the invoice.")
        protected PositiveIntType sequence;
        @Child(name="chargeItem", type={ChargeItem.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to ChargeItem containing details of this line item", formalDefinition="The ChargeItem contains information such as the billing code, date, amount etc.")
        protected Reference chargeItem;
        protected ChargeItem chargeItemTarget;
        @Child(name="priceComponent", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Components of total line item price", formalDefinition="The price for a ChargeItem may be calculated as a base price with surcharges/deductions that apply in certain conditions. A ChargeItemDefinition resource that defines the prices, factors and conditions that apply to a billing code is currently under developement. The priceComponent element can be used to offer transparency to the recipient of the Invoice of how the prices have been calculated.")
        protected List<InvoiceLineItemPriceComponentComponent> priceComponent;
        private static final long serialVersionUID = -1719217937L;

        public InvoiceLineItemComponent() {
        }

        public InvoiceLineItemComponent(Reference chargeItem) {
            this.chargeItem = chargeItem;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InvoiceLineItemComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public InvoiceLineItemComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public InvoiceLineItemComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public Reference getChargeItem() {
            if (this.chargeItem == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InvoiceLineItemComponent.chargeItem");
                }
                if (Configuration.doAutoCreate()) {
                    this.chargeItem = new Reference();
                }
            }
            return this.chargeItem;
        }

        public boolean hasChargeItem() {
            return this.chargeItem != null && !this.chargeItem.isEmpty();
        }

        public InvoiceLineItemComponent setChargeItem(Reference value) {
            this.chargeItem = value;
            return this;
        }

        public ChargeItem getChargeItemTarget() {
            if (this.chargeItemTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InvoiceLineItemComponent.chargeItem");
                }
                if (Configuration.doAutoCreate()) {
                    this.chargeItemTarget = new ChargeItem();
                }
            }
            return this.chargeItemTarget;
        }

        public InvoiceLineItemComponent setChargeItemTarget(ChargeItem value) {
            this.chargeItemTarget = value;
            return this;
        }

        public List<InvoiceLineItemPriceComponentComponent> getPriceComponent() {
            if (this.priceComponent == null) {
                this.priceComponent = new ArrayList<InvoiceLineItemPriceComponentComponent>();
            }
            return this.priceComponent;
        }

        public InvoiceLineItemComponent setPriceComponent(List<InvoiceLineItemPriceComponentComponent> thePriceComponent) {
            this.priceComponent = thePriceComponent;
            return this;
        }

        public boolean hasPriceComponent() {
            if (this.priceComponent == null) {
                return false;
            }
            for (InvoiceLineItemPriceComponentComponent item : this.priceComponent) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public InvoiceLineItemPriceComponentComponent addPriceComponent() {
            InvoiceLineItemPriceComponentComponent t = new InvoiceLineItemPriceComponentComponent();
            if (this.priceComponent == null) {
                this.priceComponent = new ArrayList<InvoiceLineItemPriceComponentComponent>();
            }
            this.priceComponent.add(t);
            return t;
        }

        public InvoiceLineItemComponent addPriceComponent(InvoiceLineItemPriceComponentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.priceComponent == null) {
                this.priceComponent = new ArrayList<InvoiceLineItemPriceComponentComponent>();
            }
            this.priceComponent.add(t);
            return this;
        }

        public InvoiceLineItemPriceComponentComponent getPriceComponentFirstRep() {
            if (this.getPriceComponent().isEmpty()) {
                this.addPriceComponent();
            }
            return this.getPriceComponent().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "Sequence in which the items appear on the invoice.", 0, 1, this.sequence));
            children.add(new Property("chargeItem", "Reference(ChargeItem)", "The ChargeItem contains information such as the billing code, date, amount etc.", 0, 1, this.chargeItem));
            children.add(new Property("priceComponent", "", "The price for a ChargeItem may be calculated as a base price with surcharges/deductions that apply in certain conditions. A ChargeItemDefinition resource that defines the prices, factors and conditions that apply to a billing code is currently under developement. The priceComponent element can be used to offer transparency to the recipient of the Invoice of how the prices have been calculated.", 0, Integer.MAX_VALUE, this.priceComponent));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "Sequence in which the items appear on the invoice.", 0, 1, this.sequence);
                }
                case 1417779175: {
                    return new Property("chargeItem", "Reference(ChargeItem)", "The ChargeItem contains information such as the billing code, date, amount etc.", 0, 1, this.chargeItem);
                }
                case 1219095988: {
                    return new Property("priceComponent", "", "The price for a ChargeItem may be calculated as a base price with surcharges/deductions that apply in certain conditions. A ChargeItemDefinition resource that defines the prices, factors and conditions that apply to a billing code is currently under developement. The priceComponent element can be used to offer transparency to the recipient of the Invoice of how the prices have been calculated.", 0, Integer.MAX_VALUE, this.priceComponent);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 1417779175: {
                    Base[] baseArray;
                    if (this.chargeItem == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.chargeItem;
                    }
                    return baseArray;
                }
                case 1219095988: {
                    return this.priceComponent == null ? new Base[]{} : this.priceComponent.toArray(new Base[this.priceComponent.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 1417779175: {
                    this.chargeItem = this.castToReference(value);
                    return value;
                }
                case 1219095988: {
                    this.getPriceComponent().add((InvoiceLineItemPriceComponentComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("chargeItem")) {
                this.chargeItem = this.castToReference(value);
            } else if (name.equals("priceComponent")) {
                this.getPriceComponent().add((InvoiceLineItemPriceComponentComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 1417779175: {
                    return this.getChargeItem();
                }
                case 1219095988: {
                    return this.addPriceComponent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 1417779175: {
                    return new String[]{"Reference"};
                }
                case 1219095988: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type Invoice.sequence");
            }
            if (name.equals("chargeItem")) {
                this.chargeItem = new Reference();
                return this.chargeItem;
            }
            if (name.equals("priceComponent")) {
                return this.addPriceComponent();
            }
            return super.addChild(name);
        }

        @Override
        public InvoiceLineItemComponent copy() {
            InvoiceLineItemComponent dst = new InvoiceLineItemComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            Reference reference = dst.chargeItem = this.chargeItem == null ? null : this.chargeItem.copy();
            if (this.priceComponent != null) {
                dst.priceComponent = new ArrayList<InvoiceLineItemPriceComponentComponent>();
                for (InvoiceLineItemPriceComponentComponent i : this.priceComponent) {
                    dst.priceComponent.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InvoiceLineItemComponent)) {
                return false;
            }
            InvoiceLineItemComponent o = (InvoiceLineItemComponent)other_;
            return InvoiceLineItemComponent.compareDeep(this.sequence, o.sequence, true) && InvoiceLineItemComponent.compareDeep(this.chargeItem, o.chargeItem, true) && InvoiceLineItemComponent.compareDeep(this.priceComponent, o.priceComponent, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InvoiceLineItemComponent)) {
                return false;
            }
            InvoiceLineItemComponent o = (InvoiceLineItemComponent)other_;
            return InvoiceLineItemComponent.compareValues(this.sequence, o.sequence, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.chargeItem, this.priceComponent});
        }

        @Override
        public String fhirType() {
            return "Invoice.lineItem";
        }
    }

    @Block
    public static class InvoiceParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of involevent in creation of this Invoice", formalDefinition="Describes the type of involvement (e.g. transcriptionist, creator etc.). If the invoice has been created automatically, the Participant may be a billing engine or another kind of device.")
        protected CodeableConcept role;
        @Child(name="actor", type={Practitioner.class, Organization.class, Patient.class, Device.class, RelatedPerson.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Individual who was involved", formalDefinition="The device, practitioner, etc. who performed or participated in the service.")
        protected Reference actor;
        protected Resource actorTarget;
        private static final long serialVersionUID = 805521719L;

        public InvoiceParticipantComponent() {
        }

        public InvoiceParticipantComponent(Reference actor) {
            this.actor = actor;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InvoiceParticipantComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public InvoiceParticipantComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InvoiceParticipantComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public InvoiceParticipantComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        public Resource getActorTarget() {
            return this.actorTarget;
        }

        public InvoiceParticipantComponent setActorTarget(Resource value) {
            this.actorTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("role", "CodeableConcept", "Describes the type of involvement (e.g. transcriptionist, creator etc.). If the invoice has been created automatically, the Participant may be a billing engine or another kind of device.", 0, 1, this.role));
            children.add(new Property("actor", "Reference(Practitioner|Organization|Patient|Device|RelatedPerson)", "The device, practitioner, etc. who performed or participated in the service.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property("role", "CodeableConcept", "Describes the type of involvement (e.g. transcriptionist, creator etc.). If the invoice has been created automatically, the Participant may be a billing engine or another kind of device.", 0, 1, this.role);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|Organization|Patient|Device|RelatedPerson)", "The device, practitioner, etc. who performed or participated in the service.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public InvoiceParticipantComponent copy() {
            InvoiceParticipantComponent dst = new InvoiceParticipantComponent();
            this.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InvoiceParticipantComponent)) {
                return false;
            }
            InvoiceParticipantComponent o = (InvoiceParticipantComponent)other_;
            return InvoiceParticipantComponent.compareDeep(this.role, o.role, true) && InvoiceParticipantComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InvoiceParticipantComponent)) {
                return false;
            }
            InvoiceParticipantComponent o = (InvoiceParticipantComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.role, this.actor});
        }

        @Override
        public String fhirType() {
            return "Invoice.participant";
        }
    }

    public static class InvoicePriceComponentTypeEnumFactory
    implements EnumFactory<InvoicePriceComponentType> {
        @Override
        public InvoicePriceComponentType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("base".equals(codeString)) {
                return InvoicePriceComponentType.BASE;
            }
            if ("surcharge".equals(codeString)) {
                return InvoicePriceComponentType.SURCHARGE;
            }
            if ("deduction".equals(codeString)) {
                return InvoicePriceComponentType.DEDUCTION;
            }
            if ("discount".equals(codeString)) {
                return InvoicePriceComponentType.DISCOUNT;
            }
            if ("tax".equals(codeString)) {
                return InvoicePriceComponentType.TAX;
            }
            if ("informational".equals(codeString)) {
                return InvoicePriceComponentType.INFORMATIONAL;
            }
            throw new IllegalArgumentException("Unknown InvoicePriceComponentType code '" + codeString + "'");
        }

        public Enumeration<InvoicePriceComponentType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<InvoicePriceComponentType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("base".equals(codeString)) {
                return new Enumeration<InvoicePriceComponentType>(this, InvoicePriceComponentType.BASE);
            }
            if ("surcharge".equals(codeString)) {
                return new Enumeration<InvoicePriceComponentType>(this, InvoicePriceComponentType.SURCHARGE);
            }
            if ("deduction".equals(codeString)) {
                return new Enumeration<InvoicePriceComponentType>(this, InvoicePriceComponentType.DEDUCTION);
            }
            if ("discount".equals(codeString)) {
                return new Enumeration<InvoicePriceComponentType>(this, InvoicePriceComponentType.DISCOUNT);
            }
            if ("tax".equals(codeString)) {
                return new Enumeration<InvoicePriceComponentType>(this, InvoicePriceComponentType.TAX);
            }
            if ("informational".equals(codeString)) {
                return new Enumeration<InvoicePriceComponentType>(this, InvoicePriceComponentType.INFORMATIONAL);
            }
            throw new FHIRException("Unknown InvoicePriceComponentType code '" + codeString + "'");
        }

        @Override
        public String toCode(InvoicePriceComponentType code) {
            if (code == InvoicePriceComponentType.BASE) {
                return "base";
            }
            if (code == InvoicePriceComponentType.SURCHARGE) {
                return "surcharge";
            }
            if (code == InvoicePriceComponentType.DEDUCTION) {
                return "deduction";
            }
            if (code == InvoicePriceComponentType.DISCOUNT) {
                return "discount";
            }
            if (code == InvoicePriceComponentType.TAX) {
                return "tax";
            }
            if (code == InvoicePriceComponentType.INFORMATIONAL) {
                return "informational";
            }
            return "?";
        }

        @Override
        public String toSystem(InvoicePriceComponentType code) {
            return code.getSystem();
        }
    }

    public static enum InvoicePriceComponentType {
        BASE,
        SURCHARGE,
        DEDUCTION,
        DISCOUNT,
        TAX,
        INFORMATIONAL,
        NULL;


        public static InvoicePriceComponentType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("base".equals(codeString)) {
                return BASE;
            }
            if ("surcharge".equals(codeString)) {
                return SURCHARGE;
            }
            if ("deduction".equals(codeString)) {
                return DEDUCTION;
            }
            if ("discount".equals(codeString)) {
                return DISCOUNT;
            }
            if ("tax".equals(codeString)) {
                return TAX;
            }
            if ("informational".equals(codeString)) {
                return INFORMATIONAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown InvoicePriceComponentType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case BASE: {
                    return "base";
                }
                case SURCHARGE: {
                    return "surcharge";
                }
                case DEDUCTION: {
                    return "deduction";
                }
                case DISCOUNT: {
                    return "discount";
                }
                case TAX: {
                    return "tax";
                }
                case INFORMATIONAL: {
                    return "informational";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case BASE: {
                    return "http://hl7.org/fhir/invoice-priceComponentType";
                }
                case SURCHARGE: {
                    return "http://hl7.org/fhir/invoice-priceComponentType";
                }
                case DEDUCTION: {
                    return "http://hl7.org/fhir/invoice-priceComponentType";
                }
                case DISCOUNT: {
                    return "http://hl7.org/fhir/invoice-priceComponentType";
                }
                case TAX: {
                    return "http://hl7.org/fhir/invoice-priceComponentType";
                }
                case INFORMATIONAL: {
                    return "http://hl7.org/fhir/invoice-priceComponentType";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case BASE: {
                    return "the amount is the base price used for calculating the total price before applying surcharges, discount or taxes";
                }
                case SURCHARGE: {
                    return "the amount is a surcharge applied on the base price";
                }
                case DEDUCTION: {
                    return "the amount is a deduction applied on the base price";
                }
                case DISCOUNT: {
                    return "the amount is a discount applied on the base price";
                }
                case TAX: {
                    return "the amount is the tax component of the total price";
                }
                case INFORMATIONAL: {
                    return "the amount is of informational character, it has not been applied in the calculation of the total price";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case BASE: {
                    return "base price";
                }
                case SURCHARGE: {
                    return "surcharge";
                }
                case DEDUCTION: {
                    return "deduction";
                }
                case DISCOUNT: {
                    return "discount";
                }
                case TAX: {
                    return "tax";
                }
                case INFORMATIONAL: {
                    return "informational";
                }
            }
            return "?";
        }
    }

    public static class InvoiceStatusEnumFactory
    implements EnumFactory<InvoiceStatus> {
        @Override
        public InvoiceStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return InvoiceStatus.DRAFT;
            }
            if ("issued".equals(codeString)) {
                return InvoiceStatus.ISSUED;
            }
            if ("balanced".equals(codeString)) {
                return InvoiceStatus.BALANCED;
            }
            if ("cancelled".equals(codeString)) {
                return InvoiceStatus.CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return InvoiceStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown InvoiceStatus code '" + codeString + "'");
        }

        public Enumeration<InvoiceStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<InvoiceStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<InvoiceStatus>(this, InvoiceStatus.DRAFT);
            }
            if ("issued".equals(codeString)) {
                return new Enumeration<InvoiceStatus>(this, InvoiceStatus.ISSUED);
            }
            if ("balanced".equals(codeString)) {
                return new Enumeration<InvoiceStatus>(this, InvoiceStatus.BALANCED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<InvoiceStatus>(this, InvoiceStatus.CANCELLED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<InvoiceStatus>(this, InvoiceStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown InvoiceStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(InvoiceStatus code) {
            if (code == InvoiceStatus.DRAFT) {
                return "draft";
            }
            if (code == InvoiceStatus.ISSUED) {
                return "issued";
            }
            if (code == InvoiceStatus.BALANCED) {
                return "balanced";
            }
            if (code == InvoiceStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == InvoiceStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(InvoiceStatus code) {
            return code.getSystem();
        }
    }

    public static enum InvoiceStatus {
        DRAFT,
        ISSUED,
        BALANCED,
        CANCELLED,
        ENTEREDINERROR,
        NULL;


        public static InvoiceStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("issued".equals(codeString)) {
                return ISSUED;
            }
            if ("balanced".equals(codeString)) {
                return BALANCED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown InvoiceStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case ISSUED: {
                    return "issued";
                }
                case BALANCED: {
                    return "balanced";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/invoice-status";
                }
                case ISSUED: {
                    return "http://hl7.org/fhir/invoice-status";
                }
                case BALANCED: {
                    return "http://hl7.org/fhir/invoice-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/invoice-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/invoice-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "the invoice has been prepared but not yet finalized";
                }
                case ISSUED: {
                    return "the invoice has been finalized and sent to the recipient";
                }
                case BALANCED: {
                    return "the invoice has been balaced / completely paid";
                }
                case CANCELLED: {
                    return "the invoice was cancelled";
                }
                case ENTEREDINERROR: {
                    return "the invoice was determined as entered in error before it was issued";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case ISSUED: {
                    return "issued";
                }
                case BALANCED: {
                    return "balanced";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered in error";
                }
            }
            return "?";
        }
    }
}

