/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.ProdCharacteristic;
import org.hl7.fhir.r4.model.ProductShelfLife;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicinalProductDeviceSpec", profile="http://hl7.org/fhir/Profile/MedicinalProductDeviceSpec")
public class MedicinalProductDeviceSpec
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier", formalDefinition="Business identifier.")
    protected Identifier identifier;
    @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The type of device", formalDefinition="The type of device.")
    protected CodeableConcept type;
    @Child(name="tradeName", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Trade name of the device, where applicable", formalDefinition="Trade name of the device, where applicable.")
    protected StringType tradeName;
    @Child(name="quantity", type={Quantity.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The quantity of the device present in the packaging of a medicinal product", formalDefinition="The quantity of the device present in the packaging of a medicinal product.")
    protected Quantity quantity;
    @Child(name="listingNumber", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Device listing number", formalDefinition="Device listing number.")
    protected StringType listingNumber;
    @Child(name="modelNumber", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Device model or reference number", formalDefinition="Device model or reference number.")
    protected StringType modelNumber;
    @Child(name="sterilityIndicator", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether the device is supplied as sterile", formalDefinition="Whether the device is supplied as sterile.")
    protected CodeableConcept sterilityIndicator;
    @Child(name="sterilisationRequirement", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether the device must be sterilised before use", formalDefinition="Whether the device must be sterilised before use.")
    protected CodeableConcept sterilisationRequirement;
    @Child(name="usage", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Usage pattern including the number of times that the device may be used", formalDefinition="Usage pattern including the number of times that the device may be used.")
    protected CodeableConcept usage;
    @Child(name="nomenclature", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A nomenclature term for the device", formalDefinition="A nomenclature term for the device.")
    protected List<CodeableConcept> nomenclature;
    @Child(name="shelfLife", type={ProductShelfLife.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Shelf Life and storage information", formalDefinition="Shelf Life and storage information.")
    protected List<ProductShelfLife> shelfLife;
    @Child(name="physicalCharacteristics", type={ProdCharacteristic.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Dimensions, color etc.", formalDefinition="Dimensions, color etc.")
    protected ProdCharacteristic physicalCharacteristics;
    @Child(name="otherCharacteristics", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Other codeable characteristics", formalDefinition="Other codeable characteristics.")
    protected List<CodeableConcept> otherCharacteristics;
    @Child(name="batchIdentifier", type={Identifier.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Batch number or expiry date of a device", formalDefinition="Batch number or expiry date of a device.")
    protected List<Identifier> batchIdentifier;
    @Child(name="manufacturer", type={Organization.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer of this Device", formalDefinition="Manufacturer of this Device.")
    protected List<Reference> manufacturer;
    protected List<Organization> manufacturerTarget;
    @Child(name="material", type={}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A substance used to create the material(s) of which the device is made", formalDefinition="A substance used to create the material(s) of which the device is made.")
    protected List<MedicinalProductDeviceSpecMaterialComponent> material;
    private static final long serialVersionUID = 839400430L;

    public MedicinalProductDeviceSpec() {
    }

    public MedicinalProductDeviceSpec(CodeableConcept type) {
        this.type = type;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDeviceSpec.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public MedicinalProductDeviceSpec setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDeviceSpec.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public MedicinalProductDeviceSpec setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public StringType getTradeNameElement() {
        if (this.tradeName == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDeviceSpec.tradeName");
            }
            if (Configuration.doAutoCreate()) {
                this.tradeName = new StringType();
            }
        }
        return this.tradeName;
    }

    public boolean hasTradeNameElement() {
        return this.tradeName != null && !this.tradeName.isEmpty();
    }

    public boolean hasTradeName() {
        return this.tradeName != null && !this.tradeName.isEmpty();
    }

    public MedicinalProductDeviceSpec setTradeNameElement(StringType value) {
        this.tradeName = value;
        return this;
    }

    public String getTradeName() {
        return this.tradeName == null ? null : (String)this.tradeName.getValue();
    }

    public MedicinalProductDeviceSpec setTradeName(String value) {
        if (Utilities.noString((String)value)) {
            this.tradeName = null;
        } else {
            if (this.tradeName == null) {
                this.tradeName = new StringType();
            }
            this.tradeName.setValue(value);
        }
        return this;
    }

    public Quantity getQuantity() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDeviceSpec.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new Quantity();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public MedicinalProductDeviceSpec setQuantity(Quantity value) {
        this.quantity = value;
        return this;
    }

    public StringType getListingNumberElement() {
        if (this.listingNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDeviceSpec.listingNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.listingNumber = new StringType();
            }
        }
        return this.listingNumber;
    }

    public boolean hasListingNumberElement() {
        return this.listingNumber != null && !this.listingNumber.isEmpty();
    }

    public boolean hasListingNumber() {
        return this.listingNumber != null && !this.listingNumber.isEmpty();
    }

    public MedicinalProductDeviceSpec setListingNumberElement(StringType value) {
        this.listingNumber = value;
        return this;
    }

    public String getListingNumber() {
        return this.listingNumber == null ? null : (String)this.listingNumber.getValue();
    }

    public MedicinalProductDeviceSpec setListingNumber(String value) {
        if (Utilities.noString((String)value)) {
            this.listingNumber = null;
        } else {
            if (this.listingNumber == null) {
                this.listingNumber = new StringType();
            }
            this.listingNumber.setValue(value);
        }
        return this;
    }

    public StringType getModelNumberElement() {
        if (this.modelNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDeviceSpec.modelNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.modelNumber = new StringType();
            }
        }
        return this.modelNumber;
    }

    public boolean hasModelNumberElement() {
        return this.modelNumber != null && !this.modelNumber.isEmpty();
    }

    public boolean hasModelNumber() {
        return this.modelNumber != null && !this.modelNumber.isEmpty();
    }

    public MedicinalProductDeviceSpec setModelNumberElement(StringType value) {
        this.modelNumber = value;
        return this;
    }

    public String getModelNumber() {
        return this.modelNumber == null ? null : (String)this.modelNumber.getValue();
    }

    public MedicinalProductDeviceSpec setModelNumber(String value) {
        if (Utilities.noString((String)value)) {
            this.modelNumber = null;
        } else {
            if (this.modelNumber == null) {
                this.modelNumber = new StringType();
            }
            this.modelNumber.setValue(value);
        }
        return this;
    }

    public CodeableConcept getSterilityIndicator() {
        if (this.sterilityIndicator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDeviceSpec.sterilityIndicator");
            }
            if (Configuration.doAutoCreate()) {
                this.sterilityIndicator = new CodeableConcept();
            }
        }
        return this.sterilityIndicator;
    }

    public boolean hasSterilityIndicator() {
        return this.sterilityIndicator != null && !this.sterilityIndicator.isEmpty();
    }

    public MedicinalProductDeviceSpec setSterilityIndicator(CodeableConcept value) {
        this.sterilityIndicator = value;
        return this;
    }

    public CodeableConcept getSterilisationRequirement() {
        if (this.sterilisationRequirement == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDeviceSpec.sterilisationRequirement");
            }
            if (Configuration.doAutoCreate()) {
                this.sterilisationRequirement = new CodeableConcept();
            }
        }
        return this.sterilisationRequirement;
    }

    public boolean hasSterilisationRequirement() {
        return this.sterilisationRequirement != null && !this.sterilisationRequirement.isEmpty();
    }

    public MedicinalProductDeviceSpec setSterilisationRequirement(CodeableConcept value) {
        this.sterilisationRequirement = value;
        return this;
    }

    public CodeableConcept getUsage() {
        if (this.usage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDeviceSpec.usage");
            }
            if (Configuration.doAutoCreate()) {
                this.usage = new CodeableConcept();
            }
        }
        return this.usage;
    }

    public boolean hasUsage() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public MedicinalProductDeviceSpec setUsage(CodeableConcept value) {
        this.usage = value;
        return this;
    }

    public List<CodeableConcept> getNomenclature() {
        if (this.nomenclature == null) {
            this.nomenclature = new ArrayList<CodeableConcept>();
        }
        return this.nomenclature;
    }

    public MedicinalProductDeviceSpec setNomenclature(List<CodeableConcept> theNomenclature) {
        this.nomenclature = theNomenclature;
        return this;
    }

    public boolean hasNomenclature() {
        if (this.nomenclature == null) {
            return false;
        }
        for (CodeableConcept item : this.nomenclature) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addNomenclature() {
        CodeableConcept t = new CodeableConcept();
        if (this.nomenclature == null) {
            this.nomenclature = new ArrayList<CodeableConcept>();
        }
        this.nomenclature.add(t);
        return t;
    }

    public MedicinalProductDeviceSpec addNomenclature(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.nomenclature == null) {
            this.nomenclature = new ArrayList<CodeableConcept>();
        }
        this.nomenclature.add(t);
        return this;
    }

    public CodeableConcept getNomenclatureFirstRep() {
        if (this.getNomenclature().isEmpty()) {
            this.addNomenclature();
        }
        return this.getNomenclature().get(0);
    }

    public List<ProductShelfLife> getShelfLife() {
        if (this.shelfLife == null) {
            this.shelfLife = new ArrayList<ProductShelfLife>();
        }
        return this.shelfLife;
    }

    public MedicinalProductDeviceSpec setShelfLife(List<ProductShelfLife> theShelfLife) {
        this.shelfLife = theShelfLife;
        return this;
    }

    public boolean hasShelfLife() {
        if (this.shelfLife == null) {
            return false;
        }
        for (ProductShelfLife item : this.shelfLife) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProductShelfLife addShelfLife() {
        ProductShelfLife t = new ProductShelfLife();
        if (this.shelfLife == null) {
            this.shelfLife = new ArrayList<ProductShelfLife>();
        }
        this.shelfLife.add(t);
        return t;
    }

    public MedicinalProductDeviceSpec addShelfLife(ProductShelfLife t) {
        if (t == null) {
            return this;
        }
        if (this.shelfLife == null) {
            this.shelfLife = new ArrayList<ProductShelfLife>();
        }
        this.shelfLife.add(t);
        return this;
    }

    public ProductShelfLife getShelfLifeFirstRep() {
        if (this.getShelfLife().isEmpty()) {
            this.addShelfLife();
        }
        return this.getShelfLife().get(0);
    }

    public ProdCharacteristic getPhysicalCharacteristics() {
        if (this.physicalCharacteristics == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDeviceSpec.physicalCharacteristics");
            }
            if (Configuration.doAutoCreate()) {
                this.physicalCharacteristics = new ProdCharacteristic();
            }
        }
        return this.physicalCharacteristics;
    }

    public boolean hasPhysicalCharacteristics() {
        return this.physicalCharacteristics != null && !this.physicalCharacteristics.isEmpty();
    }

    public MedicinalProductDeviceSpec setPhysicalCharacteristics(ProdCharacteristic value) {
        this.physicalCharacteristics = value;
        return this;
    }

    public List<CodeableConcept> getOtherCharacteristics() {
        if (this.otherCharacteristics == null) {
            this.otherCharacteristics = new ArrayList<CodeableConcept>();
        }
        return this.otherCharacteristics;
    }

    public MedicinalProductDeviceSpec setOtherCharacteristics(List<CodeableConcept> theOtherCharacteristics) {
        this.otherCharacteristics = theOtherCharacteristics;
        return this;
    }

    public boolean hasOtherCharacteristics() {
        if (this.otherCharacteristics == null) {
            return false;
        }
        for (CodeableConcept item : this.otherCharacteristics) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addOtherCharacteristics() {
        CodeableConcept t = new CodeableConcept();
        if (this.otherCharacteristics == null) {
            this.otherCharacteristics = new ArrayList<CodeableConcept>();
        }
        this.otherCharacteristics.add(t);
        return t;
    }

    public MedicinalProductDeviceSpec addOtherCharacteristics(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.otherCharacteristics == null) {
            this.otherCharacteristics = new ArrayList<CodeableConcept>();
        }
        this.otherCharacteristics.add(t);
        return this;
    }

    public CodeableConcept getOtherCharacteristicsFirstRep() {
        if (this.getOtherCharacteristics().isEmpty()) {
            this.addOtherCharacteristics();
        }
        return this.getOtherCharacteristics().get(0);
    }

    public List<Identifier> getBatchIdentifier() {
        if (this.batchIdentifier == null) {
            this.batchIdentifier = new ArrayList<Identifier>();
        }
        return this.batchIdentifier;
    }

    public MedicinalProductDeviceSpec setBatchIdentifier(List<Identifier> theBatchIdentifier) {
        this.batchIdentifier = theBatchIdentifier;
        return this;
    }

    public boolean hasBatchIdentifier() {
        if (this.batchIdentifier == null) {
            return false;
        }
        for (Identifier item : this.batchIdentifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addBatchIdentifier() {
        Identifier t = new Identifier();
        if (this.batchIdentifier == null) {
            this.batchIdentifier = new ArrayList<Identifier>();
        }
        this.batchIdentifier.add(t);
        return t;
    }

    public MedicinalProductDeviceSpec addBatchIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.batchIdentifier == null) {
            this.batchIdentifier = new ArrayList<Identifier>();
        }
        this.batchIdentifier.add(t);
        return this;
    }

    public Identifier getBatchIdentifierFirstRep() {
        if (this.getBatchIdentifier().isEmpty()) {
            this.addBatchIdentifier();
        }
        return this.getBatchIdentifier().get(0);
    }

    public List<Reference> getManufacturer() {
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        return this.manufacturer;
    }

    public MedicinalProductDeviceSpec setManufacturer(List<Reference> theManufacturer) {
        this.manufacturer = theManufacturer;
        return this;
    }

    public boolean hasManufacturer() {
        if (this.manufacturer == null) {
            return false;
        }
        for (Reference item : this.manufacturer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addManufacturer() {
        Reference t = new Reference();
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return t;
    }

    public MedicinalProductDeviceSpec addManufacturer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return this;
    }

    public Reference getManufacturerFirstRep() {
        if (this.getManufacturer().isEmpty()) {
            this.addManufacturer();
        }
        return this.getManufacturer().get(0);
    }

    @Deprecated
    public List<Organization> getManufacturerTarget() {
        if (this.manufacturerTarget == null) {
            this.manufacturerTarget = new ArrayList<Organization>();
        }
        return this.manufacturerTarget;
    }

    @Deprecated
    public Organization addManufacturerTarget() {
        Organization r = new Organization();
        if (this.manufacturerTarget == null) {
            this.manufacturerTarget = new ArrayList<Organization>();
        }
        this.manufacturerTarget.add(r);
        return r;
    }

    public List<MedicinalProductDeviceSpecMaterialComponent> getMaterial() {
        if (this.material == null) {
            this.material = new ArrayList<MedicinalProductDeviceSpecMaterialComponent>();
        }
        return this.material;
    }

    public MedicinalProductDeviceSpec setMaterial(List<MedicinalProductDeviceSpecMaterialComponent> theMaterial) {
        this.material = theMaterial;
        return this;
    }

    public boolean hasMaterial() {
        if (this.material == null) {
            return false;
        }
        for (MedicinalProductDeviceSpecMaterialComponent item : this.material) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductDeviceSpecMaterialComponent addMaterial() {
        MedicinalProductDeviceSpecMaterialComponent t = new MedicinalProductDeviceSpecMaterialComponent();
        if (this.material == null) {
            this.material = new ArrayList<MedicinalProductDeviceSpecMaterialComponent>();
        }
        this.material.add(t);
        return t;
    }

    public MedicinalProductDeviceSpec addMaterial(MedicinalProductDeviceSpecMaterialComponent t) {
        if (t == null) {
            return this;
        }
        if (this.material == null) {
            this.material = new ArrayList<MedicinalProductDeviceSpecMaterialComponent>();
        }
        this.material.add(t);
        return this;
    }

    public MedicinalProductDeviceSpecMaterialComponent getMaterialFirstRep() {
        if (this.getMaterial().isEmpty()) {
            this.addMaterial();
        }
        return this.getMaterial().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("identifier", "Identifier", "Business identifier.", 0, 1, this.identifier));
        children.add(new Property("type", "CodeableConcept", "The type of device.", 0, 1, this.type));
        children.add(new Property("tradeName", "string", "Trade name of the device, where applicable.", 0, 1, this.tradeName));
        children.add(new Property("quantity", "Quantity", "The quantity of the device present in the packaging of a medicinal product.", 0, 1, this.quantity));
        children.add(new Property("listingNumber", "string", "Device listing number.", 0, 1, this.listingNumber));
        children.add(new Property("modelNumber", "string", "Device model or reference number.", 0, 1, this.modelNumber));
        children.add(new Property("sterilityIndicator", "CodeableConcept", "Whether the device is supplied as sterile.", 0, 1, this.sterilityIndicator));
        children.add(new Property("sterilisationRequirement", "CodeableConcept", "Whether the device must be sterilised before use.", 0, 1, this.sterilisationRequirement));
        children.add(new Property("usage", "CodeableConcept", "Usage pattern including the number of times that the device may be used.", 0, 1, this.usage));
        children.add(new Property("nomenclature", "CodeableConcept", "A nomenclature term for the device.", 0, Integer.MAX_VALUE, this.nomenclature));
        children.add(new Property("shelfLife", "ProductShelfLife", "Shelf Life and storage information.", 0, Integer.MAX_VALUE, this.shelfLife));
        children.add(new Property("physicalCharacteristics", "ProdCharacteristic", "Dimensions, color etc.", 0, 1, this.physicalCharacteristics));
        children.add(new Property("otherCharacteristics", "CodeableConcept", "Other codeable characteristics.", 0, Integer.MAX_VALUE, this.otherCharacteristics));
        children.add(new Property("batchIdentifier", "Identifier", "Batch number or expiry date of a device.", 0, Integer.MAX_VALUE, this.batchIdentifier));
        children.add(new Property("manufacturer", "Reference(Organization)", "Manufacturer of this Device.", 0, Integer.MAX_VALUE, this.manufacturer));
        children.add(new Property("material", "", "A substance used to create the material(s) of which the device is made.", 0, Integer.MAX_VALUE, this.material));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property("identifier", "Identifier", "Business identifier.", 0, 1, this.identifier);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "The type of device.", 0, 1, this.type);
            }
            case 752717327: {
                return new Property("tradeName", "string", "Trade name of the device, where applicable.", 0, 1, this.tradeName);
            }
            case -1285004149: {
                return new Property("quantity", "Quantity", "The quantity of the device present in the packaging of a medicinal product.", 0, 1, this.quantity);
            }
            case -1571189011: {
                return new Property("listingNumber", "string", "Device listing number.", 0, 1, this.listingNumber);
            }
            case 346619858: {
                return new Property("modelNumber", "string", "Device model or reference number.", 0, 1, this.modelNumber);
            }
            case -2093506574: {
                return new Property("sterilityIndicator", "CodeableConcept", "Whether the device is supplied as sterile.", 0, 1, this.sterilityIndicator);
            }
            case 693339497: {
                return new Property("sterilisationRequirement", "CodeableConcept", "Whether the device must be sterilised before use.", 0, 1, this.sterilisationRequirement);
            }
            case 111574433: {
                return new Property("usage", "CodeableConcept", "Usage pattern including the number of times that the device may be used.", 0, 1, this.usage);
            }
            case 895910775: {
                return new Property("nomenclature", "CodeableConcept", "A nomenclature term for the device.", 0, Integer.MAX_VALUE, this.nomenclature);
            }
            case 1796889670: {
                return new Property("shelfLife", "ProductShelfLife", "Shelf Life and storage information.", 0, Integer.MAX_VALUE, this.shelfLife);
            }
            case -1599676319: {
                return new Property("physicalCharacteristics", "ProdCharacteristic", "Dimensions, color etc.", 0, 1, this.physicalCharacteristics);
            }
            case 722135304: {
                return new Property("otherCharacteristics", "CodeableConcept", "Other codeable characteristics.", 0, Integer.MAX_VALUE, this.otherCharacteristics);
            }
            case -1688395901: {
                return new Property("batchIdentifier", "Identifier", "Batch number or expiry date of a device.", 0, Integer.MAX_VALUE, this.batchIdentifier);
            }
            case -1969347631: {
                return new Property("manufacturer", "Reference(Organization)", "Manufacturer of this Device.", 0, Integer.MAX_VALUE, this.manufacturer);
            }
            case 299066663: {
                return new Property("material", "", "A substance used to create the material(s) of which the device is made.", 0, Integer.MAX_VALUE, this.material);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case 752717327: {
                Base[] baseArray;
                if (this.tradeName == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.tradeName;
                }
                return baseArray;
            }
            case -1285004149: {
                Base[] baseArray;
                if (this.quantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.quantity;
                }
                return baseArray;
            }
            case -1571189011: {
                Base[] baseArray;
                if (this.listingNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.listingNumber;
                }
                return baseArray;
            }
            case 346619858: {
                Base[] baseArray;
                if (this.modelNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.modelNumber;
                }
                return baseArray;
            }
            case -2093506574: {
                Base[] baseArray;
                if (this.sterilityIndicator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.sterilityIndicator;
                }
                return baseArray;
            }
            case 693339497: {
                Base[] baseArray;
                if (this.sterilisationRequirement == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.sterilisationRequirement;
                }
                return baseArray;
            }
            case 111574433: {
                Base[] baseArray;
                if (this.usage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.usage;
                }
                return baseArray;
            }
            case 895910775: {
                return this.nomenclature == null ? new Base[]{} : this.nomenclature.toArray(new Base[this.nomenclature.size()]);
            }
            case 1796889670: {
                return this.shelfLife == null ? new Base[]{} : this.shelfLife.toArray(new Base[this.shelfLife.size()]);
            }
            case -1599676319: {
                Base[] baseArray;
                if (this.physicalCharacteristics == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.physicalCharacteristics;
                }
                return baseArray;
            }
            case 722135304: {
                return this.otherCharacteristics == null ? new Base[]{} : this.otherCharacteristics.toArray(new Base[this.otherCharacteristics.size()]);
            }
            case -1688395901: {
                return this.batchIdentifier == null ? new Base[]{} : this.batchIdentifier.toArray(new Base[this.batchIdentifier.size()]);
            }
            case -1969347631: {
                return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
            }
            case 299066663: {
                return this.material == null ? new Base[]{} : this.material.toArray(new Base[this.material.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case 752717327: {
                this.tradeName = this.castToString(value);
                return value;
            }
            case -1285004149: {
                this.quantity = this.castToQuantity(value);
                return value;
            }
            case -1571189011: {
                this.listingNumber = this.castToString(value);
                return value;
            }
            case 346619858: {
                this.modelNumber = this.castToString(value);
                return value;
            }
            case -2093506574: {
                this.sterilityIndicator = this.castToCodeableConcept(value);
                return value;
            }
            case 693339497: {
                this.sterilisationRequirement = this.castToCodeableConcept(value);
                return value;
            }
            case 111574433: {
                this.usage = this.castToCodeableConcept(value);
                return value;
            }
            case 895910775: {
                this.getNomenclature().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1796889670: {
                this.getShelfLife().add(this.castToProductShelfLife(value));
                return value;
            }
            case -1599676319: {
                this.physicalCharacteristics = this.castToProdCharacteristic(value);
                return value;
            }
            case 722135304: {
                this.getOtherCharacteristics().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1688395901: {
                this.getBatchIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1969347631: {
                this.getManufacturer().add(this.castToReference(value));
                return value;
            }
            case 299066663: {
                this.getMaterial().add((MedicinalProductDeviceSpecMaterialComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("tradeName")) {
            this.tradeName = this.castToString(value);
        } else if (name.equals("quantity")) {
            this.quantity = this.castToQuantity(value);
        } else if (name.equals("listingNumber")) {
            this.listingNumber = this.castToString(value);
        } else if (name.equals("modelNumber")) {
            this.modelNumber = this.castToString(value);
        } else if (name.equals("sterilityIndicator")) {
            this.sterilityIndicator = this.castToCodeableConcept(value);
        } else if (name.equals("sterilisationRequirement")) {
            this.sterilisationRequirement = this.castToCodeableConcept(value);
        } else if (name.equals("usage")) {
            this.usage = this.castToCodeableConcept(value);
        } else if (name.equals("nomenclature")) {
            this.getNomenclature().add(this.castToCodeableConcept(value));
        } else if (name.equals("shelfLife")) {
            this.getShelfLife().add(this.castToProductShelfLife(value));
        } else if (name.equals("physicalCharacteristics")) {
            this.physicalCharacteristics = this.castToProdCharacteristic(value);
        } else if (name.equals("otherCharacteristics")) {
            this.getOtherCharacteristics().add(this.castToCodeableConcept(value));
        } else if (name.equals("batchIdentifier")) {
            this.getBatchIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("manufacturer")) {
            this.getManufacturer().add(this.castToReference(value));
        } else if (name.equals("material")) {
            this.getMaterial().add((MedicinalProductDeviceSpecMaterialComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 3575610: {
                return this.getType();
            }
            case 752717327: {
                return this.getTradeNameElement();
            }
            case -1285004149: {
                return this.getQuantity();
            }
            case -1571189011: {
                return this.getListingNumberElement();
            }
            case 346619858: {
                return this.getModelNumberElement();
            }
            case -2093506574: {
                return this.getSterilityIndicator();
            }
            case 693339497: {
                return this.getSterilisationRequirement();
            }
            case 111574433: {
                return this.getUsage();
            }
            case 895910775: {
                return this.addNomenclature();
            }
            case 1796889670: {
                return this.addShelfLife();
            }
            case -1599676319: {
                return this.getPhysicalCharacteristics();
            }
            case 722135304: {
                return this.addOtherCharacteristics();
            }
            case -1688395901: {
                return this.addBatchIdentifier();
            }
            case -1969347631: {
                return this.addManufacturer();
            }
            case 299066663: {
                return this.addMaterial();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 752717327: {
                return new String[]{"string"};
            }
            case -1285004149: {
                return new String[]{"Quantity"};
            }
            case -1571189011: {
                return new String[]{"string"};
            }
            case 346619858: {
                return new String[]{"string"};
            }
            case -2093506574: {
                return new String[]{"CodeableConcept"};
            }
            case 693339497: {
                return new String[]{"CodeableConcept"};
            }
            case 111574433: {
                return new String[]{"CodeableConcept"};
            }
            case 895910775: {
                return new String[]{"CodeableConcept"};
            }
            case 1796889670: {
                return new String[]{"ProductShelfLife"};
            }
            case -1599676319: {
                return new String[]{"ProdCharacteristic"};
            }
            case 722135304: {
                return new String[]{"CodeableConcept"};
            }
            case -1688395901: {
                return new String[]{"Identifier"};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case 299066663: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("tradeName")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicinalProductDeviceSpec.tradeName");
        }
        if (name.equals("quantity")) {
            this.quantity = new Quantity();
            return this.quantity;
        }
        if (name.equals("listingNumber")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicinalProductDeviceSpec.listingNumber");
        }
        if (name.equals("modelNumber")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicinalProductDeviceSpec.modelNumber");
        }
        if (name.equals("sterilityIndicator")) {
            this.sterilityIndicator = new CodeableConcept();
            return this.sterilityIndicator;
        }
        if (name.equals("sterilisationRequirement")) {
            this.sterilisationRequirement = new CodeableConcept();
            return this.sterilisationRequirement;
        }
        if (name.equals("usage")) {
            this.usage = new CodeableConcept();
            return this.usage;
        }
        if (name.equals("nomenclature")) {
            return this.addNomenclature();
        }
        if (name.equals("shelfLife")) {
            return this.addShelfLife();
        }
        if (name.equals("physicalCharacteristics")) {
            this.physicalCharacteristics = new ProdCharacteristic();
            return this.physicalCharacteristics;
        }
        if (name.equals("otherCharacteristics")) {
            return this.addOtherCharacteristics();
        }
        if (name.equals("batchIdentifier")) {
            return this.addBatchIdentifier();
        }
        if (name.equals("manufacturer")) {
            return this.addManufacturer();
        }
        if (name.equals("material")) {
            return this.addMaterial();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicinalProductDeviceSpec";
    }

    @Override
    public MedicinalProductDeviceSpec copy() {
        MedicinalProductDeviceSpec dst = new MedicinalProductDeviceSpec();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.tradeName = this.tradeName == null ? null : this.tradeName.copy();
        dst.quantity = this.quantity == null ? null : this.quantity.copy();
        dst.listingNumber = this.listingNumber == null ? null : this.listingNumber.copy();
        dst.modelNumber = this.modelNumber == null ? null : this.modelNumber.copy();
        dst.sterilityIndicator = this.sterilityIndicator == null ? null : this.sterilityIndicator.copy();
        dst.sterilisationRequirement = this.sterilisationRequirement == null ? null : this.sterilisationRequirement.copy();
        CodeableConcept codeableConcept = dst.usage = this.usage == null ? null : this.usage.copy();
        if (this.nomenclature != null) {
            dst.nomenclature = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.nomenclature) {
                dst.nomenclature.add(codeableConcept2.copy());
            }
        }
        if (this.shelfLife != null) {
            dst.shelfLife = new ArrayList<ProductShelfLife>();
            for (ProductShelfLife productShelfLife : this.shelfLife) {
                dst.shelfLife.add(productShelfLife.copy());
            }
        }
        ProdCharacteristic prodCharacteristic = dst.physicalCharacteristics = this.physicalCharacteristics == null ? null : this.physicalCharacteristics.copy();
        if (this.otherCharacteristics != null) {
            dst.otherCharacteristics = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.otherCharacteristics) {
                dst.otherCharacteristics.add(codeableConcept3.copy());
            }
        }
        if (this.batchIdentifier != null) {
            dst.batchIdentifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.batchIdentifier) {
                dst.batchIdentifier.add(identifier.copy());
            }
        }
        if (this.manufacturer != null) {
            dst.manufacturer = new ArrayList<Reference>();
            for (Reference reference : this.manufacturer) {
                dst.manufacturer.add(reference.copy());
            }
        }
        if (this.material != null) {
            dst.material = new ArrayList<MedicinalProductDeviceSpecMaterialComponent>();
            for (MedicinalProductDeviceSpecMaterialComponent medicinalProductDeviceSpecMaterialComponent : this.material) {
                dst.material.add(medicinalProductDeviceSpecMaterialComponent.copy());
            }
        }
        return dst;
    }

    protected MedicinalProductDeviceSpec typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductDeviceSpec)) {
            return false;
        }
        MedicinalProductDeviceSpec o = (MedicinalProductDeviceSpec)other_;
        return MedicinalProductDeviceSpec.compareDeep(this.identifier, o.identifier, true) && MedicinalProductDeviceSpec.compareDeep(this.type, o.type, true) && MedicinalProductDeviceSpec.compareDeep(this.tradeName, o.tradeName, true) && MedicinalProductDeviceSpec.compareDeep(this.quantity, o.quantity, true) && MedicinalProductDeviceSpec.compareDeep(this.listingNumber, o.listingNumber, true) && MedicinalProductDeviceSpec.compareDeep(this.modelNumber, o.modelNumber, true) && MedicinalProductDeviceSpec.compareDeep(this.sterilityIndicator, o.sterilityIndicator, true) && MedicinalProductDeviceSpec.compareDeep(this.sterilisationRequirement, o.sterilisationRequirement, true) && MedicinalProductDeviceSpec.compareDeep(this.usage, o.usage, true) && MedicinalProductDeviceSpec.compareDeep(this.nomenclature, o.nomenclature, true) && MedicinalProductDeviceSpec.compareDeep(this.shelfLife, o.shelfLife, true) && MedicinalProductDeviceSpec.compareDeep(this.physicalCharacteristics, o.physicalCharacteristics, true) && MedicinalProductDeviceSpec.compareDeep(this.otherCharacteristics, o.otherCharacteristics, true) && MedicinalProductDeviceSpec.compareDeep(this.batchIdentifier, o.batchIdentifier, true) && MedicinalProductDeviceSpec.compareDeep(this.manufacturer, o.manufacturer, true) && MedicinalProductDeviceSpec.compareDeep(this.material, o.material, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductDeviceSpec)) {
            return false;
        }
        MedicinalProductDeviceSpec o = (MedicinalProductDeviceSpec)other_;
        return MedicinalProductDeviceSpec.compareValues(this.tradeName, o.tradeName, true) && MedicinalProductDeviceSpec.compareValues(this.listingNumber, o.listingNumber, true) && MedicinalProductDeviceSpec.compareValues(this.modelNumber, o.modelNumber, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.tradeName, this.quantity, this.listingNumber, this.modelNumber, this.sterilityIndicator, this.sterilisationRequirement, this.usage, this.nomenclature, this.shelfLife, this.physicalCharacteristics, this.otherCharacteristics, this.batchIdentifier, this.manufacturer, this.material});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicinalProductDeviceSpec;
    }

    @Block
    public static class MedicinalProductDeviceSpecMaterialComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="substance", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The substance", formalDefinition="The substance.")
        protected CodeableConcept substance;
        @Child(name="alternate", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Indicates an alternative material of the device", formalDefinition="Indicates an alternative material of the device.")
        protected BooleanType alternate;
        @Child(name="allergenicIndicator", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Whether the substance is a known or suspected allergen", formalDefinition="Whether the substance is a known or suspected allergen.")
        protected BooleanType allergenicIndicator;
        private static final long serialVersionUID = 1232736508L;

        public MedicinalProductDeviceSpecMaterialComponent() {
        }

        public MedicinalProductDeviceSpecMaterialComponent(CodeableConcept substance) {
            this.substance = substance;
        }

        public CodeableConcept getSubstance() {
            if (this.substance == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDeviceSpecMaterialComponent.substance");
                }
                if (Configuration.doAutoCreate()) {
                    this.substance = new CodeableConcept();
                }
            }
            return this.substance;
        }

        public boolean hasSubstance() {
            return this.substance != null && !this.substance.isEmpty();
        }

        public MedicinalProductDeviceSpecMaterialComponent setSubstance(CodeableConcept value) {
            this.substance = value;
            return this;
        }

        public BooleanType getAlternateElement() {
            if (this.alternate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDeviceSpecMaterialComponent.alternate");
                }
                if (Configuration.doAutoCreate()) {
                    this.alternate = new BooleanType();
                }
            }
            return this.alternate;
        }

        public boolean hasAlternateElement() {
            return this.alternate != null && !this.alternate.isEmpty();
        }

        public boolean hasAlternate() {
            return this.alternate != null && !this.alternate.isEmpty();
        }

        public MedicinalProductDeviceSpecMaterialComponent setAlternateElement(BooleanType value) {
            this.alternate = value;
            return this;
        }

        public boolean getAlternate() {
            return this.alternate == null || this.alternate.isEmpty() ? false : (Boolean)this.alternate.getValue();
        }

        public MedicinalProductDeviceSpecMaterialComponent setAlternate(boolean value) {
            if (this.alternate == null) {
                this.alternate = new BooleanType();
            }
            this.alternate.setValue((Object)value);
            return this;
        }

        public BooleanType getAllergenicIndicatorElement() {
            if (this.allergenicIndicator == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDeviceSpecMaterialComponent.allergenicIndicator");
                }
                if (Configuration.doAutoCreate()) {
                    this.allergenicIndicator = new BooleanType();
                }
            }
            return this.allergenicIndicator;
        }

        public boolean hasAllergenicIndicatorElement() {
            return this.allergenicIndicator != null && !this.allergenicIndicator.isEmpty();
        }

        public boolean hasAllergenicIndicator() {
            return this.allergenicIndicator != null && !this.allergenicIndicator.isEmpty();
        }

        public MedicinalProductDeviceSpecMaterialComponent setAllergenicIndicatorElement(BooleanType value) {
            this.allergenicIndicator = value;
            return this;
        }

        public boolean getAllergenicIndicator() {
            return this.allergenicIndicator == null || this.allergenicIndicator.isEmpty() ? false : (Boolean)this.allergenicIndicator.getValue();
        }

        public MedicinalProductDeviceSpecMaterialComponent setAllergenicIndicator(boolean value) {
            if (this.allergenicIndicator == null) {
                this.allergenicIndicator = new BooleanType();
            }
            this.allergenicIndicator.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("substance", "CodeableConcept", "The substance.", 0, 1, this.substance));
            children.add(new Property("alternate", "boolean", "Indicates an alternative material of the device.", 0, 1, this.alternate));
            children.add(new Property("allergenicIndicator", "boolean", "Whether the substance is a known or suspected allergen.", 0, 1, this.allergenicIndicator));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 530040176: {
                    return new Property("substance", "CodeableConcept", "The substance.", 0, 1, this.substance);
                }
                case -1408024454: {
                    return new Property("alternate", "boolean", "Indicates an alternative material of the device.", 0, 1, this.alternate);
                }
                case 75406931: {
                    return new Property("allergenicIndicator", "boolean", "Whether the substance is a known or suspected allergen.", 0, 1, this.allergenicIndicator);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    Base[] baseArray;
                    if (this.substance == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.substance;
                    }
                    return baseArray;
                }
                case -1408024454: {
                    Base[] baseArray;
                    if (this.alternate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.alternate;
                    }
                    return baseArray;
                }
                case 75406931: {
                    Base[] baseArray;
                    if (this.allergenicIndicator == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.allergenicIndicator;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    this.substance = this.castToCodeableConcept(value);
                    return value;
                }
                case -1408024454: {
                    this.alternate = this.castToBoolean(value);
                    return value;
                }
                case 75406931: {
                    this.allergenicIndicator = this.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("substance")) {
                this.substance = this.castToCodeableConcept(value);
            } else if (name.equals("alternate")) {
                this.alternate = this.castToBoolean(value);
            } else if (name.equals("allergenicIndicator")) {
                this.allergenicIndicator = this.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return this.getSubstance();
                }
                case -1408024454: {
                    return this.getAlternateElement();
                }
                case 75406931: {
                    return this.getAllergenicIndicatorElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return new String[]{"CodeableConcept"};
                }
                case -1408024454: {
                    return new String[]{"boolean"};
                }
                case 75406931: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("substance")) {
                this.substance = new CodeableConcept();
                return this.substance;
            }
            if (name.equals("alternate")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicinalProductDeviceSpec.alternate");
            }
            if (name.equals("allergenicIndicator")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicinalProductDeviceSpec.allergenicIndicator");
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductDeviceSpecMaterialComponent copy() {
            MedicinalProductDeviceSpecMaterialComponent dst = new MedicinalProductDeviceSpecMaterialComponent();
            this.copyValues(dst);
            dst.substance = this.substance == null ? null : this.substance.copy();
            dst.alternate = this.alternate == null ? null : this.alternate.copy();
            dst.allergenicIndicator = this.allergenicIndicator == null ? null : this.allergenicIndicator.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDeviceSpecMaterialComponent)) {
                return false;
            }
            MedicinalProductDeviceSpecMaterialComponent o = (MedicinalProductDeviceSpecMaterialComponent)other_;
            return MedicinalProductDeviceSpecMaterialComponent.compareDeep(this.substance, o.substance, true) && MedicinalProductDeviceSpecMaterialComponent.compareDeep(this.alternate, o.alternate, true) && MedicinalProductDeviceSpecMaterialComponent.compareDeep(this.allergenicIndicator, o.allergenicIndicator, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDeviceSpecMaterialComponent)) {
                return false;
            }
            MedicinalProductDeviceSpecMaterialComponent o = (MedicinalProductDeviceSpecMaterialComponent)other_;
            return MedicinalProductDeviceSpecMaterialComponent.compareValues(this.alternate, o.alternate, true) && MedicinalProductDeviceSpecMaterialComponent.compareValues(this.allergenicIndicator, o.allergenicIndicator, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.substance, this.alternate, this.allergenicIndicator});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductDeviceSpec.material";
        }
    }
}

