/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ProductPlan", profile="http://hl7.org/fhir/Profile/ProductPlan")
public class ProductPlan
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for Product", formalDefinition="Business identifiers assigned to this health insurance product which remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The current state of the health insurance product.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of product", formalDefinition="The kind of health insurance product.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/productplan-type")
    protected List<CodeableConcept> type;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Official name", formalDefinition="Official name of the health insurance product as designated by the owner.")
    protected StringType name;
    @Child(name="alias", type={StringType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Alternate names", formalDefinition="A list of alternate names that the product is known as, or was known as in the past.")
    protected List<StringType> alias;
    @Child(name="period", type={Period.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the product is available", formalDefinition="The period of time that the health insurance product is available.")
    protected Period period;
    @Child(name="ownedBy", type={Organization.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Plan issuer", formalDefinition="The entity that is providing  the health insurance product and underwriting the risk.  This is typically an insurance carriers, other third-party payers, or health plan sponsors comonly referred to as 'payers'.")
    protected Reference ownedBy;
    protected Organization ownedByTarget;
    @Child(name="administeredBy", type={Organization.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Product administrator", formalDefinition="An organization which administer other services such as underwriting, customer service and/or claims processing on behalf of the health insurance product owner.")
    protected Reference administeredBy;
    protected Organization administeredByTarget;
    @Child(name="coverageArea", type={Location.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where product applies", formalDefinition="The geographic region in which a health insurance product's benefits apply.")
    protected Reference coverageArea;
    protected Location coverageAreaTarget;
    @Child(name="contact", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contact for the product", formalDefinition="The contact for the health insurance product for a certain purpose.")
    protected List<ProductPlanContactComponent> contact;
    @Child(name="endpoint", type={Endpoint.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Technical endpoint", formalDefinition="The technical endpoints providing access to services operated for the health insurance product.")
    protected List<Reference> endpoint;
    protected List<Endpoint> endpointTarget;
    @Child(name="network", type={Organization.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What networks are Included", formalDefinition="Reference to the network included in the health insurance product.")
    protected List<Reference> network;
    protected List<Organization> networkTarget;
    @Child(name="coverage", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Coverage details", formalDefinition="Details about the coverage offered by the insurance product.")
    protected List<ProductPlanCoverageComponent> coverage;
    @Child(name="plan", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Plan details", formalDefinition="Details about an insurance plan.")
    protected List<ProductPlanPlanComponent> plan;
    private static final long serialVersionUID = 106844035L;
    @SearchParamDefinition(name="identifier", path="ProductPlan.identifier", description="Any identifier for the organization (not the accreditation issuer's identifier)", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="address", path="ProductPlan.contact.address", description="A server defined search that may match any of the string fields in the Address, including line, city, district, state, country, postalCode, and/or text", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="address-state", path="ProductPlan.contact.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESS_STATE = "address-state";
    public static final StringClientParam ADDRESS_STATE = new StringClientParam("address-state");
    @SearchParamDefinition(name="owned-by", path="ProductPlan.ownedBy", description="An organization of which this organization forms a part", type="reference", target={Organization.class})
    public static final String SP_OWNED_BY = "owned-by";
    public static final ReferenceClientParam OWNED_BY = new ReferenceClientParam("owned-by");
    public static final Include INCLUDE_OWNED_BY = new Include("ProductPlan:owned-by").toLocked();
    @SearchParamDefinition(name="type", path="ProductPlan.type", description="A code for the type of organization", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="address-postalcode", path="ProductPlan.contact.address.postalCode", description="A postal code specified in an address", type="string")
    public static final String SP_ADDRESS_POSTALCODE = "address-postalcode";
    public static final StringClientParam ADDRESS_POSTALCODE = new StringClientParam("address-postalcode");
    @SearchParamDefinition(name="administered-by", path="ProductPlan.administeredBy", description="Product administrator", type="reference", target={Organization.class})
    public static final String SP_ADMINISTERED_BY = "administered-by";
    public static final ReferenceClientParam ADMINISTERED_BY = new ReferenceClientParam("administered-by");
    public static final Include INCLUDE_ADMINISTERED_BY = new Include("ProductPlan:administered-by").toLocked();
    @SearchParamDefinition(name="address-country", path="ProductPlan.contact.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESS_COUNTRY = "address-country";
    public static final StringClientParam ADDRESS_COUNTRY = new StringClientParam("address-country");
    @SearchParamDefinition(name="endpoint", path="ProductPlan.endpoint", description="Technical endpoint", type="reference", target={Endpoint.class})
    public static final String SP_ENDPOINT = "endpoint";
    public static final ReferenceClientParam ENDPOINT = new ReferenceClientParam("endpoint");
    public static final Include INCLUDE_ENDPOINT = new Include("ProductPlan:endpoint").toLocked();
    @SearchParamDefinition(name="phonetic", path="ProductPlan.name", description="A portion of the organization's name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    public static final StringClientParam PHONETIC = new StringClientParam("phonetic");
    @SearchParamDefinition(name="name", path="name | alias", description="A portion of the organization's name or alias", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="address-use", path="ProductPlan.contact.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESS_USE = "address-use";
    public static final TokenClientParam ADDRESS_USE = new TokenClientParam("address-use");
    @SearchParamDefinition(name="address-city", path="ProductPlan.contact.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESS_CITY = "address-city";
    public static final StringClientParam ADDRESS_CITY = new StringClientParam("address-city");
    @SearchParamDefinition(name="status", path="ProductPlan.status", description="Is the Organization record active", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ProductPlan setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ProductPlan addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProductPlan.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ProductPlan setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    public ProductPlan setStatus(Enumerations.PublicationStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public ProductPlan setType(List<CodeableConcept> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public ProductPlan addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public CodeableConcept getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProductPlan.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public ProductPlan setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public ProductPlan setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public List<StringType> getAlias() {
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        return this.alias;
    }

    public ProductPlan setAlias(List<StringType> theAlias) {
        this.alias = theAlias;
        return this;
    }

    public boolean hasAlias() {
        if (this.alias == null) {
            return false;
        }
        for (StringType item : this.alias) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addAliasElement() {
        StringType t = new StringType();
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        this.alias.add(t);
        return t;
    }

    public ProductPlan addAlias(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        this.alias.add(t);
        return this;
    }

    public boolean hasAlias(String value) {
        if (this.alias == null) {
            return false;
        }
        for (StringType v : this.alias) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProductPlan.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public ProductPlan setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Reference getOwnedBy() {
        if (this.ownedBy == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProductPlan.ownedBy");
            }
            if (Configuration.doAutoCreate()) {
                this.ownedBy = new Reference();
            }
        }
        return this.ownedBy;
    }

    public boolean hasOwnedBy() {
        return this.ownedBy != null && !this.ownedBy.isEmpty();
    }

    public ProductPlan setOwnedBy(Reference value) {
        this.ownedBy = value;
        return this;
    }

    public Organization getOwnedByTarget() {
        if (this.ownedByTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProductPlan.ownedBy");
            }
            if (Configuration.doAutoCreate()) {
                this.ownedByTarget = new Organization();
            }
        }
        return this.ownedByTarget;
    }

    public ProductPlan setOwnedByTarget(Organization value) {
        this.ownedByTarget = value;
        return this;
    }

    public Reference getAdministeredBy() {
        if (this.administeredBy == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProductPlan.administeredBy");
            }
            if (Configuration.doAutoCreate()) {
                this.administeredBy = new Reference();
            }
        }
        return this.administeredBy;
    }

    public boolean hasAdministeredBy() {
        return this.administeredBy != null && !this.administeredBy.isEmpty();
    }

    public ProductPlan setAdministeredBy(Reference value) {
        this.administeredBy = value;
        return this;
    }

    public Organization getAdministeredByTarget() {
        if (this.administeredByTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProductPlan.administeredBy");
            }
            if (Configuration.doAutoCreate()) {
                this.administeredByTarget = new Organization();
            }
        }
        return this.administeredByTarget;
    }

    public ProductPlan setAdministeredByTarget(Organization value) {
        this.administeredByTarget = value;
        return this;
    }

    public Reference getCoverageArea() {
        if (this.coverageArea == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProductPlan.coverageArea");
            }
            if (Configuration.doAutoCreate()) {
                this.coverageArea = new Reference();
            }
        }
        return this.coverageArea;
    }

    public boolean hasCoverageArea() {
        return this.coverageArea != null && !this.coverageArea.isEmpty();
    }

    public ProductPlan setCoverageArea(Reference value) {
        this.coverageArea = value;
        return this;
    }

    public Location getCoverageAreaTarget() {
        if (this.coverageAreaTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProductPlan.coverageArea");
            }
            if (Configuration.doAutoCreate()) {
                this.coverageAreaTarget = new Location();
            }
        }
        return this.coverageAreaTarget;
    }

    public ProductPlan setCoverageAreaTarget(Location value) {
        this.coverageAreaTarget = value;
        return this;
    }

    public List<ProductPlanContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ProductPlanContactComponent>();
        }
        return this.contact;
    }

    public ProductPlan setContact(List<ProductPlanContactComponent> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ProductPlanContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProductPlanContactComponent addContact() {
        ProductPlanContactComponent t = new ProductPlanContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<ProductPlanContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public ProductPlan addContact(ProductPlanContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ProductPlanContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public ProductPlanContactComponent getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public List<Reference> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        return this.endpoint;
    }

    public ProductPlan setEndpoint(List<Reference> theEndpoint) {
        this.endpoint = theEndpoint;
        return this;
    }

    public boolean hasEndpoint() {
        if (this.endpoint == null) {
            return false;
        }
        for (Reference item : this.endpoint) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEndpoint() {
        Reference t = new Reference();
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return t;
    }

    public ProductPlan addEndpoint(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return this;
    }

    public Reference getEndpointFirstRep() {
        if (this.getEndpoint().isEmpty()) {
            this.addEndpoint();
        }
        return this.getEndpoint().get(0);
    }

    @Deprecated
    public List<Endpoint> getEndpointTarget() {
        if (this.endpointTarget == null) {
            this.endpointTarget = new ArrayList<Endpoint>();
        }
        return this.endpointTarget;
    }

    @Deprecated
    public Endpoint addEndpointTarget() {
        Endpoint r = new Endpoint();
        if (this.endpointTarget == null) {
            this.endpointTarget = new ArrayList<Endpoint>();
        }
        this.endpointTarget.add(r);
        return r;
    }

    public List<Reference> getNetwork() {
        if (this.network == null) {
            this.network = new ArrayList<Reference>();
        }
        return this.network;
    }

    public ProductPlan setNetwork(List<Reference> theNetwork) {
        this.network = theNetwork;
        return this;
    }

    public boolean hasNetwork() {
        if (this.network == null) {
            return false;
        }
        for (Reference item : this.network) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addNetwork() {
        Reference t = new Reference();
        if (this.network == null) {
            this.network = new ArrayList<Reference>();
        }
        this.network.add(t);
        return t;
    }

    public ProductPlan addNetwork(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.network == null) {
            this.network = new ArrayList<Reference>();
        }
        this.network.add(t);
        return this;
    }

    public Reference getNetworkFirstRep() {
        if (this.getNetwork().isEmpty()) {
            this.addNetwork();
        }
        return this.getNetwork().get(0);
    }

    @Deprecated
    public List<Organization> getNetworkTarget() {
        if (this.networkTarget == null) {
            this.networkTarget = new ArrayList<Organization>();
        }
        return this.networkTarget;
    }

    @Deprecated
    public Organization addNetworkTarget() {
        Organization r = new Organization();
        if (this.networkTarget == null) {
            this.networkTarget = new ArrayList<Organization>();
        }
        this.networkTarget.add(r);
        return r;
    }

    public List<ProductPlanCoverageComponent> getCoverage() {
        if (this.coverage == null) {
            this.coverage = new ArrayList<ProductPlanCoverageComponent>();
        }
        return this.coverage;
    }

    public ProductPlan setCoverage(List<ProductPlanCoverageComponent> theCoverage) {
        this.coverage = theCoverage;
        return this;
    }

    public boolean hasCoverage() {
        if (this.coverage == null) {
            return false;
        }
        for (ProductPlanCoverageComponent item : this.coverage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProductPlanCoverageComponent addCoverage() {
        ProductPlanCoverageComponent t = new ProductPlanCoverageComponent();
        if (this.coverage == null) {
            this.coverage = new ArrayList<ProductPlanCoverageComponent>();
        }
        this.coverage.add(t);
        return t;
    }

    public ProductPlan addCoverage(ProductPlanCoverageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.coverage == null) {
            this.coverage = new ArrayList<ProductPlanCoverageComponent>();
        }
        this.coverage.add(t);
        return this;
    }

    public ProductPlanCoverageComponent getCoverageFirstRep() {
        if (this.getCoverage().isEmpty()) {
            this.addCoverage();
        }
        return this.getCoverage().get(0);
    }

    public List<ProductPlanPlanComponent> getPlan() {
        if (this.plan == null) {
            this.plan = new ArrayList<ProductPlanPlanComponent>();
        }
        return this.plan;
    }

    public ProductPlan setPlan(List<ProductPlanPlanComponent> thePlan) {
        this.plan = thePlan;
        return this;
    }

    public boolean hasPlan() {
        if (this.plan == null) {
            return false;
        }
        for (ProductPlanPlanComponent item : this.plan) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProductPlanPlanComponent addPlan() {
        ProductPlanPlanComponent t = new ProductPlanPlanComponent();
        if (this.plan == null) {
            this.plan = new ArrayList<ProductPlanPlanComponent>();
        }
        this.plan.add(t);
        return t;
    }

    public ProductPlan addPlan(ProductPlanPlanComponent t) {
        if (t == null) {
            return this;
        }
        if (this.plan == null) {
            this.plan = new ArrayList<ProductPlanPlanComponent>();
        }
        this.plan.add(t);
        return this;
    }

    public ProductPlanPlanComponent getPlanFirstRep() {
        if (this.getPlan().isEmpty()) {
            this.addPlan();
        }
        return this.getPlan().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this health insurance product which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The current state of the health insurance product.", 0, 1, this.status));
        children.add(new Property(SP_TYPE, "CodeableConcept", "The kind of health insurance product.", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property(SP_NAME, "string", "Official name of the health insurance product as designated by the owner.", 0, 1, this.name));
        children.add(new Property("alias", "string", "A list of alternate names that the product is known as, or was known as in the past.", 0, Integer.MAX_VALUE, this.alias));
        children.add(new Property("period", "Period", "The period of time that the health insurance product is available.", 0, 1, this.period));
        children.add(new Property("ownedBy", "Reference(Organization)", "The entity that is providing  the health insurance product and underwriting the risk.  This is typically an insurance carriers, other third-party payers, or health plan sponsors comonly referred to as 'payers'.", 0, 1, this.ownedBy));
        children.add(new Property("administeredBy", "Reference(Organization)", "An organization which administer other services such as underwriting, customer service and/or claims processing on behalf of the health insurance product owner.", 0, 1, this.administeredBy));
        children.add(new Property("coverageArea", "Reference(Location)", "The geographic region in which a health insurance product's benefits apply.", 0, 1, this.coverageArea));
        children.add(new Property("contact", "", "The contact for the health insurance product for a certain purpose.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_ENDPOINT, "Reference(Endpoint)", "The technical endpoints providing access to services operated for the health insurance product.", 0, Integer.MAX_VALUE, this.endpoint));
        children.add(new Property("network", "Reference(Organization)", "Reference to the network included in the health insurance product.", 0, Integer.MAX_VALUE, this.network));
        children.add(new Property("coverage", "", "Details about the coverage offered by the insurance product.", 0, Integer.MAX_VALUE, this.coverage));
        children.add(new Property("plan", "", "Details about an insurance plan.", 0, Integer.MAX_VALUE, this.plan));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this health insurance product which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the health insurance product.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "The kind of health insurance product.", 0, Integer.MAX_VALUE, this.type);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "Official name of the health insurance product as designated by the owner.", 0, 1, this.name);
            }
            case 92902992: {
                return new Property("alias", "string", "A list of alternate names that the product is known as, or was known as in the past.", 0, Integer.MAX_VALUE, this.alias);
            }
            case -991726143: {
                return new Property("period", "Period", "The period of time that the health insurance product is available.", 0, 1, this.period);
            }
            case -1054743076: {
                return new Property("ownedBy", "Reference(Organization)", "The entity that is providing  the health insurance product and underwriting the risk.  This is typically an insurance carriers, other third-party payers, or health plan sponsors comonly referred to as 'payers'.", 0, 1, this.ownedBy);
            }
            case 898770462: {
                return new Property("administeredBy", "Reference(Organization)", "An organization which administer other services such as underwriting, customer service and/or claims processing on behalf of the health insurance product owner.", 0, 1, this.administeredBy);
            }
            case -1532328299: {
                return new Property("coverageArea", "Reference(Location)", "The geographic region in which a health insurance product's benefits apply.", 0, 1, this.coverageArea);
            }
            case 951526432: {
                return new Property("contact", "", "The contact for the health insurance product for a certain purpose.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 1741102485: {
                return new Property(SP_ENDPOINT, "Reference(Endpoint)", "The technical endpoints providing access to services operated for the health insurance product.", 0, Integer.MAX_VALUE, this.endpoint);
            }
            case 1843485230: {
                return new Property("network", "Reference(Organization)", "Reference to the network included in the health insurance product.", 0, Integer.MAX_VALUE, this.network);
            }
            case -351767064: {
                return new Property("coverage", "", "Details about the coverage offered by the insurance product.", 0, Integer.MAX_VALUE, this.coverage);
            }
            case 3443497: {
                return new Property("plan", "", "Details about an insurance plan.", 0, Integer.MAX_VALUE, this.plan);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.name;
                }
                return baseArray;
            }
            case 92902992: {
                return this.alias == null ? new Base[]{} : this.alias.toArray(new Base[this.alias.size()]);
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.period;
                }
                return baseArray;
            }
            case -1054743076: {
                Base[] baseArray;
                if (this.ownedBy == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.ownedBy;
                }
                return baseArray;
            }
            case 898770462: {
                Base[] baseArray;
                if (this.administeredBy == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.administeredBy;
                }
                return baseArray;
            }
            case -1532328299: {
                Base[] baseArray;
                if (this.coverageArea == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.coverageArea;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 1741102485: {
                return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
            }
            case 1843485230: {
                return this.network == null ? new Base[]{} : this.network.toArray(new Base[this.network.size()]);
            }
            case -351767064: {
                return this.coverage == null ? new Base[]{} : this.coverage.toArray(new Base[this.coverage.size()]);
            }
            case 3443497: {
                return this.plan == null ? new Base[]{} : this.plan.toArray(new Base[this.plan.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 3575610: {
                this.getType().add(this.castToCodeableConcept(value));
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 92902992: {
                this.getAlias().add(this.castToString(value));
                return value;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                return value;
            }
            case -1054743076: {
                this.ownedBy = this.castToReference(value);
                return value;
            }
            case 898770462: {
                this.administeredBy = this.castToReference(value);
                return value;
            }
            case -1532328299: {
                this.coverageArea = this.castToReference(value);
                return value;
            }
            case 951526432: {
                this.getContact().add((ProductPlanContactComponent)((Object)value));
                return value;
            }
            case 1741102485: {
                this.getEndpoint().add(this.castToReference(value));
                return value;
            }
            case 1843485230: {
                this.getNetwork().add(this.castToReference(value));
                return value;
            }
            case -351767064: {
                this.getCoverage().add((ProductPlanCoverageComponent)((Object)value));
                return value;
            }
            case 3443497: {
                this.getPlan().add((ProductPlanPlanComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_TYPE)) {
            this.getType().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals("alias")) {
            this.getAlias().add(this.castToString(value));
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals("ownedBy")) {
            this.ownedBy = this.castToReference(value);
        } else if (name.equals("administeredBy")) {
            this.administeredBy = this.castToReference(value);
        } else if (name.equals("coverageArea")) {
            this.coverageArea = this.castToReference(value);
        } else if (name.equals("contact")) {
            this.getContact().add((ProductPlanContactComponent)((Object)value));
        } else if (name.equals(SP_ENDPOINT)) {
            this.getEndpoint().add(this.castToReference(value));
        } else if (name.equals("network")) {
            this.getNetwork().add(this.castToReference(value));
        } else if (name.equals("coverage")) {
            this.getCoverage().add((ProductPlanCoverageComponent)((Object)value));
        } else if (name.equals("plan")) {
            this.getPlan().add((ProductPlanPlanComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3575610: {
                return this.addType();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 92902992: {
                return this.addAliasElement();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -1054743076: {
                return this.getOwnedBy();
            }
            case 898770462: {
                return this.getAdministeredBy();
            }
            case -1532328299: {
                return this.getCoverageArea();
            }
            case 951526432: {
                return this.addContact();
            }
            case 1741102485: {
                return this.addEndpoint();
            }
            case 1843485230: {
                return this.addNetwork();
            }
            case -351767064: {
                return this.addCoverage();
            }
            case 3443497: {
                return this.addPlan();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 92902992: {
                return new String[]{"string"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case -1054743076: {
                return new String[]{"Reference"};
            }
            case 898770462: {
                return new String[]{"Reference"};
            }
            case -1532328299: {
                return new String[]{"Reference"};
            }
            case 951526432: {
                return new String[0];
            }
            case 1741102485: {
                return new String[]{"Reference"};
            }
            case 1843485230: {
                return new String[]{"Reference"};
            }
            case -351767064: {
                return new String[0];
            }
            case 3443497: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ProductPlan.status");
        }
        if (name.equals(SP_TYPE)) {
            return this.addType();
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type ProductPlan.name");
        }
        if (name.equals("alias")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProductPlan.alias");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("ownedBy")) {
            this.ownedBy = new Reference();
            return this.ownedBy;
        }
        if (name.equals("administeredBy")) {
            this.administeredBy = new Reference();
            return this.administeredBy;
        }
        if (name.equals("coverageArea")) {
            this.coverageArea = new Reference();
            return this.coverageArea;
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_ENDPOINT)) {
            return this.addEndpoint();
        }
        if (name.equals("network")) {
            return this.addNetwork();
        }
        if (name.equals("coverage")) {
            return this.addCoverage();
        }
        if (name.equals("plan")) {
            return this.addPlan();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ProductPlan";
    }

    @Override
    public ProductPlan copy() {
        ProductPlan dst = new ProductPlan();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<Enumerations.PublicationStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.type) {
                dst.type.add(codeableConcept.copy());
            }
        }
        StringType stringType = dst.name = this.name == null ? null : this.name.copy();
        if (this.alias != null) {
            dst.alias = new ArrayList<StringType>();
            for (StringType stringType2 : this.alias) {
                dst.alias.add(stringType2.copy());
            }
        }
        dst.period = this.period == null ? null : this.period.copy();
        dst.ownedBy = this.ownedBy == null ? null : this.ownedBy.copy();
        dst.administeredBy = this.administeredBy == null ? null : this.administeredBy.copy();
        Reference reference = dst.coverageArea = this.coverageArea == null ? null : this.coverageArea.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ProductPlanContactComponent>();
            for (ProductPlanContactComponent productPlanContactComponent : this.contact) {
                dst.contact.add(productPlanContactComponent.copy());
            }
        }
        if (this.endpoint != null) {
            dst.endpoint = new ArrayList<Reference>();
            for (Reference reference2 : this.endpoint) {
                dst.endpoint.add(reference2.copy());
            }
        }
        if (this.network != null) {
            dst.network = new ArrayList<Reference>();
            for (Reference reference3 : this.network) {
                dst.network.add(reference3.copy());
            }
        }
        if (this.coverage != null) {
            dst.coverage = new ArrayList<ProductPlanCoverageComponent>();
            for (ProductPlanCoverageComponent productPlanCoverageComponent : this.coverage) {
                dst.coverage.add(productPlanCoverageComponent.copy());
            }
        }
        if (this.plan != null) {
            dst.plan = new ArrayList<ProductPlanPlanComponent>();
            for (ProductPlanPlanComponent productPlanPlanComponent : this.plan) {
                dst.plan.add(productPlanPlanComponent.copy());
            }
        }
        return dst;
    }

    protected ProductPlan typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ProductPlan)) {
            return false;
        }
        ProductPlan o = (ProductPlan)other_;
        return ProductPlan.compareDeep(this.identifier, o.identifier, true) && ProductPlan.compareDeep(this.status, o.status, true) && ProductPlan.compareDeep(this.type, o.type, true) && ProductPlan.compareDeep(this.name, o.name, true) && ProductPlan.compareDeep(this.alias, o.alias, true) && ProductPlan.compareDeep(this.period, o.period, true) && ProductPlan.compareDeep(this.ownedBy, o.ownedBy, true) && ProductPlan.compareDeep(this.administeredBy, o.administeredBy, true) && ProductPlan.compareDeep(this.coverageArea, o.coverageArea, true) && ProductPlan.compareDeep(this.contact, o.contact, true) && ProductPlan.compareDeep(this.endpoint, o.endpoint, true) && ProductPlan.compareDeep(this.network, o.network, true) && ProductPlan.compareDeep(this.coverage, o.coverage, true) && ProductPlan.compareDeep(this.plan, o.plan, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ProductPlan)) {
            return false;
        }
        ProductPlan o = (ProductPlan)other_;
        return ProductPlan.compareValues(this.status, o.status, true) && ProductPlan.compareValues(this.name, o.name, true) && ProductPlan.compareValues(this.alias, o.alias, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.type, this.name, this.alias, this.period, this.ownedBy, this.administeredBy, this.coverageArea, this.contact, this.endpoint, this.network, this.coverage, this.plan});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ProductPlan;
    }

    @Block
    public static class ProductPlanPlanSpecificCostBenefitCostComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of cost", formalDefinition="Type of cost (copay; individual cap; family cap; coinsurance; deductible).")
        protected CodeableConcept type;
        @Child(name="applicability", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="in-network | out-of-network | other", formalDefinition="Whether the cost applies to in-network or out-of-network providers (in-network; out-of-network; other).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/applicability")
        protected Enumeration<BenefitCostApplicability> applicability;
        @Child(name="qualifiers", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional information about the cost", formalDefinition="Additional information about the cost, such as information about funding sources (e.g. HSA, HRA, FSA, RRA).")
        protected List<CodeableConcept> qualifiers;
        @Child(name="value", type={Money.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The actual cost value", formalDefinition="The actual cost value.")
        protected Money value;
        private static final long serialVersionUID = -2009981593L;

        public ProductPlanPlanSpecificCostBenefitCostComponent() {
        }

        public ProductPlanPlanSpecificCostBenefitCostComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanPlanSpecificCostBenefitCostComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ProductPlanPlanSpecificCostBenefitCostComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Enumeration<BenefitCostApplicability> getApplicabilityElement() {
            if (this.applicability == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanPlanSpecificCostBenefitCostComponent.applicability");
                }
                if (Configuration.doAutoCreate()) {
                    this.applicability = new Enumeration<BenefitCostApplicability>(new BenefitCostApplicabilityEnumFactory());
                }
            }
            return this.applicability;
        }

        public boolean hasApplicabilityElement() {
            return this.applicability != null && !this.applicability.isEmpty();
        }

        public boolean hasApplicability() {
            return this.applicability != null && !this.applicability.isEmpty();
        }

        public ProductPlanPlanSpecificCostBenefitCostComponent setApplicabilityElement(Enumeration<BenefitCostApplicability> value) {
            this.applicability = value;
            return this;
        }

        public BenefitCostApplicability getApplicability() {
            return this.applicability == null ? null : (BenefitCostApplicability)((Object)this.applicability.getValue());
        }

        public ProductPlanPlanSpecificCostBenefitCostComponent setApplicability(BenefitCostApplicability value) {
            if (value == null) {
                this.applicability = null;
            } else {
                if (this.applicability == null) {
                    this.applicability = new Enumeration<BenefitCostApplicability>(new BenefitCostApplicabilityEnumFactory());
                }
                this.applicability.setValue((Object)value);
            }
            return this;
        }

        public List<CodeableConcept> getQualifiers() {
            if (this.qualifiers == null) {
                this.qualifiers = new ArrayList<CodeableConcept>();
            }
            return this.qualifiers;
        }

        public ProductPlanPlanSpecificCostBenefitCostComponent setQualifiers(List<CodeableConcept> theQualifiers) {
            this.qualifiers = theQualifiers;
            return this;
        }

        public boolean hasQualifiers() {
            if (this.qualifiers == null) {
                return false;
            }
            for (CodeableConcept item : this.qualifiers) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addQualifiers() {
            CodeableConcept t = new CodeableConcept();
            if (this.qualifiers == null) {
                this.qualifiers = new ArrayList<CodeableConcept>();
            }
            this.qualifiers.add(t);
            return t;
        }

        public ProductPlanPlanSpecificCostBenefitCostComponent addQualifiers(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.qualifiers == null) {
                this.qualifiers = new ArrayList<CodeableConcept>();
            }
            this.qualifiers.add(t);
            return this;
        }

        public CodeableConcept getQualifiersFirstRep() {
            if (this.getQualifiers().isEmpty()) {
                this.addQualifiers();
            }
            return this.getQualifiers().get(0);
        }

        public Money getValue() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanPlanSpecificCostBenefitCostComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new Money();
                }
            }
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ProductPlanPlanSpecificCostBenefitCostComponent setValue(Money value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ProductPlan.SP_TYPE, "CodeableConcept", "Type of cost (copay; individual cap; family cap; coinsurance; deductible).", 0, 1, this.type));
            children.add(new Property("applicability", "code", "Whether the cost applies to in-network or out-of-network providers (in-network; out-of-network; other).", 0, 1, this.applicability));
            children.add(new Property("qualifiers", "CodeableConcept", "Additional information about the cost, such as information about funding sources (e.g. HSA, HRA, FSA, RRA).", 0, Integer.MAX_VALUE, this.qualifiers));
            children.add(new Property("value", "Money", "The actual cost value.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(ProductPlan.SP_TYPE, "CodeableConcept", "Type of cost (copay; individual cap; family cap; coinsurance; deductible).", 0, 1, this.type);
                }
                case -1526770491: {
                    return new Property("applicability", "code", "Whether the cost applies to in-network or out-of-network providers (in-network; out-of-network; other).", 0, 1, this.applicability);
                }
                case -31447799: {
                    return new Property("qualifiers", "CodeableConcept", "Additional information about the cost, such as information about funding sources (e.g. HSA, HRA, FSA, RRA).", 0, Integer.MAX_VALUE, this.qualifiers);
                }
                case 111972721: {
                    return new Property("value", "Money", "The actual cost value.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1526770491: {
                    Base[] baseArray;
                    if (this.applicability == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.applicability;
                    }
                    return baseArray;
                }
                case -31447799: {
                    return this.qualifiers == null ? new Base[]{} : this.qualifiers.toArray(new Base[this.qualifiers.size()]);
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1526770491: {
                    value = new BenefitCostApplicabilityEnumFactory().fromType(this.castToCode(value));
                    this.applicability = value;
                    return value;
                }
                case -31447799: {
                    this.getQualifiers().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 111972721: {
                    this.value = this.castToMoney(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ProductPlan.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("applicability")) {
                value = new BenefitCostApplicabilityEnumFactory().fromType(this.castToCode(value));
                this.applicability = value;
            } else if (name.equals("qualifiers")) {
                this.getQualifiers().add(this.castToCodeableConcept(value));
            } else if (name.equals("value")) {
                this.value = this.castToMoney(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1526770491: {
                    return this.getApplicabilityElement();
                }
                case -31447799: {
                    return this.addQualifiers();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1526770491: {
                    return new String[]{"code"};
                }
                case -31447799: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"Money"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ProductPlan.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("applicability")) {
                throw new FHIRException("Cannot call addChild on a primitive type ProductPlan.applicability");
            }
            if (name.equals("qualifiers")) {
                return this.addQualifiers();
            }
            if (name.equals("value")) {
                this.value = new Money();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ProductPlanPlanSpecificCostBenefitCostComponent copy() {
            ProductPlanPlanSpecificCostBenefitCostComponent dst = new ProductPlanPlanSpecificCostBenefitCostComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            Enumeration<BenefitCostApplicability> enumeration = dst.applicability = this.applicability == null ? null : this.applicability.copy();
            if (this.qualifiers != null) {
                dst.qualifiers = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.qualifiers) {
                    dst.qualifiers.add(i.copy());
                }
            }
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProductPlanPlanSpecificCostBenefitCostComponent)) {
                return false;
            }
            ProductPlanPlanSpecificCostBenefitCostComponent o = (ProductPlanPlanSpecificCostBenefitCostComponent)other_;
            return ProductPlanPlanSpecificCostBenefitCostComponent.compareDeep(this.type, o.type, true) && ProductPlanPlanSpecificCostBenefitCostComponent.compareDeep(this.applicability, o.applicability, true) && ProductPlanPlanSpecificCostBenefitCostComponent.compareDeep(this.qualifiers, o.qualifiers, true) && ProductPlanPlanSpecificCostBenefitCostComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProductPlanPlanSpecificCostBenefitCostComponent)) {
                return false;
            }
            ProductPlanPlanSpecificCostBenefitCostComponent o = (ProductPlanPlanSpecificCostBenefitCostComponent)other_;
            return ProductPlanPlanSpecificCostBenefitCostComponent.compareValues(this.applicability, o.applicability, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.applicability, this.qualifiers, this.value});
        }

        @Override
        public String fhirType() {
            return "ProductPlan.plan.specificCost.benefit.cost";
        }
    }

    @Block
    public static class ProductPlanPlanSpecificCostBenefitComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of specific benefit", formalDefinition="Type of specific benefit (preventative; primary care office visit; speciality office visit; hospitalization; emergency room; urgent care).")
        protected CodeableConcept type;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additional information", formalDefinition="Additional information about the specific benefit to qualify additional costs.")
        protected StringType description;
        @Child(name="cost", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of the costs", formalDefinition="List of the costs associated with a specific benefit.")
        protected List<ProductPlanPlanSpecificCostBenefitCostComponent> cost;
        private static final long serialVersionUID = 1239135146L;

        public ProductPlanPlanSpecificCostBenefitComponent() {
        }

        public ProductPlanPlanSpecificCostBenefitComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanPlanSpecificCostBenefitComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ProductPlanPlanSpecificCostBenefitComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanPlanSpecificCostBenefitComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ProductPlanPlanSpecificCostBenefitComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ProductPlanPlanSpecificCostBenefitComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<ProductPlanPlanSpecificCostBenefitCostComponent> getCost() {
            if (this.cost == null) {
                this.cost = new ArrayList<ProductPlanPlanSpecificCostBenefitCostComponent>();
            }
            return this.cost;
        }

        public ProductPlanPlanSpecificCostBenefitComponent setCost(List<ProductPlanPlanSpecificCostBenefitCostComponent> theCost) {
            this.cost = theCost;
            return this;
        }

        public boolean hasCost() {
            if (this.cost == null) {
                return false;
            }
            for (ProductPlanPlanSpecificCostBenefitCostComponent item : this.cost) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProductPlanPlanSpecificCostBenefitCostComponent addCost() {
            ProductPlanPlanSpecificCostBenefitCostComponent t = new ProductPlanPlanSpecificCostBenefitCostComponent();
            if (this.cost == null) {
                this.cost = new ArrayList<ProductPlanPlanSpecificCostBenefitCostComponent>();
            }
            this.cost.add(t);
            return t;
        }

        public ProductPlanPlanSpecificCostBenefitComponent addCost(ProductPlanPlanSpecificCostBenefitCostComponent t) {
            if (t == null) {
                return this;
            }
            if (this.cost == null) {
                this.cost = new ArrayList<ProductPlanPlanSpecificCostBenefitCostComponent>();
            }
            this.cost.add(t);
            return this;
        }

        public ProductPlanPlanSpecificCostBenefitCostComponent getCostFirstRep() {
            if (this.getCost().isEmpty()) {
                this.addCost();
            }
            return this.getCost().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ProductPlan.SP_TYPE, "CodeableConcept", "Type of specific benefit (preventative; primary care office visit; speciality office visit; hospitalization; emergency room; urgent care).", 0, 1, this.type));
            children.add(new Property("description", "string", "Additional information about the specific benefit to qualify additional costs.", 0, 1, this.description));
            children.add(new Property("cost", "", "List of the costs associated with a specific benefit.", 0, Integer.MAX_VALUE, this.cost));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(ProductPlan.SP_TYPE, "CodeableConcept", "Type of specific benefit (preventative; primary care office visit; speciality office visit; hospitalization; emergency room; urgent care).", 0, 1, this.type);
                }
                case -1724546052: {
                    return new Property("description", "string", "Additional information about the specific benefit to qualify additional costs.", 0, 1, this.description);
                }
                case 3059661: {
                    return new Property("cost", "", "List of the costs associated with a specific benefit.", 0, Integer.MAX_VALUE, this.cost);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case 3059661: {
                    return this.cost == null ? new Base[]{} : this.cost.toArray(new Base[this.cost.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case 3059661: {
                    this.getCost().add((ProductPlanPlanSpecificCostBenefitCostComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ProductPlan.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("cost")) {
                this.getCost().add((ProductPlanPlanSpecificCostBenefitCostComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3059661: {
                    return this.addCost();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3059661: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ProductPlan.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ProductPlan.description");
            }
            if (name.equals("cost")) {
                return this.addCost();
            }
            return super.addChild(name);
        }

        @Override
        public ProductPlanPlanSpecificCostBenefitComponent copy() {
            ProductPlanPlanSpecificCostBenefitComponent dst = new ProductPlanPlanSpecificCostBenefitComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.cost != null) {
                dst.cost = new ArrayList<ProductPlanPlanSpecificCostBenefitCostComponent>();
                for (ProductPlanPlanSpecificCostBenefitCostComponent i : this.cost) {
                    dst.cost.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProductPlanPlanSpecificCostBenefitComponent)) {
                return false;
            }
            ProductPlanPlanSpecificCostBenefitComponent o = (ProductPlanPlanSpecificCostBenefitComponent)other_;
            return ProductPlanPlanSpecificCostBenefitComponent.compareDeep(this.type, o.type, true) && ProductPlanPlanSpecificCostBenefitComponent.compareDeep(this.description, o.description, true) && ProductPlanPlanSpecificCostBenefitComponent.compareDeep(this.cost, o.cost, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProductPlanPlanSpecificCostBenefitComponent)) {
                return false;
            }
            ProductPlanPlanSpecificCostBenefitComponent o = (ProductPlanPlanSpecificCostBenefitComponent)other_;
            return ProductPlanPlanSpecificCostBenefitComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.description, this.cost});
        }

        @Override
        public String fhirType() {
            return "ProductPlan.plan.specificCost.benefit";
        }
    }

    @Block
    public static class ProductPlanPlanSpecificCostComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="General category of benefit", formalDefinition="General category of benefit (Medical; Dental; Vision; Drug; Mental Health; Substance Abuse; Hospice, Home Health).")
        protected CodeableConcept category;
        @Child(name="benefit", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Benefits list", formalDefinition="List of the specific benefits under this category of benefit.")
        protected List<ProductPlanPlanSpecificCostBenefitComponent> benefit;
        private static final long serialVersionUID = 1629436006L;

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanPlanSpecificCostComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public ProductPlanPlanSpecificCostComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public List<ProductPlanPlanSpecificCostBenefitComponent> getBenefit() {
            if (this.benefit == null) {
                this.benefit = new ArrayList<ProductPlanPlanSpecificCostBenefitComponent>();
            }
            return this.benefit;
        }

        public ProductPlanPlanSpecificCostComponent setBenefit(List<ProductPlanPlanSpecificCostBenefitComponent> theBenefit) {
            this.benefit = theBenefit;
            return this;
        }

        public boolean hasBenefit() {
            if (this.benefit == null) {
                return false;
            }
            for (ProductPlanPlanSpecificCostBenefitComponent item : this.benefit) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProductPlanPlanSpecificCostBenefitComponent addBenefit() {
            ProductPlanPlanSpecificCostBenefitComponent t = new ProductPlanPlanSpecificCostBenefitComponent();
            if (this.benefit == null) {
                this.benefit = new ArrayList<ProductPlanPlanSpecificCostBenefitComponent>();
            }
            this.benefit.add(t);
            return t;
        }

        public ProductPlanPlanSpecificCostComponent addBenefit(ProductPlanPlanSpecificCostBenefitComponent t) {
            if (t == null) {
                return this;
            }
            if (this.benefit == null) {
                this.benefit = new ArrayList<ProductPlanPlanSpecificCostBenefitComponent>();
            }
            this.benefit.add(t);
            return this;
        }

        public ProductPlanPlanSpecificCostBenefitComponent getBenefitFirstRep() {
            if (this.getBenefit().isEmpty()) {
                this.addBenefit();
            }
            return this.getBenefit().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "General category of benefit (Medical; Dental; Vision; Drug; Mental Health; Substance Abuse; Hospice, Home Health).", 0, 1, this.category));
            children.add(new Property("benefit", "", "List of the specific benefits under this category of benefit.", 0, Integer.MAX_VALUE, this.benefit));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "General category of benefit (Medical; Dental; Vision; Drug; Mental Health; Substance Abuse; Hospice, Home Health).", 0, 1, this.category);
                }
                case -222710633: {
                    return new Property("benefit", "", "List of the specific benefits under this category of benefit.", 0, Integer.MAX_VALUE, this.benefit);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -222710633: {
                    return this.benefit == null ? new Base[]{} : this.benefit.toArray(new Base[this.benefit.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case -222710633: {
                    this.getBenefit().add((ProductPlanPlanSpecificCostBenefitComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("benefit")) {
                this.getBenefit().add((ProductPlanPlanSpecificCostBenefitComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -222710633: {
                    return this.addBenefit();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case -222710633: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("benefit")) {
                return this.addBenefit();
            }
            return super.addChild(name);
        }

        @Override
        public ProductPlanPlanSpecificCostComponent copy() {
            ProductPlanPlanSpecificCostComponent dst = new ProductPlanPlanSpecificCostComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.category = this.category == null ? null : this.category.copy();
            if (this.benefit != null) {
                dst.benefit = new ArrayList<ProductPlanPlanSpecificCostBenefitComponent>();
                for (ProductPlanPlanSpecificCostBenefitComponent i : this.benefit) {
                    dst.benefit.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProductPlanPlanSpecificCostComponent)) {
                return false;
            }
            ProductPlanPlanSpecificCostComponent o = (ProductPlanPlanSpecificCostComponent)other_;
            return ProductPlanPlanSpecificCostComponent.compareDeep(this.category, o.category, true) && ProductPlanPlanSpecificCostComponent.compareDeep(this.benefit, o.benefit, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProductPlanPlanSpecificCostComponent)) {
                return false;
            }
            ProductPlanPlanSpecificCostComponent o = (ProductPlanPlanSpecificCostComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.category, this.benefit});
        }

        @Override
        public String fhirType() {
            return "ProductPlan.plan.specificCost";
        }
    }

    @Block
    public static class ProductPlanPlanGeneralCostComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of cost", formalDefinition="Type of cost.")
        protected CodeableConcept type;
        @Child(name="groupSize", type={PositiveIntType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number of enrollees", formalDefinition="Number of participants enrolled in the plan.")
        protected PositiveIntType groupSize;
        @Child(name="cost", type={Money.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Cost value", formalDefinition="Value of the cost.")
        protected Money cost;
        @Child(name="comment", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additional cost information", formalDefinition="Additional information about the general costs associated with this plan.")
        protected StringType comment;
        private static final long serialVersionUID = 1563949866L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanPlanGeneralCostComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ProductPlanPlanGeneralCostComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public PositiveIntType getGroupSizeElement() {
            if (this.groupSize == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanPlanGeneralCostComponent.groupSize");
                }
                if (Configuration.doAutoCreate()) {
                    this.groupSize = new PositiveIntType();
                }
            }
            return this.groupSize;
        }

        public boolean hasGroupSizeElement() {
            return this.groupSize != null && !this.groupSize.isEmpty();
        }

        public boolean hasGroupSize() {
            return this.groupSize != null && !this.groupSize.isEmpty();
        }

        public ProductPlanPlanGeneralCostComponent setGroupSizeElement(PositiveIntType value) {
            this.groupSize = value;
            return this;
        }

        public int getGroupSize() {
            return this.groupSize == null || this.groupSize.isEmpty() ? 0 : (Integer)this.groupSize.getValue();
        }

        public ProductPlanPlanGeneralCostComponent setGroupSize(int value) {
            if (this.groupSize == null) {
                this.groupSize = new PositiveIntType();
            }
            this.groupSize.setValue((Object)value);
            return this;
        }

        public Money getCost() {
            if (this.cost == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanPlanGeneralCostComponent.cost");
                }
                if (Configuration.doAutoCreate()) {
                    this.cost = new Money();
                }
            }
            return this.cost;
        }

        public boolean hasCost() {
            return this.cost != null && !this.cost.isEmpty();
        }

        public ProductPlanPlanGeneralCostComponent setCost(Money value) {
            this.cost = value;
            return this;
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanPlanGeneralCostComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public ProductPlanPlanGeneralCostComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public ProductPlanPlanGeneralCostComponent setComment(String value) {
            if (Utilities.noString((String)value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ProductPlan.SP_TYPE, "CodeableConcept", "Type of cost.", 0, 1, this.type));
            children.add(new Property("groupSize", "positiveInt", "Number of participants enrolled in the plan.", 0, 1, this.groupSize));
            children.add(new Property("cost", "Money", "Value of the cost.", 0, 1, this.cost));
            children.add(new Property("comment", "string", "Additional information about the general costs associated with this plan.", 0, 1, this.comment));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(ProductPlan.SP_TYPE, "CodeableConcept", "Type of cost.", 0, 1, this.type);
                }
                case -1483017440: {
                    return new Property("groupSize", "positiveInt", "Number of participants enrolled in the plan.", 0, 1, this.groupSize);
                }
                case 3059661: {
                    return new Property("cost", "Money", "Value of the cost.", 0, 1, this.cost);
                }
                case 950398559: {
                    return new Property("comment", "string", "Additional information about the general costs associated with this plan.", 0, 1, this.comment);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1483017440: {
                    Base[] baseArray;
                    if (this.groupSize == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.groupSize;
                    }
                    return baseArray;
                }
                case 3059661: {
                    Base[] baseArray;
                    if (this.cost == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.cost;
                    }
                    return baseArray;
                }
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.comment;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1483017440: {
                    this.groupSize = this.castToPositiveInt(value);
                    return value;
                }
                case 3059661: {
                    this.cost = this.castToMoney(value);
                    return value;
                }
                case 950398559: {
                    this.comment = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ProductPlan.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("groupSize")) {
                this.groupSize = this.castToPositiveInt(value);
            } else if (name.equals("cost")) {
                this.cost = this.castToMoney(value);
            } else if (name.equals("comment")) {
                this.comment = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1483017440: {
                    return this.getGroupSizeElement();
                }
                case 3059661: {
                    return this.getCost();
                }
                case 950398559: {
                    return this.getCommentElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1483017440: {
                    return new String[]{"positiveInt"};
                }
                case 3059661: {
                    return new String[]{"Money"};
                }
                case 950398559: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ProductPlan.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("groupSize")) {
                throw new FHIRException("Cannot call addChild on a primitive type ProductPlan.groupSize");
            }
            if (name.equals("cost")) {
                this.cost = new Money();
                return this.cost;
            }
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a primitive type ProductPlan.comment");
            }
            return super.addChild(name);
        }

        @Override
        public ProductPlanPlanGeneralCostComponent copy() {
            ProductPlanPlanGeneralCostComponent dst = new ProductPlanPlanGeneralCostComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.groupSize = this.groupSize == null ? null : this.groupSize.copy();
            dst.cost = this.cost == null ? null : this.cost.copy();
            dst.comment = this.comment == null ? null : this.comment.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProductPlanPlanGeneralCostComponent)) {
                return false;
            }
            ProductPlanPlanGeneralCostComponent o = (ProductPlanPlanGeneralCostComponent)other_;
            return ProductPlanPlanGeneralCostComponent.compareDeep(this.type, o.type, true) && ProductPlanPlanGeneralCostComponent.compareDeep(this.groupSize, o.groupSize, true) && ProductPlanPlanGeneralCostComponent.compareDeep(this.cost, o.cost, true) && ProductPlanPlanGeneralCostComponent.compareDeep(this.comment, o.comment, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProductPlanPlanGeneralCostComponent)) {
                return false;
            }
            ProductPlanPlanGeneralCostComponent o = (ProductPlanPlanGeneralCostComponent)other_;
            return ProductPlanPlanGeneralCostComponent.compareValues(this.groupSize, o.groupSize, true) && ProductPlanPlanGeneralCostComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.groupSize, this.cost, this.comment});
        }

        @Override
        public String fhirType() {
            return "ProductPlan.plan.generalCost";
        }
    }

    @Block
    public static class ProductPlanPlanComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Business Identifier for Product", formalDefinition="Business identifiers assigned to this health insurance plan which remain constant as the resource is updated and propagates from server to server.")
        protected List<Identifier> identifier;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of plan", formalDefinition="Type of plan. For example, \"Platinum\" or \"High Deductable\".")
        protected CodeableConcept type;
        @Child(name="coverageArea", type={Location.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Where product applies", formalDefinition="The geographic region in which a health insurance plan's benefits apply.")
        protected Reference coverageArea;
        protected Location coverageAreaTarget;
        @Child(name="network", type={Organization.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What networks provide coverage", formalDefinition="Reference to the network that providing the type of coverage.")
        protected List<Reference> network;
        protected List<Organization> networkTarget;
        @Child(name="generalCost", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Overall costs", formalDefinition="Overall costs associated with the plan.")
        protected List<ProductPlanPlanGeneralCostComponent> generalCost;
        @Child(name="specificCost", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specific costs", formalDefinition="Costs associated with the coverage provided by the product.")
        protected List<ProductPlanPlanSpecificCostComponent> specificCost;
        private static final long serialVersionUID = -316449985L;

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public ProductPlanPlanComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public ProductPlanPlanComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanPlanComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ProductPlanPlanComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Reference getCoverageArea() {
            if (this.coverageArea == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanPlanComponent.coverageArea");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverageArea = new Reference();
                }
            }
            return this.coverageArea;
        }

        public boolean hasCoverageArea() {
            return this.coverageArea != null && !this.coverageArea.isEmpty();
        }

        public ProductPlanPlanComponent setCoverageArea(Reference value) {
            this.coverageArea = value;
            return this;
        }

        public Location getCoverageAreaTarget() {
            if (this.coverageAreaTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanPlanComponent.coverageArea");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverageAreaTarget = new Location();
                }
            }
            return this.coverageAreaTarget;
        }

        public ProductPlanPlanComponent setCoverageAreaTarget(Location value) {
            this.coverageAreaTarget = value;
            return this;
        }

        public List<Reference> getNetwork() {
            if (this.network == null) {
                this.network = new ArrayList<Reference>();
            }
            return this.network;
        }

        public ProductPlanPlanComponent setNetwork(List<Reference> theNetwork) {
            this.network = theNetwork;
            return this;
        }

        public boolean hasNetwork() {
            if (this.network == null) {
                return false;
            }
            for (Reference item : this.network) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addNetwork() {
            Reference t = new Reference();
            if (this.network == null) {
                this.network = new ArrayList<Reference>();
            }
            this.network.add(t);
            return t;
        }

        public ProductPlanPlanComponent addNetwork(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.network == null) {
                this.network = new ArrayList<Reference>();
            }
            this.network.add(t);
            return this;
        }

        public Reference getNetworkFirstRep() {
            if (this.getNetwork().isEmpty()) {
                this.addNetwork();
            }
            return this.getNetwork().get(0);
        }

        @Deprecated
        public List<Organization> getNetworkTarget() {
            if (this.networkTarget == null) {
                this.networkTarget = new ArrayList<Organization>();
            }
            return this.networkTarget;
        }

        @Deprecated
        public Organization addNetworkTarget() {
            Organization r = new Organization();
            if (this.networkTarget == null) {
                this.networkTarget = new ArrayList<Organization>();
            }
            this.networkTarget.add(r);
            return r;
        }

        public List<ProductPlanPlanGeneralCostComponent> getGeneralCost() {
            if (this.generalCost == null) {
                this.generalCost = new ArrayList<ProductPlanPlanGeneralCostComponent>();
            }
            return this.generalCost;
        }

        public ProductPlanPlanComponent setGeneralCost(List<ProductPlanPlanGeneralCostComponent> theGeneralCost) {
            this.generalCost = theGeneralCost;
            return this;
        }

        public boolean hasGeneralCost() {
            if (this.generalCost == null) {
                return false;
            }
            for (ProductPlanPlanGeneralCostComponent item : this.generalCost) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProductPlanPlanGeneralCostComponent addGeneralCost() {
            ProductPlanPlanGeneralCostComponent t = new ProductPlanPlanGeneralCostComponent();
            if (this.generalCost == null) {
                this.generalCost = new ArrayList<ProductPlanPlanGeneralCostComponent>();
            }
            this.generalCost.add(t);
            return t;
        }

        public ProductPlanPlanComponent addGeneralCost(ProductPlanPlanGeneralCostComponent t) {
            if (t == null) {
                return this;
            }
            if (this.generalCost == null) {
                this.generalCost = new ArrayList<ProductPlanPlanGeneralCostComponent>();
            }
            this.generalCost.add(t);
            return this;
        }

        public ProductPlanPlanGeneralCostComponent getGeneralCostFirstRep() {
            if (this.getGeneralCost().isEmpty()) {
                this.addGeneralCost();
            }
            return this.getGeneralCost().get(0);
        }

        public List<ProductPlanPlanSpecificCostComponent> getSpecificCost() {
            if (this.specificCost == null) {
                this.specificCost = new ArrayList<ProductPlanPlanSpecificCostComponent>();
            }
            return this.specificCost;
        }

        public ProductPlanPlanComponent setSpecificCost(List<ProductPlanPlanSpecificCostComponent> theSpecificCost) {
            this.specificCost = theSpecificCost;
            return this;
        }

        public boolean hasSpecificCost() {
            if (this.specificCost == null) {
                return false;
            }
            for (ProductPlanPlanSpecificCostComponent item : this.specificCost) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProductPlanPlanSpecificCostComponent addSpecificCost() {
            ProductPlanPlanSpecificCostComponent t = new ProductPlanPlanSpecificCostComponent();
            if (this.specificCost == null) {
                this.specificCost = new ArrayList<ProductPlanPlanSpecificCostComponent>();
            }
            this.specificCost.add(t);
            return t;
        }

        public ProductPlanPlanComponent addSpecificCost(ProductPlanPlanSpecificCostComponent t) {
            if (t == null) {
                return this;
            }
            if (this.specificCost == null) {
                this.specificCost = new ArrayList<ProductPlanPlanSpecificCostComponent>();
            }
            this.specificCost.add(t);
            return this;
        }

        public ProductPlanPlanSpecificCostComponent getSpecificCostFirstRep() {
            if (this.getSpecificCost().isEmpty()) {
                this.addSpecificCost();
            }
            return this.getSpecificCost().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ProductPlan.SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this health insurance plan which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property(ProductPlan.SP_TYPE, "CodeableConcept", "Type of plan. For example, \"Platinum\" or \"High Deductable\".", 0, 1, this.type));
            children.add(new Property("coverageArea", "Reference(Location)", "The geographic region in which a health insurance plan's benefits apply.", 0, 1, this.coverageArea));
            children.add(new Property("network", "Reference(Organization)", "Reference to the network that providing the type of coverage.", 0, Integer.MAX_VALUE, this.network));
            children.add(new Property("generalCost", "", "Overall costs associated with the plan.", 0, Integer.MAX_VALUE, this.generalCost));
            children.add(new Property("specificCost", "", "Costs associated with the coverage provided by the product.", 0, Integer.MAX_VALUE, this.specificCost));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(ProductPlan.SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this health insurance plan which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case 3575610: {
                    return new Property(ProductPlan.SP_TYPE, "CodeableConcept", "Type of plan. For example, \"Platinum\" or \"High Deductable\".", 0, 1, this.type);
                }
                case -1532328299: {
                    return new Property("coverageArea", "Reference(Location)", "The geographic region in which a health insurance plan's benefits apply.", 0, 1, this.coverageArea);
                }
                case 1843485230: {
                    return new Property("network", "Reference(Organization)", "Reference to the network that providing the type of coverage.", 0, Integer.MAX_VALUE, this.network);
                }
                case 878344405: {
                    return new Property("generalCost", "", "Overall costs associated with the plan.", 0, Integer.MAX_VALUE, this.generalCost);
                }
                case -1205656545: {
                    return new Property("specificCost", "", "Costs associated with the coverage provided by the product.", 0, Integer.MAX_VALUE, this.specificCost);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1532328299: {
                    Base[] baseArray;
                    if (this.coverageArea == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.coverageArea;
                    }
                    return baseArray;
                }
                case 1843485230: {
                    return this.network == null ? new Base[]{} : this.network.toArray(new Base[this.network.size()]);
                }
                case 878344405: {
                    return this.generalCost == null ? new Base[]{} : this.generalCost.toArray(new Base[this.generalCost.size()]);
                }
                case -1205656545: {
                    return this.specificCost == null ? new Base[]{} : this.specificCost.toArray(new Base[this.specificCost.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(this.castToIdentifier(value));
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1532328299: {
                    this.coverageArea = this.castToReference(value);
                    return value;
                }
                case 1843485230: {
                    this.getNetwork().add(this.castToReference(value));
                    return value;
                }
                case 878344405: {
                    this.getGeneralCost().add((ProductPlanPlanGeneralCostComponent)value);
                    return value;
                }
                case -1205656545: {
                    this.getSpecificCost().add((ProductPlanPlanSpecificCostComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ProductPlan.SP_IDENTIFIER)) {
                this.getIdentifier().add(this.castToIdentifier(value));
            } else if (name.equals(ProductPlan.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("coverageArea")) {
                this.coverageArea = this.castToReference(value);
            } else if (name.equals("network")) {
                this.getNetwork().add(this.castToReference(value));
            } else if (name.equals("generalCost")) {
                this.getGeneralCost().add((ProductPlanPlanGeneralCostComponent)value);
            } else if (name.equals("specificCost")) {
                this.getSpecificCost().add((ProductPlanPlanSpecificCostComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1532328299: {
                    return this.getCoverageArea();
                }
                case 1843485230: {
                    return this.addNetwork();
                }
                case 878344405: {
                    return this.addGeneralCost();
                }
                case -1205656545: {
                    return this.addSpecificCost();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1532328299: {
                    return new String[]{"Reference"};
                }
                case 1843485230: {
                    return new String[]{"Reference"};
                }
                case 878344405: {
                    return new String[0];
                }
                case -1205656545: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ProductPlan.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals(ProductPlan.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("coverageArea")) {
                this.coverageArea = new Reference();
                return this.coverageArea;
            }
            if (name.equals("network")) {
                return this.addNetwork();
            }
            if (name.equals("generalCost")) {
                return this.addGeneralCost();
            }
            if (name.equals("specificCost")) {
                return this.addSpecificCost();
            }
            return super.addChild(name);
        }

        @Override
        public ProductPlanPlanComponent copy() {
            ProductPlanPlanComponent dst = new ProductPlanPlanComponent();
            this.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.identifier) {
                    dst.identifier.add(identifier.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            Reference reference = dst.coverageArea = this.coverageArea == null ? null : this.coverageArea.copy();
            if (this.network != null) {
                dst.network = new ArrayList<Reference>();
                for (Reference reference2 : this.network) {
                    dst.network.add(reference2.copy());
                }
            }
            if (this.generalCost != null) {
                dst.generalCost = new ArrayList<ProductPlanPlanGeneralCostComponent>();
                for (ProductPlanPlanGeneralCostComponent productPlanPlanGeneralCostComponent : this.generalCost) {
                    dst.generalCost.add(productPlanPlanGeneralCostComponent.copy());
                }
            }
            if (this.specificCost != null) {
                dst.specificCost = new ArrayList<ProductPlanPlanSpecificCostComponent>();
                for (ProductPlanPlanSpecificCostComponent productPlanPlanSpecificCostComponent : this.specificCost) {
                    dst.specificCost.add(productPlanPlanSpecificCostComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProductPlanPlanComponent)) {
                return false;
            }
            ProductPlanPlanComponent o = (ProductPlanPlanComponent)other_;
            return ProductPlanPlanComponent.compareDeep(this.identifier, o.identifier, true) && ProductPlanPlanComponent.compareDeep(this.type, o.type, true) && ProductPlanPlanComponent.compareDeep(this.coverageArea, o.coverageArea, true) && ProductPlanPlanComponent.compareDeep(this.network, o.network, true) && ProductPlanPlanComponent.compareDeep(this.generalCost, o.generalCost, true) && ProductPlanPlanComponent.compareDeep(this.specificCost, o.specificCost, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProductPlanPlanComponent)) {
                return false;
            }
            ProductPlanPlanComponent o = (ProductPlanPlanComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.coverageArea, this.network, this.generalCost, this.specificCost});
        }

        @Override
        public String fhirType() {
            return "ProductPlan.plan";
        }
    }

    @Block
    public static class ProductPlanCoverageBenefitLimitComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="value", type={Quantity.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Maximum value allowed", formalDefinition="The maximum amount of a service item a plan will pay for a covered benefit.  For examples. wellness visits, or eyeglasses.")
        protected Quantity value;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Benefit limit details", formalDefinition="The specific limit on the benefit.")
        protected CodeableConcept code;
        private static final long serialVersionUID = -304318128L;

        public Quantity getValue() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanCoverageBenefitLimitComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new Quantity();
                }
            }
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ProductPlanCoverageBenefitLimitComponent setValue(Quantity value) {
            this.value = value;
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanCoverageBenefitLimitComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ProductPlanCoverageBenefitLimitComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("value", "Quantity", "The maximum amount of a service item a plan will pay for a covered benefit.  For examples. wellness visits, or eyeglasses.", 0, 1, this.value));
            children.add(new Property("code", "CodeableConcept", "The specific limit on the benefit.", 0, 1, this.code));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 111972721: {
                    return new Property("value", "Quantity", "The maximum amount of a service item a plan will pay for a covered benefit.  For examples. wellness visits, or eyeglasses.", 0, 1, this.value);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "The specific limit on the benefit.", 0, 1, this.code);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.value;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    this.value = this.castToQuantity(value);
                    return value;
                }
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("value")) {
                this.value = this.castToQuantity(value);
            } else if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    return this.getValue();
                }
                case 3059181: {
                    return this.getCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    return new String[]{"Quantity"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("value")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            return super.addChild(name);
        }

        @Override
        public ProductPlanCoverageBenefitLimitComponent copy() {
            ProductPlanCoverageBenefitLimitComponent dst = new ProductPlanCoverageBenefitLimitComponent();
            this.copyValues(dst);
            dst.value = this.value == null ? null : this.value.copy();
            dst.code = this.code == null ? null : this.code.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProductPlanCoverageBenefitLimitComponent)) {
                return false;
            }
            ProductPlanCoverageBenefitLimitComponent o = (ProductPlanCoverageBenefitLimitComponent)other_;
            return ProductPlanCoverageBenefitLimitComponent.compareDeep(this.value, o.value, true) && ProductPlanCoverageBenefitLimitComponent.compareDeep(this.code, o.code, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProductPlanCoverageBenefitLimitComponent)) {
                return false;
            }
            ProductPlanCoverageBenefitLimitComponent o = (ProductPlanCoverageBenefitLimitComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.value, this.code});
        }

        @Override
        public String fhirType() {
            return "ProductPlan.coverage.benefit.limit";
        }
    }

    @Block
    public static class ProductPlanCoverageBenefitComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of benefit", formalDefinition="Type of benefit (primary care; speciality care; inpatient; outpatient).")
        protected CodeableConcept type;
        @Child(name="requirement", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Referral requirements", formalDefinition="The referral requirements to have access/coverage for this benefit.")
        protected StringType requirement;
        @Child(name="limit", type={}, order=3, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Benefit limits", formalDefinition="The specific limits on the benefit.")
        protected List<ProductPlanCoverageBenefitLimitComponent> limit;
        private static final long serialVersionUID = 74403513L;

        public ProductPlanCoverageBenefitComponent() {
        }

        public ProductPlanCoverageBenefitComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanCoverageBenefitComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ProductPlanCoverageBenefitComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getRequirementElement() {
            if (this.requirement == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanCoverageBenefitComponent.requirement");
                }
                if (Configuration.doAutoCreate()) {
                    this.requirement = new StringType();
                }
            }
            return this.requirement;
        }

        public boolean hasRequirementElement() {
            return this.requirement != null && !this.requirement.isEmpty();
        }

        public boolean hasRequirement() {
            return this.requirement != null && !this.requirement.isEmpty();
        }

        public ProductPlanCoverageBenefitComponent setRequirementElement(StringType value) {
            this.requirement = value;
            return this;
        }

        public String getRequirement() {
            return this.requirement == null ? null : (String)this.requirement.getValue();
        }

        public ProductPlanCoverageBenefitComponent setRequirement(String value) {
            if (Utilities.noString((String)value)) {
                this.requirement = null;
            } else {
                if (this.requirement == null) {
                    this.requirement = new StringType();
                }
                this.requirement.setValue(value);
            }
            return this;
        }

        public List<ProductPlanCoverageBenefitLimitComponent> getLimit() {
            if (this.limit == null) {
                this.limit = new ArrayList<ProductPlanCoverageBenefitLimitComponent>();
            }
            return this.limit;
        }

        public ProductPlanCoverageBenefitComponent setLimit(List<ProductPlanCoverageBenefitLimitComponent> theLimit) {
            this.limit = theLimit;
            return this;
        }

        public boolean hasLimit() {
            if (this.limit == null) {
                return false;
            }
            for (ProductPlanCoverageBenefitLimitComponent item : this.limit) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProductPlanCoverageBenefitLimitComponent addLimit() {
            ProductPlanCoverageBenefitLimitComponent t = new ProductPlanCoverageBenefitLimitComponent();
            if (this.limit == null) {
                this.limit = new ArrayList<ProductPlanCoverageBenefitLimitComponent>();
            }
            this.limit.add(t);
            return t;
        }

        public ProductPlanCoverageBenefitComponent addLimit(ProductPlanCoverageBenefitLimitComponent t) {
            if (t == null) {
                return this;
            }
            if (this.limit == null) {
                this.limit = new ArrayList<ProductPlanCoverageBenefitLimitComponent>();
            }
            this.limit.add(t);
            return this;
        }

        public ProductPlanCoverageBenefitLimitComponent getLimitFirstRep() {
            if (this.getLimit().isEmpty()) {
                this.addLimit();
            }
            return this.getLimit().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ProductPlan.SP_TYPE, "CodeableConcept", "Type of benefit (primary care; speciality care; inpatient; outpatient).", 0, 1, this.type));
            children.add(new Property("requirement", "string", "The referral requirements to have access/coverage for this benefit.", 0, 1, this.requirement));
            children.add(new Property("limit", "", "The specific limits on the benefit.", 0, Integer.MAX_VALUE, this.limit));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(ProductPlan.SP_TYPE, "CodeableConcept", "Type of benefit (primary care; speciality care; inpatient; outpatient).", 0, 1, this.type);
                }
                case 363387971: {
                    return new Property("requirement", "string", "The referral requirements to have access/coverage for this benefit.", 0, 1, this.requirement);
                }
                case 102976443: {
                    return new Property("limit", "", "The specific limits on the benefit.", 0, Integer.MAX_VALUE, this.limit);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 363387971: {
                    Base[] baseArray;
                    if (this.requirement == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.requirement;
                    }
                    return baseArray;
                }
                case 102976443: {
                    return this.limit == null ? new Base[]{} : this.limit.toArray(new Base[this.limit.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 363387971: {
                    this.requirement = this.castToString(value);
                    return value;
                }
                case 102976443: {
                    this.getLimit().add((ProductPlanCoverageBenefitLimitComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ProductPlan.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("requirement")) {
                this.requirement = this.castToString(value);
            } else if (name.equals("limit")) {
                this.getLimit().add((ProductPlanCoverageBenefitLimitComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 363387971: {
                    return this.getRequirementElement();
                }
                case 102976443: {
                    return this.addLimit();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 363387971: {
                    return new String[]{"string"};
                }
                case 102976443: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ProductPlan.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("requirement")) {
                throw new FHIRException("Cannot call addChild on a primitive type ProductPlan.requirement");
            }
            if (name.equals("limit")) {
                return this.addLimit();
            }
            return super.addChild(name);
        }

        @Override
        public ProductPlanCoverageBenefitComponent copy() {
            ProductPlanCoverageBenefitComponent dst = new ProductPlanCoverageBenefitComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            StringType stringType = dst.requirement = this.requirement == null ? null : this.requirement.copy();
            if (this.limit != null) {
                dst.limit = new ArrayList<ProductPlanCoverageBenefitLimitComponent>();
                for (ProductPlanCoverageBenefitLimitComponent i : this.limit) {
                    dst.limit.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProductPlanCoverageBenefitComponent)) {
                return false;
            }
            ProductPlanCoverageBenefitComponent o = (ProductPlanCoverageBenefitComponent)other_;
            return ProductPlanCoverageBenefitComponent.compareDeep(this.type, o.type, true) && ProductPlanCoverageBenefitComponent.compareDeep(this.requirement, o.requirement, true) && ProductPlanCoverageBenefitComponent.compareDeep(this.limit, o.limit, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProductPlanCoverageBenefitComponent)) {
                return false;
            }
            ProductPlanCoverageBenefitComponent o = (ProductPlanCoverageBenefitComponent)other_;
            return ProductPlanCoverageBenefitComponent.compareValues(this.requirement, o.requirement, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.requirement, this.limit});
        }

        @Override
        public String fhirType() {
            return "ProductPlan.coverage.benefit";
        }
    }

    @Block
    public static class ProductPlanCoverageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of coverage", formalDefinition="Type of coverage  (Medical; Dental; Mental Health; Substance Abuse; Vision; Drug; Short Term; Long Term Care; Hospice; Home Health).")
        protected CodeableConcept type;
        @Child(name="network", type={Organization.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What networks provide coverage", formalDefinition="Reference to the network that providing the type of coverage.")
        protected List<Reference> network;
        protected List<Organization> networkTarget;
        @Child(name="benefit", type={}, order=3, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of benefits", formalDefinition="Specific benefits under this type of coverage.")
        protected List<ProductPlanCoverageBenefitComponent> benefit;
        private static final long serialVersionUID = -1381201025L;

        public ProductPlanCoverageComponent() {
        }

        public ProductPlanCoverageComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanCoverageComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ProductPlanCoverageComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<Reference> getNetwork() {
            if (this.network == null) {
                this.network = new ArrayList<Reference>();
            }
            return this.network;
        }

        public ProductPlanCoverageComponent setNetwork(List<Reference> theNetwork) {
            this.network = theNetwork;
            return this;
        }

        public boolean hasNetwork() {
            if (this.network == null) {
                return false;
            }
            for (Reference item : this.network) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addNetwork() {
            Reference t = new Reference();
            if (this.network == null) {
                this.network = new ArrayList<Reference>();
            }
            this.network.add(t);
            return t;
        }

        public ProductPlanCoverageComponent addNetwork(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.network == null) {
                this.network = new ArrayList<Reference>();
            }
            this.network.add(t);
            return this;
        }

        public Reference getNetworkFirstRep() {
            if (this.getNetwork().isEmpty()) {
                this.addNetwork();
            }
            return this.getNetwork().get(0);
        }

        @Deprecated
        public List<Organization> getNetworkTarget() {
            if (this.networkTarget == null) {
                this.networkTarget = new ArrayList<Organization>();
            }
            return this.networkTarget;
        }

        @Deprecated
        public Organization addNetworkTarget() {
            Organization r = new Organization();
            if (this.networkTarget == null) {
                this.networkTarget = new ArrayList<Organization>();
            }
            this.networkTarget.add(r);
            return r;
        }

        public List<ProductPlanCoverageBenefitComponent> getBenefit() {
            if (this.benefit == null) {
                this.benefit = new ArrayList<ProductPlanCoverageBenefitComponent>();
            }
            return this.benefit;
        }

        public ProductPlanCoverageComponent setBenefit(List<ProductPlanCoverageBenefitComponent> theBenefit) {
            this.benefit = theBenefit;
            return this;
        }

        public boolean hasBenefit() {
            if (this.benefit == null) {
                return false;
            }
            for (ProductPlanCoverageBenefitComponent item : this.benefit) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProductPlanCoverageBenefitComponent addBenefit() {
            ProductPlanCoverageBenefitComponent t = new ProductPlanCoverageBenefitComponent();
            if (this.benefit == null) {
                this.benefit = new ArrayList<ProductPlanCoverageBenefitComponent>();
            }
            this.benefit.add(t);
            return t;
        }

        public ProductPlanCoverageComponent addBenefit(ProductPlanCoverageBenefitComponent t) {
            if (t == null) {
                return this;
            }
            if (this.benefit == null) {
                this.benefit = new ArrayList<ProductPlanCoverageBenefitComponent>();
            }
            this.benefit.add(t);
            return this;
        }

        public ProductPlanCoverageBenefitComponent getBenefitFirstRep() {
            if (this.getBenefit().isEmpty()) {
                this.addBenefit();
            }
            return this.getBenefit().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ProductPlan.SP_TYPE, "CodeableConcept", "Type of coverage  (Medical; Dental; Mental Health; Substance Abuse; Vision; Drug; Short Term; Long Term Care; Hospice; Home Health).", 0, 1, this.type));
            children.add(new Property("network", "Reference(Organization)", "Reference to the network that providing the type of coverage.", 0, Integer.MAX_VALUE, this.network));
            children.add(new Property("benefit", "", "Specific benefits under this type of coverage.", 0, Integer.MAX_VALUE, this.benefit));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(ProductPlan.SP_TYPE, "CodeableConcept", "Type of coverage  (Medical; Dental; Mental Health; Substance Abuse; Vision; Drug; Short Term; Long Term Care; Hospice; Home Health).", 0, 1, this.type);
                }
                case 1843485230: {
                    return new Property("network", "Reference(Organization)", "Reference to the network that providing the type of coverage.", 0, Integer.MAX_VALUE, this.network);
                }
                case -222710633: {
                    return new Property("benefit", "", "Specific benefits under this type of coverage.", 0, Integer.MAX_VALUE, this.benefit);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 1843485230: {
                    return this.network == null ? new Base[]{} : this.network.toArray(new Base[this.network.size()]);
                }
                case -222710633: {
                    return this.benefit == null ? new Base[]{} : this.benefit.toArray(new Base[this.benefit.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 1843485230: {
                    this.getNetwork().add(this.castToReference(value));
                    return value;
                }
                case -222710633: {
                    this.getBenefit().add((ProductPlanCoverageBenefitComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ProductPlan.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("network")) {
                this.getNetwork().add(this.castToReference(value));
            } else if (name.equals("benefit")) {
                this.getBenefit().add((ProductPlanCoverageBenefitComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 1843485230: {
                    return this.addNetwork();
                }
                case -222710633: {
                    return this.addBenefit();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1843485230: {
                    return new String[]{"Reference"};
                }
                case -222710633: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ProductPlan.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("network")) {
                return this.addNetwork();
            }
            if (name.equals("benefit")) {
                return this.addBenefit();
            }
            return super.addChild(name);
        }

        @Override
        public ProductPlanCoverageComponent copy() {
            ProductPlanCoverageComponent dst = new ProductPlanCoverageComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.network != null) {
                dst.network = new ArrayList<Reference>();
                for (Reference reference : this.network) {
                    dst.network.add(reference.copy());
                }
            }
            if (this.benefit != null) {
                dst.benefit = new ArrayList<ProductPlanCoverageBenefitComponent>();
                for (ProductPlanCoverageBenefitComponent productPlanCoverageBenefitComponent : this.benefit) {
                    dst.benefit.add(productPlanCoverageBenefitComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProductPlanCoverageComponent)) {
                return false;
            }
            ProductPlanCoverageComponent o = (ProductPlanCoverageComponent)other_;
            return ProductPlanCoverageComponent.compareDeep(this.type, o.type, true) && ProductPlanCoverageComponent.compareDeep(this.network, o.network, true) && ProductPlanCoverageComponent.compareDeep(this.benefit, o.benefit, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProductPlanCoverageComponent)) {
                return false;
            }
            ProductPlanCoverageComponent o = (ProductPlanCoverageComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.network, this.benefit});
        }

        @Override
        public String fhirType() {
            return "ProductPlan.coverage";
        }
    }

    @Block
    public static class ProductPlanContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="purpose", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of contact", formalDefinition="Indicates a purpose for which the contact can be reached.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contactentity-type")
        protected CodeableConcept purpose;
        @Child(name="name", type={HumanName.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A name associated with the contact", formalDefinition="A name associated with the contact.")
        protected HumanName name;
        @Child(name="telecom", type={ContactPoint.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contact details (telephone, email, etc.)  for a contact", formalDefinition="A contact detail (e.g. a telephone number or an email address) by which the party may be contacted.")
        protected List<ContactPoint> telecom;
        @Child(name="address", type={Address.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Visiting or postal addresses for the contact", formalDefinition="Visiting or postal addresses for the contact.")
        protected Address address;
        private static final long serialVersionUID = 1831121305L;

        public CodeableConcept getPurpose() {
            if (this.purpose == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanContactComponent.purpose");
                }
                if (Configuration.doAutoCreate()) {
                    this.purpose = new CodeableConcept();
                }
            }
            return this.purpose;
        }

        public boolean hasPurpose() {
            return this.purpose != null && !this.purpose.isEmpty();
        }

        public ProductPlanContactComponent setPurpose(CodeableConcept value) {
            this.purpose = value;
            return this;
        }

        public HumanName getName() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new HumanName();
                }
            }
            return this.name;
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ProductPlanContactComponent setName(HumanName value) {
            this.name = value;
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public ProductPlanContactComponent setTelecom(List<ContactPoint> theTelecom) {
            this.telecom = theTelecom;
            return this;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public ProductPlanContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        public ContactPoint getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                this.addTelecom();
            }
            return this.getTelecom().get(0);
        }

        public Address getAddress() {
            if (this.address == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProductPlanContactComponent.address");
                }
                if (Configuration.doAutoCreate()) {
                    this.address = new Address();
                }
            }
            return this.address;
        }

        public boolean hasAddress() {
            return this.address != null && !this.address.isEmpty();
        }

        public ProductPlanContactComponent setAddress(Address value) {
            this.address = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("purpose", "CodeableConcept", "Indicates a purpose for which the contact can be reached.", 0, 1, this.purpose));
            children.add(new Property(ProductPlan.SP_NAME, "HumanName", "A name associated with the contact.", 0, 1, this.name));
            children.add(new Property("telecom", "ContactPoint", "A contact detail (e.g. a telephone number or an email address) by which the party may be contacted.", 0, Integer.MAX_VALUE, this.telecom));
            children.add(new Property(ProductPlan.SP_ADDRESS, "Address", "Visiting or postal addresses for the contact.", 0, 1, this.address));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -220463842: {
                    return new Property("purpose", "CodeableConcept", "Indicates a purpose for which the contact can be reached.", 0, 1, this.purpose);
                }
                case 3373707: {
                    return new Property(ProductPlan.SP_NAME, "HumanName", "A name associated with the contact.", 0, 1, this.name);
                }
                case -1429363305: {
                    return new Property("telecom", "ContactPoint", "A contact detail (e.g. a telephone number or an email address) by which the party may be contacted.", 0, Integer.MAX_VALUE, this.telecom);
                }
                case -1147692044: {
                    return new Property(ProductPlan.SP_ADDRESS, "Address", "Visiting or postal addresses for the contact.", 0, 1, this.address);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    Base[] baseArray;
                    if (this.purpose == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.purpose;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
                case -1147692044: {
                    Base[] baseArray;
                    if (this.address == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.address;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    this.purpose = this.castToCodeableConcept(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToHumanName(value);
                    return value;
                }
                case -1429363305: {
                    this.getTelecom().add(this.castToContactPoint(value));
                    return value;
                }
                case -1147692044: {
                    this.address = this.castToAddress(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("purpose")) {
                this.purpose = this.castToCodeableConcept(value);
            } else if (name.equals(ProductPlan.SP_NAME)) {
                this.name = this.castToHumanName(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else if (name.equals(ProductPlan.SP_ADDRESS)) {
                this.address = this.castToAddress(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    return this.getPurpose();
                }
                case 3373707: {
                    return this.getName();
                }
                case -1429363305: {
                    return this.addTelecom();
                }
                case -1147692044: {
                    return this.getAddress();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    return new String[]{"CodeableConcept"};
                }
                case 3373707: {
                    return new String[]{"HumanName"};
                }
                case -1429363305: {
                    return new String[]{"ContactPoint"};
                }
                case -1147692044: {
                    return new String[]{"Address"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("purpose")) {
                this.purpose = new CodeableConcept();
                return this.purpose;
            }
            if (name.equals(ProductPlan.SP_NAME)) {
                this.name = new HumanName();
                return this.name;
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            if (name.equals(ProductPlan.SP_ADDRESS)) {
                this.address = new Address();
                return this.address;
            }
            return super.addChild(name);
        }

        @Override
        public ProductPlanContactComponent copy() {
            ProductPlanContactComponent dst = new ProductPlanContactComponent();
            this.copyValues(dst);
            dst.purpose = this.purpose == null ? null : this.purpose.copy();
            HumanName humanName = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            dst.address = this.address == null ? null : this.address.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProductPlanContactComponent)) {
                return false;
            }
            ProductPlanContactComponent o = (ProductPlanContactComponent)other_;
            return ProductPlanContactComponent.compareDeep(this.purpose, o.purpose, true) && ProductPlanContactComponent.compareDeep(this.name, o.name, true) && ProductPlanContactComponent.compareDeep(this.telecom, o.telecom, true) && ProductPlanContactComponent.compareDeep(this.address, o.address, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProductPlanContactComponent)) {
                return false;
            }
            ProductPlanContactComponent o = (ProductPlanContactComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.purpose, this.name, this.telecom, this.address});
        }

        @Override
        public String fhirType() {
            return "ProductPlan.contact";
        }
    }

    public static class BenefitCostApplicabilityEnumFactory
    implements EnumFactory<BenefitCostApplicability> {
        @Override
        public BenefitCostApplicability fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in-network".equals(codeString)) {
                return BenefitCostApplicability.INNETWORK;
            }
            if ("out-of-network".equals(codeString)) {
                return BenefitCostApplicability.OUTOFNETWORK;
            }
            if ("other".equals(codeString)) {
                return BenefitCostApplicability.OTHER;
            }
            throw new IllegalArgumentException("Unknown BenefitCostApplicability code '" + codeString + "'");
        }

        public Enumeration<BenefitCostApplicability> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<BenefitCostApplicability>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-network".equals(codeString)) {
                return new Enumeration<BenefitCostApplicability>(this, BenefitCostApplicability.INNETWORK);
            }
            if ("out-of-network".equals(codeString)) {
                return new Enumeration<BenefitCostApplicability>(this, BenefitCostApplicability.OUTOFNETWORK);
            }
            if ("other".equals(codeString)) {
                return new Enumeration<BenefitCostApplicability>(this, BenefitCostApplicability.OTHER);
            }
            throw new FHIRException("Unknown BenefitCostApplicability code '" + codeString + "'");
        }

        @Override
        public String toCode(BenefitCostApplicability code) {
            if (code == BenefitCostApplicability.INNETWORK) {
                return "in-network";
            }
            if (code == BenefitCostApplicability.OUTOFNETWORK) {
                return "out-of-network";
            }
            if (code == BenefitCostApplicability.OTHER) {
                return "other";
            }
            return "?";
        }

        @Override
        public String toSystem(BenefitCostApplicability code) {
            return code.getSystem();
        }
    }

    public static enum BenefitCostApplicability {
        INNETWORK,
        OUTOFNETWORK,
        OTHER,
        NULL;


        public static BenefitCostApplicability fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-network".equals(codeString)) {
                return INNETWORK;
            }
            if ("out-of-network".equals(codeString)) {
                return OUTOFNETWORK;
            }
            if ("other".equals(codeString)) {
                return OTHER;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown BenefitCostApplicability code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INNETWORK: {
                    return "in-network";
                }
                case OUTOFNETWORK: {
                    return "out-of-network";
                }
                case OTHER: {
                    return "other";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INNETWORK: {
                    return "http://hl7.org/fhir/applicability";
                }
                case OUTOFNETWORK: {
                    return "http://hl7.org/fhir/applicability";
                }
                case OTHER: {
                    return "http://hl7.org/fhir/applicability";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INNETWORK: {
                    return "Provider is contracted with the health insurance company to provide services to plan members for specific pre-negotiated rates";
                }
                case OUTOFNETWORK: {
                    return "Provider is  not contracted with the health insurance company to provide services to plan members for specific pre-negotiated rates";
                }
                case OTHER: {
                    return "Other applicability";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INNETWORK: {
                    return "In Network";
                }
                case OUTOFNETWORK: {
                    return "Out of Network";
                }
                case OTHER: {
                    return "Other";
                }
            }
            return "?";
        }
    }
}

