/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Schedule;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="TriggerDefinition")
public class TriggerDefinition
extends Type
implements ICompositeType {
    @Child(name="type", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="named-event | periodic | data-changed | data-added | data-modified | data-removed | data-accessed | data-access-ended", formalDefinition="The type of triggering event.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/trigger-type")
    protected Enumeration<TriggerType> type;
    @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name or URI that identifies the event", formalDefinition="A formal name for the event. This may be an absolute URI that identifies the event formally (e.g. from a trigger registry), or a simple relative URI that identifies the event in a local context.")
    protected StringType name;
    @Child(name="timing", type={Timing.class, Schedule.class, DateType.class, DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Timing of the event", formalDefinition="The timing of the event (if this is a periodic trigger).")
    protected Type timing;
    @Child(name="data", type={DataRequirement.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Triggering data of the event", formalDefinition="The triggering data of the event (if this is a data trigger).")
    protected DataRequirement data;
    @Child(name="condition", type={}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether the event triggers", formalDefinition="A boolean-valued expression that is evaluated in the context of the container of the trigger definition and returns whether or not the trigger fires.")
    protected TriggerDefinitionConditionComponent condition;
    private static final long serialVersionUID = -2027399070L;

    public TriggerDefinition() {
    }

    public TriggerDefinition(Enumeration<TriggerType> type) {
        this.type = type;
    }

    public Enumeration<TriggerType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TriggerDefinition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<TriggerType>(new TriggerTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public TriggerDefinition setTypeElement(Enumeration<TriggerType> value) {
        this.type = value;
        return this;
    }

    public TriggerType getType() {
        return this.type == null ? null : (TriggerType)((Object)this.type.getValue());
    }

    public TriggerDefinition setType(TriggerType value) {
        if (this.type == null) {
            this.type = new Enumeration<TriggerType>(new TriggerTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TriggerDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public TriggerDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public TriggerDefinition setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public Type getTiming() {
        return this.timing;
    }

    public Timing getTimingTiming() throws FHIRException {
        if (this.timing == null) {
            return null;
        }
        if (!(this.timing instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Timing)this.timing;
    }

    public boolean hasTimingTiming() {
        return this != null && this.timing instanceof Timing;
    }

    public Reference getTimingReference() throws FHIRException {
        if (this.timing == null) {
            return null;
        }
        if (!(this.timing instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Reference)this.timing;
    }

    public boolean hasTimingReference() {
        return this != null && this.timing instanceof Reference;
    }

    public DateType getTimingDateType() throws FHIRException {
        if (this.timing == null) {
            return null;
        }
        if (!(this.timing instanceof DateType)) {
            throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (DateType)this.timing;
    }

    public boolean hasTimingDateType() {
        return this != null && this.timing instanceof DateType;
    }

    public DateTimeType getTimingDateTimeType() throws FHIRException {
        if (this.timing == null) {
            return null;
        }
        if (!(this.timing instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.timing;
    }

    public boolean hasTimingDateTimeType() {
        return this != null && this.timing instanceof DateTimeType;
    }

    public boolean hasTiming() {
        return this.timing != null && !this.timing.isEmpty();
    }

    public TriggerDefinition setTiming(Type value) {
        if (!(value == null || value instanceof Timing || value instanceof Reference || value instanceof DateType || value instanceof DateTimeType)) {
            throw new Error("Not the right type for TriggerDefinition.timing[x]: " + value.fhirType());
        }
        this.timing = value;
        return this;
    }

    public DataRequirement getData() {
        if (this.data == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TriggerDefinition.data");
            }
            if (Configuration.doAutoCreate()) {
                this.data = new DataRequirement();
            }
        }
        return this.data;
    }

    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    public TriggerDefinition setData(DataRequirement value) {
        this.data = value;
        return this;
    }

    public TriggerDefinitionConditionComponent getCondition() {
        if (this.condition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TriggerDefinition.condition");
            }
            if (Configuration.doAutoCreate()) {
                this.condition = new TriggerDefinitionConditionComponent();
            }
        }
        return this.condition;
    }

    public boolean hasCondition() {
        return this.condition != null && !this.condition.isEmpty();
    }

    public TriggerDefinition setCondition(TriggerDefinitionConditionComponent value) {
        this.condition = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("type", "code", "The type of triggering event.", 0, 1, this.type));
        children.add(new Property("name", "string", "A formal name for the event. This may be an absolute URI that identifies the event formally (e.g. from a trigger registry), or a simple relative URI that identifies the event in a local context.", 0, 1, this.name));
        children.add(new Property("timing[x]", "Timing|Reference(Schedule)|date|dateTime", "The timing of the event (if this is a periodic trigger).", 0, 1, this.timing));
        children.add(new Property("data", "DataRequirement", "The triggering data of the event (if this is a data trigger).", 0, 1, this.data));
        children.add(new Property("condition", "", "A boolean-valued expression that is evaluated in the context of the container of the trigger definition and returns whether or not the trigger fires.", 0, 1, this.condition));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3575610: {
                return new Property("type", "code", "The type of triggering event.", 0, 1, this.type);
            }
            case 3373707: {
                return new Property("name", "string", "A formal name for the event. This may be an absolute URI that identifies the event formally (e.g. from a trigger registry), or a simple relative URI that identifies the event in a local context.", 0, 1, this.name);
            }
            case 164632566: {
                return new Property("timing[x]", "Timing|Reference(Schedule)|date|dateTime", "The timing of the event (if this is a periodic trigger).", 0, 1, this.timing);
            }
            case -873664438: {
                return new Property("timing[x]", "Timing|Reference(Schedule)|date|dateTime", "The timing of the event (if this is a periodic trigger).", 0, 1, this.timing);
            }
            case -497554124: {
                return new Property("timing[x]", "Timing|Reference(Schedule)|date|dateTime", "The timing of the event (if this is a periodic trigger).", 0, 1, this.timing);
            }
            case -1792466399: {
                return new Property("timing[x]", "Timing|Reference(Schedule)|date|dateTime", "The timing of the event (if this is a periodic trigger).", 0, 1, this.timing);
            }
            case 807935768: {
                return new Property("timing[x]", "Timing|Reference(Schedule)|date|dateTime", "The timing of the event (if this is a periodic trigger).", 0, 1, this.timing);
            }
            case -1837458939: {
                return new Property("timing[x]", "Timing|Reference(Schedule)|date|dateTime", "The timing of the event (if this is a periodic trigger).", 0, 1, this.timing);
            }
            case 3076010: {
                return new Property("data", "DataRequirement", "The triggering data of the event (if this is a data trigger).", 0, 1, this.data);
            }
            case -861311717: {
                return new Property("condition", "", "A boolean-valued expression that is evaluated in the context of the container of the trigger definition and returns whether or not the trigger fires.", 0, 1, this.condition);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.name;
                }
                return baseArray;
            }
            case -873664438: {
                Base[] baseArray;
                if (this.timing == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.timing;
                }
                return baseArray;
            }
            case 3076010: {
                Base[] baseArray;
                if (this.data == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.data;
                }
                return baseArray;
            }
            case -861311717: {
                Base[] baseArray;
                if (this.condition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.condition;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3575610: {
                value = new TriggerTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case -873664438: {
                this.timing = this.castToType(value);
                return value;
            }
            case 3076010: {
                this.data = this.castToDataRequirement(value);
                return value;
            }
            case -861311717: {
                this.condition = (TriggerDefinitionConditionComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("type")) {
            value = new TriggerTypeEnumFactory().fromType(this.castToCode(value));
            this.type = value;
        } else if (name.equals("name")) {
            this.name = this.castToString(value);
        } else if (name.equals("timing[x]")) {
            this.timing = this.castToType(value);
        } else if (name.equals("data")) {
            this.data = this.castToDataRequirement(value);
        } else if (name.equals("condition")) {
            this.condition = (TriggerDefinitionConditionComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return this.getTypeElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 164632566: {
                return this.getTiming();
            }
            case -873664438: {
                return this.getTiming();
            }
            case 3076010: {
                return this.getData();
            }
            case -861311717: {
                return this.getCondition();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return new String[]{"code"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -873664438: {
                return new String[]{"Timing", "Reference", "date", "dateTime"};
            }
            case 3076010: {
                return new String[]{"DataRequirement"};
            }
            case -861311717: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a primitive type TriggerDefinition.type");
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a primitive type TriggerDefinition.name");
        }
        if (name.equals("timingTiming")) {
            this.timing = new Timing();
            return this.timing;
        }
        if (name.equals("timingReference")) {
            this.timing = new Reference();
            return this.timing;
        }
        if (name.equals("timingDate")) {
            this.timing = new DateType();
            return this.timing;
        }
        if (name.equals("timingDateTime")) {
            this.timing = new DateTimeType();
            return this.timing;
        }
        if (name.equals("data")) {
            this.data = new DataRequirement();
            return this.data;
        }
        if (name.equals("condition")) {
            this.condition = new TriggerDefinitionConditionComponent();
            return this.condition;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "TriggerDefinition";
    }

    @Override
    public TriggerDefinition copy() {
        TriggerDefinition dst = new TriggerDefinition();
        this.copyValues(dst);
        dst.type = this.type == null ? null : this.type.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.timing = this.timing == null ? null : this.timing.copy();
        dst.data = this.data == null ? null : this.data.copy();
        dst.condition = this.condition == null ? null : this.condition.copy();
        return dst;
    }

    @Override
    protected TriggerDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof TriggerDefinition)) {
            return false;
        }
        TriggerDefinition o = (TriggerDefinition)other_;
        return TriggerDefinition.compareDeep(this.type, o.type, true) && TriggerDefinition.compareDeep(this.name, o.name, true) && TriggerDefinition.compareDeep(this.timing, o.timing, true) && TriggerDefinition.compareDeep(this.data, o.data, true) && TriggerDefinition.compareDeep(this.condition, o.condition, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof TriggerDefinition)) {
            return false;
        }
        TriggerDefinition o = (TriggerDefinition)other_;
        return TriggerDefinition.compareValues(this.type, o.type, true) && TriggerDefinition.compareValues(this.name, o.name, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.name, this.timing, this.data, this.condition});
    }

    @Block
    public static class TriggerDefinitionConditionComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Natural language description of the condition", formalDefinition="A brief, natural language description of the condition that effectively communicates the intended semantics.")
        protected StringType description;
        @Child(name="language", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="text/cql | text/fhirpath | etc.", formalDefinition="The media type of the language for the expression.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/expression-language")
        protected Enumeration<ExpressionLanguage> language;
        @Child(name="expression", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Boolean-valued expression", formalDefinition="An expression that returns true or false, indicating whether or not the condition is satisfied.")
        protected StringType expression;
        private static final long serialVersionUID = -1280303355L;

        public TriggerDefinitionConditionComponent() {
        }

        public TriggerDefinitionConditionComponent(Enumeration<ExpressionLanguage> language, StringType expression) {
            this.language = language;
            this.expression = expression;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TriggerDefinitionConditionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public TriggerDefinitionConditionComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public TriggerDefinitionConditionComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Enumeration<ExpressionLanguage> getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TriggerDefinitionConditionComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new Enumeration<ExpressionLanguage>(new ExpressionLanguageEnumFactory());
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public TriggerDefinitionConditionComponent setLanguageElement(Enumeration<ExpressionLanguage> value) {
            this.language = value;
            return this;
        }

        public ExpressionLanguage getLanguage() {
            return this.language == null ? null : (ExpressionLanguage)((Object)this.language.getValue());
        }

        public TriggerDefinitionConditionComponent setLanguage(ExpressionLanguage value) {
            if (this.language == null) {
                this.language = new Enumeration<ExpressionLanguage>(new ExpressionLanguageEnumFactory());
            }
            this.language.setValue((Object)value);
            return this;
        }

        public StringType getExpressionElement() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TriggerDefinitionConditionComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new StringType();
                }
            }
            return this.expression;
        }

        public boolean hasExpressionElement() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public TriggerDefinitionConditionComponent setExpressionElement(StringType value) {
            this.expression = value;
            return this;
        }

        public String getExpression() {
            return this.expression == null ? null : (String)this.expression.getValue();
        }

        public TriggerDefinitionConditionComponent setExpression(String value) {
            if (this.expression == null) {
                this.expression = new StringType();
            }
            this.expression.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "string", "A brief, natural language description of the condition that effectively communicates the intended semantics.", 0, 1, this.description));
            children.add(new Property("language", "code", "The media type of the language for the expression.", 0, 1, this.language));
            children.add(new Property("expression", "string", "An expression that returns true or false, indicating whether or not the condition is satisfied.", 0, 1, this.expression));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "string", "A brief, natural language description of the condition that effectively communicates the intended semantics.", 0, 1, this.description);
                }
                case -1613589672: {
                    return new Property("language", "code", "The media type of the language for the expression.", 0, 1, this.language);
                }
                case -1795452264: {
                    return new Property("expression", "string", "An expression that returns true or false, indicating whether or not the condition is satisfied.", 0, 1, this.expression);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.language;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.expression;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -1613589672: {
                    value = new ExpressionLanguageEnumFactory().fromType(this.castToCode(value));
                    this.language = value;
                    return value;
                }
                case -1795452264: {
                    this.expression = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("language")) {
                value = new ExpressionLanguageEnumFactory().fromType(this.castToCode(value));
                this.language = value;
            } else if (name.equals("expression")) {
                this.expression = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1613589672: {
                    return this.getLanguageElement();
                }
                case -1795452264: {
                    return this.getExpressionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1613589672: {
                    return new String[]{"code"};
                }
                case -1795452264: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type TriggerDefinition.description");
            }
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a primitive type TriggerDefinition.language");
            }
            if (name.equals("expression")) {
                throw new FHIRException("Cannot call addChild on a primitive type TriggerDefinition.expression");
            }
            return super.addChild(name);
        }

        @Override
        public TriggerDefinitionConditionComponent copy() {
            TriggerDefinitionConditionComponent dst = new TriggerDefinitionConditionComponent();
            this.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.language = this.language == null ? null : this.language.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TriggerDefinitionConditionComponent)) {
                return false;
            }
            TriggerDefinitionConditionComponent o = (TriggerDefinitionConditionComponent)other_;
            return TriggerDefinitionConditionComponent.compareDeep(this.description, o.description, true) && TriggerDefinitionConditionComponent.compareDeep(this.language, o.language, true) && TriggerDefinitionConditionComponent.compareDeep(this.expression, o.expression, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TriggerDefinitionConditionComponent)) {
                return false;
            }
            TriggerDefinitionConditionComponent o = (TriggerDefinitionConditionComponent)other_;
            return TriggerDefinitionConditionComponent.compareValues(this.description, o.description, true) && TriggerDefinitionConditionComponent.compareValues(this.language, o.language, true) && TriggerDefinitionConditionComponent.compareValues(this.expression, o.expression, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.language, this.expression});
        }

        @Override
        public String fhirType() {
            return "TriggerDefinition.condition";
        }
    }

    public static class ExpressionLanguageEnumFactory
    implements EnumFactory<ExpressionLanguage> {
        @Override
        public ExpressionLanguage fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("text/cql".equals(codeString)) {
                return ExpressionLanguage.TEXT_CQL;
            }
            if ("text/fhirpath".equals(codeString)) {
                return ExpressionLanguage.TEXT_FHIRPATH;
            }
            throw new IllegalArgumentException("Unknown ExpressionLanguage code '" + codeString + "'");
        }

        public Enumeration<ExpressionLanguage> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ExpressionLanguage>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("text/cql".equals(codeString)) {
                return new Enumeration<ExpressionLanguage>(this, ExpressionLanguage.TEXT_CQL);
            }
            if ("text/fhirpath".equals(codeString)) {
                return new Enumeration<ExpressionLanguage>(this, ExpressionLanguage.TEXT_FHIRPATH);
            }
            throw new FHIRException("Unknown ExpressionLanguage code '" + codeString + "'");
        }

        @Override
        public String toCode(ExpressionLanguage code) {
            if (code == ExpressionLanguage.TEXT_CQL) {
                return "text/cql";
            }
            if (code == ExpressionLanguage.TEXT_FHIRPATH) {
                return "text/fhirpath";
            }
            return "?";
        }

        @Override
        public String toSystem(ExpressionLanguage code) {
            return code.getSystem();
        }
    }

    public static enum ExpressionLanguage {
        TEXT_CQL,
        TEXT_FHIRPATH,
        NULL;


        public static ExpressionLanguage fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("text/cql".equals(codeString)) {
                return TEXT_CQL;
            }
            if ("text/fhirpath".equals(codeString)) {
                return TEXT_FHIRPATH;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ExpressionLanguage code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case TEXT_CQL: {
                    return "text/cql";
                }
                case TEXT_FHIRPATH: {
                    return "text/fhirpath";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case TEXT_CQL: {
                    return "http://hl7.org/fhir/expression-language";
                }
                case TEXT_FHIRPATH: {
                    return "http://hl7.org/fhir/expression-language";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case TEXT_CQL: {
                    return "Clinical Quality Language";
                }
                case TEXT_FHIRPATH: {
                    return "FHIRPath";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case TEXT_CQL: {
                    return "CQL";
                }
                case TEXT_FHIRPATH: {
                    return "FHIRPath";
                }
            }
            return "?";
        }
    }

    public static class TriggerTypeEnumFactory
    implements EnumFactory<TriggerType> {
        @Override
        public TriggerType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("named-event".equals(codeString)) {
                return TriggerType.NAMEDEVENT;
            }
            if ("periodic".equals(codeString)) {
                return TriggerType.PERIODIC;
            }
            if ("data-changed".equals(codeString)) {
                return TriggerType.DATACHANGED;
            }
            if ("data-added".equals(codeString)) {
                return TriggerType.DATAADDED;
            }
            if ("data-modified".equals(codeString)) {
                return TriggerType.DATAMODIFIED;
            }
            if ("data-removed".equals(codeString)) {
                return TriggerType.DATAREMOVED;
            }
            if ("data-accessed".equals(codeString)) {
                return TriggerType.DATAACCESSED;
            }
            if ("data-access-ended".equals(codeString)) {
                return TriggerType.DATAACCESSENDED;
            }
            throw new IllegalArgumentException("Unknown TriggerType code '" + codeString + "'");
        }

        public Enumeration<TriggerType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<TriggerType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("named-event".equals(codeString)) {
                return new Enumeration<TriggerType>(this, TriggerType.NAMEDEVENT);
            }
            if ("periodic".equals(codeString)) {
                return new Enumeration<TriggerType>(this, TriggerType.PERIODIC);
            }
            if ("data-changed".equals(codeString)) {
                return new Enumeration<TriggerType>(this, TriggerType.DATACHANGED);
            }
            if ("data-added".equals(codeString)) {
                return new Enumeration<TriggerType>(this, TriggerType.DATAADDED);
            }
            if ("data-modified".equals(codeString)) {
                return new Enumeration<TriggerType>(this, TriggerType.DATAMODIFIED);
            }
            if ("data-removed".equals(codeString)) {
                return new Enumeration<TriggerType>(this, TriggerType.DATAREMOVED);
            }
            if ("data-accessed".equals(codeString)) {
                return new Enumeration<TriggerType>(this, TriggerType.DATAACCESSED);
            }
            if ("data-access-ended".equals(codeString)) {
                return new Enumeration<TriggerType>(this, TriggerType.DATAACCESSENDED);
            }
            throw new FHIRException("Unknown TriggerType code '" + codeString + "'");
        }

        @Override
        public String toCode(TriggerType code) {
            if (code == TriggerType.NAMEDEVENT) {
                return "named-event";
            }
            if (code == TriggerType.PERIODIC) {
                return "periodic";
            }
            if (code == TriggerType.DATACHANGED) {
                return "data-changed";
            }
            if (code == TriggerType.DATAADDED) {
                return "data-added";
            }
            if (code == TriggerType.DATAMODIFIED) {
                return "data-modified";
            }
            if (code == TriggerType.DATAREMOVED) {
                return "data-removed";
            }
            if (code == TriggerType.DATAACCESSED) {
                return "data-accessed";
            }
            if (code == TriggerType.DATAACCESSENDED) {
                return "data-access-ended";
            }
            return "?";
        }

        @Override
        public String toSystem(TriggerType code) {
            return code.getSystem();
        }
    }

    public static enum TriggerType {
        NAMEDEVENT,
        PERIODIC,
        DATACHANGED,
        DATAADDED,
        DATAMODIFIED,
        DATAREMOVED,
        DATAACCESSED,
        DATAACCESSENDED,
        NULL;


        public static TriggerType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("named-event".equals(codeString)) {
                return NAMEDEVENT;
            }
            if ("periodic".equals(codeString)) {
                return PERIODIC;
            }
            if ("data-changed".equals(codeString)) {
                return DATACHANGED;
            }
            if ("data-added".equals(codeString)) {
                return DATAADDED;
            }
            if ("data-modified".equals(codeString)) {
                return DATAMODIFIED;
            }
            if ("data-removed".equals(codeString)) {
                return DATAREMOVED;
            }
            if ("data-accessed".equals(codeString)) {
                return DATAACCESSED;
            }
            if ("data-access-ended".equals(codeString)) {
                return DATAACCESSENDED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown TriggerType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NAMEDEVENT: {
                    return "named-event";
                }
                case PERIODIC: {
                    return "periodic";
                }
                case DATACHANGED: {
                    return "data-changed";
                }
                case DATAADDED: {
                    return "data-added";
                }
                case DATAMODIFIED: {
                    return "data-modified";
                }
                case DATAREMOVED: {
                    return "data-removed";
                }
                case DATAACCESSED: {
                    return "data-accessed";
                }
                case DATAACCESSENDED: {
                    return "data-access-ended";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NAMEDEVENT: {
                    return "http://hl7.org/fhir/trigger-type";
                }
                case PERIODIC: {
                    return "http://hl7.org/fhir/trigger-type";
                }
                case DATACHANGED: {
                    return "http://hl7.org/fhir/trigger-type";
                }
                case DATAADDED: {
                    return "http://hl7.org/fhir/trigger-type";
                }
                case DATAMODIFIED: {
                    return "http://hl7.org/fhir/trigger-type";
                }
                case DATAREMOVED: {
                    return "http://hl7.org/fhir/trigger-type";
                }
                case DATAACCESSED: {
                    return "http://hl7.org/fhir/trigger-type";
                }
                case DATAACCESSENDED: {
                    return "http://hl7.org/fhir/trigger-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NAMEDEVENT: {
                    return "The trigger occurs in response to a specific named event, and no other information about the trigger is specified. Named events are completely pre-coordinated, and the formal semantics of the trigger are not provided";
                }
                case PERIODIC: {
                    return "The trigger occurs at a specific time or periodically as described by a timing or schedule. A periodic event cannot have any data elements, but may have a name assigned as a shorthand for the event";
                }
                case DATACHANGED: {
                    return "The trigger occurs whenever data of a particular type is changed in any way, either added, modified, or removed";
                }
                case DATAADDED: {
                    return "The trigger occurs whenever data of a particular type is added";
                }
                case DATAMODIFIED: {
                    return "The trigger occurs whenever data of a particular type is modified";
                }
                case DATAREMOVED: {
                    return "The trigger occurs whenever data of a particular type is removed";
                }
                case DATAACCESSED: {
                    return "The trigger occurs whenever data of a particular type is accessed";
                }
                case DATAACCESSENDED: {
                    return "The trigger occurs whenever access to data of a particular type is completed";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NAMEDEVENT: {
                    return "Named Event";
                }
                case PERIODIC: {
                    return "Periodic";
                }
                case DATACHANGED: {
                    return "Data Changed";
                }
                case DATAADDED: {
                    return "Data Added";
                }
                case DATAMODIFIED: {
                    return "Data Updated";
                }
                case DATAREMOVED: {
                    return "Data Removed";
                }
                case DATAACCESSED: {
                    return "Data Accessed";
                }
                case DATAACCESSENDED: {
                    return "Data Access Ended";
                }
            }
            return "?";
        }
    }
}

