/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.AdverseEventCategory;

public class AdverseEventCategoryEnumFactory
implements EnumFactory<AdverseEventCategory> {
    @Override
    public AdverseEventCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("ProductProblem".equals(codeString)) {
            return AdverseEventCategory.PRODUCTPROBLEM;
        }
        if ("ProductQuality".equals(codeString)) {
            return AdverseEventCategory.PRODUCTQUALITY;
        }
        if ("ProductUseError".equals(codeString)) {
            return AdverseEventCategory.PRODUCTUSEERROR;
        }
        if ("WrongDose".equals(codeString)) {
            return AdverseEventCategory.WRONGDOSE;
        }
        if ("IncorrectPrescribingInformation".equals(codeString)) {
            return AdverseEventCategory.INCORRECTPRESCRIBINGINFORMATION;
        }
        if ("WrongTechnique".equals(codeString)) {
            return AdverseEventCategory.WRONGTECHNIQUE;
        }
        if ("WrongRouteOfAdministration".equals(codeString)) {
            return AdverseEventCategory.WRONGROUTEOFADMINISTRATION;
        }
        if ("WrongRate".equals(codeString)) {
            return AdverseEventCategory.WRONGRATE;
        }
        if ("WrongDuration".equals(codeString)) {
            return AdverseEventCategory.WRONGDURATION;
        }
        if ("WrongTime".equals(codeString)) {
            return AdverseEventCategory.WRONGTIME;
        }
        if ("ExpiredDrug".equals(codeString)) {
            return AdverseEventCategory.EXPIREDDRUG;
        }
        if ("MedicalDeviceUseError".equals(codeString)) {
            return AdverseEventCategory.MEDICALDEVICEUSEERROR;
        }
        if ("ProblemDifferentManufacturer".equals(codeString)) {
            return AdverseEventCategory.PROBLEMDIFFERENTMANUFACTURER;
        }
        if ("UnsafePhysicalEnvironment".equals(codeString)) {
            return AdverseEventCategory.UNSAFEPHYSICALENVIRONMENT;
        }
        throw new IllegalArgumentException("Unknown AdverseEventCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(AdverseEventCategory code) {
        if (code == AdverseEventCategory.PRODUCTPROBLEM) {
            return "ProductProblem";
        }
        if (code == AdverseEventCategory.PRODUCTQUALITY) {
            return "ProductQuality";
        }
        if (code == AdverseEventCategory.PRODUCTUSEERROR) {
            return "ProductUseError";
        }
        if (code == AdverseEventCategory.WRONGDOSE) {
            return "WrongDose";
        }
        if (code == AdverseEventCategory.INCORRECTPRESCRIBINGINFORMATION) {
            return "IncorrectPrescribingInformation";
        }
        if (code == AdverseEventCategory.WRONGTECHNIQUE) {
            return "WrongTechnique";
        }
        if (code == AdverseEventCategory.WRONGROUTEOFADMINISTRATION) {
            return "WrongRouteOfAdministration";
        }
        if (code == AdverseEventCategory.WRONGRATE) {
            return "WrongRate";
        }
        if (code == AdverseEventCategory.WRONGDURATION) {
            return "WrongDuration";
        }
        if (code == AdverseEventCategory.WRONGTIME) {
            return "WrongTime";
        }
        if (code == AdverseEventCategory.EXPIREDDRUG) {
            return "ExpiredDrug";
        }
        if (code == AdverseEventCategory.MEDICALDEVICEUSEERROR) {
            return "MedicalDeviceUseError";
        }
        if (code == AdverseEventCategory.PROBLEMDIFFERENTMANUFACTURER) {
            return "ProblemDifferentManufacturer";
        }
        if (code == AdverseEventCategory.UNSAFEPHYSICALENVIRONMENT) {
            return "UnsafePhysicalEnvironment";
        }
        return "?";
    }

    @Override
    public String toSystem(AdverseEventCategory code) {
        return code.getSystem();
    }
}

