/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AssertDirectionCodes {
    RESPONSE,
    REQUEST,
    NULL;


    public static AssertDirectionCodes fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("response".equals(codeString)) {
            return RESPONSE;
        }
        if ("request".equals(codeString)) {
            return REQUEST;
        }
        throw new FHIRException("Unknown AssertDirectionCodes code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case RESPONSE: {
                return "response";
            }
            case REQUEST: {
                return "request";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/assert-direction-codes";
    }

    public String getDefinition() {
        switch (this) {
            case RESPONSE: {
                return "The assertion is evaluated on the response. This is the default value.";
            }
            case REQUEST: {
                return "The assertion is evaluated on the request.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case RESPONSE: {
                return "response";
            }
            case REQUEST: {
                return "request";
            }
        }
        return "?";
    }
}

