/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AuditSourceType {
    _1,
    _2,
    _3,
    _4,
    _5,
    _6,
    _7,
    _8,
    _9,
    NULL;


    public static AuditSourceType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("1".equals(codeString)) {
            return _1;
        }
        if ("2".equals(codeString)) {
            return _2;
        }
        if ("3".equals(codeString)) {
            return _3;
        }
        if ("4".equals(codeString)) {
            return _4;
        }
        if ("5".equals(codeString)) {
            return _5;
        }
        if ("6".equals(codeString)) {
            return _6;
        }
        if ("7".equals(codeString)) {
            return _7;
        }
        if ("8".equals(codeString)) {
            return _8;
        }
        if ("9".equals(codeString)) {
            return _9;
        }
        throw new FHIRException("Unknown AuditSourceType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _1: {
                return "1";
            }
            case _2: {
                return "2";
            }
            case _3: {
                return "3";
            }
            case _4: {
                return "4";
            }
            case _5: {
                return "5";
            }
            case _6: {
                return "6";
            }
            case _7: {
                return "7";
            }
            case _8: {
                return "8";
            }
            case _9: {
                return "9";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/security-source-type";
    }

    public String getDefinition() {
        switch (this) {
            case _1: {
                return "End-user display device, diagnostic device.";
            }
            case _2: {
                return "Data acquisition device or instrument.";
            }
            case _3: {
                return "Web Server process or thread.";
            }
            case _4: {
                return "Application Server process or thread.";
            }
            case _5: {
                return "Database Server process or thread.";
            }
            case _6: {
                return "Security server, e.g. a domain controller.";
            }
            case _7: {
                return "ISO level 1-3 network component.";
            }
            case _8: {
                return "ISO level 4-6 operating software.";
            }
            case _9: {
                return "Other kind of device (defined by DICOM, but some other code/system can be used).";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _1: {
                return "User Device";
            }
            case _2: {
                return "Data Interface";
            }
            case _3: {
                return "Web Server";
            }
            case _4: {
                return "Application Server";
            }
            case _5: {
                return "Database Server";
            }
            case _6: {
                return "Security Server";
            }
            case _7: {
                return "Network Device";
            }
            case _8: {
                return "Network Router";
            }
            case _9: {
                return "Other";
            }
        }
        return "?";
    }
}

