/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CarePlanActivityStatus {
    NOTSTARTED,
    SCHEDULED,
    INPROGRESS,
    ONHOLD,
    COMPLETED,
    CANCELLED,
    STOPPED,
    UNKNOWN,
    NULL;


    public static CarePlanActivityStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("not-started".equals(codeString)) {
            return NOTSTARTED;
        }
        if ("scheduled".equals(codeString)) {
            return SCHEDULED;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("on-hold".equals(codeString)) {
            return ONHOLD;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("stopped".equals(codeString)) {
            return STOPPED;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown CarePlanActivityStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NOTSTARTED: {
                return "not-started";
            }
            case SCHEDULED: {
                return "scheduled";
            }
            case INPROGRESS: {
                return "in-progress";
            }
            case ONHOLD: {
                return "on-hold";
            }
            case COMPLETED: {
                return "completed";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case STOPPED: {
                return "stopped";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/care-plan-activity-status";
    }

    public String getDefinition() {
        switch (this) {
            case NOTSTARTED: {
                return "Activity is planned but no action has yet been taken.";
            }
            case SCHEDULED: {
                return "Appointment or other booking has occurred but activity has not yet begun.";
            }
            case INPROGRESS: {
                return "Activity has been started but is not yet complete.";
            }
            case ONHOLD: {
                return "Activity was started but has temporarily ceased with an expectation of resumption at a future time.";
            }
            case COMPLETED: {
                return "The activity has been completed (more or less) as planned.";
            }
            case CANCELLED: {
                return "The planned activity has been withdrawn.";
            }
            case STOPPED: {
                return "The planned activity has been ended prior to completion after the activity was started.";
            }
            case UNKNOWN: {
                return "The current state of the activity is not known.  Note: This concept is not to be used for \"other\".";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NOTSTARTED: {
                return "Not Started";
            }
            case SCHEDULED: {
                return "Scheduled";
            }
            case INPROGRESS: {
                return "In Progress";
            }
            case ONHOLD: {
                return "On Hold";
            }
            case COMPLETED: {
                return "Completed";
            }
            case CANCELLED: {
                return "Cancelled";
            }
            case STOPPED: {
                return "Stopped";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "?";
    }
}

