/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ClinicalImpressionStatus {
    DRAFT,
    COMPLETED,
    ENTEREDINERROR,
    NULL;


    public static ClinicalImpressionStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown ClinicalImpressionStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DRAFT: {
                return "draft";
            }
            case COMPLETED: {
                return "completed";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/clinical-impression-status";
    }

    public String getDefinition() {
        switch (this) {
            case DRAFT: {
                return "The assessment is still on-going and results are not yet final.";
            }
            case COMPLETED: {
                return "The assessment is done and the results are final.";
            }
            case ENTEREDINERROR: {
                return "This assessment was never actually done and the record is erroneous (e.g. Wrong patient).";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DRAFT: {
                return "In progress";
            }
            case COMPLETED: {
                return "Completed";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
        }
        return "?";
    }
}

