/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum DoseRateType {
    CALCULATED,
    ORDERED,
    NULL;


    public static DoseRateType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("calculated".equals(codeString)) {
            return CALCULATED;
        }
        if ("ordered".equals(codeString)) {
            return ORDERED;
        }
        throw new FHIRException("Unknown DoseRateType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CALCULATED: {
                return "calculated";
            }
            case ORDERED: {
                return "ordered";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/dose-rate-type";
    }

    public String getDefinition() {
        switch (this) {
            case CALCULATED: {
                return "The dose specified is calculated by the prescriber or the system";
            }
            case ORDERED: {
                return "The dose specified is as ordered by the prescriber";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CALCULATED: {
                return "Calculated";
            }
            case ORDERED: {
                return "Ordered";
            }
        }
        return "?";
    }
}

