/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.MediaCategory;

public class MediaCategoryEnumFactory
implements EnumFactory<MediaCategory> {
    @Override
    public MediaCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("image".equals(codeString)) {
            return MediaCategory.IMAGE;
        }
        if ("video".equals(codeString)) {
            return MediaCategory.VIDEO;
        }
        if ("audio".equals(codeString)) {
            return MediaCategory.AUDIO;
        }
        throw new IllegalArgumentException("Unknown MediaCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(MediaCategory code) {
        if (code == MediaCategory.IMAGE) {
            return "image";
        }
        if (code == MediaCategory.VIDEO) {
            return "video";
        }
        if (code == MediaCategory.AUDIO) {
            return "audio";
        }
        return "?";
    }

    @Override
    public String toSystem(MediaCategory code) {
        return code.getSystem();
    }
}

