/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.MediaModality;

public class MediaModalityEnumFactory
implements EnumFactory<MediaModality> {
    @Override
    public MediaModality fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("diagram".equals(codeString)) {
            return MediaModality.DIAGRAM;
        }
        if ("fax".equals(codeString)) {
            return MediaModality.FAX;
        }
        if ("scan".equals(codeString)) {
            return MediaModality.SCAN;
        }
        if ("retina".equals(codeString)) {
            return MediaModality.RETINA;
        }
        if ("fingerprint".equals(codeString)) {
            return MediaModality.FINGERPRINT;
        }
        if ("iris".equals(codeString)) {
            return MediaModality.IRIS;
        }
        if ("palm".equals(codeString)) {
            return MediaModality.PALM;
        }
        if ("face".equals(codeString)) {
            return MediaModality.FACE;
        }
        throw new IllegalArgumentException("Unknown MediaModality code '" + codeString + "'");
    }

    @Override
    public String toCode(MediaModality code) {
        if (code == MediaModality.DIAGRAM) {
            return "diagram";
        }
        if (code == MediaModality.FAX) {
            return "fax";
        }
        if (code == MediaModality.SCAN) {
            return "scan";
        }
        if (code == MediaModality.RETINA) {
            return "retina";
        }
        if (code == MediaModality.FINGERPRINT) {
            return "fingerprint";
        }
        if (code == MediaModality.IRIS) {
            return "iris";
        }
        if (code == MediaModality.PALM) {
            return "palm";
        }
        if (code == MediaModality.FACE) {
            return "face";
        }
        return "?";
    }

    @Override
    public String toSystem(MediaModality code) {
        return code.getSystem();
    }
}

