/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.MediaStatus;

public class MediaStatusEnumFactory
implements EnumFactory<MediaStatus> {
    @Override
    public MediaStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("preparation".equals(codeString)) {
            return MediaStatus.PREPARATION;
        }
        if ("in-progress".equals(codeString)) {
            return MediaStatus.INPROGRESS;
        }
        if ("not-done".equals(codeString)) {
            return MediaStatus.NOTDONE;
        }
        if ("suspended".equals(codeString)) {
            return MediaStatus.SUSPENDED;
        }
        if ("aborted".equals(codeString)) {
            return MediaStatus.ABORTED;
        }
        if ("completed".equals(codeString)) {
            return MediaStatus.COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return MediaStatus.ENTEREDINERROR;
        }
        if ("unknown".equals(codeString)) {
            return MediaStatus.UNKNOWN;
        }
        throw new IllegalArgumentException("Unknown MediaStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(MediaStatus code) {
        if (code == MediaStatus.PREPARATION) {
            return "preparation";
        }
        if (code == MediaStatus.INPROGRESS) {
            return "in-progress";
        }
        if (code == MediaStatus.NOTDONE) {
            return "not-done";
        }
        if (code == MediaStatus.SUSPENDED) {
            return "suspended";
        }
        if (code == MediaStatus.ABORTED) {
            return "aborted";
        }
        if (code == MediaStatus.COMPLETED) {
            return "completed";
        }
        if (code == MediaStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        if (code == MediaStatus.UNKNOWN) {
            return "unknown";
        }
        return "?";
    }

    @Override
    public String toSystem(MediaStatus code) {
        return code.getSystem();
    }
}

