/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum PropertyRepresentation {
    XMLATTR,
    XMLTEXT,
    TYPEATTR,
    CDATEXT,
    XHTML,
    NULL;


    public static PropertyRepresentation fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("xmlAttr".equals(codeString)) {
            return XMLATTR;
        }
        if ("xmlText".equals(codeString)) {
            return XMLTEXT;
        }
        if ("typeAttr".equals(codeString)) {
            return TYPEATTR;
        }
        if ("cdaText".equals(codeString)) {
            return CDATEXT;
        }
        if ("xhtml".equals(codeString)) {
            return XHTML;
        }
        throw new FHIRException("Unknown PropertyRepresentation code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case XMLATTR: {
                return "xmlAttr";
            }
            case XMLTEXT: {
                return "xmlText";
            }
            case TYPEATTR: {
                return "typeAttr";
            }
            case CDATEXT: {
                return "cdaText";
            }
            case XHTML: {
                return "xhtml";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/property-representation";
    }

    public String getDefinition() {
        switch (this) {
            case XMLATTR: {
                return "In XML, this property is represented as an attribute not an element.";
            }
            case XMLTEXT: {
                return "This element is represented using the XML text attribute (primitives only)";
            }
            case TYPEATTR: {
                return "The type of this element is indicated using xsi:type";
            }
            case CDATEXT: {
                return "Use CDA narrative instead of XHTML";
            }
            case XHTML: {
                return "The property is represented using XHTML";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case XMLATTR: {
                return "XML Attribute";
            }
            case XMLTEXT: {
                return "XML Text";
            }
            case TYPEATTR: {
                return "Type Attribute";
            }
            case CDATEXT: {
                return "CDA Text Format";
            }
            case XHTML: {
                return "XHTML";
            }
        }
        return "?";
    }
}

