/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SpecimenContainedPreference {
    PREFERRED,
    ALTERNATE,
    NULL;


    public static SpecimenContainedPreference fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("preferred".equals(codeString)) {
            return PREFERRED;
        }
        if ("alternate".equals(codeString)) {
            return ALTERNATE;
        }
        throw new FHIRException("Unknown SpecimenContainedPreference code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PREFERRED: {
                return "preferred";
            }
            case ALTERNATE: {
                return "alternate";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/specimen-contained-preference";
    }

    public String getDefinition() {
        switch (this) {
            case PREFERRED: {
                return "This type of contained specimen is preferred to collect this kind of specimen";
            }
            case ALTERNATE: {
                return "This type of conditioned specimen is an alternate";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PREFERRED: {
                return "Preferred";
            }
            case ALTERNATE: {
                return "Alternate";
            }
        }
        return "?";
    }
}

