/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ValidationProcess {
    EDITCHECK,
    VALUESET,
    PRIMARY,
    MULTI,
    STANDALONE,
    INCONTEXT,
    NULL;


    public static ValidationProcess fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("edit-check".equals(codeString)) {
            return EDITCHECK;
        }
        if ("valueset".equals(codeString)) {
            return VALUESET;
        }
        if ("primary".equals(codeString)) {
            return PRIMARY;
        }
        if ("multi".equals(codeString)) {
            return MULTI;
        }
        if ("standalone".equals(codeString)) {
            return STANDALONE;
        }
        if ("in-context".equals(codeString)) {
            return INCONTEXT;
        }
        throw new FHIRException("Unknown ValidationProcess code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case EDITCHECK: {
                return "edit-check";
            }
            case VALUESET: {
                return "valueset";
            }
            case PRIMARY: {
                return "primary";
            }
            case MULTI: {
                return "multi";
            }
            case STANDALONE: {
                return "standalone";
            }
            case INCONTEXT: {
                return "in-context";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/validation-process";
    }

    public String getDefinition() {
        switch (this) {
            case EDITCHECK: {
                return "";
            }
            case VALUESET: {
                return "";
            }
            case PRIMARY: {
                return "";
            }
            case MULTI: {
                return "";
            }
            case STANDALONE: {
                return "";
            }
            case INCONTEXT: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case EDITCHECK: {
                return "edit check";
            }
            case VALUESET: {
                return "value set";
            }
            case PRIMARY: {
                return "primary source";
            }
            case MULTI: {
                return "multiple sources";
            }
            case STANDALONE: {
                return "standalone";
            }
            case INCONTEXT: {
                return "in context";
            }
        }
        return "?";
    }
}

