/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.ValidationType;

public class ValidationTypeEnumFactory
implements EnumFactory<ValidationType> {
    @Override
    public ValidationType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("nothing".equals(codeString)) {
            return ValidationType.NOTHING;
        }
        if ("primary".equals(codeString)) {
            return ValidationType.PRIMARY;
        }
        if ("multiple".equals(codeString)) {
            return ValidationType.MULTIPLE;
        }
        throw new IllegalArgumentException("Unknown ValidationType code '" + codeString + "'");
    }

    @Override
    public String toCode(ValidationType code) {
        if (code == ValidationType.NOTHING) {
            return "nothing";
        }
        if (code == ValidationType.PRIMARY) {
            return "primary";
        }
        if (code == ValidationType.MULTIPLE) {
            return "multiple";
        }
        return "?";
    }

    @Override
    public String toSystem(ValidationType code) {
        return code.getSystem();
    }
}

