/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.hapi.rest.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Metadata;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.Bindings;
import ca.uhn.fhir.rest.server.IServerConformanceProvider;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerConfiguration;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import ca.uhn.fhir.rest.server.method.OperationMethodBinding;
import ca.uhn.fhir.rest.server.method.OperationParameter;
import ca.uhn.fhir.rest.server.method.SearchMethodBinding;
import ca.uhn.fhir.rest.server.method.SearchParameter;
import ca.uhn.fhir.rest.server.util.BaseServerCapabilityStatementProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.OperationDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCapabilityStatementProvider
extends BaseServerCapabilityStatementProvider
implements IServerConformanceProvider<CapabilityStatement> {
    private static final Logger ourLog = LoggerFactory.getLogger(ServerCapabilityStatementProvider.class);
    private String myPublisher = "Not provided";

    public ServerCapabilityStatementProvider() {
    }

    @Deprecated
    public ServerCapabilityStatementProvider(RestfulServer theRestfulServer) {
        this();
    }

    public ServerCapabilityStatementProvider(RestfulServerConfiguration theServerConfiguration) {
        super(theServerConfiguration);
    }

    private void checkBindingForSystemOps(CapabilityStatement.CapabilityStatementRestComponent rest, Set<CapabilityStatement.SystemRestfulInteraction> systemOps, BaseMethodBinding<?> nextMethodBinding) {
        String sysOpCode;
        if (nextMethodBinding.getRestOperationType() != null && (sysOpCode = nextMethodBinding.getRestOperationType().getCode()) != null) {
            CapabilityStatement.SystemRestfulInteraction sysOp;
            try {
                sysOp = CapabilityStatement.SystemRestfulInteraction.fromCode((String)sysOpCode);
            }
            catch (FHIRException e) {
                return;
            }
            if (sysOp == null) {
                return;
            }
            if (!systemOps.contains(sysOp)) {
                systemOps.add(sysOp);
                rest.addInteraction().setCode(sysOp);
            }
        }
    }

    private DateTimeType conformanceDate(RequestDetails theRequestDetails) {
        IPrimitiveType buildDate = this.getServerConfiguration(theRequestDetails).getConformanceDate();
        if (buildDate != null && buildDate.getValue() != null) {
            try {
                return new DateTimeType(buildDate.getValueAsString());
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }
        return DateTimeType.now();
    }

    public String getPublisher() {
        return this.myPublisher;
    }

    public void setPublisher(String thePublisher) {
        this.myPublisher = thePublisher;
    }

    @Metadata
    public CapabilityStatement getServerConformance(HttpServletRequest theRequest, RequestDetails theRequestDetails) {
        RestfulServerConfiguration configuration = this.getServerConfiguration(theRequestDetails);
        Bindings bindings = configuration.provideBindings();
        CapabilityStatement retVal = new CapabilityStatement();
        retVal.setPublisher(this.myPublisher);
        retVal.setDateElement(this.conformanceDate(theRequestDetails));
        retVal.setFhirVersion(Enumerations.FHIRVersion.fromCode((String)FhirVersionEnum.R4.getFhirVersionString()));
        ServletContext servletContext = (ServletContext)(theRequest == null ? null : theRequest.getAttribute("ca.uhn.fhir.rest.server.RestfulServer.servlet_context"));
        String serverBase = configuration.getServerAddressStrategy().determineServerBase(servletContext, theRequest);
        retVal.getImplementation().setUrl(serverBase).setDescription(configuration.getImplementationDescription());
        retVal.setKind(CapabilityStatement.CapabilityStatementKind.INSTANCE);
        retVal.getSoftware().setName(configuration.getServerName());
        retVal.getSoftware().setVersion(configuration.getServerVersion());
        retVal.addFormat("application/fhir+xml");
        retVal.addFormat("application/fhir+json");
        retVal.setStatus(Enumerations.PublicationStatus.ACTIVE);
        CapabilityStatement.CapabilityStatementRestComponent rest = retVal.addRest();
        rest.setMode(CapabilityStatement.RestfulCapabilityMode.SERVER);
        HashSet<CapabilityStatement.SystemRestfulInteraction> systemOps = new HashSet<CapabilityStatement.SystemRestfulInteraction>();
        HashSet<String> operationNames = new HashSet<String>();
        Map resourceToMethods = configuration.collectMethodBindings();
        Map resourceNameToSharedSupertype = configuration.getNameToSharedSupertype();
        for (Map.Entry nextEntry : resourceToMethods.entrySet()) {
            if (!((String)nextEntry.getKey()).isEmpty()) {
                HashSet<CapabilityStatement.TypeRestfulInteraction> resourceOps = new HashSet<CapabilityStatement.TypeRestfulInteraction>();
                CapabilityStatement.CapabilityStatementRestResourceComponent resource = rest.addResource();
                String resourceName = (String)nextEntry.getKey();
                FhirContext context = configuration.getFhirContext();
                RuntimeResourceDefinition def = resourceNameToSharedSupertype.containsKey(resourceName) ? context.getResourceDefinition((Class)resourceNameToSharedSupertype.get(resourceName)) : context.getResourceDefinition(resourceName);
                resource.getTypeElement().setValue((Object)def.getName());
                resource.getProfileElement().setValue((Object)def.getResourceProfile(serverBase));
                TreeSet<String> includes = new TreeSet<String>();
                for (BaseMethodBinding nextMethodBinding : (List)nextEntry.getValue()) {
                    SearchMethodBinding methodBinding;
                    nextMethodBinding.getRestOperationType();
                    String resOpCode = nextMethodBinding.getRestOperationType().getCode();
                    if (resOpCode != null) {
                        CapabilityStatement.TypeRestfulInteraction resOp;
                        try {
                            resOp = CapabilityStatement.TypeRestfulInteraction.fromCode((String)resOpCode);
                        }
                        catch (Exception e) {
                            resOp = null;
                        }
                        if (resOp != null) {
                            if (!resourceOps.contains(resOp)) {
                                resourceOps.add(resOp);
                                resource.addInteraction().setCode(resOp);
                            }
                            if ("vread".equals(resOpCode) && !resourceOps.contains(resOp = CapabilityStatement.TypeRestfulInteraction.READ)) {
                                resourceOps.add(resOp);
                                resource.addInteraction().setCode(resOp);
                            }
                            if (nextMethodBinding.isSupportsConditional()) {
                                switch (resOp) {
                                    case CREATE: {
                                        resource.setConditionalCreate(true);
                                        break;
                                    }
                                    case DELETE: {
                                        if (nextMethodBinding.isSupportsConditionalMultiple()) {
                                            resource.setConditionalDelete(CapabilityStatement.ConditionalDeleteStatus.MULTIPLE);
                                            break;
                                        }
                                        resource.setConditionalDelete(CapabilityStatement.ConditionalDeleteStatus.SINGLE);
                                        break;
                                    }
                                    case UPDATE: {
                                        resource.setConditionalUpdate(true);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    this.checkBindingForSystemOps(rest, systemOps, nextMethodBinding);
                    if (nextMethodBinding instanceof SearchMethodBinding) {
                        methodBinding = (SearchMethodBinding)nextMethodBinding;
                        if (methodBinding.getQueryName() != null) {
                            String queryName = (String)bindings.getNamedSearchMethodBindingToName().get(methodBinding);
                            if (operationNames.add(queryName)) {
                                rest.addOperation().setName(methodBinding.getQueryName()).setDefinition(this.getOperationDefinitionPrefix(theRequestDetails) + "OperationDefinition/" + queryName);
                            }
                        } else {
                            this.handleNamelessSearchMethodBinding(resource, def, includes, (SearchMethodBinding)nextMethodBinding, theRequestDetails);
                        }
                    } else if (nextMethodBinding instanceof OperationMethodBinding) {
                        methodBinding = (OperationMethodBinding)nextMethodBinding;
                        String opName = (String)bindings.getOperationBindingToName().get(methodBinding);
                        if (operationNames.add(opName)) {
                            rest.addOperation().setName(methodBinding.getName().substring(1)).setDefinition(this.getOperationDefinitionPrefix(theRequestDetails) + "OperationDefinition/" + opName);
                        }
                    }
                    resource.getInteraction().sort(new Comparator<CapabilityStatement.ResourceInteractionComponent>(){

                        @Override
                        public int compare(CapabilityStatement.ResourceInteractionComponent theO1, CapabilityStatement.ResourceInteractionComponent theO2) {
                            CapabilityStatement.TypeRestfulInteraction o1 = theO1.getCode();
                            CapabilityStatement.TypeRestfulInteraction o2 = theO2.getCode();
                            if (o1 == null && o2 == null) {
                                return 0;
                            }
                            if (o1 == null) {
                                return 1;
                            }
                            if (o2 == null) {
                                return -1;
                            }
                            return o1.ordinal() - o2.ordinal();
                        }
                    });
                }
                for (String nextInclude : includes) {
                    resource.addSearchInclude(nextInclude);
                }
                continue;
            }
            for (BaseMethodBinding nextMethodBinding : (List)nextEntry.getValue()) {
                this.checkBindingForSystemOps(rest, systemOps, nextMethodBinding);
                if (!(nextMethodBinding instanceof OperationMethodBinding)) continue;
                OperationMethodBinding methodBinding = (OperationMethodBinding)nextMethodBinding;
                String opName = (String)bindings.getOperationBindingToName().get(methodBinding);
                if (!operationNames.add(opName)) continue;
                ourLog.debug("Found bound operation: {}", (Object)opName);
                rest.addOperation().setName(methodBinding.getName().substring(1)).setDefinition(this.getOperationDefinitionPrefix(theRequestDetails) + "OperationDefinition/" + opName);
            }
        }
        return retVal;
    }

    protected String getOperationDefinitionPrefix(RequestDetails theRequestDetails) {
        if (theRequestDetails == null) {
            return "";
        }
        return theRequestDetails.getServerBaseForRequest() + "/";
    }

    private void handleNamelessSearchMethodBinding(CapabilityStatement.CapabilityStatementRestResourceComponent resource, RuntimeResourceDefinition def, TreeSet<String> includes, SearchMethodBinding searchMethodBinding, RequestDetails theRequestDetails) {
        includes.addAll(searchMethodBinding.getIncludes());
        List params = searchMethodBinding.getParameters();
        ArrayList<SearchParameter> searchParameters = new ArrayList<SearchParameter>();
        for (IParameter nextParameter : params) {
            if (!(nextParameter instanceof SearchParameter)) continue;
            searchParameters.add((SearchParameter)nextParameter);
        }
        this.sortSearchParameters(searchParameters);
        if (!searchParameters.isEmpty()) {
            HashSet<String> paramNames = new HashSet<String>();
            for (SearchParameter nextParameter : searchParameters) {
                RuntimeSearchParam paramDef;
                String nextParamName;
                if (nextParameter.getParamType() == null) {
                    ourLog.warn("SearchParameter {}:{} does not declare a type - Not exporting in CapabilityStatement", (Object)def.getName(), (Object)nextParameter.getName());
                    continue;
                }
                String nextParamUnchainedName = nextParamName = nextParameter.getName();
                if (nextParamName.contains(".")) {
                    nextParamUnchainedName = nextParamName.substring(0, nextParamName.indexOf(46));
                }
                if (!paramNames.add(nextParamUnchainedName)) continue;
                String nextParamDescription = nextParameter.getDescription();
                if (StringUtils.isBlank((CharSequence)nextParamDescription) && (paramDef = def.getSearchParam(nextParamUnchainedName)) != null) {
                    nextParamDescription = paramDef.getDescription();
                }
                CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent param = resource.addSearchParam();
                String typeCode = nextParameter.getParamType().getCode();
                param.getTypeElement().setValueAsString(typeCode);
                param.setName(nextParamUnchainedName);
                param.setDocumentation(nextParamDescription);
            }
        }
    }

    @Read(type=OperationDefinition.class)
    public OperationDefinition readOperationDefinition(@IdParam IdType theId, RequestDetails theRequestDetails) {
        if (theId == null || !theId.hasIdPart()) {
            throw new ResourceNotFoundException((IIdType)theId);
        }
        RestfulServerConfiguration configuration = this.getServerConfiguration(theRequestDetails);
        Bindings bindings = configuration.provideBindings();
        List operationBindings = (List)bindings.getOperationNameToBindings().get(theId.getIdPart());
        if (operationBindings != null && !operationBindings.isEmpty()) {
            return this.readOperationDefinitionForOperation(operationBindings);
        }
        List searchBindings = (List)bindings.getSearchNameToBindings().get(theId.getIdPart());
        if (searchBindings != null && !searchBindings.isEmpty()) {
            return this.readOperationDefinitionForNamedSearch(searchBindings);
        }
        throw new ResourceNotFoundException((IIdType)theId);
    }

    private OperationDefinition readOperationDefinitionForNamedSearch(List<SearchMethodBinding> bindings) {
        OperationDefinition op = new OperationDefinition();
        op.setStatus(Enumerations.PublicationStatus.ACTIVE);
        op.setKind(OperationDefinition.OperationKind.QUERY);
        op.setAffectsState(false);
        op.setSystem(false);
        op.setType(false);
        op.setInstance(false);
        HashSet<String> inParams = new HashSet<String>();
        for (SearchMethodBinding binding : bindings) {
            if (StringUtils.isNotBlank((CharSequence)binding.getDescription())) {
                op.setDescription(binding.getDescription());
            }
            if (StringUtils.isBlank((CharSequence)binding.getResourceProviderResourceName())) {
                op.setSystem(true);
            } else {
                op.setType(true);
                op.addResourceElement().setValue((Object)binding.getResourceProviderResourceName());
            }
            op.setCode(binding.getQueryName());
            for (IParameter nextParamUntyped : binding.getParameters()) {
                SearchParameter nextParam;
                if (!(nextParamUntyped instanceof SearchParameter) || !inParams.add((nextParam = (SearchParameter)nextParamUntyped).getName())) continue;
                OperationDefinition.OperationDefinitionParameterComponent param = op.addParameter();
                param.setUse(OperationDefinition.OperationParameterUse.IN);
                param.setType("string");
                param.getSearchTypeElement().setValueAsString(nextParam.getParamType().getCode());
                param.setMin(nextParam.isRequired() ? 1 : 0);
                param.setMax("1");
                param.setName(nextParam.getName());
            }
            if (!StringUtils.isBlank((CharSequence)op.getName())) continue;
            if (StringUtils.isNotBlank((CharSequence)op.getDescription())) {
                op.setName(op.getDescription());
                continue;
            }
            op.setName(op.getCode());
        }
        return op;
    }

    private OperationDefinition readOperationDefinitionForOperation(List<OperationMethodBinding> bindings) {
        OperationDefinition op = new OperationDefinition();
        op.setStatus(Enumerations.PublicationStatus.ACTIVE);
        op.setKind(OperationDefinition.OperationKind.OPERATION);
        op.setAffectsState(false);
        op.setSystem(false);
        op.setType(false);
        op.setInstance(false);
        HashSet<String> inParams = new HashSet<String>();
        HashSet<String> outParams = new HashSet<String>();
        for (OperationMethodBinding sharedDescription : bindings) {
            if (StringUtils.isNotBlank((CharSequence)sharedDescription.getDescription())) {
                op.setDescription(sharedDescription.getDescription());
            }
            if (sharedDescription.isCanOperateAtInstanceLevel()) {
                op.setInstance(true);
            }
            if (sharedDescription.isCanOperateAtServerLevel()) {
                op.setSystem(true);
            }
            if (sharedDescription.isCanOperateAtTypeLevel()) {
                op.setType(true);
            }
            if (!sharedDescription.isIdempotent()) {
                op.setAffectsState(!sharedDescription.isIdempotent());
            }
            op.setCode(sharedDescription.getName().substring(1));
            if (sharedDescription.isCanOperateAtInstanceLevel()) {
                op.setInstance(sharedDescription.isCanOperateAtInstanceLevel());
            }
            if (sharedDescription.isCanOperateAtServerLevel()) {
                op.setSystem(sharedDescription.isCanOperateAtServerLevel());
            }
            if (StringUtils.isNotBlank((CharSequence)sharedDescription.getResourceName())) {
                op.addResourceElement().setValue((Object)sharedDescription.getResourceName());
            }
            for (IParameter nextParamUntyped : sharedDescription.getParameters()) {
                if (!(nextParamUntyped instanceof OperationParameter)) continue;
                OperationParameter nextParam = (OperationParameter)nextParamUntyped;
                OperationDefinition.OperationDefinitionParameterComponent param = op.addParameter();
                if (!inParams.add(nextParam.getName())) continue;
                param.setUse(OperationDefinition.OperationParameterUse.IN);
                if (nextParam.getParamType() != null) {
                    param.setType(nextParam.getParamType());
                }
                if (nextParam.getSearchParamType() != null) {
                    param.getSearchTypeElement().setValueAsString(nextParam.getSearchParamType());
                }
                param.setMin(nextParam.getMin());
                param.setMax(nextParam.getMax() == -1 ? "*" : Integer.toString(nextParam.getMax()));
                param.setName(nextParam.getName());
            }
            for (OperationMethodBinding.ReturnType nextParam : sharedDescription.getReturnParams()) {
                if (!outParams.add(nextParam.getName())) continue;
                OperationDefinition.OperationDefinitionParameterComponent param = op.addParameter();
                param.setUse(OperationDefinition.OperationParameterUse.OUT);
                if (nextParam.getType() != null) {
                    param.setType(nextParam.getType());
                }
                param.setMin(nextParam.getMin());
                param.setMax(nextParam.getMax() == -1 ? "*" : Integer.toString(nextParam.getMax()));
                param.setName(nextParam.getName());
            }
        }
        if (StringUtils.isBlank((CharSequence)op.getName())) {
            if (StringUtils.isNotBlank((CharSequence)op.getDescription())) {
                op.setName(op.getDescription());
            } else {
                op.setName(op.getCode());
            }
        }
        if (!op.hasSystem()) {
            op.setSystem(false);
        }
        if (!op.hasInstance()) {
            op.setInstance(false);
        }
        return op;
    }

    @Deprecated
    public ServerCapabilityStatementProvider setCache(boolean theCache) {
        return this;
    }

    public void setRestfulServer(RestfulServer theRestfulServer) {
    }

    private void sortSearchParameters(List<SearchParameter> searchParameters) {
        Collections.sort(searchParameters, new Comparator<SearchParameter>(){

            @Override
            public int compare(SearchParameter theO1, SearchParameter theO2) {
                if (theO1.isRequired() == theO2.isRequired()) {
                    return theO1.getName().compareTo(theO2.getName());
                }
                if (theO1.isRequired()) {
                    return -1;
                }
                return 1;
            }
        });
    }
}

