/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.hapi.fhirpath;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.fhirpath.FhirPathExecutionException;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.fhirpath.IFhirPathEvaluationContext;
import ca.uhn.fhir.i18n.Msg;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4b.context.IWorkerContext;
import org.hl7.fhir.r4b.fhirpath.ExpressionNode;
import org.hl7.fhir.r4b.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r4b.fhirpath.FHIRPathUtilityClasses;
import org.hl7.fhir.r4b.fhirpath.TypeDetails;
import org.hl7.fhir.r4b.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.IdType;
import org.hl7.fhir.r4b.model.ValueSet;

public class FhirPathR4B
implements IFhirPath {
    private final FHIRPathEngine myEngine;

    public FhirPathR4B(FhirContext theCtx) {
        IValidationSupport validationSupport = theCtx.getValidationSupport();
        this.myEngine = new FHIRPathEngine((IWorkerContext)new HapiWorkerContext(theCtx, validationSupport));
    }

    public <T extends IBase> List<T> evaluate(IBase theInput, String thePath, Class<T> theReturnType) {
        ExpressionNode parsed;
        try {
            parsed = this.myEngine.parse(thePath);
        }
        catch (FHIRException e) {
            throw new FhirPathExecutionException(Msg.code((int)2410) + e);
        }
        return this.evaluate(theInput, parsed, theReturnType);
    }

    public <T extends IBase> List<T> evaluate(IBase theInput, IFhirPath.IParsedExpression theParsedExpression, Class<T> theReturnType) {
        ExpressionNode expressionNode = ((ParsedExpression)theParsedExpression).myParsedExpression;
        return this.evaluate(theInput, expressionNode, theReturnType);
    }

    @Nonnull
    private <T extends IBase> List<Base> evaluate(IBase theInput, ExpressionNode expressionNode, Class<T> theReturnType) {
        List result;
        try {
            result = this.myEngine.evaluate((Base)theInput, expressionNode);
        }
        catch (FHIRException e) {
            throw new FhirPathExecutionException(Msg.code((int)2154) + e);
        }
        for (IBase next : result) {
            if (theReturnType.isAssignableFrom(next.getClass())) continue;
            throw new FhirPathExecutionException(Msg.code((int)2155) + "FhirPath expression returned unexpected type " + next.getClass().getSimpleName() + " - Expected " + theReturnType.getName());
        }
        return result;
    }

    public <T extends IBase> Optional<T> evaluateFirst(IBase theInput, String thePath, Class<T> theReturnType) {
        return this.evaluate(theInput, thePath, theReturnType).stream().findFirst();
    }

    public <T extends IBase> Optional<T> evaluateFirst(IBase theInput, IFhirPath.IParsedExpression theParsedExpression, Class<T> theReturnType) {
        return this.evaluate(theInput, theParsedExpression, theReturnType).stream().findFirst();
    }

    public IFhirPath.IParsedExpression parse(String theExpression) {
        return new ParsedExpression(this.myEngine.parse(theExpression));
    }

    public void setEvaluationContext(final @Nonnull IFhirPathEvaluationContext theEvaluationContext) {
        this.myEngine.setHostServices(new FHIRPathEngine.IEvaluationContext(){

            public List<Base> resolveConstant(FHIRPathEngine engine, Object appContext, String name, boolean beforeContext, boolean explicitConstant) throws PathEngineException {
                return null;
            }

            public TypeDetails resolveConstantType(FHIRPathEngine engine, Object appContext, String name, boolean explicitConstant) throws PathEngineException {
                return null;
            }

            public boolean log(String argument, List<Base> focus) {
                return false;
            }

            public FHIRPathUtilityClasses.FunctionDetails resolveFunction(FHIRPathEngine engine, String functionName) {
                return null;
            }

            public TypeDetails checkFunction(FHIRPathEngine engine, Object appContext, String functionName, TypeDetails focus, List<TypeDetails> parameters) throws PathEngineException {
                return null;
            }

            public List<Base> executeFunction(FHIRPathEngine engine, Object appContext, List<Base> focus, String functionName, List<List<Base>> parameters) {
                return null;
            }

            public Base resolveReference(FHIRPathEngine engine, Object appContext, String url, Base refContext) throws FHIRException {
                return (Base)theEvaluationContext.resolveReference((IIdType)new IdType(url), (IBase)refContext);
            }

            public boolean conformsToProfile(FHIRPathEngine engine, Object appContext, Base item, String url) throws FHIRException {
                return false;
            }

            public ValueSet resolveValueSet(FHIRPathEngine engine, Object appContext, String url) {
                return null;
            }
        });
    }

    private static class ParsedExpression
    implements IFhirPath.IParsedExpression {
        private final ExpressionNode myParsedExpression;

        public ParsedExpression(ExpressionNode theParsedExpression) {
            this.myParsedExpression = theParsedExpression;
        }
    }
}

