/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.hapi.ctx;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.util.CoverageIgnore;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.ParserType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.utils.IResourceValidator;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.TranslationServices;
import org.hl7.fhir.utilities.i18n.I18nBase;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public final class HapiWorkerContext
extends I18nBase
implements IWorkerContext {
    private final FhirContext myCtx;
    private final Cache<String, Resource> myFetchedResourceCache;
    private final IValidationSupport myValidationSupport;
    private Parameters myExpansionProfile;
    private String myOverrideVersionNs;

    public HapiWorkerContext(FhirContext theCtx, IValidationSupport theValidationSupport) {
        Validate.notNull((Object)theCtx, (String)"theCtx must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theValidationSupport, (String)"theValidationSupport must not be null", (Object[])new Object[0]);
        this.myCtx = theCtx;
        this.myValidationSupport = theValidationSupport;
        long timeoutMillis = 10000L;
        if (System.getProperties().containsKey("TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS")) {
            timeoutMillis = Long.parseLong(System.getProperty("TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS"));
        }
        this.myFetchedResourceCache = Caffeine.newBuilder().expireAfterWrite(timeoutMillis, TimeUnit.MILLISECONDS).build();
        this.setValidationMessageLanguage(this.getLocale());
    }

    public List<StructureDefinition> allStructures() {
        return this.myValidationSupport.fetchAllStructureDefinitions();
    }

    public List<StructureDefinition> getStructures() {
        return this.allStructures();
    }

    public CodeSystem fetchCodeSystem(String theSystem) {
        if (this.myValidationSupport == null) {
            return null;
        }
        return (CodeSystem)this.myValidationSupport.fetchCodeSystem(theSystem);
    }

    public List<ConceptMap> findMapsForSource(String theUrl) {
        throw new UnsupportedOperationException();
    }

    public String getAbbreviation(String theName) {
        throw new UnsupportedOperationException();
    }

    public IParser getParser(ParserType theType) {
        throw new UnsupportedOperationException();
    }

    public IParser getParser(String theType) {
        throw new UnsupportedOperationException();
    }

    public List<String> getResourceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ResourceType next : ResourceType.values()) {
            result.add(next.name());
        }
        Collections.sort(result);
        return result;
    }

    public IParser newJsonParser() {
        throw new UnsupportedOperationException();
    }

    public IResourceValidator newValidator() {
        throw new UnsupportedOperationException();
    }

    public IParser newXmlParser() {
        throw new UnsupportedOperationException();
    }

    public String oid2Uri(String theCode) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSystem(String theSystem) {
        if (this.myValidationSupport == null) {
            return false;
        }
        return this.myValidationSupport.isCodeSystemSupported(new ValidationSupportContext(this.myValidationSupport), theSystem);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, CodeableConcept theCode, ValueSet theVs) {
        for (Coding next : theCode.getCoding()) {
            IWorkerContext.ValidationResult retVal = this.validateCode(theOptions, next, theVs);
            if (!retVal.isOk()) continue;
            return retVal;
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, null);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, Coding theCode, ValueSet theVs) {
        String system = theCode.getSystem();
        String code = theCode.getCode();
        String display = theCode.getDisplay();
        return this.validateCode(theOptions, system, code, display, theVs);
    }

    public void validateCodeBatch(ValidationOptions options, List<? extends IWorkerContext.CodingValidationRequest> codes, ValueSet vs) {
        throw new UnsupportedOperationException();
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String theSystem, String theCode, String theDisplay) {
        IValidationSupport.CodeValidationResult result = this.myValidationSupport.validateCode(new ValidationSupportContext(this.myValidationSupport), HapiWorkerContext.convertConceptValidationOptions(theOptions), theSystem, theCode, theDisplay, null);
        if (result == null) {
            return null;
        }
        ValidationMessage.IssueSeverity severity = null;
        if (result.getSeverity() != null) {
            severity = ValidationMessage.IssueSeverity.fromCode((String)result.getSeverityCode());
        }
        CodeSystem.ConceptDefinitionComponent definition = new CodeSystem.ConceptDefinitionComponent().setCode(result.getCode());
        return new IWorkerContext.ValidationResult(severity, result.getMessage(), theSystem, definition);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String theSystem, String theCode, String theDisplay, ValueSet theVs) {
        IValidationSupport.CodeValidationResult outcome = StringUtils.isNotBlank((CharSequence)theVs.getUrl()) ? this.myValidationSupport.validateCode(new ValidationSupportContext(this.myValidationSupport), HapiWorkerContext.convertConceptValidationOptions(theOptions), theSystem, theCode, theDisplay, theVs.getUrl()) : this.myValidationSupport.validateCodeInValueSet(new ValidationSupportContext(this.myValidationSupport), HapiWorkerContext.convertConceptValidationOptions(theOptions), theSystem, theCode, theDisplay, (IBaseResource)theVs);
        if (outcome != null && outcome.isOk()) {
            CodeSystem.ConceptDefinitionComponent definition = new CodeSystem.ConceptDefinitionComponent();
            definition.setCode(theCode);
            definition.setDisplay(outcome.getDisplay());
            return new IWorkerContext.ValidationResult(theSystem, definition);
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Unknown code[" + theCode + "] in system[" + Constants.codeSystemWithDefaultDescription((String)theSystem) + "]");
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String code, ValueSet vs) {
        return this.validateCode(theOptions, null, code, null, vs);
    }

    @CoverageIgnore
    public List<CanonicalResource> allConformanceResources() {
        throw new UnsupportedOperationException();
    }

    public void generateSnapshot(StructureDefinition p) throws FHIRException {
        this.myValidationSupport.generateSnapshot(new ValidationSupportContext(this.myValidationSupport), (IBaseResource)p, "", "", "");
    }

    public void generateSnapshot(StructureDefinition mr, boolean ifLogical) {
    }

    public Parameters getExpansionParameters() {
        return this.myExpansionProfile;
    }

    public void setExpansionProfile(Parameters theExpParameters) {
        this.myExpansionProfile = theExpParameters;
    }

    @CoverageIgnore
    public boolean hasCache() {
        throw new UnsupportedOperationException();
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet theSource, boolean theCacheOk, boolean theHierarchical) {
        throw new UnsupportedOperationException();
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet.ConceptSetComponent theInc, boolean theHierarchical) throws TerminologyServiceException {
        ValueSet input = new ValueSet();
        input.getCompose().addInclude(theInc);
        IValidationSupport.ValueSetExpansionOutcome output = this.myValidationSupport.expandValueSet(new ValidationSupportContext(this.myValidationSupport), null, (IBaseResource)input);
        return new ValueSetExpander.ValueSetExpansionOutcome((ValueSet)output.getValueSet(), output.getError(), null);
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public void setLocale(Locale locale) {
    }

    public IWorkerContext.ILoggingService getLogger() {
        throw new UnsupportedOperationException();
    }

    public void setLogger(IWorkerContext.ILoggingService theLogger) {
        throw new UnsupportedOperationException();
    }

    public String getVersion() {
        return this.myCtx.getVersion().getVersion().getFhirVersionString();
    }

    public String getSpecUrl() {
        throw new UnsupportedOperationException();
    }

    public UcumService getUcumService() {
        throw new UnsupportedOperationException();
    }

    public void setUcumService(UcumService ucumService) {
        throw new UnsupportedOperationException();
    }

    public boolean isNoTerminologyServer() {
        return false;
    }

    public Set<String> getCodeSystemsUsed() {
        throw new UnsupportedOperationException();
    }

    public TranslationServices translator() {
        throw new UnsupportedOperationException();
    }

    public List<StructureMap> listTransforms() {
        throw new UnsupportedOperationException();
    }

    public StructureMap getTransform(String url) {
        throw new UnsupportedOperationException();
    }

    public String getOverrideVersionNs() {
        return this.myOverrideVersionNs;
    }

    public void setOverrideVersionNs(String value) {
        this.myOverrideVersionNs = value;
    }

    public StructureDefinition fetchTypeDefinition(String typeName) {
        return this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + typeName);
    }

    public StructureDefinition fetchRawProfile(String url) {
        throw new UnsupportedOperationException();
    }

    public List<String> getTypeNames() {
        throw new UnsupportedOperationException();
    }

    public <T extends Resource> T fetchResource(Class<T> theClass, String theUri) {
        if (this.myValidationSupport == null || theUri == null) {
            return null;
        }
        Resource retVal = (Resource)this.myFetchedResourceCache.get((Object)theUri, t -> (Resource)this.myValidationSupport.fetchResource(theClass, theUri));
        return (T)retVal;
    }

    public <T extends Resource> T fetchResourceWithException(Class<T> theClass, String theUri) throws FHIRException {
        T retVal = this.fetchResource(theClass, theUri);
        if (retVal == null) {
            throw new FHIRException("Could not find resource: " + theUri);
        }
        return retVal;
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri, CanonicalResource canonicalForSource) {
        throw new UnsupportedOperationException();
    }

    public Resource fetchResourceById(String theType, String theUri) {
        throw new UnsupportedOperationException();
    }

    public <T extends Resource> boolean hasResource(Class<T> theClass_, String theUri) {
        throw new UnsupportedOperationException();
    }

    public void cacheResource(Resource theRes) throws FHIRException {
        throw new UnsupportedOperationException();
    }

    public void cacheResourceFromPackage(Resource res, IWorkerContext.PackageVersion packageDetails) throws FHIRException {
        throw new UnsupportedOperationException();
    }

    public void cachePackage(IWorkerContext.PackageDetails packageDetails, List<IWorkerContext.PackageVersion> list) {
    }

    public Set<String> getResourceNamesAsSet() {
        return this.myCtx.getResourceTypes();
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ElementDefinition.ElementDefinitionBindingComponent theBinding, boolean theCacheOk, boolean theHierarchical) throws FHIRException {
        throw new UnsupportedOperationException();
    }

    public String getLinkForUrl(String corePath, String url) {
        throw new UnsupportedOperationException();
    }

    public Map<String, byte[]> getBinaries() {
        throw new UnsupportedOperationException();
    }

    public int loadFromPackage(NpmPackage pi, IWorkerContext.IContextResourceLoader loader) throws FHIRException {
        throw new UnsupportedOperationException();
    }

    public int loadFromPackage(NpmPackage pi, IWorkerContext.IContextResourceLoader loader, String[] types) throws FHIRException {
        throw new UnsupportedOperationException();
    }

    public int loadFromPackageAndDependencies(NpmPackage pi, IWorkerContext.IContextResourceLoader loader, BasePackageCacheManager pcm) throws FHIRException {
        throw new UnsupportedOperationException();
    }

    public boolean hasPackage(String id, String ver) {
        throw new UnsupportedOperationException();
    }

    public boolean hasPackage(IWorkerContext.PackageVersion packageVersion) {
        return false;
    }

    public IWorkerContext.PackageDetails getPackage(IWorkerContext.PackageVersion packageVersion) {
        return null;
    }

    public int getClientRetryCount() {
        throw new UnsupportedOperationException();
    }

    public IWorkerContext setClientRetryCount(int value) {
        throw new UnsupportedOperationException();
    }

    public TimeTracker clock() {
        return null;
    }

    public IWorkerContext.PackageVersion getPackageForUrl(String s) {
        return null;
    }

    public static ConceptValidationOptions convertConceptValidationOptions(ValidationOptions theOptions) {
        ConceptValidationOptions retVal = new ConceptValidationOptions();
        if (theOptions.isGuessSystem()) {
            retVal = retVal.setInferSystem(true);
        }
        return retVal;
    }
}

