/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.hapi.ctx;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.sl.cache.Cache;
import ca.uhn.fhir.sl.cache.CacheFactory;
import ca.uhn.fhir.system.HapiSystemProperties;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.context.IContextResourceLoader;
import org.hl7.fhir.r5.context.ILoggingService;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.IWorkerContextManager;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.profilemodel.PEBuilder;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.terminologies.utilities.CodingValidationRequest;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.ValidationContextCarrier;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.i18n.I18nBase;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public final class HapiWorkerContext
extends I18nBase
implements IWorkerContext {
    private final FhirContext myCtx;
    private final Cache<String, Resource> myFetchedResourceCache;
    private final IValidationSupport myValidationSupport;
    private Parameters myExpansionProfile;
    private String myOverrideVersionNs;

    public HapiWorkerContext(FhirContext theCtx, IValidationSupport theValidationSupport) {
        Validate.notNull((Object)theCtx, (String)"theCtx must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theValidationSupport, (String)"theValidationSupport must not be null", (Object[])new Object[0]);
        this.myCtx = theCtx;
        this.myValidationSupport = theValidationSupport;
        long timeoutMillis = HapiSystemProperties.getValidationResourceCacheTimeoutMillis();
        this.myFetchedResourceCache = CacheFactory.build((long)timeoutMillis);
        this.setValidationMessageLanguage(this.getLocale());
    }

    public CodeSystem fetchCodeSystem(String theSystem) {
        if (this.myValidationSupport == null) {
            return null;
        }
        return (CodeSystem)this.myValidationSupport.fetchCodeSystem(theSystem);
    }

    public CodeSystem fetchCodeSystem(String theSystem, String version) {
        if (this.myValidationSupport == null) {
            return null;
        }
        return (CodeSystem)this.myValidationSupport.fetchCodeSystem(theSystem);
    }

    public CodeSystem fetchCodeSystem(String system, FhirPublication fhirVersion) {
        throw new UnsupportedOperationException(Msg.code((int)2456));
    }

    public CodeSystem fetchCodeSystem(String system, String version, FhirPublication fhirVersion) {
        throw new UnsupportedOperationException(Msg.code((int)2457));
    }

    public CodeSystem fetchSupplementedCodeSystem(String theS) {
        return null;
    }

    public CodeSystem fetchSupplementedCodeSystem(String theS, String theS1) {
        return null;
    }

    public CodeSystem fetchSupplementedCodeSystem(String system, FhirPublication fhirVersion) {
        throw new UnsupportedOperationException(Msg.code((int)2458));
    }

    public CodeSystem fetchSupplementedCodeSystem(String system, String version, FhirPublication fhirVersion) {
        throw new UnsupportedOperationException(Msg.code((int)2459));
    }

    public List<String> getResourceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ResourceType next : ResourceType.values()) {
            result.add(next.name());
        }
        Collections.sort(result);
        return result;
    }

    public List<String> getResourceNames(FhirPublication fhirVersion) {
        throw new UnsupportedOperationException(Msg.code((int)2460));
    }

    public IResourceValidator newValidator() {
        throw new UnsupportedOperationException(Msg.code((int)206));
    }

    public Map<String, NamingSystem> getNSUrlMap() {
        throw new UnsupportedOperationException(Msg.code((int)2241));
    }

    public boolean supportsSystem(String theSystem) {
        if (this.myValidationSupport == null) {
            return false;
        }
        return this.myValidationSupport.isCodeSystemSupported(new ValidationSupportContext(this.myValidationSupport), theSystem);
    }

    public boolean supportsSystem(String system, FhirPublication fhirVersion) throws TerminologyServiceException {
        if (!fhirVersion.equals((Object)FhirPublication.R5)) {
            throw new UnsupportedOperationException(Msg.code((int)2461));
        }
        return this.supportsSystem(system);
    }

    public ValidationResult validateCode(ValidationOptions theOptions, CodeableConcept theCode, ValueSet theVs) {
        for (Coding next : theCode.getCoding()) {
            ValidationResult retVal = this.validateCode(theOptions, next, theVs);
            if (!retVal.isOk()) continue;
            return retVal;
        }
        return new ValidationResult(ValidationMessage.IssueSeverity.ERROR, null, null);
    }

    public ValidationResult validateCode(ValidationOptions theOptions, Coding theCode, ValueSet theVs) {
        String system = theCode.getSystem();
        String code = theCode.getCode();
        String display = theCode.getDisplay();
        return this.validateCode(theOptions, system, null, code, display, theVs);
    }

    public ValidationResult validateCode(ValidationOptions options, Coding code, ValueSet vs, ValidationContextCarrier ctxt) {
        return this.validateCode(options, code, vs);
    }

    public void validateCodeBatch(ValidationOptions options, List<? extends CodingValidationRequest> codes, ValueSet vs) {
        throw new UnsupportedOperationException(Msg.code((int)209));
    }

    public void validateCodeBatchByRef(ValidationOptions validationOptions, List<? extends CodingValidationRequest> list, String s) {
        throw new UnsupportedOperationException(Msg.code((int)2430));
    }

    public ValueSetExpansionOutcome expandVS(ValueSet theValueSet, boolean cacheOk, boolean heiarchical, boolean incompleteOk) {
        return null;
    }

    public ValueSetExpansionOutcome expandVS(String s, boolean b, boolean b1, int i) {
        return null;
    }

    public ValidationResult validateCode(ValidationOptions theOptions, String theSystem, String theVersion, String theCode, String theDisplay) {
        IValidationSupport.CodeValidationResult result = this.myValidationSupport.validateCode(new ValidationSupportContext(this.myValidationSupport), HapiWorkerContext.convertConceptValidationOptions(theOptions), theSystem, theCode, theDisplay, null);
        if (result == null) {
            return null;
        }
        ValidationMessage.IssueSeverity severity = null;
        if (result.getSeverity() != null) {
            severity = ValidationMessage.IssueSeverity.fromCode((String)result.getSeverityCode());
        }
        CodeSystem.ConceptDefinitionComponent definition = new CodeSystem.ConceptDefinitionComponent().setCode(result.getCode());
        return new ValidationResult(severity, result.getMessage(), theSystem, theVersion, definition, null, null);
    }

    public ValidationResult validateCode(ValidationOptions theOptions, String theSystem, String theVersion, String theCode, String theDisplay, ValueSet theVs) {
        IValidationSupport.CodeValidationResult outcome = StringUtils.isNotBlank((CharSequence)theVs.getUrl()) ? this.myValidationSupport.validateCode(new ValidationSupportContext(this.myValidationSupport), HapiWorkerContext.convertConceptValidationOptions(theOptions), theSystem, theCode, theDisplay, theVs.getUrl()) : this.myValidationSupport.validateCodeInValueSet(new ValidationSupportContext(this.myValidationSupport), HapiWorkerContext.convertConceptValidationOptions(theOptions), theSystem, theCode, theDisplay, (IBaseResource)theVs);
        if (outcome != null && outcome.isOk()) {
            CodeSystem.ConceptDefinitionComponent definition = new CodeSystem.ConceptDefinitionComponent();
            definition.setCode(theCode);
            definition.setDisplay(outcome.getDisplay());
            return new ValidationResult(theSystem, theVersion, definition, null);
        }
        return new ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Unknown code[" + theCode + "] in system[" + Constants.codeSystemWithDefaultDescription((String)theSystem) + "]", null);
    }

    public ValidationResult validateCode(ValidationOptions theOptions, String code, ValueSet vs) {
        return this.validateCode(theOptions, null, null, code, null, vs);
    }

    public Parameters getExpansionParameters() {
        return this.myExpansionProfile;
    }

    public void setExpansionParameters(Parameters expParameters) {
        this.setExpansionProfile(expParameters);
    }

    public void setExpansionProfile(Parameters theExpParameters) {
        this.myExpansionProfile = theExpParameters;
    }

    public ValueSetExpansionOutcome expandVS(ValueSet theSource, boolean theCacheOk, boolean theHierarchical) {
        throw new UnsupportedOperationException(Msg.code((int)2128));
    }

    public ValueSetExpansionOutcome expandVS(ValueSet theSource, boolean theCacheOk, boolean theHierarchical, int i) {
        throw new UnsupportedOperationException(Msg.code((int)2128));
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public void setLocale(Locale locale) {
    }

    public ILoggingService getLogger() {
        throw new UnsupportedOperationException(Msg.code((int)213));
    }

    public void setLogger(ILoggingService theLogger) {
        throw new UnsupportedOperationException(Msg.code((int)214));
    }

    public String getVersion() {
        return this.myCtx.getVersion().getVersion().getFhirVersionString();
    }

    public UcumService getUcumService() {
        throw new UnsupportedOperationException(Msg.code((int)216));
    }

    public void setUcumService(UcumService ucumService) {
        throw new UnsupportedOperationException(Msg.code((int)217));
    }

    public boolean isNoTerminologyServer() {
        return false;
    }

    public Set<String> getCodeSystemsUsed() {
        throw new UnsupportedOperationException(Msg.code((int)218));
    }

    public StructureDefinition fetchTypeDefinition(String typeName) {
        return this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + typeName);
    }

    public boolean isPrimitiveType(String s) {
        throw new UnsupportedOperationException(Msg.code((int)2462));
    }

    public boolean isDataType(String s) {
        throw new UnsupportedOperationException(Msg.code((int)2463));
    }

    public StructureDefinition fetchTypeDefinition(String typeName, FhirPublication fhirVersion) {
        throw new UnsupportedOperationException(Msg.code((int)2464));
    }

    public List<StructureDefinition> fetchTypeDefinitions(String n) {
        throw new UnsupportedOperationException(Msg.code((int)234));
    }

    public List<StructureDefinition> fetchTypeDefinitions(String n, FhirPublication fhirPublication) {
        throw new UnsupportedOperationException(Msg.code((int)2465));
    }

    public <T extends Resource> T fetchResourceRaw(Class<T> class_, String uri) {
        return this.fetchResource(class_, uri);
    }

    public <T extends Resource> T fetchResource(Class<T> theClass, String theUri) {
        if (this.myValidationSupport == null || theUri == null) {
            return null;
        }
        Resource retVal = (Resource)this.myFetchedResourceCache.get((Object)theUri, t -> (Resource)this.myValidationSupport.fetchResource(theClass, theUri));
        return (T)retVal;
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri, FhirPublication fhirVersion) {
        throw new UnsupportedOperationException(Msg.code((int)2466));
    }

    public <T extends Resource> T fetchResourceWithException(Class<T> theClass, String theUri) throws FHIRException {
        T retVal = this.fetchResource(theClass, theUri);
        if (retVal == null) {
            throw new FHIRException(Msg.code((int)224) + "Could not find resource: " + theUri);
        }
        return retVal;
    }

    public <T extends Resource> T fetchResourceWithException(Class<T> theClass, String uri, Resource sourceOfReference) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)2213));
    }

    public <T extends Resource> T fetchResource(Class<T> theClass, String theUri, String theVersion) {
        return this.fetchResource(theClass, theUri + "|" + theVersion);
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri, String version, FhirPublication fhirVersion) {
        throw new UnsupportedOperationException(Msg.code((int)2467));
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri, Resource canonicalForSource) {
        return this.fetchResource(class_, uri);
    }

    public <T extends Resource> List<T> fetchResourcesByType(Class<T> class_, FhirPublication fhirVersion) {
        throw new UnsupportedOperationException(Msg.code((int)2468));
    }

    public Resource fetchResourceById(String theType, String theUri) {
        throw new UnsupportedOperationException(Msg.code((int)226));
    }

    public Resource fetchResourceById(String type, String uri, FhirPublication fhirVersion) {
        throw new UnsupportedOperationException(Msg.code((int)2469));
    }

    public <T extends Resource> boolean hasResource(Class<T> theClass_, String theUri) {
        throw new UnsupportedOperationException(Msg.code((int)227));
    }

    public <T extends Resource> boolean hasResource(Class<T> class_, String uri, Resource sourceOfReference) {
        throw new UnsupportedOperationException(Msg.code((int)2470));
    }

    public <T extends Resource> boolean hasResource(Class<T> class_, String uri, FhirPublication fhirVersion) {
        throw new UnsupportedOperationException(Msg.code((int)2471));
    }

    public void cacheResource(Resource theRes) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)228));
    }

    public void cacheResourceFromPackage(Resource res, PackageInformation packageDetails) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)229));
    }

    public void cachePackage(PackageInformation packageInformation) {
    }

    public Set<String> getResourceNamesAsSet() {
        return this.myCtx.getResourceTypes();
    }

    public Set<String> getResourceNamesAsSet(FhirPublication fhirVersion) {
        throw new UnsupportedOperationException(Msg.code((int)2472));
    }

    public ValueSetExpansionOutcome expandVS(Resource src, ElementDefinition.ElementDefinitionBindingComponent theBinding, boolean theCacheOk, boolean theHierarchical) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)230));
    }

    public ValueSetExpansionOutcome expandVS(IWorkerContext.ITerminologyOperationDetails iTerminologyOperationDetails, ValueSet.ConceptSetComponent conceptSetComponent, boolean b, boolean b1) throws TerminologyServiceException {
        return null;
    }

    public Set<String> getBinaryKeysAsSet() {
        throw new UnsupportedOperationException(Msg.code((int)2115));
    }

    public boolean hasBinaryKey(String s) {
        throw new UnsupportedOperationException(Msg.code((int)2129));
    }

    public byte[] getBinaryForKey(String s) {
        throw new UnsupportedOperationException(Msg.code((int)2199));
    }

    public int loadFromPackage(NpmPackage pi, IContextResourceLoader loader) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)233));
    }

    public int loadFromPackage(NpmPackage pi, IContextResourceLoader loader, List<String> types) throws FileNotFoundException, IOException, FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)2328));
    }

    public int loadFromPackageAndDependencies(NpmPackage pi, IContextResourceLoader loader, BasePackageCacheManager pcm) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)235));
    }

    public boolean hasPackage(String id, String ver) {
        throw new UnsupportedOperationException(Msg.code((int)236));
    }

    public boolean hasPackage(PackageInformation packageVersion) {
        return false;
    }

    public PackageInformation getPackage(String id, String ver) {
        return null;
    }

    public int getClientRetryCount() {
        throw new UnsupportedOperationException(Msg.code((int)237));
    }

    public IWorkerContext setClientRetryCount(int value) {
        throw new UnsupportedOperationException(Msg.code((int)238));
    }

    public TimeTracker clock() {
        return null;
    }

    public IWorkerContextManager.IPackageLoadingTracker getPackageTracker() {
        throw new UnsupportedOperationException(Msg.code((int)2112));
    }

    public PackageInformation getPackageForUrl(String s) {
        return null;
    }

    public static ConceptValidationOptions convertConceptValidationOptions(ValidationOptions theOptions) {
        ConceptValidationOptions retVal = new ConceptValidationOptions();
        if (theOptions.isGuessSystem()) {
            retVal = retVal.setInferSystem(true);
        }
        return retVal;
    }

    public <T extends Resource> List<T> fetchResourcesByType(Class<T> theClass) {
        if (theClass.equals(StructureDefinition.class)) {
            return this.myValidationSupport.fetchAllStructureDefinitions();
        }
        throw new UnsupportedOperationException(Msg.code((int)2113) + "Can't fetch all resources of type: " + String.valueOf(theClass));
    }

    public <T extends Resource> List<T> fetchResourcesByUrl(Class<T> class_, String url) {
        throw new UnsupportedOperationException(Msg.code((int)2508) + "Can't fetch all resources of url: " + url);
    }

    public IWorkerContext setPackageTracker(IWorkerContextManager.IPackageLoadingTracker theIPackageLoadingTracker) {
        throw new UnsupportedOperationException(Msg.code((int)220));
    }

    public String getSpecUrl() {
        return "";
    }

    public PEBuilder getProfiledElementBuilder(PEBuilder.PEElementPropertiesPolicy thePEElementPropertiesPolicy, boolean theB) {
        throw new UnsupportedOperationException(Msg.code((int)2261));
    }

    public boolean isForPublication() {
        return false;
    }

    public void setForPublication(boolean b) {
        throw new UnsupportedOperationException(Msg.code((int)2350));
    }

    public IWorkerContext.OIDSummary urlsForOid(String oid, String resourceType) {
        throw new UnsupportedOperationException(Msg.code((int)2473));
    }

    public <T extends Resource> T findTxResource(Class<T> class_, String canonical, Resource sourceOfReference) {
        throw new UnsupportedOperationException(Msg.code((int)2491));
    }

    public <T extends Resource> T findTxResource(Class<T> class_, String canonical) {
        throw new UnsupportedOperationException(Msg.code((int)2492));
    }

    public <T extends Resource> T findTxResource(Class<T> class_, String canonical, String version) {
        throw new UnsupportedOperationException(Msg.code((int)2493));
    }

    public Boolean subsumes(ValidationOptions optionsArg, Coding parent, Coding child) {
        throw new UnsupportedOperationException(Msg.code((int)2488));
    }

    public boolean isServerSideSystem(String url) {
        return false;
    }
}

