package ca.uhn.fhir.test.utilities.server;

/*-
 * #%L
 * HAPI FHIR Test Utilities
 * %%
 * Copyright (C) 2014 - 2022 Smile CDR, Inc.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import org.apache.commons.lang3.Validate;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ResourceProviderExtension<T> implements BeforeEachCallback, AfterEachCallback {

	private final RestfulServerExtension myRestfulServerExtension;
	private final T myProvider;

	/**
	 * Constructor
	 */
	public ResourceProviderExtension(RestfulServerExtension theRestfulServerExtension, T theProvider) {
		Validate.notNull(theRestfulServerExtension);
		Validate.notNull(theProvider);
		myRestfulServerExtension = theRestfulServerExtension;
		myProvider = theProvider;
	}

	@Override
	public void afterEach(ExtensionContext context) {
		myRestfulServerExtension.getRestfulServer().unregisterProvider(myProvider);
	}

	@Override
	public void beforeEach(ExtensionContext context) {
		myRestfulServerExtension.getRestfulServer().registerProvider(myProvider);
	}

	public T getProvider() {
		return myProvider;
	}

}
