/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.conformance;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.params.provider.Arguments;

public class DateSearchTestCase {
    final String myResourceValue;
    final String myQueryValue;
    final boolean expectedResult;
    final String myFileName;
    final int myLineNumber;
    public static final List<DateSearchTestCase> ourCases = new ArrayList<DateSearchTestCase>();

    public DateSearchTestCase(String myResourceValue, String myQueryValue, boolean expectedResult, String theFileName, int theLineNumber) {
        this.myResourceValue = myResourceValue;
        this.myQueryValue = myQueryValue;
        this.expectedResult = expectedResult;
        this.myFileName = theFileName;
        this.myLineNumber = theLineNumber;
    }

    public Arguments toArguments() {
        return Arguments.of((Object[])new Object[]{this.myResourceValue, this.myQueryValue, this.expectedResult, this.myFileName, this.myLineNumber});
    }

    private static List<DateSearchTestCase> expandedCases() {
        String csv = "DateSearchTestCase.csv";
        InputStream resource = DateSearchTestCase.class.getResourceAsStream(csv);
        assert (resource != null);
        InputStreamReader inputStreamReader = new InputStreamReader(resource, StandardCharsets.UTF_8);
        List<DateSearchTestCase> cases = DateSearchTestCase.parseCsvCases(inputStreamReader, csv);
        try {
            resource.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return cases;
    }

    static List<DateSearchTestCase> parseCsvCases(Reader theSource, String theFileName) {
        LineNumberReader lineNumberReader = new LineNumberReader(theSource);
        return lineNumberReader.lines().filter(l -> !l.startsWith("#")).map(l -> l.split(",")).map(fields -> new DateSearchTestCase(fields[0].trim(), fields[1].trim(), Boolean.parseBoolean(fields[2].trim()), theFileName, lineNumberReader.getLineNumber())).collect(Collectors.toList());
    }

    public static List<DateSearchTestCase> compactCases() {
        String compactCsv = "DateSearchTestCase-compact.csv";
        InputStream compactStream = DateSearchTestCase.class.getResourceAsStream(compactCsv);
        assert (compactStream != null);
        return DateSearchTestCase.expandPrefixCases(new InputStreamReader(compactStream, StandardCharsets.UTF_8), compactCsv);
    }

    @Nonnull
    static List<DateSearchTestCase> expandPrefixCases(Reader theSource, String theFileName) {
        Set<String> supportedPrefixes = Set.of(new String[]{"eq", "ge", "gt", "le", "lt", "ne"});
        LineNumberReader lineNumberReader = new LineNumberReader(theSource);
        return lineNumberReader.lines().filter(l -> !l.startsWith("#")).map(l -> l.split(",")).flatMap(fields -> {
            String resourceValue = fields[0].trim();
            String truePrefixes = fields[1].trim();
            String queryValue = fields[2].trim();
            Set expectedTruePrefixes = Arrays.stream(truePrefixes.split("\\s+")).map(String::trim).collect(Collectors.toSet());
            return supportedPrefixes.stream().map(prefix -> {
                boolean expectMatch = expectedTruePrefixes.contains(prefix);
                return new DateSearchTestCase(resourceValue, prefix + queryValue, expectMatch, theFileName, lineNumberReader.getLineNumber());
            });
        }).collect(Collectors.toList());
    }

    static {
        ourCases.addAll(DateSearchTestCase.expandedCases());
        ourCases.addAll(DateSearchTestCase.compactCases());
    }
}

