/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.parser.ErrorHandlerAdapter;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractParserErrorHandlerTest {
    protected abstract IParser createParser();

    protected abstract String createResourceWithRepeatingChoice();

    @Test
    public void testRepeatingChoiceHandled() {
        ErrorHandlerAdapter errorHandler = new ErrorHandlerAdapter(){

            public void unexpectedRepeatingElement(IParserErrorHandler.IParseLocation theLocation, String theElementName) {
                class RepeatingChoiceHandledException
                extends RuntimeException {
                    RepeatingChoiceHandledException() {
                    }
                }
                throw new RepeatingChoiceHandledException();
            }
        };
        IParser parser = this.createParser();
        parser.setParserErrorHandler((IParserErrorHandler)errorHandler);
        String resourceStr = this.createResourceWithRepeatingChoice();
        AssertionsForClassTypes.assertThatExceptionOfType(RepeatingChoiceHandledException.class).isThrownBy(() -> parser.parseResource(resourceStr));
    }
}

