/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.subscription;

import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UnsignedIntType;

public class SubscriptionTestDataHelper {
    public static final String TEST_TOPIC = "http://test.topic";
    public static final String TEST_FILTER1 = "Encounter?patient=Patient/123";
    public static final String TEST_FILTER2 = "Encounter?status=finished";
    public static final String TEST_ENDPOINT = "http://rest.endpoint/path";
    public static final String TEST_HEADER1 = "X-Foo: FOO";
    public static final String TEST_HEADER2 = "X-Bar: BAR";

    public static Subscription buildR4TopicSubscription() {
        return SubscriptionTestDataHelper.buildR4TopicSubscriptionWithContent("full-resource");
    }

    public static Subscription buildR4TopicSubscriptionWithContent(String theChannelPayloadContent) {
        Subscription subscription = new Subscription();
        subscription.getMeta().addTag("http://a", "b", "c");
        subscription.getMeta().addTag("http://d", "e", "f");
        subscription.setId("testId");
        subscription.getChannel().setType(Subscription.SubscriptionChannelType.RESTHOOK);
        subscription.getChannel().setEndpoint(TEST_ENDPOINT);
        subscription.getChannel().setPayload("application/fhir+json");
        subscription.getChannel().addHeader(TEST_HEADER1);
        subscription.getChannel().addHeader(TEST_HEADER2);
        subscription.setStatus(Subscription.SubscriptionStatus.ACTIVE);
        subscription.getMeta().addProfile("http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-subscription");
        subscription.setCriteria(TEST_TOPIC);
        subscription.getCriteriaElement().addExtension("http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-filter-criteria", (Type)new StringType(TEST_FILTER1));
        subscription.getCriteriaElement().addExtension("http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-filter-criteria", (Type)new StringType(TEST_FILTER2));
        subscription.getChannel().addExtension("http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-heartbeat-period", (Type)new UnsignedIntType(86400));
        subscription.getChannel().addExtension("http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-timeout", (Type)new UnsignedIntType(60));
        subscription.getChannel().addExtension("http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-max-count", (Type)new PositiveIntType(20));
        subscription.getChannel().getPayloadElement().addExtension("http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-payload-content", (Type)new CodeType(theChannelPayloadContent));
        return subscription;
    }
}

